/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.userconfig.GridConfigDAO;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.extdata.ExtDataQueryFactory;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;

public class ExtendDataRptListDataPlugin
extends AbstractReportListDataPlugin {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ExtendDataRptListDataPlugin.class);
    public static final String MODEL = "model";
    public static final String MUL_ENTITY = "mulentity";
    public static final String MUL_SCENARIO = "mulscenario";
    public static final String MUL_YEAR = "mulyear";
    public static final String MUL_PERIOD = "mulperiod";
    public static final String MUL_CURRENCY = "mulcurrency";
    public static final String PROCESS_F7 = "process";
    public static final String AUDITTRAIL_F7 = "audittrail";
    public static final String FIX = "_fix";
    private static final List<String> DIM_KEYS = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Scenario.getSign(), SysDimensionEnum.Year.getSign(), SysDimensionEnum.Period.getSign(), SysDimensionEnum.Currency.getSign()});

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        Map customParam = reportQueryParam.getCustomParam();
        List qFilters = reportQueryParam.getFilter().getQFilters();
        QFilter commonFilter = null;
        if (qFilters.size() > 0) {
            commonFilter = (QFilter)qFilters.get(0);
        }
        String modelNumber = ((DynamicObject)customParam.get(MODEL)).getString("shownumber");
        long modelId = ((DynamicObject)customParam.get(MODEL)).getLong("id");
        ArrayList<String> entities = new ArrayList<String>(10);
        HashMap<String, List<Long>> entityNumMap = new HashMap<String, List<Long>>(16);
        Map dim2Mems = (Map)customParam.get("dim2Mems");
        ((Map)dim2Mems.get(MUL_ENTITY)).forEach((k, v) -> {
            entities.add(String.valueOf(k));
            List ids = entityNumMap.computeIfAbsent((String)v, value -> new ArrayList(10));
            ids.add(k);
        });
        List scenarios = (List)dim2Mems.get(MUL_SCENARIO);
        List years = (List)dim2Mems.get(MUL_YEAR);
        List periods = (List)dim2Mems.get(MUL_PERIOD);
        List currencies = (List)dim2Mems.get(MUL_CURRENCY);
        String processNumber = (String)dim2Mems.get(PROCESS_F7);
        String auditNumber = (String)dim2Mems.get(AUDITTRAIL_F7);
        EdQueryComInfo edQueryComInfo = this.buildQueryCommand(modelId, modelNumber, entities, processNumber, scenarios, years, periods, currencies, auditNumber, entityNumMap);
        if (entities.isEmpty() || edQueryComInfo.getDimselects() == null && edQueryComInfo.getExtselects() == null) {
            String extendEntity = ExtendDimGroupType.COMMON.getIndex().equals(edQueryComInfo.getGrouptype()) ? "bcm_extenddata" : "bcm_extenddata_bus";
            return QueryServiceHelper.queryDataSet((String)"bcm_ext", (String)extendEntity, (String)"id", (QFilter[])new QFilter("1", "!=", (Object)1).toArray(), null);
        }
        if (commonFilter != null) {
            edQueryComInfo.setCustomFilter(commonFilter);
        }
        edQueryComInfo.setMultiOrg(true);
        try (DataSet rows = ExtDataQueryFactory.getQueryService((EdQueryComInfo)edQueryComInfo).queryNewDataSet(edQueryComInfo);){
            DataSet res = rows.copy();
            RowMeta rowMeta = res.getRowMeta();
            ThreadCache.remove((Object)"amount");
            if (rowMeta.getFields().length > 0 && !res.isEmpty()) {
                int count = 0;
                for (Row re : res) {
                    ++count;
                }
                ThreadCache.put((Object)"amount", (Object)count);
            } else {
                ThreadCache.put((Object)"amount", (Object)0);
            }
            StringJoiner stringJoiner = new StringJoiner(",");
            for (Field field : rowMeta.getFields()) {
                if (field.getAlias().equals("entity")) {
                    stringJoiner.add("entity src_entity");
                    continue;
                }
                if (field.getAlias().equals("org")) {
                    stringJoiner.add("org");
                    continue;
                }
                if (DIM_KEYS.contains(field.getAlias())) {
                    stringJoiner.add(field.getAlias() + " " + field.getAlias() + FIX);
                    continue;
                }
                stringJoiner.add(field.getAlias());
            }
            DataSet dataSet = rows.select(stringJoiner.toString());
            return dataSet;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ExtendDataRptListDataPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private EdQueryComInfo buildQueryCommand(long modelId, String modelShowNum, List<String> entities, String processNumber, List<String> scenarios, List<String> years, List<String> periods, List<String> currencies, String auditNumber, Map<String, List<Long>> entityNumMap) {
        ExtendsModel extendsModel = (ExtendsModel)this.getQueryParam().getCustomParam().get("extendsModel");
        EdQueryComInfo queryComInfo = new EdQueryComInfo(modelShowNum, extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
        queryComInfo.addDimFilter(DimTypesEnum.ENTITY.getNumber(), (String[])entities.stream().map(ent -> MemberReader.findEntityMemberById((Long)modelId, (Long)LongUtil.toLong((Object)ent)).getNumber()).toArray(String[]::new));
        queryComInfo.addDimFilter(DimTypesEnum.SCENARIO.getNumber(), scenarios.toArray(new String[0]));
        queryComInfo.addDimFilter(DimTypesEnum.YEAR.getNumber(), years.toArray(new String[0]));
        queryComInfo.addDimFilter(DimTypesEnum.PERIOD.getNumber(), periods.toArray(new String[0]));
        queryComInfo.addDimFilter(DimTypesEnum.PROCESS.getNumber(), new String[]{processNumber});
        queryComInfo.addDimFilter(DimTypesEnum.CURRENCY.getNumber(), currencies.toArray(new String[0]));
        queryComInfo.addDimFilter(DimTypesEnum.AUDITTRIAL.getNumber(), new String[]{auditNumber});
        queryComInfo.setMulOrgNumMap(entityNumMap);
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        List gridConfigs = gridConfigDAO.getGridConfig("bcm_dataqueryanalytics", "reportlistap");
        HashSet<String> hideFields = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)gridConfigs)) {
            for (GridConfigurationRow gridConfig : gridConfigs) {
                String fieldKey = gridConfig.getFieldKey();
                boolean hide = gridConfig.isHide();
                if (!hide) continue;
                hideFields.add(fieldKey);
            }
        }
        if (!hideFields.isEmpty()) {
            queryComInfo.setNeedSum(true);
        }
        HashMap fieldToColumn = new HashMap(8);
        extendsModel.getExtFieldEntry().stream().forEach(ext -> fieldToColumn.put(ext.getExtField().getNumber(), ext.getExtField().getMapped()));
        if (!fieldToColumn.isEmpty()) {
            ArrayList extList = new ArrayList(fieldToColumn.keySet());
            if (!hideFields.isEmpty()) {
                extList.removeIf(ext -> hideFields.contains(fieldToColumn.get(ext)));
            }
            if (!extList.isEmpty()) {
                queryComInfo.setExtselects(extList.toArray(new String[0]));
            }
        }
        List<String> dimList = extendsModel.getDimFieldEntry().stream().map(ext -> ext.getDimension().getNumber()).collect(Collectors.toList());
        for (String dimKey : DIM_KEYS) {
            SysDimensionEnum dimEnum;
            if (hideFields.contains(dimKey + FIX) || (dimEnum = SysDimensionEnum.getEnumByLowerCaseNumber((String)dimKey)) == null) continue;
            dimList.add(dimEnum.getNumber());
        }
        if (!hideFields.contains("org")) {
            dimList.add("org");
        }
        if (!hideFields.contains("src_entity")) {
            dimList.add(DimTypesEnum.ENTITY.getNumber());
        }
        if (CollectionUtils.isNotEmpty(dimList)) {
            Map<String, String> dimFieldMapped = this.getDimFieldMapped();
            dimList.removeIf(dim -> hideFields.contains(dimFieldMapped.get(dim)));
            if (!dimList.isEmpty()) {
                queryComInfo.setDimselects(dimList.toArray(new String[0]));
            }
        }
        return queryComInfo;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        return super.getColumns(columns);
    }

    private Map<String, String> getDimFieldMapped() {
        long modelId = ((DynamicObject)this.getQueryParam().getCustomParam().get(MODEL)).getLong("id");
        LinkedHashMap fieldMapped = Maps.newLinkedHashMap();
        QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
        Map<String, String> dimsLoadMap = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"number, fieldmapped", (QFilter[])new QFilter[]{filter})).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getString("fieldmapped")));
        dimsLoadMap.forEach((k, v) -> {
            String mapped = v;
            if (StringUtils.isEmpty((String)v)) {
                mapped = Objects.requireNonNull(SysDimensionEnum.getEnumByNumber((String)k)).getSign();
            }
            fieldMapped.put(k, mapped);
        });
        return fieldMapped;
    }
}

