/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.bizstatus.model.StatusResult;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.olap.verify.VerifyResult;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.dc.DCQueryHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.AnalyticsSolutionDataConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.PositionTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.analytics.AnalyticsSolutionHelper;
import kd.fi.bcm.formplugin.analytics.MDQueryAnalysisStyleHandle;
import kd.fi.bcm.formplugin.analytics.MultiDimQueryAnalysisPlugin;
import kd.fi.bcm.formplugin.analytics.vo.MultQueryRowColMem;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.HeadObject;
import kd.fi.bcm.spread.model.dao.MDDataHandleService;
import kd.fi.bcm.spread.util.ReportSourceUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class MDQADataQueryHelper {
    private static final List<String> msvs = Lists.newArrayList((Object[])new String[]{"+  " + AnalyticsSolutionDataConstant.getMoreMessage(), "-  " + AnalyticsSolutionDataConstant.getMoreMessage()});

    public static VerifyResult saveDataForMDQAD(Sheet sheet, long modelId, Map<String, Pair<Long, String>> pageDims) {
        boolean isNeedChange;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        ArrayList<String> rcDims = new ArrayList<String>(sheet.getRowHeader().getDimNums());
        rcDims.addAll(sheet.getColHeader().getDimNums());
        String currency = null;
        Pair<Long, String> orgPair = pageDims.get(PresetConstant.ENTITY_DIM);
        Pair<Long, String> processPair = pageDims.get(PresetConstant.PROCESS_DIM);
        Pair<Long, String> curPair = pageDims.get(PresetConstant.CURRENCY_DIM);
        QueryStatusCommandInfo qscinfo = new QueryStatusCommandInfo(modelNum);
        String proNum = null;
        if (orgPair == null || processPair == null || curPair == null) {
            DCQueryHelper.dcdims.forEach(k -> {
                if (!rcDims.contains(k)) {
                    rcDims.add((String)k);
                }
            });
            isNeedChange = true;
        } else {
            currency = (String)curPair.p2;
            currency = MDQADataQueryHelper.replaceCurrency(currency, (String)orgPair.p2, (String)processPair.p2, modelId);
            isNeedChange = false;
            proNum = (String)orgPair.p2;
        }
        HashMap<String, String> pageMap = new HashMap<String, String>(16);
        for (Map.Entry<String, Pair<Long, String>> entry : pageDims.entrySet()) {
            boolean isChangeCur;
            String number = (String)entry.getValue().p2;
            String k2 = entry.getKey();
            pageMap.put(k2, number);
            if (rcDims.contains(k2)) continue;
            String lockNumber = number;
            boolean bl = isChangeCur = PresetConstant.CURRENCY_DIM.equals(k2) && StringUtils.isNotEmpty((CharSequence)currency);
            if (isChangeCur) {
                number = currency;
                lockNumber = currency;
            } else if (PresetConstant.PROCESS_DIM.equals(k2)) {
                number = MDQADataQueryHelper.replaceProcess(number);
            } else if (PresetConstant.ENTITY_DIM.equals(k2)) {
                number = MDQADataQueryHelper.getRealOrgNum(number, proNum);
            }
            info.addfixedDimension(new String[]{k2, number});
            qscinfo.addFixDimension(k2, lockNumber);
        }
        info.setDimensions(rcDims);
        qscinfo.setCrossDimensions(rcDims);
        CellSet cellSet = MDQADataQueryHelper.getCellSet(sheet, modelId, isNeedChange, pageMap, rcDims, qscinfo);
        if (cellSet.getCount() > 0) {
            MDQueryAnalysisStyleHandle styleHandle = new MDQueryAnalysisStyleHandle();
            styleHandle.setKeyPacker(qscinfo, rcDims);
            styleHandle.setBizStatusQueryTypes(qscinfo, true);
            Map<String, StatusResult> resultMap = styleHandle.queryStatus(qscinfo);
            if (!resultMap.isEmpty()) {
                int processIndex = rcDims.indexOf(DimTypesEnum.PROCESS.getNumber());
                int orgIndex = rcDims.indexOf(DimTypesEnum.ENTITY.getNumber());
                resultMap.forEach((k, v) -> {
                    String orgNum;
                    String[] dims;
                    ArrayList<String> mems = new ArrayList<String>(16);
                    for (String dim : dims = k.split(";")) {
                        String[] split = dim.split(",");
                        if (split.length != 2) continue;
                        mems.add(split[1]);
                    }
                    if (processIndex != -1) {
                        String processNum = (String)mems.get(processIndex);
                        mems.set(processIndex, MDQADataQueryHelper.replaceProcess(processNum));
                    }
                    cellSet.remove(mems.toArray(new String[0]));
                    if (orgIndex != -1 && (orgNum = (String)mems.get(orgIndex)).split("_").length == 2) {
                        mems.set(orgIndex, orgNum.split("_")[1]);
                        cellSet.remove(mems.toArray(new String[0]));
                    }
                });
            }
        }
        OlapCommandUtil.addSourceMeasure((String)modelNum, (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.M1);
        return OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSet, (String)modelNum);
    }

    private static String getRealOrgNum(String orgNum, String proNum) {
        if (OrgRelaProcessMembPool.isRelaProcess((String)proNum)) {
            return orgNum;
        }
        if (StringUtils.isNotEmpty((CharSequence)orgNum) && orgNum.split("_").length == 2) {
            orgNum = orgNum.split("_")[1];
        }
        return orgNum;
    }

    private static CellSet getCellSet(Sheet sheet, long modelId, boolean isNeedChange, Map<String, String> pageMap, List<String> rcDims, QueryStatusCommandInfo qscinfo) {
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        List rowDims = rowHeader.getDimNums();
        List colDims = colHeader.getDimNums();
        int rDimSzie = rowDims.size();
        int cDimSzie = colDims.size();
        CellSet cellSet = new CellSet(rcDims.toArray(new String[0]), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        cellSet.setFromQuery(false);
        sheet.iteratorRangeCells(cDimSzie, rowHeader.getObjects().size(), rDimSzie, colHeader.getObjects().size(), cell -> {
            if (cell.isChangeVal()) {
                HeadObject rHeadObject = rowHeader.get(cell.getRow(), false);
                if (MDQADataQueryHelper.isNotCompleteDimMem(rHeadObject, rowDims)) {
                    return;
                }
                HeadObject cHeadObject = colHeader.get(cell.getCol(), false);
                if (MDQADataQueryHelper.isNotCompleteDimMem(cHeadObject, colDims)) {
                    return;
                }
                Map map = rHeadObject.getCombineMap(rowDims);
                map.putAll(cHeadObject.getCombineMap(colDims));
                ArrayList combineList = new ArrayList(rcDims.size());
                ArrayList lockMemList = new ArrayList(rcDims.size());
                if (isNeedChange) {
                    map.putAll(pageMap);
                    rcDims.forEach(k -> {
                        String memNum;
                        String lockNum = memNum = (String)map.get(k);
                        boolean isCurc = PresetConstant.CURRENCY_DIM.equals(k);
                        if (isCurc) {
                            lockNum = memNum = MDQADataQueryHelper.replaceCurrency(memNum, (String)map.get(PresetConstant.ENTITY_DIM), (String)map.get(PresetConstant.PROCESS_DIM), modelId);
                        } else if (PresetConstant.PROCESS_DIM.equals(k)) {
                            memNum = MDQADataQueryHelper.replaceProcess(memNum);
                        } else if (PresetConstant.ENTITY_DIM.equals(k)) {
                            memNum = MDQADataQueryHelper.getRealOrgNum(memNum, (String)map.get(PresetConstant.PROCESS_DIM));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)memNum)) {
                            combineList.add(memNum);
                        }
                        lockMemList.add(lockNum);
                    });
                } else {
                    rcDims.forEach(k -> combineList.add(map.get(k)));
                    rcDims.forEach(k -> lockMemList.add(map.get(k)));
                }
                cellSet.set(combineList.toArray(new String[0]), FacTabFieldDefEnum.FIELD_MONEY.getField(), cell.getValue());
                qscinfo.addCrossMembers(lockMemList);
            }
        });
        return cellSet;
    }

    private static String replaceCurrency(String currency, String orgNum, String process, long modelId) {
        if (Arrays.asList("DC", "EC").contains(currency)) {
            String result = currency;
            return (String)ThreadCache.get((Object)String.join((CharSequence)",", "changeCurrency", currency, orgNum, process, modelId + ""), () -> {
                String modelNum = MemberReader.findModelNumberById((Object)modelId);
                Pair pair = TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)BcmThreadCache.findMemberByNum((String)modelNum, (String)PresetConstant.ENTITY_DIM, (String)orgNum), (long)modelId, (String)process, (String)result);
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.p2))) {
                    return (String)pair.p2;
                }
                return result;
            });
        }
        return currency;
    }

    private static String replaceProcess(String number) {
        if ("ERpt".equals(number)) {
            number = "Rpt";
        } else if ("EIRpt".equals(number)) {
            number = "IRpt";
        } else if ("ERAdj".equals(number)) {
            number = "RAdj";
        }
        return number;
    }

    public static int buildRowColHeader(Sheet sheet, List<IDNumberTreeNode>[] dimAndMember, boolean isRow, Map<String, String> orgNameByFYAndPeriod, int index, boolean isLoadAll, String openParent) {
        Header header;
        int totalSize = 1;
        ArrayList<String> dimNums = new ArrayList<String>(16);
        for (int i = 0; i < dimAndMember.length; ++i) {
            List<IDNumberTreeNode> nodeList = dimAndMember[i];
            if (nodeList.isEmpty()) continue;
            totalSize *= nodeList.size();
            dimNums.add(nodeList.get(0).getDimNumber());
        }
        Header header2 = header = isRow ? sheet.getRowHeader() : sheet.getColHeader();
        if (isLoadAll) {
            header.clear();
        }
        header.setDimNums(dimNums);
        for (int idx = 0; idx < totalSize; ++idx) {
            HeadObject headObject = header.get(idx + index, true);
            for (int i = 0; i < dimAndMember.length; ++i) {
                IDNumberTreeNode treeNode = dimAndMember[i].get(0);
                String dimNum = treeNode.getDimNumber();
                IDNumberTreeNode node = dimAndMember[i].get(MDQADataQueryHelper.getCurIndex(idx, totalSize, i, dimAndMember));
                headObject.addMember(dimNum, MDQADataQueryHelper.getHeadMap(node, orgNameByFYAndPeriod));
                if (isLoadAll || !StringUtils.isNotEmpty((CharSequence)openParent)) continue;
                headObject.getSingleDimMember(dimNum).put("openParent", openParent);
            }
        }
        return totalSize;
    }

    public static int getCurIndex(int cuRow, int totalSize, int dimIndex, List<IDNumberTreeNode>[] dimAndMember) {
        int index = 0;
        int dimSize = dimAndMember.length;
        List<IDNumberTreeNode> nodeList = dimAndMember[dimIndex];
        int curMemSize = nodeList.size();
        int otherCount = 1;
        if (dimIndex == dimSize - 1) {
            index = cuRow % curMemSize;
        } else if (dimIndex == 0) {
            otherCount = totalSize / curMemSize;
            index = cuRow / otherCount;
        } else {
            for (int i = dimIndex + 1; i < dimSize; ++i) {
                otherCount *= dimAndMember[i].size();
            }
            index = cuRow / otherCount % curMemSize;
        }
        return index;
    }

    public static Map<String, Object> getHeadMap(IDNumberTreeNode node, Map<String, String> orgNameByFYAndPeriod) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String name = node.getName();
        if (DimTypesEnum.ENTITY.getNumber().equals(node.getDimNumber()) && orgNameByFYAndPeriod.get(node.getNumber()) != null) {
            name = orgNameByFYAndPeriod.get(node.getNumber());
        }
        map.put("memName", name);
        map.put("number", node.getNumber());
        if (node.getParent() != null) {
            map.put("parentNum", node.getParent().getNumber());
        }
        map.put("isleaf", node.isLeaf());
        map.put("id", node.getId());
        map.put("level", node.getLevel());
        map.put("cellFlag", GlobalIdUtil.genStringId());
        return map;
    }

    public static Map<String, List<String>> getExitDataDimMembers(Map<String, Object> map, List<String> rowColDimNums) {
        HashMap<String, List<String>> exitDataMap = new HashMap<String, List<String>>(16);
        map.forEach((k, v) -> {
            String[] split = k.split("\\|");
            if (split.length >= rowColDimNums.size()) {
                for (int i = 0; i < rowColDimNums.size(); ++i) {
                    String memNum;
                    String dimNum = (String)rowColDimNums.get(i);
                    List members = exitDataMap.computeIfAbsent(dimNum, e -> new ArrayList(16));
                    if (!members.contains(memNum = split[i])) {
                        members.add(memNum);
                    }
                    if (!DimTypesEnum.PROCESS.getNumber().equals(dimNum) || !"IRpt".equals(memNum) || members.contains("EIRpt")) continue;
                    members.add("EIRpt");
                }
            }
        });
        return exitDataMap;
    }

    public static List<Map<String, Object>> updateCellValues(Map<String, Object> result, Sheet sheet, int beginRow, int endRow, boolean isWp, SpreadManager sm) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(16);
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        List rowDimNums = rowHeader.getDimNums();
        int rowDimSize = rowDimNums.size();
        List colDimNums = colHeader.getDimNums();
        int maxColCount = sheet.getMaxColHeaderSize();
        boolean flag = ThreadCache.get((Object)"null_value_notupdate") != null;
        for (int j = beginRow; j <= endRow; ++j) {
            HeadObject rowHeadObj = rowHeader.get(j, false);
            if (MDQADataQueryHelper.isNotCompleteDimMem(rowHeadObj, rowDimNums, isWp)) continue;
            for (int i = rowDimSize; i < maxColCount; ++i) {
                HeadObject colHeadObj = colHeader.get(i, false);
                if (MDQADataQueryHelper.isNotCompleteDimMem(colHeadObj, colDimNums, isWp)) continue;
                Object value = null;
                if (rowHeadObj != null && colHeadObj != null) {
                    List combineList = rowHeadObj.getCombineList(rowDimNums);
                    MDQADataQueryHelper.getCurrentYearAndLastYear(isWp, sm, rowDimNums, combineList);
                    combineList.addAll(colHeadObj.getCombineList(colDimNums));
                    String key = String.join((CharSequence)"|", combineList);
                    value = result.get(key);
                }
                Cell cell = sheet.getCell(j, i, value != null);
                if (!flag || value != null) {
                    cellValues.add(SpreadEasyInvoker.packedUpdateCellMap(j, i, value));
                }
                if (cell == null) continue;
                cell.setValue(value);
                if (isWp) continue;
                cell.setChangeVal(false);
            }
        }
        return cellValues;
    }

    public static List<Map<String, Object>> updateCellValues(Map<String, Object> result, Sheet sheet, MultiDimQueryAnalysisPlugin.RangeWindow rangeWindow, boolean isWp, SpreadManager sm) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(16);
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        List rowDimNums = rowHeader.getDimNums();
        int rowDimSize = rowDimNums.size();
        List colDimNums = colHeader.getDimNums();
        int maxColCount = sheet.getMaxColHeaderSize();
        boolean flag = ThreadCache.get((Object)"null_value_notupdate") != null;
        for (int j = rangeWindow.getTopRow(); j <= rangeWindow.getBottomRow(); ++j) {
            HeadObject rowHeadObj = rowHeader.get(j, false);
            if (MDQADataQueryHelper.isNotCompleteDimMem(rowHeadObj, rowDimNums, isWp)) continue;
            for (int i = rowDimSize; i <= rangeWindow.getRightCol(); ++i) {
                HeadObject colHeadObj = colHeader.get(i, false);
                if (MDQADataQueryHelper.isNotCompleteDimMem(colHeadObj, colDimNums, isWp)) continue;
                Object value = null;
                if (rowHeadObj != null && colHeadObj != null) {
                    List combineList = rowHeadObj.getCombineList(rowDimNums);
                    MDQADataQueryHelper.getCurrentYearAndLastYear(isWp, sm, rowDimNums, combineList);
                    combineList.addAll(colHeadObj.getCombineList(colDimNums));
                    String key = String.join((CharSequence)"|", combineList);
                    value = result.get(key);
                }
                Cell cell = sheet.getCell(j, i, value != null);
                if (!flag || value != null) {
                    cellValues.add(SpreadEasyInvoker.packedUpdateCellMap(j, i, value));
                }
                if (cell == null) continue;
                cell.setValue(value);
                if (isWp) continue;
                cell.setChangeVal(false);
            }
        }
        return cellValues;
    }

    public static List<Map<String, Object>> updateCellValues4ext(Map<String, Object> datas, Sheet sheet) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(16);
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        List rowDimNums = rowHeader.getDimNums();
        int rowDimSize = rowHeader.getDimNumsSize();
        int colDimSize = colHeader.getDimNumsSize();
        List colDimNums = colHeader.getDimNums();
        int maxColCount = sheet.getMaxColHeaderSize();
        int maxRowCount = sheet.getMaxRowHeaderSize();
        boolean inRow = rowHeader.isWithFmoney();
        boolean inCol = colHeader.isWithFmoney();
        for (int j = colDimSize; j < maxRowCount; ++j) {
            HeadObject rowHeadObj = rowHeader.get(j, false);
            if (rowHeadObj == null) continue;
            String rowFmoneyNum = (String)rowHeadObj.get((Object)"fmoney");
            StringBuilder sb = new StringBuilder();
            Map rowAllMemberMap = rowHeadObj.getAllMemberMap();
            for (String rowDimNum : rowDimNums) {
                MultQueryRowColMem mem = (MultQueryRowColMem)rowAllMemberMap.get(rowDimNum);
                if (mem == null) continue;
                sb.append(mem.getValue());
            }
            for (int i = rowDimSize; i < maxColCount; ++i) {
                StringBuilder key = new StringBuilder(sb);
                HeadObject colHeadObj = colHeader.get(i, false);
                Map colAllMemberMap = colHeadObj.getAllMemberMap();
                Object value = null;
                if (colHeadObj != null) {
                    for (String colDimNum : colDimNums) {
                        MultQueryRowColMem mem = (MultQueryRowColMem)colAllMemberMap.get(colDimNum);
                        if (mem == null) continue;
                        key.append(mem.getValue());
                    }
                    if (inRow) {
                        key.append(rowFmoneyNum);
                    } else if (inCol) {
                        key.append(colHeadObj.get((Object)"fmoney"));
                    }
                    value = datas.get(key.toString());
                }
                Cell cell = sheet.getCell(j, i, value != null);
                if (value != null) {
                    cellValues.add(SpreadEasyInvoker.packedUpdateCellMap(j, i, value));
                }
                if (cell == null) continue;
                cell.setValue(value);
                cell.setChangeVal(false);
            }
        }
        return cellValues;
    }

    private static void getCurrentYearAndLastYear(boolean isWp, SpreadManager sm, List<String> rowDimNums, List<String> combineList) {
        if (isWp && sm != null && rowDimNums.contains("Year")) {
            String lastYear;
            int yearIndex = rowDimNums.indexOf("Year");
            if (yearIndex >= combineList.size()) {
                return;
            }
            if ("CurrentYear".equalsIgnoreCase(combineList.get(yearIndex))) {
                String currentYear = sm.getCurrentYear();
                if (StringUtils.isNotEmpty((CharSequence)currentYear)) {
                    combineList.set(yearIndex, currentYear);
                }
            } else if ("LastYear".equalsIgnoreCase(combineList.get(yearIndex)) && StringUtils.isNotEmpty((CharSequence)(lastYear = sm.getLastYear()))) {
                combineList.set(yearIndex, lastYear);
            }
        }
    }

    public static boolean addRCFilterFromHeader(SelectCommandInfo queryInfo, Header header, boolean isWp, SpreadManager sm) {
        HashMap<String, Set> memberMap = new HashMap<String, Set>(16);
        if (header != null) {
            List dims = header.getDimNums();
            header.iteratorObjects(h -> {
                if (!MDQADataQueryHelper.isNotCompleteDimMem(h, dims, isWp)) {
                    dims.forEach(s -> {
                        Set mems = memberMap.computeIfAbsent((String)s, k -> new HashSet(16));
                        String memNum = h.getMemberNum(s);
                        memNum = MDQADataQueryHelper.getCurrentYearAndLastYear(sm, s, memNum, isWp);
                        mems.add(memNum);
                    });
                }
            });
        }
        if (!memberMap.isEmpty()) {
            memberMap.forEach((k, v) -> queryInfo.addFilter(k, v.toArray(new String[0])));
            return true;
        }
        return false;
    }

    private static String getCurrentYearAndLastYear(SpreadManager sm, String s, String memNum, boolean isWp) {
        if (isWp && sm != null && "Year".equalsIgnoreCase(s)) {
            String lastYear;
            if ("CurrentYear".equalsIgnoreCase(memNum)) {
                String currentYear = sm.getCurrentYear();
                if (StringUtils.isNotEmpty((CharSequence)currentYear)) {
                    memNum = currentYear;
                }
            } else if ("LastYear".equalsIgnoreCase(memNum) && StringUtils.isNotEmpty((CharSequence)(lastYear = sm.getLastYear()))) {
                memNum = lastYear;
            }
        }
        return memNum;
    }

    public static void addRCFilterFromMember(SelectCommandInfo queryInfo, List<IDNumberTreeNode>[] rowDimMember) {
        for (List<IDNumberTreeNode> nodeList : rowDimMember) {
            ArrayList mems = new ArrayList(nodeList.size());
            nodeList.forEach(e -> {
                String dimNum = e.getDimNumber();
                if (DimTypesEnum.ENTITY.getNumber().equals(dimNum) && e.getParent_SonNumber() != null) {
                    mems.add(e.getParent_SonNumber());
                }
                mems.add(e.getNumber());
            });
            queryInfo.addFilter(nodeList.get(0).getDimNumber(), mems.toArray(new String[0]));
        }
    }

    public static Pair<Map<String, Object>, Boolean> getSingleDimMemPair(int r, int c, Sheet sheet) {
        Map rMemMap = new HashMap(16);
        Tuple<HeadObject, String, Boolean> tuple = MDQADataQueryHelper.getHeadObjectTuple(r, c, sheet);
        boolean isRow = false;
        if (tuple != null && tuple.p1 != null) {
            rMemMap = ((HeadObject)tuple.p1).getSingleDimMember((String)tuple.p2);
            isRow = (Boolean)tuple.p3;
        }
        return Pair.onePair(rMemMap, (Object)isRow);
    }

    public static Tuple<HeadObject, String, Boolean> getHeadObjectTuple(int r, int c, Sheet sheet) {
        int memIndex;
        int rcIndex;
        int rowDimSize = sheet.getRowHeader().getDimNums().size();
        int colDimSize = sheet.getColHeader().getDimNums().size();
        Header header = null;
        boolean isRow = true;
        if (c < rowDimSize && r >= colDimSize && r < sheet.getMaxRowHeaderSize()) {
            header = sheet.getRowHeader();
            rcIndex = c;
            memIndex = r;
        } else if (r < colDimSize && c >= rowDimSize && c < sheet.getMaxColHeaderSize()) {
            header = sheet.getColHeader();
            rcIndex = r;
            memIndex = c;
            isRow = false;
        } else {
            return null;
        }
        HeadObject headObject = null;
        String dimNum = null;
        if (header != null) {
            dimNum = (String)header.getDimNums().get(rcIndex);
            headObject = header.get(memIndex, false);
        }
        return Tuple.create(headObject, dimNum, (Object)isRow);
    }

    public static <T> T getValue(Map<String, Object> memberMap, String key, T defaultValue) {
        if (memberMap == null || memberMap.isEmpty()) {
            return defaultValue;
        }
        Object v = memberMap.get(key);
        return (T)(v == null ? defaultValue : v);
    }

    public static void fillMoreCell(Sheet sheet, boolean isRow, int insertCount, int r, int c, SpreadEasyInvoker invoker) {
        Header header = sheet.getHeader(isRow);
        int idx = isRow ? r : c;
        HeadObject startHeadObj = header.get(idx, true);
        int dimIndex = isRow ? c : r;
        List dimNums = header.getDimNums();
        HeadObject endHeadObj = header.get(idx + insertCount, true);
        String value = "+  " + AnalyticsSolutionDataConstant.getMoreMessage();
        Map map = startHeadObj.getSingleDimMember((String)dimNums.get(isRow ? c : r));
        String openParent = MDQADataQueryHelper.isMoreCells(startHeadObj) ? MDQADataQueryHelper.getValue(map, "openParent", "") : MDQADataQueryHelper.getValue(map, "cellFlag", "");
        for (int i = 0; i < dimNums.size(); ++i) {
            String dimNum = (String)dimNums.get(i);
            map = startHeadObj.getSingleDimMember(dimNum);
            HashMap moreMap = new HashMap(16);
            moreMap.put("number", map.get("number"));
            moreMap.put("id", map.get("id"));
            moreMap.put("level", map.get("level"));
            moreMap.put("ti", map.get("ti"));
            moreMap.put("cellFlag", GlobalIdUtil.genStringId());
            int curr = isRow ? r + insertCount : i;
            int cucc = isRow ? i : c + insertCount;
            String v = value;
            if (i == dimIndex) {
                moreMap.put("msv", value);
                Integer curCol = MDQADataQueryHelper.getValue(map, "solution_currentcell", 0);
                map.remove("solution_currentcell");
                moreMap.put("solution_currentcell", curCol);
                moreMap.put("isleaf", map.get("isleaf"));
                moreMap.put("openCount", map.get("openCount"));
            } else {
                v = null;
            }
            Cell cell = sheet.getCell(curr, cucc);
            cell.setValue((Object)v);
            cell.setChangeVal(false);
            invoker.updataValue(curr, cucc, v);
            moreMap.put("openParent", openParent);
            endHeadObj.addMember(dimNum, moreMap);
        }
    }

    public static void updateParenOpenRowCount(Header header, Map<String, Object> map, int newOpenCount, boolean isAdd, int statrt, int end) {
        if (newOpenCount < 1 || end == 0) {
            return;
        }
        String openParent = MDQADataQueryHelper.getValue(map, "openParent", "");
        if (StringUtils.isNotEmpty((CharSequence)openParent)) {
            List dimNums = header.getDimNums();
            header.iteratorObjects(statrt, end, e -> {
                Map allMemberMap = e.getAllMemberMap();
                if (!allMemberMap.isEmpty()) {
                    dimNums.forEach(s -> {
                        Map singleMap = (Map)allMemberMap.get(s);
                        if (openParent.equals(singleMap.get("cellFlag"))) {
                            MDQADataQueryHelper.updateSingleParentOpenRowCount(newOpenCount, singleMap, isAdd);
                            if (singleMap.get("openParent") != null) {
                                MDQADataQueryHelper.updateParenOpenRowCount(header, singleMap, newOpenCount, isAdd, e.getIndex());
                            }
                        }
                    });
                }
            });
        }
    }

    public static void updateParenOpenRowCount(Header header, Map<String, Object> map, int newOpenCount, boolean isAdd, int end) {
        if (newOpenCount < 1 || end == 0) {
            return;
        }
        MDQADataQueryHelper.updateParenOpenRowCount(header, map, newOpenCount, isAdd, 0, end);
    }

    private static void updateSingleParentOpenRowCount(int newOpenCount, Map<String, Object> map, boolean isAdd) {
        int oldOpenRowCount = 0;
        if (map.get("openCount") != null) {
            oldOpenRowCount = MDQADataQueryHelper.getValue(map, "openCount", 0);
        }
        if (isAdd) {
            map.put("openCount", oldOpenRowCount + newOpenCount);
        } else {
            map.put("openCount", oldOpenRowCount - newOpenCount);
        }
    }

    public static boolean isMoreCells(HeadObject headObject) {
        Predicate<Map.Entry<String, Map<String, Object>>> predicate = new Predicate<Map.Entry<String, Map<String, Object>>>(){

            @Override
            public boolean test(Map.Entry<String, Map<String, Object>> e) {
                return msvs.contains(MDQADataQueryHelper.getValue(e.getValue(), "msv", ""));
            }
        };
        return headObject == null || headObject.getAllMemberMap().entrySet().stream().anyMatch(predicate);
    }

    public static Map<String, String> getCellDimMemberMap(long modelId, Header rHeader, Header cHeader, int r, int c, Map<String, String> pageDimMemMap, RangeModel rangeModel, Map<String, Pair<String, String>> specialYear) {
        Map<String, Object> cellInfo = MDQADataQueryHelper.getCellInfo(modelId, rHeader, cHeader, r, c, pageDimMemMap, false, null, null, false, false, rangeModel, specialYear);
        return MDQADataQueryHelper.getValue(cellInfo, "dimNumber2MembNumber", new HashMap(16));
    }

    public static Map<String, Object> getCellInfo(long modelId, Header rHeader, Header cHeader, int r, int c, Map<String, String> pageDimMemMap, boolean isNeedInfo, String separate1, String separate2, boolean isParSon, boolean isOnlyRC, RangeModel rangeModel, Map<String, Pair<String, String>> specialYear) {
        List rDimNums = rHeader.getDimNums();
        List cDimNums = cHeader.getDimNums();
        int rowDimSize = rDimNums.size();
        int colDimSize = cDimNums.size();
        AtomicBoolean isMDQA = new AtomicBoolean(false);
        if (rangeModel == null) {
            rangeModel = new RangeModel(rowDimSize, cHeader.getObjects().size() - 1, colDimSize, rHeader.getObjects().size() - 1);
            isMDQA.set(true);
        }
        if (!rangeModel.isColInArea(c) || !rangeModel.isRowInArea(r)) {
            return null;
        }
        HashMap<String, Object> cellInfo = new HashMap<String, Object>(16);
        LinkedHashMap<String, Object> memMap = new LinkedHashMap<String, Object>(16);
        HeadObject rHeadObj = rHeader.get(r, false);
        HeadObject cHeadObj = cHeader.get(c, false);
        if (MDQADataQueryHelper.isNotCompleteDimMem(rHeadObj, rDimNums) || MDQADataQueryHelper.isNotCompleteDimMem(cHeadObj, cDimNums)) {
            return cellInfo;
        }
        memMap.putAll(pageDimMemMap);
        LinkedHashMap<String, Pair> map = new LinkedHashMap<String, Pair>(16);
        map.putAll(rHeadObj.getNumberNameMap(rDimNums));
        map.putAll(cHeadObj.getNumberNameMap(cDimNums));
        map.forEach((k, p) -> {
            memMap.put((String)k, p.p1);
            if ("Year".equalsIgnoreCase((String)k) && MapUtils.isNotEmpty((Map)specialYear) && specialYear.containsKey(p.p1)) {
                memMap.put((String)k, ((Pair)specialYear.get((Object)p.p1)).p1);
                map.put((String)k, (Pair)specialYear.get(p.p1));
            }
        });
        String currencyNum = (String)memMap.get(PresetConstant.CURRENCY_DIM);
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        String orgNum = (String)memMap.get(PresetConstant.ENTITY_DIM);
        String processNum = (String)memMap.get(PresetConstant.PROCESS_DIM);
        if (Lists.newArrayList((Object[])new String[]{"DC", "EC"}).contains(currencyNum) && StringUtils.isNotEmpty((CharSequence)orgNum) && StringUtils.isNotEmpty((CharSequence)processNum)) {
            Pair pair = TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)BcmThreadCache.findMemberByNum((String)modelNumber, (String)PresetConstant.ENTITY_DIM, (String)orgNum), (long)modelId, (String)processNum, (String)currencyNum);
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.p2))) {
                memMap.put(PresetConstant.CURRENCY_DIM, pair.p2);
            }
        }
        if (!isParSon && !OrgRelaProcessMembPool.isRelaProcess((String)processNum) && StringUtils.isNotEmpty((CharSequence)orgNum) && orgNum.split("_").length == 2) {
            orgNum = orgNum.split("_")[1];
        }
        if (isNeedInfo) {
            long fsource;
            StringBuilder info = new StringBuilder();
            Map tempMap = MemberReader.getDimNumberMapNameById((long)modelId);
            String finalOrgNum = orgNum;
            memMap.forEach((k, v) -> {
                if (isOnlyRC && !rDimNums.contains(k) && !cDimNums.contains(k)) {
                    return;
                }
                String dimName = (String)tempMap.get(k);
                if (StringUtils.isNotEmpty((CharSequence)dimName)) {
                    Pair pair = (Pair)map.get(k);
                    String name = "";
                    IDNumberTreeNode node = null;
                    if (pair != null) {
                        name = (String)pair.p2;
                    } else {
                        node = BcmThreadCache.findMemberByNum((String)modelNumber, (String)k, (String)v);
                        if (node != IDNumberTreeNode.NotFoundTreeNode) {
                            name = node.getName();
                        }
                    }
                    boolean isEntity = PresetConstant.ENTITY_DIM.equals(k);
                    info.append(dimName).append(separate1).append(isEntity ? finalOrgNum : v).append("  ").append(name).append(separate2);
                    if (isEntity && ";\n".equals(separate2) && isMDQA.get()) {
                        IDNumberTreeNode parent;
                        if (node == null) {
                            node = BcmThreadCache.findMemberByNum((String)modelNumber, (String)k, (String)v);
                        }
                        if ((parent = node.getParent()) != null) {
                            info.append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7|", (String)"MultiDimQueryAnalysisPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(parent.getNumber()).append("  ").append(parent.getName()).append(separate2);
                        }
                    }
                }
            });
            if (isOnlyRC && StringUtils.isNotEmpty((CharSequence)separate2) && info.length() != 0) {
                info.deleteCharAt(info.lastIndexOf(separate2));
            }
            if (!isOnlyRC && (fsource = ReportSourceUtil.getSource((String)MemberReader.findModelNumberById((Object)modelId), memMap)) != 0L) {
                info.append("\n").append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\uff1a%s", (String)"SpreadMemberUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]), OlapSourceEnum.getName((Object)fsource))).append(";\n");
            }
            cellInfo.put("infoText", info);
        }
        memMap.put(DimTypesEnum.ENTITY.getNumber(), orgNum);
        cellInfo.put("dimNumber2MembNumber", memMap);
        return cellInfo;
    }

    public static Map<String, Object> getCellInfo(long modelId, Header rHeader, Header cHeader, int r, int c, Map<String, String> pageDimMemMap, boolean isNeedInfo, String separate1, String separate2, boolean isParSon, boolean isOnlyRC) {
        return MDQADataQueryHelper.getCellInfo(modelId, rHeader, cHeader, r, c, pageDimMemMap, isNeedInfo, separate1, separate2, isParSon, isOnlyRC, null, null);
    }

    public static Map<String, Object> getCellInfo(long modelId, Sheet sheet, int r, int c, Map<String, String> pageDimMemMap, RangeModel RangeModel2) {
        return MDQADataQueryHelper.getCellInfo(modelId, sheet.getRowHeader(), sheet.getColHeader(), r, c, pageDimMemMap, true, "|", ";\n", false, false, RangeModel2, null);
    }

    public static Map<String, Object> getCellInfo4wp(long modelId, Sheet sheet, int r, int c, Map<String, String> pageDimMemMap, RangeModel RangeModel2, Map<String, Pair<String, String>> specialYear) {
        return MDQADataQueryHelper.getCellInfo(modelId, sheet.getRowHeader(), sheet.getColHeader(), r, c, pageDimMemMap, true, "|", ";\n", false, false, RangeModel2, specialYear);
    }

    public static PositionTypeEnum getPositionTypeEnum(int r, int c, Sheet sheet) {
        int colDimSize = sheet.getColHeader().getDimNums().size();
        int rowDimSize = sheet.getRowHeader().getDimNums().size();
        int maxRowSize = sheet.getMaxRowHeaderSize();
        int maxColSize = sheet.getMaxColHeaderSize();
        PositionTypeEnum positionTypeEnum = null;
        if (c < rowDimSize && r >= colDimSize) {
            positionTypeEnum = PositionTypeEnum.ONROW;
        } else if (r < colDimSize && c >= rowDimSize) {
            positionTypeEnum = PositionTypeEnum.ONCOL;
        } else if (colDimSize <= r && r < maxRowSize && rowDimSize <= c && c < maxColSize) {
            positionTypeEnum = PositionTypeEnum.ONCROSS;
        }
        return positionTypeEnum;
    }

    public static String getDimNum(Sheet sheet, int r, int c) {
        List rDimNums = sheet.getRowHeader().getDimNums();
        int rowDimSize = rDimNums.size();
        List cDimNums = sheet.getColHeader().getDimNums();
        int colDimSize = cDimNums.size();
        String dimNum = null;
        if (c < rowDimSize && r >= colDimSize && r < sheet.getMaxRowHeaderSize()) {
            dimNum = (String)rDimNums.get(c);
        } else if (r < colDimSize && c >= rowDimSize && c < sheet.getMaxColHeaderSize()) {
            dimNum = (String)cDimNums.get(r);
        } else {
            return null;
        }
        return dimNum;
    }

    public static boolean isNotCompleteDimMem(HeadObject headObject, List<String> dimNums) {
        return MDQADataQueryHelper.isNotCompleteDimMem(headObject, dimNums, false);
    }

    public static boolean isNotCompleteDimMem(HeadObject headObject, List<String> dimNums, boolean isWp) {
        if (headObject == null) {
            return true;
        }
        if (isWp) {
            return headObject.size() != dimNums.size() || dimNums.stream().anyMatch(s -> !headObject.getAllMemberMap().containsKey(s));
        }
        return MDQADataQueryHelper.isMoreCells(headObject) || headObject.size() != dimNums.size() || dimNums.stream().anyMatch(s -> !headObject.getAllMemberMap().containsKey(s));
    }

    public static boolean hasChange(Sheet sheet) {
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        List rowDims = rowHeader.getDimNums();
        List colDims = colHeader.getDimNums();
        int rDimSzie = rowDims.size();
        int cDimSzie = colDims.size();
        AtomicBoolean isChange = new AtomicBoolean(false);
        sheet.iteratorRangeByPredicateBreak(cDimSzie, rowHeader.getObjects().size(), rDimSzie, colHeader.getObjects().size(), cell -> {
            if (cell.isChangeVal()) {
                isChange.set(true);
                return true;
            }
            return false;
        });
        return isChange.get();
    }

    public static void cleanValueForDataRange(IClientViewProxy view, String spreadKey, Sheet sheet) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(view, spreadKey);
        invoker.setBatch(true);
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        sheet.iteratorRangeCells(colHeader.getDimNums().size(), rowHeader.getObjects().size() - 1, rowHeader.getDimNums().size(), colHeader.getObjects().size() - 1, cell -> {
            if (cell.getValue() != null) {
                invoker.updataValue(cell.getRow(), cell.getCol(), null);
                cell.setValue(null);
            }
        });
        invoker.startToInvoke();
    }

    public static void refreshData(SpreadManager sm, String modelNum, IRelaMembSupplier<String, String> orgSupplier) {
        Map<String, Object> data = MDQADataQueryHelper.queryData(sm, modelNum, orgSupplier);
        RangeModel rangeModel = AnalyticsSolutionHelper.getDataRangeModel(sm);
        MDQADataQueryHelper.updateCellValues(data, sm.getBook().getSheet(0), rangeModel.getY_start(), rangeModel.getY_end(), true, sm);
    }

    public static Map<String, Object> queryData(SpreadManager sm, String modelNum, IRelaMembSupplier<String, String> orgSupplier) {
        List colDimMemList = MDDataHandleService.getColDimMemList((SpreadManager)sm);
        Map<String, Object> allSets = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty((Collection)colDimMemList)) {
            return allSets;
        }
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sm.getFilter().getPageDomain().getAllMembers().forEach(p -> queryInfo.addFilter(p.getDimension().getNumber(), new String[]{p.getNumber()}));
        Sheet sheet = sm.getBook().getSheet(0);
        Header rowHeader = sheet.getRowHeader();
        List rowDims = rowHeader.getDimNums();
        List colDims = sheet.getColHeader().getDimNums();
        queryInfo.addDims(rowDims.toArray(new String[0]));
        queryInfo.addDims(colDims.toArray(new String[0]));
        if (!MDQADataQueryHelper.addRCFilterFromHeader(queryInfo, rowHeader, true, sm)) {
            return allSets;
        }
        for (Map map : colDimMemList) {
            MDDataHandleService.replaceColDimMem((Map)map, (SelectCommandInfo)queryInfo);
            Map data = DCQueryHelper.queryData((SelectCommandInfo)queryInfo, (String)modelNum, (long)((OrgRelaMembSupplier)orgSupplier).get_mainOrgId(), null, (boolean)true);
            if (MapUtils.isEmpty(allSets)) {
                allSets = data;
                continue;
            }
            allSets.putAll(data);
        }
        return allSets;
    }
}

