/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizstatus.BizStatusServer;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.bizstatus.model.StatusResult;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.CellColorRange;
import kd.fi.bcm.common.util.CellColorRangeUtils;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.analytics.MDQADataQueryHelper;
import kd.fi.bcm.formplugin.analytics.service.MultiDimQAStyleService;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.HeadObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;

public class MDQueryAnalysisStyleHandle {
    public static final String DIMDELIMITER = ";";
    public static final String MEMDELIMITER = ",";
    protected static final List<Integer> types = new ArrayList<Integer>(16);
    protected static final List<Integer> typeNoPerm = new ArrayList<Integer>(16);
    protected static final List<Integer> orgValid = new ArrayList<Integer>(16);
    private IClientViewProxy iClientViewProxy;
    private IFormView view;
    private String spreadKey;
    private long modelId;
    private Sheet sheet;
    private Map<String, Pair<Long, String>> pageDims;

    public MDQueryAnalysisStyleHandle(IFormView view, String spreadKey, long modelId, Sheet sheet, Map<String, Pair<Long, String>> pageDims) {
        this.modelId = modelId;
        this.view = view;
        this.sheet = sheet;
        this.spreadKey = spreadKey;
        if (view != null) {
            this.iClientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        }
        this.pageDims = pageDims;
    }

    public MDQueryAnalysisStyleHandle(long modelId, Sheet sheet, Map<String, Pair<Long, String>> pageDims) {
        this.modelId = modelId;
        this.sheet = sheet;
        this.pageDims = pageDims;
    }

    public MDQueryAnalysisStyleHandle() {
    }

    public void statusControl() {
        Header rowHeader = this.sheet.getRowHeader();
        Header colHeader = this.sheet.getColHeader();
        boolean canSaveData = ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"CM008");
        if (rowHeader.getDimNums().isEmpty() || colHeader.getDimNums().isEmpty()) {
            return;
        }
        int rowDimSize = rowHeader.getDimNums().size();
        int colDimSize = colHeader.getDimNums().size();
        int rc = rowHeader.getObjects().size();
        int cc = colHeader.getObjects().size();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.iClientViewProxy, this.spreadKey);
        invoker.setBatch(true);
        if (canSaveData) {
            invoker.unlockCell(colDimSize, rowDimSize, rc, cc);
            this.setColorForMDDomain(this.sheet, invoker, MultiDimQAStyleService.DEFAULT_BACKCOLOR);
        } else {
            invoker.lockCell(colDimSize, rowDimSize, rc, cc);
            this.setColorForMDDomain(this.sheet, invoker, "#C5D9F1");
        }
        try {
            this.lockCell(invoker, this.sheet, this.queryStatus(null, canSaveData), false);
        }
        catch (Exception e) {
            this.view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u72b6\u6001\u63a7\u51fa\u9519%s", (String)"MDQueryAnalysisStyleHandle_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10)));
        }
        invoker.startToInvoke();
    }

    public void statusControl(RangeModel rangeModel) {
        Header rowHeader = this.sheet.getRowHeader();
        Header colHeader = this.sheet.getColHeader();
        boolean canSaveData = ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"CM008");
        if (rowHeader.getDimNums().isEmpty() || colHeader.getDimNums().isEmpty()) {
            return;
        }
        int rowDimSize = rowHeader.getDimNums().size();
        int colDimSize = colHeader.getDimNums().size();
        int x_start = rowDimSize >= rangeModel.getX_start() ? rowDimSize : rangeModel.getX_start();
        int y_start = colDimSize >= rangeModel.getY_start() ? colDimSize : rangeModel.getY_start();
        int rc = rangeModel.getY_end() - y_start + 1;
        int cc = rangeModel.getX_end() - x_start + 1;
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.iClientViewProxy, this.spreadKey);
        invoker.setBatch(true);
        if (canSaveData) {
            invoker.unlockCell(y_start, x_start, rc, cc);
            this.setColorForMDDomain(this.sheet, invoker, MultiDimQAStyleService.DEFAULT_BACKCOLOR, rangeModel);
        } else {
            invoker.lockCell(y_start, x_start, rc, cc);
            this.setColorForMDDomain(this.sheet, invoker, "#C5D9F1", rangeModel);
        }
        try {
            this.lockCell(invoker, this.sheet, rangeModel, this.queryStatus(null, rangeModel, canSaveData), false);
        }
        catch (Exception e) {
            this.view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u72b6\u6001\u63a7\u51fa\u9519%s", (String)"MDQueryAnalysisStyleHandle_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10)));
        }
        invoker.startToInvoke();
    }

    public Map<String, StatusResult> queryStatus(Pair<Integer, Integer> pair, boolean canSaveData) {
        return this.queryStatus(this.initQueryStatusCommandInfo(pair, canSaveData));
    }

    public Map<String, StatusResult> queryStatus(Pair<Integer, Integer> pair, RangeModel rangeModel, boolean canSaveData) {
        return this.queryStatus(this.initQueryStatusCommandInfo(pair, rangeModel, canSaveData), rangeModel);
    }

    public Map<String, StatusResult> queryStatus(QueryStatusCommandInfo info) {
        Map<String, Object> results = new HashMap<String, StatusResult>(16);
        if (info.hasCrossDims()) {
            BizStatusContext ct = new BizStatusContext(info);
            results = BizStatusServer.queryStatus((BizStatusContext)ct);
        }
        return results;
    }

    public Map<String, StatusResult> queryStatus(QueryStatusCommandInfo info, RangeModel rangeModel) {
        Map<String, Object> results = new HashMap<String, StatusResult>(16);
        if (info.hasCrossDims()) {
            BizStatusContext ct = new BizStatusContext(info);
            results = BizStatusServer.queryStatus((BizStatusContext)ct);
        }
        return results;
    }

    private void lockCell(SpreadEasyInvoker invoker, Sheet sheet, Map<String, StatusResult> re, boolean isVissible) {
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        List rowDims = rowHeader.getDimNums();
        List colDims = colHeader.getDimNums();
        ArrayList<String> rowColDims = new ArrayList<String>(16);
        rowColDims.addAll(rowDims);
        rowColDims.addAll(colDims);
        int rowDimSize = rowDims.size();
        int colDimSize = colDims.size();
        int rc = rowHeader.getObjects().size();
        int cc = colHeader.getObjects().size();
        HashMap<String, List<String>> colorLockMap = new HashMap<String, List<String>>(16);
        ArrayList<Integer> notMoreCols = new ArrayList<Integer>(16);
        HashBasedTable lockCells = HashBasedTable.create();
        for (int i = colDimSize; i < rc; ++i) {
            HeadObject rObj = rowHeader.get(i, false);
            if (MDQADataQueryHelper.isNotCompleteDimMem(rObj, rowDims)) {
                if (isVissible) continue;
                invoker.lockCell(i, 0, 1, cc);
                continue;
            }
            List list = rObj.getCombineList(rowDims);
            for (int j = rowDimSize; j < cc; ++j) {
                HeadObject cObj = colHeader.get(j, false);
                if (!notMoreCols.contains(j) && MDQADataQueryHelper.isNotCompleteDimMem(cObj, colDims)) {
                    if (isVissible) continue;
                    invoker.lockCell(0, j, rc, 1);
                    continue;
                }
                notMoreCols.add(j);
                ArrayList<String> mems = new ArrayList<String>(16);
                mems.addAll(list);
                mems.addAll(cObj.getCombineList(colDims));
                String colDimMem = this.getCombineKey(rowColDims, mems);
                if (!re.containsKey(colDimMem)) continue;
                if (BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode() == re.get(colDimMem).getStatusCode()) {
                    invoker.updataValue(i, j, "******");
                    lockCells.put((Object)i, (Object)j, (Object)"");
                }
                if (isVissible) continue;
                CellColorRangeUtils.addColorLockCell(colorLockMap, (String)re.get(colDimMem).getColor(), (int)i, (int)j);
            }
        }
        this.colorLockMergeCell(invoker, colorLockMap, (Table<Integer, Integer, String>)lockCells);
    }

    private void lockCell(SpreadEasyInvoker invoker, Sheet sheet, RangeModel rangeModel, Map<String, StatusResult> re, boolean isVissible) {
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        List rowDims = rowHeader.getDimNums();
        List colDims = colHeader.getDimNums();
        ArrayList<String> rowColDims = new ArrayList<String>(16);
        rowColDims.addAll(rowDims);
        rowColDims.addAll(colDims);
        int rowDimSize = rowHeader.getDimNums().size();
        int colDimSize = colHeader.getDimNums().size();
        int x_start = rowDimSize >= rangeModel.getX_start() ? rowDimSize : rangeModel.getX_start();
        int y_start = colDimSize >= rangeModel.getY_start() ? colDimSize : rangeModel.getY_start();
        int rc = rangeModel.getY_end() - y_start + 1;
        int cc = rangeModel.getX_end() - x_start + 1;
        HashMap<String, List<String>> colorLockMap = new HashMap<String, List<String>>(16);
        ArrayList<Integer> notMoreCols = new ArrayList<Integer>(16);
        HashBasedTable lockCells = HashBasedTable.create();
        for (int i = y_start; i <= y_start + rc; ++i) {
            HeadObject rObj = rowHeader.get(i, false);
            if (MDQADataQueryHelper.isNotCompleteDimMem(rObj, rowDims)) {
                if (isVissible) continue;
                invoker.lockCell(i, 0, 1, cc);
                continue;
            }
            List list = rObj.getCombineList(rowDims);
            for (int j = x_start; j <= x_start + cc; ++j) {
                HeadObject cObj = colHeader.get(j, false);
                if (!notMoreCols.contains(j) && MDQADataQueryHelper.isNotCompleteDimMem(cObj, colDims)) {
                    if (isVissible) continue;
                    invoker.lockCell(0, j, rc, 1);
                    continue;
                }
                notMoreCols.add(j);
                ArrayList<String> mems = new ArrayList<String>(16);
                mems.addAll(list);
                mems.addAll(cObj.getCombineList(colDims));
                String colDimMem = this.getCombineKey(rowColDims, mems);
                if (!re.containsKey(colDimMem)) continue;
                if (BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode() == re.get(colDimMem).getStatusCode()) {
                    invoker.updataValue(i, j, "******");
                    lockCells.put((Object)i, (Object)j, (Object)"");
                }
                if (isVissible) continue;
                CellColorRangeUtils.addColorLockCell(colorLockMap, (String)re.get(colDimMem).getColor(), (int)i, (int)j);
            }
        }
        this.colorLockMergeCell(invoker, colorLockMap, (Table<Integer, Integer, String>)lockCells);
    }

    private void colorLockMergeCell(SpreadEasyInvoker invoker, Map<String, List<String>> colorLockMap, Table<Integer, Integer, String> lockCells) {
        if (MapUtils.isNotEmpty(colorLockMap)) {
            List<String> sameColorCellList = null;
            for (Map.Entry<String, List<String>> color : colorLockMap.entrySet()) {
                sameColorCellList = color.getValue();
                if (!CollectionUtils.isNotEmpty(sameColorCellList)) continue;
                List colorCellLockList = CellColorRangeUtils.mergeCell(sameColorCellList);
                HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
                styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), color.getKey());
                for (CellColorRange cellRange : colorCellLockList) {
                    if (lockCells != null && lockCells.contains((Object)cellRange.getR(), (Object)cellRange.getC())) {
                        styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 2);
                    }
                    invoker.setStyle(cellRange.getR(), cellRange.getC(), cellRange.getRc(), cellRange.getCc(), styleMap);
                    invoker.lockCell(cellRange.getR(), cellRange.getC(), cellRange.getRc(), cellRange.getCc());
                }
            }
        }
    }

    private void setColorForMDDomain(Sheet sheet, SpreadEasyInvoker invoker, String color) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), color);
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        int rowDimSize = rowHeader.getDimNums().size();
        int colDimSize = colHeader.getDimNums().size();
        int rc = rowHeader.getObjects().size() - colDimSize;
        int cc = colHeader.getObjects().size() - rowDimSize;
        invoker.setStyle(colDimSize, rowDimSize, rc, cc, styleMap);
    }

    private void setColorForMDDomain(Sheet sheet, SpreadEasyInvoker invoker, String color, RangeModel rangeModel) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), color);
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        int rowDimSize = rowHeader.getDimNums().size();
        int colDimSize = colHeader.getDimNums().size();
        int x_start = rowDimSize >= rangeModel.getX_start() ? rowDimSize : rangeModel.getX_start();
        int y_start = colDimSize >= rangeModel.getY_start() ? colDimSize : rangeModel.getY_start();
        int rc = rangeModel.getY_end() - y_start + 1;
        int cc = rangeModel.getX_end() - x_start + 1;
        invoker.setStyle(y_start, x_start, rc, cc, styleMap);
    }

    private QueryStatusCommandInfo initQueryStatusCommandInfo(Pair<Integer, Integer> pair, boolean canSaveData) {
        String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        QueryStatusCommandInfo comm = new QueryStatusCommandInfo(modelNum);
        this.setBizStatusQueryTypes(comm, canSaveData);
        String cyNum = "";
        String bpNum = "";
        Long orgId = null;
        for (Map.Entry<String, Pair<Long, String>> entry : this.pageDims.entrySet()) {
            IDNumberTreeNode treeNode;
            String k = entry.getKey();
            Pair<Long, String> v = entry.getValue();
            if (DimTypesEnum.ENTITY.getNumber().equals(k)) {
                orgId = (Long)v.p1;
            } else if (DimTypesEnum.PROCESS.getNumber().equals(k)) {
                bpNum = (String)v.p2;
            } else if (DimTypesEnum.CURRENCY.getNumber().equals(k)) {
                cyNum = (String)v.p2;
            }
            String memNum = (String)v.p2;
            if (DimTypesEnum.ENTITY.getNumber().equals(k) && (treeNode = MemberReader.findEntityMemberById((String)modelNum, (Long)((Long)v.p1))) != IDNumberTreeNode.NotFoundTreeNode) {
                memNum = treeNode.getParent_SonNumber();
            }
            comm.addFixDimension(k, memNum);
        }
        if (("DC".equals(cyNum) || "EC".equals(cyNum)) && orgId != null && StringUtils.isNotEmpty((String)bpNum)) {
            Pair cpair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.modelId, (long)orgId, (String)bpNum, (String)cyNum, (long)0L, (long)0L);
            if (cpair.p2 != null) {
                comm.addFixDimension(DimTypesEnum.CURRENCY.getNumber(), (String)cpair.p2);
            }
        }
        Header rowHeader = this.sheet.getRowHeader();
        Header colHeader = this.sheet.getColHeader();
        List rowDims = rowHeader.getDimNums();
        List colDims = colHeader.getDimNums();
        ArrayList<String> rowColDims = new ArrayList<String>(rowDims);
        rowColDims.addAll(colDims);
        comm.setCrossDimensions(rowColDims);
        if (pair != null) {
            HeadObject r2 = rowHeader.get(((Integer)pair.p1).intValue(), false);
            HeadObject c = colHeader.get(((Integer)pair.p2).intValue(), false);
            if (!MDQADataQueryHelper.isNotCompleteDimMem(r2, rowDims) && !MDQADataQueryHelper.isNotCompleteDimMem(c, colDims)) {
                List list = r2.getCombineList(rowDims);
                list.addAll(c.getCombineList(colDims));
                comm.addCrossMembers(list);
            }
        } else {
            rowHeader.iteratorObjects(r -> {
                if (MDQADataQueryHelper.isNotCompleteDimMem(r, rowDims)) {
                    return;
                }
                List list = r.getCombineList(rowDims);
                colHeader.iteratorObjects(c -> {
                    if (MDQADataQueryHelper.isNotCompleteDimMem(c, colDims)) {
                        return;
                    }
                    ArrayList mems = new ArrayList(16);
                    mems.addAll(list);
                    mems.addAll(c.getCombineList(colDims));
                    comm.addCrossMembers(mems);
                });
            });
        }
        this.setKeyPacker(comm, rowColDims);
        return comm;
    }

    private QueryStatusCommandInfo initQueryStatusCommandInfo(Pair<Integer, Integer> pair, RangeModel rangeModel, boolean canSaveData) {
        String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        QueryStatusCommandInfo comm = new QueryStatusCommandInfo(modelNum);
        this.setBizStatusQueryTypes(comm, canSaveData);
        String cyNum = "";
        String bpNum = "";
        Long orgId = null;
        for (Map.Entry<String, Pair<Long, String>> entry : this.pageDims.entrySet()) {
            IDNumberTreeNode treeNode;
            String k = entry.getKey();
            Pair<Long, String> v = entry.getValue();
            if (DimTypesEnum.ENTITY.getNumber().equals(k)) {
                orgId = (Long)v.p1;
            } else if (DimTypesEnum.PROCESS.getNumber().equals(k)) {
                bpNum = (String)v.p2;
            } else if (DimTypesEnum.CURRENCY.getNumber().equals(k)) {
                cyNum = (String)v.p2;
            }
            String memNum = (String)v.p2;
            if (DimTypesEnum.ENTITY.getNumber().equals(k) && (treeNode = MemberReader.findEntityMemberById((String)modelNum, (Long)((Long)v.p1))) != IDNumberTreeNode.NotFoundTreeNode) {
                memNum = treeNode.getParent_SonNumber();
            }
            comm.addFixDimension(k, memNum);
        }
        if (("DC".equals(cyNum) || "EC".equals(cyNum)) && orgId != null && StringUtils.isNotEmpty((String)bpNum)) {
            Pair cpair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.modelId, (long)orgId, (String)bpNum, (String)cyNum, (long)0L, (long)0L);
            if (cpair.p2 != null) {
                comm.addFixDimension(DimTypesEnum.CURRENCY.getNumber(), (String)cpair.p2);
            }
        }
        Header rowHeader = this.sheet.getRowHeader();
        Header colHeader = this.sheet.getColHeader();
        List rowDims = rowHeader.getDimNums();
        List colDims = colHeader.getDimNums();
        ArrayList<String> rowColDims = new ArrayList<String>(rowDims);
        rowColDims.addAll(colDims);
        comm.setCrossDimensions(rowColDims);
        if (pair != null) {
            HeadObject r = rowHeader.get(((Integer)pair.p1).intValue(), false);
            HeadObject c = colHeader.get(((Integer)pair.p2).intValue(), false);
            if (!MDQADataQueryHelper.isNotCompleteDimMem(r, rowDims) && !MDQADataQueryHelper.isNotCompleteDimMem(c, colDims)) {
                List list = r.getCombineList(rowDims);
                list.addAll(c.getCombineList(colDims));
                comm.addCrossMembers(list);
            }
        } else {
            for (int i = rangeModel.getY_start(); i <= rangeModel.getY_end(); ++i) {
                for (int j = 0; j <= rangeModel.getX_end(); ++j) {
                    HeadObject headObject = rowHeader.get(i, false);
                    if (MDQADataQueryHelper.isNotCompleteDimMem(headObject, rowDims)) continue;
                    List list = headObject.getCombineList(rowDims);
                    HeadObject colObject = colHeader.get(j, false);
                    if (MDQADataQueryHelper.isNotCompleteDimMem(colObject, colDims)) continue;
                    ArrayList mems = new ArrayList(16);
                    mems.addAll(list);
                    mems.addAll(colObject.getCombineList(colDims));
                    comm.addCrossMembers(mems);
                }
            }
        }
        this.setKeyPacker(comm, rowColDims);
        return comm;
    }

    public void setBizStatusQueryTypes(QueryStatusCommandInfo comm, boolean canSaveData) {
        if (canSaveData) {
            comm.setBizStatusQueryTypes(types);
        } else {
            if (MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)String.valueOf(this.modelId))) {
                comm.setBizStatusQueryTypes(orgValid);
            }
            comm.setBizStatusQueryTypes(typeNoPerm);
        }
    }

    public void setKeyPacker(QueryStatusCommandInfo comm, List<String> rowColDims) {
        comm.setKeyPacker(membs -> {
            ArrayList<String> members = new ArrayList<String>(16);
            rowColDims.forEach(dim -> members.add((String)membs.get(dim)));
            return this.getCombineKey(rowColDims, members);
        });
    }

    public String getCombineKey(List<String> dims, List<String> members) {
        StringBuilder sb = new StringBuilder();
        if (dims.size() == members.size()) {
            for (int i = 0; i < dims.size(); ++i) {
                sb.append(dims.get(i)).append(MEMDELIMITER).append(members.get(i)).append(DIMDELIMITER);
            }
        }
        return sb.toString();
    }

    public String getLockMsg(int r, int c) {
        boolean canSaveData = ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"CM008");
        String lockMsg = ResManager.loadKDString((String)"\u5355\u5143\u683c\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u68c0\u67e5\u591a\u7ef4\u4fdd\u5b58\u6570\u636e\u53c2\u6570\u662f\u5426\u5f00\u542f\u3002", (String)"MDQueryAnalysisStyleHandle_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (canSaveData) {
            Header rowHeader = this.sheet.getRowHeader();
            Header colHeader = this.sheet.getColHeader();
            if (MDQADataQueryHelper.isNotCompleteDimMem(rowHeader.get(r, false), rowHeader.getDimNums()) || MDQADataQueryHelper.isNotCompleteDimMem(colHeader.get(c, false), colHeader.getDimNums())) {
                return ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5168\u9501\u5b9a\u3002", (String)"MDQueryAnalysisStyleHandle_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            QueryStatusCommandInfo comm = this.initQueryStatusCommandInfo((Pair<Integer, Integer>)Pair.onePair((Object)r, (Object)c), true);
            BizStatusContext ct = new BizStatusContext(comm);
            try {
                int code;
                String msg;
                Map re = BizStatusServer.queryStatus((BizStatusContext)ct);
                if (!re.isEmpty() && StringUtils.isNotEmpty((String)(msg = BizStatusServer.getLockMsg((BizStatusContext)ct, (int)(code = ((StatusResult)re.values().iterator().next()).getStatusCode()))))) {
                    lockMsg = String.format(ResManager.loadKDString((String)"\u6240\u9009\u5355\u5143\u683c\u662f\u201c\u53ea\u8bfb\u201d\u72b6\u6001\uff0c%s", (String)"AbstractMultiReportPlugin_207", (String)"fi-bcm-formplugin", (Object[])new Object[0]), msg);
                }
                return lockMsg;
            }
            catch (Exception e) {
                return lockMsg;
            }
        }
        return lockMsg;
    }

    public void unitDataControl() {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.iClientViewProxy, this.spreadKey);
        invoker.setBatch(true);
        this.lockCell(invoker, this.sheet, this.queryStatus(null, false), true);
        invoker.startToInvoke();
    }

    static {
        orgValid.add(BizStatusAccessFactory.StatusCodeEnum.ValidEntityControl.getCode());
        typeNoPerm.add(BizStatusAccessFactory.StatusCodeEnum.ValidEntityControl.getCode());
        typeNoPerm.add(BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.RootEntity.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.ValidEntityControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.ValidCrossControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.MemberSelfControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.ValidCalAccControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.InnerLogicGenerate.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.PCControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.BLFYControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.InitPeriodControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.PeriodManageControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.InputMemberControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.DataFlowControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.DataStageArchiveAccess.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.DataStageStatusAccess.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.PermissionControl.getCode());
    }
}

