/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.bizstatus.BizStatusServer;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.report.cache.NoPluginCache;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.dc.DCQueryHelper;
import kd.fi.bcm.common.enums.AnalyticsSolutionScopeEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QueryAnalysisPermHelper {
    private static final String SAVEDATABTNS = "btn_savedata";
    private static final String QUERYPERM = "btn_number";
    private static final String MODIFYPERM = "btn_save";
    private static final String EXPORTPERM = "btn_export";
    private static final Set<String> readAndWritePermKeys = new HashSet<String>(16);

    static long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    public static String beforeDeleteData(IPageCache pageCache, int[] selectRows, DynamicObjectCollection solutionslist, long modelId, List<DynamicObject> dyos) {
        HashSet ids = new HashSet(solutionslist.size());
        Arrays.stream(selectRows).forEach(row -> ids.add(((DynamicObject)solutionslist.get(row)).getLong("id")));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_analyticssoluentry", (String)"id,solutionname,scope,createuserid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (dynamicObjects.length == 0) {
            return null;
        }
        Arrays.stream(dynamicObjects).forEach(e -> dyos.add((DynamicObject)e));
        return QueryAnalysisPermHelper.beforeModifyData(pageCache, dyos, modelId, ResManager.loadKDString((String)"\u5220\u9664", (String)"QueryAnalysisPermHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public static String beforeModifyData(IPageCache pageCache, Collection<DynamicObject> dynamicObjects, long modelId) {
        return QueryAnalysisPermHelper.beforeModifyData(pageCache, dynamicObjects, modelId, ResManager.loadKDString((String)"\u4fee\u6539", (String)"QueryAnalysisPermHelper_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public static String beforeModifyData(IPageCache pageCache, Collection<DynamicObject> dynamicObjects, long modelId, String editType) {
        if (MemberPermHelper.isModelManager((Long)modelId) || CollectionUtils.isEmpty(dynamicObjects)) {
            return null;
        }
        PermClassCache.cacheNewPermission((IPageCache)pageCache, (String)"bcm_analyticssoluentry", (String)Long.toString(modelId));
        List writeIds = PermClassCache.getPermissionMap((IPageCache)pageCache, (String)"bcm_analyticssoluentry", (DataTypeEnum)DataTypeEnum.WRITEIN);
        long userId = QueryAnalysisPermHelper.getUserId();
        Iterator<DynamicObject> iterator = dynamicObjects.iterator();
        StringBuilder tips = new StringBuilder();
        while (iterator.hasNext()) {
            boolean flag;
            DynamicObject e = iterator.next();
            int scope = Integer.parseInt(e.getString("scope"));
            boolean isPermClass = true;
            if (AnalyticsSolutionScopeEnum.PERM_CLASS.getKey() == scope) {
                flag = writeIds.contains(e.getLong("id"));
            } else {
                flag = userId == e.getLong("createuserid");
                isPermClass = false;
            }
            if (flag) continue;
            iterator.remove();
            if (StringUtils.isNotEmpty((CharSequence)tips)) {
                tips.append("\uff1b");
            }
            tips.append(String.format(isPermClass ? ResManager.loadKDString((String)"\u65e0\u6743\u9650\u7c7b\u6743\u9650\u4e0d\u53ef%1$s\u65b9\u6848\u3010%2$s\u3011", (String)"QueryAnalysisPermHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u975e\u65b9\u6848\u521b\u5efa\u4eba\u4e0d\u53ef%1$s\u65b9\u6848\u3010%2$s\u3011", (String)"QueryAnalysisPermHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), editType, e.getString("solutionname")));
        }
        if (StringUtils.isNotEmpty((CharSequence)tips)) {
            tips.append("\u3002");
        }
        return tips.toString();
    }

    public static void checkMenuPerm(long modelId, String curAppId) {
        try {
            QueryAnalysisPermHelper.checkItemPerm(modelId, QUERYPERM, curAppId);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u4f53\u7cfb\u7684\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u67e5\u8be2\u529f\u80fd\u6743\u9650\u3002", (String)"QueryAnalysisPermHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkItemPerm(long modelId, String key, String curAppId) {
        if (MemberPermHelper.isModelManager((Long)modelId)) {
            return;
        }
        String itemKey = key;
        if (readAndWritePermKeys.contains(key)) {
            itemKey = MODIFYPERM;
        } else if (!SAVEDATABTNS.equals(key) && !EXPORTPERM.equals(key)) {
            itemKey = QUERYPERM;
        }
        int is = BcmBasePluginUtil.checkPermission(QueryAnalysisPermHelper.getUserId(), modelId, AppMetadataCache.getAppInfo((String)curAppId).getId(), "bcm_analyticssolutiondata", QueryAnalysisPermHelper.getPermItemId(itemKey));
        if (is == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBaseListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private static String getPermItemId(String key) {
        return (String)ThreadCache.get((Object)("QueryAnalysisPermHelper_getPermItemId_" + key), () -> {
            String[] perm;
            Map permitem = BcmPermSingleModel.getInstance().getPermitem();
            Map map = (Map)permitem.get("bcm_analyticssolutiondata");
            String s = (String)map.get(key);
            if (StringUtils.isNotEmpty((CharSequence)s) && (perm = s.split("@")).length >= 2) {
                s = perm[1];
            }
            return StringUtils.isEmpty((CharSequence)s) ? "" : s;
        });
    }

    public static boolean isNoPermEdit(long modelId, DynamicObject solution, String curAppId) {
        try {
            QueryAnalysisPermHelper.checkItemPerm(modelId, MODIFYPERM, curAppId);
        }
        catch (Exception e) {
            return true;
        }
        return StringUtils.isNotEmpty((CharSequence)QueryAnalysisPermHelper.beforeModifyData((IPageCache)new NoPluginCache(), Lists.newArrayList((Object[])new DynamicObject[]{solution}), modelId));
    }

    public static String checkPermForAnalysisHelper(QueryStatusCommandInfo commandInfo, Map<String, String> commonMemberMap, Map<String, Map<String, String>> selectedCellsInfoMap, boolean isNeedAddCurrency) {
        ArrayList fixDims = new ArrayList(16);
        if (!commonMemberMap.isEmpty()) {
            commonMemberMap.forEach((k, v) -> {
                if (!isNeedAddCurrency || !DCQueryHelper.dcdims.contains(k)) {
                    commandInfo.addFixDimension(k, v);
                    fixDims.add(k);
                }
            });
        }
        ArrayList crossDims = new ArrayList(16);
        if (!selectedCellsInfoMap.isEmpty()) {
            Map<String, String> map = selectedCellsInfoMap.entrySet().iterator().next().getValue();
            map.forEach((k, v) -> {
                if (!fixDims.contains(k)) {
                    crossDims.add(k);
                }
            });
            commandInfo.setCrossDimensions(crossDims);
        }
        selectedCellsInfoMap.forEach((k, v) -> {
            ArrayList rowOrColDimNumber = new ArrayList(v.size());
            crossDims.forEach(s -> rowOrColDimNumber.add(v.get(s)));
            commandInfo.addCrossMembers(rowOrColDimNumber);
        });
        commandInfo.setBizStatusQueryTypes(Collections.singletonList(BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode()));
        BizStatusContext statusContext = new BizStatusContext(commandInfo);
        Map resultMap = BizStatusServer.queryStatus((BizStatusContext)statusContext);
        String message = "";
        if (!resultMap.isEmpty()) {
            message = ResManager.loadKDString((String)"\u6240\u9009\u5355\u5143\u683c\u4e2d\u5b58\u5728\u65e0\u6743\u5355\u5143\u683c\uff0c\u8bf7\u91cd\u65b0\u6846\u9009\u5355\u5143\u683c\u3002", (String)"AbstractMultiReportPlugin_2023", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return message;
    }

    public static void checkModelFunctionPerm(long modelId, String appId, String entityName, boolean isOnlyRead) {
        if (!MemberPermHelper.isModelManager((Long)modelId)) {
            HashSet<String> permItemIds = new HashSet<String>(16);
            permItemIds.add("4715a0df000000ac");
            if ("bcm_paperlist".equals(entityName)) {
                permItemIds.add("4730fc9f000020ae");
                permItemIds.add("47156aff000000ac");
            }
            if (!permItemIds.stream().anyMatch(e -> BcmBasePluginUtil.checkPermission(QueryAnalysisPermHelper.getUserId(), modelId, AppMetadataCache.getAppInfo((String)appId).getId(), entityName, e) != 0)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"MultiViewTemplateProcess_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (isOnlyRead) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u6a21\u677f\u7f16\u8f91\u6743\u9650\u3002", (String)"MultiViewTemplateProcess_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkModelFunctionPermForExport(long modelId, String appId, boolean isExport, boolean isWorkPaper) {
        if (!MemberPermHelper.isModelManager((Long)modelId)) {
            String entityName;
            String permItemId;
            if (isWorkPaper) {
                permItemId = "2F9VF7T8OT52";
                entityName = "bcm_workpaper_list";
            } else if (isExport) {
                permItemId = "1G2FW/G3YIL8";
                entityName = "bcm_report_list";
            } else {
                permItemId = "1VV514IHEN5T";
                entityName = "bcm_report_list";
            }
            if (BcmBasePluginUtil.checkPermission(QueryAnalysisPermHelper.getUserId(), modelId, AppMetadataCache.getAppInfo((String)appId).getId(), entityName, permItemId) == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"MultiViewTemplateProcess_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    static {
        readAndWritePermKeys.addAll(Arrays.asList("btn_add", MODIFYPERM, "btn_saveother", "btn_savelog"));
        readAndWritePermKeys.add("btn_delete");
        readAndWritePermKeys.add(MODIFYPERM);
    }
}

