/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.db.DataSetUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.analytics.MDQADataQueryHelper;
import kd.fi.bcm.formplugin.analytics.MultiDimQueryAnalysisPlugin;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsSolutionService;
import kd.fi.bcm.formplugin.analytics.service.MultiDimQAStyleService;
import kd.fi.bcm.formplugin.analytics.vo.AnalysisTaskResult;
import kd.fi.bcm.formplugin.analytics.vo.MultQueryRowColMem;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.HeadObject;
import kd.fi.bcm.spread.model.StatusBarModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class QueryAnalysisPlugin
extends MultiDimQueryAnalysisPlugin {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, QueryAnalysisPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_save_as", "btn_save_new");
    }

    @Override
    public void dealMsg(CommandParam com) {
        List<Object> param = com.getParam();
        if (CollectionUtils.isNotEmpty(param) && param.size() > 1 && "1".equals(param.get(1))) {
            String solutionSerial = (String)com.getParam().get(0);
            if (StringUtils.isNotEmpty((CharSequence)solutionSerial)) {
                AnalyticsSolutionService.getAnalyticsSolutionService().cacheAnalyticsSolutionSerial(this.getPageCache(), solutionSerial);
                this.clearSpreadModel();
                this.buildAllData();
            }
        } else {
            super.dealMsg(com);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildAllData() {
        DynamicObject so = AnalyticsSolutionService.getAnalyticsSolutionService().getAnalyticsSolutionDynamicObject(this.getView(), this.getPageCache());
        this.getView().getPageCache().put("solutiontype", so.getString("solutiontype"));
        if (!"1".equals(so.get("solutiontype"))) {
            super.buildAllData();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filterperm"});
            this.showToolBtn(this.getModelId());
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_packandunfold", "btn_hidenodata", "btn_display", "btn_linkdata", "btn_dataunit", "btn_analysishelper", "filteragg", "filternodatamember", "btn_restore"});
        } else {
            this.getPageCache().put("queryData", "queryData");
            this.showLoading();
            try {
                this.hideAllMenu(this.getModelId());
                this.clearReportBarMsg();
                String solutionname = so.getString("solutionname");
                this.getView().getModel().setValue("solutionname", (Object)solutionname);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_savedata", "filterperm"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_packandunfold", "btn_hidenodata", "btn_display", "btn_linkdata", "btn_dataunit", "btn_analysishelper", "filteragg", "filternodatamember", "btn_restore"});
                this.getView().getModel().setValue("filternodatamember", (Object)true);
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("modelId", this.getModelId());
                params.put("solution", this.getPageCache().get("solution_serial"));
                this.createTask(params, "task");
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
            finally {
                this.hideLoading();
            }
        }
    }

    private void createTask(Map<String, Object> params, String closeCallBackId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u67e5\u8be2\u5206\u6790", (String)"ExtDimDesignerControlPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.fi.bcm.formplugin.analytics.AnalysisTask");
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(this.getUserId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, closeCallBackId);
        this.dispatch(jobInfo, this.getView(), closeCallBack);
    }

    public void dispatch(JobInfo jobInfo, IFormView view, CloseCallBack closeCallBack) {
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(false);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(this.getView().getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        String type = this.getView().getPageCache().get("solutiontype");
        if ("btn_refresh".equals(itemKey)) {
            DynamicObject so = AnalyticsSolutionService.getAnalyticsSolutionService().getAnalyticsSolutionDynamicObject(this.getView(), this.getPageCache());
            if (!"1".equals(so.get("solutiontype"))) {
                CommandParam commandParam = new CommandParam("bcm_analyticssolutiondata", "bcm_analyticsdimdesign", "btn_ok", new Object[0]);
                this.sendMsg(this.getView(), commandParam);
            } else {
                CommandParam commandParam = new CommandParam("bcm_analyticssolutiondata", "bcm_analyticsextdesign", "btn_ok", new Object[0]);
                this.sendMsg(this.getView(), commandParam);
            }
        } else if ("btn_export".equals(itemKey) && "1".equals(type)) {
            HashMap<String, String> map2 = new HashMap<String, String>(16);
            map2.put(SpreadProperties.ExportExcelFileMethod.FILENAME.k(), ResManager.loadKDString((String)"\u5373\u5e2d\u5206\u6790", (String)"MultiDimQueryAnalysisPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            SpreadClientInvoker.invokeExportExcelFileMethod(this.getClientViewProxy(), "report", map2);
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "MultiDimQueryAnalysisPlugin_3", "fi-bcm-formplugin", "export"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "MultiDimQueryAnalysisPlugin_4", "fi-bcm-formplugin", null));
        } else {
            super.itemClick(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        block23: {
            String taskInfoStr;
            super.closedCallBack(closedCallBackEvent);
            String actionId = closedCallBackEvent.getActionId();
            Object retureData = closedCallBackEvent.getReturnData();
            if ("task".equals(actionId) && retureData instanceof Map && StringUtils.isNotEmpty((CharSequence)(taskInfoStr = (String)((Map)retureData).get("taskinfo")))) {
                this.showLoading();
                try {
                    TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
                    String data = taskInfo.getData();
                    if (!StringUtils.isNotEmpty((CharSequence)data)) break block23;
                    JSONObject dataObj = (JSONObject)JSONObject.parse((String)data);
                    if (dataObj.getBoolean("success").booleanValue()) {
                        ThreadCache.put((Object)"buildAllData", (Object)true);
                        Object resultStr = dataObj.get((Object)"result");
                        if (resultStr == null || StringUtils.isEmpty((CharSequence)resultStr.toString())) {
                            return;
                        }
                        AnalysisTaskResult result = (AnalysisTaskResult)ObjectSerialUtil.deSerializedBytes((String)resultStr.toString());
                        ArrayList rowMems = new ArrayList(16);
                        ArrayList colMems = new ArrayList(16);
                        ArrayList<String> rowSelects = new ArrayList<String>(16);
                        ArrayList<String> colSelects = new ArrayList<String>(16);
                        HashMap<String, Object> datas = new HashMap<String, Object>(16);
                        String cacheId = result.getCacheId();
                        if (StringUtils.isEmpty((CharSequence)cacheId)) {
                            this.buildEmptySheet();
                            return;
                        }
                        List rows = DataSetUtil.getAllData((String)cacheId);
                        if (CollectionUtils.isEmpty((Collection)rows)) {
                            this.buildEmptySheet();
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u65e0\u62d3\u5c55\u6570\u636e\uff0c\u8bf7\u5207\u6362\u65b9\u6848\u6216\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u540e\u91cd\u8bd5\u3002", (String)"MultiDimQueryAnalysisPlugin_68", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        List<String> fieldList = result.getFieldList();
                        Map<String, String> colsFieldMapped = result.getColsFieldMapped();
                        Map<String, String> dimsFieldMapped = result.getDimsFieldMapped();
                        List<String> rowDimSelects = result.getRowDimSelects();
                        List<String> rowExtSelects = result.getRowExtSelects();
                        List<String> colDimSelects = result.getColDimSelects();
                        List<String> fmoneyNums = result.getFmoneyNums();
                        List<String> colExtSelects = result.getColExtSelects();
                        boolean fmoneyInPage = result.isFmoneyInPage();
                        Integer[] rowDimSelectIndexs = this.collectIndex(rowDimSelects, colsFieldMapped, dimsFieldMapped, fieldList);
                        Integer[] rowExtSelectIndexs = this.collectIndex(rowExtSelects, colsFieldMapped, dimsFieldMapped, fieldList);
                        Integer[] colDimSelectIndexs = this.collectIndex(colDimSelects, colsFieldMapped, dimsFieldMapped, fieldList);
                        Integer[] colExtSelectIndexs = this.collectIndex(colExtSelects, colsFieldMapped, dimsFieldMapped, fieldList);
                        Integer[] fmoneySelectIndexs = this.collectIndex(fmoneyNums, colsFieldMapped, dimsFieldMapped, fieldList);
                        rowSelects.addAll(rowDimSelects);
                        rowSelects.addAll(rowExtSelects);
                        colSelects.addAll(colDimSelects);
                        colSelects.addAll(colExtSelects);
                        String cube = MemberReader.findModelNumberById((Object)this.getModelId());
                        if (CollectionUtils.isNotEmpty(fieldList) && CollectionUtils.isNotEmpty((Collection)rows)) {
                            for (Row row : rows) {
                                StringBuilder sb = new StringBuilder();
                                ArrayList<MultQueryRowColMem> rowMem = new ArrayList<MultQueryRowColMem>(16);
                                ArrayList<MultQueryRowColMem> colMem = new ArrayList<MultQueryRowColMem>(16);
                                this.collectRowColDimMem(rowDimSelects, rowDimSelectIndexs, cube, row, sb, rowMem);
                                this.collectRowColExtMem(rowExtSelects, rowExtSelectIndexs, row, sb, rowMem);
                                this.collectRowColDimMem(colDimSelects, colDimSelectIndexs, cube, row, sb, colMem);
                                this.collectRowColExtMem(colExtSelects, colExtSelectIndexs, row, sb, colMem);
                                if (CollectionUtils.isNotEmpty(rowMem)) {
                                    rowMems.add(rowMem);
                                }
                                if (CollectionUtils.isNotEmpty(colMem)) {
                                    colMems.add(colMem);
                                }
                                String key = sb.toString();
                                if (!fmoneyInPage) {
                                    for (int i = 0; i < fmoneySelectIndexs.length; ++i) {
                                        datas.put(key + fmoneyNums.get(i), row.get(fmoneySelectIndexs[i].intValue()));
                                    }
                                    continue;
                                }
                                datas.put(key, row.get(fmoneySelectIndexs[0].intValue()));
                            }
                        } else {
                            this.buildEmptySheet();
                            return;
                        }
                        if (result.isFmoneyInRow() && CollectionUtils.isEmpty(rowMems)) {
                            rowMems.add(new ArrayList(8));
                        }
                        if (!result.isFmoneyInRow() && !fmoneyInPage && CollectionUtils.isEmpty(colMems)) {
                            colMems.add(new ArrayList(8));
                        }
                        LinkedHashSet colSet = new LinkedHashSet(colMems);
                        LinkedHashSet rowSet = new LinkedHashSet(rowMems);
                        this.buildData(this.getModelId(), new ArrayList<List<MultQueryRowColMem>>(rowSet), new ArrayList<List<MultQueryRowColMem>>(colSet), fmoneyNums, fmoneyInPage, result.isFmoneyInRow(), datas, rowSelects, colSelects, result.isResourceOrgInCol(), result.isResourceOrgInRow());
                        SpreadClientInvoker.invokeSetSheetNameMethod(this.getClientViewProxy(), "report", dataObj.getString("solutionname"));
                        MultiDimQAStyleService.cutSheetCell(this.getClientViewProxy(), "report", this.getEffectiveSheet());
                        break block23;
                    }
                    this.buildEmptySheet();
                    this.getView().showErrorNotification(dataObj.getString("message"));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    this.buildEmptySheet();
                    this.getView().showErrorNotification(e.getMessage());
                }
                finally {
                    this.hideLoading();
                }
            }
        }
    }

    private void clearReportBarMsg() {
        StatusBarModel statusBarModel = new StatusBarModel();
        String msg = "";
        statusBarModel.setCellNameStr(msg);
        SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), "report", statusBarModel);
    }

    private void buildEmptySheet() {
        Sheet sheet = this.getEffectiveSheet();
        sheet.clear();
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "report", MultiDimQAStyleService.getInitSpreadJson(0, 0));
        MultiDimQAStyleService.cutSheetCell(this.getClientViewProxy(), "report", this.getEffectiveSheet());
        this.clearSpreadModel();
    }

    private void collectRowColExtMem(List<String> extSelects, Integer[] extSelectIndexs, Row row, StringBuilder sb, List<MultQueryRowColMem> colMem) {
        for (int i = 0; i < extSelectIndexs.length; ++i) {
            Object rowValue = row.get(extSelectIndexs[i].intValue());
            sb.append(rowValue);
            MultQueryRowColMem<Object> mem = new MultQueryRowColMem<Object>();
            String number = extSelects.get(i);
            mem.setNumber(number);
            mem.setValue(rowValue);
            mem.setIsDim(false);
            colMem.add(mem);
        }
    }

    private void collectRowColDimMem(List<String> rowSelects, Integer[] dimSelectIndexs, String cube, Row row, StringBuilder sb, List<MultQueryRowColMem> rowMem) {
        for (int i = 0; i < dimSelectIndexs.length; ++i) {
            String memNum = (String)row.get(dimSelectIndexs[i].intValue());
            sb.append(memNum);
            MultQueryRowColMem<String> mem = new MultQueryRowColMem<String>();
            String dimNumber = rowSelects.get(i);
            mem.setNumber(dimNumber);
            mem.setValue(memNum);
            if ("entity".equals(dimNumber) || "org".equals(dimNumber)) {
                dimNumber = "Entity";
            }
            IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)cube, (String)dimNumber, (String)memNum);
            mem.setName(memberByNumber.getName());
            mem.setIsDim(true);
            rowMem.add(mem);
        }
    }

    private Integer[] collectIndex(List<String> nums, Map<String, String> colsFieldMapped, Map<String, String> dimsFieldMapped, List<String> fieldList) {
        ArrayList<Integer> indexs = new ArrayList<Integer>(16);
        for (String num : nums) {
            int indexOf;
            if (ExtDataUtil.fixDims.contains(num)) {
                num = num.toLowerCase();
            }
            if ((indexOf = fieldList.indexOf(colsFieldMapped.get(num))) != -1) {
                indexs.add(indexOf);
                continue;
            }
            int index = fieldList.indexOf(dimsFieldMapped.get(num));
            if (index != -1) {
                indexs.add(index);
                continue;
            }
            int ind = fieldList.indexOf(num);
            if (ind != -1) {
                indexs.add(ind);
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u5b58\u5728", (String)"ExtDimDesignerControlPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return indexs.toArray(new Integer[0]);
    }

    private void buildData(long modelId, List<List<MultQueryRowColMem>> rowMems, List<List<MultQueryRowColMem>> colMems, List<String> fmoneyNums, boolean moneyInPage, boolean moneyInRow, Map<String, Object> datas, List<String> rowSelects, List<String> colSelects, boolean orgInCol, boolean orgInRow) {
        Sheet sheet = this.getEffectiveSheet();
        sheet.clear();
        if (!moneyInPage && CollectionUtils.isEmpty(fmoneyNums) || CollectionUtils.isEmpty(rowMems) || CollectionUtils.isEmpty(colMems)) {
            SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "report", MultiDimQAStyleService.getInitSpreadJson(0, 0));
            this.clearSpreadModel();
            return;
        }
        boolean moneyInCol = !moneyInPage && !moneyInRow;
        int rowDimSize = CollectionUtils.isEmpty(rowMems) ? 0 : rowMems.get(0).size();
        rowDimSize = moneyInRow ? rowDimSize + 1 : rowDimSize;
        int colDimSize = CollectionUtils.isEmpty(colMems) ? 0 : colMems.get(0).size();
        colDimSize = moneyInCol ? colDimSize + 1 : colDimSize;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "in", fmoneyNums);
        DynamicObjectCollection fmoneyDys = QueryServiceHelper.query((String)"bcm_structofextend", (String)"name,id,number", (QFilter[])qFilter.toArray());
        HashMap<String, MultQueryRowColMem> fmoneys = new HashMap<String, MultQueryRowColMem>(16);
        for (DynamicObject fmoneyDy : fmoneyDys) {
            MultQueryRowColMem values = new MultQueryRowColMem();
            String number = fmoneyDy.getString("number");
            values.setNumber(number);
            values.setName(fmoneyDy.getString("name"));
            values.setIsFmoney(true);
            fmoneys.put(number, values);
        }
        this.buildRowCol(rowMems, rowSelects, sheet, colDimSize, true, moneyInRow, fmoneys, orgInRow);
        this.buildRowCol(colMems, colSelects, sheet, rowDimSize, false, moneyInCol, fmoneys, orgInCol);
        int fmoneySize = fmoneys.size();
        int romMemsSize = moneyInRow ? rowMems.size() * fmoneySize : rowMems.size();
        int colMemsSize = moneyInCol ? colMems.size() * fmoneySize : colMems.size();
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "report", MultiDimQAStyleService.getInitSpreadJson(romMemsSize + colDimSize, colMemsSize + rowDimSize));
        MultiDimQAStyleService.resetSpreadStyle(this.getClientViewProxy(), sheet, "report");
        MultiDimQAStyleService.setRowColHeaderValue4ext(sheet, this.getModel().getValue("showtype").toString(), this.getClientViewProxy(), "report");
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), "report");
        invoker.setBatch(true);
        MultiDimQAStyleService.setRowsHeight(invoker, 0, colDimSize, 34);
        MultiDimQAStyleService.setRowsHeight(invoker, colDimSize, romMemsSize + colDimSize, 18);
        invoker.setSpan(0, 0, colDimSize, rowDimSize);
        MultiDimQAStyleService.setColumnWidth(invoker, sheet, rowDimSize);
        MultiDimQAStyleService.lockTableHead(invoker, 0, 0, romMemsSize + colDimSize, rowDimSize);
        MultiDimQAStyleService.lockTableHead(invoker, 0, rowDimSize, colDimSize, colMemsSize);
        MultiDimQAStyleService.setTableHeadStyle4ext(invoker, sheet, true);
        invoker.startToInvoke();
        this.loadData(sheet, rowDimSize, colDimSize, datas);
    }

    private void loadData(Sheet sheet, int rowDimSize, int colDimSize, Map<String, Object> datas) {
        new SpreadEasyInvoker(this.getClientViewProxy(), "report").lockCell(colDimSize, rowDimSize, sheet.getMaxRowHeaderSize() - colDimSize, sheet.getMaxColHeaderSize() - rowDimSize);
        List<Map<String, Object>> cellValues = MDQADataQueryHelper.updateCellValues4ext(datas, sheet);
        MultiDimQAStyleService.setSpreadStyleForCellValue(this.getClientViewProxy(), "report", sheet, cellValues);
        this.cacheSpreadModel();
    }

    private void buildRowCol(List<List<MultQueryRowColMem>> mems, List<String> selects, Sheet sheet, int otherRowColDimSize, boolean isRow, boolean withFmoney, Map<String, MultQueryRowColMem> fmoneys, boolean withOrg) {
        Header header = isRow ? sheet.getRowHeader() : sheet.getColHeader();
        header.clear();
        int fmoneySize = 0;
        int memsSize = mems.size();
        ArrayList<String> fmoneyNums = new ArrayList<String>(16);
        if (withFmoney) {
            fmoneySize = fmoneys.size();
            memsSize *= fmoneySize;
            fmoneyNums.addAll(fmoneys.keySet());
            header.setFmoneyNums(fmoneyNums);
        }
        header.setWithOrg(withOrg);
        header.setDimNums(selects);
        header.setWithFmoney(withFmoney);
        for (int i = 0; i < memsSize; ++i) {
            int index = withFmoney && fmoneySize != 0 ? i / fmoneySize : i;
            List<MultQueryRowColMem> rowObjs = mems.get(index);
            HeadObject headObject = header.get(otherRowColDimSize + i, true);
            for (int j = 0; j < rowObjs.size(); ++j) {
                headObject.addMember(selects.get(j), (Map)rowObjs.get(j));
            }
            if (!withFmoney) continue;
            String fmoneyNum = (String)fmoneyNums.get(i % fmoneySize);
            headObject.addMember(fmoneyNum, (Map)fmoneys.get(fmoneyNum));
            headObject.put((Object)"fmoney", (Object)fmoneyNum);
        }
    }

    @Override
    protected void showDimDesigner() {
        DynamicObject solution = AnalyticsSolutionService.getAnalyticsSolutionService().getAnalyticsSolutionDynamicObject(this.getView(), this.getPageCache());
        if (!"1".equals(solution.get("solutiontype"))) {
            super.showDimDesigner();
        } else {
            if (this.getPageCache().get("POV") != null) {
                String pageId = this.getPageCache().get("POV");
                IFormView childFormView = this.getView().getMainView().getView(pageId);
                childFormView.close();
                this.getView().sendFormAction(childFormView);
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCustomParam("model", (Object)this.getModelId());
            showParameter.setCustomParam("modelNumber", (Object)this.getModelNumber());
            showParameter.setFormId("bcm_analyticsextdesign");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimcfgcallback"));
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("designer");
            String pageId = this.getPageIdAndCache(this.getPageCache(), "bcm_analyticsextdesign");
            showParameter.setPageId(pageId);
            showParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u8be2\u8bbe\u8ba1\u5668", (String)"MultiDimQueryAnalysisPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"designerpanel"});
            this.getView().showForm(showParameter);
            this.getPageCache().put("designer", pageId);
            this.hidePageDim();
        }
    }

    @Override
    protected void initSpreadListener() {
        if (!ObjectUtils.equals((Object)"1", (Object)this.getView().getPageCache().get("solutiontype"))) {
            super.initSpreadListener();
        }
    }
}

