/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.model.ISupportPageCacheProxy;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public class SearchHelper {
    public static Style getStyle() {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("0");
        mg.setBottom("0");
        mg.setRight("0");
        mg.setLeft("10px");
        sl.setMargin(mg);
        return sl;
    }

    public static Style getStyleForData() {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("0");
        mg.setBottom("0");
        mg.setRight("0");
        mg.setLeft("0");
        sl.setMargin(mg);
        return sl;
    }

    public static Style getStyleForQueryPanel() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("0");
        margin.setBottom("0");
        margin.setRight("0");
        margin.setLeft("0");
        style.setMargin(margin);
        return style;
    }

    public static Object getObjectCache(IFormView curview, String cacheKey) {
        if (SearchHelper.getCache(curview) == null) {
            return null;
        }
        String cac = SearchHelper.getCache(curview).get(cacheKey);
        if (cac != null) {
            return ObjectSerialUtil.deSerializedBytes((String)cac);
        }
        return null;
    }

    public static void setObjectCache(IFormView curview, String cacheKey, Object obj) {
        if (SearchHelper.getCache(curview) == null) {
            return;
        }
        SearchHelper.getCache(curview).put(cacheKey, ObjectSerialUtil.toByteSerialized((Object)obj));
    }

    public static void removeObjectCache(IFormView curview, String cacheKey) {
        if (SearchHelper.getCache(curview) == null) {
            return;
        }
        SearchHelper.getCache(curview).remove(cacheKey);
    }

    private static IPageCache getCache(IFormView curview) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)curview.getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        for (IFormPlugin p : plugins) {
            if (!(p instanceof ISupportPageCacheProxy)) continue;
            return ((ISupportPageCacheProxy)p).getPageCache();
        }
        return curview.getPageCache();
    }

    public static Comparator<DynamicObject> getCompareMethod(final String orderName) {
        return new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject obj1, DynamicObject obj2) {
                if (obj1.getInt(orderName) > obj2.getInt(orderName)) {
                    return 1;
                }
                if (obj1.getInt(orderName) == obj2.getInt(orderName)) {
                    return 0;
                }
                return -1;
            }
        };
    }

    public static void dealNewDim(DynamicObjectCollection pageDimList, DynamicObjectCollection rowDimList, DynamicObjectCollection colDimList, long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,shortnumber,name,issysdimension", (QFilter[])new QFilter[]{qFilter}, (String)"number desc");
        if (col.size() > pageDimList.size() + rowDimList.size() + colDimList.size()) {
            for (DynamicObject obj : col) {
                if (SearchHelper.checkDimIsInclude(pageDimList, obj, "dimid") || SearchHelper.checkDimIsInclude(rowDimList, obj, "rowdimid") || SearchHelper.checkDimIsInclude(colDimList, obj, "columndimid")) continue;
                DynamicObject lastPageDim = (DynamicObject)pageDimList.get(pageDimList.size() - 1);
                DynamicObject tempPageDim = pageDimList.addNew();
                String dimNumber = obj.getString("number");
                if (DimensionUtil.isUserDefinedDim(dimNumber)) {
                    String entity = DimensionUtil.getDimMembEntityNumByDimNum(dimNumber);
                    long dimMemberId = DimensionUtil.getIdByNum(entity, modelId, obj.getString("shortnumber") + "None");
                    tempPageDim.set("menberid", (Object)dimMemberId);
                } else {
                    tempPageDim.set("menberid", (Object)"");
                }
                tempPageDim.set("orderindex", (Object)(lastPageDim.getInt("orderindex_id") + 1));
                tempPageDim.set("dimid", (Object)obj);
            }
        }
    }

    private static boolean checkDimIsInclude(DynamicObjectCollection pageDimList, DynamicObject obj, String dimId) {
        boolean result = false;
        for (DynamicObject tempDim : pageDimList) {
            DynamicObject dim = tempDim.getDynamicObject(dimId);
            String number = dim.getString("number");
            if (!obj.getString("number").equals(number)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void lockOrUnlockCell(IClientViewProxy view, String spreadKey, boolean isLock, int r, int c, int rc, int cc) {
        ArrayList cells = new ArrayList(10);
        HashMap<String, Integer> cel = new HashMap<String, Integer>(16);
        cel.put(SpreadProperties.LockCellMethod.R.k(), r);
        cel.put(SpreadProperties.LockCellMethod.C.k(), c);
        cel.put(SpreadProperties.LockCellMethod.RC.k(), rc);
        cel.put(SpreadProperties.LockCellMethod.CC.k(), cc);
        cells.add(cel);
        if (isLock) {
            SpreadClientInvoker.invokeLockCellMethod(view, spreadKey, cells);
        } else {
            SpreadClientInvoker.invokeUnLockCellMethod(view, spreadKey, cells);
        }
    }

    public static void updateSelectCellValue(int rowNumber, int colNumber, Cell cell, List<Map<String, Object>> cellValues) {
        String newCellValue = cell.getValue().toString().replace("\uff0b ", "\uff0d ");
        cell.setValue((Object)newCellValue);
        cellValues.add(SearchHelper.packedUpdateCellMap(rowNumber, colNumber, newCellValue));
    }

    private static Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    public static void setCellBackColor(IClientViewProxy view, String spreadKey, int r, int c, int rc, int cc, String color, boolean isCenter) {
        ArrayList rangeList = new ArrayList(10);
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), color);
        if (isCenter) {
            styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 1);
        }
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(view, spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
    }

    public static void setCellFontColor(IClientViewProxy view, String spreadKey, int r, int c, int rc, int cc, String color) {
        ArrayList rangeList = new ArrayList(10);
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.FORECOLOR.k(), color);
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(view, spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
    }

    public static void updateDataTraceParenOpenRowCount(Sheet sheet, Cell cell, int newOpenCount, boolean isAdd) {
        Cell tempCell;
        String openParent = (String)cell.getUserObject("openParent");
        if (openParent != null && (tempCell = (Cell)cell.getUserObject("parentCell")) != null) {
            if (tempCell.getUserObject("openParent") != null) {
                SearchHelper.updateSingleParentOpenRowCount(newOpenCount, tempCell, isAdd);
                SearchHelper.updateDataTraceParenOpenRowCount(sheet, tempCell, newOpenCount, isAdd);
            } else {
                SearchHelper.updateSingleParentOpenRowCount(newOpenCount, tempCell, isAdd);
            }
        }
    }

    private static void updateSingleParentOpenRowCount(int newOpenCount, Cell tempCell, boolean isAdd) {
        int oldOpenRowCount = 0;
        if (tempCell.getUserObject("openCount") != null) {
            oldOpenRowCount = (Integer)tempCell.getUserObject("openCount");
        }
        if (isAdd) {
            tempCell.setUserObject("openCount", (Object)(oldOpenRowCount + newOpenCount));
        } else {
            tempCell.setUserObject("openCount", (Object)(oldOpenRowCount - newOpenCount));
        }
    }

    public static void clearSheet(Sheet sheet, String spreadKey, IClientViewProxy view) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < sheet.getMaxRowCount(); ++i) {
            for (int j = 0; j < sheet.getMaxColumnCount(); ++j) {
                cellValues.add(SearchHelper.packedUpdateCellMap(i, j, null));
            }
        }
        SpreadClientInvoker.invokeUpdataValueMethod(view, spreadKey, Lists.newArrayList(cellValues));
        SearchHelper.setCellBackColor(view, spreadKey, 0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount(), "#FFFFFF", false);
        SearchHelper.clearCellsStyle(view, spreadKey, 0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount());
        sheet.clear();
    }

    public static Map<String, String> getCurrencyByOrg(Sheet sheet, long orgId, long modelId) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (orgId == 0L) {
            HashSet<Long> orgSet = new HashSet<Long>(16);
            for (int i = 1; i < sheet.getMaxRowCount(); ++i) {
                IDNumberTreeNode treeNode;
                Long id;
                Cell orgCell = sheet.getCell(i, SearchHelper.createColumnIndex(sheet).get("Entity").intValue());
                if (orgCell.getUserObject("id") == null || !orgSet.add(id = Long.valueOf(orgCell.getUserObject("id").toString())) || (treeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)id)) == IDNumberTreeNode.NotFoundTreeNode) continue;
                result.put(treeNode.getNumber(), treeNode.getCurrency());
            }
        } else {
            IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
                result.put(treeNode.getNumber(), treeNode.getCurrency());
            }
        }
        return result;
    }

    public static String getEmptyJson(int maxrow, int maxcol) {
        return "{\"version\":\"10.0.1\",\"sheets\":{\"sheet1\":{\"name\":\"sheet1\",\"rowCount\":\"" + maxrow + "\",\"columnCount\":\"" + maxcol + "\"}}}";
    }

    public static void dealAllInsertCountCache(IFormView curview, String cacheKey, int insertCount, boolean isAdd) {
        int oldCount = 0;
        if (SearchHelper.getObjectCache(curview, cacheKey) != null) {
            oldCount = (Integer)SearchHelper.getObjectCache(curview, cacheKey);
        }
        int newInsertCount = oldCount + insertCount;
        if (!isAdd) {
            newInsertCount = oldCount - insertCount;
        }
        SearchHelper.setObjectCache(curview, cacheKey, newInsertCount);
    }

    public static void setIndent(IClientViewProxy viewProxy, String spreadKey, int r, int c, int rc, int cc, int ti) {
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        ArrayList<HashMap<String, Integer>> rangeList = new ArrayList<HashMap<String, Integer>>(10);
        rangeList.add(rangeMap);
        HashMap<String, Integer> styleMap = new HashMap<String, Integer>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.TI.k(), ti);
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(viewProxy, spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
    }

    public static void clearCellsStyle(IClientViewProxy viewProxy, String spreadKey, int r, int c, int rc, int cc) {
        ArrayList cells = new ArrayList(10);
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.CC.k(), cc);
        cells.add(rangeMap);
        SpreadClientInvoker.clearCellsStyle(viewProxy, spreadKey, cells);
    }

    public static void setCellRight(IClientViewProxy view, String spreadKey, int r, int c, int rc, int cc) {
        ArrayList rangeList = new ArrayList(10);
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        HashMap<String, Integer> styleMap = new HashMap<String, Integer>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 2);
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(view, spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
    }

    public static void setCellIndent(IClientViewProxy view, String spreadKey, Cell clickCell, Cell cell) {
        int ti = 2;
        if (clickCell.getUserObject("ti") != null) {
            ti = (Integer)clickCell.getUserObject("ti") + 2;
        }
        cell.setUserObject("ti", (Object)ti);
        SearchHelper.setIndent(view, spreadKey, cell.getRow(), cell.getCol(), 1, 1, ti);
    }

    public static void setCellIndentOne(IClientViewProxy view, String spreadKey, Cell clickCell, Cell cell, int index) {
        if (clickCell.getUserObject("ti") != null) {
            int ti = (Integer)clickCell.getUserObject("ti") + index;
            cell.setUserObject("ti", (Object)ti);
            SearchHelper.setIndent(view, spreadKey, cell.getRow(), cell.getCol(), 1, 1, ti);
        }
    }

    public static void copyCellIndent(IClientViewProxy view, String spreadKey, Cell oldCell, Cell cell) {
        int ti = 0;
        if (oldCell.getUserObject("ti") != null) {
            ti = (Integer)oldCell.getUserObject("ti");
        }
        cell.setUserObject("ti", (Object)ti);
        SearchHelper.setIndent(view, spreadKey, cell.getRow(), cell.getCol(), 1, 1, ti);
    }

    public static void setSpreadBorder(IClientViewProxy viewProxy, String spreadKey, int r, int c, int rc, int cc, String color) {
        HashMap<String, Integer> range = new HashMap<String, Integer>(16);
        range.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        range.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        range.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        range.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        ArrayList<HashMap<String, Integer>> ranges = new ArrayList<HashMap<String, Integer>>(10);
        ranges.add(range);
        HashMap style = new HashMap(16);
        ArrayList<String> borderColor = new ArrayList<String>(10);
        borderColor.add(color);
        ArrayList<String> borderStyle = new ArrayList<String>(10);
        borderStyle.add("thin");
        HashMap<String, ArrayList<String>> hash = new HashMap<String, ArrayList<String>>(16);
        hash.put(SpreadProperties.SetCellStyleMethod.BORDERCOLOR.k(), borderColor);
        hash.put(SpreadProperties.SetCellStyleMethod.BORDERSTYLE.k(), borderStyle);
        style.put(SpreadProperties.SetCellStyleMethod.BORDER.k(), hash);
        HashMap<String, Cloneable> featureMap = new HashMap<String, Cloneable>(16);
        featureMap.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), ranges);
        featureMap.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), style);
        SpreadClientInvoker.invokeSetCellStyleMethod(viewProxy, spreadKey, Lists.newArrayList((Object[])new Map[]{featureMap}));
    }

    public static Map<String, Integer> createColumnIndex(Sheet sheet) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < sheet.getMaxColumnCount(); ++i) {
            Cell cell = sheet.getCell(0, i);
            if (cell.getUserObject("number") == null) continue;
            indexMap.put((String)cell.getUserObject("number"), i);
        }
        return indexMap;
    }
}

