/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.analytics.MDQADataQueryHelper;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsDimMemService;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsSolutionService;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.model.HeadObject;
import org.apache.commons.collections.CollectionUtils;

public class AnalyticsCheckService {
    private static volatile AnalyticsCheckService analyticsCheckService;

    private AnalyticsCheckService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalyticsCheckService getCheckService() {
        if (analyticsCheckService != null) return analyticsCheckService;
        Class<AnalyticsCheckService> clazz = AnalyticsCheckService.class;
        synchronized (AnalyticsCheckService.class) {
            if (analyticsCheckService != null) return analyticsCheckService;
            analyticsCheckService = new AnalyticsCheckService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return analyticsCheckService;
        }
    }

    public boolean checkRowColDimHasMember(IFormView view, IPageCache pageCache, long modelId) {
        String serialFromCache = AnalyticsSolutionService.getAnalyticsSolutionService().getAnalyticsSolutionSerialFromCache(pageCache);
        if (!StringUtil.isEmptyString((String)serialFromCache)) {
            DynamicObject solution = (DynamicObject)ObjectSerialUtil.deSerializedBytes((String)serialFromCache);
            AnalyticsDimMemService analyticsDimMemService = AnalyticsDimMemService.getAnalyticsDimMemService();
            DynamicObjectCollection rowDimList = solution.getDynamicObjectCollection("rowdim");
            List<IDNumberTreeNode>[] rowDimAndMember = analyticsDimMemService.getAllDimMemberInfo(rowDimList, "rowdimid", "rowmenberid", modelId, pageCache, view);
            for (int i = 0; i < rowDimAndMember.length; ++i) {
                if (!rowDimAndMember[i].isEmpty()) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\uff1a%s\uff0c\u6ca1\u627e\u5230\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AnalyticsCheckService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((DynamicObject)rowDimList.get(i)).getDynamicObject("rowdimid").getString("name")));
                return false;
            }
            DynamicObjectCollection colDimList = solution.getDynamicObjectCollection("coldim");
            List<IDNumberTreeNode>[] colDimAndMember = analyticsDimMemService.getAllDimMemberInfo(colDimList, "columndimid", "columnmenberid", modelId, pageCache, view);
            for (int i = 0; i < colDimAndMember.length; ++i) {
                if (!colDimAndMember[i].isEmpty()) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\uff1a%s\uff0c\u6ca1\u627e\u5230\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AnalyticsCheckService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((DynamicObject)colDimList.get(i)).getDynamicObject("columndimid").getString("name")));
                return false;
            }
        }
        return true;
    }

    public void checkCompleteDimMem(IPageCache pageCache, Sheet sheet, boolean isRow, int r, int c) {
        Header header = sheet.getHeader(isRow);
        List dimNums = header.getDimNums();
        HeadObject headObject = header.get(isRow ? r : c, false);
        String s = pageCache.get("saveDataFlag");
        List<Integer> list = new ArrayList(16);
        List otherList = new ArrayList(16);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            Pair pair = (Pair)ObjectSerialUtil.deSerializedBytes((String)s);
            list = isRow ? (List)pair.p1 : (List)pair.p2;
            otherList = isRow ? (List)pair.p2 : (List)pair.p1;
        }
        Integer index = isRow ? r : c;
        if (MDQADataQueryHelper.isNotCompleteDimMem(headObject, dimNums)) {
            if (!list.contains(index)) {
                list.add(index);
            }
        } else {
            list.remove(index);
        }
        if (list.isEmpty() && otherList.isEmpty()) {
            pageCache.remove("saveDataFlag");
            return;
        }
        pageCache.put("saveDataFlag", ObjectSerialUtil.toByteSerialized((Object)Pair.onePair(isRow ? list : otherList, isRow ? otherList : list)));
    }

    public boolean checkDimCompleteBeforeSaveData(IFormView view, IPageCache pageCache) {
        String s = pageCache.get("saveDataFlag");
        if (s != null) {
            Pair pair = (Pair)ObjectSerialUtil.deSerializedBytes((String)s);
            List notCompRowList = (List)pair.p1;
            List notCompColList = (List)pair.p2;
            StringBuilder sb = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)notCompRowList)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%\u884c\u7ef4\u5ea6\u6ca1\u6709\u5f55\u5165\u5b8c\u6574", (String)"MDQADataQueryHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), notCompRowList));
            }
            if (CollectionUtils.isNotEmpty((Collection)notCompColList)) {
                sb.append("\uff0c");
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%\u5217\u7ef4\u5ea6\u6ca1\u6709\u5f55\u5165\u5b8c\u6574", (String)"MDQADataQueryHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), notCompColList));
            }
            view.showErrorNotification(sb.toString());
            return false;
        }
        return true;
    }

    public boolean checkSolutionIsChange(String solutionSerial, DynamicObject oldSolution) {
        DynamicObject newSolution = (DynamicObject)ObjectSerialUtil.deSerializedBytes((String)solutionSerial);
        DynamicObjectCollection newRowDimList = newSolution.getDynamicObjectCollection("rowdim");
        DynamicObjectCollection newColDimList = newSolution.getDynamicObjectCollection("coldim");
        DynamicObjectCollection oldRowDimList = oldSolution.getDynamicObjectCollection("rowdim");
        DynamicObjectCollection oldColDimList = oldSolution.getDynamicObjectCollection("coldim");
        DynamicObjectCollection newpageDimList = newSolution.getDynamicObjectCollection("pagedim");
        DynamicObjectCollection oldpageDimList = oldSolution.getDynamicObjectCollection("pagedim");
        if (newRowDimList.size() != oldRowDimList.size() || newColDimList.size() != oldColDimList.size()) {
            return true;
        }
        int rowSize = newRowDimList.size();
        for (int i = 0; i < rowSize; ++i) {
            if (((DynamicObject)newRowDimList.get(i)).getString("rowmenberid").equals(((DynamicObject)oldRowDimList.get(i)).getString("rowmenberid"))) continue;
            return true;
        }
        int colSize = newColDimList.size();
        for (int i = 0; i < colSize; ++i) {
            if (((DynamicObject)newColDimList.get(i)).getString("columnmenberid").equals(((DynamicObject)oldColDimList.get(i)).getString("columnmenberid"))) continue;
            return true;
        }
        List<String> checkChangeDim = Arrays.asList(DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber());
        int pagesize = newpageDimList.size();
        for (int i = 0; i < pagesize; ++i) {
            String dimnum = ((DynamicObject)newpageDimList.get(i)).getDynamicObject("dimid").getString("number");
            if (!checkChangeDim.contains(dimnum) || ((DynamicObject)newpageDimList.get(i)).getString("menberid").equals(((DynamicObject)oldpageDimList.get(i)).getString("menberid"))) continue;
            return true;
        }
        return false;
    }
}

