/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsSolutionService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class AnalyticsDimMemService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AnalyticsDimMemService.class);
    private static volatile AnalyticsDimMemService analyticsDimMemService;

    private AnalyticsDimMemService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalyticsDimMemService getAnalyticsDimMemService() {
        if (analyticsDimMemService != null) return analyticsDimMemService;
        Class<AnalyticsDimMemService> clazz = AnalyticsDimMemService.class;
        synchronized (AnalyticsDimMemService.class) {
            if (analyticsDimMemService != null) return analyticsDimMemService;
            analyticsDimMemService = new AnalyticsDimMemService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return analyticsDimMemService;
        }
    }

    public static void removeOrgCache(IPageCache pageCache, List<IDNumberTreeNode> res) {
        ArrayList<Long> orgIds = new ArrayList<Long>(res.size());
        for (IDNumberTreeNode org : res) {
            orgIds.add(org.getId());
        }
        ThreadCache.put((Object)"gadmiorgids", orgIds);
        pageCache.remove("disableorgIds");
    }

    private static List<IDNumberTreeNode> sortIDNumberTreeNodes(long modelId, String dimNum, List<IDNumberTreeNode> res) {
        if (res.size() > 1) {
            Map<String, Integer> number2seq;
            Long cslschemeId = null;
            if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
                cslschemeId = (Long)res.get(0).getProperty("cslscheme.id");
            }
            if (!(number2seq = AnalyticsDimMemService.getMemberSort(modelId, dimNum, cslschemeId)).isEmpty()) {
                boolean isEntity = cslschemeId != null;
                res = res.stream().sorted(Comparator.comparing(e -> (Integer)number2seq.get(isEntity ? e.getId().toString() : e.getNumber()), Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
            }
        }
        return res;
    }

    public void filterNoDataRCMember(Map<String, List<String>> exitDataMap, List<IDNumberTreeNode>[] result, boolean isRow) {
        if (!exitDataMap.isEmpty()) {
            for (List<IDNumberTreeNode> nodes : result) {
                if (nodes == null) {
                    return;
                }
                Iterator<IDNumberTreeNode> iterator = nodes.iterator();
                while (iterator.hasNext()) {
                    IDNumberTreeNode treeNode = iterator.next();
                    String dimNum = treeNode.getDimNumber();
                    if (DimTypesEnum.CURRENCY.getNumber().equals(dimNum)) {
                        return;
                    }
                    List<String> dimMems = exitDataMap.get(dimNum);
                    if (!CollectionUtils.isNotEmpty(dimMems) || dimMems.contains(treeNode.getNumber())) continue;
                    if (DimTypesEnum.ENTITY.getNumber().equals(dimNum) && dimMems.contains(treeNode.getParent_SonNumber())) {
                        return;
                    }
                    iterator.remove();
                }
            }
        } else {
            result = new List[result.length];
        }
        ThreadCache.remove((Object)(isRow ? "rowdimmember" : "coldimmember"));
        ThreadCache.put((Object)(isRow ? "rowdimmember" : "coldimmember"), result);
    }

    public static void clearRowColMemberThreadCache() {
        ThreadCache.remove((Object)"rowdimmember");
        ThreadCache.remove((Object)"coldimmember");
    }

    public static Map<String, Integer> getMemberSort(long modelId, String dimnum, Long cslschemeId) {
        return (Map)ThreadCache.get((Object)String.join((CharSequence)"|", Long.toString(modelId), dimnum, cslschemeId != null ? cslschemeId.toString() : ""), () -> {
            Map<Object, Object> number2seq = new HashMap(16);
            DimMemberSortUtil.compareTimeOfChangeAndRefresh((Long)modelId, (Long)cslschemeId, (Long)MemberReader.getDimensionIdByNum((long)modelId, (String)dimnum));
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("membertype", "=", (Object)DimEntityNumEnum.getEntieyNumByNumber((String)dimnum));
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_memberorder", (String)"memberid,number,dseq", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)dys)) {
                number2seq = dys.stream().collect(Collectors.toMap(d -> cslschemeId != null ? d.getString("memberid") : d.getString("number"), d -> d.getInt("dseq"), (v1, v2) -> v1));
            }
            return number2seq;
        });
    }

    public List<IDNumberTreeNode>[] getAllDimMemberInfo(DynamicObjectCollection dimList, boolean isRow, long modelId, IPageCache pageCache, IFormView formView) {
        String dimIdName = isRow ? "rowdimid" : "columndimid";
        String memIdName = isRow ? "rowmenberid" : "columnmenberid";
        return this.getAllDimMemberInfo(dimList, dimIdName, memIdName, modelId, pageCache, formView);
    }

    public List<IDNumberTreeNode>[] getAllDimMemberInfo(DynamicObjectCollection dimList, String dimIdName, String memIdName, long modelId, IPageCache pageCache, IFormView formView) {
        return (List[])ThreadCache.get((Object)(dimIdName.equals("rowdimid") ? "rowdimmember" : "coldimmember"), () -> {
            List[] result = new List[dimList.size()];
            String mrptAndYearAndPeriod = pageCache.get("yearAndPeriod");
            boolean yearAndPeriodInPage = StringUtils.isNotEmpty((String)mrptAndYearAndPeriod);
            VersionParam versionParam = null;
            if (yearAndPeriodInPage) {
                Map dimNums2MemId = (Map)ObjectSerialUtil.deSerializedBytes((String)mrptAndYearAndPeriod);
                versionParam = new VersionParam(modelId, 0L, ((Long)dimNums2MemId.get("Year")).longValue(), ((Long)dimNums2MemId.get("Period")).longValue());
            }
            boolean filterPerm = this.isFilterPerm(formView);
            for (int i = 0; i < result.length; ++i) {
                String dimnum = ((DynamicObject)dimList.get(i)).getDynamicObject(dimIdName).getString("number");
                List<Object> res = new ArrayList<IDNumberTreeNode>(this.getNewDimInfoFromDB(dimList, i, dimIdName, memIdName, modelId, versionParam, filterPerm));
                List<Long> disableOrg = null;
                if (DimTypesEnum.ENTITY.getNumber().equals(dimnum)) {
                    AnalyticsDimMemService.removeOrgCache(pageCache, res);
                    disableOrg = this.getDisableOrg(formView, pageCache, modelId, null);
                }
                if (DimTypesEnum.YEAR.getNumber().equals(dimnum) || DimTypesEnum.PERIOD.getNumber().equals(dimnum) || DimTypesEnum.ENTITY.getNumber().equals(dimnum)) {
                    this.filterYearAndPeriod(res, dimnum, disableOrg);
                }
                if (DimTypesEnum.ENTITY.getNumber().equals(dimnum) && yearAndPeriodInPage && res.size() > 1) {
                    res = res.stream().filter(this.distinctByKey(e -> e.getParent_SonNumber())).collect(Collectors.toList());
                }
                result[i] = res;
            }
            return result;
        });
    }

    private boolean isFilterPerm(IFormView formView) {
        try {
            Object filterPerm = formView.getModel().getValue("filterperm");
            return filterPerm instanceof Boolean ? (Boolean)filterPerm : false;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return false;
        }
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private void filterYearAndPeriod(List<IDNumberTreeNode> res, String dimnum, List<Long> disableOrg) {
        IDNumberTreeNode no;
        int i;
        if (DimTypesEnum.YEAR.getNumber().equals(dimnum)) {
            for (i = 0; i < res.size(); ++i) {
                no = res.get(i);
                if (!"LastYear".equals(no.getNumber()) && !"CurrentYear".equals(no.getNumber())) continue;
                res.remove(no);
                --i;
            }
        }
        if (DimTypesEnum.PERIOD.getNumber().equals(dimnum)) {
            for (i = 0; i < res.size(); ++i) {
                no = res.get(i);
                if (!"LastPeriod".equals(no.getNumber()) && !"CurrentPeriod".equals(no.getNumber())) continue;
                res.remove(no);
                --i;
            }
        }
        if (DimTypesEnum.ENTITY.getNumber().equals(dimnum)) {
            for (i = 0; i < res.size(); ++i) {
                no = res.get(i);
                if (!disableOrg.contains(no.getId())) continue;
                res.remove(no);
                --i;
            }
        }
    }

    public List<Long> getDisableOrg(IFormView view, IPageCache pageCache, long modelId, String solutionSerial) {
        String disorg = pageCache.get("disableorgIds");
        if (StringUtils.isNotEmpty((String)disorg)) {
            return (List)ObjectSerialUtil.deSerializedBytes((String)disorg);
        }
        Map<String, Object> yearPeriodMap = this.getYearPeriodMap(view, pageCache, modelId, solutionSerial);
        List<Long> idList = new ArrayList<Long>(16);
        if (((Boolean)yearPeriodMap.get("isInPageDim")).booleanValue()) {
            List orgids = new ArrayList();
            if (yearPeriodMap.containsKey("orgids")) {
                orgids = (List)yearPeriodMap.get("orgids");
            } else if (ThreadCache.exists((Object)"gadmiorgids")) {
                orgids = (List)ThreadCache.get((Object)"gadmiorgids");
            }
            idList = EntityVersioningUtil.getOrgsByVersion((long)modelId, (long)LongUtil.toLong((Object)yearPeriodMap.get("sceneId")), (String)yearPeriodMap.get("year").toString(), (long)LongUtil.toLong((Object)yearPeriodMap.get("periodId")), orgids);
            String selectFields = "id,name,number,parent,storagetype,longnumber,level,dseq,isleaf";
            orgids.removeAll(idList);
            if (!orgids.isEmpty()) {
                QFilter qFilter = new QFilter("id", "in", orgids);
                DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)selectFields, (QFilter[])qFilter.toArray());
                OrgServiceHelper.dealNoMergeOrgList((DynamicObjectCollection)orgs, (Long)modelId, (Long)LongUtil.toLong((Object)yearPeriodMap.get("sceneId")), (Long)LongUtil.toLong((Object)yearPeriodMap.get("yearId")), (Long)LongUtil.toLong((Object)yearPeriodMap.get("periodId")));
                orgids.removeAll(orgs.stream().map(org -> org.getLong("id")).collect(Collectors.toList()));
                idList.addAll(orgids);
            }
        }
        pageCache.put("disableorgIds", ObjectSerialUtil.toByteSerialized(idList));
        return idList;
    }

    public Map<String, Object> getYearPeriodMap(IFormView view, IPageCache pageCache, long modelId, String solutionSerial) {
        DynamicObject so = AnalyticsSolutionService.getAnalyticsSolutionService().getAnalyticsSolutionDynamicObject(view, pageCache);
        if (solutionSerial != null) {
            so = (DynamicObject)ObjectSerialUtil.deSerializedBytes((String)solutionSerial);
        }
        DynamicObjectCollection pageDimList = so.getDynamicObjectCollection("pagedim");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String yearNum = null;
        String yearId = null;
        String periodNum = null;
        String periodId = null;
        String sceneId = null;
        ArrayList<Long> orgids = new ArrayList<Long>();
        ArrayList<String> pageDimNumberList = new ArrayList<String>(16);
        for (DynamicObject pageDim : pageDimList) {
            IDNumberTreeNode yearNode;
            DynamicObject dim = pageDim.getDynamicObject("dimid");
            pageDimNumberList.add(dim.getString("number"));
            if (DimTypesEnum.YEAR.getNumber().equals(dim.getString("number"))) {
                yearId = pageDim.getString("menberid");
                yearNode = MemberReader.findFyMemberById((String)modelNum, (Long)LongUtil.toLong((Object)yearId));
                yearNum = yearNode.getNumber();
                continue;
            }
            if (DimTypesEnum.PERIOD.getNumber().equals(dim.getString("number"))) {
                periodId = pageDim.getString("menberid");
                yearNode = MemberReader.findPeriodMemberById((String)modelNum, (Long)LongUtil.toLong((Object)periodId));
                periodNum = yearNode.getNumber();
                continue;
            }
            if (DimTypesEnum.SCENARIO.getNumber().equals(dim.getString("number"))) {
                sceneId = pageDim.getString("menberid");
                continue;
            }
            if (!DimTypesEnum.ENTITY.getNumber().equals(dim.getString("number"))) continue;
            orgids.add(pageDim.getLong("menberid"));
        }
        boolean isInPageDim = pageDimNumberList.contains(DimTypesEnum.YEAR.getNumber()) && pageDimNumberList.contains(DimTypesEnum.PERIOD.getNumber()) && pageDimNumberList.contains(DimTypesEnum.SCENARIO.getNumber());
        boolean isYearLeaf = !"Year".equals(yearNum) && !"AllYear".equals(yearNum);
        boolean isPeriodLeaf = !"Period".equals(periodNum) && !"M_YearTotal".equals(periodNum);
        HashMap<String, Object> Map2 = new HashMap<String, Object>(4);
        Map2.put("year", yearNum);
        Map2.put("yearId", yearId);
        Map2.put("periodId", periodId);
        Map2.put("sceneId", sceneId);
        Map2.put("periodNum", periodNum);
        Map2.put("isInPageDim", isInPageDim && isYearLeaf && isPeriodLeaf);
        if (!orgids.isEmpty()) {
            Map2.put("orgids", orgids);
        }
        return Map2;
    }

    private List<IDNumberTreeNode> getNewDimInfoFromDB(DynamicObjectCollection newRowDimList, int i, String rowdimid, String rowmenberid, long modelId, VersionParam versionParam, boolean isFilterPerm) {
        DynamicObject dimObj = (DynamicObject)newRowDimList.get(i);
        DynamicObject dim = dimObj.getDynamicObject(rowdimid);
        String mem = dimObj.getString(rowmenberid);
        String dimNum = dim.getString("number");
        List<IDNumberTreeNode> resultCol = AnalyticsDimMemService.getDimInfoFromDB(rowdimid, modelId, versionParam, isFilterPerm, mem, dimNum);
        return resultCol;
    }

    public static List<IDNumberTreeNode> getDimInfoFromDB(String rowdimid, long modelId, VersionParam versionParam, boolean isFilterPerm, String mem, String dimNum) {
        String entityNum = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        ArrayList<IDNumberTreeNode> resultCol = new ArrayList<IDNumberTreeNode>(16);
        if (mem.length() == 0) {
            ArrayList<IDNumberTreeNode> singRangeList = new ArrayList<IDNumberTreeNode>(16);
            singRangeList.addAll(MemberReader.getAllNodeFromCache((String)entityNum, (Object)modelId).values());
            resultCol.addAll(AnalyticsDimMemService.sortIDNumberTreeNodes(modelId, dimNum, singRangeList));
        } else if ("rowdimid".equals(rowdimid) || "columndimid".equals(rowdimid)) {
            String[] memList = mem.split(",");
            for (int j = 0; j < memList.length; ++j) {
                int rangeId;
                String[] temMem = memList[j].split(";");
                if (temMem.length < 1) continue;
                boolean isCustom = temMem.length >= 3 && temMem[2].equals("isProp");
                Long clsId = temMem.length == 4 ? LongUtil.toLong((Object)temMem[3]) : 0L;
                if (isCustom) {
                    rangeId = Integer.parseInt(temMem[1]);
                } else {
                    rangeId = 10;
                    if (temMem.length > 1) {
                        rangeId = Integer.parseInt(temMem[1]);
                    }
                }
                LinkedHashMap<String, IDNumberTreeNode> num2singRangeMap = new LinkedHashMap<String, IDNumberTreeNode>(16);
                MembRangeItem item = new MembRangeItem(entityNum, Long.valueOf(Long.parseLong(temMem[0])), null, rangeId, isCustom, (Object)modelId);
                if ("bcm_entitymembertree".equals(entityNum) && clsId != 0L) {
                    item.setSchemeId(clsId.longValue());
                }
                if (versionParam != null && DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNum)) {
                    item.matchItem4Ic(versionParam, c -> AnalyticsDimMemService.collectMem(modelId, entityNum, (Long)c.getId(), num2singRangeMap));
                } else {
                    item.matchItems(c -> AnalyticsDimMemService.collectMem(modelId, entityNum, (Long)c.getId(), num2singRangeMap));
                }
                if (isFilterPerm) {
                    AnalyticsDimMemService.filterPermMems(modelId, dimNum, num2singRangeMap);
                }
                if (!MapUtils.isNotEmpty(num2singRangeMap)) continue;
                resultCol.addAll(AnalyticsDimMemService.sortIDNumberTreeNodes(modelId, dimNum, new ArrayList<IDNumberTreeNode>(num2singRangeMap.values())));
            }
        } else {
            LinkedHashMap<String, IDNumberTreeNode> num2singRangeMap = new LinkedHashMap<String, IDNumberTreeNode>(16);
            for (String idStr : mem.split(",")) {
                IDNumberTreeNode treeNode = MemberReader.findMemberById((long)modelId, (String)entityNum, (Long)Long.parseLong(idStr));
                if (treeNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                num2singRangeMap.put(treeNode.getNumber(), treeNode);
            }
            if (isFilterPerm) {
                AnalyticsDimMemService.filterPermMems(modelId, dimNum, num2singRangeMap);
            }
            if (MapUtils.isNotEmpty(num2singRangeMap)) {
                resultCol.addAll(AnalyticsDimMemService.sortIDNumberTreeNodes(modelId, dimNum, new ArrayList<IDNumberTreeNode>(num2singRangeMap.values())));
            }
        }
        return resultCol;
    }

    public static void filterPermMems(long modelId, String dimNum, Map<String, IDNumberTreeNode> num2singRangeMap) {
        if (MapUtils.isEmpty(num2singRangeMap) || modelId == 0L || StringUtils.isEmpty((String)dimNum)) {
            return;
        }
        try {
            boolean admin = PermissionServiceImpl.getInstance((Long)modelId).isAdmin();
            if (admin) {
                return;
            }
            Long entityDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
            String entityNum = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
            HashSet<String> numbs = new HashSet<String>(16);
            for (IDNumberTreeNode node : num2singRangeMap.values()) {
                numbs.add(node.getNumber());
                if (!CollectionUtils.isNotEmpty((Collection)node.getChildren())) continue;
                for (IDNumberTreeNode child : node.getChildren()) {
                    numbs.add(child.getNumber());
                }
            }
            Set noPermNumbers = PermissionServiceImpl.getInstance((Long)modelId).matchNoPermMembersByNum(entityDimId, entityNum, numbs);
            if (CollectionUtils.isNotEmpty((Collection)noPermNumbers)) {
                ArrayList noPermNums = new ArrayList(noPermNumbers);
                for (String noPermNumber : noPermNums) {
                    IDNumberTreeNode node = num2singRangeMap.get(noPermNumber);
                    if (node != null && !node.isLeaf()) {
                        List children = node.getChildren();
                        if (CollectionUtils.isEmpty((Collection)children)) {
                            num2singRangeMap.remove(noPermNumber);
                            continue;
                        }
                        List childNums = children.stream().map(e -> e.getNumber()).collect(Collectors.toList());
                        if (!noPermNums.containsAll(childNums)) continue;
                        num2singRangeMap.remove(noPermNumber);
                        continue;
                    }
                    num2singRangeMap.remove(noPermNumber);
                }
            }
        }
        catch (Exception e2) {
            log.error((Throwable)e2);
        }
    }

    private static void collectMem(long modelId, String entityNum, Long c, List<IDNumberTreeNode> singRangeList) {
        IDNumberTreeNode treeNode = MemberReader.findMemberById((long)modelId, (String)entityNum, (Long)c);
        if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
            singRangeList.add(treeNode);
        }
    }

    private static void collectMem(long modelId, String entityNum, Long c, Map<String, IDNumberTreeNode> singRangeList) {
        IDNumberTreeNode treeNode = MemberReader.findMemberById((long)modelId, (String)entityNum, (Long)c);
        if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
            singRangeList.put(treeNode.getNumber(), treeNode);
        }
    }

    public List<String> getRowColDimNumberList(IFormView view, IPageCache pageCache) {
        ArrayList<String> rowColDimNumberList;
        String rowColDimNumberListSerial = pageCache.get("rowColDimNumberList");
        if (rowColDimNumberListSerial == null) {
            DynamicObject dim;
            DynamicObject solution = AnalyticsSolutionService.getAnalyticsSolutionService().getAnalyticsSolutionDynamicObject(view, pageCache);
            rowColDimNumberList = new ArrayList<String>(10);
            DynamicObjectCollection rowDimList = solution.getDynamicObjectCollection("rowdim");
            DynamicObjectCollection colDimList = solution.getDynamicObjectCollection("coldim");
            for (DynamicObject obj : rowDimList) {
                dim = obj.getDynamicObject("rowdimid");
                rowColDimNumberList.add(dim.getString("number"));
            }
            for (DynamicObject obj : colDimList) {
                dim = obj.getDynamicObject("columndimid");
                rowColDimNumberList.add(dim.getString("number"));
            }
            view.getPageCache().put("rowColDimNumberList", ObjectSerialUtil.toByteSerialized(rowColDimNumberList));
        } else {
            rowColDimNumberList = (ArrayList<String>)ObjectSerialUtil.deSerializedBytes((String)rowColDimNumberListSerial);
        }
        return rowColDimNumberList;
    }

    public void buildRowColDimNumberList(IPageCache pageCache, DynamicObjectCollection rowDimList, DynamicObjectCollection colDimList) {
        DynamicObject dim;
        ArrayList<String> rowColDimNumberList = new ArrayList<String>(16);
        ArrayList<String> rowColDimNameList = new ArrayList<String>(16);
        for (DynamicObject obj : rowDimList) {
            dim = obj.getDynamicObject("rowdimid");
            if (!Objects.nonNull(dim)) continue;
            rowColDimNumberList.add(dim.getString("number"));
            rowColDimNameList.add(dim.getString("name"));
        }
        for (DynamicObject obj : colDimList) {
            dim = obj.getDynamicObject("columndimid");
            if (!Objects.nonNull(dim)) continue;
            rowColDimNumberList.add(dim.getString("number"));
            rowColDimNameList.add(dim.getString("name"));
        }
        pageCache.put("rowColDimNumberList", ObjectSerialUtil.toByteSerialized(rowColDimNumberList));
        pageCache.put("rowColDimNameList", ObjectSerialUtil.toByteSerialized(rowColDimNameList));
        pageCache.put("rowDimSize", rowDimList.size() + "");
        pageCache.put("colDimSize", colDimList.size() + "");
    }
}

