/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.ExtFieldMappedService;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.util.BcmDLockUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.analytics.QueryAnalysisPermHelper;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.model.IDimMember;
import org.apache.commons.collections4.CollectionUtils;

public class AnalyticsSolutionService {
    private static volatile AnalyticsSolutionService analyticsSolutionService;
    private static final String NUMBER_TTPE = "numext";

    private AnalyticsSolutionService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalyticsSolutionService getAnalyticsSolutionService() {
        if (analyticsSolutionService != null) return analyticsSolutionService;
        Class<AnalyticsSolutionService> clazz = AnalyticsSolutionService.class;
        synchronized (AnalyticsSolutionService.class) {
            if (analyticsSolutionService != null) return analyticsSolutionService;
            analyticsSolutionService = new AnalyticsSolutionService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return analyticsSolutionService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSolution(IFormView view, IPageCache pageCache, long modelId, String bizEntityNumber, Map<Long, Object> pageDimValueMap) {
        DynamicObject solution;
        block25: {
            solution = this.getAnalyticsSolutionDynamicObject(view, pageCache);
            if (solution == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u5b58\u5728", (String)"AnalyticsSolutionService_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            long solutionId = solution.getLong("id");
            if (solutionId == 0L) {
                String name = solution.getString("solutionname");
                QFilter qf = new QFilter("model", "=", (Object)modelId);
                qf.and("solutionname", "=", (Object)name);
                DynamicObjectCollection dy = QueryServiceHelper.query((String)"bcm_analyticssoluentry", (String)"id, solutionnumber", (QFilter[])qf.toArray());
                if (!dy.isEmpty()) {
                    solutionId = ((DynamicObject)dy.get(0)).getLong("id");
                    solution.set("solutionnumber", ((DynamicObject)dy.get(0)).get("solutionnumber"));
                }
            }
            if (solutionId != 0L) {
                ArrayList dyos = Lists.newArrayList((Object[])new DynamicObject[]{solution});
                QueryAnalysisPermHelper.beforeModifyData(pageCache, dyos, modelId);
                if (dyos.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4fee\u6539\u5f53\u524d\u67e5\u8be2\u5206\u6790\u65b9\u6848\u7684\u6743\u9650\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Iterator cloneUtils = new CloneUtils(true, true);
                DynamicObject newSolution = (DynamicObject)cloneUtils.clone(solution.getDataEntityType(), solution);
                newSolution.set("id", (Object)solutionId);
                newSolution.set("model_id", (Object)modelId);
                newSolution.set("model", (Object)modelId);
                newSolution.set("catalog", (Object)solution.getLong("catalog"));
                newSolution.set("catalog_id", (Object)solution.getLong("catalog"));
                solution = newSolution;
            }
            if ("1".equals(solution.get("solutiontype"))) {
                AnalyticsSolutionService.dealExtSolution4Save(solution);
                solution.set("solutiontype", (Object)"1");
            } else {
                DynamicObjectCollection pageDim = solution.getDynamicObjectCollection("pagedim");
                for (Object dynamic : pageDim) {
                    long dimId = dynamic.getDynamicObject("dimid").getLong("id");
                    dynamic.set("dimid", (Object)dimId);
                    dynamic.set("dimid_id", (Object)dimId);
                    dynamic.set("orderindex", (Object)dynamic.getInt("orderindex"));
                    dynamic.set("orderindex_id", (Object)dynamic.getInt("orderindex"));
                    Object memberId = pageDimValueMap.get(dimId);
                    dynamic.set("menberid", memberId);
                }
                DynamicObjectCollection rowDim = solution.getDynamicObjectCollection("rowdim");
                for (DynamicObject dim : rowDim) {
                    long dimId = dim.getDynamicObject("rowdimid").getLong("id");
                    dim.set("rowdimid", (Object)dimId);
                    dim.set("rowdimid_id", (Object)dimId);
                    dim.set("roworderindex", (Object)dim.getInt("roworderindex"));
                    dim.set("roworderindex_id", (Object)dim.getInt("roworderindex"));
                }
                DynamicObjectCollection coldim = solution.getDynamicObjectCollection("coldim");
                for (DynamicObject dim : coldim) {
                    long dimId = dim.getDynamicObject("columndimid").getLong("id");
                    dim.set("columndimid", (Object)dimId);
                    dim.set("columndimid_id", (Object)dimId);
                    dim.set("colorderindex", (Object)dim.getInt("colorderindex"));
                    dim.set("colorderindex_id", (Object)dim.getInt("colorderindex"));
                }
                solution.set("solutiontype", (Object)"0");
            }
            solution.set("updateuserid", (Object)Long.valueOf(RequestContext.get().getUserId()));
            solution.set("updatetime", (Object)TimeServiceHelper.now());
            String solutionNumber = solution.getString("solutionnumber");
            String solutionLockKey = BcmDLockUtil.getSolutionLockKey((Object)modelId, (Object)solutionNumber);
            DLock lock = DLock.create((String)solutionLockKey).fastMode();
            Object object = null;
            try {
                if (!lock.tryLock(3000L)) break block25;
                try {
                    QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and("solutionnumber", "=", (Object)solutionNumber);
                    DeleteServiceHelper.delete((String)"bcm_analyticssoluentry", (QFilter[])qFilter.toArray());
                    DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{solution});
                    DynamicObject updateSolution = BusinessDataServiceHelper.loadSingle((Object)save[0].getLong("id"), (String)"bcm_analyticssoluentry");
                    this.cacheAnalyticsSolutionSerial(pageCache, updateSolution);
                    SearchHelper.setObjectCache(view, "solutionId", save[0].getLong("id"));
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (lock != null) {
                    if (object != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnalyticsSolutionService_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        String opDescribe = String.format(ResManager.loadKDString((String)"%s\u4fdd\u5b58\u6210\u529f", (String)"AnalyticsSolutionService_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), solution.getString("solutionname"));
        OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848", (String)"AnalyticsSolutionService_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)opDescribe, (Long)modelId, (String)bizEntityNumber);
    }

    public static void dealExtSolution4Save(DynamicObject solution) {
        DynamicObjectCollection pageDim = solution.getDynamicObjectCollection("pagedim");
        for (Object dynamic : pageDim) {
            AnalyticsSolutionService.setDimId((DynamicObject)dynamic, "dimid", "dimid_id");
            AnalyticsSolutionService.setDimId((DynamicObject)dynamic, "extdimid", "extdimid_id");
        }
        DynamicObjectCollection rowDim = solution.getDynamicObjectCollection("rowdim");
        for (DynamicObject dynamic : rowDim) {
            AnalyticsSolutionService.setDimId(dynamic, "rowdimid", "rowdimid_id");
            AnalyticsSolutionService.setDimId(dynamic, "rowextdimid", "rowextdimid_id");
        }
        DynamicObjectCollection coldim = solution.getDynamicObjectCollection("coldim");
        for (DynamicObject dynamic : coldim) {
            AnalyticsSolutionService.setDimId(dynamic, "columndimid", "columndimid_id");
            AnalyticsSolutionService.setDimId(dynamic, "columnextdimid", "columnextdimid_id");
        }
    }

    private static void setDimId(DynamicObject dynamic, String columndimid, String columndimid1) {
        long dimId = 0L;
        Object dim = dynamic.get(columndimid);
        if (dim instanceof DynamicObject) {
            dimId = ((DynamicObject)dim).getLong("id");
        }
        dynamic.set(columndimid1, (Object)dimId);
    }

    public boolean hasPermClassDataAuthor(Long solutionId, Long modelId) {
        DynamicObject permClass = PermClassEntityHelper.getPermissionClassEntity((String)"bcm_analyticssoluentry", (Long)solutionId, (Object)modelId);
        if (permClass != null) {
            String permLevel = PermClassEntityHelper.getDataPermission((String)RequestContext.get().getUserId(), (int)1, (String)permClass.getString("permclass.id"), (String)String.valueOf(modelId));
            return "3".equals(permLevel);
        }
        return true;
    }

    public String getAnalyticsSolutionSerialFromCache(IPageCache pageCache) {
        return pageCache.get("solution_serial");
    }

    public void cacheAnalyticsSolutionSerial(IPageCache pageCache, DynamicObject solution) {
        pageCache.put("solution_serial", ObjectSerialUtil.toByteSerialized((Object)solution));
    }

    public void cacheAnalyticsSolutionSerial(IPageCache pageCache, String solutionSerial) {
        pageCache.put("solution_serial", solutionSerial);
    }

    public DynamicObject getAnalyticsSolutionDynamicObject(IFormView view, IPageCache pageCache) {
        String solutionSerial = this.getAnalyticsSolutionSerialFromCache(pageCache);
        if (StringUtils.isEmpty((String)solutionSerial)) {
            solutionSerial = (String)view.getFormShowParameter().getCustomParam("solutionSerial");
            if (StringUtils.isEmpty((String)solutionSerial)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u5b58\u5728", (String)"AnalyticsSolutionService_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            pageCache.put("solution_serial", solutionSerial);
        }
        return solutionSerial == null ? null : (DynamicObject)ObjectSerialUtil.deSerializedBytes((String)solutionSerial);
    }

    public void openSolutionList(IFormView view, long modelId, CloseCallBack closeCallBack) {
        Long solutionId = (Long)SearchHelper.getObjectCache(view, "solutionId");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("solutionId", (Object)solutionId);
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setFormId("bcm_analyticssolutionlist");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public void openAddOrSaveOtherPage(IFormView view, IPageCache pageCache, CloseCallBack closeCallBack, String key, Map<Long, Object> pageDimValueMap, long modelId) {
        Long oldSolutionId = (Long)SearchHelper.getObjectCache(view, "solutionId");
        if (oldSolutionId == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u65b9\u6848\u3002", (String)"AnalyticsSolutionService_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        if ("bar_info".equals(key)) {
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u57fa\u672c\u4fe1\u606f", (String)"AnalyticsSolutionService_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if ("btn_saveother".equals(key)) {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u53e6\u5b58\u4e3a", (String)"AnalyticsSolutionService_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if ("btn_add".equals(key)) {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u65b9\u6848", (String)"AnalyticsSolutionService_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        showParameter.setCustomParam("pageDimValueMap", pageDimValueMap);
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam("solutionId", (Object)oldSolutionId);
        showParameter.setCustomParam("solutionSerial", (Object)this.getAnalyticsSolutionSerialFromCache(pageCache));
        showParameter.setCustomParam("ItemKey", (Object)key);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setFormId("bcm_saveothersolution");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public void deleteSolutionById(Set<Long> ids) {
        if (!ids.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_analyticssoluentry"), (Object[])ids.toArray());
        }
    }

    public DynamicObject getDefaultSolution(IFormView view, long modelId, List<String> doNotSaveDim) {
        Date now = TimeServiceHelper.now();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_analyticssoluentry");
        obj.set("createuserid", (Object)userId);
        obj.set("createtime", (Object)now);
        obj.set("updateuserid", (Object)userId);
        obj.set("updatetime", (Object)now);
        obj.set("solutionnumber", (Object)CodeRuleUtil.getCodeRuleNumber("bcm_analyticssoluentry", "createtime"));
        obj.set("solutionname", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"AnalyticsSolutionService_2", (String)"fi-bcm-formplugin"));
        obj.set("model", (Object)modelId);
        obj.set("turnstatus", (Object)1);
        obj.set("scope", (Object)Character.valueOf('0'));
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,shortnumber,issysdimension", (QFilter[])new QFilter[]{qFilter}, (String)"number desc");
        HashMap<String, DynamicObject> allDimMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dim : col) {
            allDimMap.put(dim.getString("number"), dim);
        }
        Map<String, String> dimIdMemNumMap = QueryDimensionServiceHelper.getDefaultValue((Long)modelId, (String)"bcm_analyticssolutiondata", null, (Long)userId).stream().collect(Collectors.toMap(p -> p.getString("dimension"), p -> p.getString("defaultnumber")));
        String memNum_acc = dimIdMemNumMap.get("Account");
        this.buildSaveDim(modelId, obj, allDimMap, "rowdim", "Account", "rowdimid", "rowmenberid", "roworderindex", memNum_acc != null ? memNum_acc : "Account", 0);
        if (MemberReader.isExistChangeTypeDimension((long)modelId)) {
            String memNum_ct = dimIdMemNumMap.get("ChangeType");
            this.buildSaveDim(modelId, obj, allDimMap, "coldim", "ChangeType", "columndimid", "columnmenberid", "colorderindex", memNum_ct != null ? memNum_ct : "ChangeType", 0);
        } else {
            String memNum_bp = dimIdMemNumMap.get("Process");
            this.buildSaveDim(modelId, obj, allDimMap, "coldim", "Process", "columndimid", "columnmenberid", "colorderindex", memNum_bp != null ? memNum_bp : "Process", 0);
        }
        Map<String, String> useSelectMap = this.getUserSelectNumber(view, modelId);
        Map dimHideDefaultMap = QueryDimensionServiceHelper.getDimensionHideDefaultItem((Long)modelId);
        int order = 0;
        for (DynamicObject dim : col) {
            String dimNum = dim.getString("number");
            long dimId = dim.getLong("id");
            String dimMemNumber = dimIdMemNumMap.get(dimNum);
            if (doNotSaveDim.contains(dimNum)) continue;
            if ("MultiGAAP".equalsIgnoreCase(dimNum)) {
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : "PRCGAAP", order);
            } else if ("Currency".equalsIgnoreCase(dimNum)) {
                String currencyNumber = dimMemNumber != null ? dimMemNumber : "DC";
                String userSelectCurrency = useSelectMap.get("currency");
                if (StringUtils.isNotEmpty((String)userSelectCurrency)) {
                    currencyNumber = userSelectCurrency;
                }
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", currencyNumber, order);
            } else if ("Scenario".equalsIgnoreCase(dimNum)) {
                String scenarioNumber = dimMemNumber != null ? dimMemNumber : dimNum;
                String userSelectScenario = useSelectMap.get("scenario");
                if (StringUtils.isNotEmpty((String)userSelectScenario)) {
                    scenarioNumber = userSelectScenario;
                }
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", scenarioNumber, order);
            } else if ("Year".equalsIgnoreCase(dimNum)) {
                String yearNumber = dimMemNumber != null ? dimMemNumber : dimNum;
                String userSelectYear = useSelectMap.get("year");
                if (StringUtils.isNotEmpty((String)userSelectYear)) {
                    yearNumber = userSelectYear;
                }
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", yearNumber, order);
            } else if ("Period".equalsIgnoreCase(dimNum)) {
                String periodNumber = dimMemNumber != null ? dimMemNumber : dimNum;
                String userSelectPeriod = useSelectMap.get("period");
                if (StringUtils.isNotEmpty((String)userSelectPeriod)) {
                    periodNumber = userSelectPeriod;
                }
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", periodNumber, order);
            } else if ("AuditTrail".equalsIgnoreCase(dimNum)) {
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : "ATTotal", order);
            } else if ("InternalCompany".equalsIgnoreCase(dimNum)) {
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : "InternalCompany", order);
            } else if ("DataSort".equalsIgnoreCase(dimNum)) {
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : "Actual", order);
            } else if ("Process".equalsIgnoreCase(dimNum)) {
                if (!MemberReader.isExistChangeTypeDimension((long)modelId)) continue;
                String processNumber = dimMemNumber != null ? dimMemNumber : "Rpt";
                QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and("number", "=", (Object)processNumber);
                boolean exists = QueryServiceHelper.exists((String)"bcm_processmembertree", (QFilter[])qfBuilder.toArray());
                if (!exists) {
                    processNumber = dimMemNumber != null ? dimMemNumber : "IRpt";
                }
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", processNumber, order);
            } else if (DimensionUtil.isUserDefinedDim(dimNum)) {
                String memNumber = dimMemNumber != null ? dimMemNumber : dim.getString("shortnumber") + "None";
                Pair pair = (Pair)dimHideDefaultMap.get(dimId);
                if (pair != null && ((Boolean)pair.p1).booleanValue()) {
                    Collection nodes = MemberReader.getAllNodeByDimNum((String)dimNum, (String)modelNum);
                    for (IDNumberTreeNode node : nodes) {
                        if (!((String)pair.p2).equals(node.getId().toString())) continue;
                        memNumber = node.getNumber();
                    }
                }
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", memNumber, order);
            } else {
                this.buildSaveDim(modelId, obj, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : dimNum, order);
            }
            ++order;
        }
        return obj;
    }

    public void setDefaultPageRowColDim4extSolution(Long modelId, DynamicObject solution, Map<String, String> useSelectMap, Long extModelId) {
        DynamicObjectCollection pageDim = solution.getDynamicObjectCollection("pagedim");
        pageDim.clear();
        DynamicObjectCollection rowDim = solution.getDynamicObjectCollection("rowdim");
        rowDim.clear();
        DynamicObjectCollection coldim = solution.getDynamicObjectCollection("coldim");
        coldim.clear();
        DynamicObjectCollection filter = solution.getDynamicObjectCollection("filter");
        filter.clear();
        ExtendsModel extendsModel = new ExtendsModel().getExtendsModel(extModelId);
        LinkedHashMap<String, DynaEntityObject> rowCols = new LinkedHashMap<String, DynaEntityObject>(16);
        HashSet<String> dimFields = new HashSet<String>(16);
        HashSet<String> extFields = new HashSet<String>(16);
        this.collectFields(extendsModel, rowCols, dimFields, extFields, new HashMap<String, String>(), new HashMap<String, String>());
        HashSet<String> needAddDims = new HashSet<String>(16);
        needAddDims.addAll(dimFields);
        needAddDims.addAll(ExtDataUtil.fixDims);
        int order = 0;
        order = this.addPageDim4extSolution(modelId, solution, useSelectMap, needAddDims, 0);
        Set<String> numberNums = this.collectNumExtDimNum(modelId, extendsModel, extFields);
        this.addExtDim4extSolution(modelId, solution, extendsModel, rowCols, numberNums, order, null);
    }

    public int addPageDim4extSolution(Long modelId, DynamicObject solution, Map<String, String> useSelectMap, Set<String> needAddDims, int order) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,shortnumber,issysdimension", (QFilter[])new QFilter[]{qFilter}, (String)"number desc");
        HashMap<String, DynamicObject> allDimMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dim : dims) {
            allDimMap.put(dim.getString("number"), dim);
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        Map<String, String> dimIdMemNumMap = QueryDimensionServiceHelper.getDefaultValue((Long)modelId, (String)"bcm_analyticssolutiondata", null, (Long)userId).stream().collect(Collectors.toMap(p -> p.getString("dimension"), p -> p.getString("defaultnumber"), (v1, v2) -> v1));
        Map dimHideDefaultMap = QueryDimensionServiceHelper.getDimensionHideDefaultItem((Long)modelId);
        for (DynamicObject dim : dims) {
            String dimNum = dim.getString("number");
            if (!needAddDims.contains(dimNum)) continue;
            long dimId = dim.getLong("id");
            String dimMemNumber = dimIdMemNumMap.get(dimNum);
            if ("MultiGAAP".equalsIgnoreCase(dimNum)) {
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : "PRCGAAP", order, "datatype", "0");
            } else if ("Currency".equalsIgnoreCase(dimNum)) {
                String currencyNumber = dimMemNumber != null ? dimMemNumber : "DC";
                String userSelectCurrency = useSelectMap.get("currency");
                if (StringUtils.isNotEmpty((String)userSelectCurrency)) {
                    currencyNumber = userSelectCurrency;
                }
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", currencyNumber, order, "datatype", "0");
            } else if ("Scenario".equalsIgnoreCase(dimNum)) {
                String scenarioNumber = dimMemNumber != null ? dimMemNumber : dimNum;
                String userSelectScenario = useSelectMap.get("scenario");
                if (StringUtils.isNotEmpty((String)userSelectScenario)) {
                    scenarioNumber = userSelectScenario;
                }
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", scenarioNumber, order, "datatype", "0");
            } else if ("Year".equalsIgnoreCase(dimNum)) {
                String yearNumber = dimMemNumber != null ? dimMemNumber : dimNum;
                String userSelectYear = useSelectMap.get("year");
                if (StringUtils.isNotEmpty((String)userSelectYear)) {
                    yearNumber = userSelectYear;
                }
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", yearNumber, order, "datatype", "0");
            } else if ("Period".equalsIgnoreCase(dimNum)) {
                String periodNumber = dimMemNumber != null ? dimMemNumber : dimNum;
                String userSelectPeriod = useSelectMap.get("period");
                if (StringUtils.isNotEmpty((String)userSelectPeriod)) {
                    periodNumber = userSelectPeriod;
                }
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", periodNumber, order, "datatype", "0");
            } else if ("AuditTrail".equalsIgnoreCase(dimNum)) {
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : "ATTotal", order, "datatype", "0");
            } else if ("InternalCompany".equalsIgnoreCase(dimNum)) {
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : "InternalCompany", order, "datatype", "0");
            } else if ("DataSort".equalsIgnoreCase(dimNum)) {
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : "Actual", order, "datatype", "0");
            } else if ("Process".equalsIgnoreCase(dimNum)) {
                if (!MemberReader.isExistChangeTypeDimension((long)modelId)) continue;
                String processNumber = dimMemNumber != null ? dimMemNumber : "Rpt";
                QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and("number", "=", (Object)processNumber);
                boolean exists = QueryServiceHelper.exists((String)"bcm_processmembertree", (QFilter[])qfBuilder.toArray());
                if (!exists) {
                    processNumber = dimMemNumber != null ? dimMemNumber : "IRpt";
                }
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", processNumber, order, "datatype", "0");
            } else if (DimensionUtil.isUserDefinedDim(dimNum)) {
                String memNumber = dimMemNumber != null ? dimMemNumber : dim.getString("shortnumber") + "None";
                Pair pair = (Pair)dimHideDefaultMap.get(dimId);
                if (pair != null && ((Boolean)pair.p1).booleanValue()) {
                    Collection nodes = MemberReader.getAllNodeByDimNum((String)dimNum, (String)modelNum);
                    for (IDNumberTreeNode node : nodes) {
                        if (!((String)pair.p2).equals(node.getId().toString())) continue;
                        memNumber = node.getNumber();
                    }
                }
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", memNumber, order, "datatype", "0");
            } else {
                this.buildSaveDim4ExtSolution(modelId, solution, allDimMap, "pagedim", dimNum, "dimid", "menberid", "orderindex", dimMemNumber != null ? dimMemNumber : dimNum, order, "datatype", "0");
            }
            ++order;
        }
        return order;
    }

    public Set<String> collectNumExtDimNum(Long modelId, ExtendsModel extendsModel, Set<String> extFields) {
        String extendsgroup = extendsModel.getExtendsGroupNumber();
        ExtFieldMappedService fieldMappedService = new ExtFieldMappedService(modelId, extendsgroup);
        Map colsFieldMapped = fieldMappedService.getColsFieldMapped(extFields.toArray(new String[0]));
        HashSet<String> numberNums = new HashSet<String>(16);
        colsFieldMapped.forEach((k, v) -> {
            if (v.startsWith(NUMBER_TTPE) && extFields.contains(k)) {
                numberNums.add((String)k);
            }
        });
        return numberNums;
    }

    public void addExtDim4extSolution(Long modelId, DynamicObject solution, ExtendsModel extendsModel, Map<String, DynaEntityObject> rowCols, Set<String> numberNums, int order, Set<String> needAddExtDim) {
        QFilter qFilter1 = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection extDims = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter1}, (String)"number desc");
        HashMap<String, DynamicObject> allExtDimMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dim : extDims) {
            allExtDimMap.put(dim.getString("number"), dim);
        }
        if (needAddExtDim == null) {
            this.buildSaveExtDim(solution, allExtDimMap, "pagedim", "extfmoney", "extdimid", "orderindex", order, "datatype", "2");
            this.buildSaveFmonty4ExtSolution(solution, allExtDimMap, "coldim", null, "colextdims", "colorderindex", 0, "coldatatype");
        }
        for (Map.Entry<String, DynaEntityObject> num2dy : rowCols.entrySet()) {
            String dimNum = num2dy.getKey();
            if (needAddExtDim != null && !needAddExtDim.contains(dimNum) || numberNums.contains(dimNum)) continue;
            if (needAddExtDim == null) {
                this.buildSaveExtDim(solution, allExtDimMap, "pagedim", dimNum, "extdimid", "orderindex", order, "datatype", "0");
            } else {
                this.buildExtDim(solution, allExtDimMap, "pagedim", dimNum, "extdimid", "orderindex", order, "datatype", "0");
            }
            ++order;
        }
    }

    public void collectFields(ExtendsModel extendsModel, Map<String, DynaEntityObject> rowCols, Set<String> dimFields, Set<String> extFields, Map<String, String> dimFields2name, Map<String, String> extdimFields2name) {
        List extFieldEntrys;
        List dimFieldEntryList = extendsModel.getDimFieldEntry();
        if (CollectionUtils.isNotEmpty((Collection)dimFieldEntryList)) {
            dimFieldEntryList.forEach(dimFieldEntry -> {
                dimFields.add(dimFieldEntry.getDimension().getNumber());
                dimFields2name.put(dimFieldEntry.getDimension().getNumber(), dimFieldEntry.getDimension().getName());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(extFieldEntrys = extendsModel.getExtFieldEntry()))) {
            extFieldEntrys.forEach(extFieldEntry -> {
                rowCols.put(extFieldEntry.getExtField().getNumber(), (DynaEntityObject)extFieldEntry);
                extFields.add(extFieldEntry.getExtField().getNumber());
                extdimFields2name.put(extFieldEntry.getExtField().getNumber(), extFieldEntry.getExtField().getName());
            });
        }
    }

    private void buildSaveDim(long modelId, DynamicObject obj, Map<String, DynamicObject> allDimMap, String dimPanel, String dimNumber, String dimIdName, String memberIdName, String orderIndexName, String memNumber, int order) {
        DynamicObject dimMember = this.buildSaveDimOfDimInfo(obj, allDimMap, dimPanel, dimNumber, dimIdName, orderIndexName, order);
        QFilter qFilter2 = new QFilter("model", "=", (Object)modelId);
        qFilter2.and("number", "=", (Object)memNumber);
        DynamicObject memDim = BusinessDataServiceHelper.loadSingleFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber), (String)"id,number", (QFilter[])new QFilter[]{qFilter2});
        if (memDim != null) {
            dimMember.set(memberIdName, (Object)memDim.getLong("id"));
        }
    }

    private void buildSaveDim4ExtSolution(long modelId, DynamicObject obj, Map<String, DynamicObject> allDimMap, String dimPanel, String dimNumber, String dimIdName, String memberIdName, String orderIndexName, String memNumber, int order, String typeProperty, String type) {
        DynamicObject dimMember = this.buildDimMemberInfo4ExtSolution(obj, allDimMap, dimPanel, dimNumber, dimIdName, orderIndexName, order);
        QFilter qFilter2 = new QFilter("model", "=", (Object)modelId);
        qFilter2.and("number", "=", (Object)memNumber);
        DynamicObject memDim = QueryServiceHelper.queryOne((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber), (String)"id,number", (QFilter[])new QFilter[]{qFilter2});
        if (memDim != null) {
            dimMember.set(memberIdName, (Object)memDim.getLong("id"));
        }
        dimMember.set(typeProperty, (Object)type);
    }

    private void buildSaveFmonty4ExtSolution(DynamicObject solution, Map<String, DynamicObject> allExtDimMap, String dimPanel, List<String> dimNumbers, String dimIdPropertyName, String orderIndexName, int order, String typeProperty) {
        DynamicObjectCollection dimCol = solution.getDynamicObjectCollection(dimPanel);
        DynamicObject dimMember = dimCol.addNew();
        ArrayList<Long> dimIds = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty(dimNumbers)) {
            for (String dimNumber : dimNumbers) {
                DynamicObject dim = allExtDimMap.get(dimNumber);
                if (dim == null) continue;
                dimIds.add(dim.getLong("id"));
            }
        }
        dimMember.set(dimIdPropertyName, (Object)JSON.toJSONString(dimIds));
        dimMember.set(orderIndexName, (Object)order);
        dimMember.set(orderIndexName, (Object)order);
        dimMember.set(typeProperty, (Object)"1");
    }

    private void buildSaveExtDim(DynamicObject solution, Map<String, DynamicObject> allExtDimMap, String dimPanel, String dimNumber, String dimIdName, String orderIndexName, int order, String typeProperty, String type) {
        DynamicObjectCollection dimCol = solution.getDynamicObjectCollection(dimPanel);
        DynamicObject dimMember = dimCol.addNew();
        DynamicObject dim = allExtDimMap.get(dimNumber);
        long dimId = dim == null ? 0L : dim.getLong("id");
        dimMember.set(dimIdName, (Object)dimId);
        dimMember.set(orderIndexName, (Object)order);
        dimMember.set(typeProperty, (Object)type);
    }

    private void buildExtDim(DynamicObject solution, Map<String, DynamicObject> allExtDimMap, String dimPanel, String dimNumber, String dimIdName, String orderIndexName, int order, String typeProperty, String type) {
        DynamicObjectCollection dimCol = solution.getDynamicObjectCollection(dimPanel);
        DynamicObject dimMember = dimCol.addNew();
        DynamicObject dim = allExtDimMap.get(dimNumber);
        dimMember.set(dimIdName, (Object)dim);
        dimMember.set(orderIndexName, (Object)order);
        dimMember.set(typeProperty, (Object)type);
    }

    public Map<String, String> getUserSelectNumber(IFormView view, long modelId) {
        DynamicObject currencyDy;
        DynamicObject periodDy;
        DynamicObject yearDy;
        DynamicObject scenarioDy;
        HashMap<String, String> useSelectNumberMap = new HashMap<String, String>(16);
        String selectFields = "model,year,scenario,period,currency";
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)view);
        DynamicObject userSelect = UserSelectUtil.getUserSelectDynamicObject(selectFields, application);
        if (userSelect == null) {
            return useSelectNumberMap;
        }
        long model = userSelect.getLong("model");
        if (model != modelId) {
            return useSelectNumberMap;
        }
        long userSelectScenario = userSelect.getLong("scenario");
        long userSelectYear = userSelect.getLong("year");
        long userSelectPeriod = userSelect.getLong("period");
        long userSelectCurrency = userSelect.getLong("currency");
        if (userSelectScenario > 0L && (scenarioDy = BusinessDataServiceHelper.loadSingle((Object)userSelectScenario, (String)"bcm_scenemembertree")) != null) {
            useSelectNumberMap.put("scenario", scenarioDy.getString("number"));
        }
        if (userSelectYear > 0L && (yearDy = BusinessDataServiceHelper.loadSingle((Object)userSelectYear, (String)"bcm_fymembertree")) != null) {
            useSelectNumberMap.put("year", yearDy.getString("number"));
        }
        if (userSelectPeriod > 0L && (periodDy = BusinessDataServiceHelper.loadSingle((Object)userSelectPeriod, (String)"bcm_periodmembertree")) != null) {
            useSelectNumberMap.put("period", periodDy.getString("number"));
        }
        if (userSelectCurrency > 0L && (currencyDy = BusinessDataServiceHelper.loadSingle((Object)userSelectCurrency, (String)"bcm_currencymembertree")) != null) {
            useSelectNumberMap.put("currency", currencyDy.getString("number"));
        }
        return useSelectNumberMap;
    }

    private DynamicObject buildSaveDimOfDimInfo(DynamicObject obj, Map<String, DynamicObject> allDimMap, String dimPanel, String dimNumber, String dimIdName, String orderIndexName, int order) {
        DynamicObjectCollection dimCol = obj.getDynamicObjectCollection(dimPanel);
        DynamicObject dimMember = dimCol.addNew();
        DynamicObject dim = allDimMap.get(dimNumber);
        dimMember.set(dimIdName, (Object)dim);
        dimMember.set(orderIndexName, (Object)order);
        return dimMember;
    }

    private DynamicObject buildDimMemberInfo4ExtSolution(DynamicObject solution, Map<String, DynamicObject> allDimMap, String dimPanel, String dimNumber, String dimIdName, String orderIndexName, int order) {
        DynamicObjectCollection dimCol = solution.getDynamicObjectCollection(dimPanel);
        DynamicObject dimMember = dimCol.addNew();
        DynamicObject dim = allDimMap.get(dimNumber);
        long dimId = dim == null ? 0L : dim.getLong("id");
        dimMember.set(dimIdName, (Object)dimId);
        dimMember.set(orderIndexName, (Object)order);
        return dimMember;
    }

    public void addParentEntityInfo(Cell cell, StringBuilder sb, String str, long modelId) {
        IDNumberTreeNode parent;
        IDNumberTreeNode numberTreeNode = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)((Long)cell.getUserObject("id")));
        if (numberTreeNode != null && numberTreeNode.getId() != -1L && (parent = numberTreeNode.getParent()) != null) {
            sb.append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7", (String)"AnalyticsSolutionService_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(str).append(parent.getNumber()).append("  ").append(parent.getName()).append(";\n");
        }
    }

    public long getMemberIdByName(String showType, String dimName, String dimMemberName, long modelId) {
        IDimMember member;
        String memNum;
        if ("btn_number".equalsIgnoreCase(showType)) {
            memNum = dimMemberName.trim();
            if (memNum.startsWith("+  ") || memNum.startsWith("-  ")) {
                memNum = memNum.substring(3).trim();
            }
        } else if ("btn_numname".equalsIgnoreCase(showType)) {
            memNum = dimMemberName.trim();
            int index = dimMemberName.lastIndexOf(32);
            if (memNum.startsWith("+  ") || memNum.startsWith("-  ")) {
                memNum = memNum.substring(3, index);
            } else if (index > 0) {
                memNum = memNum.substring(0, index).trim();
            }
        } else {
            memNum = dimMemberName.trim();
            if (memNum.startsWith("+  ") || memNum.startsWith("-  ")) {
                memNum = memNum.substring(3).trim();
            }
        }
        if ((member = TemplateUtil.getIDimMember(dimName, memNum, memNum, modelId, DimEntityNumEnum.getEntieyNumByNumber((String)dimName), false)) != null) {
            return member.getId();
        }
        return 0L;
    }

    public String[] getNumForDisableCell(Sheet sheet, int rowDimSize, int pos, int row, int col, DynamicObject dimValue) {
        String[] num = new String[3];
        if (pos == -1) {
            num[0] = dimValue.getString("number");
            num[1] = dimValue.getString("id");
            num[2] = dimValue.getString("name");
        } else {
            Cell tempCell = pos >= rowDimSize ? sheet.getCell(pos - rowDimSize, col) : sheet.getCell(row, pos);
            if (tempCell.getUserObject("selfDimMem") != null) {
                num[0] = tempCell.getUserObject("selfDimMem").toString();
            }
            if (tempCell.getUserObject("id") != null) {
                num[1] = tempCell.getUserObject("id").toString();
            }
            if (tempCell.getValue() != null) {
                num[2] = tempCell.getValue().toString();
            }
        }
        return num;
    }

    public void buildYearOrPeriodInfoList(Sheet sheet, int rowDimSize, int colDimSize, int pos, List<String> list, List<Long> memIdList, String dimNum, DynamicObject dimValue) {
        if (pos == -1) {
            String number = dimValue.getString("number");
            if ("year".equals(dimNum) && number.startsWith("FY") || "preiod".equals(dimNum) || "entity".equals(dimNum)) {
                list.add(number);
            }
            memIdList.add(dimValue.getLong("id"));
        } else {
            this.getRowOrColDimInfoList(sheet, rowDimSize, colDimSize, pos, list, memIdList);
        }
    }

    private void getRowOrColDimInfoList(Sheet sheet, int rowDimSize, int colDimSize, int pos, List<String> memList, List<Long> memIdList) {
        if (pos < rowDimSize) {
            for (int i = colDimSize; i < sheet.getMaxRowCount(); ++i) {
                Cell rowCell = sheet.getCell(i, pos);
                if (rowCell.getUserObject("selfDimMem") == null) continue;
                memList.add(rowCell.getUserObject("selfDimMem").toString());
                memIdList.add(Long.valueOf(rowCell.getUserObject("id").toString()));
            }
        } else {
            int colPos = pos - rowDimSize;
            for (int i = rowDimSize; i < sheet.getMaxColumnCount(); ++i) {
                Cell colCell = sheet.getCell(colPos, i);
                if (colCell.getUserObject("selfDimMem") == null) continue;
                memList.add(colCell.getUserObject("selfDimMem").toString());
                memIdList.add(Long.valueOf(colCell.getUserObject("id").toString()));
            }
        }
    }

    public DynamicObject buildSingleSaveLog(Map<String, Object> updateBeforeValueMap, Map.Entry entry, int row, int col, String modifyitem, long userId, long modelId) {
        DynamicObject logInfo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_analyticsavelog_entry");
        logInfo.set("modifyitem", (Object)modifyitem);
        logInfo.set("oldvalue", updateBeforeValueMap.get(row + "," + col));
        logInfo.set("newvalue", (Object)(entry.getValue() == null ? "" : entry.getValue()));
        logInfo.set("createuserid", (Object)userId);
        logInfo.set("createtime", (Object)TimeServiceHelper.now());
        logInfo.set("model", (Object)modelId);
        return logInfo;
    }

    public static DynamicObject getDefaultSolutionDy(Long modelId) {
        QFilter qfilter = new QFilter("model", "=", (Object)modelId);
        qfilter.and("turnstatus", "=", (Object)Character.valueOf('1'));
        qfilter.and("scope", "=", (Object)Character.valueOf('0'));
        DynamicObject id = QueryServiceHelper.queryOne((String)"bcm_analyticssoluentry", (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (id == null) {
            return null;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id.getLong("id"), (String)"bcm_analyticssoluentry");
        return obj;
    }
}

