/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.QuickAnalyticsEnum;
import kd.fi.bcm.common.util.UserUtils;
import kd.fi.bcm.formplugin.analytics.AnalyticsSolutionHelper;
import kd.fi.bcm.formplugin.analytics.service.IQuickAnalyticsService;
import kd.fi.bcm.formplugin.analytics.vo.SolutionParams;
import kd.fi.bcm.formplugin.analytics.vo.SolutionRowColOrder;
import kd.fi.bcm.spread.common.util.StringUtil;

public abstract class BaseQuickAnalyticsService
implements IQuickAnalyticsService {
    protected boolean entityInCol = false;
    protected boolean yearInCol = false;
    protected boolean periodInRow = false;
    protected boolean needDealProcess = false;
    protected boolean needDealAt = false;
    protected String type = "";

    @Override
    public DynamicObject buildSolution(long modelId, Map<String, List<String>> selectDimMemberInfoMap, Map<String, String> commonMemberMap, Collection<String> rowDims) {
        if (rowDims == null) {
            rowDims = new HashSet<String>(8);
        }
        DynamicObject solutionDy = AnalyticsSolutionHelper.genNewSolutin(modelId, UserUtils.getUserId());
        this.buildSolutionName(solutionDy);
        DynamicObjectCollection allDimList = AnalyticsSolutionHelper.getAllDimdyByModelid(modelId);
        Map<String, DynamicObject> allDimMap = AnalyticsSolutionHelper.getDimNum2Dimdy(allDimList);
        SolutionParams solutionParams = new SolutionParams(modelId, solutionDy, allDimMap, commonMemberMap, selectDimMemberInfoMap, new ArrayList<String>(10), new HashMap<String, Object>());
        this.setDimPosType(solutionParams, commonMemberMap, rowDims, "Entity");
        this.setDimPosType(solutionParams, commonMemberMap, rowDims, "Year");
        this.setDimPosType(solutionParams, commonMemberMap, rowDims, "Period");
        this.initParam(solutionParams);
        this.buildRowDimForSolution(solutionParams);
        SolutionRowColOrder solutionRowColOrder = this.buildRolColForSolution(solutionParams, rowDims, this.type);
        solutionParams.setSolutionRowColOrder(solutionRowColOrder);
        this.buildColDimForSolution(solutionParams);
        AnalyticsSolutionHelper.buildPageDimForSolution(modelId, commonMemberMap, solutionDy, allDimList, allDimMap, solutionParams.getRowColDimNumberList());
        return solutionDy;
    }

    private void initParam(SolutionParams solutionParams) {
        this.entityInCol = solutionParams.getEntityPositionType() == QuickAnalyticsEnum.POS_IN_COL.getValue();
        this.yearInCol = solutionParams.getYearPositionType() == QuickAnalyticsEnum.POS_IN_COL.getValue();
        this.periodInRow = solutionParams.getPeriodPositionType() == QuickAnalyticsEnum.POS_IN_ROW.getValue();
        String cube = MemberReader.findModelNumberById((Object)solutionParams.getModelId());
        String processDimNum = DimTypesEnum.PROCESS.getNumber();
        this.needDealProcess = AnalyticsSolutionHelper.chekcNeedDealMem(solutionParams.getCommonMemberMap(), solutionParams.getSelectDimMemberInfoMap(), processDimNum, "Process", cube);
        String atDimNum = DimTypesEnum.AUDITTRIAL.getNumber();
        this.needDealAt = AnalyticsSolutionHelper.chekcNeedDealMem(solutionParams.getCommonMemberMap(), solutionParams.getSelectDimMemberInfoMap(), atDimNum, "AuditTrail", cube);
    }

    private void setDimPosType(SolutionParams solutionParams, Map<String, String> commonMemberMap, Collection<String> rowDims, String dim) {
        boolean inPage = commonMemberMap.containsKey(dim);
        boolean inRow = rowDims.contains(dim);
        int type = QuickAnalyticsEnum.POS_IN_COL.getValue();
        if (inPage) {
            type = QuickAnalyticsEnum.POS_IN_PAGE.getValue();
        } else if (inRow) {
            type = QuickAnalyticsEnum.POS_IN_ROW.getValue();
        }
        if ("Entity".equals(dim)) {
            solutionParams.setEntityPositionType(type);
        } else if ("Period".equals(dim)) {
            solutionParams.setPeriodPositionType(type);
        } else if ("Year".equals(dim)) {
            solutionParams.setYearPositionType(type);
        }
    }

    protected void dealOrgDim(SolutionParams solutionParams, String rowcol, boolean needDealAt, boolean needDealProcess) {
        if (solutionParams.getRowColDimNumberList().contains("Entity")) {
            return;
        }
        AnalyticsSolutionHelper.buildDimByOrg(solutionParams.getModelId(), solutionParams.getSolutionDy(), solutionParams.getAllDimMap(), solutionParams.getCommonMemberMap(), solutionParams.getSelectDimMemberInfoMap(), solutionParams.getRowColDimNumberList(), needDealAt, needDealProcess, rowcol);
        solutionParams.getRowColDimNumberList().add("Entity");
    }

    protected void dealYearDim(SolutionParams solutionParams, String rowcol) {
        if (solutionParams.getRowColDimNumberList().contains("Year")) {
            return;
        }
        AnalyticsSolutionHelper.buildDimByYear(solutionParams.getModelId(), solutionParams.getSolutionDy(), solutionParams.getAllDimMap(), rowcol);
        solutionParams.getRowColDimNumberList().add("Year");
    }

    protected void dealPeriodDim(SolutionParams solutionParams, String rowcol) {
        if (solutionParams.getRowColDimNumberList().contains("Period")) {
            return;
        }
        String sceneNumber = BaseQuickAnalyticsService.getMemNumber(solutionParams, "Scenario");
        AnalyticsSolutionHelper.buildDimByPeriod(solutionParams.getModelId(), solutionParams.getSolutionDy(), solutionParams.getAllDimMap(), sceneNumber, rowcol);
        solutionParams.getRowColDimNumberList().add("Period");
    }

    protected static void dealWithCM056(SolutionParams solutionParams) {
        boolean yearInPage;
        long modelId = solutionParams.getModelId();
        boolean periodInPage = solutionParams.getPeriodPositionType() == QuickAnalyticsEnum.POS_IN_PAGE.getValue();
        boolean bl = yearInPage = solutionParams.getYearPositionType() == QuickAnalyticsEnum.POS_IN_PAGE.getValue();
        if (!yearInPage && periodInPage) {
            String exchangePeriodForLastYear;
            boolean equals;
            String periodNum = solutionParams.getCommonMemberMap().get("Period");
            String sceneNumber = solutionParams.getCommonMemberMap().get("Scenario");
            if (StringUtil.isEmptyString((String)sceneNumber)) {
                sceneNumber = solutionParams.getSelectDimMemberInfoMap().get("Scenario").get(0);
            }
            if (!(equals = StringUtil.equals((String)periodNum, (String)(exchangePeriodForLastYear = ConfigServiceHelper.getExchangePeriodForLastYear((long)modelId, (String)sceneNumber, (String)periodNum))))) {
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                qFilter.and("number", "in", Arrays.asList(periodNum, exchangePeriodForLastYear));
                DynamicObjectCollection periods = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,number", (QFilter[])new QFilter[]{qFilter}, (String)"number");
                AnalyticsSolutionHelper.buildPeriodInCol(solutionParams.getSolutionDy(), solutionParams.getAllDimMap(), solutionParams.getRowColDimNumberList(), periods);
            }
        }
    }

    protected static String getMemNumber(SolutionParams solutionParams, String dim) {
        String sceneNumber = solutionParams.getCommonMemberMap().get(dim);
        if (StringUtil.isEmptyString((String)sceneNumber)) {
            sceneNumber = solutionParams.getSelectDimMemberInfoMap().get(dim).get(0);
        }
        return sceneNumber;
    }

    public SolutionRowColOrder buildRolColForSolution(SolutionParams solutionParams, Collection<String> rowDims, String type) {
        return AnalyticsSolutionHelper.buildRolColForSolution(solutionParams.getModelId(), solutionParams.getSelectDimMemberInfoMap(), solutionParams.getSolutionDy(), solutionParams.getAllDimMap(), solutionParams.getRowColDimNumberList(), rowDims, AnalyticsSolutionHelper.EXCLUDETYPE_DIM.get(type));
    }

    public abstract void buildRowDimForSolution(SolutionParams var1);

    public abstract void buildColDimForSolution(SolutionParams var1);

    public abstract void buildSolutionName(DynamicObject var1);
}

