/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.workpaper.DimensionMemberDisplayTypeEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.analytics.MDQADataQueryHelper;
import kd.fi.bcm.formplugin.analytics.MultiDimQueryAnalysisPlugin;
import kd.fi.bcm.formplugin.analytics.vo.MultQueryRowColMem;
import kd.fi.bcm.formplugin.licence.BcmLicenceControl;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.multiview.validators.TemplateVerification;
import kd.fi.bcm.spread.common.variant.Variant;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.HeadObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class MultiDimQAStyleService {
    public static String DEFAULT_BACKCOLOR = "#FFFFFF";
    public static String DEFAULT_FORECOLOR = "#000000";
    public static final int INITMAXROWCOUNT = 10000;
    public static final int INITMAXCOLUMNCOUNT = 200;

    public static void hideContextMenu(IClientViewProxy viewProxy, String spreadKey) {
        ArrayList<Map> MenuItems = new ArrayList<Map>(10);
        String name = SpreadProperties.HideContextMenuItemsMethod.NAME.k();
        String ishide = SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k();
        MenuItems.add(MapInitHelper.ofMap((Object)name, (Object)SpreadProperties.ContextMenuItemNamesEnum.insertCopiedCells, (Object)ishide, (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)name, (Object)SpreadProperties.ContextMenuItemNamesEnum.rowHeaderinsertCopiedCells, (Object)ishide, (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)name, (Object)SpreadProperties.ContextMenuItemNamesEnum.colHeaderinsertCopiedCells, (Object)ishide, (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.sort, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(viewProxy, spreadKey, MenuItems);
    }

    public static void resetSpreadStyle(IClientViewProxy view, Sheet sheet, String spreadKey) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(view, spreadKey);
        invoker.setBatch(true);
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), DEFAULT_BACKCOLOR);
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        invoker.setStyle(0, 0, sheet.getMaxRowHeaderSize(), sheet.getMaxColHeaderSize(), styleMap);
        HashMap<String, Object> style = new HashMap<String, Object>(16);
        style.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), DEFAULT_BACKCOLOR);
        style.put(SpreadProperties.SetCellStyleMethod.FORECOLOR.k(), DEFAULT_FORECOLOR);
        invoker.setStyle(-1, -1, 1, 1, style);
        invoker.startToInvoke();
        SpreadClientInvoker.invokeCloseToolBar(view, spreadKey);
        SpreadClientInvoker.invokeLockOrHideSpreadMenuItems(view, spreadKey);
        SpreadClientInvoker.invokeLockSwitchViewAndUploadFile(view, spreadKey);
    }

    public static void setSpreadStyleForCellValue(IClientViewProxy view, String spreadKey, Sheet sheet, List<Map<String, Object>> cellValues) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(view, spreadKey);
        invoker.setBatch(true);
        SpreadClientInvoker.invokeUpdataValueMethod(view, spreadKey, cellValues);
        MultiDimQAStyleService.setTwoPoint(invoker, sheet);
        for (Map<String, Object> cellValue : cellValues) {
            Object value = cellValue.get(SpreadProperties.UpdataValueMethod.V.k());
            if (value == null || value.toString().length() <= 0 || !(value instanceof String)) continue;
            int r = (Integer)cellValue.get(SpreadProperties.UpdataValueMethod.R.k());
            int c = (Integer)cellValue.get(SpreadProperties.UpdataValueMethod.C.k());
            invoker.clearCellsStyle(r, c, 1, 1);
        }
        MultiDimQAStyleService.setSpreadBorder(invoker, sheet);
        invoker.startToInvoke();
    }

    public static void setTwoPoint(SpreadEasyInvoker invoker, Sheet sheet) {
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        int rowDimSize = rowHeader.getDimNums().size();
        int colDimSize = colHeader.getDimNums().size();
        MultiDimQAStyleService.setTwoPoint(invoker, colDimSize, rowDimSize, rowHeader.getObjects().size() - colDimSize, colHeader.getObjects().size() - rowDimSize);
    }

    private static void setTwoPoint(SpreadEasyInvoker invoker, int r, int c, int rc, int cc) {
        invoker.setStyle(r, c, rc, cc, MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.FORMAT.k(), (Object)"#,##0.00"));
    }

    public static void setSpreadBorder(SpreadEasyInvoker invoker, Sheet sheet) {
        HashMap<String, Object> style = new HashMap<String, Object>(16);
        ArrayList<String> borderColor = new ArrayList<String>(10);
        borderColor.add("#CCCCCC");
        ArrayList<String> borderStyle = new ArrayList<String>(10);
        borderStyle.add("thin");
        HashMap<String, ArrayList<String>> bl = new HashMap<String, ArrayList<String>>(16);
        bl.put(SpreadProperties.SetCellStyleMethod.BORDERCOLOR.k(), borderColor);
        bl.put(SpreadProperties.SetCellStyleMethod.BORDERSTYLE.k(), borderStyle);
        style.put(SpreadProperties.SetCellStyleMethod.BORDER.k(), bl);
        invoker.setStyle(0, 0, sheet.getMaxRowHeaderSize(), sheet.getMaxColHeaderSize(), style);
    }

    public static void setRowColHeaderValue(Sheet sheet, MultiDimQueryAnalysisPlugin.RangeWindow rangeWindow, String showType, IClientViewProxy view, String spreadKey) {
        Header rowHeader = sheet.getRowHeader();
        List rowDimNums = rowHeader.getDimNums();
        int rowDimSize = rowDimNums.size();
        Header colHeader = sheet.getColHeader();
        List colDimNums = colHeader.getDimNums();
        int colDimSize = colDimNums.size();
        if (rowHeader.getObjects().isEmpty() || colHeader.getObjects().isEmpty()) {
            return;
        }
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(view, spreadKey);
        invoker.setBatch(true);
        MultiDimQAStyleService.setRowOrColHeaderValue(invoker, sheet, colDimSize, rangeWindow.getBottomRow(), showType, true);
        MultiDimQAStyleService.setRowOrColHeaderValue(invoker, sheet, rowDimSize, rangeWindow.getRightCol(), showType, false);
        invoker.startToInvoke();
    }

    public static void setRowColHeaderValue(Sheet sheet, String showType, IClientViewProxy view, String spreadKey) {
        Header rowHeader = sheet.getRowHeader();
        List rowDimNums = rowHeader.getDimNums();
        int rowDimSize = rowDimNums.size();
        Header colHeader = sheet.getColHeader();
        List colDimNums = colHeader.getDimNums();
        int colDimSize = colDimNums.size();
        if (rowHeader.getObjects().isEmpty() || colHeader.getObjects().isEmpty()) {
            return;
        }
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(view, spreadKey);
        invoker.setBatch(true);
        MultiDimQAStyleService.setRowOrColHeaderValue(invoker, sheet, colDimSize, rowHeader.getObjects().size() - 1, showType, true);
        MultiDimQAStyleService.setRowOrColHeaderValue(invoker, sheet, rowDimSize, colHeader.getObjects().size() - 1, showType, false);
        invoker.startToInvoke();
    }

    public static void setRowColHeaderValue4ext(Sheet sheet, String showType, IClientViewProxy view, String spreadKey) {
        Header rowHeader = sheet.getRowHeader();
        int rowDimSize = rowHeader.getDimNumsSize();
        Header colHeader = sheet.getColHeader();
        int colDimSize = colHeader.getDimNumsSize();
        if (rowHeader.getObjects().isEmpty() || colHeader.getObjects().isEmpty()) {
            return;
        }
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(view, spreadKey);
        invoker.setBatch(true);
        MultiDimQAStyleService.setRowOrColHeaderValue4ext(invoker, sheet, colDimSize, rowHeader.getObjects().size() - 1, showType, true);
        MultiDimQAStyleService.setRowOrColHeaderValue4ext(invoker, sheet, rowDimSize, colHeader.getObjects().size() - 1, showType, false);
        invoker.startToInvoke();
    }

    public static void setRowOrColHeaderValue(SpreadEasyInvoker invoker, Sheet sheet, int start, int end, String showType, boolean isRow) {
        MultiDimQAStyleService.setRowOrColHeaderValue(invoker, sheet, start, end, DimensionMemberDisplayTypeEnum.getEnumByItemKey((String)showType), isRow, true, 0);
    }

    public static void setRowOrColHeaderValue4ext(SpreadEasyInvoker invoker, Sheet sheet, int start, int end, String showType, boolean isRow) {
        Header header = sheet.getHeader(isRow);
        boolean withFmoney = header.isWithFmoney();
        List fmoneyNums = header.getFmoneyNums();
        int fmoneySize = fmoneyNums.size();
        List dimNums = header.getDimNums();
        header.iteratorObjects(start, end, e -> {
            Map allMemberMap = e.getAllMemberMap();
            if (MapUtils.isEmpty((Map)allMemberMap)) {
                return;
            }
            for (int i = 0; i < dimNums.size(); ++i) {
                String showValue = (String)dimNums.get(i);
                MultQueryRowColMem memValues = (MultQueryRowColMem)allMemberMap.get(showValue);
                if (memValues != null) {
                    Object value;
                    boolean isdim = memValues.isDim();
                    showValue = isdim ? memValues.getName() : ((value = memValues.getValue()) != null ? value.toString() : "");
                }
                int otherIndex = i;
                if (invoker != null) {
                    invoker.updataValue(isRow ? e.getIndex() : otherIndex, isRow ? otherIndex : e.getIndex(), showValue);
                }
                Cell cell = sheet.getCell(isRow ? e.getIndex() : otherIndex, isRow ? otherIndex : e.getIndex());
                cell.setValue((Object)showValue);
                cell.setChangeVal(false);
            }
            if (withFmoney) {
                String fmoneyNum;
                int otherIndex = dimNums.size();
                int index = (e.getIndex() - start) % fmoneySize;
                String showValue = fmoneyNum = (String)fmoneyNums.get(index);
                MultQueryRowColMem memValues = (MultQueryRowColMem)allMemberMap.get(fmoneyNum);
                if (memValues != null) {
                    showValue = memValues.getName();
                }
                if (invoker != null) {
                    invoker.updataValue(isRow ? e.getIndex() : otherIndex, isRow ? otherIndex : e.getIndex(), showValue);
                }
                Cell cell = sheet.getCell(isRow ? e.getIndex() : otherIndex, isRow ? otherIndex : e.getIndex());
                cell.setValue((Object)showValue);
                cell.setChangeVal(false);
            }
        });
    }

    public static void setRowOrColHeaderValue(SpreadEasyInvoker invoker, Sheet sheet, int start, int end, DimensionMemberDisplayTypeEnum typeEnum, boolean isRow, boolean isMDQA, int index) {
        Header header = sheet.getHeader(isRow);
        List dimNums = header.getDimNums();
        header.iteratorObjects(start, end, e -> {
            for (int i = 0; i < dimNums.size(); ++i) {
                String showValue = e.getShowValue(typeEnum, (String)dimNums.get(i), isMDQA, true);
                int otherIndex = i + index;
                if (invoker != null) {
                    invoker.updataValue(isRow ? e.getIndex() : otherIndex, isRow ? otherIndex : e.getIndex(), showValue);
                }
                Cell cell = sheet.getCell(isRow ? e.getIndex() : otherIndex, isRow ? otherIndex : e.getIndex());
                cell.setValue((Object)showValue);
                cell.setChangeVal(false);
            }
        });
    }

    private static int getReportUnitInfo(Sheet sheet) {
        if (sheet.getUserObject("dataunit") == null) {
            sheet.putUserObject("dataunit", (Object)0);
            return 0;
        }
        return (Integer)sheet.getUserObject("dataunit");
    }

    public static void changeDataUnit(IFormView view, String key, Sheet sheet, boolean isreflesh, SpreadEasyInvoker invoker) {
        int oldUnitSize;
        int newUnitSize = Integer.parseInt(key.substring(8));
        if (newUnitSize == (oldUnitSize = MultiDimQAStyleService.getReportUnitInfo(sheet)) && isreflesh) {
            return;
        }
        sheet.putUserObject("dataunit", (Object)newUnitSize);
        invoker.setBatch(true);
        int rowDimSize = sheet.getRowHeader().getDimNums().size();
        int colDimSize = sheet.getColHeader().getDimNums().size();
        if (newUnitSize != 0) {
            invoker.lockCell(colDimSize, rowDimSize, sheet.getMaxRowHeaderSize() - colDimSize, sheet.getMaxColHeaderSize() - rowDimSize);
        } else {
            invoker.unlockCell(colDimSize, rowDimSize, sheet.getMaxRowHeaderSize() - colDimSize, sheet.getMaxColHeaderSize() - rowDimSize);
        }
        MultiDimQAStyleService.changeDataUnitDisplay(view, MultiDimQAStyleService.getUnitName(newUnitSize));
        sheet.iteratorRangeCells(colDimSize, sheet.getMaxRowHeaderSize(), rowDimSize, sheet.getMaxColHeaderSize(), cell -> {
            Variant value = cell.getVariant();
            if (!value.isNull()) {
                if (value.isNumeric()) {
                    invoker.updataValue(cell.getRow(), cell.getCol(), value.toBigDecimal().divide(BigDecimal.TEN.pow(newUnitSize)));
                } else {
                    invoker.updataValue(cell.getRow(), cell.getCol(), value.getValue());
                }
            }
        });
        invoker.startToInvoke();
    }

    private static void changeDataUnitDisplay(IFormView view, String unitName) {
        HashMap<String, String> language = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> parm = new HashMap<String, HashMap<String, String>>();
        language.put(Lang.get().getLangTag().replace("-", "_"), String.format(ResManager.loadKDString((String)"%s\u5143\u8868", (String)"AnalyticsSheetService_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), unitName));
        parm.put("text", language);
        view.updateControlMetadata("btn_dataunit", parm);
    }

    public static String getUnitName(int dataUnit) {
        String unitName = "";
        switch (dataUnit) {
            case 3: {
                unitName = ResManager.loadKDString((String)"\u5343", (String)"AnalyticsSheetService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 4: {
                unitName = ResManager.loadKDString((String)"\u4e07", (String)"AnalyticsSheetService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 6: {
                unitName = ResManager.loadKDString((String)"\u767e\u4e07", (String)"AnalyticsSheetService_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 8: {
                unitName = ResManager.loadKDString((String)"\u4ebf", (String)"AnalyticsSheetService_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 10: {
                unitName = ResManager.loadKDString((String)"\u767e\u4ebf", (String)"AnalyticsSheetService_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return unitName;
    }

    public static OpNameMultiLangEnumBridge getMultiLangUnitName(int dataUnit) {
        OpNameMultiLangEnumBridge unitName = null;
        switch (dataUnit) {
            case 3: {
                unitName = new OpNameMultiLangEnumBridge("\u5343\u5143\u8868", "AnalyticsSheetService_7", "fi-bcm-formplugin", "thousand rpt");
                break;
            }
            case 4: {
                unitName = new OpNameMultiLangEnumBridge("\u4e07\u5143\u8868", "AnalyticsSheetService_8", "fi-bcm-formplugin", "tenThousand rpt");
                break;
            }
            case 6: {
                unitName = new OpNameMultiLangEnumBridge("\u767e\u4e07\u5143\u8868", "AnalyticsSheetService_9", "fi-bcm-formplugin", "million rpt");
                break;
            }
            case 8: {
                unitName = new OpNameMultiLangEnumBridge("\u4ebf\u5143\u8868", "AnalyticsSheetService_10", "fi-bcm-formplugin", "hundredMillion rpt");
                break;
            }
            case 10: {
                unitName = new OpNameMultiLangEnumBridge("\u767e\u4ebf\u5143\u8868", "AnalyticsSheetService_11", "fi-bcm-formplugin", "tenBillion rpt");
                break;
            }
        }
        return unitName;
    }

    public static void setIndent(SpreadEasyInvoker invoker, int r, int c, int rc, int cc, int ti) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.TI.k(), ti);
        invoker.setStyle(r, c, rc, cc, styleMap);
    }

    public static void setIndentForExpandRowOrCol(SpreadEasyInvoker invoker, Sheet sheet, int r, int c, int count) {
        Header rowHeader = sheet.getRowHeader();
        List dimNums = rowHeader.getDimNums();
        HeadObject headObject = rowHeader.get(r, true);
        String dimNum = (String)dimNums.get(c);
        Map map = headObject.getSingleDimMember(dimNum);
        int ti = MDQADataQueryHelper.getValue(map, "ti", 0);
        rowHeader.iteratorObjects(r + 1, r + count, e -> e.getSingleDimMember(dimNum).put("ti", ti + 2));
        MultiDimQAStyleService.setIndent(invoker, r + 1, c, count, 1, ti + 2);
    }

    public static void setCellBackColor(SpreadEasyInvoker invoker, int r, int c, int rc, int cc, String color, boolean isCenter) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), color);
        if (isCenter) {
            styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 1);
        }
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        invoker.setStyle(r, c, rc, cc, styleMap);
    }

    public static int packUpRowOrCol(SpreadEasyInvoker invoker, Map<String, Object> memMap, int r, int c, Sheet sheet, boolean isH) {
        if (memMap.get("openCount") != null) {
            int openCount = MDQADataQueryHelper.getValue(memMap, "openCount", 0);
            memMap.put("openCount", 0);
            int jumpCount = 1;
            if (openCount > 0) {
                for (int i = 0; i < openCount; ++i) {
                    if (isH) {
                        sheet.delRow(r + jumpCount);
                        continue;
                    }
                    sheet.delColumn(c + jumpCount);
                }
                if (isH) {
                    invoker.batchDelRow(r + jumpCount, openCount);
                } else {
                    invoker.batchDelCol(c + jumpCount, openCount);
                }
            }
            String newCellValue = MDQADataQueryHelper.getValue(memMap, "msv", "").replace("-  ", "+  ");
            memMap.put("msv", newCellValue);
            Cell cell = sheet.getCell(r, c);
            cell.setValue((Object)newCellValue);
            cell.setChangeVal(false);
            int mergeCount = MDQADataQueryHelper.getValue(memMap, "mergeCount", 0);
            if (isH) {
                invoker.updataValue(r, c - mergeCount, newCellValue);
            } else {
                invoker.updataValue(r - mergeCount, c, newCellValue);
            }
            return openCount;
        }
        return 0;
    }

    public static int insertSpaceRowOrCol(IClientViewProxy view, String spreadKey, List<IDNumberTreeNode>[] dimAndMember, int r, int c, Sheet sheet, boolean isH, boolean flag) {
        int totalSize = 1;
        for (int i = 0; i < dimAndMember.length; ++i) {
            List<IDNumberTreeNode> nodeList = dimAndMember[i];
            if (nodeList.isEmpty()) continue;
            totalSize *= nodeList.size();
        }
        totalSize = flag ? totalSize : totalSize + 1;
        Header header = sheet.getHeader(isH);
        LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
        ArrayList rangeList = new ArrayList(16);
        HashMap<String, Integer> data = new HashMap<String, Integer>(16);
        int index = isH ? r : c;
        data.put("index", index + 1);
        data.put("count", totalSize);
        rangeList.add(data);
        map.put("status", Boolean.valueOf(true));
        HeadObject headObject = header.get(index, false);
        for (int j = 0; j < totalSize; ++j) {
            if (isH) {
                sheet.insertRow(r);
                continue;
            }
            sheet.insertColumn(c);
        }
        header.getObjects().set(index, headObject);
        header.getObjects().set(index + totalSize, new HeadObject());
        map.put("data", rangeList);
        int size = header.getDimNums().size();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(view, spreadKey);
        invoker.setBatch(true);
        if (isH) {
            SpreadClientInvoker.invokeInsertRow(view, spreadKey, map);
            invoker.lockCell(r, 0, 1, size);
            MultiDimQAStyleService.setTwoPoint(invoker, r, size, totalSize, sheet.getMaxColHeaderSize() - size);
        } else {
            invoker.lockCell(0, c, size, 1);
            SpreadClientInvoker.invokeInsertCol(view, spreadKey, map);
        }
        invoker.startToInvoke();
        return totalSize;
    }

    public static void setRowsHeight(SpreadEasyInvoker invoker, int start, int end, int height) {
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>(16);
        for (int i = start; i < end; ++i) {
            rowIndexs.add(i);
        }
        invoker.setRowsHeight(rowIndexs, height);
    }

    public static void setColumnWidth(SpreadEasyInvoker invoker, Sheet sheet, int rowDimSize) {
        ArrayList<Integer> colIndexs = new ArrayList<Integer>(16);
        for (int i = 0; i < rowDimSize; ++i) {
            colIndexs.add(i);
        }
        invoker.setColumnsWidth(colIndexs, 200);
        int size = sheet.getMaxColHeaderSize();
        ArrayList<Integer> colIndexs2 = new ArrayList<Integer>(16);
        for (int i = rowDimSize; i < size; ++i) {
            colIndexs2.add(i);
        }
        invoker.setColumnsWidth(colIndexs2, 150);
    }

    public static void setFrozen(SpreadEasyInvoker invoker, Sheet sheet) {
        int rowDimSize = sheet.getRowHeader().getDimNums().size();
        int colDimSize = sheet.getColHeader().getDimNums().size();
        invoker.setFrozenSheet(colDimSize, rowDimSize, 0, 0, "#CCCCCC", 0);
    }

    public static void setFrozen4ext(SpreadEasyInvoker invoker, Sheet sheet) {
        int rowDimSize = sheet.getRowHeader().getDimNumsSize();
        int colDimSize = sheet.getColHeader().getDimNumsSize();
        invoker.setFrozenSheet(colDimSize, rowDimSize, 0, 0, "#CCCCCC", 0);
    }

    public static void lockTableHead(SpreadEasyInvoker invoker, int r, int c, int rc, int cc) {
        invoker.lockCell(r, c, rc, cc);
    }

    public static void setTableHeadStyle(SpreadEasyInvoker invoker, Sheet sheet, boolean setColor) {
        int rowDimSize = sheet.getRowHeader().getDimNums().size();
        int colDimSize = sheet.getColHeader().getDimNums().size();
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        if (setColor) {
            styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#D9D9D9");
        }
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        styleMap.put(SpreadProperties.SetCellStyleMethod.WW.k(), true);
        invoker.setStyle(0, 0, colDimSize, sheet.getMaxColHeaderSize(), styleMap);
        invoker.setStyle(colDimSize, 0, sheet.getMaxRowHeaderSize() - colDimSize, rowDimSize, styleMap);
    }

    public static void setTableHeadStyle4ext(SpreadEasyInvoker invoker, Sheet sheet, boolean setColor) {
        int rowDimSize = sheet.getRowHeader().getDimNumsSize();
        int colDimSize = sheet.getColHeader().getDimNumsSize();
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        if (setColor) {
            styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#D9D9D9");
        }
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        styleMap.put(SpreadProperties.SetCellStyleMethod.WW.k(), true);
        invoker.setStyle(0, 0, colDimSize, sheet.getMaxColHeaderSize(), styleMap);
        invoker.setStyle(colDimSize, 0, sheet.getMaxRowHeaderSize() - colDimSize, rowDimSize, styleMap);
    }

    public static void setDataCellLockStatus(SpreadEasyInvoker invoker, Sheet sheet, long modelId) {
        boolean isLock;
        int rowDimSize = sheet.getRowHeader().getDimNums().size();
        int colDimSize = sheet.getColHeader().getDimNums().size();
        String userId = RequestContext.getOrCreate().getUserId();
        boolean canSaveData = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM008");
        boolean bl = isLock = !MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(userId), (String)String.valueOf(modelId)) || !canSaveData;
        if (isLock) {
            invoker.lockCell(colDimSize, rowDimSize, sheet.getMaxRowHeaderSize() - colDimSize, sheet.getMaxColHeaderSize() - rowDimSize);
        } else {
            invoker.unlockCell(colDimSize, rowDimSize, sheet.getMaxRowHeaderSize() - colDimSize, sheet.getMaxColHeaderSize() - rowDimSize);
        }
    }

    public static void hideOrShowNoDataRC(IClientViewProxy view, String spreadKey, Sheet sheet, boolean isVisible) {
        int rowCount = sheet.getMaxRowHeaderSize();
        int colCount = sheet.getMaxColHeaderSize();
        if (isVisible && !BcmLicenceControl.lessThanV6()) {
            SpreadClientInvoker.invokeHideRow(view, spreadKey, SpreadEasyInvoker.packHideMap(0, sheet.getMaxRowCount()), false);
            SpreadClientInvoker.invokeHideCol(view, spreadKey, SpreadEasyInvoker.packHideMap(0, sheet.getMaxColumnCount()), false);
            return;
        }
        HashSet<Integer> hideRow = new HashSet<Integer>(rowCount);
        HashSet<Integer> hideCol = new HashSet<Integer>(colCount);
        MultiDimQAStyleService.collectNoDataRowOrCol(sheet, null, hideRow, hideCol, new Predicate<Cell>(){

            @Override
            public boolean test(Cell cell) {
                return cell != null && cell.getValue() != null && StringUtils.isNotEmpty((CharSequence)cell.getValue().toString());
            }
        }, isVisible);
        if (!hideCol.isEmpty()) {
            int[] col = hideCol.stream().mapToInt(Integer::intValue).toArray();
            SpreadEasyInvoker.setColumnVisble(view, spreadKey, col, isVisible);
        }
        if (!hideRow.isEmpty()) {
            int[] row = hideRow.stream().mapToInt(Integer::intValue).toArray();
            SpreadEasyInvoker.setRowsVisble(view, spreadKey, row, isVisible);
        }
    }

    public static void collectNoDataRowOrCol(Sheet sheet, RangeModel dataRange, Set<Integer> hideRow, Set<Integer> hideCol, Predicate<Cell> predicate, boolean isVisible) {
        Predicate<Cell> rangePredicate;
        int endCol;
        int fromCol;
        int endRow;
        int fromRow;
        Header rowHeader = sheet.getRowHeader();
        Header colHeader = sheet.getColHeader();
        ArrayList<Integer> headRows = new ArrayList<Integer>(16);
        ArrayList<Integer> headCols = new ArrayList<Integer>(16);
        if (dataRange != null) {
            fromRow = 0;
            endRow = sheet.getMaxRowCount() - 1;
            fromCol = 0;
            endCol = sheet.getMaxColumnCount() - 1;
            List<RangeModel> rangeModels = TemplateVerification.getHeaderRangeModel(sheet, dataRange);
            rangePredicate = cell -> !rangeModels.stream().anyMatch(r -> r.checkIsInArea(cell));
            headRows.add(dataRange.getY_start() - 2);
            headRows.add(dataRange.getY_start() - 1);
            int rowDimSize = sheet.getRowHeader().getDimNums().size();
            for (int i = dataRange.getX_start() - rowDimSize; i < dataRange.getX_start(); ++i) {
                headCols.add(i);
            }
        } else {
            fromRow = colHeader.getDimNums().size();
            endRow = sheet.getMaxRowHeaderSize() - 1;
            fromCol = rowHeader.getDimNums().size();
            endCol = sheet.getMaxColHeaderSize() - 1;
            rangePredicate = cell -> true;
        }
        for (int i = fromRow; i <= endRow; ++i) {
            hideRow.add(i);
        }
        headRows.forEach(hideRow::remove);
        for (int j = fromCol; j <= endCol; ++j) {
            hideCol.add(j);
        }
        headCols.forEach(hideCol::remove);
        if (!isVisible) {
            sheet.iteratorRangeByPredicateBreak(fromRow, endRow, fromCol, endCol, cell -> {
                if (rangePredicate.test((Cell)cell) && predicate.test((Cell)cell)) {
                    hideRow.remove(cell.getRow());
                    hideCol.remove(cell.getCol());
                }
                return hideRow.isEmpty() && hideCol.isEmpty();
            });
        }
    }

    public static void cutSheetCell(IClientViewProxy view, String spreadKey, Sheet sheet) {
        int maxRowCount = sheet.getMaxRowHeaderSize() + 10;
        int maxColumnCount = sheet.getMaxColHeaderSize() + 5;
        SpreadEasyInvoker easyInvoker = new SpreadEasyInvoker(view, spreadKey);
        easyInvoker.batchDelCol(maxColumnCount, 200);
        easyInvoker.batchDelRow(maxRowCount, 10000);
    }

    public static String getInitSpreadJson(int maxRowCount, int maxColCount) {
        maxRowCount = maxRowCount > 10000 ? maxRowCount + 10 : 10000;
        maxColCount = maxColCount > 200 ? maxColCount + 5 : 200;
        return "{\"version\":\"10.0.1\",\"sheetCount\":1,\"sheets\":{\"null\":{\"name\":\"null\",\"rowCount\":\"" + maxRowCount + "\",\"columnCount\":\"" + maxColCount + "\",\"data\": {\"dataTable\": {}}}}}";
    }
}

