/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics.service;

import kd.bos.exception.KDBizException;
import kd.fi.bcm.formplugin.analytics.service.BaseQuickAnalyticsService;
import kd.fi.bcm.formplugin.analytics.service.CurrentOrgYearPeriodQuickAnalytiscService;
import kd.fi.bcm.formplugin.analytics.service.IQuickAnalyticsService;
import kd.fi.bcm.formplugin.analytics.service.LinkDataTraceAnalyticsService;
import kd.fi.bcm.formplugin.analytics.service.OrgYearPeriodsQuickAnalytiscService;
import kd.fi.bcm.formplugin.analytics.service.OrgYearsPeriodQuickAnalytiscService;
import kd.fi.bcm.formplugin.analytics.service.OrgYearsPeriodsQuickAnalytiscService;
import kd.fi.bcm.formplugin.analytics.service.OrgsYearPeriodQuickAnalytiscService;
import kd.fi.bcm.formplugin.analytics.service.OrgsYearPeriodsQuickAnalytiscService;
import kd.fi.bcm.formplugin.analytics.service.OrgsYearsPeriodQuickAnalytiscService;
import kd.fi.bcm.formplugin.analytics.service.OrgsYearsPeriodsQuickAnalytiscService;

public class QuickAnalysticFactory {
    public static IQuickAnalyticsService newInstance(String type) {
        BaseQuickAnalyticsService quickAnalyticsService = null;
        switch (type) {
            case "ORG": {
                quickAnalyticsService = new OrgsYearPeriodQuickAnalytiscService();
                break;
            }
            case "ORG_PERIOD": {
                quickAnalyticsService = new OrgsYearPeriodsQuickAnalytiscService();
                break;
            }
            case "ORG_YEAR": {
                quickAnalyticsService = new OrgsYearsPeriodQuickAnalytiscService();
                break;
            }
            case "ORG_YEAR_PERIOD": {
                quickAnalyticsService = new OrgsYearsPeriodsQuickAnalytiscService();
                break;
            }
            case "Period": {
                quickAnalyticsService = new OrgYearPeriodsQuickAnalytiscService();
                break;
            }
            case "Year": {
                quickAnalyticsService = new OrgYearsPeriodQuickAnalytiscService();
                break;
            }
            case "YEAR_PERIOD": {
                quickAnalyticsService = new OrgYearsPeriodsQuickAnalytiscService();
                break;
            }
            case "LINK_TRACE_TYPE": {
                quickAnalyticsService = new LinkDataTraceAnalyticsService();
                break;
            }
            case "CURRENT": {
                quickAnalyticsService = new CurrentOrgYearPeriodQuickAnalytiscService();
                break;
            }
            default: {
                throw new KDBizException(String.format("unsupoorted type %s", type));
            }
        }
        return quickAnalyticsService;
    }
}

