/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.export.model.ReportExportParam;
import kd.fi.bcm.business.export.util.ExportUtils;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.olap.PeriodRelaMembSupplier;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.WeaveInfoEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.api.dto.PrintInfoDTO;
import kd.fi.bcm.formplugin.report.NewReportMultiExportService;
import kd.fi.bcm.formplugin.report.ReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.formplugin.report.export.FixRangeAdjustService;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatWithoutViewHandle;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.common.util.CellDimFilterUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.PageDimDomain;
import kd.fi.bcm.spread.domain.ViewPointDimDomain;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.ReportDataRefleshService;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.GZIPUtils;
import kd.fi.bcm.spread.util.SpreadUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ReflectionReportPrintMsServiceImpl {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, ReflectionReportPrintMsServiceImpl.class);
    private static final String SEPARATOR = "_";
    private int timeout = 7200;
    private Long modelId;
    private String modelNumber;
    private Long fyId;
    private DynamicObject fyDy;
    private Long scenarioId;
    private DynamicObject scene;
    private Long periodId;
    private DynamicObject periodDy;
    private Long currencyId;
    private DynamicObject currencyDy;
    private Map<String, DynamicObject> cyNumber2Dy = new HashMap<String, DynamicObject>(16);
    private DynamicObject audittrial;
    private DynamicObject process;
    int viewDataunit = 0;
    int tmpDataunit = 0;
    private BigDecimal divisor = BigDecimal.ONE;
    private Integer scale = 2;
    ReportMultiExportService reportMultiExportService;
    private static final String ID = "id";
    private static final String MODEL = "model";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String LONG_NUMBER = "longnumber";
    private static final String FORMULA = "formula";
    private static final String VALUE = "value";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String commonSelectProperties = "id,number,name,dimension,dimension.membermodel";
    private static final String CHECK_PERIOD = "2";
    private static final String EXCEL = "1";
    Map<String, IDimMember> membCache = new HashMap<String, IDimMember>(16);

    public Map<String, String> getPrintUrls(Map<String, Object> reportParamObject) {
        PermissionService permissionService;
        boolean admin;
        Object permCheck;
        boolean needCheckOrgPerm;
        this.initParam(reportParamObject);
        Map orgs = (Map)reportParamObject.get("orgs");
        ArrayList templateIds = (ArrayList)reportParamObject.get("templateIds");
        Boolean isOnlyReport = (Boolean)reportParamObject.get("isOnlyReport");
        Map<Object, Object> urlMap = Maps.newHashMap();
        logger.info("\u6253\u5370\u63a5\u53e3 " + this.getLogInitParam());
        List<Object> orgPairs = this.getAllOrgByIdsAndRange(this.modelId, orgs);
        if (CollectionUtils.isEmpty(orgPairs)) {
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u672a\u627e\u5230\u4efb\u4f55\u6709\u6548\u7ec4\u7ec7");
            return urlMap;
        }
        JSONObject json = ParamSettingServiceHelper.getJSON((long)this.modelId, (String)"CM061");
        boolean needcheckPeriod = false;
        boolean isExcel = false;
        if (json != null) {
            String datatype = json.getString("datatype");
            needcheckPeriod = CHECK_PERIOD.equals(datatype);
            isExcel = EXCEL.equals(json.getString("filetype"));
        }
        if (needcheckPeriod) {
            Set orgNums = orgPairs.stream().map(p -> (String)p.p2).collect(Collectors.toSet());
            Map datastatus = PeriodSettingHelper.batchQueryOrgPeriodStatusOnlyClose((long)this.modelId, orgNums, (Long)this.scenarioId, (Long)this.fyId, (Long)this.periodId, (String)"datastatus");
            if (CollectionUtils.isEmpty(orgPairs = orgPairs.stream().filter(org -> datastatus.containsKey(org.p2)).collect(Collectors.toList()))) {
                logger.info("\u6253\u5370\u63a5\u53e3 -- \u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u672a\u5173\u95ed\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002");
                return urlMap;
            }
        }
        boolean bl = needCheckOrgPerm = (permCheck = reportParamObject.get("permCheck")) instanceof Boolean && (Boolean)permCheck != false;
        if (needCheckOrgPerm && !(admin = (permissionService = PermissionServiceImpl.getInstance((Long)this.modelId)).isAdmin())) {
            Long dimensionIdByNum = MemberReader.getDimensionIdByNum((long)this.modelId, (String)"Entity");
            Set orgIds2 = orgPairs.stream().map(p -> (Long)p.p1).collect(Collectors.toSet());
            Set noPermMembers = PermissionServiceImpl.getInstance((Long)this.modelId).matchNoPermMembers(dimensionIdByNum, "bcm_entitymembertree", orgIds2);
            if (CollectionUtils.isEmpty(orgPairs = orgPairs.stream().filter(org -> !noPermMembers.contains(org.p1)).collect(Collectors.toList()))) {
                logger.info("\u6253\u5370\u63a5\u53e3 -- \u671f\u95f4\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\u6216\u8005\u7ec4\u7ec7\u65e0\u6743\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002");
                return urlMap;
            }
        }
        Map<Object, DynamicObject> effectOrgMap = this.getEffectOrgMap(orgPairs);
        Set<Long> effectOrgIds = effectOrgMap.keySet().stream().map(LongUtil::toLong).collect(Collectors.toSet());
        if (!needcheckPeriod && this.isCM(this.modelId)) {
            effectOrgIds = this.getOrgIdsFromMergeCommit(effectOrgIds);
        }
        if (CollectionUtils.isEmpty(effectOrgIds)) {
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u7ec4\u7ec7\u7248\u672c\u5316\u540e\u672a\u627e\u5230\u4efb\u4f55\u6709\u6548\u7ec4\u7ec7");
            return urlMap;
        }
        if (isExcel) {
            return this.exportExcel(templateIds, (Map<String, String>)urlMap, effectOrgMap, effectOrgIds, needCheckOrgPerm);
        }
        Map templateIdsVersion = TemplateUtil.getRightTplIdByVersioned((Long)this.modelId, (Long)this.fyId, (Long)this.periodId, templateIds.stream().collect(Collectors.toSet()), (boolean)true);
        if (MapUtils.isEmpty((Map)templateIdsVersion)) {
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u6a21\u677f\u7248\u672c\u5316\u540e\u672a\u627e\u5230\u4efb\u4f55\u6709\u6548\u6a21\u677f");
            return urlMap;
        }
        Map template2OrgMapOfDispense = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)LongUtil.toLong((Object)this.modelId), (Set)Sets.newHashSet(templateIdsVersion.values()), effectOrgIds);
        List<Long> effectTemplateIds = template2OrgMapOfDispense.keySet().stream().collect(Collectors.toList());
        ArrayList orgTemplatePairs = Lists.newArrayList();
        template2OrgMapOfDispense.forEach((templateId, orgIds) -> orgIds.forEach(orgId -> orgTemplatePairs.add(Pair.onePair((Object)orgId, (Object)templateId))));
        if (CollectionUtils.isEmpty((Collection)orgTemplatePairs)) {
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u672a\u627e\u5230\u6709\u6548\u6a21\u677f\u5206\u914d\u7ec4\u7ec7\u8bb0\u5f55");
            return urlMap;
        }
        Map<String, List<DynamicObject>> queryReports = this.queryReports(this.modelId, this.fyId, this.scenarioId, this.periodId, effectOrgIds, effectTemplateIds, isOnlyReport);
        Map<Long, DynamicObject> queryTemplates = this.queryTemplates(effectTemplateIds);
        if (MapUtils.isEmpty(queryTemplates)) {
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u672a\u627e\u5230\u4efb\u4f55\u6709\u6548\u6a21\u677f\u6216\u62a5\u8868");
            return urlMap;
        }
        List<PrintInfoDTO> printInfoDTOS = this.getReports(effectOrgMap, orgTemplatePairs, queryReports, queryTemplates, isOnlyReport);
        if (CollectionUtils.isEmpty(printInfoDTOS)) {
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u672a\u751f\u6210\u9700\u8981\u6253\u5370\u7684\u6709\u6548\u5bf9\u8c61DTOs");
            return urlMap;
        }
        Map<String, byte[]> outMaps = this.printReports(queryTemplates, printInfoDTOS, effectOrgMap);
        logger.info("\u6253\u5370\u63a5\u53e3 -- \u9700\u8981\u6253\u5370\u7684\u6709\u6548\u5b57\u8282\u6570\u7ec4outMaps:" + outMaps.toString());
        if (MapUtils.isEmpty(outMaps)) {
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u672a\u751f\u6210\u9700\u8981\u6253\u5370\u7684\u6709\u6548\u5b57\u8282\u6570\u7ec4");
            return urlMap;
        }
        urlMap = this.getPDFUrls(outMaps);
        logger.info("\u6253\u5370\u63a5\u53e3 -- \u51fa\u53c2\uff1a" + urlMap.toString());
        return urlMap;
    }

    private Map<String, String> exportExcel(List<Long> templateIds, Map<String, String> urlMap, Map<Object, DynamicObject> effectOrgMap, Set<Long> effectOrgIds, boolean needCheckOrgPerm) {
        HashMap<String, Long> orgNum2Id = new HashMap<String, Long>(16);
        for (DynamicObject org : effectOrgMap.values()) {
            if (!effectOrgIds.contains(org.getLong(ID))) continue;
            orgNum2Id.put(org.getString(NUMBER), org.getLong(ID));
        }
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number", (QFilter[])new QFBuilder(ID, "in", templateIds).toArray());
        if (templateIds.isEmpty()) {
            return urlMap;
        }
        HashMap<String, Long> templateNum2Id = new HashMap<String, Long>(16);
        for (DynamicObject template : templates) {
            templateNum2Id.put(template.getString(NUMBER), template.getLong(ID));
        }
        NewReportMultiExportService service = new NewReportMultiExportService();
        ReportExportParam param = this.buildReportExportParam(orgNum2Id, templateNum2Id);
        this.buildService(service, param, this.viewDataunit, this.modelNumber, this.modelId, needCheckOrgPerm, true);
        ((ReportMultiExportService)service).initService();
        ((ReportMultiExportService)service).doExport_Excels();
        HashMap<String, String> fileNameMap = service.getFileNm2UrlMap();
        logger.info("\u6253\u5370\u63a5\u53e3 --excel\uff1a" + fileNameMap.toString());
        this.buildResult(urlMap, fileNameMap);
        if (!urlMap.isEmpty()) {
            urlMap.put("type_0", "xlsx");
        }
        logger.info("\u6253\u5370\u63a5\u53e3 -- \u51fa\u53c2\uff1a" + urlMap.toString());
        return urlMap;
    }

    private void buildResult(Map<String, String> urlMap, HashMap<String, String> fileNameMap) {
        Map<String, String> orgTemcurrency2Report = this.collectOrgTem2Report(fileNameMap);
        HashBasedTable orgCurrency2target = HashBasedTable.create();
        for (Map.Entry<String, String> entry : fileNameMap.entrySet()) {
            String org2tem = entry.getKey();
            String[] orgtem = new String[]{};
            orgtem = org2tem.contains(".") ? org2tem.substring(0, org2tem.indexOf(".")).split(SEPARATOR) : org2tem.split(SEPARATOR);
            if (orgtem.length == 2) {
                Long org = LongUtil.toLong((Object)orgtem[0]);
                String cyNumberStr = this.currencyDy.getString(NUMBER);
                if ("DC".equals(cyNumberStr) || "EC".equals(cyNumberStr)) {
                    if (!orgCurrency2target.contains((Object)org, (Object)cyNumberStr)) {
                        Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.modelId, (long)org, (String)this.process.getString(NUMBER), (String)cyNumberStr, (long)0L, (long)0L);
                        orgCurrency2target.put((Object)org, (Object)cyNumberStr, pair.p2);
                        cyNumberStr = (String)pair.p2;
                    } else {
                        cyNumberStr = (String)orgCurrency2target.get((Object)org, (Object)cyNumberStr);
                    }
                }
                String template = orgtem[1];
                String orgStr = orgtem[0];
                String key = String.join((CharSequence)SEPARATOR, orgStr, template, cyNumberStr);
                String reportId = orgTemcurrency2Report.containsKey(key) ? orgTemcurrency2Report.get(key) : "0";
                urlMap.put(String.join((CharSequence)SEPARATOR, orgStr, template, reportId), entry.getValue());
                continue;
            }
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u65e0\u6548\u8fd4\u56de\u503c\uff1a" + org2tem);
        }
    }

    private Map<String, String> collectOrgTem2Report(HashMap<String, String> fileNameMap) {
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        ArrayList<Long> temIds = new ArrayList<Long>(16);
        for (String key : fileNameMap.keySet()) {
            String[] orgtem = new String[]{};
            orgtem = key.contains(".") ? key.substring(0, key.indexOf(".")).split(SEPARATOR) : key.split(SEPARATOR);
            if (orgtem.length != 2) continue;
            orgIds.add(LongUtil.toLong((Object)orgtem[0]));
            temIds.add(LongUtil.toLong((Object)orgtem[1]));
        }
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.modelId).and("scene", "=", (Object)this.scenarioId).and("fyear", "=", (Object)this.fyId).and("period", "=", (Object)this.periodId).and("entity.id", "in", orgIds).and("template.id", "in", temIds);
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,entity.id,template.id,currency.number", (QFilter[])qFilter.toArray());
        HashMap<String, String> orgtemcurrency2report = new HashMap<String, String>(16);
        for (DynamicObject report : reports) {
            orgtemcurrency2report.put(String.join((CharSequence)SEPARATOR, report.getString("entity.id"), report.getString("template.id"), report.getString("currency.number")), report.getString(ID));
        }
        return orgtemcurrency2report;
    }

    private ReportExportParam buildReportExportParam(Map<String, Long> orgNum2Id, Map<String, Long> templateNum2Id) {
        ReportExportParam param = new ReportExportParam();
        param.setModelNum(this.modelNumber);
        param.setSceneNum(this.scene.getString(NUMBER));
        param.setYear(this.fyDy.getString(NUMBER));
        param.setPeriod(this.periodDy.getString(NUMBER));
        param.setCurrency(this.currencyDy.getString(NUMBER));
        param.setOrgs(new ArrayList<String>(orgNum2Id.keySet()));
        param.setTmps(new ArrayList<String>(templateNum2Id.keySet()));
        HashMap<String, String> dim2mems = new HashMap<String, String>(16);
        dim2mems.put(DimTypesEnum.PROCESS.getNumber(), this.process.getString(NUMBER));
        dim2mems.put(DimTypesEnum.AUDITTRIAL.getNumber(), this.audittrial.getString(NUMBER));
        param.setDim2Mems(dim2mems);
        return param;
    }

    private boolean isCM(Long modelId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,reporttype", (QFilter[])new QFilter(ID, "=", (Object)modelId).toArray());
        return ApplicationTypeEnum.CM.getOIndex().equals(dynamicObject.getString("reporttype"));
    }

    private void initParam(Map<String, Object> reportParamObject) {
        try {
            this.modelId = LongUtil.toLong((Object)reportParamObject.get("modelId"));
            this.modelNumber = MemberReader.findModelNumberById((Object)this.modelId);
            this.fyId = LongUtil.toLong((Object)reportParamObject.get("fyId"));
            this.scenarioId = LongUtil.toLong((Object)reportParamObject.get("scenarioId"));
            this.periodId = LongUtil.toLong((Object)reportParamObject.get("periodId"));
            this.currencyId = LongUtil.toLong((Object)reportParamObject.get("currencyId"));
            this.viewDataunit = Integer.parseInt(String.valueOf(reportParamObject.get("dataUnit")));
            Map orgs = (Map)reportParamObject.get("orgs");
            ArrayList templateIds = (ArrayList)reportParamObject.get("templateIds");
            Boolean isOnlyReport = (Boolean)reportParamObject.get("isOnlyReport");
            logger.info("\u6253\u5370\u63a5\u53e3 " + this.getLogEnterParam(orgs, templateIds, isOnlyReport));
            this.initYear();
            this.initSceneDy();
            this.initPeriod();
            this.initCurrencyDy();
            this.initAuditMember();
            this.initProcessMember();
            this.initDealScale(reportParamObject);
            this.initReportMultiExportService();
        }
        catch (Exception e) {
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38");
        }
    }

    private void initYear() {
        QFilter filter1 = new QFilter(MODEL, "=", (Object)this.modelId);
        QFilter filter2 = new QFilter(ID, "=", (Object)this.fyId);
        this.fyDy = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)commonSelectProperties, (QFilter[])new QFilter[]{filter1, filter2});
        this.isParamNotNull(this.fyDy, DimTypesEnum.YEAR.getName());
    }

    public void initPeriod() {
        String selectProperties = "id,number,name,dimension,dimension.membermodel,effmonth,effday,expmonth,expday";
        QFilter filter1 = new QFilter(MODEL, "=", (Object)this.modelId);
        QFilter filter2 = new QFilter(ID, "=", (Object)this.periodId);
        this.periodDy = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)selectProperties, (QFilter[])new QFilter[]{filter1, filter2});
        this.isParamNotNull(this.periodDy, DimTypesEnum.PERIOD.getName());
    }

    private void initSceneDy() {
        this.scene = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)commonSelectProperties, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)this.scenarioId)});
        this.isParamNotNull(this.scene, DimTypesEnum.SCENARIO.getName());
    }

    private void initCurrencyDy() {
        QFilter filter1 = new QFilter(MODEL, "=", (Object)this.modelId);
        QueryServiceHelper.query((String)"bcm_currencymembertree", (String)commonSelectProperties, (QFilter[])new QFilter[]{filter1}).forEach(value -> {
            this.cyNumber2Dy.put(value.getString(NUMBER), (DynamicObject)value);
            if (value.getLong(ID) == this.currencyId.longValue()) {
                this.currencyDy = value;
            }
        });
        this.isParamNotNull(this.currencyDy, DimTypesEnum.CURRENCY.getName());
    }

    public void initAuditMember() {
        String number = "ATTotal";
        QFilter filter1 = new QFilter(MODEL, "=", (Object)this.modelId);
        QFilter filter2 = new QFilter(NUMBER, "=", (Object)number);
        DynamicObject memDy = QueryServiceHelper.queryOne((String)"bcm_audittrialmembertree", (String)commonSelectProperties, (QFilter[])new QFilter[]{filter1, filter2});
        this.isParamNotNull(memDy, DimTypesEnum.AUDITTRIAL.getName());
        this.audittrial = memDy;
    }

    private void initProcessMember() {
        String cyNum = this.currencyDy.getString(NUMBER);
        String number = "EC".equals(cyNum) ? "ERpt" : ("DC".equals(cyNum) ? "ERpt" : "Rpt");
        QFilter filter1 = new QFilter(MODEL, "=", (Object)this.modelId);
        QFilter filter2 = new QFilter(NUMBER, "=", (Object)number);
        DynamicObject memDy = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)commonSelectProperties, (QFilter[])new QFilter[]{filter1, filter2});
        this.isParamNotNull(memDy, DimTypesEnum.PROCESS.getName());
        this.process = memDy;
    }

    private void initDealScale(Map<String, Object> reportParamObject) {
        Boolean isDealScale = (Boolean)reportParamObject.get("isDealScale");
        this.scale = isDealScale != null && isDealScale != false ? (Integer)reportParamObject.get("scale") : -1;
        this.divisor = BigDecimal.valueOf(Math.pow(10.0, this.viewDataunit));
    }

    private boolean isParamNotNull(DynamicObject object, String paramName) {
        if (object == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u7ef4\u5ea6\u53c2\u6570 %1$s \u672a\u5339\u914d\u5230\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"ReportPrintMsServiceImpl_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), paramName));
        }
        return true;
    }

    private void initReportMultiExportService() {
        this.reportMultiExportService = new ReportMultiExportService();
        this.reportMultiExportService.setModelId(this.modelId);
        this.reportMultiExportService.setCube(this.modelNumber);
        this.reportMultiExportService.setViewDataunit(this.viewDataunit);
        this.reportMultiExportService.setScale(this.scale);
        this.reportMultiExportService.setDivisor(this.divisor);
        this.reportMultiExportService.setCyObj_view(this.currencyDy);
    }

    private List<Pair<Long, String>> getAllOrgByIdsAndRange(Long modelId, Map<Long, Integer> orgs) {
        ArrayList orgPairs = Lists.newArrayList();
        orgs.forEach((orgId, rangeId) -> {
            IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)orgId);
            if (member != null) {
                new MembRangeItem("bcm_entitymembertree", orgId, member.getNumber(), rangeId.intValue(), false, (Object)modelId).matchItems(c -> orgPairs.add(Pair.onePair((Object)LongUtil.toLong((Object)c.id), (Object)c.number)));
            } else {
                logger.info("\u672a\u627e\u5230\u7ec4\u7ec7:" + orgId);
            }
        });
        return orgPairs;
    }

    private List<DynamicObject> getOrgThree(Long modelId, Collection<String> orgNumbers) {
        QFBuilder qb = new QFBuilder();
        qb.add(new QFilter(MODEL, "=", (Object)modelId));
        qb.and(new QFilter(NUMBER, "in", orgNumbers));
        DynamicObjectCollection orgThree = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number", (QFilter[])qb.toArray());
        return Lists.newArrayList((Iterable)orgThree);
    }

    private List<PrintInfoDTO> getReports(Map<Object, DynamicObject> effectOrgMap, List<Pair<Long, Long>> orgTemplatePairs, Map<String, List<DynamicObject>> queryReports, Map<Long, DynamicObject> queryTemplates, Boolean isOnlyReport) {
        ArrayList reports = Lists.newArrayList();
        orgTemplatePairs.forEach(pair -> {
            String key = pair.p1 + SEPARATOR + pair.p2;
            if (MapUtils.isNotEmpty((Map)queryReports) && queryReports.containsKey(key)) {
                ((List)queryReports.get(key)).forEach(dynamicObject -> {
                    if (this.isEffectReport((DynamicObject)dynamicObject, effectOrgMap) != null) {
                        reports.add(new PrintInfoDTO((Long)pair.p1, (Long)pair.p2, dynamicObject.getLong(ID), true, (DynamicObject)dynamicObject));
                    }
                });
            } else if (!isOnlyReport.booleanValue() && queryTemplates.containsKey(pair.p2)) {
                reports.add(new PrintInfoDTO((Long)pair.p1, (Long)pair.p2, false, (DynamicObject)queryTemplates.get(pair.p2)));
            }
        });
        return reports;
    }

    private DynamicObject isEffectReport(DynamicObject exitReport, Map<Object, DynamicObject> effectOrgMap) {
        String cyNumberStr = this.currencyDy.getString(NUMBER);
        if ("EC".equals(cyNumberStr)) {
            DynamicObject orgObject = effectOrgMap.get(exitReport.getLong("entity.id"));
            if (orgObject == null) {
                return null;
            }
            String cynumber = orgObject.getString("currency.number");
            long cyId = this.cyNumber2Dy.get(cynumber).getLong(ID);
            if (exitReport.getLong("currency.id") == cyId) {
                return exitReport;
            }
        } else if ("DC".equals(cyNumberStr)) {
            Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.modelId, (long)exitReport.getLong("entity.id"), (String)this.process.getString(NUMBER), (String)cyNumberStr, (long)0L, (long)0L);
            long cyId = this.cyNumber2Dy.get(pair.p2).getLong(ID);
            if (exitReport.getLong("currency.id") == cyId) {
                return exitReport;
            }
        } else if (exitReport.getLong("currency.id") == this.currencyId.longValue()) {
            return exitReport;
        }
        return null;
    }

    private Map<Object, DynamicObject> getEffectOrgMap(List<Pair<Long, String>> orgPairs) {
        List orgIds = orgPairs.stream().map(p -> (Long)p.p1).collect(Collectors.toList());
        List<DynamicObject> orgThree = this.getOrgThree(this.modelId, orgPairs.stream().map(p -> (String)p.p2).collect(Collectors.toList()));
        EntityVersioningUtil.filterVersionOrgTree(orgThree, (long)this.modelId, (long)this.fyId, (long)this.periodId, (long)this.scenarioId);
        List effectOrgIds = orgThree.stream().filter(dynamicObject -> orgIds.contains(dynamicObject.getLong(ID)) && !dynamicObject.getString(NUMBER).equals(DimTypesEnum.ENTITY.getNumber())).map(dynamicObject -> dynamicObject.getLong(ID)).collect(Collectors.toList());
        Map<Object, DynamicObject> effectOrgMap = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,orgcode,name,isleaf,currency.number,simplename", (QFilter[])new QFilter[]{new QFilter(ID, "in", effectOrgIds)}).stream().collect(Collectors.toMap(e -> e.getLong(ID), e -> e));
        return effectOrgMap;
    }

    private Set<Long> getOrgIdsFromMergeCommit(Set<Long> effectOrgIds) {
        HashSet orgIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(effectOrgIds)) {
            Map mcStatusMap = McStatus.batchGetMcStatus((Object)this.modelId, effectOrgIds, (Object)this.scenarioId, (Object)this.fyId, (Object)this.periodId);
            for (Map.Entry entry : mcStatusMap.entrySet()) {
                if (!((McStatus)entry.getValue()).getFlow().isSubmit()) continue;
                orgIds.add(entry.getKey());
            }
        }
        return orgIds;
    }

    private Map<String, List<DynamicObject>> queryReports(Long modelId, Long fyId, Long scenarioId, Long periodId, Set<Long> orgIds, List<Long> templateIds, Boolean isOnlyReport) {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId).and("scene", "=", (Object)scenarioId).and("fyear", "=", (Object)fyId).and("period", "=", (Object)periodId).and("entity", "in", orgIds).and("template", "in", templateIds);
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,entity.id,template.id,currency.id,modifier,modifytime,data,spreadjson", (QFilter[])qFilter.toArray());
        logger.info("\u6253\u5370\u63a5\u53e3 -- \u67e5\u8be2\u62a5\u8868\u8bb0\u5f55\u6570\uff1a " + reports.size());
        Map<String, List<DynamicObject>> reportMap = reports.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("entity.id") + SEPARATOR + dynamicObject.getLong("template.id")));
        return reportMap;
    }

    private Map<Long, DynamicObject> queryTemplates(List<Long> templateIds) {
        Object[] templates = BusinessDataServiceHelper.load((Object[])templateIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_templateentity"));
        logger.info("\u6253\u5370\u63a5\u53e3 -- \u67e5\u8be2\u62a5\u8868\u6a21\u677f\u8bb0\u5f55\u6570\uff1a " + templates.length);
        Map<Long, DynamicObject> templateMap = Lists.newArrayList((Object[])templates).stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong(ID), Function.identity()));
        return templateMap;
    }

    private Map<String, byte[]> printReports(Map<Long, DynamicObject> queryTemplates, List<PrintInfoDTO> printInfoDTOS, Map<Object, DynamicObject> effectOrgMap) {
        HashMap outsMap = Maps.newHashMapWithExpectedSize((int)printInfoDTOS.size());
        for (PrintInfoDTO printInfoDTO : printInfoDTOS) {
            String key = printInfoDTO.getKey();
            long effectTemplateId = printInfoDTO.getTemplateId();
            DynamicObject effectTemplate = queryTemplates.get(effectTemplateId);
            TemplateModel templateModel = TemplateModel.genImmutableModel((DynamicObject)effectTemplate);
            printInfoDTO.setIsSaveByDim(templateModel.isSaveByDim());
            byte[] bytes = this.getReportsBytes(printInfoDTO, templateModel, effectOrgMap);
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u9700\u8981\u6253\u5370\u7684\u6709\u6548\u5b57\u8282\u6570\u7ec4\uff1a" + Arrays.toString(bytes));
            if (bytes == null) continue;
            outsMap.put(key, bytes);
        }
        return outsMap;
    }

    private byte[] getReportsBytes(PrintInfoDTO printInfoDTO, TemplateModel templateModel, Map<Object, DynamicObject> effectOrgMap) {
        IDNumberTreeNode entityMember = MemberReader.findEntityMemberById((String)this.modelNumber, (Long)printInfoDTO.getOrgId());
        DynamicObject effectOrg = effectOrgMap.get(printInfoDTO.getOrgId());
        DynamicObject report = printInfoDTO.getDynamicObject();
        String spreadjson = report.getString("spreadjson");
        if (spreadjson == null || StringUtils.isEmpty((String)spreadjson)) {
            spreadjson = templateModel.getRptSpreadJson();
        }
        if (spreadjson != null && !StringUtils.isEmpty((String)spreadjson)) {
            spreadjson = spreadjson.substring(6);
        }
        Pair<List<Map<String, Object>>, List<Map<String, Object>>> olapValue = this.getOlapValue(printInfoDTO, templateModel, report, effectOrg, entityMember);
        return this.addSheet2JSONWorkBook(printInfoDTO, spreadjson, olapValue);
    }

    protected Pair<List<Map<String, Object>>, List<Map<String, Object>>> getOlapValue(PrintInfoDTO printInfoDTO, TemplateModel templateModel, DynamicObject report, DynamicObject effectOrg, IDNumberTreeNode entityMember) {
        SpreadManager spreadModel = null;
        spreadModel = printInfoDTO.isReport() != false && report.getString("data") != null && !StringUtils.isEmpty((String)report.getString("data")) ? JsonSerializerUtil.toSpreadManager((String)report.getString("data")) : JsonSerializerUtil.toSpreadManager((String)templateModel.getRptData());
        this.initSpreadFilter(spreadModel, templateModel, effectOrg);
        this.reportMultiExportService.initCellPeriod(spreadModel, this.periodDy.getString(NUMBER));
        this.reportMultiExportService.initCellYear(spreadModel, this.fyDy.getString(NUMBER));
        AutoFloatUtil.clearOldSeqInfo(spreadModel);
        this.autoFloat(printInfoDTO, entityMember.getNumber(), spreadModel, templateModel);
        List<Map<String, Object>> clearValues = this.clearMdDataDomainValue(printInfoDTO, spreadModel);
        this.tmpDataunit = this.viewDataunit;
        if (this.reportMultiExportService.getViewDataunit() == 1) {
            this.tmpDataunit = (Integer)spreadModel.getBook().getSheet(0).getUserObject("dataunit");
            this.divisor = BigDecimal.valueOf(Math.pow(10.0, this.tmpDataunit));
        }
        CellDimFilterUtil.cellDimFilterBuild((SpreadManager)spreadModel);
        new ReportDataRefleshService().reflesh(spreadModel, this.modelNumber, this.getOrgRelaMembSupplier(printInfoDTO.getOrgId(), entityMember.getNumber(), this.modelId), (IRelaMembSupplier)new PeriodRelaMembSupplier(this.modelNumber, this.fyDy.getString(NUMBER), this.periodDy.getString(NUMBER), this.scene.getString(NUMBER)));
        TemplateFloatUtil.clearNoDataRC(spreadModel);
        AutoFloatUtil.reGenerateSeqCol(spreadModel);
        Sheet effectiveSheet = spreadModel.getBook().getSheet(0);
        CalContext ctx = new CalContext(this.modelNumber, entityMember.getNumber(), this.fyDy.getString(NUMBER), this.periodDy.getString(NUMBER), this.scene.getString(NUMBER), this.cyNumber2Dy.get(effectOrg.getString("currency.number")).getString(NUMBER));
        this.reportMultiExportService.initRptInfoFormulaV2Model(effectiveSheet, (ICalContext)ctx, this.tmpDataunit);
        Pair<List<Map<String, Object>>, List<Map<String, Object>>> pair = this.createClientValuesConfig(printInfoDTO, templateModel, effectiveSheet, this.fyDy, this.periodDy, report, effectOrg);
        List cellValues = effectiveSheet.createClientValues_All(true);
        cellValues.addAll((Collection)pair.p1);
        clearValues.addAll((Collection)pair.p2);
        Set<String> needChangeUnitCells = this.reportMultiExportService.getNeedChangeUnitCells(spreadModel, effectiveSheet);
        this.reportMultiExportService.dealDataUnit((List<Map<String, Object>>)cellValues, needChangeUnitCells);
        return Pair.onePair(clearValues, (Object)cellValues);
    }

    protected void autoFloat(PrintInfoDTO printInfoDTO, String orgNum, SpreadManager sm, TemplateModel templateModel) {
        AutoFloatWithoutViewHandle impl = new AutoFloatWithoutViewHandle(sm, templateModel);
        impl.setModelId(this.modelId);
        impl.setRelaMembSupplier(this.getOrgRelaMembSupplier(printInfoDTO.getOrgId(), orgNum, this.modelId));
        for (PositionInfo positionInfo : sm.getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().size() <= 0) continue;
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                printInfoDTO.setFloat(true);
                AutoFloatWithoutViewHandle.cacheFloatType(basePointInfo.isDirectHoriz());
            }
        }
        impl.setPeriodSupplier((IRelaMembSupplier<String, String>)new PeriodRelaMembSupplier(this.modelNumber, this.fyDy.getString(NUMBER), this.periodDy.getString(NUMBER), this.scene.getString(NUMBER)));
        impl.autoFloat(false, orgNum);
    }

    private Pair<List<Map<String, Object>>, List<Map<String, Object>>> createClientValuesConfig(PrintInfoDTO printInfoDTO, TemplateModel tmplModel, Sheet sheet, DynamicObject year, DynamicObject period, DynamicObject report, DynamicObject currentOrg) {
        ArrayList cellValues = new ArrayList(10);
        ArrayList cellFValues = new ArrayList(10);
        sheet.iteratorCells(cell -> {
            if (cell.getFormula() != null) {
                HashMap<String, Object> e = new HashMap<String, Object>(3);
                e.put("r", cell.getRow());
                e.put("c", cell.getCol());
                String cellValue = "";
                if (cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("rpt")) {
                    cellValue = this.reportMultiExportService.dealRPTFormula(tmplModel, year, period, report, currentOrg, (Cell)cell, cellValue);
                } else if (cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith(WeaveInfoEnum.UNIT.getFormlua())) {
                    String ss = cell.getFormula().substring(5, cell.getFormula().length() - 1);
                    cellValue = ss + " " + currentOrg.getString(NAME);
                } else if (cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith(WeaveInfoEnum.DATE.getFormlua())) {
                    String ss = cell.getFormula().substring(5, cell.getFormula().length() - 1);
                    cellValue = ss + " " + year.getString(NAME) + period.getString(NAME);
                } else if (cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith(WeaveInfoEnum.CURRENCY.getFormlua())) {
                    cellValue = this.reportMultiExportService.dealCurrencyFormula(year, period, currentOrg, (Cell)cell);
                } else if (cell.getFormula().toLowerCase(Locale.ENGLISH).contains("acct")) {
                    cellFValues.add(e);
                    if (cell.isMdDataDomain()) {
                        e.put("v", cell.getValue());
                    }
                }
                if (!cellValue.isEmpty()) {
                    e.put("v", cellValue);
                    cellValues.add(e);
                }
                if (!printInfoDTO.isSaveByDim().booleanValue()) {
                    e = new HashMap(3);
                    e.put("r", cell.getRow());
                    e.put("c", cell.getCol());
                    e.put("v", cell.getValue());
                    cellValues.add(e);
                }
            }
        });
        Pair pair = Pair.onePair(cellValues, cellFValues);
        return pair;
    }

    private List<Map<String, Object>> clearMdDataDomainValue(PrintInfoDTO printInfoDTO, SpreadManager spreadModel) {
        ArrayList<Map<String, Object>> eValues = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < spreadModel.getBook().getSheetCount(); ++i) {
            spreadModel.getBook().getSheet(i).iteratorCells(cell -> {
                if (printInfoDTO.isSaveByDim().booleanValue() && cell.isMdDataDomain()) {
                    HashMap<String, Integer> e = new HashMap<String, Integer>(3);
                    e.put("r", cell.getRow());
                    e.put("c", cell.getCol());
                    e.put("v", null);
                    eValues.add(e);
                }
            });
            Sheet sheet = spreadModel.getBook().getSheet(0);
            for (int row = 0; row < sheet.getMaxRowCount(); ++row) {
                if (sheet.getRow(row) == null || !sheet.getRow(row).isEmpty()) continue;
                for (int col = 0; col < sheet.getMaxColumnCount(); ++col) {
                    HashMap<String, Integer> e = new HashMap<String, Integer>(3);
                    e.put("r", row);
                    e.put("c", col);
                    e.put("v", null);
                    eValues.add(e);
                }
            }
        }
        return eValues;
    }

    protected IRelaMembSupplier<String, String> getOrgRelaMembSupplier(long orgId, String orgNum, Long modelId) {
        OrgRelaMembSupplier supplier = new OrgRelaMembSupplier(Long.valueOf(orgId), orgNum, modelId);
        return supplier;
    }

    public byte[] addSheet2JSONWorkBook(PrintInfoDTO printInfoDTO, String spreadjson, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues) {
        try {
            if (spreadjson == null || StringUtils.isEmpty((String)spreadjson) || cellValues == null) {
                return null;
            }
            String reportJson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadjson)));
            JSONObject reportObject = JSON.parseObject((String)reportJson, (Feature[])new Feature[]{Feature.OrderedField});
            JSONObject sheets = (JSONObject)reportObject.get((Object)"sheets");
            for (Map.Entry k : sheets.entrySet()) {
                JSONObject sheet = (JSONObject)k.getValue();
                this.setSheetValue(printInfoDTO, sheet, cellValues);
            }
            return reportObject.toJSONString().getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void setSheetValue(PrintInfoDTO printInfoDTO, JSONObject sheet, Pair<List<Map<String, Object>>, List<Map<String, Object>>> values) {
        String colKey;
        JSONObject cell;
        JSONObject row;
        String rowKey;
        Map<String, List<String>> deleteData;
        JSONObject data = sheet.getJSONObject("data");
        JSONObject dataTable = data.getJSONObject("dataTable");
        if (dataTable == null) {
            return;
        }
        if (printInfoDTO.isFloat().booleanValue() && (deleteData = this.floatSpreadJson(dataTable, sheet)) != null && !deleteData.isEmpty()) {
            for (Map.Entry rowEntry : dataTable.entrySet()) {
                for (Map.Entry cellEntry : ((JSONObject)rowEntry.getValue()).entrySet()) {
                    ((JSONObject)cellEntry.getValue()).remove((Object)VALUE);
                }
            }
        }
        boolean isADJE = this.audittrial.getString(NUMBER).equals("ADJE");
        for (Map val : (List)values.p1) {
            int rowIndex = (Integer)val.get("r");
            int colIndex = (Integer)val.get("c");
            rowKey = String.valueOf(rowIndex);
            row = dataTable.getJSONObject(rowKey);
            if (row == null || (cell = row.getJSONObject(colKey = String.valueOf(colIndex))) == null) continue;
            if (printInfoDTO.isSaveByDim().booleanValue()) {
                if (isADJE) {
                    cell.put(VALUE, val.get("v"));
                    continue;
                }
                if (!val.containsKey("v")) continue;
                cell.put(VALUE, val.get("v"));
                continue;
            }
            cell.put(VALUE, val.get("v"));
        }
        for (Map val : (List)values.p2) {
            int rowIndex = (Integer)val.get("r");
            int colIndex = (Integer)val.get("c");
            rowKey = String.valueOf(rowIndex);
            row = dataTable.getJSONObject(rowKey);
            if (row == null) {
                row = new JSONObject();
                dataTable.put(rowKey, (Object)row);
            }
            if ((cell = row.getJSONObject(colKey = String.valueOf(colIndex))) == null) {
                cell = new JSONObject();
                row.put(colKey, (Object)cell);
            }
            if (val.get("v") != null && cell.get((Object)VALUE) instanceof String && val.get("v") instanceof String && cell.get((Object)VALUE).toString().trim().equals(val.get("v").toString().trim())) continue;
            if (printInfoDTO.isSaveByDim().booleanValue()) {
                cell.put(VALUE, val.get("v"));
                continue;
            }
            if (val.get("v") == null) continue;
            cell.put(VALUE, val.get("v"));
        }
        Set numbers = FormulaConfig.getInstance().getFormulaNumberSet();
        Predicate<String> testIsFormula = s -> {
            for (String number : numbers) {
                if (!s.contains(number)) continue;
                return true;
            }
            return false;
        };
        dataTable.forEach((r, p) -> {
            if (p != null) {
                ((JSONObject)p).forEach((c, v) -> {
                    if (v != null) {
                        Object formula = ((JSONObject)v).get((Object)FORMULA);
                        Object value = ((JSONObject)v).get((Object)VALUE);
                        if (formula != null && testIsFormula.test(formula.toString().toLowerCase(Locale.ENGLISH))) {
                            ((JSONObject)v).remove((Object)FORMULA);
                        }
                        if (!printInfoDTO.isReport().booleanValue() && value instanceof Integer && (Integer)value == 0) {
                            ((JSONObject)v).remove((Object)VALUE);
                        }
                    }
                });
            }
        });
        if (printInfoDTO.isFloat().booleanValue()) {
            data.put("dataTable", (Object)dataTable);
        }
        ThreadCache.remove((Object)"floatarea");
    }

    protected Map<String, List<String>> floatSpreadJson(JSONObject dataTable, JSONObject sheet) {
        Object serialStr = ThreadCache.get((Object)"floatarea");
        HashMap<String, List<String>> deleteDatas = new HashMap<String, List<String>>(16);
        if (serialStr == null) {
            return deleteDatas;
        }
        List floatAreas = (List)serialStr;
        dataTable = this.transposeTable(dataTable, floatAreas);
        JSONObject copydataTable = new JSONObject(new LinkedHashMap(2000));
        int allFloatSize = 0;
        int anti_lastEndIndex = 0;
        int lastEndIndex = 0;
        for (AutoFloatLogicImpl.FloatArea floatArea : floatAreas) {
            if (floatArea.isHasFloat()) {
                String key;
                ArrayList<String> deleteData = new ArrayList<String>(16);
                for (Integer index : floatArea.getDeledata()) {
                    deleteData.add(String.valueOf(index));
                }
                String string = key = floatArea.isCol() ? "c" : "r";
                if (deleteDatas.get(key) != null) {
                    ((List)deleteDatas.get(key)).addAll(deleteData);
                    continue;
                }
                deleteDatas.put(key, deleteData);
                continue;
            }
            JSONObject copyRow = dataTable.getJSONObject(String.valueOf(floatArea.getOriginalendIndex()));
            if (copyRow == null) {
                return deleteDatas;
            }
            String copyRowJson = copyRow.toJSONString();
            int floatfixIndex = 0;
            int fixIndex = 0;
            for (Map.Entry entry : dataTable.entrySet()) {
                int anti_row = Integer.parseInt((String)entry.getKey());
                if (anti_row < floatArea.getOriginalStartIndex() && anti_row > anti_lastEndIndex || anti_row == 0 && anti_lastEndIndex == 0) {
                    copydataTable.put(String.valueOf(lastEndIndex + fixIndex), entry.getValue());
                    ++fixIndex;
                    continue;
                }
                if (anti_row != floatArea.getOriginalStartIndex()) continue;
                for (int i = 0; i < floatArea.getFloatSize(); ++i) {
                    int index = lastEndIndex + fixIndex + floatfixIndex + i;
                    if (anti_row >= floatArea.getOriginalStartIndex() && anti_row <= floatArea.getOriginalendIndex()) {
                        copydataTable.put(String.valueOf(index), dataTable.get((Object)anti_row));
                        ++anti_row;
                        continue;
                    }
                    JSONObject value = JSON.parseObject((String)copyRowJson, (Feature[])new Feature[]{Feature.OrderedField});
                    copydataTable.put(String.valueOf(index), (Object)value);
                }
            }
            anti_lastEndIndex = floatArea.getOriginalendIndex();
            allFloatSize += floatArea.getFloatSize();
            lastEndIndex += fixIndex + floatArea.getFloatSize() + floatfixIndex;
        }
        FixRangeAdjustService fservice = new FixRangeAdjustService(floatAreas);
        Object spansObj = sheet.get((Object)"spans");
        fservice.doAdjust(spansObj);
        int endFixIndex = 0;
        for (Map.Entry entry : dataTable.entrySet()) {
            int anti_row = Integer.parseInt((String)entry.getKey());
            if (anti_row <= anti_lastEndIndex && anti_lastEndIndex != 0) continue;
            copydataTable.put(String.valueOf(lastEndIndex + endFixIndex), entry.getValue());
            ++endFixIndex;
        }
        copydataTable = this.transposeTable(copydataTable, floatAreas);
        dataTable.clear();
        dataTable.putAll((Map)copydataTable);
        return deleteDatas;
    }

    private JSONObject transposeTable(JSONObject dataTable, List<AutoFloatLogicImpl.FloatArea> floatAreas) {
        if (floatAreas != null && !floatAreas.isEmpty() && floatAreas.get(0).isCol()) {
            JSONObject transPoseTable = new JSONObject(new LinkedHashMap(2000));
            for (Map.Entry rowEntry : dataTable.entrySet()) {
                for (Map.Entry colEntry : ((JSONObject)rowEntry.getValue()).entrySet()) {
                    Object o = transPoseTable.get(colEntry.getKey());
                    if (o != null) {
                        ((JSONObject)o).put((String)rowEntry.getKey(), colEntry.getValue());
                        continue;
                    }
                    JSONObject transPoseRowTable = new JSONObject(new LinkedHashMap(2000));
                    transPoseRowTable.put((String)rowEntry.getKey(), colEntry.getValue());
                    transPoseTable.put((String)colEntry.getKey(), (Object)transPoseRowTable);
                }
            }
            ArrayList<String> keys = new ArrayList<String>(16);
            keys.addAll(transPoseTable.keySet());
            keys.sort(Comparator.comparing(Integer::valueOf));
            JSONObject sortdataTable = new JSONObject(true);
            for (String key : keys) {
                sortdataTable.put(key, transPoseTable.get((Object)key));
            }
            dataTable.clear();
            dataTable.putAll((Map)sortdataTable);
        }
        return dataTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generatePDFUrl(String fileName, byte[] bytes) {
        ByteArrayInputStream excelStream = new ByteArrayInputStream(bytes);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String json = SpreadUtils.getStrFromInsByCode((InputStream)excelStream, (Charset)StandardCharsets.UTF_8);
        logger.info("\u6253\u5370\u63a5\u53e3 -- \u751f\u6210\u6253\u5370\u62a5\u8868url:json:" + json);
        String pdfURL = "";
        ByteArrayOutputStream out = null;
        try {
            out = SpreadUtils.getByteArrayOutputStream((String)json);
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u751f\u6210\u6253\u5370\u62a5\u8868url:out:" + out.toString());
            pdfURL = cache.saveAsUrl(fileName + ".pdf", out.toByteArray(), this.timeout);
            logger.info("\u6253\u5370\u63a5\u53e3 -- \u751f\u6210\u6253\u5370\u62a5\u8868url:pdfURL:" + pdfURL);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                ((InputStream)excelStream).close();
            }
            catch (IOException e) {
                logger.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
        }
        return pdfURL;
    }

    private Map<String, String> getPDFUrls(Map<String, byte[]> outMaps) {
        HashMap urlMap = Maps.newHashMap();
        outMaps.forEach((key, bytes) -> {
            if (((byte[])bytes).length == 0) {
                return;
            }
            String url = this.generatePDFUrl((String)key, (byte[])bytes);
            urlMap.put(key, url);
        });
        if (!urlMap.isEmpty()) {
            urlMap.put("type_0", "pdf");
        }
        return urlMap;
    }

    protected void initSpreadFilter(SpreadManager spm, TemplateModel template, DynamicObject orgDy) {
        FilterView spmFilter = spm.getFilter();
        if (spmFilter == null) {
            String entityNumber;
            ViewPointDimDomain view = new ViewPointDimDomain();
            PageDimDomain page = new PageDimDomain();
            IDimension dim = null;
            IDimMember member = null;
            boolean isViewEntity = false;
            Predicate<String> testEntity = s -> s.equals("bcm_entitymembertree");
            for (ViewPointDimensionEntry v : template.getViewPointDimensionEntries()) {
                entityNumber = v.getDimension().getMemberEntityNumber();
                if (!testEntity.test(entityNumber)) continue;
                isViewEntity = true;
            }
            for (ViewPointDimensionEntry v : template.getPageDimensionEntries()) {
                entityNumber = v.getDimension().getMemberEntityNumber();
                if (!testEntity.test(entityNumber)) continue;
                isViewEntity = true;
            }
            for (ViewPointDimensionEntry v : template.getPagePropEntries()) {
                entityNumber = v.getDimension().getMemberEntityNumber();
                if (!testEntity.test(entityNumber)) continue;
                isViewEntity = true;
            }
            for (ViewPointDimensionEntry v : template.getViewPointDimensionEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                member = ObjectConvertUtils.toDimMember(v.getMember(), dim);
                logger.info("initSpreadFilter: ViewPointDimensionEntry for: " + member);
                dim.addMember(member);
                view.addDimension(dim);
            }
            JSONObject dims = this.collectDimensionInfo(orgDy, isViewEntity);
            for (PageDimensionEntry v : template.getPageDimensionEntries()) {
                Member m;
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                String entityNumber2 = v.getDimension().getMemberEntityNumber();
                if (dims.containsKey((Object)entityNumber2)) {
                    JSONObject item = (JSONObject)dims.get((Object)entityNumber2);
                    m = new Member();
                    m.setName(item.getString(NAME));
                    m.setNumber(item.getString(NUMBER));
                    member = ObjectConvertUtils.toDimMember(m, dim);
                } else {
                    if (v.getMembers().isEmpty() && "bcm_entitymembertree".equals(entityNumber2)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u9ed8\u8ba4\u6210\u5458\u672a\u8bbe\u7f6e\u3002", (String)"ReportPrintMsServiceImpl_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    Member vMemb = (Member)v.getMembers().get(0);
                    if ("bcm_processmembertree".equals(entityNumber2)) {
                        m = vMemb;
                        member = this.getMember(m, dim);
                        member.setNumber(this.process.getString(NUMBER));
                        logger.info("initSpreadFilter: ViewPointDimensionEntry for: " + member);
                    } else if ("bcm_audittrialmembertree".equals(entityNumber2)) {
                        m = vMemb;
                        member = this.getMember(m, dim);
                        member.setNumber(this.audittrial.getString(NUMBER));
                    } else {
                        m = vMemb;
                        member = this.getMember(m, dim);
                    }
                    this.membCache.put(vMemb.getId() + "#" + vMemb.getScope(), member);
                }
                dim.addMember(member);
                page.addDimension(dim);
            }
            for (PageDimensionEntry v : template.getPagePropEntries()) {
                Member m;
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                if (dims.containsKey((Object)v.getDimension().getMemberEntityNumber())) {
                    JSONObject item = (JSONObject)dims.get((Object)v.getDimension().getMemberEntityNumber());
                    m = new Member();
                    m.setName(item.getString(NAME));
                    m.setNumber(item.getString(NUMBER));
                    member = ObjectConvertUtils.toDimMember(m, dim);
                    dim.addMember(member);
                } else {
                    DynamicObjectCollection members = kd.fi.bcm.formplugin.spread.SpreadUtils.queryMemberByMembProperty(v.getCustomProperties(), (List<MembProperty>)v.getAllMembProperties(), v.getDimension());
                    if (members != null && members.size() > 0) {
                        m = new Member();
                        m.setName(((DynamicObject)members.get(0)).getString(NAME));
                        m.setNumber(((DynamicObject)members.get(0)).getString(NUMBER));
                        member = ObjectConvertUtils.toDimMember(m, dim);
                        dim.addMember(member);
                    }
                }
                page.addDimension(dim);
            }
            spm.setFilter(new FilterView(view, page));
        } else {
            for (IDimension dimension : spmFilter.getPageDomain().getDimensions()) {
                DimMember dimMember;
                if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimension.getNumber())) {
                    dimension.getMembers().clear();
                    dimMember = new DimMember(this.audittrial.getString(NAME), this.audittrial.getString(NUMBER), null, dimension);
                    dimension.addMember((IDimMember)dimMember);
                    continue;
                }
                if (!DimTypesEnum.PROCESS.getNumber().equals(dimension.getNumber())) continue;
                dimension.getMembers().clear();
                dimMember = new DimMember(this.process.getString(NAME), this.process.getString(NUMBER), null, dimension);
                dimension.addMember((IDimMember)dimMember);
            }
        }
    }

    protected IDimMember getMember(Member m, IDimension dim) {
        int scope = m.getScope();
        long memberid = m.getId();
        DimMember member = null;
        String key = memberid + "#" + scope;
        if (this.membCache.containsKey(key)) {
            return this.membCache.get(key);
        }
        if (scope == RangeEnum.VALUE_20.getValue() || scope == RangeEnum.VALUE_40.getValue()) {
            QFilter qf = new QFilter("parent", "=", (Object)memberid);
            DynamicObject dot = this.queryOne(m.getDataEntityNumber(), "id,name,number,simpleName", new QFilter[]{qf});
            if (dot != null) {
                member = new DimMember(dot.getString(NAME), dot.getString(NUMBER), dot.getString(NAME), dim);
            }
            return member;
        }
        if (scope == RangeEnum.VALUE_60.getValue()) {
            QFilter qf = new QFilter(ID, "=", (Object)memberid);
            DynamicObject dot = this.queryOne(m.getDataEntityNumber(), "parent", new QFilter[]{qf});
            if (dot != null) {
                long parentid = dot.getLong("parent");
                QFilter qf1 = new QFilter("parent", "=", (Object)parentid);
                QFilter qf2 = new QFilter(ID, "!=", (Object)memberid);
                dot = this.queryOne(m.getDataEntityNumber(), "id,name,number,simpleName", new QFilter[]{qf1, qf2});
            }
            if (dot != null) {
                member = new DimMember(dot.getString(NAME), dot.getString(NUMBER), dot.getString("simpleName"), dim);
            }
            return member;
        }
        if (scope == RangeEnum.VALUE_90.getValue() || scope == RangeEnum.VALUE_110.getValue()) {
            String pLongNum = QueryServiceHelper.queryOne((String)m.getDataEntityNumber(), (String)LONG_NUMBER, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)m.getId())}).getString(LONG_NUMBER);
            DynamicObject dot = this.queryOne(m.getDataEntityNumber(), "id,name,number,simpleName", new QFilter[]{new QFilter(LONG_NUMBER, "like", (Object)(pLongNum + '!' + "%")).or(LONG_NUMBER, "=", (Object)pLongNum), new QFilter(MODEL, "=", (Object)this.modelId), new QFilter("isleaf", "=", (Object)(scope == RangeEnum.VALUE_90.getValue() ? 1 : 0))});
            if (dot != null) {
                member = new DimMember(dot.getString(NAME), dot.getString(NUMBER), dot.getString("simpleName"), dim);
            }
            return member;
        }
        member = new DimMember(m.getName(), m.getNumber(), m.getName(), dim);
        return member;
    }

    private DynamicObject queryOne(String entityName, String selectFields, QFilter[] filters) {
        DynamicObjectCollection list = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])filters, (String)"level, dseq", (int)1);
        return list.size() == 0 ? null : (DynamicObject)list.get(0);
    }

    private JSONObject collectDimensionInfo(DynamicObject orgDy, boolean isViewEntity) {
        HashMap<String, Object> dimItem;
        List<DynamicObject> dims = this.getCommonFilter(orgDy, isViewEntity);
        JSONObject dimInfoMap = new JSONObject();
        for (DynamicObject dy : dims) {
            dimItem = new HashMap<String, Object>(16);
            dimItem.put(NAME, dy.getString(NAME));
            dimItem.put(NUMBER, dy.getString(NUMBER));
            dimItem.put(ID, dy.getLong(ID));
            dimInfoMap.put(dy.getString("dimension.membermodel"), JSON.toJSON(dimItem));
        }
        String orgName = orgDy.getString(NAME);
        String orgNumber = orgDy.getString(NUMBER);
        long orgId = orgDy.getLong(ID);
        dimItem = new HashMap(16);
        dimItem.put(NAME, orgName);
        dimItem.put(NUMBER, orgNumber);
        dimItem.put(ID, orgId);
        dimInfoMap.put("bcm_entitymembertree", JSON.toJSON(dimItem));
        return dimInfoMap;
    }

    private List<DynamicObject> getCommonFilter(DynamicObject orgDy, boolean isViewEntity) {
        DynamicObject currency;
        String cyNumber;
        DynamicObject year = this.fyDy;
        DynamicObject period = this.periodDy;
        if (this.currencyDy.getString(NUMBER).equals("EC") || this.currencyDy.getString(NUMBER).equals("DC")) {
            String string = cyNumber = isViewEntity ? orgDy.getString("currency.number") : this.currencyDy.getString(NUMBER);
            if (this.cyNumber2Dy.get(cyNumber) == null) {
                QFilter f = new QFilter(NUMBER, "=", (Object)cyNumber);
                f.and(new QFilter(MODEL, "=", (Object)this.modelId));
                currency = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)commonSelectProperties, (QFilter[])new QFilter[]{f});
                this.cyNumber2Dy.put(cyNumber, currency);
            } else {
                currency = this.cyNumber2Dy.get(cyNumber);
            }
        } else {
            cyNumber = this.currencyDy.getString(NUMBER);
            if (this.cyNumber2Dy.get(cyNumber) == null) {
                currency = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)commonSelectProperties, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)this.currencyDy.getLong(ID))});
                this.cyNumber2Dy.put(cyNumber, currency);
            } else {
                currency = this.cyNumber2Dy.get(cyNumber);
            }
        }
        ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(10);
        dys.add(this.scene);
        dys.add(year);
        dys.add(period);
        dys.add(currency);
        return dys;
    }

    private String getLogInitParam() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--- initParam ---").append(System.lineSeparator()).append("fyId:").append(this.fyDy.getLong(ID)).append(" ").append("scenarioId:").append(this.scene.getLong(ID)).append(" ").append("periodId:").append(this.periodDy.getLong(ID)).append(" ").append("currencyId").append(this.currencyDy.getLong(ID)).append(" ").append("audittrial").append(this.audittrial.getLong(ID)).append(" ").append("process").append(this.process.getLong(ID));
        return stringBuilder.toString();
    }

    private String getLogEnterParam(Map<Long, Integer> orgs, List<Long> templateIds, Boolean isOnlyReport) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--- enterParam ---").append(System.lineSeparator()).append("modelId:").append(this.modelId).append(" ").append("fyId:").append(this.fyId).append(" ").append("scenarioId:").append(this.scenarioId).append(" ").append("periodId:").append(this.periodId).append(" ").append("currencyId").append(this.currencyId).append(" ").append("viewDataunit").append(this.viewDataunit).append(" ").append("isOnlyReport").append(isOnlyReport).append(" ").append("templateIds").append(templateIds.toArray()).append("orgs").append(orgs.toString());
        return stringBuilder.toString();
    }

    public void buildService(ReportMultiExportService service, ReportExportParam param, int viewDataunit, String cube, Long modelId, boolean needCheckOrgPerm, boolean fromAEF) {
        service.setKeepSomeSetting(false);
        String atNum = (String)param.getDim2Mems().get(DimTypesEnum.AUDITTRIAL.getNumber());
        DynamicObject atDy = ExportUtils.getMemberDy((long)modelId, (String)atNum, (String)"bcm_audittrialmembertree");
        HashMap<String, DynamicObject> auditMap = new HashMap<String, DynamicObject>(16);
        auditMap.put(atNum, atDy);
        service.setAuditMap(auditMap);
        service.setAudittrial(atDy);
        service.setCube(cube);
        service.setCyNumber2Dy(ExportUtils.getModelCyDys((long)modelId));
        String cyNum = param.getCurrency();
        DynamicObject cyDy = service.getCyNumber2Dy().get(cyNum);
        service.setCyObj_view(cyDy);
        service.setViewDataunit(viewDataunit);
        service.setDivisor(this.divisor);
        service.setExcelfiletype(CHECK_PERIOD);
        service.setSchemeName("");
        service.setFileruleStr("ORGID_TEMID");
        service.setFiletxt("");
        service.setFloat(false);
        service.setScale(this.scale);
        String fyNum = param.getYear();
        String periodNum = param.getPeriod();
        DynamicObject fyDy = ExportUtils.getMemberDy((long)modelId, (String)fyNum, (String)"bcm_fymembertree");
        DynamicObject periodDy = ExportUtils.getMemberDy((long)modelId, (String)periodNum, (String)"bcm_periodmembertree");
        FYPeriodPair fyPeriodPair = new FYPeriodPair(fyNum + "|" + periodNum, fyDy, periodDy);
        service.setFyPeriodPairs(Lists.newArrayList((Object[])new FYPeriodPair[]{fyPeriodPair}));
        service.setModelId(modelId);
        String bpNum = (String)param.getDim2Mems().get(DimTypesEnum.PROCESS.getNumber());
        DynamicObject bpDy = ExportUtils.getMemberDy((long)modelId, (String)bpNum, (String)"bcm_processmembertree");
        HashMap<String, DynamicObject> bpMap = new HashMap<String, DynamicObject>(16);
        bpMap.put(bpNum, bpDy);
        service.setProcess(bpDy);
        service.setProcessMap(bpMap);
        service.setReport(false);
        service.setSaveByDim(false);
        service.setScale(-1);
        service.setScaleStr("");
        String sceneNum = param.getSceneNum();
        DynamicObject sceneDy = ExportUtils.getMemberDy((long)modelId, (String)sceneNum, (String)"bcm_scenemembertree");
        service.setScene(sceneDy);
        service.setScene_view(sceneDy);
        service.setCslscheme_view(null);
        service.setSheetruleStr("reportname");
        service.setSheettxt("");
        service.setUnweave(true);
        service.setReportStatus(Lists.newArrayList((Object[])new String[]{"B", "C", "D", "E"}));
        service.setStartYear(fyDy);
        service.setStartPeriod(periodDy);
        service.setEndYear(fyDy);
        service.setEndPeriod(periodDy);
        service.setFilterEfftiveOrg(false);
        DynamicObjectCollection tempDoc = ExportUtils.getTempDoc4AEF((List)param.getTmps(), (long)modelId);
        service.setTempDoc(tempDoc);
        DynamicObjectCollection orgDoc = ExportUtils.getOrgDoc((List)param.getOrgs(), (long)modelId);
        service.setOrgDoc(orgDoc);
        service.setPageSourceEnum(ExportPageSourceEnum.DEFAULT);
        service.setSchemeId(0L);
        service.setPackDownload(false);
        service.setSourcestyle(EXCEL);
        service.setFloatdispay("3");
        service.setFiletype("3");
        service.setCsl(false);
        Map dimNum2Items = ExportUtils.getDimNum2Items((Map)param.getDim2Mems(), (long)modelId);
        service.setDimNum2Items(dimNum2Items);
        service.setZipFileName(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u6587\u4ef6%s", (String)"ExportServiceConstructor_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())));
        service.setrNumbers(param.getTmps());
        service.setNeedCheckOrgPerm(needCheckOrgPerm);
        service.setFromAEF(fromAEF);
    }
}

