/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.carry;

import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.carry.CarryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class BeginYearCarryConfirmPlugin
extends AbstractBaseFormPlugin {
    private static final String model = "model";
    private static final String scenario = "scenario";
    private static final String year = "year";
    private static final String period = "period";
    private static final String lastscenario = "lastscenario";
    private static final String lastyear = "lastyear";
    private static final String lastperiod = "lastperiod";
    private static final String currency = "currency";
    private static final String btn_ok = "btn_ok";
    private static final String ACCOUNT = "account";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(BeginYearCarryConfirmPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_ok, ACCOUNT);
        BasedataEdit lastperiodBE = (BasedataEdit)this.getControl(lastperiod);
        lastperiodBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit lastscenar = (BasedataEdit)this.getControl(lastscenario);
        lastscenar.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntry();
        this.setVisible();
    }

    private void setVisible() {
        if (this.getView().getFormShowParameter().getCustomParam("templateid") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap8", "flexpanelap9"});
        }
        if ("bcm_carrylist".equals(this.getView().getParentView().getEntityId())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ACCOUNT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap8", "flexpanelap9"});
            this.getView().updateView();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ACCOUNT});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Set<Long> perm;
        super.beforeF7Select(arg0);
        BasedataEdit bs = (BasedataEdit)arg0.getSource();
        String key = bs.getKey();
        if (key.equals(lastperiod)) {
            if (this.getModel().getValue(lastscenario, 0) != null) {
                this.setF7Qfilter(arg0);
            }
        } else if (lastscenario.equals(key) && !(perm = this.getPerm()).isEmpty()) {
            ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            listFilterParameter.setFilter(new QFilter("id", "not in", perm));
        }
    }

    private Set<Long> getPerm() {
        boolean modelManager = MemberPermHelper.isModelManager((Long)this.getModelId());
        HashSet<Long> set = new HashSet<Long>();
        if (modelManager) {
            return set;
        }
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_scenemembertree", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
        Collection entries = map.entries();
        for (Map.Entry entrie : entries) {
            if (!DataTypeEnum.NO.getIndex().equals(entrie.getKey())) continue;
            set.add((Long)entrie.getValue());
        }
        return set;
    }

    private void setF7Qfilter(BeforeF7SelectEvent e) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(model, "=", (Object)this.getModelId()));
        Long scenarioId = ((DynamicObject)this.getModel().getValue(lastscenario, 0)).getLong("id");
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)scenarioId, (String)"bcm_scenemembertree", (String)"sceneperiod");
        ArrayList ids = new ArrayList();
        DynamicObjectCollection sceneperiod = dot.getDynamicObjectCollection("sceneperiod");
        sceneperiod.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
        DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,isleaf,isadjust,useyear,dseq", (QFilter[])new QFilter("model.id", "=", (Object)this.getModelId()).toArray(), (String)"level,dseq");
        for (DynamicObject member : members) {
            if (!member.getBoolean("isadjust") || member.getString("useyear").contains(((DynamicObject)this.getModel().getValue(lastyear, e.getRow())).getString("number"))) continue;
            ids.remove(member.getLong("id"));
        }
        qFilters.add(new QFilter("id", "in", ids));
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        listFilterParameter.setQFilters(qFilters);
        listFilterParameter.setOrderBy("dseq");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (lastscenario.equals(propertyName)) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null && oldValue != null) {
                this.getModel().setValue(e.getProperty().toString(), (Object)oldValue.getLong("id"));
                return;
            }
            this.getModel().setValue(lastperiod, null, 0);
            this.getView().updateView(lastperiod, 0);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(btn_ok)) {
            this.validatorCondition();
            Set<Long> templateIds = this.getSelectTemplateIds();
            if (templateIds == null || templateIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5e74\u7ed3\u7684\u62a5\u8868\u8bb0\u5f55\u3002", (String)"BeginYearCarryConfirmPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            boolean isDC = ((DynamicObject)this.getModel().getValue(currency)).getString("number").equals(CurrencyEnum.DC.number);
            Map<String, String> paramMap = this.getParam(isDC);
            Map<Long, Set<String>> orgIdNumberMap = this.getOrgNumbers(paramMap);
            HashSet<String> orgnumbers = new HashSet<String>(16);
            for (Set<String> numset : orgIdNumberMap.values()) {
                orgnumbers.addAll(numset);
            }
            Long modelId = Long.valueOf(paramMap.get("modelId"));
            Long scenarioId = Long.valueOf(paramMap.get("scenarioId"));
            Long yearId = Long.valueOf(paramMap.get("yearId"));
            Long periodId = Long.valueOf(paramMap.get("periodId"));
            Map mcStatusMap = McStatus.batchGetMcStatus((Object)modelId, orgIdNumberMap.keySet(), (Object)scenarioId, (Object)yearId, (Object)periodId);
            for (Map.Entry<Long, Set<String>> entry : orgIdNumberMap.entrySet()) {
                McStatus mcStatus = (McStatus)mcStatusMap.get(entry.getKey());
                if (!mcStatus.getFlow().isSubmit()) continue;
                orgnumbers.removeAll((Collection)entry.getValue());
            }
            String onlyselfOrNot = (String)this.getModel().getValue("radiogroupfield");
            if (orgnumbers.isEmpty()) {
                if ("1".equals(onlyselfOrNot)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u5e01\u62a5\u8868\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u5e74\u521d\u7ed3\u8f6c\u3002", (String)"BeginYearCarryConfirmPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5e74\u7ed3\u6210\u529f\uff0c\u5df2\u8df3\u8fc7\u667a\u80fd\u5408\u5e76\u4e2d\u6d41\u7a0b\u72b6\u6001\u4e3a\u975e\u5904\u7406\u4e2d\u7684\u7ec4\u7ec7\u8bb0\u5f55\u3002", (String)"BeginYearCarryConfirmPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                for (Long templateId : templateIds) {
                    if (isDC) {
                        this.carryOperation(templateId, paramMap, orgnumbers, null);
                        continue;
                    }
                    if (CurrencyEnum.EC.number.equals(paramMap.get("currencyNum")) && "1".equals(onlyselfOrNot)) {
                        if (orgnumbers.size() != 1) {
                            return;
                        }
                        Long orgId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("orgid"));
                        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"currency.number", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
                        if (org == null || org.getString("currency.number") == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u5e01\u4e3a\u7a7a\u3002", (String)"BeginYearCarryConfirmPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                        this.carryOperation(templateId, paramMap, orgnumbers, org.getString("currency.number"));
                        continue;
                    }
                    this.carryOperation(templateId, paramMap, orgnumbers, paramMap.get("currencyNum"));
                }
            }
            catch (NumberFormatException e) {
                throw new KDBizException(e.getMessage());
            }
            Object logMessageMap = this.getView().getFormShowParameter().getCustomParams().get("logMap");
            String yearNum = paramMap.get("yearNum");
            String periodNum = paramMap.get("periodNum");
            try {
                Map map = (Map)JSONUtils.cast((String)logMessageMap.toString(), Map.class);
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    ArrayList value = (ArrayList)iterator.next().getValue();
                    String norgName = (String)value.get(0);
                    String number = (String)value.get(1);
                    String name = (String)value.get(2);
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5e74\u7ed3", "BeginYearCarryConfirmPlugin_1", "fi-bcm-formplugin", "Carry Forward"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s %4$s %5$s\uff0c\u5e74\u7ed3\u64cd\u4f5c\u6210\u529f", "BeginYearCarryConfirmPlugin_2", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{norgName, yearNum, periodNum, number, name})));
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            if ("1".equals(onlyselfOrNot)) {
                this.returnDataToParent(ResManager.loadKDString((String)"\u5e74\u7ed3\u6267\u884c\u6210\u529f\u3002", (String)"BeginYearCarryConfirmPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.returnDataToParent(ResManager.loadKDString((String)"\u5e74\u7ed3\u6210\u529f\uff0c\u5df2\u8df3\u8fc7\u667a\u80fd\u5408\u5e76\u4e2d\u6d41\u7a0b\u72b6\u6001\u4e3a\u975e\u5904\u7406\u4e2d\u7684\u7ec4\u7ec7\u8bb0\u5f55\u3002", (String)"BeginYearCarryConfirmPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getView().close();
        } else if (ACCOUNT.equals(key)) {
            FormShowParameter para = new FormShowParameter();
            DimensionMsgCache dmc = new DimensionMsgCache(this.getModelId());
            para.setFormId("bcm_mulmemberf7base_tem");
            para.getOpenStyle().setShowType(ShowType.Modal);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("dimension", String.valueOf(dmc.getSeq(DimTypesEnum.ACCOUNT.getNumber())));
            params.put("sign", key);
            para.setCustomParams(params);
            para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"BeginYearCarryConfirmPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dmc.getName(key)));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            para.setCloseCallBack(closeCallBack);
            if (StringUtils.isEmpty((String)this.getModel().getValue(ACCOUNT, 0).toString())) {
                this.getPageCache().put(ACCOUNT, null);
            }
            this.getView().showForm(para);
        }
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if (ACCOUNT.equals(key) && cb.getReturnData() != null) {
            DynamicObjectCollection docs = (DynamicObjectCollection)cb.getReturnData();
            StringBuilder sb = new StringBuilder();
            ArrayList list = new ArrayList(docs.size());
            for (int i = 0; i < docs.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                DynamicObject doc = (DynamicObject)docs.get(i);
                map.put("id", doc.get(4).toString());
                map.put("scope", doc.get(5).toString());
                map.put("number", doc.get(2).toString());
                map.put("name", doc.get(3).toString());
                map.put("pid", doc.get(6).toString());
                if (RangeEnum.getRangeByVal((int)doc.getInt(5)) == RangeEnum.VALUE_10) {
                    sb.append(doc.get(2).toString()).append(' ');
                    sb.append(doc.get(3).toString()).append(';').append(' ');
                } else {
                    sb.append(doc.get(2).toString()).append(' ').append(doc.get(3).toString()).append(ResManager.loadKDString((String)"\u7684", (String)"BeginYearCarryConfirmPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)doc.getInt(5)).getName()).append(';').append(' ');
                }
                list.add(map);
            }
            if (sb.length() > 0 && !"null".equals(sb.toString()) && !"".equals(sb.toString())) {
                this.getModel().setValue(key, (Object)sb.substring(0, sb.length() - 1));
                this.getPageCache().put(ACCOUNT, SerializationUtils.toJsonString(list));
            }
        }
    }

    private void carryOperation(Long templateid, Map<String, String> paramMap, Set<String> orgs, String currency) {
        try {
            HashSet accounts = new HashSet();
            List scope = SpreadMemUtil.analysisMemberFromSheet((SpreadManager)SpreadMemUtil.querySpreadManager((Long)templateid), (TemplateModel)TemplateUtil.getTempModel((Object)templateid), (String[])new String[]{DimTypesEnum.CHANGETYPE.getNumber(), DimTypesEnum.ACCOUNT.getNumber()});
            scope.forEach(e -> {
                Set cts = (Set)e.get(PresetConstant.CHANGETYPE_DIM);
                if (cts != null && (cts.contains("BFLY") || cts.contains("BBOY"))) {
                    accounts.addAll((Collection)e.get(PresetConstant.ACCOUNT_DIM));
                }
            });
            if (!accounts.isEmpty()) {
                CarryServiceHelper.simpleCarry((long)Long.parseLong(paramMap.get("modelId")), (String)paramMap.get("modelNum"), (String)paramMap.get("lastScenarioNum"), (String)paramMap.get("lastyearNum"), (String)paramMap.get("lastperiodNum"), (String)paramMap.get("scenarioNum"), (String)paramMap.get("yearNum"), (String)paramMap.get("periodNum"), orgs, accounts, (String)currency);
            }
        }
        catch (Exception e2) {
            log.error((Throwable)e2);
            throw new KDBizException(e2.getMessage());
        }
    }

    private Set<Long> getSelectTemplateIds() {
        HashSet<Long> templateids = new HashSet<Long>();
        if (this.getView().getFormShowParameter().getCustomParam("templateid") != null) {
            templateids.add((Long)this.getView().getFormShowParameter().getCustomParam("templateid"));
        } else {
            List carryids = (List)this.getView().getFormShowParameter().getCustomParam("carryids");
            QFilter filter = new QFilter("id", "in", (Object)carryids);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_reportlistentity", (String)"id, template", (QFilter[])new QFilter[]{filter});
            for (DynamicObject col : collection) {
                templateids.add(col.getLong("template"));
            }
        }
        return templateids;
    }

    private Map<Long, Set<String>> getOrgNumbers(Map<String, String> paramMap) {
        HashMap<Long, Set<String>> orgIdNumberMap = new HashMap<Long, Set<String>>(16);
        String orgid = (String)this.getView().getFormShowParameter().getCustomParam("orgid");
        String onlyselfOrNot = (String)this.getModel().getValue("radiogroupfield");
        DynamicObject org = QueryDimensionServiceHelper.getMemMsgById((String)orgid, (String)"bcm_entitymembertree");
        if (!DimTypesEnum.ENTITY.getNumber().equals(org.getString("number")) && "2".equals(onlyselfOrNot)) {
            QFBuilder qf = new QFBuilder(model, "=", (Object)ConvertUtil.convertStrToLong((String)paramMap.get("modelId")));
            qf.add("cslscheme", "=", (Object)org.getLong("cslscheme"));
            qf.add("longnumber", "like", (Object)(org.getString("longnumber") + "%"));
            DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,parent.number", (QFilter[])qf.toArray());
            result.forEach(e -> {
                HashSet<String> tempnums = new HashSet<String>(2);
                tempnums.add(e.getString("number"));
                tempnums.add(e.getString("parent.number") + "_" + e.getString("number"));
                orgIdNumberMap.put(e.getLong("id"), tempnums);
            });
        } else {
            HashSet<String> tempnums = new HashSet<String>(2);
            tempnums.add(org.getString("number"));
            orgIdNumberMap.put(org.getLong("id"), tempnums);
        }
        return orgIdNumberMap;
    }

    private Map<String, String> getParam(boolean isDC) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("modelId", ((DynamicObject)this.getModel().getValue(model)).getString("id"));
        paramMap.put("modelNum", ((DynamicObject)this.getModel().getValue(model)).getString("number"));
        paramMap.put("scenarioId", ((DynamicObject)this.getModel().getValue(scenario, 0)).getString("id"));
        paramMap.put("scenarioNum", ((DynamicObject)this.getModel().getValue(scenario, 0)).getString("number"));
        paramMap.put("yearId", ((DynamicObject)this.getModel().getValue(year, 0)).getString("id"));
        paramMap.put("yearNum", ((DynamicObject)this.getModel().getValue(year, 0)).getString("number"));
        paramMap.put("periodId", ((DynamicObject)this.getModel().getValue(period, 0)).getString("id"));
        paramMap.put("periodNum", ((DynamicObject)this.getModel().getValue(period, 0)).getString("number"));
        paramMap.put("lastyearId", ((DynamicObject)this.getModel().getValue(lastyear, 0)).getString("id"));
        paramMap.put("lastyearNum", ((DynamicObject)this.getModel().getValue(lastyear, 0)).getString("number"));
        paramMap.put("lastperiodId", ((DynamicObject)this.getModel().getValue(lastperiod, 0)).getString("id"));
        paramMap.put("lastperiodNum", ((DynamicObject)this.getModel().getValue(lastperiod, 0)).getString("number"));
        paramMap.put("lastScenarioId", ((DynamicObject)this.getModel().getValue(lastscenario, 0)).getString("id"));
        paramMap.put("lastScenarioNum", ((DynamicObject)this.getModel().getValue(lastscenario, 0)).getString("number"));
        if (!isDC) {
            paramMap.put("currencyId", ((DynamicObject)this.getModel().getValue(currency)).getString("id"));
            paramMap.put("currencyNum", ((DynamicObject)this.getModel().getValue(currency)).getString("number"));
        }
        return paramMap;
    }

    private void validatorCondition() {
        if (this.getModel().getValue(lastperiod, 0) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4e0a\u5e74\u671f\u95f4\u3002", (String)"BeginYearCarryConfirmPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void initEntry() {
        String lastP;
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        Long currencyid = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_currencymembertree");
        this.getModel().setValue(model, (Object)modelid);
        this.getModel().setValue(currency, (Object)currencyid);
        Long sceneid = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_scenemembertree");
        Long yearid = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_fymembertree");
        Long periodid = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_periodmembertree");
        Long lastyearid = (Long)this.getView().getFormShowParameter().getCustomParam("lastyearid");
        DynamicObject scenarioEntity = BusinessDataServiceHelper.loadSingle((Object)sceneid, (String)"bcm_scenemembertree");
        DynamicObject lastYearEntity = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)lastyearid).toArray());
        this.getModel().setValue(scenario, (Object)sceneid, 0);
        this.getModel().setValue(year, (Object)yearid, 0);
        this.getModel().setValue(period, (Object)periodid, 0);
        this.getModel().setValue(lastyear, (Object)lastyearid, 0);
        QFBuilder builder = new QFBuilder();
        builder.add(model, "=", (Object)modelid);
        builder.add(scenario, "=", (Object)sceneid);
        builder.add(year, "=", (Object)yearid);
        builder.add("entryentity.curperiod", "=", (Object)periodid);
        builder.add("entryentity.lastyear", "=", (Object)lastyearid);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_carrymap", (String)"entryentity.lastscenario, entryentity.lastperiod", (QFilter[])builder.toArray());
        Optional lastPeriod = PeriodUtils.getLastPeriod((String)modelNum, (String)MemberReader.findFyMemberById((String)modelNum, (Long)yearid).getNumber(), (String)(scenarioEntity.getString("number").contains("QRpt") ? "Q_Q1" : "M_M01"), (boolean)true);
        DynamicObject defaultLastPeriod = null;
        if (!lastPeriod.isPresent()) {
            Optional optional = PeriodUtils.getLastPeriod((String)modelNum, (String)MemberReader.findFyMemberById((String)modelNum, (Long)yearid).getNumber(), (String)(scenarioEntity.getString("number").contains("QRpt") ? "Q_Q1" : "M_M01"), (boolean)false);
            lastP = optional.orElse(null);
        } else {
            lastP = (String)lastPeriod.get();
        }
        HashSet ids = new HashSet();
        HashMap periodMap = new HashMap(16);
        DynamicObjectCollection scenePeriod = scenarioEntity.getDynamicObjectCollection("sceneperiod");
        scenePeriod.forEach(p -> {
            periodMap.put(p.getDynamicObject("fbasedataid").getString("number"), p.getDynamicObject("fbasedataid"));
            ids.add(p.getDynamicObject("fbasedataid").getLong("id"));
        });
        List<DynamicObject> orderPeriods = DimensionUtil.getOrderedMembers(this.getModelId(), "bcm_periodmembertree", new HashSet<Long>(ids));
        String lastYearNum = lastYearEntity.getString("number");
        orderPeriods.removeIf(m -> m.getBoolean("isadjust") && !m.getString("useyear").contains(lastYearNum));
        for (DynamicObject orderPeriod : orderPeriods) {
            if (!orderPeriod.getString("number").equals(lastP)) continue;
            defaultLastPeriod = orderPeriod;
        }
        if (defaultLastPeriod == null && !orderPeriods.isEmpty()) {
            defaultLastPeriod = (DynamicObject)periodMap.get(orderPeriods.get(orderPeriods.size() - 1).getString("number"));
        }
        if (dyn != null && dyn.get("entryentity.lastscenario") != null && dyn.get("entryentity.lastperiod") != null) {
            this.getModel().setValue(lastscenario, dyn.get("entryentity.lastscenario"), 0);
            this.getModel().setValue(lastperiod, dyn.get("entryentity.lastperiod"), 0);
        } else {
            this.getModel().setValue(lastscenario, this.getModel().getValue(scenario), 0);
            this.getModel().setValue(lastperiod, (Object)defaultLastPeriod, 0);
        }
        if (this.getView().getFormShowParameter().getCustomParam(ACCOUNT) != null) {
            this.getPageCache().put(ACCOUNT, this.getView().getFormShowParameter().getCustomParam(ACCOUNT).toString());
            this.getModel().setValue(ACCOUNT, (Object)this.getView().getFormShowParameter().getCustomParam("accountStr").toString(), 0);
        }
    }
}

