/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.carry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class BeginYearCarryListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener,
RowClickEventListener {
    private static final String ctl_treeviewap = "treeviewap";
    private static final String entryentity = "entryentity";
    private static final String ctl_model = "model";
    private static final String ctl_scene = "scenario";
    private static final String ctl_year = "year";
    private static final String ctl_period = "period";
    private static final String ctl_alllevel = "alllevel";
    private static final String ctl_directlevel = "directlevel";
    private static final String cache_showorgtype = "showorgtype";
    private static final String selectorgs = "selectorgs";
    private static final String cache_treeorg = "cache_treeentity";
    private static final List<String> f7KEYS = Arrays.asList("model", "scenario", "year", "period");
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");
    private static final String f7CACHEKEY = "f7Cache";
    protected static final String ROWLLIST = "llist";
    protected static final String LFOCUS = "lfocus";
    private static final String CARRYYEAR_CALLBACK = "carry_callback";
    private static final String HAVE_ONLY_READ_ORG = "hasOnlyReadOrg";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        BasedataEdit cslschemeF7 = (BasedataEdit)this.getControl("cslscheme");
        cslschemeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView treeView = (TreeView)this.getControl(ctl_treeviewap);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners("searchbefore", "searchnext");
        Search sl = (Search)this.getControl("searchap");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    BeginYearCarryListPlugin.this.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), true);
                } else {
                    BeginYearCarryListPlugin.this.getPageCache().put(BeginYearCarryListPlugin.ROWLLIST, null);
                    BeginYearCarryListPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryentity);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid billList = (EntryGrid)this.getView().getControl(entryentity);
        billList.addPackageDataListener(this::packageData);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        if ("cslscheme".equals(((BasedataEdit)evt.getSource()).getKey())) {
            QFilter filter;
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilterList = showParameter.getListFilterParameter().getQFilters();
            if (qFilterList == null) {
                qFilterList = Lists.newArrayListWithExpectedSize((int)10);
                long modelId = this.getModelId();
                qFilterList.add(new QFilter(ctl_model, "=", (Object)modelId));
            }
            if (qFilterList.size() > 1 && (filter = (QFilter)qFilterList.get(1)).getProperty().equals("id")) {
                filter.or(new QFilter("id", "in", (Object)this.getRateCslScheme()));
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private Long getRateCslScheme() {
        QFilter rate = new QFilter("number", "=", (Object)"DefaultRateScheme");
        QFilter model = new QFilter(ctl_model, "=", (Object)this.getModelId());
        DynamicObject rateCslScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])new QFilter[]{rate, model});
        if (rateCslScheme != null) {
            return rateCslScheme.getLong("id");
        }
        return 0L;
    }

    public void packageData(PackageDataEvent e) {
        String key;
        super.packageData(e);
        if (BasedataEdit.class.isAssignableFrom(e.getSource().getClass()) && "orgname".equals(key = ((BasedataEdit)e.getSource()).getKey())) {
            Map treeCacheMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("treeCacheMap"));
            String org = e.getRowData().getString("orgnumber");
            if (!StringUtils.isEmpty((CharSequence)org)) {
                e.setFormatValue(treeCacheMap.get(org));
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(dimKeys, false);
        HashMap<String, String> f7KeyMap = new HashMap<String, String>();
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (!StringUtils.isEmpty((CharSequence)modelId)) {
            this.initCslschemeValue(modelId, false);
            this.refreshTree(modelId);
            this.checkGradeOrgScheme();
            String orgNodeId = this.getPageCache().get("focusnodeid");
            if (!StringUtil.isEmptyString((String)orgNodeId)) {
                if (!this.checkOrgMemberIsReadAndWrite(orgNodeId)) {
                    this.setBtnVisible(false);
                } else {
                    this.setBtnVisible(true);
                }
            }
            if (!this.isExistAuditTrailDimension() || !this.isExistChangeTypeDimension()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_carry"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_carry"});
            }
        }
        for (String key : f7KEYS) {
            String f7id = UserSelectUtil.getF7SelectId(this.getView(), key);
            if (StringUtils.isEmpty((CharSequence)f7id)) continue;
            f7KeyMap.put(key, f7id);
        }
        this.getPageCache().put(f7CACHEKEY, SerializationUtils.toJsonString(f7KeyMap));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String selectId = evt.getNodeId().toString();
        if (this.checkOrgMemberIsNoPerm(selectId)) {
            this.setBtnVisible(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u6210\u5458\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BeginYearCarryListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<String> selectnodes = new ArrayList<String>();
        if (this.getPageCache().get(selectorgs) != null) {
            selectnodes = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectorgs));
        }
        selectnodes.add(selectId);
        this.getPageCache().put(selectorgs, ObjectSerialUtil.toByteSerialized(selectnodes));
        this.getPageCache().put("focusnodeid", selectId);
        this.refreshEntryEntity();
        if (this.checkOrgMemberIsOnlyRead(selectId)) {
            this.setBtnVisible(false);
        } else {
            this.setBtnVisible(true);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObjectCollection dynCol = this.getModel().getEntryEntity(entryentity);
        if (dynCol == null || dynCol.isEmpty()) {
            return;
        }
        int row = evt.getRow();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryentity);
        int[] nowSelectRows = entryGrid.getSelectRows();
        ArrayList<Integer> selectRowList = new ArrayList<Integer>(nowSelectRows.length);
        for (int selectRow : nowSelectRows) {
            selectRowList.add(selectRow);
        }
        if (row >= 0 && nowSelectRows.length != dynCol.size()) {
            String orgId = ((DynamicObject)dynCol.get(row)).getString("orgid");
            if (this.checkOrgMemberIsOnlyRead(orgId)) {
                this.setBtnVisible(false);
                ArrayList<Integer> newSelectRowList = new ArrayList<Integer>(selectRowList);
                newSelectRowList.removeIf(rowIndex -> rowIndex == row);
                if (!newSelectRowList.isEmpty()) {
                    int[] selectRowArray = new int[newSelectRowList.size()];
                    for (int i = 0; i < selectRowArray.length; ++i) {
                        selectRowArray[i] = (Integer)newSelectRowList.get(i);
                    }
                    entryGrid.selectRows(selectRowArray, selectRowArray[0]);
                } else {
                    entryGrid.selectRows(-1);
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458\u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BeginYearCarryListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.setBtnVisible(true);
            }
        }
        if (nowSelectRows.length == dynCol.size() && this.getPageCache().get(HAVE_ONLY_READ_ORG) != null) {
            int[] selectRowArray = new int[]{};
            entryGrid.selectRows(selectRowArray, -1);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u90e8\u5206\u6210\u5458\u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u65e0\u6cd5\u5168\u9009\u3002", (String)"BeginYearCarryListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setBtnVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btn_carry"});
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_carry": {
                this.showCarryMap();
                break;
            }
            case "btn_refresh": {
                this.refreshTree(String.valueOf(this.getModelId()));
                break;
            }
            case "btn_param": 
            case "btn_specialsetting": {
                this.showParamForm(key);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] data;
        DynamicObject newValue;
        Boolean isSureReturn;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Map f7KeyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(f7CACHEKEY), Map.class);
        if (dimKeys.contains(key) && !(isSureReturn = this.propertyChangedDimUse(key, newValue = (DynamicObject)(data = e.getChangeSet())[0].getNewValue(), false, true)).booleanValue()) {
            return;
        }
        switch (key) {
            case "model": {
                this.propertyChangedModelUse(dimKeys);
                f7KeyMap.clear();
                this.getPageCache().put(selectorgs, null);
                String modelid = this.getPageCache().get("KEY_MODEL_ID");
                this.initCslschemeValue(modelid, false);
                this.refreshTree(modelid);
                this.refreshEntryEntity();
                break;
            }
            case "period": 
            case "year": 
            case "scenario": {
                this.refreshTree(this.getPageCache().get("KEY_MODEL_ID"));
                this.refreshEntryEntity();
                break;
            }
            case "alllevel": {
                if (((Boolean)this.getModel().getValue(ctl_alllevel)).booleanValue()) {
                    this.getModel().setValue(ctl_directlevel, (Object)false);
                }
                this.refreshEntryEntity();
                break;
            }
            case "directlevel": {
                if (((Boolean)this.getModel().getValue(ctl_directlevel)).booleanValue()) {
                    this.getModel().setValue(ctl_alllevel, (Object)false);
                }
                this.refreshEntryEntity();
                break;
            }
            case "showorgtype": {
                this.refreshTree(this.getPageCache().get("KEY_MODEL_ID"));
                break;
            }
            case "cslscheme": {
                this.saveUserChangedCslscheme((DynamicObject)e.getChangeSet()[0].getNewValue());
                this.refreshTree(this.getPageCache().get("KEY_MODEL_ID"));
                this.refreshEntryEntity();
                break;
            }
        }
        if (!this.isExistAuditTrailDimension() || !this.isExistChangeTypeDimension()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_carry"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_carry"});
        }
    }

    private void searchMember(String text, boolean isentity) {
        TreeView treeView = (TreeView)this.getControl(ctl_treeviewap);
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)cache_treeorg);
        if (treeModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"BeginYearCarryListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ITreeNode root = treeModel.getRoot();
        List lists = treeModel.seekAllChildrenIf(root.getId(), p -> p.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH)));
        ArrayList<String> list = new ArrayList<String>(lists.size());
        for (AbstractTreeNode node : lists) {
            list.add(node.getId());
        }
        if (!list.isEmpty()) {
            this.getPageCache().put(ROWLLIST, SerializationUtils.toJsonString(list));
            this.getPageCache().put(LFOCUS, "0");
            String focusnode = (String)list.get(0);
            ITreeNode parent = ((AbstractTreeNode)treeModel.searchByNodeId(focusnode)).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent() != null) {
                    parentId = ((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent().getId();
                    continue;
                }
                break;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"BeginYearCarryListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            ITreeNode parent;
            int rowCount = 0;
            TreeView treeView = (TreeView)this.getControl(ctl_treeviewap);
            TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)cache_treeorg);
            String rowcache = this.getPageCache().get(ROWLLIST);
            String count = this.getPageCache().get(LFOCUS);
            if (count != null) {
                rowCount = Integer.parseInt(count);
            }
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"BeginYearCarryListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
            if ("searchbefore".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"BeginYearCarryListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else if ("searchnext".equals(key)) {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"BeginYearCarryListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            String focusnode = String.valueOf(rowList.get(rowCount));
            if ("searchbefore".equals(key) || "searchnext".equals(key)) {
                this.getPageCache().put(LFOCUS, String.valueOf(rowCount));
            }
            String parentId = (parent = treeModel.searchByNodeId(focusnode).getParent()) == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (treeModel.searchByNodeId(temp).getParent() == null) break;
                parentId = treeModel.searchByNodeId(temp).getParent().getId();
            }
        }
    }

    public void refreshTree(String modelId) {
        this.initTree();
    }

    private void initTree() {
        String showType;
        List orgNodes;
        HashMap<String, List<Long>> need2RemoveNodes;
        long modelId = this.getModelId();
        OrgTreeNode rootTreeNode = this.createRootOrgTreeNode(modelId, need2RemoveNodes = new HashMap<String, List<Long>>(), orgNodes = this.getOrgNodes(modelId, null, need2RemoveNodes, this.isRPT()), showType = this.getModel().getValue(cache_showorgtype) == null ? "4" : this.getModel().getValue(cache_showorgtype).toString(), this.isRPT(), false);
        if (rootTreeNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u8be5\u7ec4\u7ec7\u89c6\u56fe\u4e0b,\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6210\u5458\u6743\u9650\u3002", (String)"BeginYearCarryListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.clearTree();
            return;
        }
        if (ThreadCache.exists((Object)"orgrealnames")) {
            this.getPageCache().put("treeCacheMap", ObjectSerialUtil.toByteSerialized((Object)ThreadCache.get((Object)"orgrealnames")));
        }
        rootTreeNode.SetIsOpened(true);
        TreeView tree = (TreeView)this.getControl(ctl_treeviewap);
        TreeModel treemodel = new TreeModel((ITreeNode)rootTreeNode);
        treemodel.buildEntryTree(tree);
        TreeNode findCacheNode = this.findCacheNode((AbstractTreeNode<Object>)rootTreeNode);
        tree.focusNode(findCacheNode);
        this.getPageCache().put("focusnodeid", findCacheNode.getId());
        treemodel.ache2page(this.getPageCache(), cache_treeorg);
        this.refreshEntryEntity();
        this.expandAllSelected((TreeModel<AbstractTreeNode<Object>>)treemodel, tree);
        tree.setRootVisible(this.isRPT());
    }

    private TreeView clearTree() {
        TreeView tree = (TreeView)this.getControl(ctl_treeviewap);
        if (tree != null) {
            tree.deleteAllNodes();
        }
        return tree;
    }

    private TreeNode findCacheNode(AbstractTreeNode<Object> root) {
        String selectnode = this.getPageCache().get("focusnodeid");
        if (StringUtil.isEmptyString((String)selectnode)) {
            selectnode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), false, false);
        }
        if (this.getPageCache().get(selectorgs) != null) {
            List selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectorgs));
            selectnode = (String)selects.get(selects.size() - 1);
        }
        if (selectnode == null || selectnode.equals(root.getId())) {
            return new TreeNode("0", root.getId(), root.getName());
        }
        LinkedList<AbstractTreeNode<Object>> queue = new LinkedList<AbstractTreeNode<Object>>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ITreeNode node = (ITreeNode)queue.poll();
            if (node.getId().equals(selectnode)) {
                return new TreeNode(node.getParent().getId(), node.getId(), "");
            }
            List children = node.getChildren();
            if (children.isEmpty()) continue;
            queue.addAll(children);
        }
        return new TreeNode("0", root.getId(), root.getName());
    }

    private void expandAllSelected(TreeModel<AbstractTreeNode<Object>> treemodel, TreeView treeView) {
        String focusid;
        List<String> selects = new ArrayList();
        if (this.getPageCache().get(selectorgs) != null) {
            selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectorgs));
        }
        if (!StringUtil.isEmptyString((String)(focusid = this.getPageCache().get("focusnodeid")))) {
            selects.add(focusid);
        }
        OrgTreeNode root = (OrgTreeNode)treemodel.getRoot();
        for (String nodeid : selects) {
            OrgTreeNode node = (OrgTreeNode)treemodel.searchByNodeId(nodeid);
            if (node == null || node.getId() == null) continue;
            if (node.getId().equals(root.getId())) {
                List children = node.getChildren();
                if (children.isEmpty()) continue;
                for (ITreeNode child : children) {
                    treeView.expand(child.getId());
                }
                continue;
            }
            String parentid = node.getParent().getId();
            while (!parentid.equals(root.getId())) {
                treeView.expand(parentid);
                node = (OrgTreeNode)node.getParent();
                parentid = node.getParent().getId();
            }
        }
    }

    private void refreshEntryEntity() {
        if (this.getModel().getValue(ctl_model) == null || this.getModel().getValue(ctl_scene) == null || this.getModel().getValue(ctl_year) == null || this.getModel().getValue(ctl_period) == null) {
            this.getPageCache().put("focusnodeid", null);
            this.getModel().deleteEntryData(entryentity);
            return;
        }
        if (!this.getOrgNumbers().isEmpty()) {
            DynamicObject[] carryRows = this.buildCarryRows();
            this.getModel().beginInit();
            this.getModel().deleteEntryData(entryentity);
            this.getModel().batchCreateNewEntryRow(entryentity, carryRows.length);
            String defaultScene = ((DynamicObject)this.getModel().getValue(ctl_scene)).getString("name");
            String yearNumber = ((DynamicObject)this.getModel().getValue(ctl_year)).getString("number");
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            Optional lastYear = PeriodUtils.getLastYear((String)modelNum, (String)yearNumber);
            Optional endPeriod = PeriodUtils.getLastPeriod((String)modelNum, (String)yearNumber, (String)"M_M01", (boolean)true);
            for (int i = 0; i < carryRows.length; ++i) {
                DynamicObject dyObj = carryRows[i];
                IDNumberTreeNode org = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)(dyObj.getLong("org.id") == 0L ? dyObj.getLong("org") : dyObj.getLong("org.id")));
                if (org != IDNumberTreeNode.NotFoundTreeNode) {
                    this.getModel().setValue("orgnumber", (Object)org.getNumber(), i);
                    this.getModel().setValue("orgname", (Object)org.getName(), i);
                    this.getModel().setValue("orgid", (Object)org.getId(), i);
                }
                this.getModel().setValue("carrystatus", dyObj.get("carrystatus"), i);
                this.getModel().setValue("modifier", dyObj.get("modifier"), i);
                this.getModel().setValue("modifydate", dyObj.get("modifydate"), i);
                if ("0".equals(dyObj.getString("carrystatus")) || !lastYear.isPresent()) continue;
                String defaultPeriod = null;
                if (endPeriod.isPresent()) {
                    defaultPeriod = MemberReader.findPeriodMemberByNum((String)modelNum, (String)((String)endPeriod.get())).getName();
                }
                this.setAccountStr(defaultScene, MemberReader.findFyMemberByNum((String)modelNum, (String)((String)lastYear.get())).getName(), defaultPeriod, dyObj, i);
            }
            this.getModel().endInit();
            this.getView().updateView(entryentity);
        } else {
            this.getModel().deleteEntryData(entryentity);
        }
    }

    private void setAccountStr(String defaultScene, String year, String defaultPeriod, DynamicObject dyObj, int i) {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection dyns = dyObj.getDynamicObjectCollection(entryentity);
        if (StringUtils.isNotEmpty((CharSequence)dyObj.getString("lastscene.name"))) {
            defaultScene = dyObj.getString("lastscene.name");
        }
        if (StringUtils.isNotEmpty((CharSequence)dyObj.getString("lastperiod.name"))) {
            defaultPeriod = dyObj.getString("lastperiod.name");
        }
        sb.append(ResManager.loadKDString((String)"\u9ed8\u8ba4\uff1a", (String)"BeginYearCarryListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(defaultScene).append("_").append(year).append("_").append(defaultPeriod).append(";");
        if (!dyns.isEmpty()) {
            sb.append(ResManager.loadKDString((String)"\u7279\u6b8a\uff1a", (String)"BeginYearCarryListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            for (DynamicObject dyn : dyns) {
                IDNumberTreeNode member = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_accountmembertree", (Long)dyn.getLong("account.id"));
                String accountName = member.getName();
                if (member == IDNumberTreeNode.NotFoundTreeNode) {
                    accountName = ResManager.loadKDString((String)"\u65e0", (String)"BeginYearCarryListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                RangeEnum.buildScopeShowName((StringBuilder)sb, (String)accountName, (int)(dyn.getInt("scope") == 0 ? 10 : dyn.getInt("scope")));
                sb = new StringBuilder(sb.substring(0, sb.length() - 1));
                if (dyn.getDynamicObject("sourceperiod") != null) {
                    defaultPeriod = dyn.getDynamicObject("sourceperiod").getString("name");
                }
                sb.append("_").append(defaultPeriod).append(",");
            }
            sb = new StringBuilder(sb.substring(0, sb.length() - 1));
        }
        this.getModel().setValue("account", (Object)sb.toString(), i);
    }

    private DynamicObject[] getCarriedData() {
        DynamicObject[] carried = BusinessDataServiceHelper.load((String)"bcm_carryentity", (String)this.getSelector(), (QFilter[])this.getCarryFilter().toArray(), (String)"modifydate desc");
        return carried;
    }

    private DynamicObject[] buildCarryRows() {
        DynamicObject[] carried = this.getCarriedData();
        HashMap<String, Integer> orgindexMap = new HashMap<String, Integer>(carried.length);
        HashMap otherMap = new HashMap(16);
        for (int y = 0; y < carried.length; ++y) {
            String orgId = ((DynamicObject)carried[y].get("org")).getString("id");
            if (StringUtils.isNotEmpty((CharSequence)orgId) && orgindexMap.get(orgId) != null) continue;
            orgindexMap.put(orgId, y);
        }
        long modelId = this.getModelId();
        for (Map.Entry entry : orgindexMap.entrySet()) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)Long.parseLong((String)entry.getKey()));
            if (entity == IDNumberTreeNode.NotFoundTreeNode) continue;
            if (entity.isShare()) {
                entity = MemberReader.findEntityMemberById((Long)modelId, (Long)entity.getCopyfromId());
                if (entity == IDNumberTreeNode.NotFoundTreeNode) continue;
                otherMap.put(String.valueOf(entity.getId()), entry.getValue());
            }
            List shareNodes = entity.getShareNodes();
            for (IDNumberTreeNode shareNode : shareNodes) {
                otherMap.put(String.valueOf(shareNode.getId()), entry.getValue());
            }
        }
        if (!otherMap.isEmpty()) {
            orgindexMap.putAll(otherMap);
        }
        List<String> allOrgids = this.getOrgNumbers();
        Map<String, String> map = this.getCondition();
        DynamicObject[] dyns = new DynamicObject[allOrgids.size()];
        int i = 0;
        for (String orgid : allOrgids) {
            Integer temp = (Integer)orgindexMap.get(orgid);
            if (temp != null) {
                dyns[i] = carried[temp];
            } else {
                DynamicObject carryObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_carryentity");
                carryObj.set(ctl_model, (Object)map.get(ctl_model));
                carryObj.set("scene", (Object)map.get("scene"));
                carryObj.set(ctl_year, (Object)map.get(ctl_year));
                carryObj.set(ctl_period, (Object)map.get(ctl_period));
                carryObj.set("org", (Object)orgid);
                carryObj.set("carrystatus", (Object)"0");
                dyns[i] = carryObj;
            }
            ++i;
        }
        return dyns;
    }

    private QFBuilder getCarryFilter() {
        Map<String, String> map = this.getCondition();
        QFBuilder qfb = new QFBuilder();
        qfb.add(ctl_model, "=", (Object)LongUtil.toLong((Object)map.get(ctl_model)));
        qfb.add("scene", "=", (Object)LongUtil.toLong((Object)map.get("scene")));
        qfb.add(ctl_year, "=", (Object)LongUtil.toLong((Object)map.get(ctl_year)));
        qfb.add(ctl_period, "=", (Object)LongUtil.toLong((Object)map.get(ctl_period)));
        qfb.add("org.number", "in", this.getOrgNumByIds(this.getOrgNumbers()));
        return qfb;
    }

    private List<String> getOrgNumbers() {
        String focusNodeId = this.getPageCache().get("focusnodeid");
        if (StringUtils.isEmpty((CharSequence)focusNodeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5e74\u7ed3\u7684\u7ec4\u7ec7\u884c\u3002", (String)"BeginYearCarryListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject focusOrg = (DynamicObject)ThreadCache.get((Object)focusNodeId, () -> QueryDimensionServiceHelper.getMemMsgById((String)focusNodeId, (String)"bcm_entitymembertree"));
        if (focusOrg == null || DimTypesEnum.ENTITY.getNumber().equals(focusOrg.getString("number"))) {
            return new ArrayList<String>();
        }
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)cache_treeorg);
        if (treeModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"BeginYearCarryListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return new ArrayList<String>();
        }
        List<Object> treeNodes = null;
        treeNodes = (Boolean)this.getModel().getValue(ctl_alllevel) != false ? treeModel.seekChildrenByGivenNode(focusNodeId, true) : ((Boolean)this.getModel().getValue(ctl_directlevel) != false ? treeModel.seekChildrenIf(focusNodeId, true, node -> true) : Collections.singletonList(treeModel.searchByNodeId(focusOrg.getString("id"))));
        if (treeNodes == null || treeNodes.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> orgIds = new ArrayList<String>(treeNodes.size());
        if (this.isModelManager(this.getModelId())) {
            for (AbstractTreeNode abstractTreeNode : treeNodes) {
                String orgId = abstractTreeNode.getId();
                if (orgId == null || orgId.isEmpty()) continue;
                orgIds.add(orgId);
            }
            return orgIds;
        }
        boolean hasOnlyReadOrg = false;
        PermPackageList permPackageList = this.getPermMapFromCache();
        for (AbstractTreeNode abstractTreeNode : treeNodes) {
            String orgId = abstractTreeNode.getId();
            if (orgId == null || orgId.isEmpty()) continue;
            PermEnum permNum = permPackageList.getPermEnum(LongUtil.toLong((Object)orgId).longValue());
            if (PermEnum.READONLY == permNum) {
                hasOnlyReadOrg = true;
            }
            if (permNum == PermEnum.NOPERM) continue;
            orgIds.add(orgId);
        }
        if (hasOnlyReadOrg) {
            this.getPageCache().put(HAVE_ONLY_READ_ORG, "1");
        } else {
            this.getPageCache().remove(HAVE_ONLY_READ_ORG);
        }
        return orgIds;
    }

    private List<String> getOrgNumByIds(List<String> ids) {
        return ids.stream().map(id -> MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)Long.parseLong(id)).getNumber()).collect(Collectors.toList());
    }

    private String getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add(ctl_model);
        selector.add("scene");
        selector.add("lastscene");
        selector.add(ctl_year);
        selector.add(ctl_period);
        selector.add("lastperiod");
        selector.add("org.id");
        selector.add("carrystatus");
        selector.add("modifier");
        selector.add("modifydate");
        selector.add("entryentity.account");
        selector.add("entryentity.scope");
        selector.add("entryentity.sourceperiod");
        return String.join((CharSequence)",", selector);
    }

    private Map<String, String> getCondition() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ctl_model, ((DynamicObject)this.getModel().getValue(ctl_model)).getString("id"));
        map.put("scene", ((DynamicObject)this.getModel().getValue(ctl_scene)).getString("id"));
        map.put(ctl_year, ((DynamicObject)this.getModel().getValue(ctl_year)).getString("id"));
        map.put(ctl_period, ((DynamicObject)this.getModel().getValue(ctl_period)).getString("id"));
        return map;
    }

    public QFilter[] getPeriodQFilter(Long model, List<String> orgNumbers, Long scenario, Long year, String statusField) {
        QFilter qfModel = new QFilter(ctl_model, "=", (Object)model);
        QFilter qfOrg = new QFilter("orgnumber", "in", orgNumbers);
        QFilter qfScenario = new QFilter(ctl_scene, "=", (Object)scenario);
        QFilter qfYear = new QFilter(ctl_year, "=", (Object)year);
        QFilter qfStatus = new QFilter(statusField, "=", (Object)"A");
        return new QFilter[]{qfModel, qfOrg, qfScenario, qfYear, qfStatus};
    }

    private void showCarryMap() {
        QFilter numberqf;
        QFilter modelqfilter;
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryentity);
        if (this.getModel().getValue(ctl_scene) == null || this.getModel().getValue(ctl_year) == null || this.getModel().getValue(ctl_period) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3001\u8d22\u5e74\u548c\u671f\u95f4\u3002", (String)"BeginYearCarryPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Long year = ((DynamicObject)this.getModel().getValue(ctl_year)).getLong("id");
        Long model = ((DynamicObject)this.getModel().getValue(ctl_model)).getLong("id");
        Long scenario = ((DynamicObject)this.getModel().getValue(ctl_scene)).getLong("id");
        Long period = ((DynamicObject)this.getModel().getValue(ctl_period)).getLong("id");
        DynamicObject yearobj = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"dseq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)year)});
        if (yearobj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u8d22\u5e74\u4e0d\u5b58\u5728\u3002", (String)"BeginYearCarryPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        QFilter seqqfilter = new QFilter("dseq", "<", yearobj.get("dseq"));
        DynamicObjectCollection lastyearobj = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id", (QFilter[])new QFilter[]{seqqfilter, modelqfilter = new QFilter(ctl_model, "=", (Object)this.getModelId()), numberqf = new QFilter("number", "like", (Object)"FY%")}, (String)"dseq desc", (int)1);
        if (lastyearobj == null || lastyearobj.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u540e\u91cd\u8bd5\u3002", (String)"BeginYearCarryPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] rows = grid.getSelectRows();
        if (rows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5e74\u7ed3\u7684\u7ec4\u7ec7\u884c\u3002", (String)"BeginYearCarryListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity(entryentity);
        ArrayList<String> orgids = new ArrayList<String>(rows.length);
        List<Object> orgNumbers = new ArrayList(rows.length);
        boolean isQuoteScene = MergeControlHelper.isQuoteScene((Long)model, (Long)scenario);
        Set allVersionedOrgs = MergeControlHelper.getAllVersionedOrgs((Long)model, (Long)scenario, (Long)year, (Long)period);
        FormShowParameter formShowParameter = new FormShowParameter();
        HashMap<String, String> orgIdMap = new HashMap<String, String>(16);
        HashMap<String, String> orgNumberMap = new HashMap<String, String>(16);
        for (int row : rows) {
            String orgId = ((DynamicObject)dyncol.get(row)).getString("orgid");
            String orgNumber = ((DynamicObject)dyncol.get(row)).getString("orgnumber");
            if (isQuoteScene && !allVersionedOrgs.contains(orgNumber)) continue;
            String orgName = ((DynamicObject)dyncol.get(row)).getString("orgname");
            orgids.add(orgId);
            orgNumbers.add(orgNumber);
            orgIdMap.put(orgId, orgName);
            orgNumberMap.put(orgNumber, orgName);
        }
        if (orgNumbers.isEmpty()) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioVersionError"), new Object[0]);
        }
        orgNumbers = orgNumbers.stream().distinct().collect(Collectors.toList());
        boolean isEnable = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
        QFilter sceneFilter = new QFilter("id", "=", (Object)scenario);
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])new QFilter[]{sceneFilter});
        DynamicObjectCollection scenePeriods = dot.getDynamicObjectCollection("sceneperiod");
        Set<Long> tempIds = scenePeriods.stream().map(per -> per.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        List orderPeriods = DimensionUtil.getOrderedMembers(this.getModelId(), "bcm_periodmembertree", tempIds).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        int index = orderPeriods.indexOf(period);
        if (index < 0) {
            return;
        }
        orderPeriods = orderPeriods.subList(index, orderPeriods.size());
        if (isEnable) {
            Map result = PeriodSettingHelper.batchCheckPeriodStatus((long)model, new HashSet<Object>(orgNumbers), Collections.singleton(scenario), Collections.singleton(year), new HashSet(orderPeriods), (String)"datastatus");
            HashMap orgPeriodNums = new HashMap(16);
            for (String string : orgNumbers) {
                for (Long order : orderPeriods) {
                    String key = String.format("%s_%s_%s_%s", string, scenario, year, order);
                    if (result.get(key) == null || !((Boolean)result.get(key)).booleanValue()) continue;
                    orgPeriodNums.putIfAbsent(string, new LinkedList());
                    ((List)orgPeriodNums.get(string)).add(order);
                }
            }
            if (orgPeriodNums.size() != orgNumbers.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u671f\u95f4\u672a\u5f00\u542f\uff0c\u8bf7\u5230\u671f\u95f4\u7ba1\u7406\u9875\u9762\u5f00\u542f\u671f\u95f4\u3002", (String)"BeginYearCarryListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            List includes = (List)orgPeriodNums.get(orgNumbers.get(0));
            boolean bl = true;
            for (List value : orgPeriodNums.values()) {
                includes.retainAll(value);
            }
            if (includes.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u671f\u95f4\u672a\u5f00\u542f\uff0c\u8bf7\u5230\u671f\u95f4\u7ba1\u7406\u9875\u9762\u5f00\u542f\u671f\u95f4\u3002", (String)"BeginYearCarryListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            orderPeriods = includes;
        }
        formShowParameter.setCustomParam("periods", (Object)SerializationUtils.toJsonString(orderPeriods));
        formShowParameter.setFormId("bcm_carryconfirm_multi");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("bcm_scenemembertree", (Object)scenario);
        formShowParameter.setCustomParam("bcm_fymembertree", (Object)year);
        formShowParameter.setCustomParam("bcm_periodmembertree", (Object)period);
        formShowParameter.setCustomParam("orgids", orgids);
        formShowParameter.setCustomParam("orgIdMap", (Object)SerializationUtils.serializeToBase64(orgIdMap));
        formShowParameter.setCustomParam("orgNumberMap", (Object)SerializationUtils.serializeToBase64(orgNumberMap));
        formShowParameter.setCustomParam("lastyearid", (Object)((DynamicObject)lastyearobj.get(0)).getLong("id"));
        if (orgids.size() == 1) {
            formShowParameter.setCustomParam("account", (Object)this.getPageCache().get("account"));
            formShowParameter.setCustomParam("accountStr", this.getModel().getValue("account", rows[0]));
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "carry_confirm"));
        this.getView().showForm(formShowParameter);
    }

    private void showParamForm(String itemKey) {
        if (this.getModel().getValue(ctl_scene) == null || this.getModel().getValue(ctl_year) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u548c\u8d22\u5e74\u3002", (String)"BeginYearCarryPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Long model = ((DynamicObject)this.getModel().getValue(ctl_model)).getLong("id");
        Long scenario = ((DynamicObject)this.getModel().getValue(ctl_scene)).getLong("id");
        Long year = ((DynamicObject)this.getModel().getValue(ctl_year)).getLong("id");
        DynamicObject yearObj = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"dseq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)year)});
        QFBuilder builder = new QFBuilder(ctl_model, "=", (Object)this.getModelId());
        builder.and("dseq", "<", yearObj.get("dseq")).and("number", "like", (Object)"FY%");
        DynamicObjectCollection lastyearobj = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id", (QFilter[])builder.toArray(), (String)"dseq desc", (int)1);
        if (lastyearobj == null || lastyearobj.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u540e\u91cd\u8bd5\u3002", (String)"BeginYearCarryPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = "carrymap" + itemKey + this.getView().getPageId();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            QFilter qfmodel = new QFilter(ctl_model, "=", (Object)model);
            QFilter qfscenario = new QFilter(ctl_scene, "=", (Object)scenario);
            QFilter qfyear = new QFilter(ctl_year, "=", (Object)year);
            DynamicObjectCollection carryobj = QueryServiceHelper.query((String)"bcm_carrymap", (String)"id", (QFilter[])new QFilter[]{qfmodel, qfscenario, qfyear}, (String)"id", (int)1);
            BaseShowParameter basecarrymap = new BaseShowParameter();
            basecarrymap.setFormId("bcm_carrymap");
            if (!CollectionUtil.isEmpty((Collection)carryobj)) {
                basecarrymap.setPkId((Object)((DynamicObject)carryobj.get(0)).getLong("id"));
                basecarrymap.setStatus(OperationStatus.EDIT);
            } else {
                basecarrymap.setStatus(OperationStatus.ADDNEW);
            }
            if ("btn_param".equals(itemKey)) {
                basecarrymap.setCaption(ResManager.loadKDString((String)"\u5e74\u521d\u7ed3\u8f6c-\u516c\u5171\u8bbe\u7f6e", (String)"BeginYearCarryListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                basecarrymap.setCaption(ResManager.loadKDString((String)"\u5e74\u521d\u7ed3\u8f6c-\u7279\u6b8a\u8bbe\u7f6e", (String)"BeginYearCarryListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            basecarrymap.setCustomParam("KEY_MODEL_ID", (Object)model);
            basecarrymap.setCustomParam(ctl_scene, (Object)scenario);
            basecarrymap.setCustomParam(ctl_year, (Object)year);
            basecarrymap.setCustomParam("lastyear", (Object)((DynamicObject)lastyearobj.get(0)).getLong("id"));
            basecarrymap.setCustomParam("itemKey", (Object)itemKey);
            basecarrymap.setPageId(pageId);
            basecarrymap.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            basecarrymap.getOpenStyle().setTargetKey("_submaintab_");
            basecarrymap.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CARRYYEAR_CALLBACK));
            if (parentView == null) {
                this.getView().showForm((FormShowParameter)basecarrymap);
                return;
            }
            basecarrymap.setParentPageId(parentView.getPageId());
            basecarrymap.setParentFormId(parentView.getEntityId());
            parentView.showForm((FormShowParameter)basecarrymap);
            this.getView().sendFormAction(parentView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("carry_confirm".equals(actionId) && evt.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"BeginYearCarryPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.refreshEntryEntity();
        }
    }
}

