/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.carry;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.Close;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.formplugin.AbstractBaseBasicPlugIn;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;

public class BeginYearCarryPlugin
extends AbstractBaseBasicPlugIn {
    private static final String modelkey = "model";
    private static final String scenariokey = "scenario";
    private static final String yearkey = "year";
    private static final String orgkey = "orgid";
    private static final String entryentitykey = "entryentity";
    private static final String CUR_YEAR = "curyear";
    private static final String CUR_PERIOD = "curperiod";
    private static final String LAST_SCENARIO = "lastscenario";
    private static final String DIM_SCENARIO_ID = "dim_scenario_id";
    private static final String LAST_YEAR = "lastyear";
    private static final String LAST_PERIOD = "lastperiod";
    private static final String DIM_PREIOD_ID = "dim_poeriod_id";
    private static final String DIMENSION = "dimension";
    private static final String ACCOUNT_SCOPE = "accountscope";
    private static final String DIMENSION_SCOPE = "dimensionscope";
    private static final String SPECIAL_ENTRY = "specialentry";
    private static final String BEFORE_YEAR = "beforeperiod";
    private static final String SOURCE_YEAR = "sourceperiod";

    private static final String getOperationBeginningOfTheYear() {
        return ResManager.loadKDString((String)"\u5e74\u521d\u7ed3\u8f6c", (String)"BeginYearCarryPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static final String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"BeginYearCarryPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit lastperiodBE = (BasedataEdit)this.getControl(LAST_PERIOD);
        lastperiodBE.setF7BatchFill(false);
        BasedataEdit lastsceneBE = (BasedataEdit)this.getControl(LAST_SCENARIO);
        lastsceneBE.setF7BatchFill(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit lastperiodBE = (BasedataEdit)this.getControl(LAST_PERIOD);
        lastperiodBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit lastscenario = (BasedataEdit)this.getControl(LAST_SCENARIO);
        lastscenario.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit beforeYear = (BasedataEdit)this.getControl(BEFORE_YEAR);
        beforeYear.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sourceYear = (BasedataEdit)this.getControl(SOURCE_YEAR);
        sourceYear.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{DIMENSION});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(DIMENSION)) {
            int row = this.getModel().getEntryCurrentRowIndex(SPECIAL_ENTRY);
            this.getView().getPageCache().put(DIMENSION, null);
            if (row >= 0) {
                Map<Object, Object> mapParams = new HashMap(2);
                if (StringUtils.isNotEmpty((String)this.getModel().getValue(ACCOUNT_SCOPE, row).toString())) {
                    mapParams = this.transOldSetting(this.getModel().getValue(ACCOUNT_SCOPE, row).toString());
                } else if (StringUtils.isNotEmpty((String)this.getModel().getValue(DIMENSION_SCOPE, row).toString())) {
                    mapParams = this.transDimSetting(this.getModel().getValue(DIMENSION_SCOPE, row).toString());
                }
                FormShowParameter para = new FormShowParameter();
                para.setFormId("bcm_carrydimsetting");
                para.setCustomParam(DIMENSION, mapParams);
                para.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_carrydimsetting");
                para.setCloseCallBack(closeCallBack);
                para.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(para);
            }
        }
    }

    private Map<String, List<Map<String, String>>> transDimSetting(String accounts) {
        return (Map)SerializationUtils.fromJsonString((String)accounts, Map.class);
    }

    private Map<String, List<Map<String, String>>> transOldSetting(String accounts) {
        HashMap<String, List<Map<String, String>>> mapParams = new HashMap<String, List<Map<String, String>>>(2);
        List list = (List)SerializationUtils.fromJsonString((String)accounts, List.class);
        mapParams.put(SysDimensionEnum.Account.getSign(), list);
        return mapParams;
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        Object data;
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if (key.equals("bcm_carrydimsetting") && (data = cb.getReturnData()) != null) {
            Map newMap = (Map)this.deSerializedBytes((String)data);
            int row = this.getModel().getEntryCurrentRowIndex(SPECIAL_ENTRY);
            String newVal = SerializationUtils.toJsonString((Object)newMap);
            this.getModel().setValue(DIMENSION, (Object)this.getDimStr(newVal), row);
            this.getModel().setValue(DIMENSION_SCOPE, (Object)newVal, row);
            this.getModel().setValue(ACCOUNT_SCOPE, null, row);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue("id") != null && (Long)this.getModel().getValue("id") != 0L) {
            this.afterCreateNewData(e);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SPECIAL_ENTRY);
        int row = 0;
        for (DynamicObject entry : entryEntity) {
            String accounts = entry.getString(ACCOUNT_SCOPE);
            if (StringUtils.isNotEmpty((String)accounts)) {
                this.getModel().setValue(DIMENSION, (Object)this.getAccountStr(entry.getString(ACCOUNT_SCOPE)), row);
            } else if (StringUtils.isNotEmpty((String)entry.getString(DIMENSION_SCOPE))) {
                this.getModel().setValue(DIMENSION, (Object)this.getDimStr(entry.getString(DIMENSION_SCOPE)), row);
            }
            ++row;
        }
        this.getModel().setDataChanged(false);
    }

    private String getAccountStr(String accounts) {
        StringBuilder sb = new StringBuilder();
        List list = (List)SerializationUtils.fromJsonString((String)accounts, List.class);
        sb.append(DimEntityNumEnum.ACCOUNT.getName()).append(":");
        for (Map doc : list) {
            if (RangeEnum.getRangeByVal((int)Integer.parseInt((String)doc.get("scope"))) == RangeEnum.VALUE_10) {
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)PresetConstant.ACCOUNT_DIM, (String)((String)doc.get("number")));
                if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                sb.append((String)doc.get("number")).append(' ');
                sb.append(node.getName()).append(';').append(' ');
                continue;
            }
            sb.append((String)doc.get("number")).append(' ').append((String)doc.get("name")).append(ResManager.loadKDString((String)"\u7684", (String)"BeginYearCarryPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)Integer.parseInt((String)doc.get("scope"))).getName()).append(';').append(' ');
        }
        return sb.toString().length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    private String getDimStr(String dims) {
        StringBuilder sb = new StringBuilder();
        Map map = (Map)SerializationUtils.fromJsonString((String)dims, Map.class);
        map.forEach((key, val) -> {
            sb.append(DimEntityNumEnum.getNameByNumber((String)key)).append(":");
            if (val != null) {
                for (Map doc : val) {
                    if (RangeEnum.getRangeByVal((int)Integer.parseInt((String)doc.get("scope"))) == RangeEnum.VALUE_10) {
                        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)DimEntityNumEnum.getNumberByLowercaseNumber((String)key), (String)((String)doc.get("number")));
                        if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                        sb.append((String)doc.get("number")).append(' ');
                        sb.append(node.getName()).append(';').append(' ');
                        continue;
                    }
                    sb.append((String)doc.get("number")).append(' ').append((String)doc.get("name")).append(ResManager.loadKDString((String)"\u7684", (String)"BeginYearCarryPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)Integer.parseInt((String)doc.get("scope"))).getName()).append(';').append(' ');
                }
            }
        });
        return sb.toString();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long model = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (model != null && model != 0L) {
            this.cacheId(model);
        }
        HashMap<String, String> f7Key2Dim = new HashMap<String, String>();
        f7Key2Dim.put(LAST_SCENARIO, DimTypesEnum.SCENARIO.getNumber());
        f7Key2Dim.put(LAST_PERIOD, DimTypesEnum.PERIOD.getNumber());
        this.getPageCache().put("f7Key2Dim", this.toByteSerialized(f7Key2Dim));
        Long scenario = (Long)this.getView().getFormShowParameter().getCustomParam(scenariokey);
        Long year = (Long)this.getView().getFormShowParameter().getCustomParam(yearkey);
        this.getModel().setValue(modelkey, (Object)model);
        this.getModel().setValue(scenariokey, (Object)scenario);
        this.getModel().setValue(yearkey, (Object)year);
        this.refreshEntry(model, scenario, year);
        if (this.getModel().getValue("id") == null || (Long)this.getModel().getValue("id") == 0L) {
            this.getModel().deleteEntryData(SPECIAL_ENTRY);
        }
        if ("btn_param".equals(this.getFormCustomParam("itemKey"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{entryentitykey});
        }
    }

    private void cacheId(Long model) {
        String id = QueryDimensionServiceHelper.getDimIdByNumber((String)DimTypesEnum.PERIOD.getNumber(), (String)String.valueOf(model));
        this.getPageCache().put(DIM_PREIOD_ID, id);
        String scenarioId = QueryDimensionServiceHelper.getDimIdByNumber((String)DimTypesEnum.SCENARIO.getNumber(), (String)String.valueOf(model));
        this.getPageCache().put(DIM_SCENARIO_ID, scenarioId);
    }

    private void refreshEntry(Long model, Long scenario, Long year) {
        if (model == null || scenario == null || year == null || model == 0L || scenario == 0L || year == 0L) {
            return;
        }
        QFilter modelQFilter = new QFilter(modelkey, "=", (Object)model);
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)scenario, (String)"bcm_scenemembertree", (String)"sceneperiod");
        ArrayList ids = new ArrayList();
        DynamicObjectCollection scenePeriod = dot.getDynamicObjectCollection("sceneperiod");
        scenePeriod.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
        QFilter idsQFilter = new QFilter("id", "in", ids);
        boolean exists = QueryServiceHelper.exists((String)"bcm_periodmembertree", (QFilter[])new QFilter[]{modelQFilter, idsQFilter});
        if (exists) {
            HashMap<Long, Pair<DynamicObject, DynamicObject>> periodToSetting = new HashMap<Long, Pair<DynamicObject, DynamicObject>>(16);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryentitykey);
            for (DynamicObject carry : entryentity) {
                periodToSetting.put(carry.getLong("curperiod.id"), new Pair((Object)carry.getDynamicObject(LAST_SCENARIO), (Object)carry.getDynamicObject(LAST_PERIOD)));
            }
            List<DynamicObject> orderPeriods = DimensionUtil.getOrderedMembers(model, "bcm_periodmembertree", new HashSet<Long>(ids));
            String yearNumber = MemberReader.findFyMemberById((String)MemberReader.findModelNumberById((Object)model), (Long)year).getNumber();
            orderPeriods.removeIf(m -> m.getBoolean("isadjust") && !m.getString("useyear").contains(yearNumber));
            this.insertEntry(orderPeriods, year, scenario, (Long)this.getView().getFormShowParameter().getCustomParam(LAST_YEAR), periodToSetting);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f00\u542f\u4e00\u4e2a\u6570\u636e\u671f\u95f4\u3002", (String)"BeginYearCarryPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean queryTheSubtableData(DynamicObjectCollection carryobj) {
        if (carryobj != null && !carryobj.isEmpty()) {
            HashSet<Long> entryentity = new HashSet<Long>();
            for (DynamicObject dynamicObject : carryobj) {
                if (dynamicObject.getLong("entryentity.curyear") != 0L) continue;
                entryentity.add(dynamicObject.getLong("id"));
            }
            if (!entryentity.isEmpty()) {
                QFilter qff1 = new QFilter("id", "in", entryentity);
                QFilter[] filters1 = new QFilter[]{qff1};
                DeleteServiceHelper.delete((String)"bcm_carrymap", (QFilter[])filters1);
                return false;
            }
            return true;
        }
        return false;
    }

    private void insertEntry(List<DynamicObject> periods, Long year, Long scenario, Long lastYear, Map<Long, Pair<DynamicObject, DynamicObject>> periodToSetting) {
        String lastP;
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        DynamicObject lastYearEntity = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)lastYear).toArray());
        DynamicObject scenarioEntity = BusinessDataServiceHelper.loadSingle((Object)scenario, (String)"bcm_scenemembertree");
        Optional lastPeriod = PeriodUtils.getLastPeriod((String)modelNum, (String)MemberReader.findFyMemberById((String)modelNum, (Long)year).getNumber(), (String)(scenarioEntity.getString("number").contains("QRpt") ? "Q_Q1" : "M_M01"), (boolean)true);
        DynamicObject defaultLastPeriod = null;
        if (!lastPeriod.isPresent()) {
            Optional optional = PeriodUtils.getLastPeriod((String)modelNum, (String)MemberReader.findFyMemberById((String)modelNum, (Long)year).getNumber(), (String)(scenarioEntity.getString("number").contains("QRpt") ? "Q_Q1" : "M_M01"), (boolean)false);
            lastP = optional.orElse(null);
        } else {
            lastP = (String)lastPeriod.get();
        }
        HashSet ids = new HashSet();
        HashMap periodMap = new HashMap(16);
        DynamicObjectCollection scenePeriod = scenarioEntity.getDynamicObjectCollection("sceneperiod");
        scenePeriod.forEach(p -> {
            periodMap.put(p.getDynamicObject("fbasedataid").getString("number"), p.getDynamicObject("fbasedataid"));
            ids.add(p.getDynamicObject("fbasedataid").getLong("id"));
        });
        List<DynamicObject> orderPeriods = DimensionUtil.getOrderedMembers(this.getModelId(), "bcm_periodmembertree", new HashSet<Long>(ids));
        String lastYearNum = lastYearEntity.getString("number");
        orderPeriods.removeIf(m -> m.getBoolean("isadjust") && !m.getString("useyear").contains(lastYearNum));
        for (DynamicObject orderPeriod : orderPeriods) {
            if (!orderPeriod.getString("number").equals(lastP)) continue;
            defaultLastPeriod = orderPeriod;
        }
        if (defaultLastPeriod == null && !orderPeriods.isEmpty()) {
            defaultLastPeriod = (DynamicObject)periodMap.get(orderPeriods.get(orderPeriods.size() - 1).getString("number"));
        }
        int i = 0;
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryentitykey);
        this.getModel().batchCreateNewEntryRow(entryentitykey, periods.size());
        for (DynamicObject period : periods) {
            long curPeriod = period.getLong("id");
            this.getModel().setValue(CUR_YEAR, (Object)year, i);
            this.getModel().setValue(CUR_PERIOD, (Object)period, i);
            this.getModel().setValue(LAST_YEAR, lastYearEntity.get("id"), i);
            if (periodToSetting.get(curPeriod) != null) {
                this.getModel().setValue(LAST_SCENARIO, periodToSetting.get((Object)Long.valueOf((long)curPeriod)).p1, i);
                this.getModel().setValue(LAST_PERIOD, periodToSetting.get((Object)Long.valueOf((long)curPeriod)).p2, i);
            } else {
                this.getModel().setValue(LAST_SCENARIO, (Object)scenarioEntity.getLong("id"), i);
                if (defaultLastPeriod != null) {
                    this.getModel().setValue(LAST_PERIOD, (Object)defaultLastPeriod.getLong("id"), i);
                }
            }
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(entryentitykey);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Long model = this.defaultIfNull(this.getModel().getValue(modelkey), 0L, v -> ((DynamicObject)v).getLong("id"));
        if (e.getProperty().getName().equals(LAST_SCENARIO) || e.getProperty().getName().equals(LAST_PERIOD)) {
            if (e.getProperty().getName().equals(LAST_SCENARIO)) {
                this.getModel().setValue(LAST_PERIOD, null, e.getChangeSet()[0].getRowIndex());
            }
            return;
        }
        if (DIMENSION.equals(e.getProperty().getName())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(SPECIAL_ENTRY);
            if (StringUtils.isEmpty((String)e.getChangeSet()[0].getNewValue().toString())) {
                this.getModel().setValue(ACCOUNT_SCOPE, null, rowIndex);
                this.getModel().setValue(DIMENSION_SCOPE, null, rowIndex);
            }
            return;
        }
        if (Arrays.asList(ACCOUNT_SCOPE, SOURCE_YEAR, BEFORE_YEAR).contains(e.getProperty().getName())) {
            return;
        }
        Long scenario = this.defaultIfNull(this.getModel().getValue(scenariokey), 0L, v -> ((DynamicObject)v).getLong("id"));
        Long year = this.defaultIfNull(this.getModel().getValue(yearkey), 0L, v -> ((DynamicObject)v).getLong("id"));
        if (e.getProperty().getName().equals(modelkey)) {
            this.cacheId(model);
        }
        this.getView().getFormShowParameter().setStatus(OperationStatus.ADDNEW);
        this.refreshEntry(model, scenario, year);
        this.getView().cacheFormShowParameter();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("baritesave".equals(itemKey) && !this.checkSetting()) {
            evt.setCancel(true);
        }
    }

    private boolean checkSetting() {
        boolean res = true;
        DynamicObjectCollection entries = this.getModel().getEntryEntity(entryentitykey);
        int index = 0;
        for (DynamicObject entry : entries) {
            if (entry.get(LAST_SCENARIO) == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BeginYearCarryPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), index + 1));
                res = false;
                break;
            }
            if (entry.get(LAST_PERIOD) == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e0a\u5e74\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BeginYearCarryPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), index + 1));
                res = false;
                break;
            }
            ++index;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SPECIAL_ENTRY);
        int row = 0;
        for (DynamicObject entry : entryEntity) {
            if (StringUtils.isEmpty((String)entry.getString(DIMENSION))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ef4\u5ea6\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BeginYearCarryPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row + 1));
                res = false;
                break;
            }
            if (CollectionUtils.isEmpty((Collection)entry.getDynamicObjectCollection(BEFORE_YEAR))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5e74\u521d\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BeginYearCarryPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row + 1));
                res = false;
                break;
            }
            if (Objects.isNull(this.getModel().getValue(SOURCE_YEAR, row))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6765\u6e90\u671f\u95f4\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BeginYearCarryPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row + 1));
                res = false;
                break;
            }
            ++row;
        }
        return res;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getSource() instanceof Save) {
            OPDescMultiLangEnumBridge des = "btn_param".equals(this.getFormCustomParam("itemKey")) ? new OPDescMultiLangEnumBridge("\u5e74\u521d\u7ed3\u8f6c-\u516c\u5171\u8bbe\u7f6e\u4fdd\u5b58\u6210\u529f", "BeginYearCarryListPlugin_19", "fi-bcm-formplugin", null) : new OPDescMultiLangEnumBridge("\u5e74\u521d\u7ed3\u8f6c-\u7279\u6b8a\u8bbe\u7f6e\u4fdd\u5b58\u6210\u529f", "BeginYearCarryListPlugin_20", "fi-bcm-formplugin", null);
            this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.SAVE.getMultiLangEnumBridge(), (String)"Save"), des);
        } else if (e.getSource() instanceof NewEntry) {
            int index = this.getModel().getEntryCurrentRowIndex(SPECIAL_ENTRY);
            if (this.getModel().getValue(LAST_PERIOD) != null) {
                List<String> validatePeriods = this.getValidatePeriods(((DynamicObject)this.getModel().getValue(yearkey)).getString("number"));
                if (!validatePeriods.isEmpty()) {
                    Long[] ids = new Long[validatePeriods.size()];
                    for (int i = 0; i < validatePeriods.size(); ++i) {
                        ids[i] = LongUtil.toLong((Object)validatePeriods.get(i));
                    }
                    this.getModel().setValue(BEFORE_YEAR, (Object)ids);
                }
                if (validatePeriods.contains(((DynamicObject)this.getModel().getValue(LAST_PERIOD, 0)).getString("id"))) {
                    this.getModel().setValue(SOURCE_YEAR, (Object)((DynamicObject)this.getModel().getValue(LAST_PERIOD, 0)).getLong("id"), index);
                }
            }
        }
    }

    private List<String> getValidatePeriods(String yearNum) {
        String periods = this.getPageCache().get("periods_" + yearNum);
        ArrayList<String> ids = new ArrayList();
        if (StringUtils.isEmpty((String)periods)) {
            Long scenarioId = ((DynamicObject)this.getModel().getValue(scenariokey)).getLong("id");
            DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)scenarioId, (String)"bcm_scenemembertree", (String)"sceneperiod");
            DynamicObjectCollection sceneperiod = dot.getDynamicObjectCollection("sceneperiod");
            for (DynamicObject p : sceneperiod) {
                ids.add(p.getDynamicObject("fbasedataid").getString("id"));
            }
            DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,isleaf,isadjust,useyear,dseq", (QFilter[])new QFilter("model.id", "=", (Object)this.getModelId()).and("id", "in", (Object)ConvertUtil.convertListToLong(ids)).toArray(), (String)"level,dseq");
            for (DynamicObject member : members) {
                if (!member.getBoolean("isadjust") || member.getString("useyear").contains(yearNum)) continue;
                ids.remove(member.getString("id"));
            }
            this.getPageCache().put("periods_" + yearNum, this.toByteSerialized(ids));
        } else {
            ids = (List)this.deSerializedBytes(periods);
        }
        return ids;
    }

    private <R> R defaultIfNull(Object v, R defaultValue, Function<Object, R> f) {
        Predicate<Object> p = t -> t == null;
        if (p.test(v)) {
            return defaultValue;
        }
        return f.apply(v);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        QFilter qFilter = new QFilter(modelkey, "=", (Object)this.getModelId());
        if (key.equals(LAST_PERIOD)) {
            if (this.getModel().getValue(LAST_SCENARIO, e.getRow()) != null) {
                this.setF7Qfilter(e);
            }
        } else if (key.equals(LAST_SCENARIO)) {
            Set<Long> perm = this.getPerm();
            if (!perm.isEmpty()) {
                ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
                listFilterParameter.setFilter(new QFilter("id", "not in", perm));
            }
        } else if (key.equals(BEFORE_YEAR) || key.equals(SOURCE_YEAR)) {
            String yearNum = key.equals(BEFORE_YEAR) ? ((DynamicObject)this.getModel().getValue(yearkey)).getString("number") : ((DynamicObject)this.getModel().getValue(LAST_YEAR)).getString("number");
            List havePeriods = this.getValidatePeriods(yearNum).stream().map(p -> LongUtil.toLong((Object)p)).collect(Collectors.toList());
            if (!havePeriods.isEmpty()) {
                qFilter.and("id", "in", havePeriods);
                ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
                listFilterParameter.setFilter(qFilter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u671f\u95f4\u3002", (String)"BeginYearCarryPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    private void setF7Qfilter(BeforeF7SelectEvent e) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(modelkey, "=", (Object)this.getModelId()));
        Long scenarioid = ((DynamicObject)this.getModel().getValue(LAST_SCENARIO, e.getRow())).getLong("id");
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)scenarioid, (String)"bcm_scenemembertree", (String)"sceneperiod");
        ArrayList ids = new ArrayList();
        DynamicObjectCollection sceneperiod = dot.getDynamicObjectCollection("sceneperiod");
        sceneperiod.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
        DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,isleaf,isadjust,useyear,dseq", (QFilter[])new QFilter("model.id", "=", (Object)this.getModelId()).toArray(), (String)"level,dseq");
        for (DynamicObject member : members) {
            if (!member.getBoolean("isadjust") || member.getString("useyear").contains(((DynamicObject)this.getModel().getValue(LAST_YEAR, e.getRow())).getString("number"))) continue;
            ids.remove(member.getLong("id"));
        }
        qFilters.add(new QFilter("id", "in", ids));
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        listFilterParameter.setQFilters(qFilters);
        listFilterParameter.setOrderBy("dseq");
    }

    private Set<Long> getPerm() {
        boolean modelManager = MemberPermHelper.isModelManager((Long)this.getModelId());
        HashSet<Long> set = new HashSet<Long>();
        if (modelManager) {
            return set;
        }
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_scenemembertree", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
        Collection entries = map.entries();
        for (Map.Entry entrie : entries) {
            if (!DataTypeEnum.NO.getIndex().equals(entrie.getKey())) continue;
            set.add((Long)entrie.getValue());
        }
        return set;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Close) {
            return;
        }
        if (args.getSource() instanceof Save) {
            int is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), "bcm_carrylist", "/=NAF=U/PB06");
            if (is == 0) {
                if (MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()))) {
                    return;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"BeginYearCarryPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            int index = 0;
            if ("btn_specialsetting".equals(this.getFormCustomParam("itemKey")) && LongUtil.toLong((Object)this.getModel().getValue("id")) != 0L) {
                DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"bcm_carrymap");
                DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection(entryentitykey);
                Map<Integer, DynamicObject> seq = entryentity.stream().collect(Collectors.toMap(e -> e.getInt("seq"), e -> e, (existValue, newValue) -> newValue));
                for (Map.Entry<Integer, DynamicObject> entry : seq.entrySet()) {
                    this.getModel().setValue(LAST_SCENARIO, entry.getValue().get(LAST_SCENARIO), entry.getKey() - 1);
                    this.getModel().setValue(LAST_PERIOD, entry.getValue().get(LAST_PERIOD), entry.getKey() - 1);
                }
            } else {
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryentitykey);
                for (DynamicObject object : entryentity) {
                    object.set("seq", (Object)index);
                    ++index;
                }
            }
            DynamicObjectCollection specialentry = this.getModel().getEntryEntity(SPECIAL_ENTRY);
            index = 0;
            for (DynamicObject object : specialentry) {
                object.set("seq", (Object)index);
                ++index;
            }
        }
    }
}

