/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.carry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class CarryDimSettingPlugin
extends AbstractBaseFormPlugin {
    private static final String DIMENSION = "dimension";
    private static final String ENTITY = "entity";
    private static final String ACCOUNT = "account";
    private static final String BUTTON_OK = "button_ok";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(ENTITY, ACCOUNT, BUTTON_OK);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getFormCustomParam(DIMENSION) != null) {
            Map mapParams = (Map)this.getFormCustomParam(DIMENSION);
            mapParams.forEach((key, val) -> this.setValue((String)key, this.getDimAppearStr((String)key, (List<Map<String, String>>)val)));
            this.getView().getPageCache().put(DIMENSION, this.toByteSerialized(mapParams));
        }
    }

    private String getDimAppearStr(String key, List<Map<String, String>> val) {
        StringBuilder sb = new StringBuilder();
        if (val == null) {
            return null;
        }
        for (Map<String, String> doc : val) {
            if (RangeEnum.getRangeByVal((int)Integer.parseInt(doc.get("scope"))) == RangeEnum.VALUE_10) {
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)DimEntityNumEnum.getNumberByLowercaseNumber((String)key), (String)doc.get("number"));
                if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                sb.append(doc.get("number")).append(' ');
                sb.append(node.getName()).append(';').append(' ');
                continue;
            }
            sb.append(doc.get("number")).append(' ').append(doc.get("name")).append(ResManager.loadKDString((String)"\u7684", (String)"DimDesignerControlPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)Integer.parseInt(doc.get("scope"))).getName()).append(';').append(' ');
        }
        return sb.toString().length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BUTTON_OK.equals(key)) {
            this.checkNull();
            this.returnDataToParent(this.getCacheObject());
            this.getView().close();
        } else {
            Map map;
            String dimNumber = DimEntityNumEnum.getNumberByLowercaseNumber((String)key);
            FormShowParameter para = new FormShowParameter();
            DimensionMsgCache dmc = new DimensionMsgCache(this.getModelId());
            para.setFormId("bcm_mulmemberf7base_tem");
            para.getOpenStyle().setShowType(ShowType.Modal);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put(DIMENSION, String.valueOf(dmc.getSeq(dimNumber)));
            params.put("sign", key);
            if (dimNumber.equals(DimEntityNumEnum.ACCOUNT.getNumber())) {
                QFBuilder notRate = new QFBuilder("model", "=", (Object)this.getModelId());
                notRate.add("accounttype", "!=", (Object)AccountTypeEnum.EXCHANGERATE.index);
                DynamicObjectCollection cols = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"id", (QFilter[])notRate.toArray());
                List ids = cols.stream().map(col -> col.getString("id")).collect(Collectors.toList());
                params.put("filter", ids);
            }
            this.getView().getPageCache().put(key, null);
            if (this.getPageCache().get(DIMENSION) != null && (map = (Map)this.deSerializedBytes(this.getPageCache().get(DIMENSION))).get(key) != null) {
                this.getView().getPageCache().put(key, SerializationUtils.toJsonString(map.get(key)));
            }
            para.setCustomParams(params);
            para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"DimDesignerControlPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dmc.getName(key)));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            para.setCloseCallBack(closeCallBack);
            this.getView().showForm(para);
        }
    }

    private void checkNull() {
        if (this.getValue(ENTITY) == null && this.getValue(ACCOUNT) == null || StringUtils.isEmpty((String)this.getValue(ENTITY).toString()) && StringUtils.isEmpty((String)this.getValue(ACCOUNT).toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u548c\u79d1\u76ee\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"CarryDimSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null || StringUtils.isEmpty((String)newValue.toString())) {
            this.updateDimCache(key, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        DynamicObjectCollection docs = (DynamicObjectCollection)cb.getReturnData();
        if (cb.getReturnData() != null) {
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(docs.size());
            if (!docs.isEmpty()) {
                for (int i = 0; i < docs.size(); ++i) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    DynamicObject doc = (DynamicObject)docs.get(i);
                    map.put("id", doc.get(4).toString());
                    map.put("scope", doc.get(5).toString());
                    map.put("number", doc.get(2).toString());
                    map.put("name", doc.get(3).toString());
                    map.put("pid", doc.get(6).toString());
                    list.add(map);
                }
            } else {
                this.getPageCache().remove(key);
            }
            this.updateDimCache(key, list);
            this.setValue(key, this.getDimAppearStr(key, list));
        }
    }

    private String updateDimCache(String key, List<Map<String, String>> list) {
        String setting = this.getPageCache().get(DIMENSION);
        Map map = null;
        map = StringUtils.isEmpty((String)setting) ? new HashMap(2) : (Map)this.deSerializedBytes(setting);
        if (CollectionUtils.isEmpty(list)) {
            map.remove(key);
        } else {
            map.put(key, list);
        }
        String newCache = this.toByteSerialized(map);
        this.getPageCache().put(DIMENSION, newCache);
        return newCache;
    }

    private Map<String, List<Map<String, String>>> getCacheObject() {
        String setting = this.getPageCache().get(DIMENSION);
        Map map = null;
        map = StringUtils.isEmpty((String)setting) ? Collections.emptyMap() : (Map)this.deSerializedBytes(setting);
        return map;
    }
}

