/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.carry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.carry.CarryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;

public class NewBeginYearCarryConfirmPlugin
extends AbstractBaseFormPlugin {
    private static final String MODEL = "model";
    private static final String ID = "id";
    private static final String SCENARIO = "scenario";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String LAST_SCENARIO = "lastscenario";
    private static final String LAST_YEAR = "lastyear";
    private static final String LAST_PERIOD = "lastperiod";
    private static final String CURRENCY = "currency";
    private static final String BTN_OK = "btn_ok";
    private static final String ACCOUNT = "account";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRYENTITY_CURPERIOD = "entryentity.curperiod";
    private static final String ENTRYENTITY_LASTYEAR = "entryentity.lastyear";
    private static final String ENTRYENTITY_LASTSCENARIO = "entryentity.lastscenario";
    private static final String ENTRYENTITY_LASTPERIOD = "entryentity.lastperiod";
    private static final String FBASEDATAID = "fbasedataid";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String M_M13 = "M_M13";
    private static final String M_Q5 = "M_Q5";
    private static final String ORGIDS = "orgids";
    private static final String SCOPE = "scope";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(NewBeginYearCarryConfirmPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
        BasedataEdit lastPeriod = (BasedataEdit)this.getControl(LAST_PERIOD);
        lastPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit lastScenario = (BasedataEdit)this.getControl(LAST_SCENARIO);
        lastScenario.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshEntry();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        BasedataEdit bs = (BasedataEdit)arg0.getSource();
        String key = bs.getKey();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        if (key.equals(LAST_PERIOD)) {
            if (this.getModel().getValue(LAST_SCENARIO, rowIndex) != null) {
                this.setF7QFilter(arg0, rowIndex);
            }
        } else if (key.equals(LAST_SCENARIO)) {
            QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
            qFilter.and("isleaf", "=", (Object)true);
            ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            listFilterParameter.setFilter(qFilter);
        }
    }

    private void setF7QFilter(BeforeF7SelectEvent e, int rowIndex) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        Long scenarioId = ((DynamicObject)this.getModel().getValue(LAST_SCENARIO, rowIndex)).getLong(ID);
        QFilter filter1 = new QFilter(ID, "=", (Object)scenarioId);
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])new QFilter[]{filter1});
        ArrayList ids = new ArrayList();
        DynamicObjectCollection sceneperiod = dot.getDynamicObjectCollection("sceneperiod");
        sceneperiod.forEach(p -> ids.add(p.getDynamicObject(FBASEDATAID).getLong(ID)));
        DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,isleaf,isadjust,useyear,dseq", (QFilter[])new QFilter("model.id", "=", (Object)this.getModelId()).toArray(), (String)"level,dseq");
        for (DynamicObject member : members) {
            if (!member.getBoolean("isadjust") || member.getString("useyear").contains(((DynamicObject)this.getModel().getValue(LAST_YEAR, e.getRow())).getString(NUMBER))) continue;
            ids.remove(member.getLong(ID));
        }
        qFilters.add(new QFilter(ID, "in", ids));
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        listFilterParameter.setQFilters(qFilters);
        listFilterParameter.setOrderBy("dseq");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        if (LAST_SCENARIO.equals(propertyName)) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null && oldValue != null) {
                this.getModel().setValue(e.getProperty().toString(), (Object)oldValue.getLong(ID));
                return;
            }
            this.getModel().setValue(LAST_PERIOD, null, rowIndex);
            this.getView().updateView(LAST_PERIOD, rowIndex);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(BTN_OK)) {
            this.validatorCondition();
            String result = null;
            try {
                result = this.carryOperationInMenu();
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e74\u7ed3\u6267\u884c\u5931\u8d25:%s", (String)"BeginYearCarryConfirmPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                this.getView().showTipNotification(result);
                return;
            }
            this.getView().returnDataToParent((Object)"finish");
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
    }

    private void validatorCondition() {
        int[] selectRows;
        EntryGrid treeEntry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        for (int row : selectRows = treeEntry.getSelectRows()) {
            if (this.getModel().getValue(LAST_PERIOD, row) != null) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e0a\u5e74\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"BeginYearCarryConfirmPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row));
        }
    }

    private void refreshEntry() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        Long sceneId = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_scenemembertree");
        Long yearId = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_fymembertree");
        Long periodId = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_periodmembertree");
        DynamicObject periodEntity = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)"dseq", (QFilter[])new QFilter(ID, "=", (Object)periodId).toArray());
        Set filterPeriods = this.getView().getFormShowParameter().getCustomParam("periods") == null ? null : (Set)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("periods")), Set.class);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (!CollectionUtils.isEmpty(filterPeriods)) {
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bcm_carrymap", (String)"id,entryentity.curyear,entryentity.curperiod,entryentity.lastscenario,entryentity.lastyear,entryentity.lastperiod,entryentity.seq", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId), new QFilter(SCENARIO, "=", (Object)sceneId), new QFilter(YEAR, "=", (Object)yearId)});
            HashMap<Long, Pair<Long, Long>> periodToSetting = new HashMap<Long, Pair<Long, Long>>(16);
            if (!periods.isEmpty()) {
                for (DynamicObject carry : periods) {
                    periodToSetting.putIfAbsent(carry.getLong(ENTRYENTITY_CURPERIOD), (Pair<Long, Long>)new Pair((Object)carry.getLong(ENTRYENTITY_LASTSCENARIO), (Object)carry.getLong(ENTRYENTITY_LASTPERIOD)));
                }
            }
            List<DynamicObject> orderPeriods = DimensionUtil.getOrderedMembers(modelId, "bcm_periodmembertree", new HashSet<Long>(filterPeriods));
            this.insertEntry(orderPeriods, yearId, sceneId, (Long)this.getView().getFormShowParameter().getCustomParam("lastyearid"), periodToSetting);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u671f\u95f4\u672a\u5f00\u542f\uff0c\u8bf7\u5230\u671f\u95f4\u7ba1\u7406\u9875\u9762\u5f00\u542f\u671f\u95f4\u3002", (String)"BeginYearCarryPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void insertEntry(List<DynamicObject> periods, Long year, Long scenario, Long lastYear, Map<Long, Pair<Long, Long>> periodToSetting) {
        if (periods.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ec4\u7ec7\u4e2d\u4e0d\u5b58\u5728\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u7684\u5f00\u542f\u671f\u95f4\u3002", (String)"NewBeginYearCarryConfirmPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        DynamicObject scenarioEntity = BusinessDataServiceHelper.loadSingle((Object)scenario, (String)"bcm_scenemembertree");
        Optional lastPeriod = PeriodUtils.getLastPeriod((String)modelNum, (String)MemberReader.findFyMemberById((String)modelNum, (Long)year).getNumber(), (String)(scenarioEntity.getString(NUMBER).contains("QRpt") ? "Q_Q1" : "M_M01"), (boolean)true);
        DynamicObject lastYearEntity = BusinessDataServiceHelper.loadSingle((Object)lastYear, (String)"bcm_fymembertree");
        DynamicObject defaultLastPeriod = null;
        String lastP = null;
        if (!lastPeriod.isPresent()) {
            Optional optional = PeriodUtils.getLastPeriod((String)modelNum, (String)MemberReader.findFyMemberById((String)modelNum, (Long)year).getNumber(), (String)(scenarioEntity.getString(NUMBER).contains("QRpt") ? "Q_Q1" : "M_M01"), (boolean)false);
            lastP = optional.orElse(null);
        } else {
            lastP = (String)lastPeriod.get();
        }
        HashSet ids = new HashSet();
        HashMap periodMap = new HashMap(16);
        DynamicObjectCollection scenePeriod = scenarioEntity.getDynamicObjectCollection("sceneperiod");
        scenePeriod.forEach(p -> {
            periodMap.put(p.getDynamicObject(FBASEDATAID).getString(NUMBER), p.getDynamicObject(FBASEDATAID));
            ids.add(p.getDynamicObject(FBASEDATAID).getLong(ID));
        });
        List<DynamicObject> orderPeriods = DimensionUtil.getOrderedMembers(this.getModelId(), "bcm_periodmembertree", new HashSet<Long>(ids));
        String lastYearNum = lastYearEntity.getString(NUMBER);
        orderPeriods.removeIf(m -> m.getBoolean("isadjust") && !m.getString("useyear").contains(lastYearNum));
        for (DynamicObject orderPeriod : orderPeriods) {
            if (!orderPeriod.getString(NUMBER).equals(lastP)) continue;
            defaultLastPeriod = orderPeriod;
        }
        if (defaultLastPeriod == null && !orderPeriods.isEmpty()) {
            defaultLastPeriod = (DynamicObject)periodMap.get(orderPeriods.get(orderPeriods.size() - 1).getString(NUMBER));
        }
        String yearNumber = MemberReader.findFyMemberById((String)modelNum, (Long)year).getNumber();
        periods.removeIf(m -> m.getBoolean("isadjust") && !m.getString("useyear").contains(yearNumber));
        if (!periods.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, periods.size());
            int i = 0;
            for (DynamicObject obj : periods) {
                long period = obj.getLong(ID);
                this.getModel().setValue(YEAR, (Object)year, i);
                this.getModel().setValue(PERIOD, (Object)period, i);
                this.getModel().setValue(SCENARIO, (Object)scenario, i);
                this.getModel().setValue(LAST_YEAR, (Object)lastYear, i);
                if (periodToSetting.get(period) != null) {
                    this.getModel().setValue(LAST_SCENARIO, periodToSetting.get((Object)Long.valueOf((long)period)).p1, i);
                    this.getModel().setValue(LAST_PERIOD, periodToSetting.get((Object)Long.valueOf((long)period)).p2, i);
                } else {
                    this.getModel().setValue(LAST_SCENARIO, (Object)scenario, i);
                    this.getModel().setValue(LAST_PERIOD, (Object)defaultLastPeriod, i);
                }
                ++i;
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    private String carryOperationInMenu() {
        String lastPeriodNum;
        Long modelId = this.getModelId();
        List orgIds = this.getFormCustomParam(ORGIDS, Collections.emptyList());
        Map orgIdNameMap = (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("orgIdMap")));
        Map orgNumberMap = (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("orgNumberMap")));
        HashSet orgNumbers = new HashSet();
        Set ids = ConvertUtil.convertListToLong(orgIds);
        ArrayList<IDNumberTreeNode> nodes = new ArrayList<IDNumberTreeNode>(10);
        ArrayList children = new ArrayList(10);
        for (Long id : ids) {
            IDNumberTreeNode member = MemberReader.findEntityMemberById((Long)modelId, (Long)id);
            if (member == IDNumberTreeNode.NotFoundTreeNode) continue;
            nodes.add(member);
            if (member.isLeaf()) continue;
            children.addAll(member.getChildren());
        }
        Map idMap = nodes.stream().collect(Collectors.toMap(re -> re.getId(), Function.identity()));
        nodes.forEach(re -> orgNumbers.add(re.getNumber()));
        children.forEach(re -> orgNumbers.add(re.getParent().getNumber() + "_" + re.getNumber()));
        if (orgNumbers.isEmpty()) {
            this.getView().close();
            return "";
        }
        EntryGrid treeEntry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectIndexs = treeEntry.getSelectRows();
        if (selectIndexs.length == 0) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u6267\u884c\u7684\u884c\u3002", (String)"BeginYearCarryPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String[] curYearNums = new String[selectIndexs.length];
        String[] curYearIds = new String[selectIndexs.length];
        String[] curPeriodNums = new String[selectIndexs.length];
        String[] curPeriodIds = new String[selectIndexs.length];
        String[] lastSenarioNums = new String[selectIndexs.length];
        String[] lastSenarioIds = new String[selectIndexs.length];
        String[] lastYearNums = new String[selectIndexs.length];
        String[] lastYearIds = new String[selectIndexs.length];
        String[] lastPeriodNums = new String[selectIndexs.length];
        String[] lastPeriodIds = new String[selectIndexs.length];
        for (int i = 0; i < selectIndexs.length; ++i) {
            int index = selectIndexs[i];
            String curYearNum = this.defaultIfNull(this.getModel().getValue(YEAR, index), null, v -> ((DynamicObject)v).getString(NUMBER));
            String curYearId = this.defaultIfNull(this.getModel().getValue(YEAR, index), null, v -> ((DynamicObject)v).getString(ID));
            String curPeriodNum = this.defaultIfNull(this.getModel().getValue(PERIOD, index), null, v -> ((DynamicObject)v).getString(NUMBER));
            String string = this.defaultIfNull(this.getModel().getValue(PERIOD, index), null, v -> ((DynamicObject)v).getString(ID));
            String lastScenarioNum = this.defaultIfNull(this.getModel().getValue(LAST_SCENARIO, index), null, v -> ((DynamicObject)v).getString(NUMBER));
            String lastScenarioId = this.defaultIfNull(this.getModel().getValue(LAST_SCENARIO, index), null, v -> ((DynamicObject)v).getString(ID));
            String lastYearNum = this.defaultIfNull(this.getModel().getValue(LAST_YEAR, index), null, v -> ((DynamicObject)v).getString(NUMBER));
            String lastYearId = this.defaultIfNull(this.getModel().getValue(LAST_YEAR, index), null, v -> ((DynamicObject)v).getString(ID));
            lastPeriodNum = this.defaultIfNull(this.getModel().getValue(LAST_PERIOD, index), null, v -> ((DynamicObject)v).getString(NUMBER));
            String lastPeriodId = this.defaultIfNull(this.getModel().getValue(LAST_PERIOD, index), null, v -> ((DynamicObject)v).getString(ID));
            if (curYearNum == null || curPeriodNum == null || lastScenarioNum == null || lastYearNum == null || lastPeriodNum == null) {
                return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u8981\u6267\u884c\u7684\u884c\u3002", (String)"BeginYearCarryPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            curYearNums[i] = curYearNum;
            curYearIds[i] = curYearId;
            curPeriodNums[i] = curPeriodNum;
            curPeriodIds[i] = string;
            lastSenarioNums[i] = lastScenarioNum;
            lastSenarioIds[i] = lastScenarioId;
            lastYearNums[i] = lastYearNum;
            lastYearIds[i] = lastYearId;
            lastPeriodNums[i] = lastPeriodNum;
            lastPeriodIds[i] = lastPeriodId;
        }
        String cube = MemberReader.findModelNumberById((Object)modelId);
        String scenarioId = this.getView().getFormShowParameter().getCustomParam("bcm_scenemembertree").toString();
        String scenario = MemberReader.findScenaMemberById((String)cube, (Long)LongUtil.toLong((Object)scenarioId)).getNumber();
        String year = this.getView().getFormShowParameter().getCustomParam("bcm_fymembertree").toString();
        HashMap mcStatusMap = new HashMap(16);
        for (String period : curPeriodIds) {
            mcStatusMap.putAll(McStatus.batchGetMcStatus((Object)modelId, (Collection)ids, (Object)scenarioId, (Object)year, (Object)LongUtil.toLong((Object)period)));
        }
        if (mcStatusMap.values().stream().anyMatch(m -> m.getFlow().isSubmit())) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u4e2d\u5305\u542b\u5df2\u63d0\u4ea4\u6216\u8005\u5df2\u5f52\u6863\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BeginYearCarryPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        DynamicObject[] dynamicObjectArray = new DynamicObject[selectIndexs.length * orgIds.size()];
        Map carrySpecialSetting = CarryServiceHelper.getCarrySpecialSetting((String)cube, (String)scenario, (String)curYearNums[0]);
        int dynIndex = 0;
        for (int i = 0; i < selectIndexs.length; ++i) {
            String lastYearNum = lastYearNums[i];
            lastPeriodNum = lastPeriodNums[i];
            String lastScenario = lastSenarioNums[i];
            String curYearNum = curYearNums[i];
            String curPeriodNum = curPeriodNums[i];
            StringBuilder builder = CarryServiceHelper.simpleCarry((long)modelId, (String)cube, (String)lastScenario, (String)lastYearNum, (String)lastPeriodNum, (String)scenario, (String)curYearNum, (String)curPeriodNum, orgNumbers, Collections.emptySet(), null);
            String yearPeriod = curYearNum + "." + curPeriodNum;
            if (builder.length() > 0) {
                for (IDNumberTreeNode res : nodes) {
                    builder.insert(0, res.getNumber() + " " + res.getName() + " " + yearPeriod + " ");
                    this.writeMultiLangLog(NewBeginYearCarryConfirmPlugin.getOperationBeginningOfTheYear(), OPDescMultiLangEnumBridge.genUnTransBridge((String)(builder + NewBeginYearCarryConfirmPlugin.getOperationStstusSuccess())));
                }
            } else {
                for (IDNumberTreeNode res : nodes) {
                    this.writeOperationLog(new OpNameMultiLangEnumBridge("\u5e74\u521d\u7ed3\u8f6c", "BeginYearCarryPlugin_0", "fi-bcm-formplugin", "Carry Forward"), res.getNumber() + " " + res.getName(), yearPeriod, NewBeginYearCarryConfirmPlugin.getOperationStstusSuccess());
                }
            }
            Map specials = (Map)carrySpecialSetting.get(curPeriodNum);
            for (int j = 0; j < orgIds.size(); ++j) {
                String orgId = (String)orgIds.get(j);
                DynamicObject carryObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_carryentity");
                carryObj.set(MODEL, (Object)modelId);
                carryObj.set("scene", (Object)scenarioId);
                carryObj.set("lastscene", (Object)lastSenarioIds[i]);
                carryObj.set(YEAR, (Object)LongUtil.toLong((Object)year));
                carryObj.set(PERIOD, (Object)curPeriodIds[i]);
                carryObj.set(LAST_PERIOD, (Object)lastPeriodIds[i]);
                carryObj.set("org", (Object)orgId);
                carryObj.set("carrystatus", (Object)"1");
                carryObj.set("modifier", (Object)RequestContext.get().getUserId());
                carryObj.set("modifydate", (Object)TimeServiceHelper.now());
                if (builder.length() > 0 && specials != null) {
                    DynamicObjectCollection colls = carryObj.getDynamicObjectCollection(ENTRY_ENTITY);
                    HashMap<String, List> sourcePeriod = new HashMap<String, List>(16);
                    specials.forEach((key, val) -> {
                        if (!key.equals(lastPeriodNum)) {
                            for (String v : val) {
                                Map tempMapList = (Map)SerializationUtils.fromJsonString((String)v, Map.class);
                                HashSet entities = new HashSet(16);
                                if (tempMapList.get(SysDimensionEnum.Entity.getSign()) != null) {
                                    ((List)tempMapList.get(SysDimensionEnum.Entity.getSign())).stream().forEach(map -> {
                                        Long id = Long.valueOf((String)map.get(ID));
                                        String scope = (String)map.get(SCOPE);
                                        String entityNum = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)id).getNumber();
                                        new MembRangeItem("bcm_entitymembertree", id, entityNum, RangeEnum.getRangeByVal((int)Integer.parseInt(scope)), false, (Object)modelId).matchItems(c -> entities.add(c.id.toString()));
                                    });
                                }
                                if (!entities.isEmpty() && !entities.contains(orgId)) continue;
                                sourcePeriod.putIfAbsent((String)key, new ArrayList(10));
                                if (tempMapList.get(SysDimensionEnum.Account.getSign()) == null) continue;
                                ((List)tempMapList.get(SysDimensionEnum.Account.getSign())).stream().forEach(map -> ((List)sourcePeriod.get(key)).add(new Pair((Object)Long.valueOf((String)map.get(ID)), map.get(SCOPE))));
                            }
                        }
                    });
                    if (sourcePeriod.size() > 0) {
                        sourcePeriod.forEach((per, pairs) -> {
                            Long periodId = MemberReader.findPeriodMemberByNum((String)cube, (String)per).getId();
                            if (pairs.isEmpty()) {
                                DynamicObject temp = new DynamicObject(colls.getDynamicObjectType());
                                temp.set("sourceperiod", (Object)periodId);
                                colls.add((Object)temp);
                            } else {
                                for (Pair pair : pairs) {
                                    DynamicObject temp = new DynamicObject(colls.getDynamicObjectType());
                                    temp.set(ACCOUNT, pair.p1);
                                    temp.set(SCOPE, pair.p2);
                                    temp.set("sourceperiod", (Object)periodId);
                                    colls.add((Object)temp);
                                }
                            }
                        });
                    }
                }
                dynamicObjectArray[dynIndex] = carryObj;
                ++dynIndex;
            }
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
        return "";
    }

    private String transOldScope(String accountScope) {
        HashMap<String, List> map = new HashMap<String, List>(2);
        List tempList = (List)SerializationUtils.fromJsonString((String)accountScope, List.class);
        map.put(SysDimensionEnum.Account.getSign(), tempList);
        return SerializationUtils.toJsonString(map);
    }

    private void removeExchangeAccount(Long modelId, Map<String, Pair<Set<String>, Set<String>>> accountNums) {
        HashSet allAccount = new HashSet();
        for (Pair nums : accountNums.values()) {
            if (((Set)nums.p2).isEmpty()) continue;
            allAccount.addAll((Collection)nums.p2);
        }
        QFBuilder qb = new QFBuilder();
        qb.add(NUMBER, "in", allAccount);
        qb.add("accounttype", "!=", (Object)AccountTypeEnum.EXCHANGERATE.index);
        qb.add(MODEL, "=", (Object)modelId);
        qb.add("isleaf", "=", (Object)true);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)NUMBER, (QFilter[])qb.toArray());
        if (CollectionUtils.isEmpty((Collection)cols)) {
            accountNums = Collections.emptyMap();
        } else {
            Set contains = cols.stream().map(col -> col.getString(NUMBER)).collect(Collectors.toSet());
            for (Pair pair : accountNums.values()) {
                if (((Set)pair.p2).isEmpty()) continue;
                ((Set)pair.p2).retainAll(contains);
            }
        }
    }

    private QFilter[] getPeriodQFilter(Long model, Set<String> orgNumbers, String scenario, String year, String[] periods, String statusField) {
        QFilter qfModel = new QFilter(MODEL, "=", (Object)model);
        QFilter qfOrg = new QFilter("orgnumber", "in", orgNumbers);
        QFilter qfScenario = new QFilter(SCENARIO, "=", (Object)LongUtil.toLong((Object)scenario));
        QFilter qfYear = new QFilter(YEAR, "=", (Object)LongUtil.toLong((Object)year));
        QFilter qfPeriod = new QFilter(PERIOD, "in", (Object)LongUtil.toLongList(Arrays.asList(periods)));
        QFilter qfStatus = new QFilter(statusField, "=", (Object)"A");
        return new QFilter[]{qfModel, qfOrg, qfScenario, qfYear, qfPeriod, qfStatus};
    }

    private static OpNameMultiLangEnumBridge getOperationBeginningOfTheYear() {
        return new OpNameMultiLangEnumBridge("\u5e74\u521d\u7ed3\u8f6c", "BeginYearCarryPlugin_0", "fi-bcm-formplugin", "Carry Forward");
    }

    private static final String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"BeginYearCarryPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private <R> R defaultIfNull(Object v, R defaultValue, Function<Object, R> f) {
        Predicate<Object> p = t -> t == null;
        if (p.test(v)) {
            return defaultValue;
        }
        return f.apply(v);
    }
}

