/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.allinone.util.AllInOneUtils;
import kd.fi.bcm.business.check.CheckContext;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.CheckResult;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.ICheckContext;
import kd.fi.bcm.business.check.helper.CheckRecordHelper;
import kd.fi.bcm.business.check.helper.CheckServiceHelper;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.adjust.LinkAdjustMappingEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.check.CheckHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckBalanceProcessPlugin
extends AbstractBaseListPlugin {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(CheckBalanceProcessPlugin.class);
    private static final String entryentity = "entryentity";
    private static final String entryid = "id";
    private static final String entrynum = "entrynum";
    private static final String entrytmpl = "entrytmpl";
    private static final String entryorg = "entryorg";
    private static final String entrycompany = "entrycompany";
    private static final String entrymycompany = "entrymycompany";
    private static final String entrydebitaccout = "entrydebitaccout";
    private static final String entrycreditaccout = "entrycreditaccout";
    private static final String entrychangetype = "entrychangetype";
    private static final String entryaudittrail = "entryaudittrail";
    private static final String entry_dim1 = "entrydim1";
    private static final String entry_dim2 = "entrydim2";
    private static final String entry_dim3 = "entrydim3";
    private static final String entry_dim4 = "entrydim4";
    private static final String entry_dim5 = "entrydim5";
    private static final String entry_dim6 = "entrydim6";
    private static final String entrydebit = "entrydebit";
    private static final String entrycredit = "entrycredit";
    private static final String entrydc = "dc";
    private static final String entrydiffmode = "diffmode";
    private static final String entrystatus = "status";
    private static final String entrydebelimval = "entrydebelimval";
    private static final String entrycreelimval = "entrycreelimval";
    private static final String checktmplentry = "checktmplentry";
    private static final String NUMBER = "number";
    private static final List<String> SCALE_COLS = Lists.newArrayList((Object[])new String[]{"entrydebit", "entrycredit", "entrydebelimval", "entrycreelimval"});
    private static final String KEY_YEAR_ID = "KEY_YEAR_ID";
    private static final String KEY_PERIOD_ID = "KEY_PERIOD_ID";
    private String[] allColumns = new String[]{"id", "entrynum", "entrytmpl", "entryorg", "entrymycompany", "entrycompany", "entrydebitaccout", "entrycreditaccout", "entrychangetype", "entryaudittrail", "entrydim1", "entrydim2", "entrydim3", "entrydim4", "entrydim5", "entrydim6", "entrydebit", "entrycredit", "dc", "diffmode", "status", "entrydebelimval", "entrycreelimval", "checktmplentry"};

    private static String getOperationView() {
        return ResManager.loadKDString((String)"\u67e5\u770b", (String)"CheckBalanceProcessPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getSubmit() {
        return ResManager.loadKDString((String)"\u786e\u8ba4", (String)"CheckBalanceProcessPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getUnsubmit() {
        return ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"CheckBalanceProcessPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"CheckBalanceProcessPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("linkbilllistap");
        billList.addCreateListColumnsListener(this::beforeCreateListColumns);
        billList.addPackageDataListener(this::packageData);
        billList.addHyperClickListener(this::hyperLinkClick);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap", "diffentrytoolbarap");
        this.addListeners();
    }

    private void addListeners() {
        EntryGrid diffentry = (EntryGrid)this.getControl(entryentity);
        for (FieldEdit fe : diffentry.getFieldEdits()) {
            ArrayList<QFilter> qfs;
            BasedataEdit be;
            if (entryorg.equals(fe.getFieldKey()) && fe instanceof BasedataEdit) {
                be = (BasedataEdit)fe;
                be.setQFilters(this.getOrgFilters());
                continue;
            }
            if (entrymycompany.equals(fe.getFieldKey()) && fe instanceof BasedataEdit) {
                be = (BasedataEdit)fe;
                qfs = new ArrayList<QFilter>(10);
                qfs.add(new QFilter("model", "=", (Object)this.getModelId()));
                if (!"ADJ".equalsIgnoreCase(this.getPageCache().get("processNum"))) {
                    qfs.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
                }
                be.setQFilters(qfs);
                continue;
            }
            if (entrycompany.equals(fe.getFieldKey()) && fe instanceof BasedataEdit) {
                be = (BasedataEdit)fe;
                qfs = new ArrayList(10);
                qfs.add(new QFilter("model", "=", (Object)this.getModelId()));
                if (!"ADJ".equalsIgnoreCase(this.getPageCache().get("processNum"))) {
                    qfs.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
                }
                be.setQFilters(qfs);
                continue;
            }
            if (entryaudittrail.equals(fe.getFieldKey()) && fe instanceof BasedataEdit) {
                be = (BasedataEdit)fe;
                qfs = new ArrayList(10);
                qfs.add(new QFilter("model", "=", (Object)this.getModelId()));
                qfs.add(new QFilter("datasource", "=", (Object)DataSourceEnum.ENTRYADJUSTMENT.getOIndex()).and("isleaf", "=", (Object)Boolean.TRUE));
                be.setQFilters(qfs);
                continue;
            }
            if (!entrydebitaccout.equals(fe.getFieldKey()) && !entrycreditaccout.equals(fe.getFieldKey()) && !entrychangetype.equals(fe.getFieldKey()) || !(fe instanceof BasedataEdit)) continue;
            be = (BasedataEdit)fe;
            qfs = new ArrayList(10);
            qfs.add(new QFilter("model", "=", (Object)this.getModelId()));
            qfs.add(new QFilter("storagetype", "in", (Object)StorageTypeEnum.getRealStorageEnumIndexs()));
            qfs.add(new QFilter("isleaf", "=", (Object)true));
            be.setQFilters(qfs);
        }
    }

    private List<QFilter> getOrgFilters() {
        CheckParam checkParam = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(10);
        String longNumber = this.getPageCache().get("parentLongNumber") != null ? this.getPageCache().get("parentLongNumber") : (String)this.getFormCustomParam("parentLongNumber");
        QFilter orgfilter = new QFilter("longnumber", "like", (Object)(longNumber + "!%")).or("longnumber", "=", (Object)longNumber).or("longnumber", "in", (Object)EntityServiceHelper.getParentLongNumber((String)longNumber));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, isleaf,longnumber, number", (QFilter[])new QFilter[]{orgfilter});
        FilterOrgStructParam orgParam = new FilterOrgStructParam(this.getModelId(), ((Long)checkParam.getScene().p1).longValue(), (String)checkParam.getYear().p2, ((Long)checkParam.getPeriod().p1).longValue());
        orgParam.setFrom(FilterOrgStructParam.FROM_CHECKELIM);
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)orgParam, (List)doc);
        Set ids = doc.stream().map(e -> e.getLong(entryid)).collect(Collectors.toSet());
        if (ids.isEmpty()) {
            qfs.add(new QFilter(entryid, "=", (Object)-1L));
        } else {
            qfs.add(new QFilter("model", "=", (Object)this.getModelId()));
            if (!"ADJ".equalsIgnoreCase(this.getPageCache().get("processNum"))) {
                qfs.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            }
            qfs.add(new QFilter("isexchangerate", "=", (Object)Boolean.FALSE));
            qfs.add(new QFilter("longnumber", "like", (Object)(longNumber + "!%")));
            qfs.add(new QFilter(entryid, "in", ids));
        }
        return qfs;
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        String selectFields = "id,number,name,membermodel,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)this.getModelId());
        QFilter fliter2 = new QFilter("ISSYSDIMENSION", "=", (Object)false);
        QFilter[] filters = new QFilter[]{fmodelid, fliter2};
        DynamicObjectCollection userDefineDims = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)"dseq asc");
        int userDefineDimNum = 1;
        int width = 100 / (columns.size() - 6 + userDefineDims.size());
        for (IListColumn listColumn : columns) {
            if (listColumn.toString().startsWith("dim")) {
                if (listColumn.toString().startsWith("dim" + userDefineDimNum) && userDefineDimNum <= userDefineDims.size()) {
                    listColumn.setCaption(new LocaleString(((DynamicObject)userDefineDims.get(userDefineDimNum - 1)).getString("name")));
                    ++userDefineDimNum;
                    listColumn.setVisible(1);
                } else {
                    listColumn.setVisible(0);
                }
            }
            if (listColumn.toString().startsWith("mycompany") && !this.isExistDimension(MemberReader.findModelNumberById((Object)this.getModelId()), PresetConstant.MYCOMPANY_DIM)) {
                listColumn.setVisible(0);
            }
            if (listColumn.getListFieldKey().startsWith("audittrial") || listColumn.getListFieldKey().startsWith("audittrail")) {
                if (this.isExistAuditTrailDimension()) {
                    listColumn.setVisible(63);
                } else {
                    listColumn.setVisible(0);
                }
            }
            if (listColumn.getListFieldKey().startsWith("changetype")) {
                if (this.isExistChangeTypeDimension()) {
                    listColumn.setVisible(63);
                } else {
                    listColumn.setVisible(0);
                }
            }
            listColumn.setWidth(new LocaleString(width + "%"));
        }
        args.setListColumns(columns);
        if (!this.isExistDimension(MemberReader.findModelNumberById((Object)this.getModelId()), PresetConstant.MYCOMPANY_DIM)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{entrymycompany});
        }
    }

    public void packageData(PackageDataEvent e) {
        Object value;
        String key;
        super.packageData(e);
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass()) && (StringUtil.equals((String)(key = ((ColumnDesc)e.getSource()).getKey()), (String)"debit") || StringUtil.equals((String)key, (String)"credit")) && (value = e.getRowData().get(key)) instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) != 0) {
            e.setFormatValue(this.formatValue(this.getUserDefineScale(), value));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(map.get("KEY_MODEL_ID")));
        this.initUserDefineDim();
        this.initF7Filters();
        this.refreshEntryEntity();
        this.forbiddenEdit();
        this.validateManualDiffmode();
        this.refreshBillList(this.getPageCache().get("selectPK"));
        this.initEntryColScaleField();
        this.setBtnVisible(this.getModelId());
    }

    private void setBtnVisible(Long modelId) {
        BarItemAp barItemAp = new BarItemAp();
        barItemAp.setKey("btn_submit");
        barItemAp.setId("btn_submit");
        barItemAp.setName(new LocaleString(CheckBalanceProcessPlugin.getSubmit()));
        barItemAp.setOperationStyle(Integer.valueOf(1));
        CheckHelper.initDiffButton(modelId, this.getView(), barItemAp, true, 0);
    }

    private void setTotalDiffAmountTip() {
        DynamicObjectCollection recs = this.getModel().getEntryEntity(entryentity);
        BigDecimal debitValue = BigDecimal.ZERO;
        BigDecimal creditValue = BigDecimal.ZERO;
        for (DynamicObject d : recs) {
            debitValue = debitValue.add(d.getBigDecimal(entrydebelimval));
            creditValue = creditValue.add(d.getBigDecimal(entrycreelimval));
        }
        BigDecimal diff = debitValue.subtract(creditValue);
        DecimalFormat decimalFormat = new DecimalFormat("#,###.###############");
        Label lblTip = (Label)this.getControl("labelap");
        lblTip.setText(decimalFormat.format(diff));
    }

    private void initEntryColScaleField() {
        this.getPageCache().put("checkScale", ConfigServiceHelper.getStringParam((Long)this.getModelId(), (String)"checkScale"));
        Integer scale = this.getUserDefineScale();
        if (scale == null) {
            return;
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (String col : SCALE_COLS) {
            clientViewProxy.invokeControlMethod(entryentity, "setColEditorProp", new Object[]{col, "sz", Boolean.FALSE});
            clientViewProxy.invokeControlMethod(entryentity, "setColEditorProp", new Object[]{col, "sc", scale});
        }
    }

    private Integer getUserDefineScale() {
        String scaleStr = this.getPageCache().get("checkScale");
        if (StringUtils.isNotBlank((CharSequence)scaleStr)) {
            try {
                int scale = Integer.parseInt(kd.bos.util.StringUtils.trim((String)scaleStr));
                if (scale >= 0 & scale <= 10) {
                    return scale;
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u7528\u6237\u81ea\u5b9a\u4e49\u7684\u7cbe\u5ea6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
        return null;
    }

    private Object formatValue(Integer scale, Object value) {
        if (value == null) {
            return value;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#,###.###############");
        if (scale != null) {
            decimalFormat.setMaximumFractionDigits(scale);
            decimalFormat.setMinimumFractionDigits(scale);
            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        }
        return decimalFormat.format(value);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (ArrayUtils.isEmpty((Object[])e.getChangeSet()) || e.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        if (entrydebelimval.equalsIgnoreCase(e.getProperty().getName()) || entrycreelimval.equalsIgnoreCase(e.getProperty().getName())) {
            BigDecimal newValue = new BigDecimal(e.getChangeSet()[0].getNewValue().toString());
            if (newValue.compareTo(BigDecimal.ZERO) == 0) {
                this.setTotalDiffAmountTip();
                return;
            }
            String accountNumber = null;
            DynamicObject dataEntity = e.getChangeSet()[0].getDataEntity();
            if (entrydebelimval.equalsIgnoreCase(e.getProperty().getName())) {
                accountNumber = dataEntity.getString("entrydebitaccout.number");
            } else if (entrycreelimval.equalsIgnoreCase(e.getProperty().getName())) {
                accountNumber = dataEntity.getString("entrycreditaccout.number");
            }
            if (kd.bos.util.StringUtils.isBlank((String)accountNumber)) {
                this.setTotalDiffAmountTip();
                return;
            }
            DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)this.getPKId(), (String)"bcm_checkrecord");
            Long modelId = source.getLong("model.id");
            String sceneNumber = source.getString("scene.number");
            String currencyNumber = source.getString("currency.number");
            Integer scale = CurrencyScaleHandler.getNewCurrencyScale((long)modelId, (String)sceneNumber, (String)currencyNumber, (String)accountNumber);
            BigDecimal dealValue = CurrencyScaleHandler.handleByScaleEnum((BigDecimal)newValue, (Integer)scale);
            DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, e.getChangeSet()[0].getRowIndex());
            rowObj.set(e.getProperty().getName(), (Object)dealValue);
            this.getView().updateView(entryentity);
            this.forbiddenEdit();
            this.setTotalDiffAmountTip();
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, e.getRowIndexs()[0]);
        if (rowObj.getBigDecimal(entrycredit).compareTo(BigDecimal.ZERO) != 0 || rowObj.getBigDecimal(entrydebit).compareTo(BigDecimal.ZERO) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u7684\u5206\u5f55\u4e0d\u80fd\u5220\u9664\u3002", (String)"CheckBalanceProcessPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        super.doCheckPermission("bcm_rptadjust_list", "47150e89000000ac", Long.valueOf(this.getModelId()), this.getBizAppId());
        CheckHelper.openAdjustPage(this.getModelId(), this.getPKId(), (AbstractFormPlugin)this);
    }

    private void refreshBillList(String selectPK) {
        Set<Object> entryIds = new HashSet(16);
        Set<Object> groupNums = new HashSet(16);
        Set checkEntryIds = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,entryentity.id", (QFilter[])new QFilter[]{new QFilter(entryid, "=", (Object)LongUtil.toLong((Object)selectPK))}).stream().map(e -> e.getLong("entryentity.id")).collect(Collectors.toSet());
        DynamicObjectCollection mappings = QueryServiceHelper.query((String)"bcm_linkadjust_mapping", (String)"elim.id,elimentry.groupnum", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("biztype", "=", (Object)LinkAdjustMappingEnum.CHECK_RECORD.getBizType()), new QFilter("linkid", "in", checkEntryIds)});
        if (mappings.size() > 0) {
            Set adjustIds = mappings.stream().map(d -> d.getLong("elim.id")).collect(Collectors.toSet());
            groupNums = mappings.stream().map(d -> d.getString("elimentry.groupnum")).collect(Collectors.toSet());
            List linkIds = QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("linkagelinksource", "in", adjustIds)}, null, (int)-1);
            for (Object linkId : linkIds) {
                adjustIds.add(Long.valueOf(linkId.toString()));
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_rptadjustdata", (String)"id,groupnum", (QFilter[])new QFilter[]{new QFilter("adjust.id", "in", adjustIds)});
            Set<Object> finalGroupNums = groupNums;
            entryIds = dynamicObjects.stream().filter(e -> finalGroupNums.contains(e.getString("groupnum"))).map(e -> e.getLong(entryid)).collect(Collectors.toSet());
        }
        QFilter qFilter = entryIds.size() > 0 ? new QFilter(entryid, "in", entryIds) : new QFilter(entryid, "=", (Object)-1);
        BillList billList = (BillList)this.getControl("linkbilllistap");
        billList.setFilterParameter(new FilterParameter(qFilter, "dseq asc "));
        billList.refreshData();
        billList.refresh();
        billList.clearSelection();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.startsWith("btn_aobo")) {
            Pair<DiffModeEnum, DiffMethodEnum> diffPair = CheckHelper.getDiffPairByBinSign(key);
            this.actionDiffProcess(diffPair);
            return;
        }
        switch (key) {
            case "btn_submit": {
                this.actionSubmit();
                this.refreshBillList(this.getPageCache().get("selectPK"));
                break;
            }
            case "btn_unaudit": {
                this.actionUnAudit();
                break;
            }
            case "btn_lastentry": {
                this.actionLastentry();
                break;
            }
            case "btn_nextentry": {
                this.actionNextentry();
                break;
            }
            case "btn_smartnotice": {
                CheckHelper.openCheckSmartNoticePage(this.getModelId(), Lists.newArrayList((Object[])new Long[]{this.getPKId()}), this.getView(), (IFormPlugin)this);
                break;
            }
        }
    }

    private void actionSubmit() {
        CheckParam checkparam = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
        DynamicObject source = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"id, number, status, diffmode, isautoelim,entity.id,entity.number,entity.name,myentity.name,checktmpl.id,checktmpl.number,checktmpl.name,checktmpl.isenable", (QFilter[])new QFilter[]{new QFilter(entryid, "=", (Object)this.getPKId())});
        if (source != null) {
            if (2 == source.getInt(entrystatus)) {
                this.refreshEntryEntity();
                this.refreshBillList(this.getPageCache().get("selectPK"));
                this.validateManualDiffmode();
                this.forbiddenEdit();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u786e\u8ba4\uff0c\u4e0d\u53ef\u91cd\u590d\u786e\u8ba4\u3002", (String)"CheckBalanceProcessPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckBalanceProcessPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Pair entityPair = Pair.onePair((Object)source.getLong("entity.id"), (Object)source.getString("entity.number"));
        checkparam.setEntity(entityPair);
        checkparam.setCheckTmpl(Pair.onePair((Object)new Long[]{source.getLong("checktmpl.id")}, null));
        boolean isQuoteLocked = MergeControlHelper.isQuoteLocked((Long)((Long)checkparam.getModel().p1), (Long)((Long)checkparam.getScene().p1), (Long)((Long)checkparam.getYear().p1), (Long)((Long)checkparam.getPeriod().p1), (Long)((Long)checkparam.getEntity().p1));
        if (isQuoteLocked) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5982\u4e0b\u8bb0\u5f55\u7684\u5408\u5e76\u8282\u70b9\u5728\u65b0\u60c5\u666f\u4e0b\u672a\u5f00\u542f\u7ec4\u7ec7\u7248\u672c\u5316\uff1a%s", (String)"CheckMainPagePlugin_94", (String)"fi-bcm-formplugin", (Object[])new Object[0]), source.getString("entity.number")));
            return;
        }
        CheckHelper.isExistArchiving(this.getModelId(), (String)checkparam.getScene().p2, (String)checkparam.getYear().p2, (String)checkparam.getPeriod().p2);
        this.checkOrgPeriodOpen(this.getPKId());
        this.checkAllInOneStatus(source.getString("entity.number"), source.getString("entity.name"));
        CheckContext ctx = new CheckContext(checkparam);
        if (!ctx.isAvailable()) {
            CheckResult checkResult = ctx.getCheckResult();
            this.getView().showErrorNotification(checkResult.getMessage());
            return;
        }
        DynamicObjectCollection recs = this.getModel().getEntryEntity(entryentity);
        BigDecimal debitValue = BigDecimal.ZERO;
        BigDecimal creditValue = BigDecimal.ZERO;
        int index = 1;
        int userDefinedCount = ctx.getUserDefineDims().size();
        StringBuilder errorMsg = new StringBuilder();
        for (DynamicObject d : recs) {
            BigDecimal creditValueInput;
            BigDecimal debitValueInput;
            DynamicObject entryDebitAccount = d.getDynamicObject(entrydebitaccout);
            DynamicObject entryCreditAccount = d.getDynamicObject(entrycreditaccout);
            if (d.get(entryorg) == null || d.get(entrycompany) == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u7b2c", (String)"CheckBalanceProcessPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(index).append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u660e\u7ec6\u7ec4\u7ec7\u548c\u5f80\u6765\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"CheckBalanceProcessPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (ctx.isSpptMyCompany() && d.get(entrymycompany) == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u7b2c", (String)"CheckBalanceProcessPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(index).append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u6211\u65b9\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"CheckBalanceProcessPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (this.isExistChangeTypeDimension() && d.get(entrychangetype) == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u7b2c", (String)"CheckBalanceProcessPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(index).append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u53d8\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"CheckBalanceProcessPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (this.isExistAuditTrailDimension() && d.get(entryaudittrail) == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u7b2c", (String)"CheckBalanceProcessPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(index).append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u5ba1\u8ba1\u7ebf\u7d22\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckBalanceProcessPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            for (int i = 1; i <= userDefinedCount; ++i) {
                if (d.get("entrydim" + i) != null) continue;
                errorMsg.append(ResManager.loadKDString((String)"\u7b2c", (String)"CheckBalanceProcessPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(index).append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckBalanceProcessPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            if (entryDebitAccount == null && entryCreditAccount == null || entryDebitAccount != null && entryCreditAccount != null) {
                errorMsg.append(ResManager.loadKDString((String)"\u7b2c", (String)"CheckBalanceProcessPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(index).append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u884c\u5206\u5f55\u501f\u65b9\u79d1\u76ee\u548c\u8d37\u65b9\u79d1\u76ee\u5176\u4e2d\u4e00\u4e2a\u7684\u503c\u3002", (String)"CheckBalanceProcessPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (!this.checkInputValue(debitValueInput = d.getBigDecimal(entrydebelimval), creditValueInput = d.getBigDecimal(entrycreelimval))) {
                errorMsg.append(ResManager.loadKDString((String)"\u6bcf\u884c\u5206\u5f55\u4e2d\u7684\u501f\u65b9\u62b5\u9500\u91d1\u989d\u548c\u8d37\u65b9\u62b5\u9500\u91d1\u989d\uff0c\u53ea\u80fd\u586b\u5199\u5176\u4e2d\u4e00\u4e2a\u7684\u503c\u3002", (String)"CheckBalanceProcessPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)errorMsg.toString())) {
                this.getView().showMessage(errorMsg.toString());
                return;
            }
            debitValue = debitValue.add(debitValueInput);
            creditValue = creditValue.add(creditValueInput);
            ++index;
        }
        if (debitValue.compareTo(creditValue) != 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u62b5\u9500\u501f\u8d37\u603b\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u68c0\u67e5\u91d1\u989d\u3002", (String)"CheckBalanceProcessPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.doSubmit((ICheckContext)ctx);
        this.refreshEntryEntity();
    }

    private boolean checkInputValue(BigDecimal debitValueInput, BigDecimal creditValueInput) {
        return debitValueInput.compareTo(BigDecimal.ZERO) == 0 || creditValueInput.compareTo(BigDecimal.ZERO) == 0;
    }

    private void validateManualDiffmode() {
        Set tmplIdSet;
        CheckParam checkparam = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
        Long currentPKId = this.getPKId();
        DynamicObject dos = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"status, isautoelim, diffmode,createtype,checktmpl.id,checktmpl.isenable,entity.id,entity.number", (QFilter[])new QFilter[]{new QFilter(entryid, "=", (Object)currentPKId)});
        boolean isEnable = false;
        isEnable = "1".equals(dos.getString("isautoelim")) ? kd.bos.util.StringUtils.isNotEmpty((String)dos.getString(entrydiffmode)) : !"2".equals(dos.getString("isautoelim"));
        boolean isEffectiveTmpl = true;
        Set dispensedTmpls = CheckUtil.queryDispensedTmpls((Long)this.getModelId(), (Long)((Long)checkparam.getScene().p1), (Set)Sets.newHashSet((Object[])new Long[]{dos.getLong("checktmpl.id")}), null, (Set)Sets.newHashSet((Object[])new String[]{dos.getString("entity.number")}));
        isEffectiveTmpl = dispensedTmpls.size() > 0 ? !(tmplIdSet = CheckUtil.queryEffectiveTmpls((Long)this.getModelId(), (Long)((Long)checkparam.getYear().p1), (Long)((Long)checkparam.getPeriod().p1), (Set)dispensedTmpls)).isEmpty() : false;
        String[] btns = CheckUtil.diffSettingOrderList.stream().map(e -> "btn_aobo" + e).collect(Collectors.toSet()).toArray(new String[0]);
        String msg = "";
        PermissionService permissionService = PermissionServiceImpl.getInstance((Long)this.getModelId());
        Long entityDimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.ENTITY_DIM);
        if (permissionService.isAllReadPerm(entityDimensionId, "bcm_entitymembertree", (Collection)Sets.newHashSet((Object[])new Long[]{dos.getLong("entity.id")}))) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u8be5\u6761\u6570\u636e\u4ec5\u6709\u53ea\u8bfb\u6743\u9650\u3002", (String)"CheckBalanceProcessPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else if (!dos.getBoolean("checktmpl.isenable")) {
            msg = ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f\u5df2\u88ab\u7981\u7528\u3002", (String)"CheckBalanceProcessPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else if (!isEffectiveTmpl) {
            msg = ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f\u672a\u5206\u914d\u6216\u4e0d\u9002\u7528\u6709\u6548\u671f\u95f4\u3002", (String)"CheckBalanceProcessPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!msg.isEmpty()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_submit", "btn_unaudit", "btn_newentry", "btn_delentry"});
            this.getView().setEnable(Boolean.valueOf(false), btns);
            this.getView().showTipNotification(msg);
            return;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"btn_submit", "btn_unaudit", "btn_newentry", "btn_delentry"});
        this.getView().setEnable(Boolean.valueOf(isEnable), btns);
        if (isEnable) {
            this.getView().setEnable(Boolean.valueOf(dos.getInt(entrystatus) != 2), new String[]{"btn_submit", "btn_newentry", "btn_delentry"});
            this.getView().setEnable(Boolean.valueOf(dos.getInt(entrystatus) != 2), btns);
            this.getView().setEnable(Boolean.valueOf(dos.getInt(entrystatus) == 2), new String[]{"btn_unaudit"});
        }
    }

    private void forbiddenEdit() {
        int i;
        Long currentPKId = this.getPKId();
        DynamicObject dos = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"diffmode, status,createtype", (QFilter[])new QFilter[]{new QFilter(entryid, "=", (Object)currentPKId)});
        int rows = this.getModel().getEntryRowCount(entryentity);
        ArrayList list = new ArrayList(10);
        ArrayList<Integer> list_audit = new ArrayList<Integer>(10);
        ArrayList<Integer> list_unaudit = new ArrayList<Integer>(10);
        if (kd.bos.util.StringUtils.isEmpty((String)dos.getString(entrydiffmode)) || Integer.parseInt((String)dos.get(entrystatus)) == 2) {
            for (i = 0; i < rows; ++i) {
                list_audit.add(i);
            }
            list = list_audit;
        } else {
            for (i = 0; i < rows; ++i) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, i);
                if (rowObj.getBigDecimal(entrycredit).compareTo(BigDecimal.ZERO) == 0 && rowObj.getBigDecimal(entrydebit).compareTo(BigDecimal.ZERO) == 0 && rowObj.getLong(checktmplentry) == 0L) continue;
                list_unaudit.add(i);
            }
            list = list_unaudit;
        }
        for (i = 0; i < list.size(); ++i) {
            for (String column : this.allColumns) {
                if (!column.equals(entrydebelimval) && !column.equals(entrycreelimval)) {
                    this.getView().setEnable(Boolean.valueOf(false), ((Integer)list.get(i)).intValue(), new String[]{column});
                    continue;
                }
                if (kd.bos.util.StringUtils.isEmpty((String)dos.getString(entrydiffmode)) || Integer.parseInt((String)dos.get(entrydiffmode)) != 3 || Integer.parseInt((String)dos.get(entrystatus)) == 2) {
                    this.getView().setEnable(Boolean.valueOf(false), ((Integer)list.get(i)).intValue(), new String[]{column});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(true), ((Integer)list.get(i)).intValue(), new String[]{column});
            }
        }
    }

    private void actionLastentry() {
        this.changePKId(0);
        this.refreshEntryEntity();
        this.validateManualDiffmode();
        this.forbiddenEdit();
    }

    private void actionNextentry() {
        this.changePKId(1);
        this.refreshEntryEntity();
        this.validateManualDiffmode();
        this.forbiddenEdit();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int entryRowCount = this.getModel().getEntryRowCount(entryentity);
        IDataModel model = this.getModel();
        model.setValue(entrynum, (Object)this.getPageCache().get("add_num"), entryRowCount - 1);
        if (entryRowCount >= 2) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(entryentity);
            DynamicObject entry = (DynamicObject)entrys.get(entryRowCount - 2);
            Long elimAudittrailId = 0L;
            Long elimAccountId = 0L;
            boolean isDc = false;
            DynamicObject record = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"id,checktmpl.id", (QFilter[])new QFilter[]{new QFilter(entryid, "=", (Object)this.getPKId())});
            if (record == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckBalanceProcessPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)record.getLong("checktmpl.id"), (String)"bcm_checktmpl");
            DynamicObjectCollection entries = template.getDynamicObjectCollection(entryentity);
            Optional<DynamicObject> diffitem = entries.stream().filter(tmplEntry -> tmplEntry.getBoolean("diffitem")).findFirst();
            if (diffitem.isPresent()) {
                Optional<DynamicObject> elimAccount;
                DynamicObjectCollection elimdetailscope = diffitem.get().getDynamicObjectCollection("elimdetailscope");
                Optional<DynamicObject> elimaudittrail = elimdetailscope.stream().filter(p -> "elimaudittrail".equals(p.getString("elimsign"))).findFirst();
                if (elimaudittrail.isPresent()) {
                    elimAudittrailId = elimaudittrail.get().getLong("elimmemberid");
                }
                if ((elimAccount = elimdetailscope.stream().filter(p -> "elimaccounttree".equals(p.getString("elimsign"))).findFirst()).isPresent()) {
                    boolean isaccountoffset;
                    IDNumberTreeNode acct = MemberReader.findMemberById((long)this.getModelId(), (String)DimEntityNumEnum.getEntieyNumByNumber((String)PresetConstant.ACCOUNT_DIM), (Long)elimAccount.get().getLong("elimmemberid"));
                    if (acct != IDNumberTreeNode.NotFoundTreeNode) {
                        acct = acct.getBaseTreeNode();
                    }
                    boolean bl = isaccountoffset = acct.getProperty("accountpart.isaccountoffset") == null ? false : (Boolean)acct.getProperty("accountpart.isaccountoffset");
                    if (acct.isLeaf() && isaccountoffset) {
                        elimAccountId = acct.getId();
                        isDc = DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.getOIndex().equals(acct.getProperty("drcrdirect"));
                    }
                }
            }
            for (String colname : this.allColumns) {
                if (entryaudittrail.equals(colname)) {
                    model.setValue(colname, (Object)elimAudittrailId, entryRowCount - 1);
                } else if (entrydebitaccout.equals(colname)) {
                    if (!isDc) {
                        model.setValue(colname, (Object)elimAccountId, entryRowCount - 1);
                    }
                } else if (entrycreditaccout.equals(colname)) {
                    if (isDc) {
                        model.setValue(colname, (Object)elimAccountId, entryRowCount - 1);
                    }
                } else {
                    Object value = entry.get(colname);
                    if (value instanceof DynamicObject) {
                        model.setValue(colname, ((DynamicObject)value).get(entryid), entryRowCount - 1);
                    }
                }
                if (!colname.equals(entrynum) && !colname.equals(entrytmpl)) continue;
                this.getView().setEnable(Boolean.valueOf(false), entryRowCount - 1, new String[]{colname});
            }
        }
        this.setTotalDiffAmountTip();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.setTotalDiffAmountTip();
    }

    private void doSubmit(ICheckContext ctx) {
        Long pk = this.getPKId();
        DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bcm_checkrecord");
        boolean isLock = false;
        try (TXHandle tx = TX.required();){
            try {
                DynamicObjectCollection rows = this.getModel().getEntryEntity(entryentity);
                DynamicObject newObj = CheckRecordHelper.toCheckDynamicObject((DynamicObject)source, (DynamicObjectCollection)rows);
                if (this.checkIfBuildEliminationEntry()) {
                    DynamicObject elimDynaObj = CheckRecordHelper.buildElimDynamicObject((ICheckContext)ctx, (DynamicObject)newObj);
                    DynamicObjectCollection elimDataDynaObj = CheckRecordHelper.buildElimDataDynamicObject((DynamicObject)newObj, (DynamicObject)elimDynaObj, (EntrySourceEnum)EntrySourceEnum.CHECKAUTOCREATE, (ICheckContext)ctx);
                    CheckRecordHelper.resetAdjustBalance((Long)((Long)ctx.getModel().p1), (Collection)Lists.newArrayList((Object[])new DynamicObject[]{elimDynaObj}), (Collection)elimDataDynaObj);
                    if (!elimDataDynaObj.isEmpty()) {
                        ArrayList<Long> elimDynaPks = new ArrayList<Long>(10);
                        elimDynaPks.add(elimDynaObj.getLong(entryid));
                        SaveServiceHelper.save((IDataEntityType)elimDynaObj.getDynamicObjectType(), (Object[])new Object[]{elimDynaObj});
                        SaveServiceHelper.save((IDataEntityType)elimDataDynaObj.getDynamicObjectType(), (Object[])elimDataDynaObj.toArray(new Object[0]));
                        CheckRecordHelper.saveAdjustMapping((List)elimDataDynaObj);
                        if (source.getInt("checktmpl.islinkage") == 1) {
                            LinkageMappingService.newObject((DynamicObject)elimDynaObj, (EntrySourceEnum)EntrySourceEnum.CHECKLINKAGECREATE).buildAutoElimLinkage();
                            List linkIds = QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])new QFilter("linkagelinksource", "in", elimDynaPks).toArray(), null, (int)-1);
                            for (Object linkId : linkIds) {
                                elimDynaPks.add(Long.valueOf(linkId.toString()));
                            }
                        }
                        HashSet pairLockList = new HashSet(16);
                        HashBasedTable adjustDataLock = AdjustOperationHelper.batchCheckOlapDataLockByIds((String)"CheckService.doSubmit", (AbstractContext)new AdjustOperationContext(((Long)ctx.getModel().p1).longValue(), ((Long)ctx.getCheckParam().getScene().p1).longValue(), ((Long)ctx.getCheckParam().getYear().p1).longValue(), ((Long)ctx.getCheckParam().getPeriod().p1).longValue()), elimDynaPks, pair -> {
                            pairLockList.addAll((Collection)pair.p2);
                            return "";
                        });
                        if (!adjustDataLock.isEmpty()) {
                            isLock = true;
                            newObj.set("isautoelim", (Object)"1");
                            newObj.set(entrystatus, (Object)1);
                            BusinessDataWriter.delete((String)"bcm_linkadjust_mapping", (QFilter[])new QFilter[]{new QFilter("elim.id", "in", elimDynaPks)});
                            BusinessDataWriter.delete((String)"bcm_rptadjustdata", (QFilter[])new QFilter[]{new QFilter("adjust.id", "in", elimDynaPks)});
                            BusinessDataWriter.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust").getDynamicObjectType(), (Object[])elimDynaPks.toArray());
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u5206\u5f55\u6570\u636e\u5b58\u5728\u5982\u4e0b\u5206\u9636\u6bb5\u9501\u5b9a\uff0c\u751f\u6210\u5206\u5f55\u5931\u8d25\uff1a%s\u3002", (String)"CheckBalanceProcessPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", pairLockList.stream().map(p -> String.format("%s(%s)", p.p1, p.p2)).collect(Collectors.toSet()))));
                        } else {
                            HashMap<String, HashSet> adjGroupNums = new HashMap<String, HashSet>(16);
                            adjGroupNums.put(elimDynaObj.getString(NUMBER), Sets.newHashSet((Object[])new String[]{newObj.getString(NUMBER)}));
                            AdjustCheckServiceHelper.doSysToMddWithTraceLog((String)ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02\u5904\u7406-\u786e\u8ba4", (String)"CheckBalanceProcessPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), adjGroupNums, (long)((Long)ctx.getModel().p1), (long)((Long)ctx.getCheckParam().getScene().p1), (long)((Long)ctx.getCheckParam().getYear().p1), (long)((Long)ctx.getCheckParam().getPeriod().p1), elimDynaPks, (boolean)true);
                            newObj.set("adjustnumber", (Object)elimDynaObj.getString(NUMBER));
                        }
                    }
                }
                DeleteServiceHelper.delete((IDataEntityType)source.getDataEntityType(), (Object[])new Object[]{pk});
                SaveServiceHelper.save((IDataEntityType)source.getDataEntityType(), (Object[])new Object[]{newObj});
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.DOSUBMIT.getMultiLangEnumBridge(), (String)OpItemEnum.DOSUBMIT.getCode()), new OPDescMultiLangEnumBridge("\u5bf9\u8d26\u8bb0\u5f55%1$s\u5dee\u5f02\u5904\u7406\u786e\u8ba4%2$s", "CheckBalanceProcessPlugin_38", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{newObj.getString(NUMBER), ResultStatusEnum.SUCCESS.getName()})));
            }
            catch (Exception e) {
                tx.markRollback();
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.DOSUBMIT.getMultiLangEnumBridge(), (String)OpItemEnum.DOSUBMIT.getCode()), new OPDescMultiLangEnumBridge("\u5bf9\u8d26\u8bb0\u5f55%1$s\u5dee\u5f02\u5904\u7406\u786e\u8ba4%2$s", "CheckBalanceProcessPlugin_38", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{source.getString(NUMBER), ResultStatusEnum.FAIL.getName()})));
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
        if (!isLock) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u786e\u8ba4\u6210\u529f\u3002", (String)"CheckBalanceProcessPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.validateManualDiffmode();
        this.forbiddenEdit();
    }

    private boolean checkIfBuildEliminationEntry() {
        DynamicObjectCollection recs = this.getModel().getEntryEntity(entryentity);
        int entryCount = 0;
        for (DynamicObject entry : recs) {
            BigDecimal debitValueInput = entry.getBigDecimal(entrydebelimval);
            BigDecimal creditValueInput = entry.getBigDecimal(entrycreelimval);
            if (debitValueInput.compareTo(BigDecimal.ZERO) == 0 && creditValueInput.compareTo(BigDecimal.ZERO) == 0) continue;
            ++entryCount;
        }
        return entryCount > 0;
    }

    private void actionUnAudit() {
        Long pkid = this.getPKId();
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"id, number, status, isautoelim,diffmode,entity.id,entity.number,entity.name", (QFilter[])new QFilter[]{new QFilter(entryid, "=", (Object)pkid)});
        StringBuilder msg = new StringBuilder();
        if (dyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckBalanceProcessPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u53cd\u786e\u8ba4", "CheckMainPagePlugin_31", "fi-bcm-formplugin", "unConfirm");
        CheckParam checkparam = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
        String logPrefix = String.join((CharSequence)" ", (CharSequence)checkparam.getScene().p2, (CharSequence)checkparam.getYear().p2, (CharSequence)checkparam.getPeriod().p2);
        if (dyn.getInt(entrystatus) == 2 && !"2".equals(dyn.getString("isautoelim"))) {
            String infoStr;
            CheckHelper.isExistArchiving(this.getModelId(), (String)checkparam.getScene().p2, (String)checkparam.getYear().p2, (String)checkparam.getPeriod().p2);
            this.checkOrgPeriodOpen(pkid);
            this.checkAllInOneStatus(dyn.getString("entity.number"), dyn.getString("entity.name"));
            boolean isQuoteLocked = MergeControlHelper.isQuoteLocked((Long)((Long)checkparam.getModel().p1), (Long)((Long)checkparam.getScene().p1), (Long)((Long)checkparam.getYear().p1), (Long)((Long)checkparam.getPeriod().p1), (Long)dyn.getLong("entity.id"));
            if (isQuoteLocked) {
                String infoStr2 = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5982\u4e0b\u8bb0\u5f55\u7684\u5408\u5e76\u8282\u70b9\u5728\u65b0\u60c5\u666f\u4e0b\u672a\u5f00\u542f\u7ec4\u7ec7\u7248\u672c\u5316\uff1a%s", (String)"CheckMainPagePlugin_94", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn.getString("entity.number"));
                this.getView().showTipNotification(infoStr2);
                this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("%1$s \u64cd\u4f5c\u5931\u8d25\uff0c\u5982\u4e0b\u8bb0\u5f55\u7684\u5408\u5e76\u8282\u70b9\u5728\u65b0\u60c5\u666f\u4e0b\u672a\u5f00\u542f\u7ec4\u7ec7\u7248\u672c\u5316\uff1a%2$s", "CheckMainPagePlugin_log_94", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{logPrefix, dyn.getString("entity.number")})));
                return;
            }
            Map unAuditBatch = CheckUtil.unAuditBatch((List)Lists.newArrayList((Object[])new Long[]{pkid}), (String)this.getModel().getDataEntityType().getName(), (CheckParam)checkparam);
            if (unAuditBatch.containsKey("adjuststagelock")) {
                infoStr = String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u9636\u6bb5\u5df2\u9501\u5b9a\uff0c\u5206\u5f55\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u5bf9\u5e94\u7684\u5bf9\u8d26\u8bb0\u5f55\u53cd\u786e\u8ba4\u5931\u8d25\uff1a%s\u3002", (String)"CheckBalanceProcessPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((Pair)unAuditBatch.get((Object)"adjuststagelock")).p2);
                msg.append(infoStr).append("\n");
                this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("%1$s \u5982\u4e0b\u9636\u6bb5\u5df2\u9501\u5b9a\uff0c\u5206\u5f55\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u5bf9\u5e94\u7684\u5bf9\u8d26\u8bb0\u5f55\u53cd\u786e\u8ba4\u5931\u8d25\uff1a%2$s\u3002", "CheckBalanceProcessPlugin_log_34", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{logPrefix, (String)((Pair)unAuditBatch.get((Object)"adjuststagelock")).p2})));
            }
            if (unAuditBatch.containsKey("adjustsharelock")) {
                infoStr = String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u5206\u5f55\u6570\u636e\u5b58\u5728\u5171\u4eab\u5206\u5f55\uff0c\u5bf9\u5e94\u7684\u5bf9\u8d26\u8bb0\u5f55\u53cd\u786e\u8ba4\u5931\u8d25\uff1a%s\u3002", (String)"CheckBalanceProcessPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((Pair)unAuditBatch.get((Object)"adjustsharelock")).p2);
                msg.append(infoStr).append("\n");
                this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("%1$s \u5982\u4e0b\u5206\u5f55\u6570\u636e\u5b58\u5728\u5171\u4eab\u5206\u5f55\uff0c\u5bf9\u5e94\u7684\u5bf9\u8d26\u8bb0\u5f55\u53cd\u786e\u8ba4\u5931\u8d25\uff1a%2$s\u3002", "CheckBalanceProcessPlugin_log_35", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{logPrefix, (String)((Pair)unAuditBatch.get((Object)"adjustsharelock")).p2})));
            }
            if (unAuditBatch.containsKey("adjustunautolock")) {
                infoStr = String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u5206\u5f55\u6570\u636e\u5df2\u88ab\u624b\u5de5\u4fee\u6539\uff0c\u5bf9\u5e94\u7684\u5bf9\u8d26\u8bb0\u5f55\u53cd\u786e\u8ba4\u5931\u8d25\uff1a%s\u3002", (String)"CheckBalanceProcessPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((Pair)unAuditBatch.get((Object)"adjustunautolock")).p2);
                msg.append(infoStr).append("\n");
                this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("%1$s \u5982\u4e0b\u5206\u5f55\u6570\u636e\u5df2\u88ab\u624b\u5de5\u4fee\u6539\uff0c\u5bf9\u5e94\u7684\u5bf9\u8d26\u8bb0\u5f55\u53cd\u786e\u8ba4\u5931\u8d25\uff1a%2$s\u3002", "CheckBalanceProcessPlugin_log_36", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{logPrefix, (String)((Pair)unAuditBatch.get((Object)"adjustunautolock")).p2})));
            }
            this.refreshEntryEntity();
        } else if ("2".equals(dyn.getString("isautoelim"))) {
            String infoStr = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u5bf9\u8d26\u8bb0\u5f55\u4e3a\u6c47\u603b\u62a5\u544a\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"CheckBalanceProcessPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn.getString(NUMBER));
            msg.append(infoStr);
            this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("\u7f16\u53f7\u4e3a%s\u7684\u5bf9\u8d26\u8bb0\u5f55\u4e3a\u6c47\u603b\u62a5\u544a\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", "CheckBalanceProcessPlugin_20", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dyn.getString(NUMBER)})));
        } else if (dyn.getInt(entrystatus) == 1) {
            String infoStr = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u5bf9\u8d26\u8bb0\u5f55\u72b6\u6001\u4e3a\u672a\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"CheckBalanceProcessPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn.getString(NUMBER));
            msg.append(infoStr);
            this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("\u7f16\u53f7\u4e3a%s\u7684\u5bf9\u8d26\u8bb0\u5f55\u72b6\u6001\u4e3a\u672a\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", "CheckBalanceProcessPlugin_21", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dyn.getString(NUMBER)})));
        }
        if (msg.length() > 0) {
            this.getView().showMessage("", msg.toString(), MessageTypes.Default);
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{entryentity});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u6210\u529f\u3002", (String)"CheckBalanceProcessPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("\u53cd\u786e\u8ba4\u6210\u529f\u3002", "CheckBalanceProcessPlugin_22", "fi-bcm-formplugin", null));
        }
        this.validateManualDiffmode();
        this.forbiddenEdit();
        this.refreshBillList(pkid.toString());
    }

    private void checkOrgPeriodOpen(Long checkId) {
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
        if (periodManage) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            DynamicObject entityDy = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"entity.number", (QFilter[])new QFilter[]{new QFilter(entryid, "=", (Object)checkId)});
            long model = Long.parseLong(customParams.get("KEY_MODEL_ID").toString());
            long scenario = Long.parseLong(customParams.get("KEY_SCENARIO_ID").toString());
            long year = Long.parseLong(customParams.get(KEY_YEAR_ID).toString());
            long period = Long.parseLong(customParams.get(KEY_PERIOD_ID).toString());
            Pair periodStatusPair = PeriodSettingHelper.batchSelectPeriodStatusOpenbyUntreated((long)model, (String)entityDy.getString("entity.number"), (long)scenario, (long)year, (long)period);
            if (!((Boolean)periodStatusPair.p1).booleanValue()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7 %s \u6ca1\u6709\u5f00\u542f\u6570\u636e\u671f\u95f4\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CheckBalanceProcessPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entityDy.getString("entity.number")));
            }
            if (!((Boolean)periodStatusPair.p2).booleanValue()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7 %s \u6ca1\u6709\u5f00\u542f\u8c03\u6574\u5206\u5f55\u671f\u95f4\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CheckBalanceProcessPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entityDy.getString("entity.number")));
            }
        }
    }

    private void changePKId(int step) {
        Object[] rows = ((JSONArray)this.getFormCustomParam("rows")).toArray();
        String currentpk = this.getPageCache().get("selectPK");
        int flag = 0;
        int index = 0;
        for (Object row : rows) {
            if (currentpk.equals(row.toString())) {
                index = flag;
                break;
            }
            ++flag;
        }
        String selectPk = null;
        if (step == 0) {
            if (index == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5230\u7b2c\u4e00\u6761\u5bf9\u8d26\u8bb0\u5f55\u3002", (String)"CheckBalanceProcessPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            selectPk = rows[index - 1].toString();
            this.getPageCache().put("selectPK", selectPk);
        } else if (step == 1) {
            if (index == rows.length - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5230\u6700\u540e\u4e00\u6761\u5bf9\u8d26\u8bb0\u5f55\u3002", (String)"CheckBalanceProcessPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            selectPk = rows[index + 1].toString();
            this.getPageCache().put("selectPK", selectPk);
        }
        this.refreshBillList(selectPk);
    }

    private Long getPKId() {
        if (this.getPageCache().get("selectPK") == null) {
            Object[] rows = ((JSONArray)this.getFormCustomParam("rows")).toArray();
            this.getPageCache().put("selectPK", rows[0].toString());
        }
        return Long.valueOf(this.getPageCache().get("selectPK"));
    }

    private void initUserDefineDim() {
        Long modelId = this.getModelId();
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, name, fieldmapped", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).add("issysdimension", "=", (Object)false).toArray(), (String)"dseq");
        for (String field : CheckConstant.PRESET_DIMFIELDS) {
            BasedataEdit dataEdit = (BasedataEdit)this.getControl("entry" + field);
            dataEdit.setVisible(null, false);
        }
        ArrayList userDefines = new ArrayList(dims.size());
        for (DynamicObject dim : dims) {
            HashMap<String, Object> dimMap = new HashMap<String, Object>(16);
            BasedataEdit dataEdit = (BasedataEdit)this.getControl("entry" + dim.getString("fieldmapped"));
            dataEdit.setVisible(null, true);
            EntryGrid grid = (EntryGrid)this.getControl(entryentity);
            grid.setColumnProperty("entry" + dim.getString("fieldmapped"), "header", (Object)new LocaleString(dim.getString("name")));
            dimMap.put(entryid, dim.getLong(entryid));
            dimMap.put("dimNum", "entry" + dim.getString("fieldmapped"));
            userDefines.add(dimMap);
        }
        this.getPageCache().put("userDefines", SerializationUtils.toJsonString(userDefines));
    }

    private void initF7Filters() {
        long modelid = this.getModelId();
        if (modelid == 0L) {
            return;
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        BasedataEdit baseDataF7Tmpl = (BasedataEdit)this.getControl(entrytmpl);
        baseDataF7Tmpl.setQFilter(modelFilter);
        List list = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("userDefines"), List.class);
        if (list.size() > 0) {
            for (Map map : list) {
                BasedataEdit dimF7 = (BasedataEdit)this.getControl(map.get("dimNum").toString());
                QFilter dimFilter = new QFilter("dimension", "=", map.get(entryid));
                ArrayList<QFilter> dimfilterList = new ArrayList<QFilter>(2);
                dimfilterList.add(modelFilter);
                dimfilterList.add(dimFilter);
                dimfilterList.add(new QFilter("storagetype", "in", (Object)StorageTypeEnum.getRealStorageEnumIndexs()));
                dimfilterList.add(new QFilter("isleaf", "=", (Object)true));
                dimF7.setQFilters(dimfilterList);
            }
        }
    }

    @Override
    public <T> T getFormCustomParam(String key) {
        return (T)this.getView().getFormShowParameter().getCustomParam(key);
    }

    private void refreshEntryEntity() {
        Long currentPk = this.getPKId();
        DynamicObject rec = BusinessDataServiceHelper.loadSingle((Object)currentPk, (String)"bcm_checkrecord", (String)this.getSelector());
        this.getPageCache().put("processNum", rec.getString("process.number"));
        this.getPageCache().put("parentLongNumber", rec.getString("entity.longnumber"));
        this.getModel().deleteEntryData(entryentity);
        this.getModel().beginInit();
        int row = 0;
        DynamicObjectCollection doc = rec.getDynamicObjectCollection(entryentity);
        doc.sort(Comparator.comparing(e -> e.getInt("seq")));
        this.getModel().batchCreateNewEntryRow(entryentity, doc.size());
        for (DynamicObject dynaObj : doc) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, row++);
            String[] stringArray = this.allColumns;
            int n = stringArray.length;
            block13: for (int i = 0; i < n; ++i) {
                String column;
                switch (column = stringArray[i]) {
                    case "entrynum": {
                        rowObj.set(column, rec.get(NUMBER));
                        continue block13;
                    }
                    case "entrytmpl": {
                        rowObj.set(column, rec.get("checktmpl"));
                        continue block13;
                    }
                    case "status": {
                        rowObj.set(column, rec.get(entrystatus));
                        continue block13;
                    }
                    case "diffmode": {
                        rowObj.set(column, rec.get(entrydiffmode));
                        continue block13;
                    }
                    default: {
                        rowObj.set(column, dynaObj.get(column));
                    }
                }
            }
        }
        this.getPageCache().put("add_num", rec.getString(NUMBER));
        this.getPageCache().put("add_tmpl", ObjectSerialUtil.toByteSerialized((Object)rec.get("checktmpl")));
        this.getModel().endInit();
        this.getView().updateView(entryentity);
        this.setTotalDiffAmountTip();
    }

    private String getSelector() {
        ArrayList<String> selector = new ArrayList<String>(25);
        selector.add(NUMBER);
        selector.add("entity.longnumber");
        selector.add("elimtype");
        selector.add("process");
        selector.add(entrystatus);
        selector.add("checktmpl");
        selector.add(entrydiffmode);
        selector.add("entryentity.entryid");
        selector.add("entryentity.entryorg");
        selector.add("entryentity.entrymycompany");
        selector.add("entryentity.entrycompany");
        selector.add("entryentity.entrydebitaccout");
        selector.add("entryentity.entrycreditaccout");
        selector.add("entryentity.entrychangetype");
        selector.add("entryentity.entryaudittrail");
        selector.add("entryentity.entrydim1");
        selector.add("entryentity.entrydim2");
        selector.add("entryentity.entrydim3");
        selector.add("entryentity.entrydim4");
        selector.add("entryentity.entrydim5");
        selector.add("entryentity.entrydim6");
        selector.add("entryentity.entrydebit");
        selector.add("entryentity.entrycredit");
        selector.add("entryentity.dc");
        selector.add("entryentity.entrydebelimval");
        selector.add("entryentity.entrycreelimval");
        selector.add("entryentity.entryprocess");
        selector.add("entryentity.checktmplentry");
        selector.add("entryentity.seq");
        return String.join((CharSequence)",", selector);
    }

    private void actionDiffProcess(Pair<DiffModeEnum, DiffMethodEnum> diffPair) {
        Long rows = this.getPKId();
        if (rows != null && rows != 0L) {
            DynamicObject doc = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"id,checktmpl.id, entity.id, entity.number,entity.name, number, status, diffmode, isautoelim,createtype", (QFilter[])new QFilter[]{new QFilter(entryid, "=", (Object)rows)});
            if (doc == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckBalanceProcessPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            CheckParam param = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
            CheckHelper.isExistArchiving(this.getModelId(), (String)param.getScene().p2, (String)param.getYear().p2, (String)param.getPeriod().p2);
            this.checkOrgPeriodOpen(rows);
            this.checkAllInOneStatus(doc.getString("entity.number"), doc.getString("entity.name"));
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5dee\u5f02\u5904\u7406", "CheckMainPagePlugin_99", "fi-bcm-formplugin", "differenceDisposal");
            String diffName = CheckUtil.getDiffPairName(diffPair);
            HashMultimap mulMap = HashMultimap.create();
            if (doc.getInt(entrystatus) == 1) {
                mulMap.put((Object)Pair.onePair((Object)doc.getLong("entity.id"), (Object)doc.getString("entity.number")), (Object)doc.getLong(entryid));
            }
            StringBuilder msg = new StringBuilder();
            HashMap result = new HashMap(16);
            ArrayList<String> quoteLocked = new ArrayList<String>(16);
            mulMap.asMap().forEach((entityPair, ids) -> {
                if (!ids.isEmpty()) {
                    CheckParam checkParam = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
                    checkParam.setEntity(entityPair);
                    checkParam.setCheckTmpl(Pair.onePair((Object)new Long[]{doc.getLong("checktmpl.id")}, null));
                    checkParam.put("checkRecordIds", (Object)Sets.newHashSet((Iterable)ids));
                    checkParam.put("actionDiffFlag", (Object)true);
                    checkParam.setIsAutoElim("0");
                    CheckResult checkResult = CheckServiceHelper.check((CheckContext)new CheckContext(checkParam), (Pair)diffPair);
                    if (checkResult == null) {
                        return;
                    }
                    if ("fail".equals(checkResult.getErrorCode())) {
                        msg.append(checkResult.getMessage());
                        msg.append("\n");
                        return;
                    }
                    if (checkResult.getData() instanceof Map) {
                        result.putAll((Map)checkResult.getData());
                    }
                }
            });
            for (Map.Entry entry : result.entrySet()) {
                Set flag;
                String entity = (String)entry.getKey();
                if ("lockAdjustInfo".equals(entity)) {
                    flag = (Set)entry.getValue();
                    String notification = flag.size() <= 10 ? Joiner.on((String)",").join((Iterable)flag) : Joiner.on((String)",").join(new ArrayList(flag).subList(0, 10)) + "......";
                    String infos = String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u9636\u6bb5\u5df2\u9501\u5b9a\uff0c\u5206\u5f55\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u6216\u751f\u6210\uff1a%s", (String)"CheckHelper_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]), notification);
                    msg.append(infos).append("\n");
                    continue;
                }
                flag = (Set)entry.getValue();
                if (flag.isEmpty() || !flag.stream().anyMatch(e -> e.intValue() == -4)) continue;
                quoteLocked.add(entity);
            }
            if (!quoteLocked.isEmpty()) {
                String notification = quoteLocked.size() <= 5 ? Joiner.on((String)",").join(quoteLocked) : Joiner.on((String)",").join(quoteLocked.subList(0, 5)) + "......";
                msg.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5982\u4e0b\u8bb0\u5f55\u7684\u5408\u5e76\u8282\u70b9\u5728\u65b0\u60c5\u666f\u4e0b\u672a\u5f00\u542f\u7ec4\u7ec7\u7248\u672c\u5316\uff1a%s", (String)"CheckMainPagePlugin_94", (String)"fi-bcm-formplugin", (Object[])new Object[0]), notification)).append("\n");
            }
            if (msg.length() > 0) {
                if (diffPair != null) {
                    this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("\u5bf9\u8d26\u8bb0\u5f55%1$s %2$s %3$s", "CheckMainPagePlugin_100", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{doc.getString(NUMBER), diffName, ResultStatusEnum.FAIL.getName()})));
                }
                this.getView().showTipNotification(msg.toString());
            } else {
                if (diffPair != null) {
                    this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("\u5bf9\u8d26\u8bb0\u5f55%1$s %2$s %3$s", "CheckMainPagePlugin_100", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{doc.getString(NUMBER), diffName, ResultStatusEnum.SUCCESS.getName()})));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5dee\u5f02\u5904\u7406\u5b8c\u6210\u3002", (String)"CheckBalanceProcessPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.refreshBillList(doc.getString(entryid));
            this.refreshEntryEntity();
            this.validateManualDiffmode();
            this.forbiddenEdit();
        }
    }

    private void checkAllInOneStatus(String orgNUm, String orgName) {
        Long period;
        Long year;
        Long scenario;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long model = Long.valueOf(customParams.get("KEY_MODEL_ID").toString());
        if (AllInOneUtils.isSubmitted((Long)model, (String)orgNUm, (Long)(scenario = Long.valueOf(customParams.get("KEY_SCENARIO_ID").toString())), (Long)(year = Long.valueOf(customParams.get(KEY_YEAR_ID).toString())), (Long)(period = Long.valueOf(customParams.get(KEY_PERIOD_ID).toString())))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9 %1$s %2$S \u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u72b6\u6001\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5bf9\u8d26\u5206\u5f55\u6570\u636e\u3002", (String)"CheckMainPagePlugin_80", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNUm, orgName));
        }
    }
}

