/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.check.CheckDetailHelper;
import kd.fi.bcm.formplugin.check.CheckHelper;
import kd.fi.bcm.formplugin.check.GroupData;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class CheckDetailExport {
    public static final int FONT_SIZE = 9;
    public static final int PAGE_SIZE = 1000;
    public static final String ORDER_BY = "checktmpl.number asc,entity.longnumber asc,myentity.number asc,oppositeentity.number asc";
    private SXSSFWorkbook wb = new SXSSFWorkbook(50000);
    private Font font = null;
    private SXSSFSheet sheet = null;
    private UserObject userObject = new UserObject();
    private Long modelId;
    private List<Long> ids;
    private String createType;
    private String showStyle;
    private Integer userScale;
    private XSSFCellStyle headStyle = null;
    private XSSFCellStyle[] textStyle = null;
    private XSSFCellStyle[] markStyle = null;
    private XSSFCellStyle[] numStyle = null;
    private XSSFCellStyle[] subtotalStyle = null;
    private XSSFCellStyle[] totalStyle = null;
    private Short dataFormate = null;
    private Integer allRecord = 0;
    private AtomicInteger completeRecod = new AtomicInteger(0);
    private XSSFColor borderColor = null;
    private Consumer<Integer> taskCallbackConsumer;
    private static final List<String> sumCol = Arrays.asList("entryecmoney", "entrycvtmoney", "entrydebit", "entrycredit", "entryelimmoney", "entrydebelimval", "entrycreelimval");
    private static final Set<String> twoPointCol = Sets.newHashSet((Object[])new String[]{"entryecmoney", "entrycvtmoney", "entrydebit", "entrycredit", "entryelimmoney", "entrydebelimval", "entrycreelimval", "my_entryecmoney", "my_entrycvtmoney", "my_entrydebit", "my_entrycredit", "my_entryelimmoney", "my_entrydebelimval", "my_entrycreelimval", "op_entryecmoney", "op_entrycvtmoney", "op_entrydebit", "op_entrycredit", "op_entryelimmoney", "op_entrydebelimval", "op_entrycreelimval", "cvtdifmoney", "entryocmoney", "my_entryocmoney", "op_entryocmoney", "ocdiffmoney"});
    public static final Set<String> MY_OP = Sets.newHashSet((Object[])new String[]{"checktmpl", "entity", "myentity", "oppositeentity", "cvtdifmoney", "adjustnumber", "diffmode", "diffmethod", "status", "isautoelim", "modifier", "modifytime", "mark"});
    public static final Set<String> MULTI_ROW = Sets.newHashSet((Object[])new String[]{"checktmpl", "entity", "cvtdifmoney", "adjustnumber", "diffmode", "diffmethod", "status", "isautoelim", "modifier", "modifytime", "mark"});
    public static final Set<String> HEADER_1 = Sets.newHashSet((Object[])new String[]{"checktmpl", "entity", "entryaccount", "entryaudittrail", "entrychangetype", "adjustnumber", "diffmode", "diffmethod", "difftype", "status", "modifier", "modifytime", "mark", "isautoelim", "ocdiffmoney"});
    public static final Set<String> HEADER_2 = Sets.newHashSet((Object[])new String[]{"entryecmoney", "entrycvtpath", "entrycvtmoney", "entrydebit", "entrycredit", "entryocmoney"});
    public static final Set<String> HEADER_3 = Sets.newHashSet((Object[])new String[]{"entryelimmoney", "entrydebelimval", "entrycreelimval"});
    private static final int DEFAULT_WIDTH = 3840;
    private static final Map<String, Integer> COL_WIDTH_MAP = ImmutableMap.of((Object)"checktmpl", (Object)7680, (Object)"entity", (Object)10240, (Object)"myentity", (Object)10240, (Object)"oppositeentity", (Object)10240);

    public CheckDetailExport(Long modelId, List<Long> ids, String createType, String showStyle, Integer userScale, Consumer<Integer> taskCallbackConsumer) {
        this.modelId = modelId;
        this.ids = ids;
        this.createType = createType;
        this.showStyle = showStyle;
        this.userScale = userScale;
        this.taskCallbackConsumer = taskCallbackConsumer;
    }

    public void initService() {
        if (this.userScale == null) {
            this.userScale = 2;
        }
        StringBuilder sb = new StringBuilder("#,##0");
        if (this.userScale > 0) {
            sb.append(".");
        }
        Integer i = 0;
        while (i < this.userScale) {
            sb.append("0");
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.dataFormate = this.wb.createDataFormat().getFormat(sb.toString());
        this.borderColor = this.getXSSFColor("c0c0c0");
        this.font = this.wb.createFont();
        this.font.setFontHeightInPoints((short)9);
        this.font.setFontName(ResManager.getLocaleString((String)"\u5b8b\u4f53", (String)"CheckDetailExportTask_2", (String)"fi-bcm-formplugin").getLocaleValue_zh_CN());
        this.wb.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        this.sheet = this.wb.createSheet("sheet1");
        this.sheet.createFreezePane(0, 2, 0, 2);
        this.headStyle = this.getHeadCellStyle(this.wb);
        this.textStyle = new XSSFCellStyle[]{this.getTextStyle(this.wb, 1, false), this.getTextStyle(this.wb, 2, false)};
        this.markStyle = new XSSFCellStyle[]{this.getTextStyle(this.wb, 1, true), this.getTextStyle(this.wb, 2, true)};
        this.numStyle = new XSSFCellStyle[]{this.getNumStyle(this.wb, 1), this.getNumStyle(this.wb, 2)};
        this.subtotalStyle = new XSSFCellStyle[]{this.getSubtotalStyle(this.wb, "num"), this.getSubtotalStyle(this.wb, "text")};
        this.totalStyle = new XSSFCellStyle[]{this.getTotalStyle(this.wb, "num"), this.getTotalStyle(this.wb, "text")};
        this.allRecord = this.ids.size();
    }

    public SXSSFWorkbook exportDetail() {
        Map<Integer, Pair<String, String>> indexSignConfig = CheckHelper.getColumnConfig(this.modelId, this.createType);
        Map<String, Integer> signIndexConfig = this.buildTableHead(this.modelId, indexSignConfig);
        this.buildDetailReport(signIndexConfig);
        this.sheet.setAutoFilter(new CellRangeAddress(1, 1, 0, signIndexConfig.size() - 1));
        for (Map.Entry<String, Integer> item : signIndexConfig.entrySet()) {
            this.sheet.setColumnWidth(item.getValue().intValue(), COL_WIDTH_MAP.getOrDefault(item.getKey(), 3840).intValue());
        }
        return this.wb;
    }

    private void buildDetailReport(Map<String, Integer> signIndexConfig) {
        ArrayList littleSumRowIndex = new ArrayList(16);
        ArrayList needMergeColumn = Lists.newArrayList((Object[])new String[]{"adjustnumber", "status", "isautoelim", "modifier", "modifytime", "mark"});
        ArrayList gourpNeedMergeColumn = Lists.newArrayList((Object[])new String[]{"difftype", "ocdiffmoney"});
        ArrayList mergeColumn = Lists.newArrayList((Object[])new String[]{"cvtdifmoney", "diffmode", "diffmethod"});
        if (ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"isCheckTotalDiffFirst")) {
            needMergeColumn.addAll(mergeColumn);
        } else {
            gourpNeedMergeColumn.addAll(mergeColumn);
        }
        Map<Long, DynamicObject> tmplMap = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,checktmpl.checkconfig,checktmpl.issingledc", (QFilter[])new QFilter[]{new QFilter("id", "in", this.ids)}).stream().collect(Collectors.toMap(e -> e.getLong("id"), v -> v));
        int[] groupRowIndex = new int[]{2};
        BatchProcessHelper.pageConsume((int)this.allRecord, (int)1000, index -> {
            int toIndex = (index + 1) * 1000;
            toIndex = toIndex > this.allRecord ? this.allRecord : toIndex;
            List<Long> subList = this.ids.subList(index * 1000, toIndex);
            DynamicObjectCollection checkrecords = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,number,model.id,checktmpl.id,checktmpl.name,checktmpl.number,entity.id,entity.number,entity.name,entity.longnumber,myentity.id,myentity.number,myentity.name,myentity.longnumber, oppositeentity.id,oppositeentity.number,oppositeentity.name,oppositeentity.longnumber,cvtdifmoney, adjustnumber, diffmode, diffmethod,status, isautoelim, modifier.name, modifytime, mark", (QFilter[])new QFilter[]{new QFilter("id", "in", subList)}, (String)ORDER_BY);
            HashMap<Long, DynamicObjectCollection> allEntryMap = new HashMap<Long, DynamicObjectCollection>(subList.size());
            DynamicObjectCollection allEntry = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,entryentity.id as entryid,entryentity.entrydebitaccout.id as entrydebitaccout.id,entryentity.entrymyaccount.id as entrymyaccount.id,entryentity.entrycreditaccout.id as entrycreditaccout.id,entryentity.entrydebit as entrydebit,entryentity.entrycredit as entrycredit,entryentity.entrydebelimval as entrydebelimval,entryentity.entrycreelimval as entrycreelimval,entryentity.entryaudittrail.id as entryaudittrail.id,entryentity.entrychangetype.id as entrychangetype.id,entryentity.entrydim1.id as entrydim1.id,entryentity.entrydim2.id as entrydim2.id,entryentity.entrydim3.id as entrydim3.id,entryentity.entrydim4.id as entrydim4.id,entryentity.entrydim5.id as entrydim5.id,entryentity.entrydim6.id as entrydim6.id,entryentity.entrycompany.id as entrycompany.id,entryentity.entryprocess.id as entryprocess.id,entryentity.entrymultigaap.id as entrymultigaap.id,entryentity.entrydatasort.id as entrydatasort.id,entryentity.entryscene.id as entryscene.id,entryentity.entryyear.id as entryyear.id,entryentity.entryperiod.id as entryperiod.id,entryentity.entrymycompany.id as entrymycompany.id,entryentity.entryorg.id as entryorg.id,entryentity.entrydiffmode as entrydiffmode,entryentity.entrydiffmethod as entrydiffmethod,entryentity.entrymyecmoney as entrymyecmoney,entryentity.entryopecmoney as entryopecmoney,entryentity.entrymycvtpath as entrymycvtpath,entryentity.entryopcvtpath as entryopcvtpath,entryentity.entryocmoney as entryocmoney,entryentity.entrymycvtmoney as entrymycvtmoney,entryentity.entryopcvtmoney as entryopcvtmoney,entryentity.difftype as difftype,entryentity.seq as seq,entryentity.groupkey as groupkey", (QFilter[])new QFilter[]{new QFilter("id", "in", subList)});
            for (DynamicObject dyn : allEntry) {
                DynamicObjectCollection entryDoc = (DynamicObjectCollection)allEntryMap.get(dyn.getLong("id"));
                if (entryDoc == null) {
                    entryDoc = new DynamicObjectCollection();
                    allEntryMap.put(dyn.getLong("id"), entryDoc);
                }
                entryDoc.add((Object)dyn);
            }
            for (DynamicObject checkrecord : checkrecords) {
                Set<String> headKeys;
                DynamicObjectCollection entryentity = (DynamicObjectCollection)allEntryMap.get(checkrecord.getLong("id"));
                if (signIndexConfig.get("entryelimmoney") == null && signIndexConfig.get("my_entryelimmoney") == null && signIndexConfig.get("entrydebelimval") == null && signIndexConfig.get("my_entrydebelimval") == null) {
                    entryentity.removeIf(e -> this.isDiffitem((DynamicObject)e));
                }
                entryentity.sort(Comparator.comparing(e -> e.getInt("seq")));
                boolean isMyOp = false;
                if (signIndexConfig.get("my_entryaccount") != null) {
                    isMyOp = true;
                    headKeys = MY_OP;
                } else {
                    headKeys = MULTI_ROW;
                }
                List<GroupData> groupDataList = CheckDetailHelper.packageRowData(this.modelId, entryentity, checkrecord, tmplMap, signIndexConfig, isMyOp, null, null);
                int lineCount = 0;
                for (int a = 0; a < groupDataList.size(); ++a) {
                    GroupData groupData = groupDataList.get(a);
                    List data = groupData.getData();
                    int colorIndex = a % 2;
                    for (int i = 0; i < data.size(); ++i) {
                        int n = groupRowIndex[0] + lineCount + i;
                        SXSSFRow row = this.sheet.createRow(n);
                        for (Map.Entry entry : signIndexConfig.entrySet()) {
                            DynamicObject entryData;
                            String key = (String)entry.getKey();
                            boolean isOp = false;
                            if (key.contains("_")) {
                                String[] s = key.split("_");
                                isOp = "op".equals(s[0]);
                                key = s[1];
                            }
                            if (("ocdiffmoney".equalsIgnoreCase(key) || "cvtdifmoney".equalsIgnoreCase(key)) && i != 0) continue;
                            Integer col = (Integer)entry.getValue();
                            Cell cell = row.getCell(col.intValue());
                            if (isMyOp) {
                                Pair pair = (Pair)data.get(i);
                                DynamicObject dynamicObject = entryData = isOp ? (DynamicObject)pair.p2 : (DynamicObject)pair.p1;
                                if (("diffmode".equals(key) || "diffmethod".equals(key) || "difftype".equals(key)) && entryData == null) {
                                    entryData = !isOp ? (DynamicObject)pair.p2 : (DynamicObject)pair.p1;
                                }
                            } else {
                                entryData = (DynamicObject)data.get(i);
                            }
                            Object cellValue = CheckDetailHelper.getCellShowValue(this.modelId, key, checkrecord, entryData, new ArrayList<String>(headKeys), groupData, this.showStyle, false);
                            if (twoPointCol.contains(key)) {
                                if (cellValue != null) {
                                    cell.setCellValue(((BigDecimal)cellValue).doubleValue());
                                }
                                cell.setCellStyle((CellStyle)this.numStyle[colorIndex]);
                            } else {
                                if (cellValue != null) {
                                    cell.setCellValue(cellValue.toString());
                                }
                                if ("mark".equals(key)) {
                                    cell.setCellStyle((CellStyle)this.markStyle[colorIndex]);
                                } else {
                                    cell.setCellStyle((CellStyle)this.textStyle[colorIndex]);
                                }
                            }
                            if (!sumCol.contains(key) || entryData == null) continue;
                            this.userObject.put(n, col, "money", cellValue);
                        }
                    }
                    for (String string : gourpNeedMergeColumn) {
                        if (signIndexConfig.get(string) == null) continue;
                        this.mergeCell(groupRowIndex[0] + lineCount, groupRowIndex[0] + lineCount + data.size() - 1, (Integer)signIndexConfig.get(string), (Integer)signIndexConfig.get(string));
                    }
                    lineCount += data.size();
                }
                for (String sign : needMergeColumn) {
                    if (signIndexConfig.get(sign) == null) continue;
                    this.mergeCell(groupRowIndex[0], groupRowIndex[0] + lineCount - 1, (Integer)signIndexConfig.get(sign), (Integer)signIndexConfig.get(sign));
                }
                Integer checktmplIndex = (Integer)signIndexConfig.get("checktmpl");
                Row subTotalRow = this.getOrCreateRow(groupRowIndex[0] + lineCount);
                this.addRowStyle(subTotalRow, 0, signIndexConfig.size(), (CellStyle)this.subtotalStyle[1]);
                Cell subTotalText = subTotalRow.getCell(checktmplIndex.intValue());
                subTotalText.setCellValue(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CheckDetailPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.mergeCell(groupRowIndex[0] + lineCount, groupRowIndex[0] + lineCount, checktmplIndex, checktmplIndex + 1);
                Cell subTotalNum = subTotalRow.getCell(((Integer)signIndexConfig.get("cvtdifmoney")).intValue());
                subTotalNum.setCellValue(checkrecord.getBigDecimal("cvtdifmoney").doubleValue());
                subTotalNum.setCellStyle((CellStyle)this.subtotalStyle[0]);
                this.userObject.put(groupRowIndex[0] + lineCount, (Integer)signIndexConfig.get("cvtdifmoney"), "littleSum", checkrecord.getBigDecimal("cvtdifmoney"));
                littleSumRowIndex.add(groupRowIndex[0] + lineCount);
                for (Map.Entry entry : signIndexConfig.entrySet()) {
                    String sign = (String)entry.getKey();
                    String key = sign.contains("_") ? sign.split("_")[1] : sign;
                    if (!sumCol.contains(key)) continue;
                    BigDecimal sum = new BigDecimal(0);
                    for (int i = groupRowIndex[0]; i < groupRowIndex[0] + lineCount; ++i) {
                        BigDecimal money = this.userObject.get(i, (Integer)entry.getValue(), "money", BigDecimal.ZERO);
                        sum = sum.add(money);
                    }
                    Cell cell = subTotalRow.getCell(((Integer)entry.getValue()).intValue());
                    cell.setCellStyle((CellStyle)this.subtotalStyle[0]);
                    cell.setCellValue(sum.doubleValue());
                    this.userObject.put(groupRowIndex[0] + lineCount, (Integer)entry.getValue(), "littleSum", sum);
                }
                groupRowIndex[0] = groupRowIndex[0] + lineCount + 1;
                this.updateProgress();
            }
        });
        Row totalRow = this.getOrCreateRow(groupRowIndex[0]);
        this.addRowStyle(totalRow, 0, signIndexConfig.size(), (CellStyle)this.totalStyle[1]);
        Cell totalText = totalRow.getCell(signIndexConfig.get("checktmpl").intValue());
        totalText.setCellValue(ResManager.loadKDString((String)"\u603b\u8ba1", (String)"CheckDetailPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        totalText.setCellStyle((CellStyle)this.totalStyle[1]);
        this.mergeCell(groupRowIndex[0], groupRowIndex[0], signIndexConfig.get("checktmpl"), signIndexConfig.get("checktmpl") + 1);
        for (Map.Entry<String, Integer> entry : signIndexConfig.entrySet()) {
            String sign = entry.getKey();
            String key = sign.contains("_") ? sign.split("_")[1] : sign;
            if (!sumCol.contains(key)) continue;
            BigDecimal sum = new BigDecimal(0);
            for (Integer r : littleSumRowIndex) {
                BigDecimal money = this.userObject.get(r, (Integer)entry.getValue(), "littleSum", BigDecimal.ZERO);
                sum = sum.add(money);
            }
            Cell cell = totalRow.getCell(((Integer)entry.getValue()).intValue());
            cell.setCellValue(sum.doubleValue());
            cell.setCellStyle((CellStyle)this.totalStyle[0]);
        }
        BigDecimal diffSum = new BigDecimal(0);
        for (Integer r : littleSumRowIndex) {
            BigDecimal money = this.userObject.get(r, signIndexConfig.get("cvtdifmoney"), "littleSum", BigDecimal.ZERO);
            diffSum = diffSum.add(money);
        }
        Cell cvtdifmoneyCell = totalRow.getCell(signIndexConfig.get("cvtdifmoney").intValue());
        cvtdifmoneyCell.setCellValue(diffSum.doubleValue());
        cvtdifmoneyCell.setCellStyle((CellStyle)this.totalStyle[0]);
        groupRowIndex[0] = groupRowIndex[0] + 1;
    }

    private void updateProgress() {
        if (this.taskCallbackConsumer != null) {
            this.taskCallbackConsumer.accept(this.completeRecod.incrementAndGet() * 100 / this.allRecord);
        }
    }

    private void addRowStyle(Row row, int startCell, int colSize, CellStyle style) {
        for (int i = startCell; i < colSize; ++i) {
            row.getCell(i).setCellStyle(style);
        }
    }

    private void mergeCell(int firstRow, int lastRow, int firstCol, int lastCol) {
        if (firstRow == lastRow && firstCol == lastCol) {
            return;
        }
        this.sheet.addMergedRegionUnsafe(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    private Row getOrCreateRow(int rowIndex) {
        SXSSFRow row = this.sheet.getRow(rowIndex);
        if (row == null) {
            row = this.sheet.createRow(rowIndex);
        }
        return row;
    }

    private boolean isDiffitem(DynamicObject entry) {
        BigDecimal value1 = entry.getBigDecimal("entrydebit");
        BigDecimal value2 = entry.getBigDecimal("entrycredit");
        return BigDecimal.ZERO.compareTo(value1) == 0 && BigDecimal.ZERO.compareTo(value2) == 0;
    }

    public Map<String, Integer> buildTableHead(Long modelId, Map<Integer, Pair<String, String>> indexSignConfig) {
        Integer minValue;
        LinkedHashMap<String, Integer> signIndexConfig = new LinkedHashMap<String, Integer>(16);
        SXSSFRow firstRow = this.sheet.createRow(0);
        SXSSFRow secondRow = this.sheet.createRow(1);
        for (Map.Entry<Integer, Pair<String, String>> entry : indexSignConfig.entrySet()) {
            int columnIndex = entry.getKey();
            String colName = (String)indexSignConfig.get((Object)Integer.valueOf((int)columnIndex)).p2;
            if (((String)entry.getValue().p1).contains("entrycvtmoney")) {
                colName = ResManager.loadKDString((String)"\u5bf9\u8d26\u91d1\u989d", (String)"CheckDetailPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            } else if (((String)entry.getValue().p1).contains("entryelimmoney")) {
                colName = ResManager.loadKDString((String)"\u62b5\u9500\u91d1\u989d", (String)"CheckDetailPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            } else if (((String)entry.getValue().p1).contains("myentity")) {
                colName = ResManager.loadKDString((String)"\u7ec4\u7ec7/\u6211\u65b9\u7ec4\u7ec7", (String)"CheckDetailPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            } else if (((String)entry.getValue().p1).contains("oppositeentity")) {
                colName = ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7", (String)"CheckDetailPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            Cell cell = secondRow.createCell(columnIndex);
            cell.setCellValue(colName);
            cell.setCellStyle((CellStyle)this.headStyle);
            this.userObject.put(1, columnIndex, "key", indexSignConfig.get(columnIndex));
            signIndexConfig.put((String)indexSignConfig.get((Object)Integer.valueOf((int)columnIndex)).p1, columnIndex);
        }
        Set<String> header1 = HEADER_1;
        header1 = new HashSet<String>(header1);
        QFilter query = new QFilter("model", "=", (Object)modelId);
        QFilter query2 = new QFilter("issysdimension", "=", (Object)"0");
        DynamicObjectCollection dimensionCollection = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,number,fieldmapped", (QFilter[])new QFilter[]{query, query2}, (String)"fieldmapped");
        for (DynamicObject dynamicObject : dimensionCollection) {
            header1.add("entry" + dynamicObject.getString("fieldmapped"));
        }
        Set<String> header2 = HEADER_2;
        Set<String> header3 = HEADER_3;
        ArrayList<Integer> l1 = new ArrayList<Integer>(16);
        ArrayList<Integer> l2 = new ArrayList<Integer>(16);
        ArrayList<Integer> l3 = new ArrayList<Integer>(16);
        ArrayList<Integer> l4 = new ArrayList<Integer>(16);
        for (Map.Entry entry : signIndexConfig.entrySet()) {
            Cell cell;
            String key = (String)entry.getKey();
            if (key.contains("_")) {
                String[] s = key.split("_");
                key = s[1];
            }
            Cell firstRowwCell = firstRow.getCell(((Integer)entry.getValue()).intValue());
            firstRowwCell.setCellStyle((CellStyle)this.headStyle);
            if (header1.contains(key)) {
                cell = firstRowwCell;
                cell.setCellStyle((CellStyle)this.headStyle);
                cell.setCellValue((String)indexSignConfig.get(entry.getValue()).p2);
                this.mergeCell(0, 1, (Integer)entry.getValue(), (Integer)entry.getValue());
            }
            if ("myentity".equalsIgnoreCase(key)) {
                firstRowwCell.setCellValue(ResManager.loadKDString((String)"\u672c\u65b9\u5355\u4f4d", (String)"CheckDetailPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else if ("oppositeentity".equalsIgnoreCase(key)) {
                firstRowwCell.setCellValue(ResManager.loadKDString((String)"\u5bf9\u65b9\u5355\u4f4d", (String)"CheckDetailPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else if ("cvtdifmoney".equalsIgnoreCase(key)) {
                firstRowwCell.setCellValue(ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02", (String)"CheckDetailPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                cell = secondRow.getCell(((Integer)entry.getValue()).intValue());
                cell.setCellStyle((CellStyle)this.headStyle);
                cell.setCellValue(ResManager.loadKDString((String)"\u5bf9\u8d26\u91d1\u989d", (String)"CheckDetailPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (header2.contains(key)) {
                if (((String)entry.getKey()).startsWith("op_")) {
                    l3.add((Integer)entry.getValue());
                    continue;
                }
                l1.add((Integer)entry.getValue());
                continue;
            }
            if (!header3.contains(key)) continue;
            if (((String)entry.getKey()).startsWith("op_")) {
                l4.add((Integer)entry.getValue());
                continue;
            }
            l2.add((Integer)entry.getValue());
        }
        if (CollectionUtils.isEmpty(l3) && CollectionUtils.isEmpty(l4)) {
            if (!CollectionUtils.isEmpty(l1)) {
                minValue = this.getMinValueFromList(l1);
                firstRow.getCell(minValue.intValue()).setCellValue(ResManager.loadKDString((String)"\u5bf9\u8d26\u8d27\u5e01", (String)"CheckDetailPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                if (this.isAdjacentList(l1)) {
                    this.mergeCell(0, 0, minValue, minValue + l1.size() - 1);
                }
            }
            if (!CollectionUtils.isEmpty(l2)) {
                minValue = this.getMinValueFromList(l2);
                firstRow.getCell(minValue.intValue()).setCellValue(ResManager.loadKDString((String)"\u62b5\u9500\u8d27\u5e01", (String)"CheckDetailPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                if (this.isAdjacentList(l2)) {
                    this.mergeCell(0, 0, minValue, minValue + l2.size() - 1);
                }
            }
        } else {
            if (!CollectionUtils.isEmpty(l1)) {
                minValue = this.getMinValueFromList(l1);
                firstRow.getCell(minValue.intValue()).setCellValue(ResManager.loadKDString((String)"\u672c\u65b9\u5bf9\u8d26\u8d27\u5e01", (String)"CheckDetailPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                if (this.isAdjacentList(l1)) {
                    this.mergeCell(0, 0, minValue, minValue + l1.size() - 1);
                }
            }
            if (!CollectionUtils.isEmpty(l2)) {
                minValue = this.getMinValueFromList(l2);
                firstRow.getCell(minValue.intValue()).setCellValue(ResManager.loadKDString((String)"\u672c\u65b9\u62b5\u9500\u8d27\u5e01", (String)"CheckDetailPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                if (this.isAdjacentList(l2)) {
                    this.mergeCell(0, 0, minValue, minValue + l2.size() - 1);
                }
            }
            if (!CollectionUtils.isEmpty(l3)) {
                minValue = this.getMinValueFromList(l3);
                firstRow.getCell(minValue.intValue()).setCellValue(ResManager.loadKDString((String)"\u5bf9\u65b9\u5bf9\u8d26\u8d27\u5e01", (String)"CheckDetailPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                if (this.isAdjacentList(l3)) {
                    this.mergeCell(0, 0, minValue, minValue + l3.size() - 1);
                }
            }
            if (!CollectionUtils.isEmpty(l4)) {
                minValue = this.getMinValueFromList(l4);
                firstRow.getCell(minValue.intValue()).setCellValue(ResManager.loadKDString((String)"\u5bf9\u65b9\u62b5\u9500\u8d27\u5e01", (String)"CheckDetailPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                if (this.isAdjacentList(l4)) {
                    this.mergeCell(0, 0, minValue, minValue + l4.size() - 1);
                }
            }
        }
        return signIndexConfig;
    }

    private XSSFCellStyle getHeadCellStyle(SXSSFWorkbook wb) {
        XSSFCellStyle headStyle = wb.getXSSFWorkbook().createCellStyle();
        this.commonStyle(headStyle);
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setFillForegroundColor(this.getXSSFColor("dfdfdf"));
        return headStyle;
    }

    private XSSFCellStyle getTotalStyle(SXSSFWorkbook wb, String type) {
        XSSFCellStyle style = wb.getXSSFWorkbook().createCellStyle();
        this.commonStyle(style);
        if ("num".equals(type)) {
            style.setAlignment(HorizontalAlignment.RIGHT);
            style.setDataFormat(this.dataFormate.shortValue());
        } else {
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setWrapText(true);
        }
        style.setFillForegroundColor(this.getXSSFColor("c2c2c2"));
        return style;
    }

    private XSSFCellStyle getSubtotalStyle(SXSSFWorkbook wb, String type) {
        XSSFCellStyle style = wb.getXSSFWorkbook().createCellStyle();
        this.commonStyle(style);
        if ("num".equals(type)) {
            style.setAlignment(HorizontalAlignment.RIGHT);
            style.setDataFormat(this.dataFormate.shortValue());
        } else {
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setWrapText(true);
        }
        style.setFillForegroundColor(this.getXSSFColor("d9d9d9"));
        return style;
    }

    private XSSFCellStyle getNumStyle(SXSSFWorkbook wb, int type) {
        XSSFCellStyle style = wb.getXSSFWorkbook().createCellStyle();
        this.commonStyle(style);
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setDataFormat(this.dataFormate.shortValue());
        if (type == 1) {
            style.setFillForegroundColor(this.getXSSFColor("ffffff"));
        } else {
            style.setFillForegroundColor(this.getXSSFColor("d9e1f2"));
        }
        return style;
    }

    private XSSFCellStyle getTextStyle(SXSSFWorkbook wb, int type, boolean isMark) {
        XSSFCellStyle style = wb.getXSSFWorkbook().createCellStyle();
        this.commonStyle(style);
        if (isMark) {
            style.setAlignment(HorizontalAlignment.LEFT);
        } else {
            style.setAlignment(HorizontalAlignment.CENTER);
        }
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        if (type == 1) {
            style.setFillForegroundColor(this.getXSSFColor("ffffff"));
        } else {
            style.setFillForegroundColor(this.getXSSFColor("d9e1f2"));
        }
        return style;
    }

    private void commonStyle(XSSFCellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBottomBorderColor(this.borderColor);
        style.setTopBorderColor(this.borderColor);
        style.setLeftBorderColor(this.borderColor);
        style.setRightBorderColor(this.borderColor);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFont(this.font);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setLocked(true);
    }

    private boolean isAdjacentList(List<Integer> l1) {
        return this.getMaxValueFromList(l1) - this.getMinValueFromList(l1) + 1 == l1.size();
    }

    private Integer getMinValueFromList(List<Integer> list) {
        Optional min = list.stream().min(Integer::compareTo);
        if (min.isPresent()) {
            return (Integer)min.get();
        }
        return 0;
    }

    private Integer getMaxValueFromList(List<Integer> list) {
        Optional max = list.stream().max(Integer::compareTo);
        if (max.isPresent()) {
            return (Integer)max.get();
        }
        return 0;
    }

    private XSSFColor getXSSFColor(String colorHex) {
        int r = Integer.parseInt(colorHex.substring(0, 2), 16);
        int g = Integer.parseInt(colorHex.substring(2, 4), 16);
        int b = Integer.parseInt(colorHex.substring(4, 6), 16);
        return new XSSFColor(new Color(r, g, b), (IndexedColorMap)new DefaultIndexedColorMap());
    }

    public Integer getAllRecord() {
        return this.allRecord;
    }

    public Integer getCompleteRecod() {
        return this.completeRecod.get();
    }

    static class UserObject {
        private Map<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>(16);

        UserObject() {
        }

        public void put(int row, int col, String strKey, Object value) {
            String dataKey = this.createKey(row, col);
            Map<String, Object> map = this.dataMap.get(dataKey);
            if (map == null) {
                map = new HashMap<String, Object>(16);
                this.dataMap.put(dataKey, map);
            }
            map.put(strKey, value);
        }

        public <T> T get(int row, int col, String strKey) {
            return this.get(row, col, strKey, null);
        }

        public <T> T get(int row, int col, String strKey, T defaultValue) {
            Map<String, Object> map = this.dataMap.get(this.createKey(row, col));
            if (map != null) {
                Object value = map.get(strKey);
                if (value != null) {
                    return (T)value;
                }
                return defaultValue;
            }
            return defaultValue;
        }

        private String createKey(int row, int col) {
            return row + "_" + col;
        }
    }
}

