/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.check.helper.CheckRecordHelper;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CheckStatusEnum;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.enums.DiffTypeEnum;
import kd.fi.bcm.common.enums.check.CheckSumStatusEnum;
import kd.fi.bcm.formplugin.check.GroupData;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckDetailHelper {
    private static final Set<String> defaultGroupDims = Sets.newHashSet((Object[])new String[]{"entryaccount", "entryaudittrail", "entrychangetype", "entrydim1", "entrydim2", "entrydim3", "entrydim4", "entrydim5", "entrydim6"});
    public static final String RECORD_SELECT_FIELDS = "id,number,model.id,checktmpl.id,checktmpl.name,checktmpl.number,entity.id,entity.number,entity.name,entity.longnumber,myentity.id,myentity.number,myentity.name,myentity.longnumber, oppositeentity.id,oppositeentity.number,oppositeentity.name,oppositeentity.longnumber,cvtdifmoney, adjustnumber, diffmode, diffmethod,status, isautoelim, modifier.name, modifytime, mark";
    public static final String ENTRY_SELECT_FIELDS = "id,entryentity.id as entryid,entryentity.entrydebitaccout.id as entrydebitaccout.id,entryentity.entrymyaccount.id as entrymyaccount.id,entryentity.entrycreditaccout.id as entrycreditaccout.id,entryentity.entrydebit as entrydebit,entryentity.entrycredit as entrycredit,entryentity.entrydebelimval as entrydebelimval,entryentity.entrycreelimval as entrycreelimval,entryentity.entryaudittrail.id as entryaudittrail.id,entryentity.entrychangetype.id as entrychangetype.id,entryentity.entrydim1.id as entrydim1.id,entryentity.entrydim2.id as entrydim2.id,entryentity.entrydim3.id as entrydim3.id,entryentity.entrydim4.id as entrydim4.id,entryentity.entrydim5.id as entrydim5.id,entryentity.entrydim6.id as entrydim6.id,entryentity.entrycompany.id as entrycompany.id,entryentity.entryprocess.id as entryprocess.id,entryentity.entrymultigaap.id as entrymultigaap.id,entryentity.entrydatasort.id as entrydatasort.id,entryentity.entryscene.id as entryscene.id,entryentity.entryyear.id as entryyear.id,entryentity.entryperiod.id as entryperiod.id,entryentity.entrymycompany.id as entrymycompany.id,entryentity.entryorg.id as entryorg.id,entryentity.entrydiffmode as entrydiffmode,entryentity.entrydiffmethod as entrydiffmethod,entryentity.entrymyecmoney as entrymyecmoney,entryentity.entryopecmoney as entryopecmoney,entryentity.entrymycvtpath as entrymycvtpath,entryentity.entryopcvtpath as entryopcvtpath,entryentity.entryocmoney as entryocmoney,entryentity.entrymycvtmoney as entrymycvtmoney,entryentity.entryopcvtmoney as entryopcvtmoney,entryentity.difftype as difftype,entryentity.seq as seq,entryentity.groupkey as groupkey";

    public static boolean isChangeMyop(DynamicObject checkRecord, String fromPage) {
        if ("sum_page".equals(fromPage)) {
            String opMergeDirectOrg;
            String myMergeDirectOrg = EntityServiceHelper.getMergeDirectLongNumber((String)checkRecord.getString("entity.longnumber"), (String)checkRecord.getString("myentity.longnumber"));
            return myMergeDirectOrg.compareTo(opMergeDirectOrg = EntityServiceHelper.getMergeDirectLongNumber((String)checkRecord.getString("entity.longnumber"), (String)checkRecord.getString("oppositeentity.longnumber"))) > 0;
        }
        return false;
    }

    public static List<GroupData> packageRowData(Long modelId, DynamicObjectCollection entryentity, DynamicObject checkRecord, Map<Long, DynamicObject> tmplMap, Map<String, Integer> signIndexConfig, Boolean isMyop, DynamicObjectCollection userDefineDims, String fromPage) {
        boolean isChangeMyop = CheckDetailHelper.isChangeMyop(checkRecord, fromPage);
        String opNumber = checkRecord.getString("oppositeentity.number");
        IDNumberTreeNode opMemberTreeNode = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)"InternalCompany", (String)opNumber);
        DynamicObject checkTmpl = tmplMap.get(checkRecord.getLong("id"));
        String checkconfig = checkTmpl == null ? "" : checkTmpl.getString("checktmpl.checkconfig");
        ArrayList<GroupData> result = new ArrayList<GroupData>(16);
        boolean isHasGroupKey = entryentity.stream().anyMatch(e -> e.getString("groupkey") != null && !" ".equals(e.getString("groupkey")));
        Map<String, Map<Boolean, List<DynamicObject>>> collect = entryentity.stream().collect(Collectors.groupingBy(e -> isHasGroupKey ? e.getString("groupkey") : (checkconfig.indexOf("1") >= 0 ? e.getString("entrydim1.id") : "") + (checkconfig.indexOf("2") >= 0 ? e.getString("entrydim2.id") : "") + (checkconfig.indexOf("3") >= 0 ? e.getString("entrydim3.id") : "") + (checkconfig.indexOf("4") >= 0 ? e.getString("entrydim4.id") : "") + (checkconfig.indexOf("5") >= 0 ? e.getString("entrydim5.id") : "") + (checkconfig.indexOf("6") >= 0 ? e.getString("entrydim6.id") : "") + (checkconfig.indexOf("7") >= 0 ? e.getString("entryaudittrail.id") : ""), Collectors.groupingBy(e -> isChangeMyop == (e.getLong("entrycompany.id") != opMemberTreeNode.getId().longValue()))));
        TreeMap<String, Map> sortedMap = new TreeMap<String, Map>(String::compareTo);
        sortedMap.putAll(collect);
        sortedMap.forEach((groupKey, m) -> {
            HashMap<Long, Map<String, Set<Pair<Long, String>>>> dimCombineMap = new HashMap<Long, Map<String, Set<Pair<Long, String>>>>(16);
            ArrayList<Pair<DynamicObject, DynamicObject>> myopData = new ArrayList<Pair<DynamicObject, DynamicObject>>(16);
            List<Object> my = m.get(Boolean.TRUE) == null ? new ArrayList(1) : (List)m.get(Boolean.TRUE);
            List<Object> op = m.get(Boolean.FALSE) == null ? new ArrayList(1) : (List)m.get(Boolean.FALSE);
            my = CheckDetailHelper.mergeDataByColumnConfig(modelId, my, signIndexConfig, dimCombineMap, userDefineDims);
            op = CheckDetailHelper.mergeDataByColumnConfig(modelId, op, signIndexConfig, dimCombineMap, userDefineDims);
            op.sort(Comparator.comparing(e -> e.getInt("seq")));
            my.sort(Comparator.comparing(e -> e.getInt("seq")));
            for (int i = 0; i < Math.max(my.size(), op.size()); ++i) {
                Pair p = Pair.onePair((Object)(i < my.size() ? (DynamicObject)my.get(i) : null), i < op.size() ? (DynamicObject)op.get(i) : null);
                myopData.add(p);
            }
            ArrayList<DynamicObject> allData = new ArrayList<DynamicObject>(16);
            List myDiffitem = my.stream().filter(e -> CheckDetailHelper.isDiffitem(e)).collect(Collectors.toList());
            my.removeAll(myDiffitem);
            List opDiffitem = op.stream().filter(e -> CheckDetailHelper.isDiffitem(e)).collect(Collectors.toList());
            op.removeAll(opDiffitem);
            Map<Boolean, List<DynamicObject>> mydcGroup = my.stream().collect(Collectors.groupingBy(e -> e.getLong("entrydebitaccout.id") != 0L));
            Map<Boolean, List<DynamicObject>> opdcGroup = op.stream().collect(Collectors.groupingBy(e -> e.getLong("entrydebitaccout.id") != 0L));
            List<Object> myD = mydcGroup.get(Boolean.TRUE) == null ? new ArrayList(1) : mydcGroup.get(Boolean.TRUE);
            List<Object> myC = mydcGroup.get(Boolean.FALSE) == null ? new ArrayList(1) : mydcGroup.get(Boolean.FALSE);
            List<Object> opD = opdcGroup.get(Boolean.TRUE) == null ? new ArrayList(1) : opdcGroup.get(Boolean.TRUE);
            List<Object> opC = opdcGroup.get(Boolean.FALSE) == null ? new ArrayList(1) : opdcGroup.get(Boolean.FALSE);
            myD.sort(Comparator.comparing(e -> e.getInt("seq")));
            myC.sort(Comparator.comparing(e -> e.getInt("seq")));
            opD.sort(Comparator.comparing(e -> e.getInt("seq")));
            opC.sort(Comparator.comparing(e -> e.getInt("seq")));
            allData.addAll(myD);
            allData.addAll(opC);
            allData.addAll(myC);
            allData.addAll(opD);
            allData.addAll(myDiffitem);
            allData.addAll(opDiffitem);
            Pair<BigDecimal, BigDecimal> groupDiffPair = CheckDetailHelper.calculateGroupDiff(my, op, checkTmpl);
            GroupData groupData = new GroupData(myopData, allData, groupDiffPair, isMyop, dimCombineMap);
            result.add(groupData);
        });
        return result;
    }

    private static Pair<BigDecimal, BigDecimal> calculateGroupDiff(List<DynamicObject> my, List<DynamicObject> op, DynamicObject checkTmpl) {
        BigDecimal ocValue;
        BigDecimal entrydebit;
        BigDecimal entrycredit;
        Boolean issingledc = checkTmpl.getBoolean("checktmpl.issingledc");
        BigDecimal abSum = BigDecimal.ZERO;
        BigDecimal baSum = BigDecimal.ZERO;
        BigDecimal abOcSum = BigDecimal.ZERO;
        BigDecimal baOcSum = BigDecimal.ZERO;
        for (DynamicObject dy : my) {
            if (CheckDetailHelper.isDiffitem(dy)) continue;
            entrycredit = dy.getBigDecimal("entrycredit") == null ? BigDecimal.ZERO : dy.getBigDecimal("entrycredit");
            entrydebit = dy.getBigDecimal("entrydebit") == null ? BigDecimal.ZERO : dy.getBigDecimal("entrydebit");
            abSum = abSum.add(entrycredit.subtract(entrydebit));
            ocValue = dy.getBigDecimal("entryocmoney");
            abOcSum = abOcSum.add(entrydebit.compareTo(BigDecimal.ZERO) == 0 ? ocValue : ocValue.negate());
        }
        for (DynamicObject dy : op) {
            if (CheckDetailHelper.isDiffitem(dy)) continue;
            entrycredit = dy.getBigDecimal("entrycredit") == null ? BigDecimal.ZERO : dy.getBigDecimal("entrycredit");
            entrydebit = dy.getBigDecimal("entrydebit") == null ? BigDecimal.ZERO : dy.getBigDecimal("entrydebit");
            baSum = baSum.add(entrycredit.subtract(entrydebit));
            ocValue = dy.getBigDecimal("entryocmoney");
            baOcSum = baOcSum.add(entrydebit.compareTo(BigDecimal.ZERO) == 0 ? ocValue : ocValue.negate());
        }
        BigDecimal diffAmount = issingledc != false ? abSum.add(baSum) : abSum.subtract(baSum.negate());
        BigDecimal ocDiffAmount = issingledc != false ? abOcSum.add(baOcSum) : abOcSum.subtract(baOcSum.negate());
        return Pair.onePair((Object)diffAmount, (Object)ocDiffAmount);
    }

    private static List<DynamicObject> mergeDataByColumnConfig(Long modelId, List<DynamicObject> dynamicObjects, Map<String, Integer> signIndexConfig, Map<Long, Map<String, Set<Pair<Long, String>>>> dimCombineMap, DynamicObjectCollection userDefineDims) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            List diffitems = dynamicObjects.stream().filter(e -> CheckDetailHelper.isDiffitem(e)).collect(Collectors.toList());
            dynamicObjects.removeAll(diffitems);
            result.addAll(diffitems);
            Set<String> signSet = signIndexConfig.keySet().stream().map(e -> e.contains("_") ? e.split("_")[1] : e).collect(Collectors.toSet());
            HashSet realGroupDims = new HashSet(16);
            signSet.forEach(e -> {
                if (defaultGroupDims.contains(e)) {
                    realGroupDims.add(e);
                }
            });
            Map<String, List<DynamicObject>> groupedMap = dynamicObjects.stream().collect(Collectors.groupingBy(e -> {
                StringBuilder key = new StringBuilder();
                realGroupDims.forEach(dim -> {
                    if ("entryaccount".equalsIgnoreCase((String)dim)) {
                        key.append(StringUtils.isEmpty((CharSequence)e.getString("entrydebitaccout.id")) ? "" : e.getString("entrydebitaccout.id")).append(StringUtils.isEmpty((CharSequence)e.getString("entrycreditaccout.id")) ? "" : e.getString("entrycreditaccout.id"));
                    } else {
                        key.append(StringUtils.isEmpty((CharSequence)e.getString(dim + ".id")) ? "" : e.getString(dim + ".id"));
                    }
                });
                return key.toString();
            }));
            groupedMap.forEach((k, l) -> {
                if (!CollectionUtils.isEmpty((Collection)l)) {
                    DynamicObject dy = (DynamicObject)l.get(0);
                    dy.set("entryocmoney", (Object)l.stream().map(e -> e.getBigDecimal("entryocmoney") == null ? BigDecimal.ZERO : e.getBigDecimal("entryocmoney")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    dy.set("entrymyecmoney", (Object)l.stream().map(e -> e.getBigDecimal("entrymyecmoney") == null ? BigDecimal.ZERO : e.getBigDecimal("entrymyecmoney")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    dy.set("entryopecmoney", (Object)l.stream().map(e -> e.getBigDecimal("entryopecmoney") == null ? BigDecimal.ZERO : e.getBigDecimal("entryopecmoney")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    dy.set("entrymycvtmoney", (Object)l.stream().map(e -> e.getBigDecimal("entrymycvtmoney") == null ? BigDecimal.ZERO : e.getBigDecimal("entrymycvtmoney")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    dy.set("entryopcvtmoney", (Object)l.stream().map(e -> e.getBigDecimal("entryopcvtmoney") == null ? BigDecimal.ZERO : e.getBigDecimal("entryopcvtmoney")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    dy.set("entrydebit", (Object)l.stream().map(e -> e.getBigDecimal("entrydebit") == null ? BigDecimal.ZERO : e.getBigDecimal("entrydebit")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    dy.set("entrycredit", (Object)l.stream().map(e -> e.getBigDecimal("entrycredit") == null ? BigDecimal.ZERO : e.getBigDecimal("entrycredit")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    dy.set("entrydebelimval", (Object)l.stream().map(e -> e.getBigDecimal("entrydebelimval") == null ? BigDecimal.ZERO : e.getBigDecimal("entrydebelimval")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    dy.set("entrycreelimval", (Object)l.stream().map(e -> e.getBigDecimal("entrycreelimval") == null ? BigDecimal.ZERO : e.getBigDecimal("entrycreelimval")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    if (userDefineDims != null) {
                        dimCombineMap.put(dy.getLong("entryid"), CheckDetailHelper.getDimCombine(modelId, l, userDefineDims));
                    }
                    result.add(dy);
                }
            });
        }
        return result;
    }

    private static Map<String, Set<Pair<Long, String>>> getDimCombine(Long modelId, List<DynamicObject> entrys, DynamicObjectCollection userDefineDims) {
        HashMap<String, Set<Pair<Long, String>>> result = new HashMap<String, Set<Pair<Long, String>>>(16);
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        for (DynamicObject entry : entrys) {
            String[] strArry;
            CheckDetailHelper.addTtoResult(result, PresetConstant.ENTITY_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entryorg"), null);
            CheckDetailHelper.addTtoResult(result, PresetConstant.MYCOMPANY_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entrymycompany"), null);
            CheckDetailHelper.addTtoResult(result, PresetConstant.INTERNALCOMPANY_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entrycompany"), null);
            String account = "entrydebitaccout";
            String accountId = entry.getString("entrydebitaccout.id");
            if (StringUtils.isBlank((CharSequence)accountId) || "0".equals(accountId)) {
                account = "entrycreditaccout";
            }
            CheckDetailHelper.addTtoResult(result, PresetConstant.ACCOUNT_DIM, CheckDetailHelper.getIdNumber(modelId, entry, account), null);
            CheckDetailHelper.addTtoResult(result, PresetConstant.SCENE_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entryscene"), null);
            CheckDetailHelper.addTtoResult(result, PresetConstant.FY_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entryyear"), null);
            CheckDetailHelper.addTtoResult(result, PresetConstant.PERIOD_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entryperiod"), null);
            String cvtpath = entry.getString("entrymycvtpath");
            if (StringUtils.isBlank((CharSequence)cvtpath)) {
                cvtpath = entry.getString("entryopcvtpath");
            }
            if (StringUtils.isNotBlank((CharSequence)cvtpath) && (strArry = cvtpath.split("->")).length >= 1) {
                String currencyNum = StringUtils.trim((String)strArry[0]);
                IDNumberTreeNode currencyMember = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)currencyNum);
                CheckDetailHelper.addTtoResult(result, PresetConstant.CURRENCY_DIM, null, currencyMember);
                String cvtCurrencyNum = strArry.length >= 2 ? StringUtils.trim((String)strArry[1]) : StringUtils.trim((String)strArry[0]);
                IDNumberTreeNode cvtCurrencyMember = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)cvtCurrencyNum);
                CheckDetailHelper.addTtoResult(result, PresetConstant.CURRENCY_DIM + "cvt", null, cvtCurrencyMember);
            }
            CheckDetailHelper.addTtoResult(result, PresetConstant.PROCESS_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entryprocess"), null);
            CheckDetailHelper.addTtoResult(result, PresetConstant.AUDITTRIAL_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entryaudittrail"), null);
            CheckDetailHelper.addTtoResult(result, PresetConstant.CHANGETYPE_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entrychangetype"), null);
            CheckDetailHelper.addTtoResult(result, PresetConstant.RULE_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entrymultigaap"), null);
            CheckDetailHelper.addTtoResult(result, PresetConstant.DATASORT_DIM, CheckDetailHelper.getIdNumber(modelId, entry, "entrydatasort"), null);
            for (DynamicObject dim : userDefineDims) {
                String property = "entry" + dim.getString("fieldmapped");
                CheckDetailHelper.addTtoResult(result, dim.getString("number"), CheckDetailHelper.getIdNumber(modelId, entry, property), null);
            }
        }
        return result;
    }

    private static Pair<Long, String> getIdNumber(Long modelId, DynamicObject entry, String field) {
        Long memberId = entry.getLong(field + ".id");
        if (memberId == 0L) {
            return null;
        }
        IDNumberTreeNode numberTreeNode = MemberReader.findMemberById((long)modelId, (String)CheckDetailHelper.getEntityNumberBySign(field), (Long)entry.getLong(field + ".id"));
        if (numberTreeNode.getId() == -1L) {
            return null;
        }
        return Pair.onePair((Object)numberTreeNode.getId(), (Object)numberTreeNode.getNumber());
    }

    private static String getEntityNumberBySign(String sign) {
        switch (sign) {
            case "entryorg": {
                return "bcm_entitymembertree";
            }
            case "entrydebitaccout": 
            case "entrycreditaccout": {
                return "bcm_accountmembertree";
            }
            case "entryyear": {
                return "bcm_fymembertree";
            }
            case "entryperiod": {
                return "bcm_periodmembertree";
            }
            case "entryscene": {
                return "bcm_scenemembertree";
            }
            case "entryprocess": {
                return "bcm_processmembertree";
            }
            case "currency": {
                return "bcm_currencymembertree";
            }
            case "entryaudittrail": {
                return "bcm_audittrialmembertree";
            }
            case "entrychangetype": {
                return "bcm_changetypemembertree";
            }
            case "entrycompany": {
                return "bcm_icmembertree";
            }
            case "entrymultigaap": {
                return "bcm_rulemembertree";
            }
            case "entrydatasort": {
                return "bcm_datasortmembertree";
            }
            case "entrymycompany": {
                return "bcm_mycompanymembertree";
            }
        }
        return "bcm_userdefinedmembertree";
    }

    private static String getMemberShowValue(Long modelId, String key, DynamicObject dy, String showStyle, String sign) {
        IDNumberTreeNode numberTreeNode = MemberReader.findMemberById((long)modelId, (String)CheckDetailHelper.getEntityNumberBySign(sign), (Long)dy.getLong(key + ".id"));
        if ("number".equals(showStyle)) {
            return numberTreeNode.getNumber();
        }
        if ("name".equals(showStyle)) {
            return numberTreeNode.getName();
        }
        if ("numbername".equals(showStyle)) {
            return numberTreeNode.getNumber() + "|" + numberTreeNode.getName();
        }
        return "";
    }

    private static void addTtoResult(Map<String, Set<Pair<Long, String>>> result, String dimKey, Pair<Long, String> pair, IDNumberTreeNode treeNode) {
        if ((pair == null || pair.p2 == null) && treeNode == null) {
            return;
        }
        Set dimValueSet = result.computeIfAbsent(dimKey, k -> new HashSet(16));
        if (pair != null) {
            dimValueSet.add(pair);
        } else {
            dimValueSet.add(Pair.onePair((Object)treeNode.getId(), (Object)treeNode.getNumber()));
        }
    }

    public static Object getCellShowValue(Long modelId, String key, DynamicObject head, DynamicObject item, List<String> headKeys, GroupData groupData, String showStyle, boolean isChangeMyop) {
        BigDecimal entrycreelimval;
        boolean isCheckTotalDiffFirst = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isCheckTotalDiffFirst");
        if (headKeys.contains(key)) {
            if ("myentity".equals(key) || "oppositeentity".equals(key) || "entity".equals(key) || "checktmpl".equals(key)) {
                if (isChangeMyop && "myentity".equals(key)) {
                    key = "oppositeentity";
                } else if (isChangeMyop && "oppositeentity".equals(key)) {
                    key = "myentity";
                }
                String val = "";
                if ("number".equals(showStyle)) {
                    val = head.getString(key + ".number");
                } else if ("name".equals(showStyle)) {
                    val = head.getString(key + ".name");
                } else if ("numbername".equals(showStyle)) {
                    val = head.getString(key + ".number") + "|" + head.getString(key + ".name");
                }
                return val;
            }
            if ("diffmode".equalsIgnoreCase(key)) {
                if (isCheckTotalDiffFirst) {
                    if (StringUtils.isNotEmpty((CharSequence)head.getString("diffmode")) && !"0".equals(head.getString("diffmode"))) {
                        return DiffModeEnum.getEnumName((int)head.getInt(key));
                    }
                    return "";
                }
                if (item != null && StringUtils.isNotBlank((CharSequence)item.getString("entrydiffmode")) && !"0".equals(item.getString("entrydiffmode"))) {
                    return DiffModeEnum.getEnumName((int)item.getInt("entrydiffmode"));
                }
                if (StringUtils.isNotEmpty((CharSequence)head.getString(key))) {
                    return DiffModeEnum.getEnumName((int)head.getInt(key));
                }
                return "";
            }
            if ("diffmethod".equalsIgnoreCase(key)) {
                if (isCheckTotalDiffFirst) {
                    if (StringUtils.isNotEmpty((CharSequence)head.getString("diffmethod")) && !"0".equals(head.getString("diffmethod"))) {
                        return DiffMethodEnum.getEnumName((int)head.getInt(key));
                    }
                    return "";
                }
                if (item != null && StringUtils.isNotBlank((CharSequence)item.getString("entrydiffmethod")) && !"0".equals(item.getString("entrydiffmethod"))) {
                    return DiffMethodEnum.getEnumName((int)item.getInt("entrydiffmethod"));
                }
                if (StringUtils.isNotEmpty((CharSequence)head.getString(key))) {
                    return DiffMethodEnum.getEnumName((int)head.getInt(key));
                }
                return "";
            }
            if ("status".equalsIgnoreCase(key)) {
                if (StringUtils.isNotEmpty((CharSequence)head.getString(key))) {
                    return CheckStatusEnum.getEnum((int)head.getInt(key)).getName();
                }
                return "";
            }
            if ("isautoelim".equalsIgnoreCase(key)) {
                CheckSumStatusEnum status = CheckSumStatusEnum.getEnumByValue((String)head.getString(key));
                return status != null ? status.getName() : "";
            }
            if ("modifier".equalsIgnoreCase(key)) {
                return head.getString(key + ".name");
            }
            if ("modifytime".equalsIgnoreCase(key)) {
                Date date = head.getDate(key);
                return DateTimeUtils.format((Date)date);
            }
            if ("cvtdifmoney".equalsIgnoreCase(key)) {
                if (isCheckTotalDiffFirst) {
                    return head.getBigDecimal("cvtdifmoney");
                }
                return groupData.getGroupDiff();
            }
            return head.getString(key);
        }
        if ("ocdiffmoney".equals(key)) {
            return groupData.getOcGroupDiff();
        }
        if (item == null) {
            return null;
        }
        boolean isDebit = item.getLong("entrydebitaccout.id") != 0L;
        boolean dc = CheckRecordHelper.isDc((Long)head.getLong("model.id"), (Long)(isDebit ? item.getLong("entrydebitaccout.id") : item.getLong("entrycreditaccout.id")));
        boolean isMy = item.getLong("entrymyaccount.id") != 0L;
        BigDecimal entrydebit = item.getBigDecimal("entrydebit") == null ? BigDecimal.ZERO : item.getBigDecimal("entrydebit");
        BigDecimal entrycredit = item.getBigDecimal("entrycredit") == null ? BigDecimal.ZERO : item.getBigDecimal("entrycredit");
        BigDecimal entrydebelimval = item.getBigDecimal("entrydebelimval") == null ? BigDecimal.ZERO : item.getBigDecimal("entrydebelimval");
        BigDecimal bigDecimal = entrycreelimval = item.getBigDecimal("entrycreelimval") == null ? BigDecimal.ZERO : item.getBigDecimal("entrycreelimval");
        if ("entryaudittrail".equals(key)) {
            return CheckDetailHelper.getMemberShowValue(modelId, key, item, showStyle, "entryaudittrail");
        }
        if ("entrychangetype".equals(key)) {
            return CheckDetailHelper.getMemberShowValue(modelId, key, item, showStyle, "entrychangetype");
        }
        if (key.startsWith("entrydim")) {
            return CheckDetailHelper.getMemberShowValue(modelId, key, item, showStyle, key);
        }
        if ("entryaccount".equals(key)) {
            return CheckDetailHelper.getMemberShowValue(modelId, isDebit ? "entrydebitaccout" : "entrycreditaccout", item, showStyle, isDebit ? "entrydebitaccout" : "entrycreditaccout");
        }
        if ("myentity".equals(key)) {
            if (item.getLong("entrymycompany.id") == 0L) {
                return CheckDetailHelper.getMemberShowValue(modelId, "entryorg", item, showStyle, "entryorg");
            }
            return CheckDetailHelper.getMemberShowValue(modelId, "entrymycompany", item, showStyle, "entrymycompany");
        }
        if ("oppositeentity".equals(key)) {
            return CheckDetailHelper.getMemberShowValue(modelId, "entrycompany", item, showStyle, "entrycompany");
        }
        if ("entryecmoney".equalsIgnoreCase(key)) {
            BigDecimal ecMoney = item.getBigDecimal(isMy ? "entrymyecmoney" : "entryopecmoney");
            return dc ? ecMoney : ecMoney.negate();
        }
        if ("entrycvtpath".equalsIgnoreCase(key)) {
            return item.getString(isMy ? "entrymycvtpath" : "entryopcvtpath");
        }
        if ("entrycvtmoney".equalsIgnoreCase(key)) {
            return entrycredit.subtract(entrydebit);
        }
        if ("entryelimmoney".equalsIgnoreCase(key)) {
            return entrydebelimval.subtract(entrycreelimval);
        }
        if ("entrydebit".equalsIgnoreCase(key) || "entrycredit".equalsIgnoreCase(key) || "entrydebelimval".equalsIgnoreCase(key) || "entrycreelimval".equalsIgnoreCase(key)) {
            return item.getBigDecimal(key);
        }
        if ("difftype".equalsIgnoreCase(key)) {
            return item.getInt(key) != 0 ? DiffTypeEnum.getEnum((int)item.getInt(key)).getName() : "";
        }
        if ("entryocmoney".equalsIgnoreCase(key)) {
            BigDecimal ocMoney = item.getBigDecimal("entryocmoney");
            return dc ? ocMoney : ocMoney.negate();
        }
        return item.getString(key);
    }

    private static boolean isDiffitem(DynamicObject entry) {
        BigDecimal value1 = entry.getBigDecimal("entrydebit");
        BigDecimal value2 = entry.getBigDecimal("entrycredit");
        return BigDecimal.ZERO.compareTo(value1) == 0 && BigDecimal.ZERO.compareTo(value2) == 0;
    }
}

