/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.util.AllInOneUtils;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.DataTraceFromItem;
import kd.fi.bcm.business.linkquery.LinkQueryService;
import kd.fi.bcm.business.linkquery.LinkQueryUtil;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CheckCreateTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.ObjectUtils;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.check.CheckDetailHelper;
import kd.fi.bcm.formplugin.check.CheckHelper;
import kd.fi.bcm.formplugin.check.GroupData;
import kd.fi.bcm.formplugin.intergration.formula.FormulaLinkShowForm;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.UserObject;
import org.apache.commons.lang3.StringUtils;

public class CheckDetailPlugin
extends AbstractTemplateBasePlugin
implements DynamicPage {
    private static final String spreadKey = "report";
    private static final int initRowCount = 100;
    private static final String KEY_YEAR_ID = "KEY_YEAR_ID";
    private static final String KEY_PERIOD_ID = "KEY_PERIOD_ID";
    private static final Set<String> sumCol = Sets.newHashSet((Object[])new String[]{"entryecmoney", "entrycvtmoney", "entrydebit", "entrycredit", "entryelimmoney", "entrydebelimval", "entrycreelimval"});
    private static final Set<String> twoPointCol = Sets.newHashSet((Object[])new String[]{"entryecmoney", "entrycvtmoney", "entrydebit", "entrycredit", "entryelimmoney", "entrydebelimval", "entrycreelimval", "my_entryecmoney", "my_entrycvtmoney", "my_entrydebit", "my_entrycredit", "my_entryelimmoney", "my_entrydebelimval", "my_entrycreelimval", "op_entryecmoney", "op_entrycvtmoney", "op_entrydebit", "op_entrycredit", "op_entryelimmoney", "op_entrydebelimval", "op_entrycreelimval", "cvtdifmoney", "entryocmoney", "my_entryocmoney", "op_entryocmoney", "ocdiffmoney"});
    private static final Set<String> numberCols = Sets.newHashSet((Object[])new String[]{"entryocmoney", "entryecmoney", "entrycvtmoney", "entrydebit", "entrycredit", "entryelimmoney", "entrydebelimval", "entrycreelimval", "cvtdifmoney", "ocdiffmoney"});
    private static final List<Map<String, Object>> GROUP_STYLE = Lists.newArrayList((Object[])new Map[]{CheckHelper.getColorStyleMap("4"), CheckHelper.getColorStyleMap("5")});
    private static final Map<String, Object> SUBTOTAL_STYLE = CheckHelper.getColorStyleMap("3");
    private static final Map<String, Object> TOTAL_STYLE = CheckHelper.getColorStyleMap("6");
    public static final String ORDER_BY = "checktmpl.number asc,entity.longnumber asc,myentity.number asc,oppositeentity.number asc";
    private static final int PAGE_SIZE = 1000;
    private static final String[] ALL_TOOLBAR_BUTTON = new String[]{"btn_save", "btn_diffprocess", "btn_unaudit", "btn_linkquery", "btn_linktrace", "btn_layout", "btn_export", "btn_smartnotice", "btn_refresh", "baritemap"};
    private static final Map<String, Object> centerStyleMap = ImmutableMap.of((Object)SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), (Object)1, (Object)SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), (Object)1);
    private static final Map<String, Object> rightStyleMap = ImmutableMap.of((Object)SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), (Object)2, (Object)SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), (Object)1);
    private static final Map<String, Object> remarkStyleMap = ImmutableMap.of((Object)SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), (Object)0, (Object)SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), (Object)1, (Object)SpreadProperties.SetCellStyleMethod.WW.k(), (Object)true);

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        this.getPageCache().put("KEY_MODEL_ID", modelId + "");
        this.getPageCache().put("checkScale", ConfigServiceHelper.getStringParam((Long)this.getModelId(), (String)"checkScale"));
        this.refreshSpread();
        this.registSpreadShortcutKey();
    }

    @Override
    public String getSpreadKey() {
        return spreadKey;
    }

    private void refreshSpread() {
        Sheet sheet = this.getEffectiveSheet();
        SearchHelper.clearSheet(sheet, spreadKey, this.getClientViewProxy());
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("id");
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        this.buildSpreadAndData(sheet, ids);
        this.cacheSpreadModel();
        String createType = (String)this.getView().getFormShowParameter().getCustomParam("createtype");
        if (CheckCreateTypeEnum.CHECK_CREATE.value.equals(createType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_diffprocess", "btn_unaudit"});
        }
    }

    @Override
    public void registSpreadShortcutKey() {
        super.registSpreadShortcutKey();
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "showCheckContext", "F7", true, true, true);
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "showVersionView", "F9", true, true, true);
    }

    public void showVersionView() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_version_view");
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    public void showCheckContext() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_checkcontext_view");
        param.setCustomParam("checkParam", this.getFormCustomParam("checkParam"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    public void lookBackgroundConfig() {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("bcm_configsetting");
        param.setShowTitle(true);
        param.setCustomParam("isBackParam", (Object)"true");
        param.setCaption(ResManager.loadKDString((String)"\u540e\u53f0\u53c2\u6570\u8bbe\u7f6e\u5217\u8868", (String)"AbstractMultiReportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initSpreadListener();
    }

    private void initSpreadListener() {
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, event -> {
            Cell cell = (Cell)event.getSource();
            Sheet sheet = this.getEffectiveSheet();
            sheet.iteratorRangeCells(0, sheet.getMaxRowCount(), 0, sheet.getMaxColumnCount(), e -> {
                if (null != cell.getUserObject().get((Object)"billId") && null != e.getUserObject().get((Object)"billId") && cell.getUserObject().get((Object)"billId").equals(e.getUserObject().get((Object)"billId"))) {
                    cell.setUserObject("UPDATE_VALUE", (Object)true);
                }
            });
        });
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                String bizAppId = this.getBizAppId();
                if (ApplicationTypeEnum.BGMD.appnum.equalsIgnoreCase(bizAppId)) {
                    bizAppId = ApplicationTypeEnum.EB.appnum;
                }
                if (ObjectUtils.equals((Object)this.getFormCustomParam("createtype"), (Object)CheckCreateTypeEnum.CHECK_CREATE.getValue())) {
                    super.doCheckPermission("bcm_checkmainpage", "4730fc9f000008ae", Long.valueOf(this.getModelId()), bizAppId);
                } else {
                    super.doCheckPermission("bcm_checkmainpage", "1I6PHKCS9/D7", Long.valueOf(this.getModelId()), bizAppId);
                }
                this.saveData();
                break;
            }
            case "btn_diffprocess": {
                this.actionDiffProcess();
                break;
            }
            case "btn_refresh": {
                this.refreshSpread();
                break;
            }
            case "btn_unaudit": {
                this.actionUnAudit();
                break;
            }
            case "btn_linkquery": {
                this.linkReport();
                break;
            }
            case "btn_linktrace": {
                this.linkDataTrace();
                break;
            }
            case "btn_export": {
                this.actionExport();
                break;
            }
            case "btn_smartnotice": {
                this.actionSmartNotice();
                break;
            }
            case "btn_layout": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_checktmpllayoutfrom");
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                showParameter.setCustomParam("PAGE_FROM", (Object)"bcm_checkdetail");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_checktmpllayoutfrom");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    private void actionSmartNotice() {
        Set<Long> idSet = this.getCurrentPageSelect();
        if (!idSet.isEmpty()) {
            long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
            CheckHelper.openCheckSmartNoticePage(modelId, new ArrayList<Long>(idSet), this.getView(), (IFormPlugin)this);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"CheckDetailPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public String getBizAppId() {
        String appId = "";
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"cm");
        if (null != appInfo) {
            appId = appInfo.getId();
        }
        return appId;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "bcm_checktmpllayoutfrom": {
                if (returnData == null) break;
                this.refreshSpread();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"CheckDetailPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "closeLinkQuery": {
                this.getView().setEnable(Boolean.valueOf(true), ALL_TOOLBAR_BUTTON);
                break;
            }
        }
    }

    private Set<Long> getCurrentPageSelect() {
        HashSet<Long> selectedInfo = new HashSet<Long>(16);
        Sheet sheet = this.getEffectiveSheet();
        List selections = this.getSpreadSelector().getSelections();
        if (CollectionUtils.isEmpty((Collection)selections)) {
            for (int row = this.getSpreadSelector().getStartRow(); row <= this.getSpreadSelector().getEndRow(); ++row) {
                Cell cell;
                if (row < 0 || (cell = sheet.getCell(row, 0)).getUserObject("k") == null) continue;
                selectedInfo.add((Long)cell.getUserObject("k"));
            }
        } else {
            for (Map selection : selections) {
                for (int row = ((Integer)selection.get("row")).intValue(); row < (Integer)selection.get("row") + (Integer)selection.get("rowCount"); ++row) {
                    Cell cell;
                    if (row < 0 || (cell = sheet.getCell(row, 0)).getUserObject("k") == null) continue;
                    selectedInfo.add((Long)cell.getUserObject("k"));
                }
            }
        }
        return selectedInfo;
    }

    private void saveData() {
        HashSet billIds = new HashSet(10);
        HashMap updateMap = new HashMap(10);
        Sheet effectiveSheet = this.getEffectiveSheet();
        effectiveSheet.iteratorRangeCells(0, effectiveSheet.getMaxRowCount(), 0, effectiveSheet.getMaxColumnCount(), e -> {
            if (null != e.getUserObject().get((Object)"billId") && e.getUserObject("UPDATE_VALUE") != null) {
                Long billId = Long.valueOf(e.getUserObject().get((Object)"billId").toString());
                billIds.add(billId);
                updateMap.put(billId, null == e.getValue() ? "" : e.getValue().toString());
                e.removeUserObject("UPDATE_VALUE");
            }
        });
        DynamicObject[] billList = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_checkrecord"));
        Arrays.stream(billList).forEach(dn -> {
            if (updateMap.containsKey(dn.get("id"))) {
                dn.set("mark", updateMap.get(dn.get("id")));
                dn.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                dn.set("modifytime", (Object)TimeServiceHelper.now());
            }
        });
        SaveServiceHelper.save((DynamicObject[])billList);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CheckDetailPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.SAVE.getMultiLangEnumBridge(), (String)OpItemEnum.SAVE.getCode()), new OPDescMultiLangEnumBridge("\u4fdd\u5b58\u5bf9\u8d26\u62a5\u544a\u5907\u6ce8\u6210\u529f", "CheckDetailPlugin_37", "fi-bcm-formplugin", null));
    }

    public void linkReport() {
        this.linkQuery(1);
    }

    public void linkDataTrace() {
        this.linkQuery(2);
    }

    public void linkQuery(int type) {
        super.checkPerm("btn_linkquery", this.getView().getEntityId());
        SpreadSelector selector = this.getSpreadSelector();
        int rowNumber = selector.getStartRow();
        int colNumber = selector.getStartCol();
        Sheet sheet = this.getEffectiveSheet();
        Cell cell = sheet.getCell(rowNumber, colNumber);
        UserObject userObject = cell.getUserObject();
        if (userObject == null || !userObject.containsKey((Object)"dimcombine")) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u8ffd\u6eaf\u3002", (String)"CheckDetailPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.linkQueryLog(message, Boolean.FALSE);
            this.getView().showTipNotification(message);
            return;
        }
        Map dimcombine = (Map)userObject.get((Object)"dimcombine");
        HashMap<String, String> param = new HashMap<String, String>(dimcombine.size());
        for (Map.Entry kv : dimcombine.entrySet()) {
            String value = ((Set)kv.getValue()).stream().map(item -> (String)item.p2).collect(Collectors.joining(","));
            if (((Set)kv.getValue()).size() > 1) {
                String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c\u7684\u7ef4\u5ea6\uff1a%1$s\uff0c\u5b58\u5728\u6709\u591a\u4e2a\u503c\uff1a%2$s\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u8ffd\u6eaf\u3002", (String)"CheckDetailPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), kv.getKey(), value);
                this.linkQueryLog(JSON.toJSONString(param), Boolean.FALSE);
                this.getView().showTipNotification(message);
                return;
            }
            param.put((String)kv.getKey(), value);
            if (!PresetConstant.ENTITY_DIM.equals(kv.getKey())) continue;
            param.put((String)kv.getKey() + "Id", ((Set)kv.getValue()).stream().map(item -> ((Long)item.p1).toString()).collect(Collectors.joining(",")));
        }
        if (type == 1) {
            Set matchTemplates;
            param.remove(PresetConstant.ENTITY_DIM + "Id");
            Map linkParam = LinkQueryUtil.getLinkParam((long)this.getModelId(), param, null);
            if (linkParam == null) {
                this.linkQueryLog(JSON.toJSONString(param), Boolean.FALSE);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c\u627e\u4e0d\u5230\u6709\u5bf9\u5e94\u7ef4\u5ea6\u7ec4\u5408\u7684\u62a5\u8868\u6a21\u677f\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u8ffd\u6eaf\u3002", (String)"CheckDetailPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (linkParam.get("matchTemplates") != null && (matchTemplates = (Set)linkParam.get("matchTemplates")) != null && matchTemplates.size() > 1) {
                this.openLinkByTemplate(userObject, linkParam, param, matchTemplates);
                this.getView().setEnable(Boolean.valueOf(false), ALL_TOOLBAR_BUTTON);
                return;
            }
            this.linkQueryLog(JSON.toJSONString(param), Boolean.TRUE);
            new FormulaLinkShowForm(this.getView(), linkParam, true).showForm();
        } else {
            BigDecimal cellValue = BigDecimal.ZERO;
            if (userObject.containsKey((Object)"money")) {
                cellValue = (BigDecimal)userObject.get((Object)"money");
            }
            param.put("cellValue", cellValue.toString());
            CheckParam checkparam = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCustomParam("model", (Object)this.getModelId());
            showParameter.setCustomParam("year", checkparam.getYear().p1);
            showParameter.setCustomParam("period", checkparam.getPeriod().p1);
            showParameter.setCustomParam("scenario", checkparam.getScene().p1);
            Long cslschemeId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("cslschemeId"));
            showParameter.setCustomParam("schemeId", (Object)cslschemeId);
            HashMap orgNumberIdMap = new HashMap(16);
            if (param.get(PresetConstant.ENTITY_DIM) == null) {
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u8ffd\u6eaf\u3002", (String)"CheckDetailPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.linkQueryLog(message, Boolean.FALSE);
                this.getView().showTipNotification(message);
                return;
            }
            orgNumberIdMap.put(param.get(PresetConstant.ENTITY_DIM), LongUtil.toLong(param.get(PresetConstant.ENTITY_DIM + "Id")));
            showParameter.setCustomParam("orgNumberIdMap", orgNumberIdMap);
            ArrayList<HashMap<String, String>> selectDimCell = new ArrayList<HashMap<String, String>>(16);
            param.remove(PresetConstant.ENTITY_DIM + "Id");
            selectDimCell.add(param);
            showParameter.setCustomParam("selectDimCell", selectDimCell);
            showParameter.setCustomParam("commonMemberList", new HashMap());
            showParameter.setCaption(ResManager.loadKDString((String)"\u5bf9\u8d26\u62a5\u544a\uff1a\u6570\u636e\u8ffd\u6eaf", (String)"CheckDetailPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            showParameter.setFormId("bcm_datatrace");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
            this.linkQueryLog(JSON.toJSONString(param), Boolean.TRUE);
        }
    }

    private void openLinkByTemplate(UserObject userObject, Map<String, Object> linkParam, Map<String, String> param, Set<Long> templates) {
        BigDecimal cellValue = BigDecimal.ZERO;
        if (userObject.containsKey((Object)"money")) {
            cellValue = (BigDecimal)userObject.get((Object)"money");
        }
        if (linkParam.get("numtomems") != null && linkParam.get("numtomems") instanceof Map) {
            Map dimMemberMap = (Map)linkParam.get("numtomems");
            Map dimMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)this.getModelId()));
            HashMap<String, String> value2Key = new HashMap<String, String>(dimMap.size());
            for (Map.Entry entry : dimMap.entrySet()) {
                value2Key.put((String)entry.getValue(), (String)entry.getKey());
            }
            if (dimMemberMap.size() != dimMap.size()) {
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5168\uff0c\u4e0d\u80fd\u8fdb\u884c\u8ffd\u6eaf\u8054\u67e5\u3002", (String)"CheckDetailPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            DataTraceFrom dtf = this.buildDataTraceFrom(cellValue, dimMemberMap, value2Key, templates);
            LinkQueryService linkService = new LinkQueryService(this.getModelId(), this.getView());
            linkService.setPlugin((IFormPlugin)this.getPlugin());
            Map<String, Object> commParam = this.collectCommonParams(param.get("Entity"), param.get("Year"), param.get("Period"), param);
            if (dtf != null) {
                linkService.link(dtf, param, true, commParam);
            }
        }
    }

    private DataTraceFrom buildDataTraceFrom(BigDecimal money, Map<String, String> dimMemberMap, Map<String, String> value2Key, Set<Long> templates) {
        DataTraceFrom dtf = new DataTraceFrom();
        String m = money == null ? null : money.toString();
        dtf.setM(m);
        String d = null;
        StringBuilder sb = new StringBuilder("(");
        for (Map.Entry<String, String> entry : dimMemberMap.entrySet()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append("\"").append(value2Key.get(entry.getKey())).append(".").append(entry.getValue()).append("\"");
        }
        sb.append(")");
        d = sb.toString();
        dtf.setD(d);
        ArrayList<DataTraceFromItem> dataList = new ArrayList<DataTraceFromItem>(8);
        for (Long temp : templates) {
            int i = 1;
            DataTraceFromItem dtfi = new DataTraceFromItem();
            dtfi.setS(Integer.valueOf(++i));
            dtfi.setD(d);
            dtfi.setV(m);
            dtfi.setTi(temp);
            QFilter filter = new QFilter("id", "=", (Object)temp);
            DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"name", (QFilter[])filter.toArray());
            dtfi.setT(template != null ? template.getString("name") : null);
            dataList.add(dtfi);
        }
        dtf.setDf(dataList);
        return dtf;
    }

    private Map<String, Object> collectCommonParams(String org, String yearNum, String periodNum, Map<String, String> memberMap) {
        HashMap<String, Object> commParam = new HashMap<String, Object>(16);
        commParam.put("org", org);
        commParam.put("fy", yearNum);
        commParam.put("period", periodNum);
        commParam.put("model", this.getModelId());
        commParam.put("memberMap", memberMap);
        commParam.put("linkType", "checkDetail");
        return commParam;
    }

    private void linkQueryLog(String param, boolean isSuccess) {
        if (isSuccess) {
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u8054\u67e5", "CheckDetailPlugin_30", "fi-bcm-formplugin", "relationshipQuery"), new OPDescMultiLangEnumBridge("%s\u8054\u67e5\u6210\u529f", "CheckDetailPlugin_35", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{param})));
        } else {
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u8054\u67e5", "CheckDetailPlugin_30", "fi-bcm-formplugin", "relationshipQuery"), new OPDescMultiLangEnumBridge("%s\u8054\u67e5\u5931\u8d25", "CheckDetailPlugin_36", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{param})));
        }
    }

    private void buildSpreadAndData(Sheet sheet, List<Long> ids) {
        SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), spreadKey);
        spreadEasyInvoker.setBatch(true);
        spreadEasyInvoker.addContextMenuItem("linkReport", ResManager.loadKDString((String)"\u8054\u67e5\u62a5\u8868\u6570\u636e", (String)"CheckDetailPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        spreadEasyInvoker.addContextMenuItem("linkDataTrace", ResManager.loadKDString((String)"\u8054\u67e5\u591a\u7ef4\u6570\u636e", (String)"CheckDetailPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        String json = AdjustModelUtil.getEmptyJson(100, 40);
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), spreadKey, json);
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), spreadKey);
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        String createType = (String)this.getView().getFormShowParameter().getCustomParam("createtype");
        Map<Integer, Pair<String, String>> indexSignConfig = CheckHelper.getColumnConfig(modelId, createType);
        Map<String, Integer> signIndexConfig = CheckHelper.buildTableHead(modelId, sheet, indexSignConfig, spreadEasyInvoker);
        this.setColumnWidth(signIndexConfig, 100, spreadEasyInvoker);
        this.buildDetailReport(sheet, ids, signIndexConfig, spreadEasyInvoker);
        spreadEasyInvoker.setFrozenSheet(2, 0, 0, 0, "gray", 0);
        SearchHelper.lockOrUnlockCell(this.getClientViewProxy(), spreadKey, true, 0, 0, sheet.getMaxRowCount() + 1, sheet.getMaxColumnCount());
        if (signIndexConfig.get("mark") != null) {
            SearchHelper.lockOrUnlockCell(this.getClientViewProxy(), spreadKey, false, 2, signIndexConfig.get("mark"), sheet.getMaxRowCount() - 1, 1);
        }
        this.formatValue(sheet, signIndexConfig, spreadEasyInvoker);
        spreadEasyInvoker.startToInvoke();
    }

    private void appendRows(Sheet sheet, int needtotalrows, int currentRow) {
        if (needtotalrows > sheet.getMaxRowCount()) {
            SpreadClientInvoker.appendRows(this.getClientViewProxy(), spreadKey, currentRow, needtotalrows - sheet.getMaxRowCount());
        }
    }

    private void formatValue(Sheet sheet, Map<String, Integer> signIndexConfig, SpreadEasyInvoker spreadEasyInvoker) {
        Set<Integer> cols = signIndexConfig.entrySet().stream().filter(e -> twoPointCol.contains(e.getKey())).map(e -> (Integer)e.getValue()).collect(Collectors.toSet());
        if (cols.size() > 0) {
            Integer scale = this.getUserDefineScale();
            if (scale == null) {
                scale = 2;
            }
            HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
            StringBuilder sb = new StringBuilder("#,##0");
            if (scale > 0) {
                sb.append(".");
            }
            Integer i2 = 0;
            while (i2 < scale) {
                sb.append("0");
                Integer n = i2;
                Integer n2 = i2 = Integer.valueOf(i2 + 1);
            }
            styleMap.put(SpreadProperties.SetCellStyleMethod.FORMAT.k(), sb.toString());
            styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
            ArrayList<Map<String, Object>> rangeList = new ArrayList<Map<String, Object>>(16);
            cols.forEach(i -> this.addToRangMap((List<Map<String, Object>>)rangeList, 2, (int)i, sheet.getMaxRowCount(), 1));
            spreadEasyInvoker.setStyle(rangeList, styleMap);
        }
    }

    private void setColumnWidth(Map<String, Integer> signIndexConfig, int width, SpreadEasyInvoker spreadEasyInvoker) {
        for (Integer col : signIndexConfig.values()) {
            spreadEasyInvoker.setColumnsWidth(col, width);
        }
    }

    private boolean isDiffitem(DynamicObject entry) {
        BigDecimal value1 = entry.getBigDecimal("entrydebit");
        BigDecimal value2 = entry.getBigDecimal("entrycredit");
        return BigDecimal.ZERO.compareTo(value1) == 0 && BigDecimal.ZERO.compareTo(value2) == 0;
    }

    /*
     * WARNING - void declaration
     */
    private void buildDetailReport(Sheet sheet, List<Long> idList, Map<String, Integer> signIndexConfig, SpreadEasyInvoker spreadEasyInvoker) {
        int row;
        ArrayList<Integer> littleSumRowIndex = new ArrayList<Integer>(16);
        ArrayList needMergeColumn = Lists.newArrayList((Object[])new String[]{"adjustnumber", "status", "isautoelim", "modifier", "modifytime", "mark"});
        ArrayList gourpNeedMergeColumn = Lists.newArrayList((Object[])new String[]{"difftype", "ocdiffmoney"});
        ArrayList mergeColumn = Lists.newArrayList((Object[])new String[]{"cvtdifmoney", "diffmode", "diffmethod"});
        boolean isCheckTotalDiffFirst = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isCheckTotalDiffFirst");
        if (isCheckTotalDiffFirst) {
            needMergeColumn.addAll(mergeColumn);
        } else {
            gourpNeedMergeColumn.addAll(mergeColumn);
        }
        Map<Long, DynamicObject> tmplMap = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,checktmpl.checkconfig,checktmpl.issingledc", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}).stream().collect(Collectors.toMap(e -> e.getLong("id"), v -> v));
        IDNumberTreeNode ocNode = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)"OC");
        DynamicObjectCollection userDefineDims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, shortnumber, fieldmapped, issysdimension", (QFilter[])new QFBuilder().add("model", "=", (Object)this.getModelId()).add("issysdimension", "=", (Object)Boolean.FALSE).toArray(), (String)"dseq");
        ArrayList<Map<String, Object>> rangeList = new ArrayList<Map<String, Object>>(16);
        int allRow = row = 2;
        ArrayList groupRangeList = Lists.newArrayList((Object[])new List[]{new ArrayList(16), new ArrayList(16)});
        ArrayList<Map<String, Object>> subTotalRangeList = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> totalRangeList = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection allRecords = new DynamicObjectCollection();
        BatchProcessHelper.batchConsume(idList, (int)10000, t -> allRecords.addAll((Collection)QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", t)})));
        if (allRecords.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5bf9\u8d26\u7ba1\u7406\u4e3b\u9875\u540e\u91cd\u65b0\u6253\u5f00\u3002", (String)"CheckDetailPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List idOrderBy = allRecords.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        ArrayList<FourTuple> allGroupData = new ArrayList<FourTuple>(idOrderBy.size());
        int pages = this.getPages(idOrderBy.size(), 1000);
        for (int index = 0; index < pages; ++index) {
            int n = (index + 1) * 1000;
            n = Math.min(n, idOrderBy.size());
            List subList = idOrderBy.subList(index * 1000, n);
            DynamicObjectCollection checkrecords = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,number,model.id,checktmpl.id,checktmpl.name,checktmpl.number,entity.id,entity.number,entity.name,entity.longnumber,myentity.id,myentity.number,myentity.name,myentity.longnumber, oppositeentity.id,oppositeentity.number,oppositeentity.name,oppositeentity.longnumber,cvtdifmoney, adjustnumber, diffmode, diffmethod,status, isautoelim, modifier.name, modifytime, mark", (QFilter[])new QFilter[]{new QFilter("id", "in", subList)}, (String)ORDER_BY);
            HashMap<Long, DynamicObjectCollection> allEntryMap = new HashMap<Long, DynamicObjectCollection>(subList.size());
            DynamicObjectCollection allEntry = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,entryentity.id as entryid,entryentity.entrydebitaccout.id as entrydebitaccout.id,entryentity.entrymyaccount.id as entrymyaccount.id,entryentity.entrycreditaccout.id as entrycreditaccout.id,entryentity.entrydebit as entrydebit,entryentity.entrycredit as entrycredit,entryentity.entrydebelimval as entrydebelimval,entryentity.entrycreelimval as entrycreelimval,entryentity.entryaudittrail.id as entryaudittrail.id,entryentity.entrychangetype.id as entrychangetype.id,entryentity.entrydim1.id as entrydim1.id,entryentity.entrydim2.id as entrydim2.id,entryentity.entrydim3.id as entrydim3.id,entryentity.entrydim4.id as entrydim4.id,entryentity.entrydim5.id as entrydim5.id,entryentity.entrydim6.id as entrydim6.id,entryentity.entrycompany.id as entrycompany.id,entryentity.entryprocess.id as entryprocess.id,entryentity.entrymultigaap.id as entrymultigaap.id,entryentity.entrydatasort.id as entrydatasort.id,entryentity.entryscene.id as entryscene.id,entryentity.entryyear.id as entryyear.id,entryentity.entryperiod.id as entryperiod.id,entryentity.entrymycompany.id as entrymycompany.id,entryentity.entryorg.id as entryorg.id,entryentity.entrydiffmode as entrydiffmode,entryentity.entrydiffmethod as entrydiffmethod,entryentity.entrymyecmoney as entrymyecmoney,entryentity.entryopecmoney as entryopecmoney,entryentity.entrymycvtpath as entrymycvtpath,entryentity.entryopcvtpath as entryopcvtpath,entryentity.entryocmoney as entryocmoney,entryentity.entrymycvtmoney as entrymycvtmoney,entryentity.entryopcvtmoney as entryopcvtmoney,entryentity.difftype as difftype,entryentity.seq as seq,entryentity.groupkey as groupkey", (QFilter[])new QFilter[]{new QFilter("id", "in", subList)});
            for (DynamicObject dyn : allEntry) {
                DynamicObjectCollection entryDoc = (DynamicObjectCollection)allEntryMap.get(dyn.getLong("id"));
                if (entryDoc == null) {
                    entryDoc = new DynamicObjectCollection();
                    allEntryMap.put(dyn.getLong("id"), entryDoc);
                }
                entryDoc.add((Object)dyn);
            }
            for (DynamicObject checkrecord : checkrecords) {
                void var32_47;
                DynamicObjectCollection entryentity = (DynamicObjectCollection)allEntryMap.get(checkrecord.getLong("id"));
                if (signIndexConfig.get("entryelimmoney") == null && signIndexConfig.get("my_entryelimmoney") == null && signIndexConfig.get("entrydebelimval") == null && signIndexConfig.get("my_entrydebelimval") == null) {
                    entryentity.removeIf(e -> this.isDiffitem((DynamicObject)e));
                }
                entryentity.sort(Comparator.comparing(e -> e.getInt("seq")));
                boolean isMyOp = false;
                if (signIndexConfig.get("my_entryaccount") != null) {
                    isMyOp = true;
                    List<String> list = Arrays.asList("checktmpl", "entity", "myentity", "oppositeentity", "cvtdifmoney", "adjustnumber", "diffmode", "diffmethod", "status", "isautoelim", "modifier", "modifytime", "mark");
                } else {
                    List<String> list = Arrays.asList("checktmpl", "entity", "cvtdifmoney", "adjustnumber", "diffmode", "diffmethod", "status", "isautoelim", "modifier", "modifytime", "mark");
                }
                List<GroupData> groupDataList = CheckDetailHelper.packageRowData(this.getModelId(), entryentity, checkrecord, tmplMap, signIndexConfig, isMyOp, userDefineDims, (String)this.getFormCustomParam("fromPage"));
                int size = groupDataList.stream().mapToInt(e -> e.getData().size()).sum();
                allRow = allRow + size + 1;
                allGroupData.add(new FourTuple((Object)checkrecord, (Object)isMyOp, (Object)var32_47, groupDataList));
            }
        }
        this.appendRows(sheet, allRow, row);
        for (FourTuple fourTuple : allGroupData) {
            DynamicObject checkrecord = (DynamicObject)fourTuple.item1;
            boolean isMyOp = (Boolean)fourTuple.item2;
            boolean isChangeMyop = CheckDetailHelper.isChangeMyop(checkrecord, (String)this.getFormCustomParam("fromPage"));
            List headKeys = (List)fourTuple.item3;
            List groupDataList = (List)fourTuple.item4;
            int lineCount = 0;
            for (int a = 0; a < groupDataList.size(); ++a) {
                GroupData groupData = (GroupData)groupDataList.get(a);
                List data = groupData.getData();
                Map<Long, Map<String, Set<Pair<Long, String>>>> dimCombineMap = groupData.getDimCombineMap();
                for (int i = 0; i < data.size(); ++i) {
                    for (Map.Entry<String, Integer> entry : signIndexConfig.entrySet()) {
                        HashMap<String, Set<Pair<Long, String>>> dimCombineNew;
                        Map<String, Set<Pair<Long, String>>> dimCombine;
                        DynamicObject entryData;
                        String key = entry.getKey();
                        boolean isOp = false;
                        if (key.contains("_")) {
                            String[] s = key.split("_");
                            isOp = "op".equals(s[0]);
                            key = s[1];
                        }
                        if ("cvtdifmoney".equalsIgnoreCase(key) && (isCheckTotalDiffFirst && a != 0 || !isCheckTotalDiffFirst && i != 0) || "ocdiffmoney".equalsIgnoreCase(key) && i != 0) continue;
                        Integer col = entry.getValue();
                        Cell cell = sheet.getCell(row + lineCount + i, col.intValue());
                        if (isMyOp) {
                            Pair pair = (Pair)data.get(i);
                            DynamicObject dynamicObject = entryData = isOp ? (DynamicObject)pair.p2 : (DynamicObject)pair.p1;
                            if (("diffmode".equals(key) || "diffmethod".equals(key) || "difftype".equals(key)) && entryData == null) {
                                entryData = !isOp ? (DynamicObject)pair.p2 : (DynamicObject)pair.p1;
                            }
                        } else {
                            entryData = (DynamicObject)data.get(i);
                        }
                        Object cellValue = CheckDetailHelper.getCellShowValue(this.getModelId(), key, checkrecord, entryData, headKeys, groupData, this.getShowStyle(), isChangeMyop);
                        spreadEasyInvoker.updataValue(row + lineCount + i, col, cellValue);
                        if (entryData != null && "entrycvtmoney".equals(key) && (dimCombine = dimCombineMap.get(entryData.getLong("entryid"))) != null) {
                            IDNumberTreeNode pNode;
                            dimCombineNew = new HashMap<String, Set<Pair<Long, String>>>(dimCombine);
                            if (dimCombineNew.get(PresetConstant.CURRENCY_DIM + "cvt") != null) {
                                dimCombineNew.put(PresetConstant.CURRENCY_DIM, (Set<Pair<Long, String>>)dimCombineNew.get(PresetConstant.CURRENCY_DIM + "cvt"));
                            }
                            dimCombineNew.remove(PresetConstant.CURRENCY_DIM + "cvt");
                            Set processPair = (Set)dimCombineNew.get(PresetConstant.PROCESS_DIM);
                            if (processPair.size() > 0 && ("ADJ".equals(((Pair)new ArrayList<E>(processPair).get((int)0)).p2) || "ARPT".equals(((Pair)new ArrayList<E>(processPair).get((int)0)).p2)) && (pNode = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)("T" + (String)((Pair)new ArrayList<E>(processPair).get((int)0)).p2))).getId() != -1L) {
                                dimCombineNew.put(PresetConstant.PROCESS_DIM, Sets.newHashSet((Object[])new Pair[]{Pair.onePair((Object)pNode.getId(), (Object)pNode.getNumber())}));
                            }
                            cell.setUserObject("dimcombine", dimCombineNew);
                        }
                        if (entryData != null && "entryecmoney".equals(key) && (dimCombine = dimCombineMap.get(entryData.getLong("entryid"))) != null) {
                            dimCombineNew = new HashMap<String, Set<Pair<Long, String>>>(dimCombine);
                            dimCombineNew.remove(PresetConstant.CURRENCY_DIM + "cvt");
                            cell.setUserObject("dimcombine", dimCombineNew);
                        }
                        if (entryData != null && "entryocmoney".equals(key) && (dimCombine = dimCombineMap.get(entryData.getLong("entryid"))) != null) {
                            dimCombineNew = new HashMap<String, Set<Pair<Long, String>>>(dimCombine);
                            dimCombineNew.put(PresetConstant.CURRENCY_DIM, Sets.newHashSet((Object[])new Pair[]{Pair.onePair((Object)ocNode.getId(), (Object)ocNode.getNumber())}));
                            dimCombineNew.remove(PresetConstant.CURRENCY_DIM + "cvt");
                            cell.setUserObject("dimcombine", dimCombineNew);
                        }
                        if ("adjustnumber".equalsIgnoreCase(key)) {
                            this.addToRangMap(rangeList, row + lineCount + i, col, 1, 1);
                        }
                        if ((sumCol.contains(key) || "entryocmoney".equals(key)) && entryData != null) {
                            cell.setUserObject("money", cellValue);
                        }
                        if (!"mark".equalsIgnoreCase(key)) continue;
                        cell.setUserObject("billId", (Object)checkrecord.getString("id"));
                        cell.setValue(cellValue);
                    }
                }
                for (String sign : gourpNeedMergeColumn) {
                    if (signIndexConfig.get(sign) == null) continue;
                    spreadEasyInvoker.setSpan(row + lineCount, signIndexConfig.get(sign), data.size(), 1);
                }
                this.addToRangMap((List)groupRangeList.get(a % 2), row + lineCount, 0, data.size(), signIndexConfig.size());
                lineCount += data.size();
            }
            for (String string : needMergeColumn) {
                if (signIndexConfig.get(string) == null) continue;
                spreadEasyInvoker.setSpan(row, signIndexConfig.get(string), lineCount, 1);
            }
            spreadEasyInvoker.updataValue(row + lineCount, signIndexConfig.get("checktmpl"), ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CheckDetailPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            spreadEasyInvoker.setSpan(row + lineCount, signIndexConfig.get("checktmpl"), 1, 2);
            spreadEasyInvoker.updataValue(row + lineCount, signIndexConfig.get("cvtdifmoney"), checkrecord.getBigDecimal("cvtdifmoney"));
            sheet.getCell(row + lineCount, signIndexConfig.get("cvtdifmoney").intValue()).setUserObject("littleSum", (Object)checkrecord.getBigDecimal("cvtdifmoney"));
            littleSumRowIndex.add(row + lineCount);
            for (Map.Entry entry : signIndexConfig.entrySet()) {
                String sign = (String)entry.getKey();
                String key = sign.contains("_") ? sign.split("_")[1] : sign;
                if (!sumCol.contains(key)) continue;
                BigDecimal sum = new BigDecimal(0);
                for (int i = row; i < row + lineCount; ++i) {
                    Cell moneyCell = sheet.getCell(i, ((Integer)entry.getValue()).intValue());
                    BigDecimal money = (BigDecimal)moneyCell.getUserObject("money", (Object)BigDecimal.ZERO);
                    sum = sum.add(money);
                }
                spreadEasyInvoker.updataValue(row + lineCount, (Integer)entry.getValue(), sum);
                sheet.getCell(row + lineCount, ((Integer)entry.getValue()).intValue()).setUserObject("littleSum", (Object)sum);
            }
            this.addToRangMap(subTotalRangeList, row + lineCount, 0, 1, signIndexConfig.size());
            this.setCellRecordInfo(row, row + lineCount, sheet, checkrecord);
            row = row + lineCount + 1;
        }
        spreadEasyInvoker.updataValue(row, signIndexConfig.get("checktmpl"), ResManager.loadKDString((String)"\u603b\u8ba1", (String)"CheckDetailPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        spreadEasyInvoker.setSpan(row, signIndexConfig.get("checktmpl"), 1, 2);
        this.addToRangMap(totalRangeList, row, 0, 1, signIndexConfig.size());
        for (Map.Entry entry : signIndexConfig.entrySet()) {
            String sign = (String)entry.getKey();
            String key = sign.contains("_") ? sign.split("_")[1] : sign;
            if (!sumCol.contains(key)) continue;
            BigDecimal sum = new BigDecimal(0);
            for (Integer r : littleSumRowIndex) {
                Cell moneyCell = sheet.getCell(r.intValue(), ((Integer)entry.getValue()).intValue());
                BigDecimal money = (BigDecimal)moneyCell.getUserObject("littleSum", (Object)BigDecimal.ZERO);
                sum = sum.add(money);
            }
            spreadEasyInvoker.updataValue(row, (Integer)entry.getValue(), sum);
        }
        BigDecimal diffSum = new BigDecimal(0);
        for (Integer r : littleSumRowIndex) {
            Cell moneyCell = sheet.getCell(r.intValue(), signIndexConfig.get("cvtdifmoney").intValue());
            BigDecimal money = (BigDecimal)moneyCell.getUserObject("littleSum", (Object)BigDecimal.ZERO);
            diffSum = diffSum.add(money);
        }
        spreadEasyInvoker.updataValue(row, signIndexConfig.get("cvtdifmoney"), diffSum);
        ++row;
        spreadEasyInvoker.setStyle((List)groupRangeList.get(0), GROUP_STYLE.get(0));
        spreadEasyInvoker.setStyle((List)groupRangeList.get(1), GROUP_STYLE.get(1));
        spreadEasyInvoker.setStyle(subTotalRangeList, SUBTOTAL_STYLE);
        spreadEasyInvoker.setStyle(totalRangeList, TOTAL_STYLE);
        spreadEasyInvoker.setHyperLinkCellSimple(rangeList, "openDataEntry");
        this.setAlignStyle(2, row, signIndexConfig, spreadEasyInvoker);
        CheckHelper.setSpreadBorder(0, 0, row, signIndexConfig.size(), spreadEasyInvoker);
        this.setSpreadFilter(2, 0, row, signIndexConfig.size());
    }

    private void setAlignStyle(int rowStart, int rowEnd, Map<String, Integer> signIndexConfig, SpreadEasyInvoker spreadEasyInvoker) {
        ArrayList<Map<String, Object>> centerRangeList = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> rightRangeList = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> remarkRangeList = new ArrayList<Map<String, Object>>(16);
        for (Map.Entry<String, Integer> entry : signIndexConfig.entrySet()) {
            String key = entry.getKey();
            if (key.contains("_")) {
                key = key.split("_")[1];
            }
            if ("mark".equals(key)) {
                this.addToRangMap(remarkRangeList, rowStart, entry.getValue(), rowEnd, 1);
                continue;
            }
            if (numberCols.contains(key)) {
                this.addToRangMap(rightRangeList, rowStart, entry.getValue(), rowEnd, 1);
                continue;
            }
            this.addToRangMap(centerRangeList, rowStart, entry.getValue(), rowEnd, 1);
        }
        spreadEasyInvoker.setStyle(centerRangeList, centerStyleMap);
        spreadEasyInvoker.setStyle(rightRangeList, rightStyleMap);
        spreadEasyInvoker.setStyle(remarkRangeList, remarkStyleMap);
    }

    public void addToRangMap(List<Map<String, Object>> rangeList, int r, int c, int rc, int cc) {
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.R.k(), r);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.C.k(), c);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.CC.k(), cc);
        rangeList.add(rangeMap);
    }

    public int getPages(int totalSize, int pageSize) {
        if (totalSize < 1) {
            return 1;
        }
        if (totalSize < pageSize) {
            return 1;
        }
        return totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
    }

    private void setCellRecordInfo(int rowStart, int rowEnd, Sheet sheet, DynamicObject checkrecord) {
        for (int i = rowStart; i <= rowEnd; ++i) {
            Cell cell = sheet.getCell(i, 0);
            cell.setUserObject("k", (Object)checkrecord.getLong("id"));
        }
    }

    private Integer getUserDefineScale() {
        String scaleStr = this.getPageCache().get("checkScale");
        if (StringUtils.isNotBlank((CharSequence)scaleStr)) {
            try {
                int scale = Integer.parseInt(kd.bos.util.StringUtils.trim((String)scaleStr));
                if (scale >= 0 & scale <= 10) {
                    return scale;
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u7528\u6237\u81ea\u5b9a\u4e49\u7684\u7cbe\u5ea6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
        return null;
    }

    void setSpreadFilter(int r, int c, int rc, int cc) {
        HashMap<String, Integer> range = new HashMap<String, Integer>(16);
        range.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        range.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        range.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        range.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        SpreadClientInvoker.invokeSetRowFilterMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList((Object[])new Map[]{range}));
    }

    public void openDataEntry() {
        super.doCheckPermission("bcm_rptadjust_list", "47150e89000000ac", Long.valueOf(this.getModelId()), this.getBizAppId());
        Cell cell = this.getEffectiveSheet().getCell(this.getSpreadSelector().getStartRow(), 0);
        DynamicObject checkRecord = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"id,number,model.id,scene.id,year.id,period.id,adjustnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", cell.getUserObject().get((Object)"k"))});
        if (checkRecord == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckMainPagePlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        CheckHelper.openAdjustPage(checkRecord.getLong("model.id"), checkRecord.getLong("id"), this);
    }

    private void actionDiffProcess() {
        Set<Long> idSet = this.getCurrentPageSelect();
        if (idSet.size() > 0) {
            long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
            ArrayList ids = new ArrayList(idSet.size());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,diffmode,entity,entity.number,scene.id,year.id,period.id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
            dynamicObjects.forEach(e -> ids.add(e.get("id")));
            if (ids.size() != idSet.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckMainPagePlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            String pageId = this.getView().getPageId() + ids.get(0);
            if (mainPageView == null || mainPageView.getView(pageId) == null || parentView == null) {
                mainPageView = mainPageView == null ? this.getView() : mainPageView;
                FormShowParameter param = new FormShowParameter();
                param.setFormId("bcm_checkbalance");
                param.setPageId(pageId);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.getOpenStyle().setTargetKey("_submaintab_");
                param.setCustomParam("KEY_MODEL_ID", (Object)modelId);
                param.setCustomParam("KEY_SCENARIO_ID", (Object)((DynamicObject)dynamicObjects.get(0)).getLong("scene.id"));
                param.setCustomParam(KEY_YEAR_ID, (Object)((DynamicObject)dynamicObjects.get(0)).getLong("year.id"));
                param.setCustomParam(KEY_PERIOD_ID, (Object)((DynamicObject)dynamicObjects.get(0)).getLong("period.id"));
                param.setCustomParam("checkParam", this.getFormCustomParam("checkParam"));
                param.setCustomParam("rows", ids);
                param.setCustomParam("parentLongNumber", (Object)EntityServiceHelper.getSecondLongNumber((String)TreeStructureServiceHelper.getLongNumber((String)"bcm_entitymembertree", (Long)((DynamicObject)dynamicObjects.get(0)).getLong("entity"))));
                param.setCaption(ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02\u5904\u7406", (String)"CheckMainPagePlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                if (parentView == null) {
                    this.getView().showForm(param);
                    this.getView().sendFormAction(mainPageView);
                } else {
                    parentView.showForm(param);
                    this.getView().sendFormAction(parentView);
                }
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"CheckDetailPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void actionUnAudit() {
        Set<Long> idSet = this.getCurrentPageSelect();
        if (!idSet.isEmpty()) {
            long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
            DynamicObjectCollection dos = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,number,myentity.name,checktmpl.name, status, diffmode, isautoelim,entity.id,entity.number,entity.name,checktmpl.id,checktmpl.number,checktmpl.isenable", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
            if (null == dos || dos.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u3002", (String)"CheckMainPagePlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            PermissionService permissionService = PermissionServiceImpl.getInstance((Long)this.getModelId());
            Long entityDimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.ENTITY_DIM);
            for (DynamicObject dynamicObject : dos) {
                if (!permissionService.isAllReadPerm(entityDimensionId, "bcm_entitymembertree", (Collection)Sets.newHashSet((Object[])new Long[]{dynamicObject.getLong("entity.id")}))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u7ec4\u7ec7 %s \u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CheckMainPagePlugin_74", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dynamicObject.getString("entity.number")));
            }
            boolean periodManage = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012");
            if (periodManage && !CheckHelper.isStatusAllOpen(new ArrayList<Long>(idSet), this, modelId)) {
                return;
            }
            CheckParam checkParam = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
            CheckHelper.isExistArchiving(this.getModelId(), (String)checkParam.getScene().p2, (String)checkParam.getYear().p2, (String)checkParam.getPeriod().p2);
            this.checkAllInOneStatus(dos);
            CheckHelper.groupAndUnAuditRecords(this, dos, checkParam);
            this.refreshSpread();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"CheckDetailPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void actionExport() {
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObjectCollection dos = new DynamicObjectCollection();
        BatchProcessHelper.batchConsume(new ArrayList(ids), (int)10000, t -> dos.addAll((Collection)QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", t)})));
        if (CollectionUtils.isEmpty((Collection)dos) || dos.size() != ids.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5bf9\u8d26\u7ba1\u7406\u4e3b\u9875\u540e\u91cd\u65b0\u6253\u5f00\u3002", (String)"CheckDetailPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "CheckMainPagePlugin_44", "fi-bcm-formplugin", "export");
        try {
            HashMap<String, String> map2 = new HashMap<String, String>(16);
            map2.put(SpreadProperties.ExportExcelFileMethod.FILENAME.k(), ResManager.loadKDString((String)"\u660e\u7ec6\u5bf9\u8d26\u62a5\u544a", (String)"CheckDetailPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            SpreadClientInvoker.invokeExportExcelFileMethod(this.getClientViewProxy(), spreadKey, map2);
            this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u660e\u7ec6\u5bf9\u8d26\u62a5\u544a\u6210\u529f\u3002", "CheckMainPagePlugin_85", "fi-bcm-formplugin", null));
        }
        catch (Exception e) {
            this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u660e\u7ec6\u5bf9\u8d26\u62a5\u544a\u5931\u8d25\u3002", "CheckMainPagePlugin_86", "fi-bcm-formplugin", null));
            log.error(ThrowableHelper.toString((Exception)e));
        }
    }

    private void checkAllInOneStatus(DynamicObjectCollection dos) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long model = Long.valueOf(customParams.get("KEY_MODEL_ID").toString());
        Long scenario = Long.valueOf(customParams.get("KEY_SCENARIO_ID").toString());
        Long year = Long.valueOf(customParams.get(KEY_YEAR_ID).toString());
        Long period = Long.valueOf(customParams.get(KEY_PERIOD_ID).toString());
        Map<String, String> nameMap = dos.stream().collect(Collectors.toMap(e -> e.getString("entity.number"), e -> e.getString("entity.name"), (k1, k2) -> k1));
        Map orgStatus = AllInOneUtils.isSubmittedBatch((Long)model, (Collection)dos.stream().map(e -> e.getString("entity.number")).collect(Collectors.toSet()), (Object)scenario, (Object)year, (Object)period);
        for (Map.Entry entry : orgStatus.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9 %1$s %2$S \u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u72b6\u6001\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5bf9\u8d26\u5206\u5f55\u6570\u636e\u3002", (String)"CheckMainPagePlugin_80", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entry.getKey(), nameMap.get(entry.getKey())));
        }
    }

    private String getShowStyle() {
        String parentShowstyle = this.getView().getParentView().getPageCache().get("showstyle");
        if (StringUtils.isNotEmpty((CharSequence)parentShowstyle)) {
            return parentShowstyle;
        }
        return (String)this.getView().getFormShowParameter().getCustomParam("showstyle");
    }
}

