/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.mvc.list.ListUserConfig;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.bcm.business.allinone.util.AllInOneUtils;
import kd.fi.bcm.business.check.CheckContext;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.CheckResult;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.helper.CheckServiceHelper;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CheckCreateTypeEnum;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.ScenarioMemberEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.check.CheckDetailExport;
import kd.fi.bcm.formplugin.check.CheckHelper;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CheckMainPagePlugin
extends AbstractTemplateBasePlugin
implements DynamicPage,
HyperLinkClickListener,
IListPlugin {
    public static final String MY_ORG_LIST_KEY = "check-myorglist";
    public static final String CREATE_TYPE_KEY = "check-ct";
    private static final Set<String> AND_CONDITION_SET = Sets.newHashSet((Object[])new String[]{"<>", "not like", "is not null"});
    public static final String CHECK_CSLSCHEME = "check-cslscheme";
    private static String spreadKey = "report";
    private static final String ctl_billlistap = "billlistap";
    private final List<String> dimKeys = Arrays.asList("scenario", "year", "period");
    private static String SHOW_STYLE = "showstyle";
    private static final String KEY_YEAR_ID = "KEY_YEAR_ID";
    private static final String KEY_PERIOD_ID = "KEY_PERIOD_ID";
    private static final String KEY_ADMINUSERBOL = "adminUserBol";
    private static final String KEY_ALLCHECKTMPLPERMMAP = "allCheckTmplPermMap";
    private static final String KEY_NOPERMCHECKTMPL = "nopermchecktmpl";
    private static final String KEY_READONLYCHECKTMPL = "readonlychecktmpl";
    private static final String KEY_READWRITEHECKTMPL = "readwritechecktmpl";
    private static final String KEY_ISROOT = "isroot";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final List<String> adjColumns = Arrays.asList("adjustnumber", "diffmode", "diffmethod", "status", "isautoelim");
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(CheckMainPagePlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(this.dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        this.bcmInit();
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.addCreateListColumnsListener(this::beforeCreateListColumns);
        billList.addPackageDataListener(evt -> this.packData((PackageDataEvent)evt));
        this.addBillCreateListDataProviderListener(billList);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener(this::setFilter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("myorg", "opporg");
        this.addItemClickListeners("toolbarap");
        BasedataEdit currencyEdit = (BasedataEdit)this.getControl("currency");
        currencyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cslschemeEdit = (BasedataEdit)this.getControl("cslscheme");
        cslschemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void addBillCreateListDataProviderListener(BillList billList) {
        billList.addCreateListDataProviderListener(evt -> evt.setListDataProvider((IListDataProvider)new AbstractBaseListPlugin.LangListDataProvider(){

            public QueryResult getQueryResult() {
                QueryResult qr = super.getQueryResult();
                List sumResults = qr.getSummaryResults();
                if (sumResults != null) {
                    Integer scale = CheckMainPagePlugin.this.getUserDefineScale();
                    scale = scale == null ? Integer.valueOf(2) : scale;
                    for (SummaryResult sumResult : sumResults) {
                        if (sumResult.getNumberPrecision() == null) continue;
                        sumResult.getNumberPrecision().setPrecision(scale.intValue());
                    }
                }
                return qr;
            }
        }));
    }

    @Override
    public IPageCache getPageCache() {
        return this.getView().getPageCache();
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        if (qFilters.size() > 1) {
            for (int i = 1; i < qFilters.size(); ++i) {
                QFilter qFilter = (QFilter)qFilters.get(i);
                QFilter newQFilter = this.rebuildQFilter(qFilter);
                qFilters.set(i, newQFilter);
            }
        }
    }

    private QFilter rebuildQFilter(QFilter qFilter) {
        ArrayList<QFilter> allQFilter = new ArrayList<QFilter>(16);
        allQFilter.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter temp = nest.getFilter();
            if ((QEmptyValue.value == temp.getValue() || temp.isCP("is null")) && !nest.isAnd()) continue;
            allQFilter.add(new QFilter(temp.getProperty(), temp.getCP(), temp.getValue()));
        }
        QFilter newQFilter = new QFilter("1", "=", (Object)1);
        for (QFilter filter : allQFilter) {
            String property = filter.getProperty();
            String cp = filter.getCP();
            Object value = filter.getValue();
            if ("checktmpl.name".equals(property) || "entity.name".equals(property) || "myentity.name".equals(property) || "oppositeentity.name".equals(property)) {
                property = property.replace(".name", ".number");
                if (AND_CONDITION_SET.contains(cp)) {
                    filter.and(property, cp, value);
                } else {
                    filter.or(property, cp, value);
                }
            }
            newQFilter.and(filter);
        }
        return newQFilter;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Object createtype = this.getModel().getValue("createtype");
        args.getListColumns().forEach(e -> {
            if (adjColumns.contains(e.getListFieldKey())) {
                e.setVisible(Objects.equals(CheckCreateTypeEnum.CHECK_CREATE.value, createtype) ? 0 : 63);
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setStatus(OperationStatus.ADDNEW);
        this.loadPageRowFromDB();
        this.getPageCache().put(SHOW_STYLE, "numbername");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"matrixshow"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("myorg")) {
            this.getModel().setValue("model", (Object)LongUtil.toLong(customParams.get("modelId")));
            this.initCheckTmplPerm();
            this.getModel().setValue("cslscheme", (Object)LongUtil.toLong(customParams.get("cslscheme")));
            this.getModel().setValue("scenario", (Object)LongUtil.toLong(customParams.get("scenarioId")));
            this.getModel().setValue("year", (Object)LongUtil.toLong(customParams.get("yearId")));
            this.getModel().setValue("period", (Object)LongUtil.toLong(customParams.get("periodId")));
            JSONObject myorg = (JSONObject)customParams.get("myorg");
            String myorgName = myorg.getJSONObject(NAME).getString("zh_CN");
            ArrayList list = new ArrayList(1);
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put(ID, myorg.getString(ID));
            map.put("scope", "10");
            map.put(NUMBER, myorg.getString(NUMBER));
            map.put(NAME, myorgName);
            list.add(map);
            this.getPageCache().put("myorg", SerializationUtils.toJsonString(list));
            this.getPageCache().put("myorgCache", myorg.getString(ID) + ";10");
            this.getModel().setValue("myorg", (Object)myorgName);
            this.getModel().setValue("process", (Object)"ARPT");
            this.setOffsetType();
            this.changeCheckTmpByOffsetType();
            QFilter qf = new QFilter("model", "=", (Object)LongUtil.toLong(customParams.get("modelId")));
            qf.and("scenario", "=", (Object)LongUtil.toLong(customParams.get("scenarioId")));
            qf.and(NUMBER, "=", customParams.get("checkImpdNumber"));
            DynamicObject checkImp = QueryServiceHelper.queryOne((String)"bcm_checktmpl", (String)"id,templatecatalog.number", (QFilter[])new QFilter[]{qf});
            if (checkImp != null) {
                this.getModel().setValue("offsettype", checkImp.get("templatecatalog.number"));
                this.getModel().setValue("checktmp", checkImp.get(ID));
            }
            this.changeCreateType(null);
            this.refreshData(true);
        } else {
            String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
            if (modelId == null) {
                this.refreshBillList(false);
                return;
            }
            this.getModel().setValue("model", (Object)modelId);
            this.setOffsetType();
            this.initCheckTmplPerm();
            this.setUserSelectF7Value(modelId);
            this.changeCheckTmpByOffsetType();
            this.refreshBillList(false);
        }
        this.setBtnVisible(this.getModelId());
    }

    private void setBtnVisible(Long modelId) {
        BarItemAp barItemAp = new BarItemAp();
        barItemAp.setKey("btn_diffprocess");
        barItemAp.setId("btn_diffprocess");
        barItemAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5dee\u5f02\u5904\u7406", (String)"CheckMainPagePlugin_99", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        barItemAp.setOperationStyle(Integer.valueOf(1));
        CheckHelper.initDiffButton(modelId, this.getView(), barItemAp, true, 2);
        this.getPageCache().put("checkScale", ConfigServiceHelper.getStringParam((Long)modelId, (String)"checkScale"));
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        Object pkId = list.getFocusRowPkId();
        DynamicObject checkRecord = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"id,number,adjustnumber", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)LongUtil.toLong((Object)pkId))});
        if (checkRecord == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u3002", (String)"CheckMainPagePlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String fieldName = hyperLinkClickEvent.getFieldName();
        OPDescMultiLangEnumBridge opDesc = new OPDescMultiLangEnumBridge("\u660e\u7ec6\u62a5\u544a\u67e5\u770b\u6210\u529f\u3002", "CheckMainPagePlugin_1", "fi-bcm-formplugin", null);
        switch (fieldName) {
            case "adjustnumber": {
                super.doCheckPermission("bcm_rptadjust_list", "47150e89000000ac", Long.valueOf(this.getModelId()), this.getBizAppId());
                CheckHelper.openAdjustPage(this.getModelId(), checkRecord.getLong(ID), this);
                opDesc = new OPDescMultiLangEnumBridge("\u67e5\u770b\u5bf9\u8d26\u5206\u5f55\u6210\u529f\u3002", "CheckMainPagePlugin_87", "fi-bcm-formplugin", null);
                break;
            }
            default: {
                this.openCheckDetailPage(Lists.newArrayList((Object[])new Long[]{LongUtil.toLong((Object)pkId)}));
            }
        }
    }

    private void packData(PackageDataEvent e) {
        String showStyle = this.getPageCache().get(SHOW_STYLE);
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String key = ((ColumnDesc)e.getSource()).getKey();
            if ("myentity.name".equals(key) || "oppositeentity.name".equals(key) || "entity.name".equals(key) || "checktmpl.name".equals(key)) {
                String preffix = key.split("\\.")[0];
                if (NUMBER.equals(showStyle)) {
                    e.setFormatValue((Object)e.getRowData().getString(preffix + ".number"));
                } else if (NAME.equals(showStyle)) {
                    e.setFormatValue((Object)e.getRowData().getString(preffix + ".name"));
                } else if ("numbername".equals(showStyle)) {
                    e.setFormatValue((Object)(e.getRowData().getString(preffix + ".number") + "|" + e.getRowData().getString(preffix + ".name")));
                }
            } else if ("cvtdifmoney".equals(key) || "opcvtmoney".equals(key) || "opecmoney".equals(key) || "mycvtmoney".equals(key) || "myecmoney".equals(key)) {
                BigDecimal bigDecimal = e.getRowData().getBigDecimal(key);
                Integer scale = this.getUserDefineScale();
                DecimalFormat decimalFormat = null;
                if (scale != null) {
                    decimalFormat = new DecimalFormat();
                    decimalFormat.setMinimumFractionDigits(scale);
                    decimalFormat.setMaximumFractionDigits(scale);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                } else {
                    decimalFormat = new DecimalFormat("#,###.###############");
                }
                e.setFormatValue((Object)decimalFormat.format(bigDecimal));
            }
        }
    }

    private Integer getUserDefineScale() {
        String scaleStr = this.getPageCache().get("checkScale");
        if (StringUtils.isBlank((CharSequence)scaleStr)) {
            return null;
        }
        try {
            Integer scale = Integer.valueOf(StringUtils.trim((String)scaleStr));
            if (scale >= 0 & scale <= 10) {
                return scale;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7528\u6237\u81ea\u5b9a\u4e49\u7684\u7cbe\u5ea6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
        }
        return null;
    }

    private void openCheckDetailPage(List<Long> ids) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,diffmode,entity,entity.number", (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
        if (dynamicObjects.size() != ids.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckMainPagePlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String obId = String.join((CharSequence)"_", ids.stream().map(e -> e.toString()).collect(Collectors.toList()));
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = this.getView().getPageId() + "_" + this.getBizAppId() + "_" + this.getUserId() + "_" + obId.hashCode();
        if (mainPageView == null || mainPageView.getView(pageId) == null || parentView == null) {
            mainPageView = mainPageView == null ? this.getView() : mainPageView;
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bcm_checkdetail");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCustomParam(ID, ids);
            param.setPageId(pageId);
            param.getOpenStyle().setTargetKey("_submaintab_");
            param.setCustomParam("model", (Object)this.getModelId());
            param.setCustomParam("createtype", this.getModel().getValue("createtype"));
            param.setCustomParam("KEY_ISROOT", (Object)this.getPageCache().get(KEY_ISROOT));
            Long cslschemeId = this.getModel().getValue("cslscheme") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("cslscheme")).getLong(ID));
            param.setCustomParam("cslschemeId", cslschemeId);
            param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            param.setCustomParam("KEY_SCENARIO_ID", (Object)((DynamicObject)this.getModel().getValue(this.dimKeys.get(0))).getString(ID));
            param.setCustomParam(KEY_YEAR_ID, (Object)((DynamicObject)this.getModel().getValue(this.dimKeys.get(1))).getString(ID));
            param.setCustomParam(KEY_PERIOD_ID, (Object)((DynamicObject)this.getModel().getValue(this.dimKeys.get(2))).getString(ID));
            Pair org = Pair.onePair((Object)((DynamicObject)dynamicObjects.get(0)).getLong("entity"), (Object)((DynamicObject)dynamicObjects.get(0)).getString("entity.number"));
            CheckParam checkParam = this.getCheckParam((Pair<Long, String>)org, true);
            param.setCustomParam("checkParam", (Object)ObjectSerialUtil.toByteSerialized((Object)checkParam));
            param.setCustomParam(SHOW_STYLE, (Object)this.getPageCache().get(SHOW_STYLE));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openPage"));
            if (parentView == null) {
                this.getView().showForm(param);
                this.getView().sendFormAction(mainPageView);
            } else {
                parentView.showForm(param);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String process = (String)this.getModel().getValue("process");
        if (key.startsWith("btn_aobo")) {
            this.doCheckPermission("bcm_checkmainpage", "1G9LZYEWTWGV", this.getModelId(), this.getBizAppId());
            Pair<DiffModeEnum, DiffMethodEnum> diffPair = CheckHelper.getDiffPairByBinSign(key);
            this.actionBatchDiffProcess(diffPair);
            return;
        }
        switch (key) {
            case "btn_unaudit": {
                this.actionUnAudit();
                break;
            }
            case "btn_diffprocess": {
                if ("ARPT".equals(process)) {
                    this.actionDiffProcess(this.getSelectEntry());
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u7a0b\u4e3a\u5408\u5e76\u8c03\u6574\u540e\u624d\u53ef\u5bf9\u8d26\u62b5\u9500", (String)"CheckMainPagePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_check": {
                this.actionCheck(false);
                break;
            }
            case "btn_checkandadjust": {
                if ("ARPT".equals(process)) {
                    this.actionCheck(true);
                    break;
                }
                this.getModel().setValue("process", (Object)ScenarioMemberEnum.ARPT);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u7a0b\u4e3a\u5408\u5e76\u8c03\u6574\u540e\u624d\u53ef\u5bf9\u8d26\u62b5\u9500,\u5df2\u81ea\u52a8\u8c03\u6574\u8fc7\u7a0b\u4e3a\u5408\u5e76\u8c03\u6574\u540e\u3002", (String)"CheckMainPagePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_hidenodata": {
                this.hideNoDataCell();
                break;
            }
            case "btn_refresh": {
                this.setBtnVisible(this.getModelId());
                this.refreshData(true);
                break;
            }
            case "btn_rev": {
                this.refreshData(true);
                break;
            }
            case "detail_report": {
                List<Long> ids = this.getSelectRowIds();
                if (ids == null) {
                    return;
                }
                this.openCheckDetailPage(ids);
                break;
            }
            case "sum_report": {
                this.openCheckSumPage();
                break;
            }
            case "btn_export": {
                this.actionExport();
                break;
            }
            case "btn_oldcheck": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_checkrecordlist");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
                break;
            }
            case "btn_shownumber": {
                this.getPageCache().put(SHOW_STYLE, NUMBER);
                this.refreshData(true);
                break;
            }
            case "btn_showname": {
                this.getPageCache().put(SHOW_STYLE, NAME);
                this.refreshData(true);
                break;
            }
            case "btn_shownumbername": {
                this.getPageCache().put(SHOW_STYLE, "numbername");
                this.refreshData(true);
                break;
            }
            case "btn_exportdetail": {
                this.exportDetail();
                break;
            }
            case "btn_exportdetailUnitTest": {
                this.exportDetailUnitTest();
                break;
            }
            case "btn_batchfetchbigUnitTest": {
                this.actionBatchDiffProcess((Pair<DiffModeEnum, DiffMethodEnum>)Pair.onePair((Object)DiffModeEnum.BIG, (Object)DiffMethodEnum.DIFFITEM), false);
                break;
            }
            case "btn_smartnotice": {
                CheckHelper.openCheckSmartNoticePage(this.getModelId(), this.getSelectRowIds(), this.getView(), (IFormPlugin)this);
                break;
            }
        }
    }

    private void openCheckSumPage() {
        if (!this.checkParams(true)) {
            return;
        }
        Pair<List<Pair<Long, String>>, StringBuilder> mergeEntityPair = this.filterCompanyByPerm(false, "myorg");
        if (mergeEntityPair.p2 != null && ((StringBuilder)mergeEntityPair.p2).length() > 0) {
            this.getView().showTipNotification(((StringBuilder)mergeEntityPair.p2).toString());
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)mergeEntityPair.p1))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u65b9\u5355\u4f4d\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5408\u5e76\u8282\u70b9\u3002", (String)"CheckMainPagePlugin_93", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Pair orgPair = (Pair)((List)mergeEntityPair.p1).get(0);
        CheckParam checkParam = this.getCheckParam((Pair<Long, String>)orgPair, true);
        Long cslschemeId = this.getModel().getValue("cslscheme") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("cslscheme")).getLong(ID));
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        ArrayList<Object> keys = new ArrayList<Object>(Arrays.asList((Object[])checkParam.getCheckTmpl().p1));
        keys.add(checkParam.getModel().p1);
        keys.add(cslschemeId);
        keys.add(checkParam.getScene().p1);
        keys.add(checkParam.getYear().p1);
        keys.add(checkParam.getPeriod().p1);
        String keyStr = keys.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining("_"));
        String obId = ((List)mergeEntityPair.p1).stream().map(e -> ((Long)e.p1).toString()).collect(Collectors.joining("_"));
        String pageId = this.getView().getPageId() + "_" + this.getBizAppId() + "_" + this.getUserId() + "_" + (keyStr + obId).hashCode();
        if (mainPageView == null || mainPageView.getView(pageId) == null || parentView == null) {
            mainPageView = mainPageView == null ? this.getView() : mainPageView;
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bcm_checksumreport");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setPageId(pageId);
            param.setCustomParam("createtype", this.getModel().getValue("createtype"));
            param.setCustomParam("KEY_ISROOT", (Object)this.getPageCache().get(KEY_ISROOT));
            param.setCustomParam("cslschemeId", (Object)cslschemeId);
            param.setCustomParam("KEY_SCENARIO_ID", (Object)((DynamicObject)this.getModel().getValue(this.dimKeys.get(0))).getString(ID));
            param.setCustomParam(KEY_YEAR_ID, (Object)((DynamicObject)this.getModel().getValue(this.dimKeys.get(1))).getString(ID));
            param.setCustomParam(KEY_PERIOD_ID, (Object)((DynamicObject)this.getModel().getValue(this.dimKeys.get(2))).getString(ID));
            param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            param.setCustomParam(SHOW_STYLE, (Object)this.getPageCache().get(SHOW_STYLE));
            checkParam.setMergeEntityIds(((List)mergeEntityPair.p1).stream().map(e -> (Long)e.p1).collect(Collectors.toList()));
            checkParam.setCslschemeId(cslschemeId);
            param.setCustomParam("checkParam", (Object)ObjectSerialUtil.toByteSerialized((Object)checkParam));
            if (parentView == null) {
                this.getView().showForm(param);
                this.getView().sendFormAction(mainPageView);
            } else {
                parentView.showForm(param);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private List<Long> getSelectRowIds() {
        BillList billlistap = (BillList)this.getControl(ctl_billlistap);
        ListSelectedRowCollection idList = billlistap.getSelectedRows();
        if (null == idList || idList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u8bb0\u5f55\u3002", (String)"CheckMainPagePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        idList.sort(Comparator.comparingInt(ListSelectedRow::getRowKey));
        Object[] id = idList.getPrimaryKeyValues();
        DynamicObjectCollection allRecords = new DynamicObjectCollection();
        BatchProcessHelper.batchConsume(Arrays.asList(id), (int)10000, t -> allRecords.addAll((Collection)QueryServiceHelper.query((String)"bcm_checkrecord", (String)ID, (QFilter[])new QFilter[]{new QFilter(ID, "in", t)})));
        if (allRecords.size() != id.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u3002", (String)"CheckMainPagePlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Arrays.stream(id).map(e -> LongUtil.toLong((Object)e)).collect(Collectors.toList());
    }

    private void exportDetailUnitTest() {
        List<Long> ids = this.getSelectRowIds();
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(ids)) {
            return;
        }
        CheckDetailExport export = new CheckDetailExport(this.getModelId(), ids, this.getModel().getValue("createtype").toString(), this.getPageCache().get(SHOW_STYLE), this.getUserDefineScale(), null);
        export.initService();
        export.exportDetail();
    }

    private void exportDetail() {
        List<Long> ids = this.getSelectRowIds();
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(ids)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("modelId", this.getModelId());
        params.put("ids", ids);
        params.put("createType", this.getModel().getValue("createtype").toString());
        params.put("showStyle", this.getPageCache().get(SHOW_STYLE));
        params.put("userScale", this.getUserDefineScale());
        this.createTask(params, ResManager.loadKDString((String)"\u5bfc\u51fa\u660e\u7ec6\u5bf9\u8d26\u62a5\u544a", (String)"CheckMainPagePlugin_84", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "kd.fi.bcm.formplugin.check.CheckDetailExportTask", "checkdetailexporttaskclose");
    }

    private void createTask(Map<String, Object> params, String JobInfoName, String taskClassName, String closeCallBackId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(JobInfoName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(this.getUserId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, closeCallBackId);
        this.dispatch(jobInfo, this.getView(), closeCallBack);
    }

    public void dispatch(JobInfo jobInfo, IFormView view, CloseCallBack closeCallBack) {
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(this.getView().getPageId());
        clientJobInfo.setClickClassName("kd.fi.bcm.formplugin.check.CheckTaskClickPlugin");
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    @Override
    public String getBizAppId() {
        String appId = "";
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"cm");
        if (null != appInfo) {
            appId = appInfo.getId();
        }
        return appId;
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListUserConfig listUserConfig = new ListUserConfig();
        listUserConfig.setPageRows(billList.getPageRow());
        listUserConfig.store(billList.getBillFormId());
        PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId());
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        List<Object> qFilterList;
        ListShowParameter showParameter;
        super.beforeF7Select(beforeF7SelectEvent);
        String conKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        Object model = this.getModel().getValue(this.getModelSign());
        Object sceneDy = this.getModel().getValue("scenario");
        if (("currency".equals(conKey) || "cslscheme".equals(conKey)) && model == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"CheckMainPagePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        if ("currency".equals(conKey) && beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(10);
            }
            qFilterList.add(new QFilter(NUMBER, "not in", (Object)new Object[]{"EC", "PC", "Currency", "DC", "OC"}));
            qFilterList.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            qFilterList.add(new QFilter("model", "=", ((DynamicObject)model).get(ID)));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
        if ("cslscheme".equals(conKey) && sceneDy != null && beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList(10);
            }
            qFilterList.add(new QFilter("model", "=", ((DynamicObject)model).get(ID)));
            qFilterList.add(new QFilter(ID, "in", (Object)DimensionServiceHelper.buildCslschemeFilter((long)((DynamicObject)model).getLong(ID), (long)((DynamicObject)sceneDy).getLong(ID))));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public void initBasedataEditSingleMemberF7(String f7Key, BasedataEditSingleMemberF7 f7) {
        if ("currency".equals(f7Key)) {
            f7.setCustomFilter(new QFilter(NUMBER, "!=", (Object)"EC"));
        }
    }

    private void hideNoDataCell() {
        Sheet sheet = this.getEffectiveSheet();
        String selectValue = (String)this.getModel().getValue("reporttype");
        if ("2".equalsIgnoreCase(selectValue)) {
            this.deleteNoDataRow(sheet);
            this.deleteNoDataCol(sheet);
            this.cacheSpreadModel();
        }
    }

    private void deleteNoDataRow(Sheet sheet) {
        ArrayList<Integer> noDataRow = new ArrayList<Integer>(sheet.getMaxRowCount());
        for (int rowNum = 2; rowNum < sheet.getMaxRowCount(); ++rowNum) {
            boolean haveData = false;
            for (int colNum = 1; colNum < sheet.getMaxColumnCount(); ++colNum) {
                Cell cell = sheet.getCell(rowNum, colNum);
                if ("-".equals(cell.getValue())) continue;
                haveData = true;
                break;
            }
            if (haveData) continue;
            noDataRow.add(rowNum);
        }
        for (int i = noDataRow.size() - 1; i > 0; --i) {
            sheet.delRow(i);
        }
        LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
        map.put("status", Boolean.valueOf(true));
        map.put("data", noDataRow);
        SpreadClientInvoker.invokeDelRow(this.getClientViewProxy(), spreadKey, map);
    }

    private void deleteNoDataCol(Sheet sheet) {
        ArrayList<Integer> noDataCol = new ArrayList<Integer>(sheet.getMaxRowCount());
        for (int colNum = 1; colNum < sheet.getMaxColumnCount(); ++colNum) {
            boolean haveData = false;
            for (int rowNum = 2; rowNum < sheet.getMaxRowCount(); ++rowNum) {
                Cell cell = sheet.getCell(rowNum, colNum);
                if ("-".equals(cell.getValue())) continue;
                haveData = true;
                break;
            }
            if (haveData) continue;
            noDataCol.add(colNum);
        }
        for (int i = noDataCol.size() - 1; i > 0; --i) {
            sheet.delColumn(i);
        }
        LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
        map.put("status", Boolean.valueOf(true));
        map.put("data", noDataCol);
        SpreadClientInvoker.invokeDelCol(this.getClientViewProxy(), spreadKey, map);
    }

    private void setUserSelectF7Value(String modelId) {
        this.getModel().beginInit();
        ArrayList<String> dimensions = new ArrayList<String>(10);
        for (String key : this.dimKeys) {
            dimensions.add(UserSelectUtil.getDimensionByKey(key));
            dimensions.add(UserSelectUtil.getDimensionByKey(key) + ".membermodel");
            dimensions.add(key + ".isleaf");
        }
        String selectFileds = UserSelectUtil.buildOtherSelectFileds(dimensions) + ",config";
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        DynamicObject userSelect = UserSelectUtil.getUserSelectById(modelId, selectFileds, application);
        JSONObject jsonObject = null;
        if (userSelect != null) {
            String configJsonStr = userSelect.getString("config");
            if (StringUtils.isNotBlank((CharSequence)configJsonStr)) {
                jsonObject = JSONObject.parseObject((String)configJsonStr);
                this.initCslScheme(jsonObject.getLong(CHECK_CSLSCHEME));
            } else {
                this.initCslScheme(null);
            }
            for (String key : this.dimKeys) {
                Long dimensionId = userSelect.getLong(key);
                if (dimensionId == 0L) continue;
                this.getModel().setValue(key, (Object)dimensionId);
            }
            if (jsonObject != null) {
                this.initMyorgSelect(jsonObject.getJSONArray(MY_ORG_LIST_KEY));
            }
        }
        this.getModel().endInit();
        this.getView().updateView("myorg");
        this.getView().updateView("cslscheme");
        this.getView().updateView("scenario");
        this.getView().updateView("year");
        this.getView().updateView("period");
        this.getView().updateView("process");
        if (jsonObject != null) {
            this.getModel().setValue("createtype", (Object)(jsonObject.getString(CREATE_TYPE_KEY) == null ? CheckCreateTypeEnum.CHECKADJUST_CREATE.value : jsonObject.getString(CREATE_TYPE_KEY)));
            this.changeCreateType(jsonObject);
        } else {
            this.changeCreateType(null);
        }
    }

    private void initCslScheme(Long cslschemeId) {
        if (cslschemeId != null) {
            this.getModel().setValue("cslscheme", (Object)cslschemeId);
        } else {
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            CslSchemeUtils.setDefaultCslSchemeValue(model.getString(ID), false, this.getView());
        }
        this.getView().updateView("cslscheme");
    }

    private void initMyorgSelect(JSONArray myOrgList) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)myOrgList)) {
            int myOrgListSize = myOrgList.size();
            ArrayList<Long> idList = new ArrayList<Long>(myOrgListSize);
            for (int i = 0; i < myOrgListSize; ++i) {
                idList.add(myOrgList.getJSONObject(i).getLong(ID));
            }
            DynamicObjectCollection orgs = OrgServiceHelper.getOrgList((Long)this.getModelId(), idList);
            HashMap<String, DynamicObject> orgMap = new HashMap<String, DynamicObject>(orgs.size());
            for (DynamicObject org : orgs) {
                orgMap.put(org.getString(ID), org);
            }
            JSONArray myorgListJson = new JSONArray();
            ArrayList<String> myorgCache = new ArrayList<String>(myOrgListSize);
            ArrayList<String> myorg = new ArrayList<String>(myOrgListSize);
            for (int i = 0; i < myOrgListSize; ++i) {
                JSONObject item = new JSONObject();
                JSONObject temp = myOrgList.getJSONObject(i);
                String id = temp.getString(ID);
                DynamicObject org = (DynamicObject)orgMap.get(id);
                if (org == null) continue;
                String scope = temp.getString("scope");
                item.put(ID, (Object)id);
                item.put("pid", (Object)temp.getString("pid"));
                item.put(NUMBER, (Object)org.getString(NUMBER));
                item.put("scope", (Object)scope);
                String orgName = new LocaleString(org.getString(NAME)).toString();
                item.put(NAME, (Object)orgName);
                myorgListJson.add((Object)item);
                myorgCache.add(id + ";" + temp.getString("scope"));
                if (RangeEnum.VALUE_10.getValue() == Integer.parseInt(scope)) {
                    myorg.add(orgName);
                    continue;
                }
                myorg.add(String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s", (String)"CheckMainPagePlugin_81", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgName, RangeEnum.getRangeByVal((int)Integer.parseInt(scope)).getName()));
            }
            this.getPageCache().put("myorg", myorgListJson.toJSONString());
            this.getPageCache().put("myorgCache", StringUtils.join(myorgCache, (String)","));
            this.getModel().setValue("myorg", (Object)StringUtils.join(myorg, (String)","));
            this.checkUnEffectOrg();
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("myorg".equals(key) || "opporg".equals(key)) {
            if (this.getPairByCtl("year") == null || this.getPairByCtl("period") == null || this.getPairByCtl("scenario") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u8d22\u5e74\u3001\u60c5\u666f\u3001\u671f\u95f4\u3002", (String)"CheckMainPagePlugin_76", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter para = new FormShowParameter();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>(16);
            params.put("lockcslscheme", true);
            para.setCustomParams(params);
            this.showMulTiF7(key, "Entity");
        }
    }

    private void showMulTiF7(String key, String number) {
        long modelId = this.getModelId();
        DynamicObject dim = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)modelId, (String)number));
        if (dim == null) {
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_mulmemberf7base_tem");
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("lockcslscheme", true);
        params.put("dimension", dim.getInt("dseq") + "");
        params.put("sign", key);
        if ("myorg".equals(key)) {
            if (Objects.equals(CheckCreateTypeEnum.CHECKADJUST_CREATE.value, this.getModel().getValue("createtype"))) {
                params.put("showScopes", ObjectSerialUtil.toByteSerialized((Object)new int[]{10, 110}));
                params.put("customFilter", new QFilter("isleaf", "=", (Object)Boolean.FALSE).toSerializedString());
            } else {
                params.put("showScopes", ObjectSerialUtil.toByteSerialized((Object)new int[]{10, 90, 110}));
            }
        } else {
            params.put("showScopes", ObjectSerialUtil.toByteSerialized((Object)new int[]{10, 90}));
        }
        DynamicObject cslscheme = (DynamicObject)this.getModel().getValue("cslscheme");
        if (cslscheme != null) {
            params.put("cslscheme", cslscheme.getLong(ID));
        }
        para.setCustomParams(params);
        Pair<Long, String> year = this.getPairByCtl("year");
        Pair<Long, String> period = this.getPairByCtl("period");
        if (year != null && period != null) {
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("yearNum", year.p2);
            customData.put("yearId", year.p1);
            customData.put("periodId", period.p1);
            Pair<Long, String> scene = this.getPairByCtl("scenario");
            if (scene != null) {
                customData.put("sceneId", scene.p1);
            }
            para.setCustomParam("customData", customData);
        }
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"CheckMainPagePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString(NAME)));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if ("diffpage_close".equals(key)) {
            this.refreshData(false);
        } else if ("actionchecktaskclose".equals(key) || "actionBatchDiffProcessClose".equals(key)) {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result = (Map)cb.getReturnData();
            if (result != null && result.containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                CheckHelper.handleCheckResult(this.getView(), taskInfo);
                this.refreshData(false);
            }
        } else if ("checkdetailexporttaskclose".equals(key)) {
            String data;
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result = (Map)cb.getReturnData();
            if (result != null && result.containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotBlank((CharSequence)(data = taskInfo.getData()))) {
                JSONObject dataObj = (JSONObject)JSONObject.parse((String)data);
                if (dataObj.getBoolean("success").booleanValue()) {
                    this.downloadFile(dataObj.getString("fileUrl"), "bcm_checkmainpage", "1G2FW/G3YIL8");
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "CheckMainPagePlugin_44", "fi-bcm-formplugin", "export"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u660e\u7ec6\u5bf9\u8d26\u62a5\u544a\u6210\u529f\u3002", "CheckMainPagePlugin_85", "fi-bcm-formplugin", null));
                } else {
                    this.getView().showErrorNotification(dataObj.getString("message"));
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "CheckMainPagePlugin_44", "fi-bcm-formplugin", "export"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u660e\u7ec6\u5bf9\u8d26\u62a5\u544a\u5931\u8d25\u3002", "CheckMainPagePlugin_86", "fi-bcm-formplugin", null));
                }
            }
        } else if (cb.getReturnData() != null) {
            DynamicObjectCollection doc = (DynamicObjectCollection)cb.getReturnData();
            PermissionService permissionService = PermissionServiceImpl.getInstance((Long)this.getModelId());
            Long entityDimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.ENTITY_DIM);
            if (doc.size() > 0 || "myorg".equals(key) || "opporg".equals(key)) {
                StringBuilder sb = new StringBuilder();
                ArrayList list = new ArrayList(doc.size());
                StringBuilder idSb = new StringBuilder();
                for (int i = 0; i < doc.size(); ++i) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put(ID, ((DynamicObject)doc.get(i)).get(4).toString());
                    map.put("scope", ((DynamicObject)doc.get(i)).get(5).toString());
                    map.put(NUMBER, ((DynamicObject)doc.get(i)).get(2).toString());
                    map.put(NAME, ((DynamicObject)doc.get(i)).get(3).toString());
                    map.put("pid", ((DynamicObject)doc.get(i)).get(6).toString());
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)map.get("pid"))) && permissionService.isAllNoPerm(entityDimensionId, "bcm_entitymembertree", (Collection)Sets.newHashSet((Object[])new Long[]{LongUtil.toLong((Object)((DynamicObject)doc.get(i)).get(4))}))) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u7ec4\u7ec7%1$s %2$s \u65e0\u6743\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7ec4\u7ec7\u3002", (String)"CheckMainPagePlugin_70", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((DynamicObject)doc.get(i)).get(2).toString(), ((DynamicObject)doc.get(i)).get(3).toString()));
                        return;
                    }
                    if (RangeEnum.getRangeByVal((int)((DynamicObject)doc.get(i)).getInt(5)) == RangeEnum.VALUE_10) {
                        sb.append(((DynamicObject)doc.get(i)).get(3).toString()).append(',');
                    } else {
                        sb.append(((DynamicObject)doc.get(i)).get(3).toString()).append(ResManager.loadKDString((String)"\u7684", (String)"CheckMainPagePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)((DynamicObject)doc.get(i)).getInt(5)).getName()).append(',');
                    }
                    list.add(map);
                    idSb.append(((DynamicObject)doc.get(i)).get(4).toString()).append(';').append(((DynamicObject)doc.get(i)).getInt(5)).append(',');
                }
                this.getPageCache().put(key, SerializationUtils.toJsonString(list));
                this.getPageCache().put(key + "Cache", idSb.substring(0, StringUtils.isEmpty((CharSequence)idSb) ? idSb.length() : idSb.length() - 1));
                this.getModel().setValue(key, (Object)sb.substring(0, StringUtils.isEmpty((CharSequence)sb) ? sb.length() : sb.length() - 1));
            }
        }
    }

    private void refreshData(boolean showMsg) {
        if (this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u4f53\u7cfb\u201d\u3002", (String)"CheckMainPagePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("checkScale", ConfigServiceHelper.getStringParam((Long)this.getModelId(), (String)"checkScale"));
        String selectValue = (String)this.getModel().getValue("reporttype");
        if ("1".equalsIgnoreCase(selectValue)) {
            this.refreshBillList(showMsg);
        } else {
            this.refreshSpread(showMsg);
        }
    }

    private void refreshBillList(boolean showMsg) {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        FilterParameter fp = new FilterParameter();
        if (this.checkParams(showMsg)) {
            fp.setFilter(this.setBillListFilter());
            fp.setOrderBy("checktmpl.number asc,entity.longnumber asc,myentity.number asc,oppositeentity.number asc");
        } else {
            fp.setFilter(new QFilter("1", "=", (Object)0));
        }
        billList.setFilterParameter(fp);
        billList.refresh();
        billList.clearSelection();
    }

    private QFilter setBillListFilter() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        long modelId = model.getLong(ID);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        this.setOrgFilterForBillList(filter, modelId);
        this.setMyEntityFilter(filter);
        this.setPageDimFilter(filter, "scene", "scenario");
        this.setPageDimFilter(filter, "year", "year");
        this.setPageDimFilter(filter, "period", "period");
        this.setPageDimFilter(filter, "currency", "currency");
        ArrayList<String> processNums = new ArrayList<String>(16);
        if ("ARPT".equals(this.getModel().getValue("process").toString())) {
            processNums.add("ARPT");
            processNums.add("ADJ");
            if (Objects.equals(CheckCreateTypeEnum.CHECK_CREATE.value, this.getModel().getValue("createtype"))) {
                filter.and("createtype", "=", (Object)CheckCreateTypeEnum.CHECK_CREATE.value);
            } else {
                filter.and("createtype", "=", (Object)CheckCreateTypeEnum.CHECKADJUST_CREATE.value);
            }
        } else {
            processNums.add("Rpt");
        }
        filter.and("process.number", "in", processNums);
        this.setOffsetAndTmpl(filter, "checktmpl.templatecatalog.number", "offsettype", false);
        this.setOffsetAndTmpl(filter, "checktmpl", "checktmp", true);
        if ("2".equals(this.getModel().getValue("showzero"))) {
            filter.and("cvtdifmoney", "!=", (Object)BigDecimal.ZERO);
        }
        return filter;
    }

    private void setOffsetAndTmpl(QFilter filter, String filterName, String selectNumName, boolean isConvertToLong) {
        String selectNum = "";
        if (this.getModel().getValue(selectNumName) != null) {
            selectNum = (String)this.getModel().getValue(selectNumName);
        }
        if (selectNum.length() > 0) {
            String[] split = selectNum.split(",");
            ArrayList<String> filterLst = new ArrayList<String>(10);
            for (String spt : split) {
                if ("all".equals(spt) || "0".equals(spt)) {
                    return;
                }
                if ("".equals(spt)) continue;
                filterLst.add(spt);
            }
            if (isConvertToLong) {
                filter.and(filterName, "in", (Object)ConvertUtil.convertListToLong(filterLst));
            } else {
                filter.and(filterName, "in", filterLst);
            }
        }
    }

    private void setPageDimFilter(QFilter filter, String filterName, String entity) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(entity);
        if (obj != null) {
            filter.and(filterName, "=", (Object)obj.getLong(ID));
        }
    }

    private void setMyEntityFilter(QFilter filter) {
        Pair<List<Pair<Long, String>>, StringBuilder> myEntityPairs = this.filterCompanyByPerm(false, "myorg");
        if (!CollectionUtils.isEmpty((Collection)((Collection)myEntityPairs.p1))) {
            QFilter qf = null;
            HashSet<String> leafNums = new HashSet<String>(16);
            HashSet<String> mergeNums = new HashSet<String>(16);
            String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
            for (Pair p : (List)myEntityPairs.p1) {
                IDNumberTreeNode node = MemberReader.findEntityMemberById((String)modelNumber, (Long)((Long)p.p1));
                if (node.isLeaf()) {
                    leafNums.add(node.getNumber());
                    continue;
                }
                mergeNums.add(node.getNumber());
            }
            if (!CollectionUtils.isEmpty(leafNums)) {
                qf = new QFilter("myentity.number", "in", leafNums);
                qf.or("oppositeentity.number", "in", leafNums);
            }
            if (!CollectionUtils.isEmpty(mergeNums)) {
                if (qf == null) {
                    qf = new QFilter("entity.number", "in", mergeNums);
                } else {
                    qf.or("entity.number", "in", mergeNums);
                }
            }
            if (qf != null) {
                Long cslschemeid;
                Long l = cslschemeid = this.getModel().getValue("cslscheme") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("cslscheme")).getLong(ID));
                if (cslschemeid != null) {
                    qf.and("entity.cslscheme", "=", (Object)cslschemeid);
                }
                filter.and(qf);
            }
        } else {
            filter.and(new QFilter("entity.id", "=", (Object)-1L));
        }
    }

    private void setOrgFilterForBillList(QFilter filter, long modelId) {
        String[] innerComps = this.getInnerComps();
        if (innerComps != null) {
            QFilter qf = new QFilter("oppositeentity.number", "in", (Object)innerComps);
            qf.or("myentity.number", "in", (Object)innerComps);
            filter.and(qf);
        } else if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("opporg"))) {
            filter.and(new QFilter("oppositeentity.id", "=", (Object)-1L));
        }
    }

    private void actionCheck(boolean isAdjust) {
        if (!this.checkParams(true)) {
            return;
        }
        if (isAdjust && !ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM022")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570CM022\u8bbe\u7f6e\u4e3a\u5426\uff0c\u65e0\u6cd5\u751f\u6210\u62b5\u9500\u6570\u636e\u3002", (String)"CheckMainPagePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectMC = this.getPageCache().get("myorgCache");
        if (isAdjust) {
            this.getPageCache().remove("opporgCache");
            this.getPageCache().remove("opporg");
            this.getModel().setValue("opporg", null);
        }
        CheckParam cparam = this.getCheckParam(null, isAdjust);
        CheckHelper.isExistArchiving(this.getModelId(), (String)cparam.getScene().p2, (String)cparam.getYear().p2, (String)cparam.getPeriod().p2);
        if (selectMC != null) {
            String jobName;
            Pair<List<Pair<Long, String>>, StringBuilder> orgIdPair = this.filterCompanyByPerm(isAdjust, "myorg");
            List orgIds = ((List)orgIdPair.p1).stream().map(e -> (Long)e.p1).collect(Collectors.toList());
            DynamicObjectCollection entityCollection = OrgServiceHelper.getOrgList((Long)this.getModelId(), orgIds);
            List<Tuple<Long, String, String>> entities = entityCollection.stream().map(dyna -> Tuple.create((Object)dyna.getLong(ID), (Object)dyna.getString(NUMBER), (Object)dyna.getString("longnumber"))).collect(Collectors.toList());
            entities.sort((t1, t2) -> ((String)t2.p3).compareTo((String)t1.p3));
            List<String> unOpenPeriodOrg = this.checkOrgPeriodStatus(entities);
            String string = jobName = isAdjust ? ResManager.loadKDString((String)"\u5bf9\u8d26\u5e76\u62b5\u9500", (String)"CheckMainPagePlugin_88", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bf9\u8d26", (String)"CheckMainPagePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (!entities.isEmpty()) {
                HashMap<String, Object> params = new HashMap<String, Object>(5);
                CheckParam checkParam = this.getCheckParam((Pair<Long, String>)Pair.onePair((Object)entities.get((int)0).p1, (Object)entities.get((int)0).p2), isAdjust);
                if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("opporg")) && checkParam.getIcNumbers() == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u65b9\u5355\u4f4d\u6ca1\u6709\u627e\u5230\u6709\u6548\u4e14\u6709\u6743\u7684\u660e\u7ec6\u7ec4\u7ec7\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CheckMainPagePlugin_96", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                params.put("checkParam", ObjectSerialUtil.toByteSerialized((Object)checkParam));
                params.put("entities", ObjectSerialUtil.toByteSerialized(entities));
                params.put("unOpenPeriodOrg", ObjectSerialUtil.toByteSerialized(unOpenPeriodOrg));
                params.put("permInfo", ((StringBuilder)orgIdPair.p2).toString());
                params.put("taskType", isAdjust ? "1" : "0");
                params.put("requestContext", RequestContext.get() != null ? ObjectSerialUtil.toByteSerialized((Object)RequestContext.get()) : null);
                this.createTask(params, jobName, "kd.fi.bcm.business.check.task.ActionCheckTask", "actionchecktaskclose");
            } else {
                StringBuilder sb = new StringBuilder(16);
                if (orgIdPair.p2 != null && ((StringBuilder)orgIdPair.p2).length() > 0) {
                    sb.append((CharSequence)orgIdPair.p2).append("\n");
                }
                if (unOpenPeriodOrg.size() > 0) {
                    String notification = unOpenPeriodOrg.size() <= 5 ? Joiner.on((String)",").join(unOpenPeriodOrg) : Joiner.on((String)",").join(unOpenPeriodOrg.subList(0, 5)) + "......";
                    sb.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u7ec4\u7ec7\u6ca1\u6709\u5f00\u542f\u6570\u636e\u671f\u95f4,\u5df2\u8df3\u8fc7\u6267\u884c\u5bf9\u8d26\uff1a %s", (String)"CheckMainPagePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), notification)).append("\n");
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bf9\u8d26", "CheckMainPagePlugin_13", "fi-bcm-formplugin", "check"), new OPDescMultiLangEnumBridge("\u5982\u4e0b\u7ec4\u7ec7\u6ca1\u6709\u5f00\u542f\u6570\u636e\u671f\u95f4,\u5df2\u8df3\u8fc7\u6267\u884c\u5bf9\u8d26\uff1a %s", "CheckMainPagePlugin_10", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{notification})));
                }
                if (sb.length() > 0) {
                    this.getView().showMessage("", sb.toString(), MessageTypes.Default);
                }
            }
        }
    }

    private boolean checkParams(boolean showMsg) {
        Object model = this.getModel().getValue("model");
        Object scene = this.getModel().getValue("scenario");
        Object year = this.getModel().getValue("year");
        Object period = this.getModel().getValue("period");
        Object cslscheme = this.getModel().getValue("cslscheme");
        Object checkTmpl = this.getModel().getValue("checktmp");
        if (model == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u4f53\u7cfb\u201d\u3002", (String)"CheckMainPagePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (cslscheme == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u89c6\u56fe\u201d\u3002", (String)"CheckMainPagePlugin_69", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (scene == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u60c5\u666f\u201d\u3002", (String)"CheckMainPagePlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (year == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u8d22\u5e74\u201d\u3002", (String)"CheckMainPagePlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (period == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u671f\u95f4\u201d\u3002", (String)"CheckMainPagePlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (this.getPageCache().get("myorgCache") == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u672c\u65b9\u5355\u4f4d\u201d\u3002", (String)"CheckMainPagePlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (checkTmpl == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5bf9\u8d26\u6a21\u677f\u201d\u3002", (String)"CheckMainPagePlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private CheckParam getCheckParam(Pair<Long, String> entity, boolean isGenerateElim) {
        Pair<Long, String> model = this.getPairByCtl("model");
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u4f53\u7cfb\u201d\u3002", (String)"CheckMainPagePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Pair<Long, String> scene = this.getPairByCtl("scenario");
        Pair<Long, String> year = this.getPairByCtl("year");
        Pair<Long, String> period = this.getPairByCtl("period");
        Pair<Long, String> currency = this.getPairByCtl("currency");
        String elimType = (String)this.getModel().getValue("offsettype");
        Pair<Long[], String> checkTmpl = this.getPairByCtlTmpl();
        String[] icNumbers = this.getInnerComps();
        isGenerateElim = isGenerateElim && ConfigServiceHelper.getBoolParam((Long)((Long)model.p1), (String)"CM022");
        boolean isIncludeAdj = "ARPT".equals(this.getModel().getValue("process"));
        CheckCreateTypeEnum createTypeEnum = Objects.equals(CheckCreateTypeEnum.CHECKADJUST_CREATE.value, this.getModel().getValue("createtype")) ? CheckCreateTypeEnum.CHECKADJUST_CREATE : CheckCreateTypeEnum.CHECK_CREATE;
        return new CheckParam(model, scene, year, period, entity, currency, isIncludeAdj, isGenerateElim, icNumbers, elimType, checkTmpl, createTypeEnum);
    }

    private String[] getInnerComps() {
        Pair<List<Pair<Long, String>>, StringBuilder> opporgs = this.filterCompanyByPerm(false, "opporg");
        HashSet result = new HashSet(16);
        ((List)opporgs.p1).forEach(p -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)((Long)p.p1));
            if (node.isLeaf()) {
                result.add(p.p2);
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new String[0]);
    }

    private Pair<Long, String> getPairByCtl(String ctl) {
        DynamicObject dynaObj = (DynamicObject)this.getModel().getValue(ctl);
        if (dynaObj != null) {
            return Pair.onePair((Object)dynaObj.getLong(ID), (Object)dynaObj.getString(NUMBER));
        }
        return null;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject obj;
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if (e.getChangeSet()[0].getNewValue() != null && ("offsettype".equals(keyName) || "createtype".equals(keyName) || "cslscheme".equals(keyName) || "myorg".equals(keyName) || this.dimKeys.contains(keyName))) {
            Object createtype;
            String orgListStr;
            Object myorgName;
            UserSelectModel usm = new UserSelectModel();
            HashMap<String, Object> configObj = new HashMap<String, Object>(16);
            if ("myorg".equals(keyName) && (myorgName = this.getModel().getValue("myorg")) != null && StringUtils.isNotBlank((CharSequence)myorgName.toString()) && StringUtils.isNotBlank((CharSequence)(orgListStr = this.getPageCache().get("myorg")))) {
                JSONArray orgListTemp = JSONArray.parseArray((String)orgListStr);
                JSONArray orgList = new JSONArray();
                for (int i = 0; i < orgListTemp.size() && i < 10; ++i) {
                    JSONObject item = new JSONObject();
                    JSONObject temp = orgListTemp.getJSONObject(i);
                    item.put(ID, (Object)temp.getLong(ID));
                    item.put("scope", (Object)temp.getLong("scope"));
                    item.put("pid", (Object)temp.getString("pid"));
                    orgList.add((Object)item);
                }
                configObj.put(MY_ORG_LIST_KEY, orgList);
            }
            if ("cslscheme".equals(keyName) && (obj = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null && StringUtils.isNotBlank((CharSequence)obj.getString(ID))) {
                configObj.put(CHECK_CSLSCHEME, obj.getLong(ID));
                configObj.put(MY_ORG_LIST_KEY, new JSONArray());
            }
            if ("createtype".equals(keyName)) {
                createtype = this.getModel().getValue("createtype");
                configObj.put(CREATE_TYPE_KEY, createtype);
            }
            if ("offsettype".equals(keyName)) {
                createtype = this.getModel().getValue("createtype");
                Object offsettype = this.getModel().getValue("offsettype");
                if (createtype != null && offsettype != null) {
                    CharSequence[] split = offsettype.toString().split(",", 15);
                    configObj.put(String.join((CharSequence)"-", "check-ot", createtype.toString()), String.join((CharSequence)",", split));
                }
            }
            usm.setConfig(configObj);
            this.savetUserSelectWhenOtherChange(keyName, usm);
        }
        switch (keyName) {
            case "reporttype": {
                if ("1".equalsIgnoreCase(e.getChangeSet()[0].getNewValue().toString())) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"threelist"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"matrixshow"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"threelist"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"matrixshow"});
                this.refreshSpread(false);
                break;
            }
            case "model": {
                obj = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (obj == null) break;
                long modelId = obj.getLong(ID);
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), String.valueOf(modelId));
                this.loadPageRowFromDB();
                this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
                this.clearAllData(keyName);
                this.initCheckTmplPerm();
                this.setOffsetType();
                this.setUserSelectF7Value(String.valueOf(modelId));
                this.changeCheckTmpByOffsetType();
                this.setBtnVisible(this.getModelId());
                break;
            }
            case "cslscheme": {
                this.clearAllData(keyName);
                break;
            }
            case "scenario": {
                this.checkCslscheme();
                this.clearAllData(keyName);
                break;
            }
            case "year": 
            case "period": {
                this.checkUnEffectOrg();
                this.changeCheckTmpByOffsetType();
                break;
            }
            case "myorg": {
                if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue().toString().isEmpty()) {
                    this.getPageCache().remove("myorgCache");
                    this.getPageCache().remove("myorg");
                }
                this.changeCheckTmpByOffsetType();
                break;
            }
            case "opporg": {
                if (e.getChangeSet()[0].getNewValue() != null && !e.getChangeSet()[0].getNewValue().toString().isEmpty()) break;
                this.getPageCache().remove("opporgCache");
                this.getPageCache().remove("opporg");
                break;
            }
            case "process": {
                break;
            }
            case "offsettype": {
                this.changeCheckTmpByOffsetType();
                break;
            }
            case "createtype": {
                this.changeCreateType(null);
                this.changeCheckTmpByOffsetType();
                break;
            }
        }
        if (!"reporttype".equals(keyName)) {
            this.pushCache();
            this.refreshData(false);
        }
    }

    private void checkCslscheme() {
        List cslSchemeIds;
        Object modelDy = this.getModel().getValue(this.getModelSign());
        Object sceneDy = this.getModel().getValue("scenario");
        Object cslSchemeDy = this.getModel().getValue("cslscheme");
        if (modelDy != null && sceneDy != null && cslSchemeDy != null && !(cslSchemeIds = DimensionServiceHelper.buildCslschemeFilter((long)((DynamicObject)modelDy).getLong(ID), (long)((DynamicObject)sceneDy).getLong(ID))).contains(((DynamicObject)cslSchemeDy).getLong(ID))) {
            this.getModel().setValue("cslscheme", null);
        }
    }

    private void changeCreateType(JSONObject userConfig) {
        this.loadPageRowFromDB();
        Object createtype = this.getModel().getValue("createtype");
        if (createtype != null) {
            if (Objects.equals(CheckCreateTypeEnum.CHECKADJUST_CREATE.value, createtype)) {
                if (this.checkMyOrgContainsLeaf()) {
                    this.getPageCache().remove("myorgCache");
                    this.getPageCache().remove("myorg");
                    this.getModel().setValue("myorg", null);
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_check"});
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u7c7b\u578b\u4e3a\u62b5\u9500\u5bf9\u8d26\u62a5\u544a\u65f6\uff0c\u672c\u65b9\u5355\u4f4d\u4e0d\u80fd\u5b58\u5728\u660e\u7ec6\u7ec4\u7ec7\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CheckMainPagePlugin_97", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.getPageCache().remove("opporgCache");
                this.getPageCache().remove("opporg");
                this.getModel().setValue("opporg", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"opporg"});
                this.getModel().setValue("process", (Object)"ARPT");
                this.getView().setEnable(Boolean.FALSE, new String[]{"process"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_checkandadjust", "btn_diffprocess", "btn_unaudit", "sum_report"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_check"});
            } else if (Objects.equals(CheckCreateTypeEnum.CHECK_CREATE.value, createtype)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"opporg"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"process"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_checkandadjust", "btn_diffprocess", "btn_unaudit", "sum_report"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_check"});
            }
            if (userConfig == null) {
                String configJsonStr;
                ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
                DynamicObject userSelect = UserSelectUtil.getUserSelectById(this.getModelId() + "", "id,config", application);
                if (userSelect != null && StringUtils.isNotBlank((CharSequence)(configJsonStr = userSelect.getString("config")))) {
                    userConfig = JSONObject.parseObject((String)configJsonStr);
                }
            }
            String otKey = String.join((CharSequence)"-", "check-ot", createtype.toString());
            if (userConfig != null && userConfig.get((Object)otKey) != null) {
                this.getModel().setValue("offsettype", userConfig.get((Object)otKey));
            }
        }
    }

    private void clearAllData(String keyName) {
        this.getModel().beginInit();
        if ("model".equals(keyName)) {
            this.getModel().setValue("scenario", null);
            this.getModel().setValue("year", null);
            this.getModel().setValue("period", null);
            this.getModel().setValue("cslscheme", null);
        } else if (!"cslscheme".equals(keyName) && "scenario".equals(keyName)) {
            this.getModel().setValue("period", null);
            this.getModel().setValue("myorg", null);
        }
        this.getModel().setValue("myorg", null);
        this.getPageCache().remove("myorg");
        this.getPageCache().remove("myorgCache");
        this.getModel().setValue("opporg", null);
        this.getPageCache().remove("opporgCache");
        this.getPageCache().remove("opporg");
        this.getModel().setValue("currency", null);
        this.getModel().setValue("offsettype", (Object)"all");
        this.getModel().setValue("checktmp", null);
        this.getModel().endInit();
        this.getView().updateView("cslscheme");
        this.getView().updateView("scenario");
        this.getView().updateView("year");
        this.getView().updateView("period");
        this.getView().updateView("myorg");
        this.getView().updateView("opporg");
        this.getView().updateView("currency");
        this.getView().updateView("offsettype");
        this.getView().updateView("checktmp");
    }

    private void setCslScheme(long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection cslscheme = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
        if (cslscheme == null || cslscheme.size() == 0) {
            this.getModel().setValue("cslscheme", null);
        } else {
            long cslId = ((DynamicObject)cslscheme.get(0)).getLong(ID);
            for (DynamicObject csl : cslscheme) {
                if (!"DefaultScheme".equalsIgnoreCase(csl.getString(NUMBER))) continue;
                cslId = csl.getLong(ID);
                break;
            }
            this.getModel().setValue("cslscheme", (Object)cslId);
        }
    }

    private void checkUnEffectOrg() {
        if (this.getModel().getValue("myorg") == null) {
            return;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject scene = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        String orgId = this.getPageCache().get("myorgCache");
        HashMap<Long, Integer> orgScopeMap = new HashMap<Long, Integer>();
        if (model != null && year != null && period != null && orgId != null) {
            ArrayList<Long> orgIdList = new ArrayList<Long>(16);
            for (String org : orgId.split(",")) {
                String[] orgScope = org.split(";");
                if (!NumberUtils.isDigits((String)orgScope[0])) continue;
                orgIdList.add(Long.valueOf(orgScope[0]));
                orgScopeMap.put(Long.valueOf(orgScope[0]), Integer.valueOf(orgScope[1]));
            }
            DynamicObjectCollection doc = OrgServiceHelper.getOrgList((Long)this.getModelId(), orgIdList);
            if (doc == null || doc.size() != orgIdList.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u8303\u56f4\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u539f\u6709\u8bb0\u5fc6\u529f\u80fd\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7\u6210\u5458\u3002", (String)"CheckMainPagePlugin_75", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("myorg", null);
                this.getPageCache().remove("myorg");
                this.getPageCache().remove("myorgCache");
                return;
            }
            List<DynamicObject> allFilterOrg = this.findAllParentOrgs(this.getModelId(), orgIdList);
            FilterOrgStructParam orgParam = new FilterOrgStructParam(model.getLong(ID), scene.getLong(ID), year.getString(NUMBER), period.getLong(ID));
            orgParam.setFrom(FilterOrgStructParam.FROM_CHECKELIM);
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)orgParam, allFilterOrg);
            Set effectOrgIds = allFilterOrg.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
            doc.removeIf(e -> !effectOrgIds.contains(e.getLong(ID)));
            if (doc == null || doc.size() != orgIdList.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u8303\u56f4\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u539f\u6709\u8bb0\u5fc6\u529f\u80fd\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7\u6210\u5458\u3002", (String)"CheckMainPagePlugin_75", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("myorg", null);
                this.getPageCache().remove("myorg");
                this.getPageCache().remove("myorgCache");
                return;
            }
            DynamicObjectCollection noMerge = OrgServiceHelper.getNoMergeOrgList((DynamicObjectCollection)doc, (Long)this.getModelId(), (Long)scene.getLong(ID), (Long)year.getLong(ID), (Long)period.getLong(ID));
            if (noMerge != null && noMerge.size() > 0) {
                HashSet<Long> noMergeIds = new HashSet<Long>(16);
                for (DynamicObject dy : noMerge) {
                    noMergeIds.add(dy.getLong(ID));
                }
                for (DynamicObject dyn : doc) {
                    if (!noMergeIds.contains(dyn.getLong(ID))) continue;
                    dyn.set(NAME, (Object)String.format(ResManager.loadKDString((String)"%s(\u4e0d\u53c2\u4e0e\u5408\u5e76)", (String)"CheckMainPagePlugin_92", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn.getString(NAME)));
                }
            }
            ArrayList<String> myOrgNameList = new ArrayList<String>(doc.size());
            for (DynamicObject dy : doc) {
                Integer scope = (Integer)orgScopeMap.get(dy.getLong(ID));
                if (RangeEnum.VALUE_10.getValue() == scope.intValue()) {
                    myOrgNameList.add(dy.getString(NAME));
                    continue;
                }
                myOrgNameList.add(String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s", (String)"CheckMainPagePlugin_81", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dy.getString(NAME), RangeEnum.getRangeByVal((int)scope).getName()));
            }
            this.getModel().setValue("myorg", (Object)StringUtils.join(myOrgNameList, (String)","));
        }
    }

    private List<DynamicObject> findAllParentOrgs(long modelId, List<Long> orgIdList) {
        ArrayList<Long> filterOrgIds = new ArrayList<Long>(orgIdList);
        filterOrgIds.addAll(OrgServiceHelper.findAllParentOrgIdsFormMemberNode((Long)modelId, orgIdList));
        MainEntityType orgEntityType = EntityMetadataCache.getDataEntityType((String)"bcm_entitymembertree");
        return filterOrgIds.stream().map(e -> new DynamicObject((DynamicObjectType)orgEntityType, e)).collect(Collectors.toList());
    }

    private void refreshSpread(boolean showMsg) {
        Sheet sheet = this.getEffectiveSheet();
        if (!this.checkParams(showMsg)) {
            return;
        }
        SearchHelper.clearSheet(sheet, spreadKey, this.getClientViewProxy());
        this.buildMatrixSpreadAndData(sheet);
        this.cacheSpreadModel();
    }

    private void changeCheckTmpByOffsetType() {
        Pair<Long, String> year = this.getPairByCtl("year");
        Pair<Long, String> period = this.getPairByCtl("period");
        DynamicObject scene = (DynamicObject)this.getModel().getValue("scenario");
        if (scene == null || StringUtils.isEmpty((CharSequence)this.getPageCache().get("myorg"))) {
            return;
        }
        String offsettype = this.getModel().getValue("offsettype") == null ? "" : this.getModel().getValue("offsettype").toString();
        String[] numbers = offsettype.contains("all") ? null : offsettype.split(",");
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        if (numbers != null) {
            qFilter.and(new QFilter("templatecatalog.number", "in", (Object)numbers));
        }
        DynamicObjectCollection checkTmpCollection = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id,name,number,elimtype", (QFilter[])new QFilter[]{qFilter}, (String)"sequence asc,id asc");
        HashSet allAccessTmplIds = new HashSet(16);
        HashSet orgAccessTmplIds = new HashSet(16);
        List myOrgIds = ((List)this.filterCompanyByPerm((boolean)Objects.equals((Object)CheckCreateTypeEnum.CHECKADJUST_CREATE.value, (Object)this.getModel().getValue((String)"createtype")), (String)"myorg").p1).stream().map(e -> (Long)e.p1).collect(Collectors.toList());
        if (myOrgIds.size() > 0 && checkTmpCollection.size() > 0) {
            Set tmplIds = checkTmpCollection.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
            HashSet<String> orgnums = new HashSet<String>(myOrgIds.size());
            for (Long id : myOrgIds) {
                IDNumberTreeNode memberNode = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)id);
                orgnums.add(memberNode.getNumber());
            }
            Set dispensedTmpls = CheckUtil.queryDispensedTmpls((Long)this.getModelId(), (Long)scene.getLong(ID), tmplIds, (String)offsettype, orgnums);
            Set tmplIdSet = CheckUtil.queryEffectiveTmpls((Long)this.getModelId(), (Long)(year == null ? null : (Long)year.p1), (Long)(period == null ? null : (Long)period.p1), (Set)dispensedTmpls);
            orgAccessTmplIds.addAll(tmplIdSet);
            allAccessTmplIds.addAll(tmplIdSet);
        }
        this.getModel().beginInit();
        this.getModel().setValue("checktmp", (Object)"all");
        if (this.checkParams(false)) {
            Set recordTmplIds = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id, number, checktmpl.id", (QFilter[])new QFilter[]{this.setBillListFilter()}).stream().map(e -> e.getLong("checktmpl.id")).collect(Collectors.toSet());
            allAccessTmplIds.addAll(recordTmplIds);
        }
        this.getModel().setValue("checktmp", null);
        this.getModel().endInit();
        if (allAccessTmplIds.size() > 0) {
            checkTmpCollection.removeIf(e -> !allAccessTmplIds.contains(e.getLong(ID)));
        } else {
            checkTmpCollection.clear();
        }
        List<Long> noPermCheckTmpIds = this.getCheckTmplPermByType(KEY_NOPERMCHECKTMPL);
        if (!this.getAdminUserBol().booleanValue() && !CollectionUtils.isEmpty(noPermCheckTmpIds)) {
            checkTmpCollection.removeIf(e -> noPermCheckTmpIds.contains(e.getLong(ID)));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("checktmp");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        for (DynamicObject obj : checkTmpCollection) {
            data.add(new ComboItem(new LocaleString(String.join((CharSequence)"|", obj.getString(NUMBER), obj.getString(NAME))), obj.getString(ID)));
        }
        comboEdit.setComboItems(data);
        this.getModel().beginInit();
        if (checkTmpCollection.size() > 0) {
            StringBuilder ids = new StringBuilder();
            checkTmpCollection.forEach(e -> {
                if (orgAccessTmplIds.contains(e.getLong(ID))) {
                    ids.append(e.getLong(ID)).append(",");
                }
            });
            if (ids.length() > 0) {
                this.getModel().setValue("checktmp", (Object)ids.toString());
            } else {
                this.getModel().setValue("checktmp", null);
            }
        } else {
            this.getModel().setValue("checktmp", null);
        }
        this.getModel().endInit();
        this.getView().updateView("checktmp");
    }

    private void buildMatrixSpreadAndData(Sheet sheet) {
        QFilter qFilter = this.setBillListFilter();
        DynamicObjectCollection record = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,myentity,myentity.name,myentity.number,oppositeentity,oppositeentity.name,oppositeentity.number,cvtdifmoney", (QFilter[])new QFilter[]{qFilter}, (String)"checktmpl.number asc,entity.longnumber asc,myentity.number asc,oppositeentity.number asc");
        HashMap<String, DynamicObject> recordMap = new HashMap<String, DynamicObject>(16);
        for (int i = record.size() - 1; i >= 0; --i) {
            DynamicObject rec = (DynamicObject)record.get(i);
            String key = rec.getString("myentity") + ":" + rec.getString("oppositeentity");
            DynamicObject recIn = (DynamicObject)recordMap.get(key);
            if (recIn == null) {
                recordMap.put(key, rec);
                continue;
            }
            recIn.set("cvtdifmoney", (Object)recIn.getBigDecimal("cvtdifmoney").add(rec.getBigDecimal("cvtdifmoney")));
            record.remove(i);
        }
        ArrayList<String> myEntityList = new ArrayList<String>(record.size());
        ArrayList<String> interEntityList = new ArrayList<String>(record.size());
        HashMap<String, DynamicObject> recMap = new HashMap<String, DynamicObject>(16);
        String showstyle = this.getPageCache().get(SHOW_STYLE);
        for (DynamicObject rec : record) {
            String myEntity = rec.getString("myentity");
            String interEntity = rec.getString("oppositeentity");
            recMap.put(myEntity + "," + interEntity, rec);
            String myEntityEle = myEntity + "," + rec.getString("myentity.name");
            if (NUMBER.equals(showstyle)) {
                myEntityEle = myEntity + "," + rec.getString("myentity.number");
            } else if ("numbername".equals(showstyle)) {
                myEntityEle = myEntity + "," + rec.getString("myentity.number") + "-" + rec.getString("myentity.name");
            }
            if (!myEntityList.contains(myEntityEle)) {
                myEntityList.add(myEntityEle);
            }
            String interEntityEle = interEntity + "," + rec.getString("oppositeentity.name");
            if (NUMBER.equals(showstyle)) {
                interEntityEle = interEntity + "," + rec.getString("oppositeentity.number");
            } else if ("numbername".equals(showstyle)) {
                interEntityEle = interEntity + "," + rec.getString("oppositeentity.number") + "-" + rec.getString("oppositeentity.name");
            }
            if (interEntityList.contains(interEntityEle)) continue;
            interEntityList.add(interEntityEle);
        }
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>((interEntityList.size() + 2) * (myEntityList.size() + 1));
        cellValues.add(this.packedUpdateCellMap(0, 0, ResManager.loadKDString((String)"\u672c\u65b9\u5355\u4f4d", (String)"CheckMainPagePlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        cellValues.add(this.packedUpdateCellMap(1, 0, ResManager.loadKDString((String)"\u5bf9\u65b9\u5355\u4f4d", (String)"CheckMainPagePlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        this.buildTableHead(sheet, interEntityList, 2, cellValues, false);
        this.buildTableHead(sheet, myEntityList, 1, cellValues, true);
        this.setColumnWidth(sheet, 200);
        this.setTableHeadDisplay(sheet, 1);
        this.setFrozen();
        SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), spreadKey);
        spreadEasyInvoker.setBatch(true);
        for (int i = 1; i < sheet.getMaxColumnCount(); ++i) {
            spreadEasyInvoker.setSpan(0, i, 2, 1);
        }
        spreadEasyInvoker.startToInvoke();
        this.buildMatrixSpreadData(sheet, recMap, cellValues);
        this.formatValue(sheet);
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList(cellValues));
        SpreadClientInvoker.invokeLockSheetMethod(this.getClientViewProxy(), spreadKey, Collections.singletonList(sheet.getSheetName()));
    }

    private void buildMatrixSpreadData(Sheet sheet, Map<String, DynamicObject> recMap, List<Map<String, Object>> cellValues) {
        for (int rowNum = 2; rowNum < sheet.getMaxRowCount(); ++rowNum) {
            for (int colNum = 1; colNum < sheet.getMaxColumnCount(); ++colNum) {
                Cell cell = sheet.getCell(rowNum, colNum);
                Cell rowCell = sheet.getCell(rowNum, 0);
                Cell colCell = sheet.getCell(0, colNum);
                String ids = colCell.getUserObject(ID) + "," + rowCell.getUserObject(ID);
                DynamicObject obj = recMap.get(ids);
                if (obj == null) {
                    cellValues.add(this.packedUpdateCellMap(rowNum, colNum, "-"));
                    cell.setValue((Object)"-");
                    continue;
                }
                cell.setValue(obj.get("cvtdifmoney"));
                cellValues.add(this.packedUpdateCellMap(rowNum, colNum, obj.get("cvtdifmoney")));
            }
        }
    }

    private void buildTableHead(Sheet sheet, List<String> entityList, int num, List<Map<String, Object>> cellValues, boolean isH) {
        for (String str : entityList) {
            String[] entitys = str.split(",");
            Cell cell = sheet.getCell(num, 0);
            if (isH) {
                cell = sheet.getCell(0, num);
                cellValues.add(this.packedUpdateCellMap(0, num, entitys[1]));
            } else {
                cellValues.add(this.packedUpdateCellMap(num, 0, entitys[1]));
            }
            cell.setUserObject(ID, (Object)entitys[0]);
            ++num;
        }
    }

    private void formatValue(Sheet sheet) {
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), 2);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), 1);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), sheet.getMaxRowCount() - 2);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), sheet.getMaxColumnCount() - 1);
        ArrayList<HashMap<String, Integer>> rangeList = new ArrayList<HashMap<String, Integer>>(10);
        rangeList.add(rangeMap);
        Integer scale = this.getUserDefineScale();
        if (scale == null) {
            scale = 2;
        }
        HashMap<String, String> styleMap = new HashMap<String, String>(16);
        StringBuilder sb = new StringBuilder("#,##0");
        if (scale > 0) {
            sb.append(".");
        }
        Integer i = 0;
        while (i < scale) {
            sb.append("0");
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        styleMap.put(SpreadProperties.SetCellStyleMethod.FORMAT.k(), sb.toString());
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
    }

    private void setColumnWidth(Sheet sheet, int width) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        int[] colindex = new int[sheet.getMaxColumnCount()];
        for (int i = 0; i < colindex.length; ++i) {
            colindex[i] = i;
        }
        map.put("index", colindex);
        map.put("num", width);
        SpreadClientInvoker.invokeSetColumsWidthMethod(this.getClientViewProxy(), spreadKey, map);
    }

    private void setTableHeadDisplay(Sheet sheet, int rowCount) {
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), 0);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), 0);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rowCount);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), sheet.getMaxColumnCount());
        ArrayList<HashMap<String, Integer>> rangeList = new ArrayList<HashMap<String, Integer>>(10);
        rangeList.add(rangeMap);
        HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#b2b2b2");
        styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 1);
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
    }

    private void setFrozen() {
        HashMap<String, Object> features = new HashMap<String, Object>(16);
        features.put(SpreadProperties.SetFrozenSheetMethod.R.k(), 2);
        features.put(SpreadProperties.SetFrozenSheetMethod.C.k(), 1);
        features.put(SpreadProperties.SetFrozenSheetMethod.FLC.k(), "#000000");
        SpreadClientInvoker.invokeSetFrozenSheetMethod(this.getClientViewProxy(), spreadKey, features);
    }

    private void actionUnAudit() {
        if (!this.checkParams(true)) {
            return;
        }
        Long[] ids = this.getSelectEntry();
        if (ids == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5bf9\u8d26\u8bb0\u5f55\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"CheckMainPagePlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
        if (periodManage && !CheckHelper.isStatusAllOpen(Arrays.asList(ids), this, this.getModelId())) {
            return;
        }
        DynamicObjectCollection dos = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id, number, status, diffmode, isautoelim,entity.id,entity.number,entity.name,myentity.name,checktmpl.id,checktmpl.number,checktmpl.name,checktmpl.isenable", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)ids)});
        if (null == dos || dos.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u3002", (String)"CheckMainPagePlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        PermissionService permissionService = PermissionServiceImpl.getInstance((Long)this.getModelId());
        Long entityDimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.ENTITY_DIM);
        for (DynamicObject dy : dos) {
            if (!permissionService.isAllReadPerm(entityDimensionId, "bcm_entitymembertree", (Collection)Sets.newHashSet((Object[])new Long[]{dy.getLong("entity.id")}))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u7ec4\u7ec7 %s \u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CheckMainPagePlugin_74", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dy.getString("entity.number")));
        }
        this.checkAllInOneStatus(dos);
        Pair orgPair = Pair.onePair((Object)((DynamicObject)dos.get(0)).getLong("entity.id"), (Object)((DynamicObject)dos.get(0)).getString("entity.number"));
        CheckParam checkParam = this.getCheckParam((Pair<Long, String>)orgPair, true);
        CheckHelper.groupAndUnAuditRecords(this, dos, checkParam);
        this.refreshData(false);
    }

    private Long[] getSelectEntry() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        LinkedHashSet<Long> values = new LinkedHashSet<Long>(16);
        if (!rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                Long id = (Long)row.getPrimaryKeyValue();
                values.add(id);
            }
            return values.toArray(new Long[0]);
        }
        return null;
    }

    private void actionDiffProcess(Long ... rows) {
        if (!this.checkParams(true)) {
            return;
        }
        if (rows == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5bf9\u8d26\u8bb0\u5f55\u8fdb\u884c\u5dee\u5f02\u5904\u7406\u3002", (String)"CheckMainPagePlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rows != null && rows.length > 0) {
            ArrayList ids = new ArrayList(rows.length);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,diffmode,entity,entity.number", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)rows)});
            dynamicObjects.forEach(e -> ids.add(e.get(ID)));
            if (ids.size() != rows.length) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckMainPagePlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            String pageId = this.getView().getPageId() + rows[0];
            if (mainPageView == null || mainPageView.getView(pageId) == null || parentView == null) {
                mainPageView = mainPageView == null ? this.getView() : mainPageView;
                FormShowParameter param = new FormShowParameter();
                param.setFormId("bcm_checkbalance");
                param.setParentPageId(this.getView().getPageId());
                param.setPageId(pageId);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.getOpenStyle().setTargetKey("_submaintab_");
                param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                param.setCustomParam("KEY_SCENARIO_ID", (Object)((DynamicObject)this.getModel().getValue(this.dimKeys.get(0))).getString(ID));
                param.setCustomParam(KEY_YEAR_ID, (Object)((DynamicObject)this.getModel().getValue(this.dimKeys.get(1))).getString(ID));
                param.setCustomParam(KEY_PERIOD_ID, (Object)((DynamicObject)this.getModel().getValue(this.dimKeys.get(2))).getString(ID));
                Pair org = Pair.onePair((Object)((DynamicObject)dynamicObjects.get(0)).getLong("entity"), (Object)((DynamicObject)dynamicObjects.get(0)).getString("entity.number"));
                CheckParam checkParam = this.getCheckParam((Pair<Long, String>)org, true);
                param.setCustomParam("checkParam", (Object)ObjectSerialUtil.toByteSerialized((Object)checkParam));
                param.setCustomParam("rows", (Object)rows);
                param.setCustomParam("parentLongNumber", (Object)EntityServiceHelper.getSecondLongNumber((String)TreeStructureServiceHelper.getLongNumber((String)"bcm_entitymembertree", (Long)((DynamicObject)dynamicObjects.get(0)).getLong("entity"))));
                param.setCaption(ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02\u5904\u7406", (String)"CheckMainPagePlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "diffpage_close"));
                if (parentView == null) {
                    this.getView().showForm(param);
                    this.getView().sendFormAction(mainPageView);
                } else {
                    parentView.showForm(param);
                    this.getView().sendFormAction(parentView);
                }
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    private Pair<Long[], String> getPairByCtlTmpl() {
        List<Long> pkIds = this.getChecktmplFilterId();
        if (pkIds.size() > 0) {
            Long[] ids = new Long[pkIds.size()];
            int i = 0;
            Iterator<Long> iterator = pkIds.iterator();
            while (iterator.hasNext()) {
                Long id;
                ids[i] = id = iterator.next();
                ++i;
            }
            return Pair.onePair((Object)ids, null);
        }
        return null;
    }

    private List<Long> getChecktmplFilterId() {
        String checktmpls = (String)this.getModel().getValue("checktmp");
        ArrayList<Long> pkIds = new ArrayList<Long>(10);
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)checktmpls)) {
            String[] checktmplsArray;
            for (String id : checktmplsArray = checktmpls.split(",")) {
                if ("0".equals(id)) {
                    return new ArrayList<Long>(10);
                }
                if ("".equals(id)) continue;
                pkIds.add(Long.parseLong(id));
            }
        }
        return pkIds;
    }

    private List<String> checkOrgPeriodStatus(List<Tuple<Long, String, String>> entities) {
        Set entrystatus = new HashSet(0);
        ArrayList<String> list = new ArrayList<String>(16);
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
        if (periodManage) {
            Long scene = ((DynamicObject)this.getModel().getValue(this.dimKeys.get(0))).getLong(ID);
            Long period = ((DynamicObject)this.getModel().getValue(this.dimKeys.get(2))).getLong(ID);
            Long year = ((DynamicObject)this.getModel().getValue(this.dimKeys.get(1))).getLong(ID);
            entrystatus = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)this.getModelId(), entities.stream().map(e -> (String)e.p2).collect(Collectors.toSet()), (Long)scene, (Long)year, (Long)period, (String)"datastatus");
            for (int i = entities.size() - 1; i >= 0; --i) {
                if (entrystatus.contains(entities.get((int)i).p2)) continue;
                list.add((String)entities.get((int)i).p2);
                entities.remove(i);
            }
        }
        return list;
    }

    private void initCheckTmplPerm() {
        Boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        this.getPageCache().put(KEY_ADMINUSERBOL, adminUserBol.toString());
        if (!adminUserBol.booleanValue()) {
            ArrayListMultimap checkTmplPermMap = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_checktmpl", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId());
            HashMap allCheckTmplPermMap = new HashMap();
            for (String key : checkTmplPermMap.keySet()) {
                List ids = checkTmplPermMap.get((Object)key);
                ids.forEach(id -> allCheckTmplPermMap.put(id.toString(), key));
            }
            this.getPageCache().put(KEY_ALLCHECKTMPLPERMMAP, SerializationUtils.toJsonString(allCheckTmplPermMap));
            this.getPageCache().put(KEY_NOPERMCHECKTMPL, SerializationUtils.toJsonString(checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()) == null ? new ArrayList() : checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue())));
            this.getPageCache().put(KEY_READONLYCHECKTMPL, SerializationUtils.toJsonString(checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue()) == null ? new ArrayList() : checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue())));
            this.getPageCache().put(KEY_READWRITEHECKTMPL, SerializationUtils.toJsonString(checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READWRITE.getValue()) == null ? new ArrayList() : checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READWRITE.getValue())));
        }
    }

    private Boolean getAdminUserBol() {
        return Boolean.parseBoolean(this.getPageCache().get(KEY_ADMINUSERBOL));
    }

    private List<Long> getCheckTmplPermByType(String key) {
        ArrayList<Long> result = new ArrayList<Long>();
        String s = this.getPageCache().get(key);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            List o = (List)SerializationUtils.fromJsonString((String)s, List.class);
            o.forEach(e -> result.add(LongUtil.toLong((Object)e)));
        }
        return result;
    }

    private Map<String, String> getAllCheckTmplPermMap() {
        String s = this.getPageCache().get(KEY_ALLCHECKTMPLPERMMAP);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return (Map)SerializationUtils.fromJsonString((String)s, Map.class);
        }
        return new HashMap<String, String>();
    }

    private void actionBatchDiffProcess(Pair<DiffModeEnum, DiffMethodEnum> diffPair) {
        this.actionBatchDiffProcess(diffPair, true);
    }

    private void actionBatchDiffProcess(Pair<DiffModeEnum, DiffMethodEnum> diffPair, boolean isRunByTask) {
        Long[] rows = this.getSelectEntry();
        if (rows != null && rows.length > 0) {
            this.checkParams(true);
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id, entity.id, entity.number, entity.name, number, status, diffmode, isautoelim,createtype,checktmpl.isenable,checktmpl.number", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)rows)});
            if (doc.size() != rows.length) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckMainPagePlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            PermissionService permissionService = PermissionServiceImpl.getInstance((Long)this.getModelId());
            Long entityDimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.ENTITY_DIM);
            for (DynamicObject dy : doc) {
                if (!permissionService.isAllReadPerm(entityDimensionId, "bcm_entitymembertree", (Collection)Sets.newHashSet((Object[])new Long[]{dy.getLong("entity.id")}))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u7ec4\u7ec7 %s \u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CheckMainPagePlugin_74", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dy.getString("entity.number")));
            }
            boolean diffmode = doc.stream().anyMatch(e -> StringUtils.isEmpty((CharSequence)e.getString("diffmode")));
            if (diffmode) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5bf9\u8d26\u3002", (String)"CheckMainPagePlugin_66", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            boolean periodManage = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012");
            if (periodManage && !CheckHelper.isStatusAllOpen(Arrays.asList(rows), this, this.getModelId())) {
                return;
            }
            this.checkAllInOneStatus(doc);
            HashMultimap mulMap = HashMultimap.create();
            doc.forEach(e -> {
                if (e.getInt("status") == 1) {
                    mulMap.put((Object)Pair.onePair((Object)e.getLong("entity.id"), (Object)e.getString("entity.number")), (Object)e.getLong(ID));
                }
            });
            if (mulMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u542f\u7528\u72b6\u6001\u7684\u6a21\u677f\u5bf9\u5e94\u7684\u672a\u786e\u8ba4\u72b6\u6001\u7684\u5bf9\u8d26\u8bb0\u5f55\u8fdb\u884c\u5dee\u5f02\u5904\u7406\u3002", (String)"CheckMainPagePlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                String notification;
                StringBuilder msg = new StringBuilder();
                HashMap result = new HashMap(16);
                ArrayList<String> noTmpls = new ArrayList<String>(16);
                ArrayList<String> quoteLocked = new ArrayList<String>(16);
                if (isRunByTask) {
                    HashMap<String, Object> params = new HashMap<String, Object>(5);
                    CheckParam checkParam = this.getCheckParam((Pair<Long, String>)((Pair)mulMap.asMap().keySet().iterator().next()), true);
                    checkParam.setDiffPair(diffPair);
                    params.put("checkParam", ObjectSerialUtil.toByteSerialized((Object)checkParam));
                    params.put("mulEntityMap", ObjectSerialUtil.toByteSerialized((Object)mulMap));
                    params.put("requestContext", RequestContext.get() != null ? ObjectSerialUtil.toByteSerialized((Object)RequestContext.get()) : null);
                    this.createTask(params, CheckUtil.getDiffPairName(diffPair), "kd.fi.bcm.business.check.task.BatchDiffProcessTask", "actionBatchDiffProcessClose");
                    return;
                }
                mulMap.asMap().forEach((entityPair, ids) -> {
                    if (!ids.isEmpty()) {
                        CheckParam checkParam = this.getCheckParam((Pair<Long, String>)entityPair, true);
                        checkParam.put("checkRecordIds", (Object)Sets.newHashSet((Iterable)ids));
                        checkParam.setIsAutoElim("0");
                        CheckResult checkResult = CheckServiceHelper.check((CheckContext)new CheckContext(checkParam), (Pair)diffPair);
                        if (checkResult == null) {
                            return;
                        }
                        if ("fail".equals(checkResult.getErrorCode())) {
                            msg.append(checkResult.getMessage());
                            msg.append("\n");
                            return;
                        }
                        if (checkResult.getData() instanceof Map) {
                            result.putAll((Map)checkResult.getData());
                        }
                    }
                });
                for (Map.Entry entry : result.entrySet()) {
                    Set flag;
                    String entity = (String)entry.getKey();
                    if ("lockAdjustInfo".equals(entity)) {
                        flag = (Set)entry.getValue();
                        msg.append((String)flag.iterator().next()).append("\n");
                        continue;
                    }
                    flag = (Set)entry.getValue();
                    if (flag.size() <= 0) continue;
                    if (flag.stream().anyMatch(e -> e.intValue() == -3)) {
                        noTmpls.add(entity);
                    }
                    if (!flag.stream().anyMatch(e -> e.intValue() == -4)) continue;
                    quoteLocked.add(entity);
                }
                if (noTmpls.size() > 0) {
                    notification = noTmpls.size() <= 5 ? Joiner.on((String)",").join(noTmpls) : Joiner.on((String)",").join(noTmpls.subList(0, 5)) + "......";
                    msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u7ec4\u7ec7\u6ca1\u6709\u5206\u914d\u5df2\u542f\u7528\u4e14\u9002\u7528\u5f53\u524d\u6709\u6548\u671f\u95f4\u7684\u5bf9\u8d26\u6a21\u677f\uff1a%s", (String)"CheckMainPagePlugin_83", (String)"fi-bcm-formplugin", (Object[])new Object[0]), notification)).append("\n");
                }
                if (quoteLocked.size() > 0) {
                    notification = quoteLocked.size() <= 5 ? Joiner.on((String)",").join(quoteLocked) : Joiner.on((String)",").join(quoteLocked.subList(0, 5)) + "......";
                    msg.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5982\u4e0b\u8bb0\u5f55\u7684\u5408\u5e76\u8282\u70b9\u5728\u65b0\u60c5\u666f\u4e0b\u672a\u5f00\u542f\u7ec4\u7ec7\u7248\u672c\u5316\uff1a%s", (String)"CheckMainPagePlugin_94", (String)"fi-bcm-formplugin", (Object[])new Object[0]), notification)).append("\n");
                }
                this.refreshBillList(true);
                if (msg.length() > 0) {
                    this.getView().showTipNotification(msg.toString());
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5dee\u5f02\u5904\u7406\u5df2\u5b8c\u6210\u3002", (String)"CheckMainPagePlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5dee\u5f02\u5904\u7406", "CheckMainPagePlugin_99", "fi-bcm-formplugin", "differenceDisposal"), new OPDescMultiLangEnumBridge("\u6279\u91cf\u5dee\u5f02\u5904\u7406\u5df2\u5b8c\u6210\u3002", "CheckMainPagePlugin_41", "fi-bcm-formplugin", null));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u8bb0\u5f55\u3002", (String)"CheckMainPagePlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void actionExport() {
        String selectValue = (String)this.getModel().getValue("reporttype");
        try {
            if ("1".equalsIgnoreCase(selectValue)) {
                BillList billlista = (BillList)this.getControl(ctl_billlistap);
                List idLists = billlista.getSelectedRows().stream().map(p -> (Long)p.getPrimaryKeyValue()).collect(Collectors.toList());
                if (idLists.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u8bb0\u5f55\u3002", (String)"CheckMainPagePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection record = new DynamicObjectCollection();
                BatchProcessHelper.batchConsume(idLists, (int)10000, t -> record.addAll((Collection)QueryServiceHelper.query((String)"bcm_checkrecord", (String)"checktmpl.name,entity.name,myentity.name,oppositeentity.name,myecmoney,mycvtpath,mycvtmoney,opecmoney,opcvtpath,opcvtmoney,cvtdifmoney,adjustnumber,diffmode,diffmethod,status,isautoelim,modifier.name,modifytime,id,myentity.number,oppositeentity.number,entity.number,checktmpl.number", (QFilter[])new QFilter[]{new QFilter(ID, "in", t)}, (String)"checktmpl.number asc,entity.longnumber asc,myentity.number asc,oppositeentity.number asc")));
                new CheckHelper().exportBillList(this.getView(), record, this.getPageCache().get(SHOW_STYLE), (String)this.getModel().getValue("createtype"), this.getModelId());
            } else {
                HashMap<String, String> map2 = new HashMap<String, String>(16);
                map2.put(SpreadProperties.ExportExcelFileMethod.FILENAME.k(), ResManager.loadKDString((String)"\u5bf9\u8d26\u8bb0\u5f55", (String)"CheckMainPagePlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                SpreadClientInvoker.invokeExportExcelFileMethod(this.getClientViewProxy(), spreadKey, map2);
            }
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "CheckMainPagePlugin_44", "fi-bcm-formplugin", "export"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u5bf9\u8d26\u62a5\u544a\u6210\u529f\u3002", "CheckMainPagePlugin_45", "fi-bcm-formplugin", null));
        }
        catch (Exception e) {
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "CheckMainPagePlugin_44", "fi-bcm-formplugin", "export"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u5bf9\u8d26\u62a5\u544a\u5931\u8d25\u3002", "CheckMainPagePlugin_46", "fi-bcm-formplugin", null));
            log.error(ThrowableHelper.toString((Exception)e));
        }
    }

    private void setOffsetType() {
        ComboEdit offsettype = (ComboEdit)this.getControl("offsettype");
        ArrayList<ComboItem> offsettypes = new ArrayList<ComboItem>(10);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.and("longnumber", "!=", (Object)"root");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_checktmplcatalog", (String)"number,name", (QFilter[])qfBuilder.toArray());
        offsettypes.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"CheckMainPagePlugin_79", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "all"));
        for (DynamicObject dn : query) {
            offsettypes.add(new ComboItem(new LocaleString(dn.getString(NAME)), dn.getString(NUMBER)));
        }
        offsettype.setComboItems(offsettypes);
        this.getModel().setValue("offsettype", (Object)"all");
    }

    private boolean checkMyOrgContainsLeaf() {
        List<Pair<Long, String>> orgIds = this.getOrgIds("myorg");
        if (!CollectionUtils.isEmpty(orgIds)) {
            for (Pair<Long, String> id : orgIds) {
                IDNumberTreeNode memberNode = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)((Long)id.p1));
                if (!memberNode.isLeaf()) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private List<Pair<Long, String>> getOrgIds(String key) {
        Long cslschemeid;
        HashSet orgids = new HashSet(16);
        String orgString = this.getPageCache().get(key);
        Long l = cslschemeid = this.getModel().getValue("cslscheme") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("cslscheme")).getLong(ID));
        if (cslschemeid == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CheckMainPagePlugin_98", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((CharSequence)orgString)) {
            List orgList = SerializationUtils.fromJsonStringToList((String)orgString, Map.class);
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            for (Object org : orgList) {
                Map map = (Map)org;
                new MembRangeItem("bcm_entitymembertree", Long.valueOf(Long.parseLong((String)map.get(ID))), (String)map.get(NUMBER), Integer.parseInt((String)map.get("scope")), !StringUtils.isEmpty((CharSequence)((CharSequence)map.get("pid"))), (Object)this.getModelId()).matchItems(e -> {
                    IDNumberTreeNode node = MemberReader.findEntityMemberById((String)modelNum, (Long)((Long)e.id));
                    if (cslschemeid == null || cslschemeid.equals(node.getProperty("cslscheme.id"))) {
                        orgids.add(Pair.onePair((Object)((Long)e.id), (Object)e.number));
                    }
                });
            }
        }
        return new ArrayList<Pair<Long, String>>(orgids);
    }

    private List<Pair<Long, String>> getOrgIdsByVersion(String key) {
        return (List)ThreadCache.get((Object)String.format("CHECK_ORGID_VERDION_%s", key), () -> {
            List<Pair<Long, String>> myOrgIds = this.getOrgIds(key);
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            DynamicObject year = (DynamicObject)this.getModel().getValue("year");
            DynamicObject scene = (DynamicObject)this.getModel().getValue("scenario");
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            if (myOrgIds.size() > 0 && model != null && year != null && scene != null && period != null) {
                List<DynamicObject> allFilterOrg = this.findAllParentOrgs(model.getLong(ID), myOrgIds.stream().map(e -> (Long)e.p1).collect(Collectors.toList()));
                FilterOrgStructParam orgParam = new FilterOrgStructParam(model.getLong(ID), scene.getLong(ID), year.getString(NUMBER), period.getLong(ID));
                orgParam.setFrom(FilterOrgStructParam.FROM_CHECKELIM);
                EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)orgParam, allFilterOrg);
                Set effectOrgIds = allFilterOrg.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
                myOrgIds.removeIf(e -> !effectOrgIds.contains(e.p1));
            }
            return myOrgIds;
        });
    }

    private Pair<List<Pair<Long, String>>, StringBuilder> filterCompanyByPerm(boolean isRemoveReadOnly, String key) {
        boolean isRemoveLeaf;
        List<Pair<Long, String>> orgIds = this.getOrgIdsByVersion(key);
        ArrayList<Pair<Long, String>> result = new ArrayList<Pair<Long, String>>(orgIds);
        boolean bl = isRemoveLeaf = isRemoveReadOnly && "myorg".equals(key);
        if (isRemoveLeaf) {
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            result.removeIf(e -> {
                IDNumberTreeNode node = MemberReader.findEntityMemberById((String)modelNum, (Long)((Long)e.p1));
                return node.isLeaf();
            });
        }
        HashSet<Pair> noPermOrg = new HashSet<Pair>(16);
        HashSet<Pair> readOnlyOrg = new HashSet<Pair>(16);
        Set allOrgIds = result.stream().map(e -> (Long)e.p1).collect(Collectors.toSet());
        PermissionService permissionService = PermissionServiceImpl.getInstance((Long)this.getModelId());
        Long entityDimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.ENTITY_DIM);
        Set noPermSet = permissionService.matchNoPermMembers(entityDimensionId, "bcm_entitymembertree", allOrgIds);
        Set readOnlyPermSet = permissionService.matchReadPermMembers(entityDimensionId, "bcm_entitymembertree", allOrgIds);
        for (Pair pair : result) {
            if (noPermSet.contains(pair.p1)) {
                noPermOrg.add(pair);
                continue;
            }
            if (!readOnlyPermSet.contains(pair.p1)) continue;
            readOnlyOrg.add(pair);
        }
        StringBuilder msg = new StringBuilder();
        if (noPermOrg.size() > 0) {
            result.removeAll(noPermOrg);
            String string = Joiner.on((String)",").join((Iterable)noPermOrg.stream().map(e -> (String)e.p2).collect(Collectors.toSet()));
            msg.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u7ec4\u7ec7 %s \u65e0\u6743,", (String)"CheckMainPagePlugin_71", (String)"fi-bcm-formplugin", (Object[])new Object[0]), string));
        }
        if (readOnlyOrg.size() > 0 && isRemoveReadOnly) {
            result.removeAll(readOnlyOrg);
            String string = Joiner.on((String)",").join((Iterable)readOnlyOrg.stream().map(e -> (String)e.p2).collect(Collectors.toSet()));
            msg.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u7ec4\u7ec7 %s \u53ea\u8bfb,", (String)"CheckMainPagePlugin_72", (String)"fi-bcm-formplugin", (Object[])new Object[0]), string));
        }
        if (msg.length() > 0) {
            msg.append(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u4e0a\u8ff0\u7ec4\u7ec7\u7684\u64cd\u4f5c\u3002", (String)"CheckMainPagePlugin_73", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Pair.onePair(result, (Object)msg);
    }

    private void loadPageRowFromDB() {
        JSONArray array;
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListUserConfig listUserConfig = ListUserConfig.retrieve((String)billList.getBillFormId());
        if (listUserConfig != null) {
            billList.setPageRow(listUserConfig.getPageRows());
        }
        String key = "bcm_checkmainpage.bcm_checkrecord.billlistap";
        String setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)key);
        if (!StringUtils.isEmpty((CharSequence)setting)) {
            array = JSON.parseArray((String)setting);
            array.removeIf(e -> adjColumns.contains(((JSONObject)e).getString("listFieldKey")));
            UserConfigServiceHelper.setSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)key, (String)array.toJSONString());
        }
        key = "bcm_checkrecord";
        setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)key);
        if (!StringUtils.isEmpty((CharSequence)setting)) {
            array = JSON.parseArray((String)setting);
            array.removeIf(e -> adjColumns.contains(((JSONObject)e).getString("listFieldKey")));
            UserConfigServiceHelper.setSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)key, (String)array.toJSONString());
        }
    }

    private void checkAllInOneStatus(DynamicObjectCollection dos) {
        Pair<Long, String> year = this.getPairByCtl("year");
        Pair<Long, String> period = this.getPairByCtl("period");
        Pair<Long, String> scene = this.getPairByCtl("scenario");
        Pair<Long, String> model = this.getPairByCtl("model");
        if (year == null || period == null || scene == null || model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u8d22\u5e74\u3001\u60c5\u666f\u3001\u671f\u95f4\u3002", (String)"CheckMainPagePlugin_76", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        CheckHelper.isExistArchiving(this.getModelId(), (String)scene.p2, (String)year.p2, (String)period.p2);
        Map<String, String> nameMap = dos.stream().collect(Collectors.toMap(e -> e.getString("entity.number"), e -> e.getString("entity.name"), (k1, k2) -> k2));
        Map orgStatus = AllInOneUtils.isSubmittedBatch((Long)((Long)model.p1), (Collection)dos.stream().map(e -> e.getString("entity.number")).collect(Collectors.toSet()), (Object)scene.p1, (Object)year.p1, (Object)period.p1);
        for (Map.Entry entry : orgStatus.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9 %1$s %2$S \u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u72b6\u6001\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5bf9\u8d26\u5206\u5f55\u6570\u636e\u3002", (String)"CheckMainPagePlugin_80", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entry.getKey(), nameMap.get(entry.getKey())));
        }
    }
}

