/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.bcm.business.linkquery.LinkQueryUtil;
import kd.fi.bcm.business.message.MessageBcmServiceHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class CheckSmartNoticePlugin
extends AbstractBaseFormPlugin {
    public static final String ORDER_BY = "checktmpl.number asc,entity.longnumber asc,myentity.number asc,oppositeentity.number asc";
    private static final String RECORD_SELECT_FIELDS = "id,number,model.id,checktmpl.id,checktmpl.name,checktmpl.number,entity.id,entity.number,entity.name,entity.longnumber,entity.cslscheme.name,myentity.id,myentity.number,myentity.name, oppositeentity.id,oppositeentity.number,oppositeentity.name,cvtdifmoney, adjustnumber, diffmode, status, isautoelim, modifier.name, modifytime, mark";
    private static final String ENTRY_SELECT_FIELDS = "entryentity.id as entryid,entryentity.entrydebitaccout.id as entrydebitaccout.id,entryentity.entrydebitaccout.number as entrydebitaccout.number,entryentity.entrydebitaccout.name as entrydebitaccout.name,entryentity.entrymyaccount.id as entrymyaccount.id,entryentity.entrycreditaccout.id as entrycreditaccout.id,entryentity.entrycreditaccout.number as entrycreditaccout.number,entryentity.entrycreditaccout.name as entrycreditaccout.name,entryentity.entrydebit as entrydebit,entryentity.entrycredit as entrycredit,entryentity.entrydebelimval as entrydebelimval,entryentity.entrycreelimval as entrycreelimval,entryentity.entryaudittrail.id as entryaudittrail.id,entryentity.entryaudittrail.number as entryaudittrail.number,entryentity.entryaudittrail.name as entryaudittrail.name,entryentity.entrychangetype.id as entrychangetype.id,entryentity.entrychangetype.number as entrychangetype.number,entryentity.entrychangetype.name as entrychangetype.name,entryentity.entrydim1.id as entrydim1.id,entryentity.entrydim1.number as entrydim1.number,entryentity.entrydim1.name as entrydim1.name,entryentity.entrydim2.id as entrydim2.id,entryentity.entrydim2.number as entrydim2.number,entryentity.entrydim2.name as entrydim2.name,entryentity.entrydim3.id as entrydim3.id,entryentity.entrydim3.number as entrydim3.number,entryentity.entrydim3.name as entrydim3.name,entryentity.entrydim4.id as entrydim4.id,entryentity.entrydim4.number as entrydim4.number,entryentity.entrydim4.name as entrydim4.name,entryentity.entrydim5.id as entrydim5.id,entryentity.entrydim5.number as entrydim5.number,entryentity.entrydim5.name as entrydim5.name,entryentity.entrydim6.id as entrydim6.id,entryentity.entrydim6.number as entrydim6.number,entryentity.entrydim6.name as entrydim6.name,entryentity.entrycompany.id as entrycompany.id,entryentity.entrycompany.number as entrycompany.number,entryentity.entrycompany.name as entrycompany.name,entryentity.entryprocess.id as entryprocess.id,entryentity.entryprocess.number as entryprocess.number,entryentity.entryprocess.name as entryprocess.name,entryentity.entrymultigaap.id as entrymultigaap.id,entryentity.entrymultigaap.number as entrymultigaap.number,entryentity.entrymultigaap.name as entrymultigaap.name,entryentity.entrydatasort.id as entrydatasort.id,entryentity.entrydatasort.number as entrydatasort.number,entryentity.entrydatasort.name as entrydatasort.name,entryentity.entryscene.id as entryscene.id,entryentity.entryscene.number as entryscene.number,entryentity.entryscene.name as entryscene.name,entryentity.entryyear.id as entryyear.id,entryentity.entryyear.number as entryyear.number,entryentity.entryyear.name as entryyear.name,entryentity.entryperiod.id as entryperiod.id,entryentity.entryperiod.number as entryperiod.number,entryentity.entryperiod.name as entryperiod.name,entryentity.entrymycompany.id as entrymycompany.id,entryentity.entrymycompany.number as entrymycompany.number,entryentity.entrymycompany.name as entrymycompany.name,entryentity.entryorg.id as entryorg.id,entryentity.entryorg.number as entryorg.number,entryentity.entryorg.name as entryorg.name, entryentity.entrydiffmode as entrydiffmode,entryentity.entrymyecmoney as entrymyecmoney,entryentity.entryopecmoney as entryopecmoney,entryentity.entrymycvtpath as entrymycvtpath,entryentity.entryopcvtpath as entryopcvtpath,entryentity.entryocmoney as entryocmoney,entryentity.entrymycvtmoney as entrymycvtmoney,entryentity.entryopcvtmoney as entryopcvtmoney,entryentity.difftype as difftype,entryentity.seq as seq";
    private static final String RPT_LINK = UrlService.getDomainContextUrl() + "?formId=bcm_cslreportprocess&reportId=";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok", "btncancel");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<String, String> messageParam = this.getMessageParam();
        String content = String.format(ResManager.loadKDString((String)"\u4f60\u597d\uff0c\u4f60\u5df2\u586b\u62a5\u7684%1$s\u7684\u6570\u636e\u4e0e\u5bf9\u65b9%2$s\u5bf9\u8d26\u5b58\u5728\u5dee\u5f02\uff0c\u8bf7\u786e\u8ba4\u5dee\u5f02\u4fe1\u606f\uff1a%3$s\u3002", (String)"CheckSmartNoticePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), messageParam.get("cslscheme") + messageParam.get("mcOrg") + messageParam.get("scenario") + messageParam.get("year") + messageParam.get("period") + messageParam.get("checkTmpl"), messageParam.get("icOrg"), messageParam.get("mark"));
        this.getModel().setValue("content", (Object)content);
        this.getModel().setValue("explain", (Object)String.format(ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u5176\u4e2d\u9700\u6309\u6240\u9009\u5bf9\u8d26\u8bb0\u5f55\u89e3\u6790\u6210\u5177\u4f53\u7ef4\u5ea6\u6210\u5458\u7684\u8bf7\u6309\u7279\u5b9a\u683c\u5f0f\u586b\u5199\uff0c\u76ee\u524d\u53ef\u652f\u6301\uff1a%1$s\u548c%2$s\u3002", (String)"CheckSmartNoticePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", messageParam.get("cslscheme"), messageParam.get("mcOrg"), messageParam.get("scenario"), messageParam.get("year"), messageParam.get("period"), messageParam.get("checkTmpl"), messageParam.get("icOrg")), messageParam.get("mark")));
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        switch (key = Control2.getKey()) {
            case "btnok": {
                this.sendSmartNotice();
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private void sendSmartNotice() {
        Boolean issendmy = (Boolean)this.getModel().getValue("issendmy");
        Boolean issendop = (Boolean)this.getModel().getValue("issendop");
        if (!issendmy.booleanValue() && !issendop.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u5176\u4e2d\u4e00\u65b9\u53d1\u9001\u901a\u77e5\u3002", (String)"CheckSmartNoticePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object content = this.getModel().getValue("content");
        if (content == null || StringUtils.isBlank((CharSequence)content.toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u901a\u77e5\u5185\u5bb9\u3002", (String)"CheckSmartNoticePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List checkId = (List)this.getFormCustomParam("ids");
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        DynamicObjectCollection userDefineDims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, shortnumber, fieldmapped, issysdimension", (QFilter[])new QFBuilder().add("model", "=", (Object)this.getModelId()).add("issysdimension", "=", (Object)Boolean.FALSE).toArray(), (String)"dseq");
        DynamicObjectCollection checkrecords = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,number,model.id,checktmpl.id,checktmpl.name,checktmpl.number,entity.id,entity.number,entity.name,entity.longnumber,entity.cslscheme.name,myentity.id,myentity.number,myentity.name, oppositeentity.id,oppositeentity.number,oppositeentity.name,cvtdifmoney, adjustnumber, diffmode, status, isautoelim, modifier.name, modifytime, mark,entryentity.id as entryid,entryentity.entrydebitaccout.id as entrydebitaccout.id,entryentity.entrydebitaccout.number as entrydebitaccout.number,entryentity.entrydebitaccout.name as entrydebitaccout.name,entryentity.entrymyaccount.id as entrymyaccount.id,entryentity.entrycreditaccout.id as entrycreditaccout.id,entryentity.entrycreditaccout.number as entrycreditaccout.number,entryentity.entrycreditaccout.name as entrycreditaccout.name,entryentity.entrydebit as entrydebit,entryentity.entrycredit as entrycredit,entryentity.entrydebelimval as entrydebelimval,entryentity.entrycreelimval as entrycreelimval,entryentity.entryaudittrail.id as entryaudittrail.id,entryentity.entryaudittrail.number as entryaudittrail.number,entryentity.entryaudittrail.name as entryaudittrail.name,entryentity.entrychangetype.id as entrychangetype.id,entryentity.entrychangetype.number as entrychangetype.number,entryentity.entrychangetype.name as entrychangetype.name,entryentity.entrydim1.id as entrydim1.id,entryentity.entrydim1.number as entrydim1.number,entryentity.entrydim1.name as entrydim1.name,entryentity.entrydim2.id as entrydim2.id,entryentity.entrydim2.number as entrydim2.number,entryentity.entrydim2.name as entrydim2.name,entryentity.entrydim3.id as entrydim3.id,entryentity.entrydim3.number as entrydim3.number,entryentity.entrydim3.name as entrydim3.name,entryentity.entrydim4.id as entrydim4.id,entryentity.entrydim4.number as entrydim4.number,entryentity.entrydim4.name as entrydim4.name,entryentity.entrydim5.id as entrydim5.id,entryentity.entrydim5.number as entrydim5.number,entryentity.entrydim5.name as entrydim5.name,entryentity.entrydim6.id as entrydim6.id,entryentity.entrydim6.number as entrydim6.number,entryentity.entrydim6.name as entrydim6.name,entryentity.entrycompany.id as entrycompany.id,entryentity.entrycompany.number as entrycompany.number,entryentity.entrycompany.name as entrycompany.name,entryentity.entryprocess.id as entryprocess.id,entryentity.entryprocess.number as entryprocess.number,entryentity.entryprocess.name as entryprocess.name,entryentity.entrymultigaap.id as entrymultigaap.id,entryentity.entrymultigaap.number as entrymultigaap.number,entryentity.entrymultigaap.name as entrymultigaap.name,entryentity.entrydatasort.id as entrydatasort.id,entryentity.entrydatasort.number as entrydatasort.number,entryentity.entrydatasort.name as entrydatasort.name,entryentity.entryscene.id as entryscene.id,entryentity.entryscene.number as entryscene.number,entryentity.entryscene.name as entryscene.name,entryentity.entryyear.id as entryyear.id,entryentity.entryyear.number as entryyear.number,entryentity.entryyear.name as entryyear.name,entryentity.entryperiod.id as entryperiod.id,entryentity.entryperiod.number as entryperiod.number,entryentity.entryperiod.name as entryperiod.name,entryentity.entrymycompany.id as entrymycompany.id,entryentity.entrymycompany.number as entrymycompany.number,entryentity.entrymycompany.name as entrymycompany.name,entryentity.entryorg.id as entryorg.id,entryentity.entryorg.number as entryorg.number,entryentity.entryorg.name as entryorg.name, entryentity.entrydiffmode as entrydiffmode,entryentity.entrymyecmoney as entrymyecmoney,entryentity.entryopecmoney as entryopecmoney,entryentity.entrymycvtpath as entrymycvtpath,entryentity.entryopcvtpath as entryopcvtpath,entryentity.entryocmoney as entryocmoney,entryentity.entrymycvtmoney as entrymycvtmoney,entryentity.entryopcvtmoney as entryopcvtmoney,entryentity.difftype as difftype,entryentity.seq as seq", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)checkId)}, (String)ORDER_BY);
        Map<Long, List<DynamicObject>> checkRecordMap = checkrecords.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
        if (checkRecordMap.size() != checkId.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u3002", (String)"CheckMainPagePlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder(16);
        Map<String, String> messageParam = this.getMessageParam();
        for (Map.Entry<Long, List<DynamicObject>> checkRecord : checkRecordMap.entrySet()) {
            List<DynamicObject> values = checkRecord.getValue();
            values.removeIf(e -> this.isDiffitem((DynamicObject)e));
            values.sort(Comparator.comparing(e -> e.getInt("seq")));
            if (issendmy.booleanValue()) {
                Optional<DynamicObject> myOptional = values.stream().filter(e -> Objects.equals(e.getString("entrycompany.number"), e.getString("oppositeentity.number"))).findFirst();
                myOptional.ifPresent(dynamicObject -> this.sendMsgByEntryData(content, modelId, userDefineDims, messageParam, (DynamicObject)dynamicObject, sb));
            }
            if (!issendop.booleanValue()) continue;
            Optional<DynamicObject> opOptional = values.stream().filter(e -> !Objects.equals(e.getString("entrycompany.number"), e.getString("oppositeentity.number"))).findFirst();
            opOptional.ifPresent(dynamicObject -> this.sendMsgByEntryData(content, modelId, userDefineDims, messageParam, (DynamicObject)dynamicObject, sb));
        }
        if (sb.length() > 0) {
            this.getView().getParentView().showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u901a\u77e5\u53d1\u9001\u7ed3\u679c", (String)"CheckSmartNoticePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
        } else {
            this.getView().getParentView().showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u901a\u77e5\u53d1\u9001\u7ed3\u679c", (String)"CheckSmartNoticePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u901a\u77e5\u5bf9\u8c61\u3002", (String)"CheckSmartNoticePlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageTypes.Default);
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bf9\u8d26\u667a\u80fd\u901a\u77e5", "CheckSmartNoticePlugin_17", "fi-bcm-formplugin", "checkNotice"), new OPDescMultiLangEnumBridge("\u53d1\u9001\u5bf9\u8d26\u667a\u80fd\u901a\u77e5\u6210\u529f\u3002", "CheckSmartNoticePlugin_18", "fi-bcm-formplugin", null));
    }

    private boolean isDiffitem(DynamicObject entry) {
        BigDecimal value1 = entry.getBigDecimal("entrydebit");
        BigDecimal value2 = entry.getBigDecimal("entrycredit");
        return BigDecimal.ZERO.compareTo(value1) == 0 && BigDecimal.ZERO.compareTo(value2) == 0;
    }

    private void sendMsgByEntryData(Object content, Long modelId, DynamicObjectCollection userDefineDims, Map<String, String> messageParam, DynamicObject entry, StringBuilder sb) {
        Map<String, String> dimMemberMap = this.getDimMemberMap(userDefineDims, entry);
        Map linkParam = LinkQueryUtil.getLinkParam((long)this.getModelId(), dimMemberMap, null);
        if (linkParam != null) {
            Long templateId = (Long)linkParam.get("tem");
            QFBuilder builder = new QFBuilder();
            builder.and("entity.number", "=", (Object)entry.getString("entryorg.number"));
            builder.and("template", "=", (Object)templateId);
            builder.and("currency.number", "=", (Object)dimMemberMap.get(PresetConstant.CURRENCY_DIM));
            builder.and("model", "=", (Object)modelId);
            builder.and("scene", "=", (Object)entry.getLong("entryscene.id"));
            builder.and("fyear", "=", (Object)entry.getLong("entryyear.id"));
            builder.and("period", "=", (Object)entry.getLong("entryperiod.id"));
            DynamicObject report = QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)"id,template.name,template.id,modifier.id,modifier.name", (QFilter[])builder.toArray());
            if (report != null && report.getLong("modifier.id") != 0L) {
                String title = ResManager.loadKDString((String)"\u5408\u5e76\u62a5\u8868\u5bf9\u8d26\u6d88\u606f\u901a\u77e5", (String)"CheckSmartNoticePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                String myOrgName = StringUtils.isNotEmpty((CharSequence)entry.getString("entrymycompany.name")) ? entry.getString("entrymycompany.name") : entry.getString("entryorg.name");
                String msgContent = content.toString().replace(messageParam.get("cslscheme"), this.formateParam(entry.getString("entity.cslscheme.name"))).replace(messageParam.get("mcOrg"), this.formateParam(myOrgName)).replace(messageParam.get("scenario"), this.formateParam(entry.getString("entryscene.name"))).replace(messageParam.get("year"), this.formateParam(entry.getString("entryyear.name"))).replace(messageParam.get("period"), this.formateParam(entry.getString("entryperiod.name"))).replace(messageParam.get("checkTmpl"), this.formateParam(entry.getString("checktmpl.name"))).replace(messageParam.get("icOrg"), this.formateParam(entry.getString("entrycompany.name"))).replace(messageParam.get("mark"), StringUtils.isNotEmpty((CharSequence)entry.getString("mark")) ? this.formateParam(entry.getString("mark")) : "");
                MessageBcmServiceHelper.sendSystemMessage((String)title, (String)msgContent, (List)Lists.newArrayList((Object[])new Long[]{report.getLong("modifier.id")}), (String)(RPT_LINK + report.getLong("id")));
                sb.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%1$s] \u62a5\u8868[%2$s] \u7f16\u5236\u4eba[%3$s] \u5df2\u53d1\u9001\u901a\u77e5\u3002", (String)"CheckSmartNoticePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entry.getString("entryorg.name"), report.getString("template.name"), report.getString("modifier.name"))).append("\n");
            }
        }
    }

    private Map<String, String> getDimMemberMap(DynamicObjectCollection userDefineDims, DynamicObject entry) {
        String[] strArry;
        HashMap<String, String> dimMemberMap = new HashMap<String, String>(16);
        dimMemberMap.put(PresetConstant.ENTITY_DIM, entry.getString("entryorg.number"));
        if (StringUtils.isNotEmpty((CharSequence)entry.getString("entrymycompany.number"))) {
            dimMemberMap.put(PresetConstant.MYCOMPANY_DIM, entry.getString("entrymycompany.number"));
        }
        dimMemberMap.put(PresetConstant.INTERNALCOMPANY_DIM, entry.getString("entrycompany.number"));
        dimMemberMap.put(PresetConstant.ACCOUNT_DIM, StringUtils.isNotEmpty((CharSequence)entry.getString("entrydebitaccout.number")) ? entry.getString("entrydebitaccout.number") : entry.getString("entrycreditaccout.number"));
        dimMemberMap.put(PresetConstant.SCENE_DIM, entry.getString("entryscene.number"));
        dimMemberMap.put(PresetConstant.FY_DIM, entry.getString("entryyear.number"));
        dimMemberMap.put(PresetConstant.PERIOD_DIM, entry.getString("entryperiod.number"));
        String cvtpath = entry.getString("entrymycvtpath");
        if (StringUtils.isBlank((CharSequence)cvtpath)) {
            cvtpath = entry.getString("entryopcvtpath");
        }
        if (StringUtils.isNotBlank((CharSequence)cvtpath) && (strArry = cvtpath.split("->")).length >= 1) {
            dimMemberMap.put(PresetConstant.CURRENCY_DIM, StringUtils.trim((String)strArry[0]));
        }
        dimMemberMap.put(PresetConstant.PROCESS_DIM, "Rpt");
        if (StringUtils.isNotEmpty((CharSequence)entry.getString("entryaudittrail.number"))) {
            dimMemberMap.put(PresetConstant.AUDITTRIAL_DIM, entry.getString("entryaudittrail.number"));
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getString("entrychangetype.number"))) {
            dimMemberMap.put(PresetConstant.CHANGETYPE_DIM, entry.getString("entrychangetype.number"));
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getString("entrymultigaap.number"))) {
            dimMemberMap.put(PresetConstant.RULE_DIM, entry.getString("entrymultigaap.number"));
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getString("entrydatasort.number"))) {
            dimMemberMap.put(PresetConstant.DATASORT_DIM, entry.getString("entrydatasort.number"));
        }
        for (DynamicObject dim : userDefineDims) {
            String property = "entry" + dim.getString("fieldmapped");
            dimMemberMap.put(dim.getString("number"), entry.getString(property + ".number"));
        }
        return dimMemberMap;
    }

    private Map<String, String> getMessageParam() {
        HashMap<String, String> messageParam = new HashMap<String, String>(5);
        messageParam.put("cslscheme", ResManager.loadKDString((String)"\u3010@\u7ec4\u7ec7\u89c6\u56fe\u3011", (String)"CheckSmartNoticePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        messageParam.put("mcOrg", ResManager.loadKDString((String)"\u3010@\u672c\u65b9\u5355\u4f4d\u3011", (String)"CheckSmartNoticePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        messageParam.put("scenario", ResManager.loadKDString((String)"\u3010@\u60c5\u666f\u3011", (String)"CheckSmartNoticePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        messageParam.put("year", ResManager.loadKDString((String)"\u3010@\u8d22\u5e74\u3011", (String)"CheckSmartNoticePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        messageParam.put("period", ResManager.loadKDString((String)"\u3010@\u671f\u95f4\u3011", (String)"CheckSmartNoticePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        messageParam.put("checkTmpl", ResManager.loadKDString((String)"\u3010@\u5bf9\u8d26\u6a21\u677f\u3011", (String)"CheckSmartNoticePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        messageParam.put("icOrg", ResManager.loadKDString((String)"\u3010@\u5bf9\u65b9\u5355\u4f4d\u3011", (String)"CheckSmartNoticePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        messageParam.put("mark", ResManager.loadKDString((String)"\u3010@\u5907\u6ce8\u4fe1\u606f\u3011", (String)"CheckSmartNoticePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return messageParam;
    }

    private String formateParam(String str) {
        return String.format("[%s]", str);
    }
}

