/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.TreeSearchResult;
import kd.fi.bcm.spread.common.util.StringUtil;

public class CheckTmplAccountF7Plugin
extends AbstractBaseFormPlugin
implements SetFilterListener,
SearchEnterListener {
    private static final String MEMBERLISTFLEX = "memberlistflex";
    private static final String MEMBERTREEFLEX = "membertreeflex";
    private static final String BILLLISTAP = "billlistap";
    private static final String MEMBERTREEAP = "membertreeap";
    private static final String RADIO = "radio";
    private static final String MEMRADIO = "memradio";
    private static final String LOCALRADIO = "localradio";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String DEFAULTSCOPE = "defaultscope";
    private static final String SEARCHAP = "searchap";
    private static final String IMAGEUP = "imageup";
    private static final String IMAGEDOWN = "imagedown";
    private static final String right_move = "addoneb";
    private static final String right_move_all = "addallb";
    private static final String left_move = "deloneb";
    private static final String left_move_all = "delallb";
    private static final String up_move = "mup";
    private static final String down_move = "mdown";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CLOSE = "btnclose";
    private static final String SCOPE = "scope";
    private boolean isFirstSwitchCustom = true;
    private static final String search_result = "search_result";
    private static final String cache_rootNode = "cache_rootNode";

    @Override
    public void initialize() {
        super.initialize();
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        billlistap.addSetFilterListener(this::setFilter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(right_move, right_move_all, left_move, left_move_all, up_move, down_move, BTN_OK, BTN_CLOSE, IMAGEUP, IMAGEDOWN);
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener(this::search);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        String radio = (String)this.getModel().getValue(RADIO);
        if (StringUtil.equals((String)radio, (String)"10")) {
            this.searchMemberList(text);
        } else if (StringUtil.equals((String)radio, (String)"20") && !StringUtils.isBlank((CharSequence)text)) {
            this.unCheckAllNode();
            this.searchCustomTree(text);
        } else {
            this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
        }
    }

    private void searchMemberList(String text) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        FilterParameter fp = new FilterParameter();
        if (!StringUtils.isBlank((CharSequence)text)) {
            fp.setFilter(new QFilter("number", "like", (Object)("%" + text + "%")).or("name", "like", (Object)("%" + text + "%")));
        }
        billList.setFilterParameter(fp);
        billList.clearSelection();
        billList.refresh();
    }

    private void unCheckAllNode() {
        String rootNodeseri = this.getPageCache().get(cache_rootNode);
        if (rootNodeseri != null) {
            TreeNode rootNode = (TreeNode)this.deSerializedBytes(rootNodeseri);
            List nodeIds = rootNode.getChildren().stream().map(TreeNode::getId).collect(Collectors.toList());
            TreeView treeView = (TreeView)this.getControl(MEMBERTREEAP);
            treeView.uncheckNodes(nodeIds);
        }
    }

    private void searchCustomTree(String text) {
        TreeView treeView = (TreeView)this.getControl(MEMBERTREEAP);
        String rootNodeCache = this.getPageCache().get(cache_rootNode);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>(10);
            root.getTreeNodeListByText(hitNode, text, 999);
            TreeSearchResult result = null;
            if (hitNode.size() > 0) {
                result = new TreeSearchResult(hitNode);
                TreeNode next = result.next(1);
                treeView.checkNode(next);
                this.getView().updateView(MEMBERTREEFLEX);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u540e\u91cd\u65b0\u641c\u7d22", (String)"CheckTmplAccountF7Plugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put(search_result, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        List membColl;
        super.afterCreateNewData(e);
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        String s = pageCache.get(sign);
        if (StringUtils.isNotEmpty((CharSequence)s) && !CollectionUtils.isEmpty((Collection)(membColl = (List)SerializationUtils.fromJsonString((String)s, List.class)))) {
            int size = membColl.size();
            IDataModel model = this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY1, size);
            for (int i = 0; i < size; ++i) {
                Map memInfo = (Map)membColl.get(i);
                model.setValue("mid", memInfo.get("id"), i);
                model.setValue("mnum", memInfo.get("number"), i);
                model.setValue("mname", memInfo.get("name"), i);
                model.setValue(SCOPE, memInfo.get(SCOPE), i);
                model.setValue("pid", memInfo.get("pid"), i);
            }
            model.endInit();
        }
        String radio = this.getModel().getValue(RADIO).toString();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY1);
        if (entryEntity.size() > 0 && !this.isCustom(((DynamicObject)entryEntity.get(0)).getLong("mid")) && "10".equals(radio)) {
            this.getModel().setValue(RADIO, (Object)"20");
            this.switchCustom();
        }
    }

    private boolean isCustom(Long id) {
        QFilter f1 = new QFilter("model", "=", (Object)this.getModelId());
        QFilter f2 = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{f1, f2};
        Map id1 = BusinessDataServiceHelper.loadFromCache((String)"bcm_accountmembertree", (String)"id", (QFilter[])filters);
        Map id2 = BusinessDataServiceHelper.loadFromCache((String)"bcm_definedpropertyvalue", (String)"id", (QFilter[])filters);
        if (id1.size() > 0) {
            return true;
        }
        return id2.size() <= 0;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY1);
        if (entryEntity.size() > 0 && !this.isCustom(((DynamicObject)entryEntity.get(0)).getLong("mid"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MEMBERLISTFLEX, up_move, down_move});
            this.getView().setVisible(Boolean.TRUE, new String[]{MEMBERTREEFLEX, SCOPE, DEFAULTSCOPE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{MEMBERLISTFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{MEMBERTREEFLEX, SCOPE, DEFAULTSCOPE, up_move, down_move});
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("accountpart.isaccountoffset", "=", (Object)Boolean.TRUE);
        if (sign.endsWith("elimaccounttree")) {
            qFilter.and("isleaf", "=", (Object)Boolean.TRUE);
            qFilter.and("storagetype", "in", (Object)StorageTypeEnum.getRealStorageEnumIndexs());
        } else {
            qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        }
        setFilterEvent.getQFilters().add(qFilter);
        setFilterEvent.setOrderBy("number asc");
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "addoneb": 
            case "addallb": 
            case "deloneb": 
            case "delallb": 
            case "mup": 
            case "mdown": {
                this.memberMoveOperation(key);
                break;
            }
            case "btnok": {
                DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRYENTITY1);
                this.getView().returnDataToParent((Object)doc);
                this.getView().close();
                break;
            }
            case "btnclose": {
                this.getView().close();
                break;
            }
            case "imageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": {
                this.searchNext(1);
            }
        }
    }

    private void searchNext(int i) {
        String radio = (String)this.getModel().getValue(RADIO);
        if ("10".equals(radio)) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(search_result);
        if (searchResultCache != null) {
            TreeSearchResult result = (TreeSearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(MEMBERTREEAP);
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"CheckTmplAccountF7Plugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"CheckTmplAccountF7Plugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else {
                tree.checkNode(next);
                tree.treeNodeClick(next.getParentid(), next.getId());
                pageCache.put(search_result, ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"CheckTmplAccountF7Plugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void memberMoveOperation(String opKey) {
        switch (opKey) {
            case "addoneb": {
                if (!this.checkMemberSelect()) break;
                this.memberRightMove(false);
                break;
            }
            case "addallb": {
                this.memberRightMove(true);
                break;
            }
            case "deloneb": {
                int row = this.getMemberSelectedRow();
                if (row < 0) break;
                this.getModel().deleteEntryRow(ENTRYENTITY1, row);
                break;
            }
            case "delallb": {
                this.clearSelectMember();
                this.isRadio();
                break;
            }
        }
    }

    private void isRadio() {
        boolean radio = this.getModel().getValue(RADIO).equals("10");
        if (radio) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MEMBERLISTFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{MEMBERTREEFLEX, SCOPE, DEFAULTSCOPE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{MEMBERLISTFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{MEMBERTREEFLEX, SCOPE, DEFAULTSCOPE});
        }
    }

    private int getMemberSelectedRow() {
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY1);
        int row = eg.getEntryState().getFocusRow();
        if (row < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"CheckTmplAccountF7Plugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return -1;
        }
        this.isRadio();
        return row;
    }

    private void memberRightMove(boolean isAll) {
        boolean mid;
        List<Map<String, String>> memInfos = this.memDataCollect(isAll);
        this.filterMemberByOther(memInfos);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY1);
        if (entryEntity.size() <= 0 || memInfos.size() <= 0) {
            this.RightMove(memInfos);
            return;
        }
        boolean radio = this.getModel().getValue(RADIO).equals("10");
        if (radio != (mid = this.isCustom(((DynamicObject)entryEntity.get(0)).getLong("mid")))) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(right_move, (IFormPlugin)this);
            this.getPageCache().put("memInfos", ObjectSerialUtil.toByteSerialized(memInfos));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53ea\u53ef\u6309\u6210\u5458\u6216\u6309\u81ea\u5b9a\u4e49\u5c5e\u6027\u5176\u4e2d\u7684\u4e00\u79cd\u65b9\u5f0f\u8fdb\u884c\u6210\u5458\u9009\u62e9\uff0c\u786e\u5b9a\u8986\u76d6\u5df2\u9009\u8bb0\u5f55\uff1f", (String)"CheckTmplAccountF7Plugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
            return;
        }
        this.RightMove(memInfos);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)right_move, (CharSequence)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.isRadio();
            this.clearSelectMember();
            List memInfos = (List)this.deSerializedBytes(this.getPageCache().get("memInfos"));
            this.RightMove(memInfos);
        }
    }

    private List<Map<String, String>> memDataCollect(boolean isAll) {
        String radio = this.getModel().getValue(RADIO).toString();
        ArrayList<Map<String, String>> memInfos = new ArrayList<Map<String, String>>();
        if (StringUtil.equals((String)radio, (String)"10")) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = isAll ? billList.getCurrentListAllRowCollection() : billList.getSelectedRows();
            selectedRows.forEach(r -> {
                HashMap<String, String> map = new HashMap<String, String>(5);
                map.put("id", r.getPrimaryKeyValue().toString());
                map.put("number", r.getNumber());
                map.put("name", r.getName());
                map.put(SCOPE, RangeEnum.VALUE_10.getValue() + "");
                map.put("pid", "");
                memInfos.add(map);
            });
        } else if (StringUtil.equals((String)radio, (String)"20")) {
            TreeView treeView = (TreeView)this.getControl(MEMBERTREEAP);
            List checkedNodes = treeView.getTreeState().getCheckedNodes();
            String defaultScope = this.getModel().getValue(DEFAULTSCOPE).toString();
            List customList = (List)this.deSerializedBytes(this.getPageCache().get("customList"));
            (isAll ? customList : checkedNodes).forEach(c -> {
                HashMap<String, String> map = new HashMap<String, String>(5);
                map.put("id", c.get("id").toString());
                String customNum = this.findCustomFieldValue(customList, "id", (String)c.get("id"), "propertynum");
                String customName = this.findCustomFieldValue(customList, "id", (String)c.get("id"), "propertyname");
                String[] numAndName = (isAll ? c.get("name") : c.get("text")).toString().split("\n\n");
                map.put("number", customNum + ":" + numAndName[0]);
                map.put("name", customName + ":" + numAndName[1]);
                map.put(SCOPE, defaultScope);
                map.put("pid", c.get("parentid").toString());
                memInfos.add(map);
            });
        }
        return memInfos;
    }

    private String findCustomFieldValue(List<Map<String, String>> customList, String conditionField, String conditionValue, String findField) {
        Map map = customList.stream().filter(c -> StringUtils.equals((CharSequence)((CharSequence)c.get(conditionField)), (CharSequence)conditionValue)).findFirst().orElse(null);
        return Optional.ofNullable(map).map(m -> (String)m.get(findField)).orElse("");
    }

    private void RightMove(List<Map<String, String>> memInfos) {
        if (CollectionUtils.isEmpty(memInfos)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        int startIdx = model.getEntryEntity(ENTRYENTITY1).size();
        model.batchCreateNewEntryRow(ENTRYENTITY1, memInfos.size());
        for (Map<String, String> memInfo : memInfos) {
            model.setValue("mid", (Object)memInfo.get("id"), startIdx);
            model.setValue("mnum", (Object)memInfo.get("number"), startIdx);
            model.setValue("mname", (Object)memInfo.get("name"), startIdx);
            model.setValue(SCOPE, (Object)memInfo.get(SCOPE), startIdx);
            model.setValue("pid", (Object)memInfo.get("pid"), startIdx);
            ++startIdx;
        }
        model.endInit();
        this.getView().updateView(ENTRYENTITY1);
    }

    private void filterMemberByOther(List<Map<String, String>> memInfos) {
        DynamicObjectCollection selectedMem = this.getModel().getEntryEntity(ENTRYENTITY1);
        Set selectedMemId = selectedMem.stream().map(m -> m.getLong("mid")).collect(Collectors.toSet());
        memInfos.removeIf(m -> selectedMemId.contains(Long.valueOf((String)m.get("id"))));
    }

    private boolean checkMemberSelect() {
        TreeView treeView;
        int size;
        String radio = this.getModel().getValue(RADIO).toString();
        if (StringUtil.equals((String)radio, (String)"10")) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            if (billList.getSelectedRows().size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"CheckTmplAccountF7Plugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (StringUtil.equals((String)radio, (String)"20") && (size = (treeView = (TreeView)this.getControl(MEMBERTREEAP)).getTreeState().getCheckedNodeIds().size()) < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"CheckTmplAccountF7Plugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "memradio": {
                this.switchMember();
                break;
            }
            case "localradio": {
                this.switchCustom();
                break;
            }
            case "radio": {
                String radio = this.getModel().getValue(RADIO).toString();
                if (StringUtil.equals((String)radio, (String)"10")) {
                    this.switchMember();
                    break;
                }
                if (!StringUtil.equals((String)radio, (String)"20")) break;
                this.switchCustom();
            }
        }
    }

    private void switchCustom() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY1);
        String radio = this.getModel().getValue(RADIO).toString();
        if (entryEntity.size() > 0 && this.isCustom(((DynamicObject)entryEntity.get(0)).getLong("mid")) || entryEntity.size() <= 0 && radio.equals("10")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MEMBERLISTFLEX, SCOPE, DEFAULTSCOPE});
            this.getView().setVisible(Boolean.TRUE, new String[]{MEMBERTREEFLEX});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{MEMBERLISTFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{MEMBERTREEFLEX, SCOPE, DEFAULTSCOPE});
        }
        if (this.isFirstSwitchCustom) {
            Long dimensionId;
            this.isFirstSwitchCustom = false;
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Long modelId = (Long)parameter.getCustomParam("KEY_MODEL_ID");
            DynamicObjectCollection customValue = this.getCustomValue(modelId, dimensionId = (Long)parameter.getCustomParam("dimensionId"));
            if (CollectionUtils.isEmpty((Collection)customValue)) {
                return;
            }
            ArrayList customList = new ArrayList(customValue.size());
            TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"CheckTmplAccountF7Plugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            customValue.forEach(c -> {
                HashMap<String, String> map = new HashMap<String, String>(5);
                map.put("id", c.getString("id"));
                map.put("number", c.getString("number"));
                map.put("name", c.getString("number") + "\n\n" + c.getString("name"));
                map.put("parentid", c.getString("parentid"));
                map.put("propertyid", c.getString("propertyid"));
                map.put("propertynum", c.getString("propertyid.number"));
                map.put("propertyname", c.getString("propertyid.name"));
                customList.add(map);
            });
            BCMTreeUtils.setEntryNode((TreeNode)rootNode, customList, (String)rootNode.getId());
            BCMTreeUtils.spreadAllNode((TreeNode)rootNode);
            TreeView treeView = (TreeView)this.getControl(MEMBERTREEAP);
            treeView.addNode(rootNode);
            this.getView().updateView("memselectflex");
            this.getPageCache().put("customList", this.toByteSerialized(customList));
            this.getPageCache().put(cache_rootNode, this.toByteSerialized(rootNode));
        }
    }

    private DynamicObjectCollection getCustomValue(Long modelId, Long dimensionId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension", "=", (Object)dimensionId);
        DynamicObjectCollection customs = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id", (QFilter[])qFilter.toArray());
        Set customIds = customs.stream().map(c -> c.getLong("id")).collect(Collectors.toSet());
        QFilter qf = new QFilter("propertyid", "in", customIds);
        DynamicObjectCollection customValue = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,name,parentid,propertyid,propertyid.number,propertyid.name", (QFilter[])qf.toArray());
        return customValue;
    }

    private void switchMember() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY1);
        String radio = this.getModel().getValue(RADIO).toString();
        if (entryEntity.size() > 0 && this.isCustom(((DynamicObject)entryEntity.get(0)).getLong("mid")) || entryEntity.size() <= 0 && radio.equals("10")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MEMBERLISTFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{MEMBERTREEFLEX, SCOPE, DEFAULTSCOPE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{MEMBERLISTFLEX, SCOPE, DEFAULTSCOPE});
            this.getView().setVisible(Boolean.FALSE, new String[]{MEMBERTREEFLEX});
        }
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.refresh();
    }

    private void clearSelectMember() {
        this.getModel().deleteEntryData(ENTRYENTITY1);
    }
}

