/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.check.CheckHelper;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import org.apache.commons.collections.CollectionUtils;

public class CheckTmplAssignPlugin
extends AbstractBaseFormPlugin
implements TreeNodeCheckListener {
    public static final String ctl_selectorg = "dentity";
    public static final String ctl_temcatalogtree = "temcatalogtree";
    public static final String ctl_billlistap = "billlistap";
    public static final String KEY_SCENE = "scene";

    private String getOperationSend() {
        return ResManager.loadKDString((String)"\u5206\u914d", (String)"CheckTmplAssignPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private final String getOperationBackSend() {
        return ResManager.loadKDString((String)"\u53cd\u5206\u914d", (String)"CheckTmplAssignPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"CheckTmplAssignPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"CheckTmplAssignPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addListeners();
    }

    private void addListeners() {
        this.addClickListeners("btn_selectorg", "btn_deleteorg", "btn_unassign", "btn_details");
        this.addItemClickListeners("toolbarap");
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        tree.addTreeNodeCheckListener(this::treeNodeCheck);
        EntryGrid orgeg = (EntryGrid)this.getControl(ctl_selectorg);
        orgeg.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                CheckTmplAssignPlugin.this.refreshBillList();
            }
        });
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent evt) {
                List filters = evt.getQFilters();
                QFilter filter1 = CheckTmplAssignPlugin.this.getTemQueryFilter(CheckTmplAssignPlugin.ctl_temcatalogtree, "template");
                QFilter filter2 = CheckTmplAssignPlugin.this.getOrgQueryFilter(CheckTmplAssignPlugin.ctl_selectorg, "oid", "entity");
                if (filter1 == null && filter2 == null) {
                    filters.add(new QFilter("1", "!=", (Object)1));
                } else if (filter1 == null) {
                    filters.add(filter2);
                } else if (filter2 == null) {
                    filters.add(filter1);
                } else {
                    filters.add(filter1.and(filter2));
                }
            }
        });
        billList.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listCol = args.getListColumns();
                String viewid = (String)CheckTmplAssignPlugin.this.getModel().getValue("viewcombo");
                if (!viewid.equals("10") && viewid.equals("20")) {
                    Collections.swap(listCol, 0, 1);
                    Collections.swap(listCol, 1, 2);
                }
            }
        });
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_selectorg": {
                this.actionSelectOrg();
                break;
            }
            case "btn_deleteorg": {
                this.actionDeleteOrg();
                break;
            }
            case "btn_unassign": {
                this.actionUnAssign();
                break;
            }
            case "btn_details": {
                this.actionViewDetail();
                break;
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeView source = (TreeView)evt.getSource();
        List tids = source.getTreeState().getSelectedNodeId().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        if (tids.isEmpty()) {
            this.getPageCache().remove("templeteids");
        } else {
            this.getPageCache().put("templeteids", SerializationUtils.toJsonString(tids));
        }
        this.refreshBillList();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_distribute".equals(key)) {
            this.actionAssign();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("viewcombo".equals(key)) {
            this.refreshBillList();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelid = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.getPageCache().put("KEY_MODEL_ID", modelid.toString());
        Long sceneId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam(KEY_SCENE));
        this.getPageCache().put(KEY_SCENE, sceneId.toString());
        if (modelid != 0L) {
            this.setTemplateDate2View(modelid);
        }
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.setFilterParameter(fp);
        this.refreshBillList();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(ctl_selectorg);
        if ("ccb_selectmember".equals(actionId) && e.getReturnData() != null) {
            DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
            this.selectOrgMember(olddoc, newdoc);
            this.refreshBillList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("delete_comfirm".equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList billlist = (BillList)this.getControl(ctl_billlistap);
            ListSelectedRowCollection listrows = billlist.getSelectedRows();
            String selectFields = "id,template,template.number,template.name,entity,range,propertyvalue";
            Object[] rows = listrows.getPrimaryKeyValues();
            QFilter filter = new QFilter("id", "in", (Object)rows);
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_checktmplassignentry", (String)selectFields, (QFilter[])new QFilter[]{filter});
            ArrayList<Long> idlist = new ArrayList<Long>(10);
            for (DynamicObject d : doc) {
                idlist.add(d.getLong("id"));
            }
            if (idlist.size() > 0) {
                try (TXHandle tx = TX.beginRequired();){
                    try {
                        BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_checktmplassignentry"), (Object[])idlist.toArray());
                        this.backSendLog(doc, this.getOperationStstusSuccess());
                    }
                    catch (KDBizException e1) {
                        this.backSendLog(doc, this.getOperationStstusFail());
                        tx.markRollback();
                        throw e1;
                    }
                    catch (Throwable e1) {
                        this.backSendLog(doc, this.getOperationStstusFail());
                        tx.markRollback();
                        throw e1;
                    }
                }
            }
            this.refreshBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5b8c\u6210\u3002", (String)"CheckTmplAssignPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void backSendLog(DynamicObjectCollection doc, String status) {
        for (DynamicObject dy : doc) {
            String number = dy.getString("template.number");
            String name = dy.getString("template.name");
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u53cd\u5206\u914d", "CheckTmplAssignPlugin_17", "fi-bcm-formplugin", "unassign"), new OPDescMultiLangEnumBridge("\u5bf9\u8d26\u6a21\u677f%1$s %2$s\u53cd\u5206\u914d%3$s", "CheckTmplAssignPlugin_21", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number, name, status})));
        }
    }

    private void assignSendLog(DynamicObjectCollection doc, String status) {
        for (DynamicObject dy : doc) {
            String number = dy.getString("number");
            String name = dy.getString("name");
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5206\u914d", "CheckTmplAssignPlugin_0", "fi-bcm-formplugin", "assign"), new OPDescMultiLangEnumBridge("\u5bf9\u8d26\u6a21\u677f%1$s %2$s\u5206\u914d%3$s", "CheckTmplAssignPlugin_22", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number, name, status})));
        }
    }

    private void selectOrgMember(DynamicObjectCollection olddoc, DynamicObjectCollection newdoc) {
        IDataModel model = this.getModel();
        boolean isexist = false;
        HashSet<Integer> list = new HashSet<Integer>(10);
        EntryGrid eg = (EntryGrid)this.getControl(ctl_selectorg);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newone : newdoc) {
            isexist = false;
            for (DynamicObject oldone : olddoc) {
                if (!newone.get("mid1").equals(oldone.get("oid")) || !newone.get("filltypevalue1").equals(oldone.get("rangevalue"))) continue;
                isexist = true;
                break;
            }
            if (isexist) continue;
            int index = model.createNewEntryRow(ctl_selectorg);
            model.setValue("entity", newone.get(3), index);
            model.setValue("rangevalue", newone.get(5), index);
            model.setValue("oid", newone.get(4), index);
            model.setValue("pid", newone.get(6), index);
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.size() == 0) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private void refreshBillList() {
        BillList billlist = (BillList)this.getControl(ctl_billlistap);
        billlist.refresh();
        billlist.clearSelection();
    }

    private QFilter getTemQueryFilter(String entityid, String columnname) {
        List<String> rows = this.getTemSelectedAndResultList(entityid);
        QFilter filter = null;
        if (rows.size() > 0) {
            filter = new QFilter(columnname, "in", (Object)LongUtil.toLongList(rows).toArray());
        }
        return filter;
    }

    private List<String> getTemSelectedAndResultList(String entityid) {
        TreeView tree = (TreeView)this.getControl(entityid);
        List<String> tids = tree.getTreeState().getSelectedNodeId().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        if (tids.isEmpty()) {
            String cache = this.getPageCache().get("templeteids");
            tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList(10);
        } else {
            this.getPageCache().put("templeteids", SerializationUtils.toJsonString(tids));
        }
        DynamicObjectCollection doc = this.getTemplatecatalogList();
        LinkedList<String> clist = new LinkedList<String>();
        for (DynamicObject dd : doc) {
            clist.add(dd.getString("id"));
        }
        tids.removeAll(clist);
        return tids;
    }

    private DynamicObjectCollection getTemplatecatalogList() {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,parent,name";
        String orderBys = "longnumber";
        return QueryServiceHelper.query((String)"bcm_checktmplcatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    private QFilter getOrgQueryFilter(String entityid, String idname, String columnname) {
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList(entityid);
        Set orgids = orglist.stream().map(e -> e.getLong("oid")).collect(Collectors.toSet());
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.getModelId());
        qf.add("id", "in", orgids);
        HashMap idMap = new HashMap(orgids.size());
        QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, copyfrom.id", (QFilter[])qf.toArray()).forEach(e -> {
            Long baseid = e.getLong("copyfrom.id");
            Long id = e.getLong("id");
            if (baseid != null && baseid != 0L) {
                idMap.put(id, baseid);
            } else {
                idMap.put(id, id);
            }
        });
        LinkedList mrows = new LinkedList();
        LinkedList<Long> lrows = new LinkedList<Long>();
        for (DynamicObject org : orglist) {
            if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim())) {
                mrows.add(idMap.get(Long.valueOf(org.get(idname).toString())));
                continue;
            }
            lrows.add(org.getLong(idname));
        }
        QFilter filter = null;
        if (mrows.size() > 0) {
            filter = new QFilter(columnname, "in", (Object)mrows.toArray());
        }
        if (lrows.size() > 0) {
            QFilter filter2 = new QFilter("propertyvalue", "in", (Object)lrows.toArray());
            filter = filter == null ? filter2 : filter.or(filter2);
        }
        return filter;
    }

    private List<DynamicObject> getOrgSelectedAndResultList(String entityid) {
        EntryGrid eg = (EntryGrid)this.getControl(entityid);
        int[] rows = eg.getEntryState().getSelectedRows();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (int row : rows) {
            DynamicObject dd = this.getModel().getEntryRowEntity(entityid, row);
            if (dd == null) continue;
            list.add(dd);
        }
        return list;
    }

    private void actionSelectOrg() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"CheckTmplAssignPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ccb_selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void actionDeleteOrg() {
        EntryGrid eg = (EntryGrid)this.getControl(ctl_selectorg);
        int[] row = eg.getEntryState().getSelectedRows();
        if (row.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"CheckTmplAssignPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ctl_selectorg, row);
        this.refreshBillList();
    }

    private void actionUnAssign() {
        BillList billlist = (BillList)this.getControl(ctl_billlistap);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"CheckTmplAssignPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53cd\u5206\u914d\u3002", (String)"CheckTmplAssignPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    private void actionAssign() {
        List<String> temlist = this.getTemSelectedAndResultList(ctl_temcatalogtree);
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList(ctl_selectorg);
        if (temlist.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6a21\u677f\u3002", (String)"CheckTmplAssignPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (orglist.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"CheckTmplAssignPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (temlist.size() < 1) {
            return;
        }
        if (this.checkTempAssign(LongUtil.toLongList(temlist), orglist)) {
            this.saveDistributeRecord(this.mergeResult(orglist, temlist, this.getModelId()));
        }
    }

    private boolean checkTempAssign(List<Long> temlist, List<DynamicObject> orglist) {
        HashMap<String, Set<SimpleItem>> orgMembRangeItemCache = new HashMap<String, Set<SimpleItem>>(16);
        HashSet baseOrgNumSet = new HashSet(16);
        for (DynamicObject org : orglist) {
            baseOrgNumSet.addAll(this.getOriginOrgs(org, orgMembRangeItemCache).stream().map(SimpleItem::getNumber).collect(Collectors.toSet()));
        }
        SaveServiceHelper.clearDataEntityCache((String)"bcm_checktmpl");
        Map tmplMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_checktmpl", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.getModelId())});
        if (!tmplMap.keySet().containsAll(temlist)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u6a21\u677f\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CheckTmplAssignPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashSet<Long> tempSet = new HashSet<Long>(temlist);
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.getModelId());
        qf.add("template.model.id", "=", (Object)this.getModelId());
        String selectFields = "entity.id, entity.number, template.id, template.number, property.id, property.number, propertyvalue.id, propertyvalue.number, range";
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_checktmplassignentry", (String)selectFields, (QFilter[])qf.toArray());
        HashMultimap tempAssignMap = HashMultimap.create();
        docs.forEach(arg_0 -> CheckTmplAssignPlugin.lambda$checkTempAssign$4((Multimap)tempAssignMap, arg_0));
        HashMap compareMap = new HashMap(16);
        HashMap<String, Set<Pair<Long, String>>> membRangeItemCache = new HashMap<String, Set<Pair<Long, String>>>(16);
        for (Long tempId : temlist) {
            Set<Long> sameScenarioTmpls = CheckHelper.filterScenario(this.getModelId(), (DynamicObject)tmplMap.get(tempId), tmplMap.values(), membRangeItemCache);
            Set needToCompareId = temlist.stream().filter(e -> !e.equals(tempId) && sameScenarioTmpls.contains(e)).collect(Collectors.toSet());
            Set assignCol = docs.stream().filter(e -> sameScenarioTmpls.contains(e.getLong("template.id"))).collect(Collectors.toSet());
            for (DynamicObject d : assignCol) {
                Set dOrgNums;
                long tid = d.getLong("template.id");
                if (tempId.equals(tid) || !CollectionUtils.containsAny(baseOrgNumSet, dOrgNums = this.getOrgs(d, orgMembRangeItemCache).stream().map(SimpleItem::getNumber).collect(Collectors.toSet()))) continue;
                needToCompareId.add(tid);
            }
            Set tmps = tmplMap.values().stream().filter(tm -> needToCompareId.contains(tm.getLong("id"))).collect(Collectors.toSet());
            compareMap.put(tmplMap.get(tempId), tmps);
        }
        List allYearIds = DimensionServiceHelper.getYearIdsByModel((long)this.getModelId());
        Set<Long> allPeriodIds = MemberReader.getAllNodeFromCache((String)"bcm_periodmembertree", (Object)this.getModelId()).keySet();
        for (Map.Entry kv : compareMap.entrySet()) {
            for (DynamicObject tmp2 : (Set)kv.getValue()) {
                if (!this.checkSameDims((DynamicObject)kv.getKey(), tmp2, allYearIds, allPeriodIds)) continue;
                HashSet<String> orgNums = new HashSet<String>(16);
                if (tempSet.contains(tmp2.getLong("id"))) {
                    for (DynamicObject item : orglist) {
                        orgNums.addAll(this.getOriginOrgs(item, orgMembRangeItemCache).stream().map(SimpleItem::getNumber).collect(Collectors.toSet()));
                    }
                }
                for (DynamicObject dyn : tempAssignMap.get((Object)tmp2.getLong("id"))) {
                    orgNums.addAll(this.getOrgs(dyn, orgMembRangeItemCache).stream().map(SimpleItem::getNumber).collect(Collectors.toSet()));
                }
                orgNums.retainAll(baseOrgNumSet);
                this.showErrorNotification(orgNums, (DynamicObject)kv.getKey(), tmp2);
                return false;
            }
        }
        return true;
    }

    private String getOrgNotice(Collection<String> orgNumbers) {
        if (CollectionUtils.isNotEmpty(orgNumbers)) {
            if (orgNumbers.size() > 4) {
                orgNumbers = orgNumbers.stream().limit(4L).collect(Collectors.toSet());
                orgNumbers.add("\u2026\u2026");
            }
            return StringUtils.join((Object[])orgNumbers.toArray(), (String)"\uff0c");
        }
        return null;
    }

    private boolean checkSameDims(DynamicObject temp1, DynamicObject temp2, List<Long> allYearIds, Set<Long> allPeriodIds) {
        DynamicObjectCollection entries1 = temp1.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entries2 = temp2.getDynamicObjectCollection("entryentity");
        if (!CheckHelper.checkPeriod(temp1, temp2, allYearIds, allPeriodIds).booleanValue()) {
            return false;
        }
        for (DynamicObject entry1 : entries1) {
            for (DynamicObject entry2 : entries2) {
                if (this.checkDiffitem(entry1, entry2) || !this.checkDim(entry1, entry2, "datasort") || !this.checkDim(entry1, entry2, "multigaap") || !this.checkDim(entry1, entry2, "changetype") || !this.checkDim(entry1, entry2, "mycompany") || !this.checkAccount(entry1, entry2) || !this.checkDetailscope(entry1, entry2)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<SimpleItem> getOrgs(DynamicObject org, Map<String, Set<SimpleItem>> orgMembRangeItemCache) {
        String mnumber;
        long mId;
        boolean isCustom;
        if (org == null) {
            return new HashSet<SimpleItem>(16);
        }
        if (org.getLong("propertyvalue.id") != 0L) {
            isCustom = true;
            mId = org.getLong("propertyvalue.id");
            mnumber = org.getString("propertyvalue.number");
        } else {
            isCustom = false;
            mId = org.getLong("entity.id");
            mnumber = org.getString("entity.number");
        }
        RangeEnum range = RangeEnum.getRangeByVal((int)org.getInt("range"));
        MembRangeItem item = new MembRangeItem("bcm_entitymembertree", Long.valueOf(mId), mnumber, range, isCustom, (Object)this.getModelId());
        String key = item.genKey((Object)"");
        return orgMembRangeItemCache.computeIfAbsent(key, v -> {
            HashSet orgIds = new HashSet(16);
            item.matchItems(orgIds::add);
            return orgIds;
        });
    }

    private Set<SimpleItem> getOriginOrgs(DynamicObject org, Map<String, Set<SimpleItem>> orgMembRangeItemCache) {
        if (org == null) {
            return new HashSet<SimpleItem>(16);
        }
        MembRangeItem item = new MembRangeItem("bcm_entitymembertree", Long.valueOf(org.getLong("oid")), null, RangeEnum.getRangeByVal((int)org.getInt("rangevalue")), StringUtils.isNotEmpty((CharSequence)org.getString("pid")), (Object)this.getModelId());
        String key = item.genKey((Object)"");
        return orgMembRangeItemCache.computeIfAbsent(key, v -> {
            HashSet orgIds = new HashSet(16);
            item.matchItems(orgIds::add);
            return orgIds;
        });
    }

    private void showErrorNotification(Set<String> orgNums, DynamicObject temp1, DynamicObject temp2) {
        String notice = this.getOrgNotice(orgNums);
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s\u548c%2$s\u6709\u91cd\u590d\u7ef4\u5ea6\u7ec4\u5408\uff0c\u4e0d\u80fd\u5206\u914d\u7ed9\u540c\u4e00\u7ec4\u7ec7%3$s\u3002", (String)"CheckTmplAssignPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), temp1.getString("number"), temp2.getString("number"), notice));
    }

    private boolean checkDim(DynamicObject entry1, DynamicObject entry2, String dim) {
        DynamicObject changetype1 = entry1.getDynamicObject(dim);
        DynamicObject changetype2 = entry2.getDynamicObject(dim);
        return changetype1 == null || changetype2 == null || changetype1.getLong("id") == changetype2.getLong("id");
    }

    private boolean checkDetailscope(DynamicObject entry1, DynamicObject entry2) {
        DynamicObjectCollection scope2;
        DynamicObjectCollection scope1 = entry1.getDynamicObjectCollection("detailscope");
        return this.checkDetailscope(scope1, scope2 = entry2.getDynamicObjectCollection("detailscope"), "audittrail", "bcm_audittrialmembertree") && this.checkDetailscope(scope1, scope2, "dim1", "bcm_userdefinedmembertree") && this.checkDetailscope(scope1, scope2, "dim2", "bcm_userdefinedmembertree") && this.checkDetailscope(scope1, scope2, "dim3", "bcm_userdefinedmembertree") && this.checkDetailscope(scope1, scope2, "dim4", "bcm_userdefinedmembertree") && this.checkDetailscope(scope1, scope2, "dim5", "bcm_userdefinedmembertree") && this.checkDetailscope(scope1, scope2, "dim6", "bcm_userdefinedmembertree") && this.checkDetailscope(scope1, scope2, "company", "bcm_icmembertree");
    }

    private boolean checkDetailscope(DynamicObjectCollection detailscope1, DynamicObjectCollection detailscope2, String sign, String entity) {
        Object audittrail1 = null;
        for (Object scope : detailscope1) {
            if (!sign.equals(scope.getString("sign"))) continue;
            audittrail1 = scope;
        }
        DynamicObject audittrail2 = null;
        for (DynamicObject scope : detailscope2) {
            if (!sign.equals(scope.getString("sign"))) continue;
            audittrail2 = scope;
        }
        if (audittrail1 == null || audittrail2 == null) {
            return true;
        }
        HashSet member1 = new HashSet(16);
        long mId = audittrail1.getLong("memberid");
        RangeEnum range = RangeEnum.getRangeByVal((int)audittrail1.getInt("scope"));
        new MembRangeItem(entity, Long.valueOf(mId), null, range, false, (Object)this.getModelId()).matchItems(e -> member1.add(Long.valueOf(e.id.toString())));
        HashSet member2 = new HashSet(16);
        mId = audittrail2.getLong("memberid");
        range = RangeEnum.getRangeByVal((int)audittrail2.getInt("scope"));
        new MembRangeItem(entity, Long.valueOf(mId), null, range, false, (Object)this.getModelId()).matchItems(e -> member2.add(Long.valueOf(e.id.toString())));
        for (Long member : member1) {
            if (!member2.contains(member)) continue;
            return true;
        }
        return false;
    }

    private void saveDistributeRecord(List<DynamicObject> dlist) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter filter2 = new QFilter("template.id", "in", dlist.stream().map(e -> LongUtil.toLong((Object)e.get("template"))).collect(Collectors.toSet()));
        QFilter[] filters = new QFilter[]{filter, filter2};
        String selectFields = "id,entity,template,range,propertyvalue ";
        DynamicObjectCollection oldoc = QueryServiceHelper.query((String)"bcm_checktmplassignentry", (String)selectFields, (QFilter[])filters);
        DynamicObjectCollection tempList = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", dlist.stream().map(e -> LongUtil.toLong((Object)e.get("template"))).collect(Collectors.toSet()))});
        dlist.removeIf(dd -> {
            for (DynamicObject tem : oldoc) {
                String cloname;
                Object entityid = dd.get("entity");
                String string = cloname = !ObjectUtils.isEmpty((Object)entityid) ? "entity" : "propertyvalue";
                if (tem.getLong("template") != dd.getLong("template") || !tem.get("range").equals(dd.get("range")) || tem.getLong(cloname) != dd.getLong(cloname)) continue;
                return true;
            }
            return false;
        });
        if (dlist.size() < 1) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject[] newdoc = dlist.toArray(new DynamicObject[dlist.size()]);
                Object[] oo = SaveServiceHelper.save((DynamicObject[])newdoc);
                if (oo.length > 0) {
                    this.assignSendLog(tempList, this.getOperationStstusSuccess());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"CheckTmplAssignPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            catch (KDBizException e2) {
                this.assignSendLog(tempList, this.getOperationStstusFail());
                tx.markRollback();
                throw e2;
            }
            catch (Throwable e3) {
                this.assignSendLog(tempList, this.getOperationStstusFail());
                tx.markRollback();
                throw e3;
            }
        }
        this.refreshBillList();
    }

    private List<DynamicObject> mergeResult(List<DynamicObject> orglist, List<String> temlist, Long modelid) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        if (!orglist.isEmpty()) {
            for (String tem : temlist) {
                for (DynamicObject org : orglist) {
                    DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checktmplassignentry");
                    if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim())) {
                        IDNumberTreeNode member = MemberReader.findEntityMemberById((Long)modelid, (Long)LongUtil.toLong((Object)org.get("oid")));
                        IDNumberTreeNode baseTreeNode = member.getBaseTreeNode();
                        distribute.set("entity", (Object)baseTreeNode.getId());
                    } else {
                        distribute.set("property", org.get("pid"));
                        distribute.set("propertyvalue", org.get("oid"));
                    }
                    distribute.set("range", org.get("rangevalue"));
                    distribute.set("template", (Object)tem);
                    distribute.set("model", (Object)modelid);
                    distribute.set("textname", (Object)this.subName(org.get("entity")));
                    result.add(distribute);
                }
            }
        }
        return result;
    }

    private String subName(Object name) {
        String result = "";
        if (name != null) {
            if (name.toString().length() > 90) {
                return name.toString().substring(0, 90) + "...";
            }
            result = name.toString();
        }
        return result;
    }

    private DynamicObject getEntityName() {
        QFilter filter1 = new QFilter("model", "=", (Object)this.getModelId());
        QFilter filter2 = new QFilter("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
        QFilter[] filters = new QFilter[]{filter1, filter2};
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"name", (QFilter[])filters);
    }

    private void actionViewDetail() {
        BillList billlist = (BillList)this.getControl(ctl_billlistap);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_checktmplasgn_detail");
        param.setCaption(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f\u5206\u914d\u8be6\u60c5", (String)"CheckTmplAssignPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        Object[] ids = billlist.getSelectedRows().getPrimaryKeyValues().length < 1 ? billlist.getCurrentListAllRowCollection().getPrimaryKeyValues() : billlist.getSelectedRows().getPrimaryKeyValues();
        param.setCustomParam("ids", (Object)SerializationUtils.toJsonString((Object)ids));
        param.setCustomParam("modelid", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void setTemplateDate2View(Long modelid) {
        DynamicObjectCollection temlist = this.getTemplateColls(modelid);
        TreeNode rootview = ReportListUtil.getTemplateTree(this.mergeTemplateCatalogList(), temlist, new ArrayList<TreeNode>(10), "0", new TreeNode());
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        List rows = (List)this.getView().getFormShowParameter().getCustomParam("rows");
        ArrayList<TreeNode> selNodes = new ArrayList<TreeNode>(10);
        for (DynamicObject dd : temlist) {
            if (rows == null || !rows.contains(dd.getLong("id"))) continue;
            TreeNode node = rootview.getTreeNode(dd.getString("id"), 10);
            selNodes.add(node);
        }
        tree.addNode(rootview);
        if (selNodes.size() > 0) {
            tree.checkNodes(selNodes);
            this.getPageCache().put("templeteids", SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
        }
    }

    private DynamicObjectCollection getTemplateColls(Long modelid) {
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        Object pks = this.getView().getFormShowParameter().getCustomParam("tpks");
        Long scene = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam(KEY_SCENE));
        List noPermIds = (List)this.getView().getFormShowParameter().getCustomParam("noPermIds");
        if (pks != null) {
            QFilter filter1 = new QFilter("id", "in", pks);
            filter.and(filter1);
        }
        QFilter filter2 = new QFilter("id", "in", (Object)CheckUtil.getApplySceneTmpls((Long)modelid, (Long)scene));
        filter.and(filter2);
        if (CollectionUtils.isNotEmpty((Collection)noPermIds)) {
            QFilter filter3 = new QFilter("id", "not in", (Object)noPermIds);
            filter.and(filter3);
        }
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id, name, number,templatecatalog";
        return QueryServiceHelper.query((String)"bcm_checktmpl", (String)selectFields, (QFilter[])filters, (String)"sequence asc,id asc");
    }

    private List<Map<String, String>> mergeTemplateCatalogList() {
        DynamicObjectCollection doc = this.getTemplatecatalogList();
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>(10);
        for (DynamicObject dd : doc) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("id", dd.getString("id"));
            map.put("name", dd.getString("name"));
            map.put("parentid", dd.getString("parent"));
            clist.add(map);
        }
        return clist;
    }

    private boolean checkDiffitem(DynamicObject dnDiffitem, DynamicObject dyDiffitem) {
        return dnDiffitem.getBoolean("diffitem") || dyDiffitem.getBoolean("diffitem");
    }

    private boolean checkAccount(DynamicObject entry1, DynamicObject entry2) {
        DynamicObjectCollection scope1 = entry1.getDynamicObjectCollection("detailscope");
        DynamicObjectCollection scope2 = entry2.getDynamicObjectCollection("detailscope");
        HashSet<Long> number1Set = new HashSet<Long>(16);
        for (DynamicObject account1Tmp : scope1) {
            if (!"accounttree".equals(account1Tmp.getString("sign"))) continue;
            number1Set.add(account1Tmp.getLong("memberid"));
        }
        for (DynamicObject account2Tmp : scope2) {
            Long number2;
            if (!"accounttree".equals(account2Tmp.getString("sign")) || !number1Set.contains(number2 = Long.valueOf(account2Tmp.getLong("memberid")))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$checkTempAssign$4(Multimap tempAssignMap, DynamicObject item) {
        tempAssignMap.put((Object)item.getLong("template.id"), (Object)item);
    }
}

