/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.check.CheckHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.util.AdjustCatalogUtil;

public class CheckTmplBatchImportPlugin
extends BatchImportPlugin {
    private static final Log logger = LogFactory.getLog(CheckTmplBatchImportPlugin.class);
    private static final String[] staticFields = new String[]{"datasort", "multigaap", "changetype", "elim_mycompany", "elim_changetype", "diffitem", "detailscope", "entrygroup", "entrymyop", "mappingaccount"};
    private static Set<String> fieldmappeds = new HashSet<String>(Arrays.asList("dim1", "dim2", "dim3", "dim4", "dim5", "dim6"));
    private static Set<String> diffModes = Arrays.stream(DiffModeEnum.values()).filter(DiffModeEnum::isVisible).map(e -> e.getValue() + "").collect(Collectors.toSet());
    private static Set<String> atScops = new HashSet<String>(Arrays.asList("10", "90"));
    private static final Map<String, String> checkconfigs = new ImmutableMap.Builder().put((Object)"dim1", (Object)"1").put((Object)"dim2", (Object)"2").put((Object)"dim3", (Object)"3").put((Object)"dim4", (Object)"4").put((Object)"dim5", (Object)"5").put((Object)"dim6", (Object)"6").put((Object)"AuditTrail", (Object)"7").build();
    private static final String NUMBER = "model,number";
    public static final int BATCH_SIZE = 1000;
    private static final String CACHE_TEMPLATECATALOG_MAP = "templatecatalog_map";
    private static final String CACHE_MODEL_MAP = "model_map";
    private static final String CACHE_DIM_MAP = "dim_map";
    private static final String CACHE_PROPERTYMEMBER_MAP = "propertymember_map";
    private static final String CACHE_ADJUSTCATALOG_MAP = "adjustcatalog_map";
    private Map<String, Object> cache = new HashMap<String, Object>(16);
    private Map<String, Set<String>> memberItemCache = new HashMap<String, Set<String>>(16);
    private Map<String, IDNumberTreeNode> memberReaderCache = new HashMap<String, IDNumberTreeNode>(16);
    private Set<String> existNameSet = new HashSet<String>(16);
    private Set<String> existNumberSet = new HashSet<String>(16);

    public <T> void addCache(String key, T v) {
        this.cache.put(key, v);
    }

    public <T> T getCache(String key) {
        return (T)this.cache.get(key);
    }

    private void initCache() {
        this.addCache(CACHE_MODEL_MAP, new HashMap(16));
        this.addCache(CACHE_TEMPLATECATALOG_MAP, new HashMap(16));
        this.addCache(CACHE_DIM_MAP, new HashMap(16));
        this.addCache(CACHE_PROPERTYMEMBER_MAP, new HashMap(16));
        this.addCache(CACHE_ADJUSTCATALOG_MAP, new HashMap());
    }

    protected int getBatchImportSize() {
        return 1000;
    }

    protected boolean isForceBatch() {
        return true;
    }

    public String getDefaultImportType() {
        return super.getDefaultImportType();
    }

    public String getDefaultKeyFields() {
        return NUMBER;
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockUIs = new ArrayList<String>(2);
        lockUIs.add("keyfields");
        return lockUIs;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.initCache();
        this.existNameSet = new HashSet<String>(16);
        this.existNumberSet = new HashSet<String>(16);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(16);
        Boolean b = Boolean.TRUE;
        ArrayList<DynamicObject> needSaveData = new ArrayList<DynamicObject>(16);
        BillResult item = new BillResult();
        int dataIndex = 0;
        for (ImportBillData rowdata : rowdatas) {
            Pair<Boolean, String> res = this.validateBillData(rowdata, importType, needSaveData);
            b = b != false && (Boolean)res.p1 != false;
            item.setData((Map<String, Object>)rowdata.getData());
            item.setIndex(dataIndex++);
            item.setSucess((Boolean)res.p1);
            item.setMessage((String)res.p2);
            datas.add(item.toMap());
        }
        if (needSaveData.size() > 0) {
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])needSaveData.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        ApiResult result = new ApiResult();
        result.setSuccess(b.booleanValue());
        result.setData(datas);
        return result;
    }

    private Pair<Boolean, String> validateBillData(ImportBillData rowdata, ImportOperateType importType, List<DynamicObject> needSaveData) {
        JSONObject data = rowdata.getData();
        JSONObject modelJson = (JSONObject)data.get((Object)"model");
        if (modelJson == null || modelJson.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        Long modelId = this.getModeId(modelJson);
        if (modelId == null) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u3002", (String)"CheckTmplBatchImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (StringUtils.isEmpty((CharSequence)data.getString("number"))) {
            String msg = ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (data.getString("number").length() > 30) {
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,30]", (String)"CheckTmplBatchImportPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (!CheckHelper.isLetterDigit(data.getString("number"))) {
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801\u201d\u53ea\u80fd\u8f93\u5165\u5b57\u6bcd\u8ddf\u6570\u5b57\u3002", (String)"CheckTmplBatchImportPlugin_60", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        Object name = data.get((Object)"name");
        String nameStr = "";
        if (name == null) {
            String msg = ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        nameStr = name instanceof Map ? LocaleString.fromMap((Map)((Map)name)).toString().trim() : name.toString().trim();
        if (nameStr.length() > 50) {
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,50]", (String)"CheckTmplBatchImportPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (nameStr.length() == 0) {
            String msg = ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        DynamicObject sameNameTmpl = QueryServiceHelper.queryOne((String)"bcm_checktmpl", (String)"id", (QFilter[])this.getUniqueFilters(data, modelId, "name"));
        DynamicObject sameNumTmpl = QueryServiceHelper.queryOne((String)"bcm_checktmpl", (String)"id", (QFilter[])this.getUniqueFilters(data, modelId, "number"));
        DynamicObject newTmpl = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checktmpl");
        if (ImportOperateType.NEW == importType) {
            if (sameNumTmpl != null) {
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u65b0\u589e\u6570\u636e\u5931\u8d25\u3002", (String)"CheckTmplBatchImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            if (sameNameTmpl != null) {
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65b0\u589e\u6570\u636e\u5931\u8d25\u3002", (String)"CheckTmplBatchImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            newTmpl.set("createtime", (Object)TimeServiceHelper.now());
        } else if (ImportOperateType.OVERRIDE == importType) {
            if (sameNumTmpl == null) {
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u66f4\u65b0\u6570\u636e\u5931\u8d25\u3002", (String)"CheckTmplBatchImportPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            if (sameNameTmpl != null && sameNameTmpl.getLong("id") != sameNumTmpl.getLong("id")) {
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u66f4\u65b0\u6570\u636e\u5931\u8d25\u3002", (String)"CheckTmplBatchImportPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            newTmpl = BusinessDataServiceHelper.loadSingle((Object)sameNumTmpl.getLong("id"), (String)"bcm_checktmpl");
        } else if (ImportOperateType.OVERRIDENEW == importType) {
            if (sameNumTmpl != null) {
                if (sameNameTmpl != null && sameNameTmpl.getLong("id") != sameNumTmpl.getLong("id")) {
                    String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u66f4\u65b0\u6570\u636e\u5931\u8d25\u3002", (String)"CheckTmplBatchImportPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
                }
                newTmpl = BusinessDataServiceHelper.loadSingle((Object)sameNumTmpl.getLong("id"), (String)"bcm_checktmpl");
            } else {
                if (sameNameTmpl != null) {
                    String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65b0\u589e\u6570\u636e\u5931\u8d25\u3002", (String)"CheckTmplBatchImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
                }
                newTmpl.set("createtime", (Object)TimeServiceHelper.now());
            }
        }
        Pair buildRes = Pair.onePair((Object)Boolean.TRUE, (Object)"");
        try {
            buildRes = this.buildDynInfo(data, newTmpl, modelId);
        }
        catch (KDBizException e) {
            buildRes = Pair.onePair((Object)Boolean.FALSE, (Object)e.getMessage());
        }
        catch (Exception e) {
            buildRes = Pair.onePair((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"CheckTmplBatchImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e));
            logger.error((Throwable)e);
        }
        if (((Boolean)buildRes.p1).booleanValue()) {
            needSaveData.add(newTmpl);
        }
        return buildRes;
    }

    private Pair<Boolean, String> buildDynInfo(JSONObject data, DynamicObject dyn, Long modelId) {
        String description;
        String msg;
        dyn.set("model", (Object)modelId);
        Object name = data.get((Object)"name");
        String nameStr = "";
        nameStr = name instanceof Map ? LocaleString.fromMap((Map)((Map)name)).toString().trim() : name.toString().trim();
        if (this.existNameSet.contains(nameStr)) {
            String msg2 = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u91cc\u6a21\u677f\u540d\u79f0 %S \u91cd\u590d\u3002", (String)"CheckTmplBatchImportPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]), nameStr);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg2);
        }
        if (this.existNumberSet.contains(data.getString("number"))) {
            String msg3 = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u91cc\u6a21\u677f\u7f16\u7801 %S \u91cd\u590d\u3002", (String)"CheckTmplBatchImportPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]), data.getString("number"));
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg3);
        }
        dyn.set("name", (Object)nameStr);
        dyn.set("number", data.get((Object)"number"));
        this.existNameSet.add(nameStr);
        this.existNumberSet.add(data.getString("number"));
        if (data.get((Object)"templatecatalog") == null) {
            String msg4 = ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg4);
        }
        Long templatecatalogId = this.getEntityIdByNum((JSONObject)data.get((Object)"templatecatalog"), modelId, CACHE_TEMPLATECATALOG_MAP);
        if (templatecatalogId == null) {
            String msg5 = ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"CheckTmplBatchImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
        }
        dyn.set("templatecatalog", (Object)templatecatalogId);
        JSONObject adjustcatalogJson = (JSONObject)data.get((Object)"adjustcatalog");
        if (adjustcatalogJson != null && adjustcatalogJson.containsKey((Object)"number") && StringUtils.isNotEmpty((CharSequence)adjustcatalogJson.getString("number"))) {
            Long adjustCatalogId = this.getEntityIdByNum((JSONObject)data.get((Object)"adjustcatalog"), modelId, CACHE_ADJUSTCATALOG_MAP);
            if (adjustCatalogId == null) {
                String msg6 = ResManager.loadKDString((String)"\u5206\u5f55\u5206\u7c7b\u7f16\u7801\u65e0\u6743\u6216\u4e0d\u5b58\u5728\u3002", (String)"CheckTmplBatchImportPlugin_63", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg6);
            }
            dyn.set("adjustcatalog", (Object)adjustCatalogId);
        }
        if (data.get((Object)"period") != null) {
            this.setPeriod(dyn, (JSONObject)data.get((Object)"period"), modelId);
        }
        if (StringUtils.isEmpty((CharSequence)data.getString("issingledc"))) {
            msg = ResManager.loadKDString((String)"\u5dee\u989d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (!"0".equals(data.getString("issingledc")) && !"1".equals(data.getString("issingledc"))) {
            msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u5dee\u989d\u7b97\u6cd5\u3002", (String)"CheckTmplBatchImportPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        dyn.set("issingledc", data.get((Object)"issingledc"));
        if (StringUtils.isEmpty((CharSequence)data.getString("diffmode"))) {
            msg = ResManager.loadKDString((String)"\u5dee\u989d\u65b9\u5411\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (!diffModes.contains(data.getString("diffmode"))) {
            msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u5dee\u989d\u65b9\u5411\u3002", (String)"CheckTmplBatchImportPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (!ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isCheckMaxLineReplace") && "11".equals(data.getString("diffmode"))) {
            msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u5dee\u989d\u65b9\u5411\u3002", (String)"CheckTmplBatchImportPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        dyn.set("diffmode", data.get((Object)"diffmode"));
        if (data.getInteger("diffmode") == 1 || data.getInteger("diffmode") == 2 || data.getInteger("diffmode") == 9 || data.getInteger("diffmode") == 10) {
            if (StringUtils.isEmpty((CharSequence)data.getString("diffmethod"))) {
                msg = ResManager.loadKDString((String)"\u5dee\u5f02\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_69", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            if (Arrays.stream(DiffMethodEnum.values()).noneMatch(e -> (e.getValue() + "").equals(data.getString("diffmethod")))) {
                msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u5dee\u989d\u65b9\u5f0f\u3002", (String)"CheckTmplBatchImportPlugin_70", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            if (!ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isCheckMaxLineReplace") && (DiffMethodEnum.MAXMAPPING.getValue() + "").equals(data.getString("diffmode"))) {
                msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u5dee\u989d\u65b9\u5f0f\u3002", (String)"CheckTmplBatchImportPlugin_70", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            dyn.set("diffmethod", (Object)data.getString("diffmethod"));
        } else {
            dyn.set("diffmethod", (Object)0);
        }
        if (data.get((Object)"checkconfignumber") != null) {
            if (data.get((Object)"checkconfignumber").toString().length() > 30) {
                msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5bf9\u8d26\u914d\u7f6e\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,30]", (String)"CheckTmplBatchImportPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            this.getCheckConfig(dyn, data.get((Object)"checkconfignumber").toString().split(","), modelId, data.getInteger("diffmode"));
        }
        if (StringUtils.isEmpty((CharSequence)data.getString("balance"))) {
            msg = ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        dyn.set("balance", data.get((Object)"balance"));
        if (StringUtils.isEmpty((CharSequence)data.getString("islinkage"))) {
            msg = ResManager.loadKDString((String)"\u662f\u5426\u8054\u52a8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (!("0".equals(data.getString("islinkage")) || "1".equals(data.getString("islinkage")) || "2".equals(data.getString("islinkage")))) {
            msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u8054\u52a8\u65b9\u5f0f\u3002", (String)"CheckTmplBatchImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        dyn.set("islinkage", data.get((Object)"islinkage"));
        if (StringUtils.isEmpty((CharSequence)data.getString("journaltype"))) {
            msg = ResManager.loadKDString((String)"\u5206\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        dyn.set("journaltype", data.get((Object)"journaltype"));
        String string = description = null == data.get((Object)"description") ? "" : (String)((Map)data.get((Object)"description")).get("zh_CN");
        if (description.length() > 255) {
            String msg7 = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u8bf4\u660e\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,255]", (String)"CheckTmplBatchImportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg7);
        }
        String isenable = data.getString("isenable");
        if (!"1".equals(isenable) && !"0".equals(isenable)) {
            String msg8 = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u662f\u5426\u542f\u7528\u201d\u8bf7\u586b\u5199\u201c\u542f\u7528\u201d\u6216\u201c\u7981\u7528\u201d\u3002", (String)"CheckTmplBatchImportPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg8);
        }
        dyn.set("isenable", (Object)isenable);
        dyn.set("description", (Object)description);
        dyn.set("createorg", (Object)RequestContext.get().getOrgId());
        dyn.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dyn.set("modifytime", (Object)TimeServiceHelper.now());
        Pair<Boolean, String> r = this.setEffective(data, dyn, modelId);
        if (((Boolean)r.p1).booleanValue()) {
            Pair<Boolean, String> r2 = this.setScenarios(data, dyn, modelId);
            if (((Boolean)r2.p1).booleanValue()) {
                return this.setEntryentity(data, dyn, modelId);
            }
            return r2;
        }
        return r;
    }

    private Pair<Boolean, String> setScenarios(JSONObject data, DynamicObject dyn, Long modelId) {
        DynamicObjectCollection scenarios = dyn.getDynamicObjectCollection("scenarios");
        scenarios.clear();
        JSONArray scenariosJson = (JSONArray)data.get((Object)"scenarios");
        if (scenariosJson == null) {
            return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u9002\u7528\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_61", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        int seq = 1;
        for (Object entryJson : scenariosJson) {
            Object isexcept = ((JSONObject)entryJson).get((Object)"isexcept");
            Object scenariomeb = ((JSONObject)entryJson).get((Object)"scenariomeb");
            Object scope = ((JSONObject)entryJson).get((Object)"scenarioscope");
            if (ObjectUtils.isEmpty((Object)isexcept) || ObjectUtils.isEmpty((Object)scenariomeb) || ObjectUtils.isEmpty((Object)scope)) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u9002\u7528\u60c5\u666f\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"CheckTmplBatchImportPlugin_62", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String sceneNum = ((JSONObject)scenariomeb).getString("number");
            if (StringUtils.isEmpty((CharSequence)sceneNum)) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u9002\u7528\u60c5\u666f\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"CheckTmplBatchImportPlugin_62", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            IDNumberTreeNode scene = this.getMemberByNumCache(modelId, "Scenario", sceneNum, false);
            if (scene == null) {
                String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u60c5\u666f\u7f16\u7801\u3002", (String)"CheckTmplBatchImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            DynamicObject rowObj = scenarios.addNew();
            rowObj.set("seq", (Object)seq);
            rowObj.set("isexcept", isexcept);
            DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)"bcm_scenemembertree");
            member.set("id", (Object)scene.getId());
            rowObj.set("scenariomeb", (Object)member);
            rowObj.set("scenarioscope", scope);
            ++seq;
        }
        return Pair.onePair((Object)Boolean.TRUE, (Object)"");
    }

    private Pair<Boolean, String> setEffective(JSONObject data, DynamicObject dyn, Long modelId) {
        DynamicObjectCollection effective = dyn.getDynamicObjectCollection("effective");
        effective.clear();
        JSONArray effectiveJson = (JSONArray)data.get((Object)"effective");
        if (effectiveJson != null) {
            int seq = 0;
            for (Object entryJson : effectiveJson) {
                Object applytype = ((JSONObject)entryJson).get((Object)"applytype");
                Object yearscope = ((JSONObject)entryJson).get((Object)"yearscope");
                if (ObjectUtils.isEmpty((Object)applytype) || ObjectUtils.isEmpty((Object)yearscope)) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u9002\u7528\u7c7b\u578b\u6216\u8d22\u5e74\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                IDNumberTreeNode year = null;
                IDNumberTreeNode period = null;
                JSONObject yearJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveyear");
                JSONObject periodJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveperiod");
                if (yearJson != null && (year = this.getMemberByNumCache(modelId, "Year", yearJson.getString("number"), false)) == null) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8d22\u5e74\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"CheckTmplBatchImportPlugin_56", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (periodJson != null && (period = this.getMemberByNumCache(modelId, "Period", periodJson.getString("number"), false)) == null) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"CheckTmplBatchImportPlugin_57", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (ObjectUtils.isEmpty(year) && ObjectUtils.isEmpty(period)) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8d22\u5e74\u7f16\u7801\u671f\u95f4\u7f16\u7801\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_58", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                DynamicObject rowObj = effective.addNew();
                rowObj.set("seq", (Object)seq);
                rowObj.set("effectiveyear", (Object)(year == null ? null : year.getId()));
                rowObj.set("applytype", applytype);
                rowObj.set("yearscope", yearscope);
                rowObj.set("effectiveperiod", (Object)(period == null ? null : period.getId()));
                ++seq;
            }
        }
        return Pair.onePair((Object)Boolean.TRUE, (Object)"");
    }

    private Pair<Boolean, String> setEntryentity(JSONObject data, DynamicObject dyn, Long modelId) {
        String msg;
        String msg2;
        boolean isMappingBig;
        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
        entryentity.clear();
        boolean bl = isMappingBig = dyn.getInt("diffmethod") == DiffMethodEnum.MAXMAPPING.getValue();
        if (!data.containsKey((Object)"entryentity") || ((JSONArray)data.get((Object)"entryentity")).isEmpty()) {
            String msg3 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u5355\u636e\u4f53\u4fe1\u606f\u3002", (String)"CheckTmplBatchImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg3);
        }
        JSONArray entryentityJsonArr = (JSONArray)data.get((Object)"entryentity");
        int seq = 0;
        for (Object rowObject : entryentityJsonArr) {
            JSONObject rowJSONObject = (JSONObject)rowObject;
            DynamicObject newEntryObj = entryentity.addNew();
            newEntryObj.set("seq", (Object)(++seq));
            for (String field : staticFields) {
                String msg4;
                String msg5;
                Object fieldValue = rowJSONObject.get((Object)field);
                if (field.equals("datasort") && this.isExistDimension(modelId, DimTypesEnum.DATASORT.getNumber())) {
                    if (fieldValue == null) {
                        msg5 = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53%s", (String)"CheckTmplBatchImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.DATASORT.getName());
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
                    }
                    IDNumberTreeNode datasortObj = this.getMemberByNumCache(modelId, DimTypesEnum.DATASORT.getNumber(), ((JSONObject)fieldValue).getString("number"), false);
                    if (datasortObj == null) {
                        String msg6 = String.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u5355\u636e\u4f53%1$s\u7ef4\u5ea6\u7f16\u7801%2$s\u6210\u5458\u4e0d\u5b58\u5728", (String)"CheckTmplBatchImportPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.DATASORT.getName(), ((JSONObject)fieldValue).getString("number"));
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg6);
                    }
                    newEntryObj.set(field, (Object)datasortObj.getId());
                    continue;
                }
                if (field.equals("multigaap") && this.isExistDimension(modelId, DimTypesEnum.MULTIGAAP.getNumber())) {
                    if (fieldValue == null) {
                        msg5 = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53%s", (String)"CheckTmplBatchImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.MULTIGAAP.getName());
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
                    }
                    IDNumberTreeNode multigaapObj = this.getMemberByNumCache(modelId, DimTypesEnum.MULTIGAAP.getNumber(), ((JSONObject)fieldValue).getString("number"), false);
                    if (multigaapObj == null) {
                        String msg7 = String.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u5355\u636e\u4f53%1$s\u7ef4\u5ea6\u7f16\u7801%2$s\u6210\u5458\u4e0d\u5b58\u5728", (String)"CheckTmplBatchImportPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.MULTIGAAP.getName(), ((JSONObject)fieldValue).getString("number"));
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg7);
                    }
                    newEntryObj.set(field, (Object)multigaapObj.getId());
                    continue;
                }
                if (field.equals("elim_mycompany") && this.isExistDimension(modelId, DimTypesEnum.MYCOMPANY.getNumber())) {
                    IDNumberTreeNode mycompangObj;
                    if (fieldValue == null || (mycompangObj = this.getMemberByNumCache(modelId, DimTypesEnum.MYCOMPANY.getNumber(), ((JSONObject)fieldValue).getString("number"), false)) == null) continue;
                    newEntryObj.set("mycompany", (Object)mycompangObj.getId());
                    continue;
                }
                if ((field.equals("changetype") || field.equals("elim_changetype")) && this.isExistDimension(modelId, DimTypesEnum.CHANGETYPE.getNumber())) {
                    if (fieldValue == null) {
                        msg5 = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53%s", (String)"CheckTmplBatchImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.CHANGETYPE.getName());
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
                    }
                    IDNumberTreeNode changeTypeObj = this.getMemberByNumCache(modelId, DimTypesEnum.CHANGETYPE.getNumber(), ((JSONObject)fieldValue).getString("number"), false);
                    if (changeTypeObj == null) {
                        String msg8 = String.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u5355\u636e\u4f53%1$s\u7ef4\u5ea6\u7f16\u7801%2$s\u6210\u5458\u4e0d\u5b58\u5728", (String)"CheckTmplBatchImportPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.CHANGETYPE.getName(), ((JSONObject)fieldValue).getString("number"));
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg8);
                    }
                    newEntryObj.set(field, (Object)changeTypeObj.getId());
                    continue;
                }
                if (field.equals("diffitem")) {
                    if (fieldValue == null) {
                        msg5 = ResManager.loadKDString((String)"\u5dee\u989d\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
                    }
                    newEntryObj.set(field, (Object)((Boolean)fieldValue));
                    continue;
                }
                if (field.equals("mappingaccount") && isMappingBig && !newEntryObj.getBoolean("diffitem")) {
                    boolean isaccountoffset;
                    if (fieldValue == null) {
                        msg5 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u201c\u6620\u5c04\u5dee\u989d\u79d1\u76ee\u201d\u3002", (String)"CheckTmplBatchImportPlugin_66", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
                    }
                    IDNumberTreeNode accountNode = this.getMemberByNumCache(modelId, DimTypesEnum.ACCOUNT.getNumber(), ((JSONObject)fieldValue).getString("number"), false);
                    if (accountNode == null || accountNode == IDNumberTreeNode.NotFoundTreeNode) {
                        String msg9 = String.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u5355\u636e\u4f53\u201c\u6620\u5c04\u5dee\u989d\u79d1\u76ee\u201d\u7f16\u7801%1$s\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"CheckTmplBatchImportPlugin_67", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((JSONObject)fieldValue).getString("number"));
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg9);
                    }
                    boolean bl2 = isaccountoffset = accountNode.getProperty("accountpart.isaccountoffset") == null ? false : (Boolean)accountNode.getProperty("accountpart.isaccountoffset");
                    if (accountNode.isLeaf() && isaccountoffset && StorageTypeEnum.getRealStorageEnumIndexs().contains(accountNode.getStorageType().index)) {
                        newEntryObj.set(field, (Object)accountNode.getId());
                        continue;
                    }
                    msg4 = String.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u5355\u636e\u4f53\u201c\u6620\u5c04\u5dee\u989d\u79d1\u76ee\u201d\u6210\u5458\u9700\u4e3a\u6253\u5f00\u4e86\u62b5\u9500\u5c5e\u6027\u7684\u660e\u7ec6\u6210\u5458\u3002", (String)"CheckTmplBatchImportPlugin_68", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((JSONObject)fieldValue).getString("number"));
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg4);
                }
                if (field.equals("entrygroup")) {
                    if (fieldValue == null) {
                        msg5 = ResManager.loadKDString((String)"\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
                    }
                    if (!((Boolean)rowJSONObject.get((Object)"diffitem")).booleanValue() && "0".equals(fieldValue)) {
                        msg5 = ResManager.loadKDString((String)"\u975e\u5dee\u989d\u9879\u201c\u5206\u7ec4\u201d\u4e0d\u80fd\u4e3a\u201c\u4e0d\u533a\u5206\u201d\u3002", (String)"CheckTmplBatchImportPlugin_52", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
                    }
                    newEntryObj.set(field, fieldValue);
                    continue;
                }
                if (field.equals("entrymyop")) {
                    if (fieldValue == null) {
                        msg5 = ResManager.loadKDString((String)"\u672c\u65b9\u5bf9\u65b9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_51", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
                    }
                    if (((Boolean)rowJSONObject.get((Object)"diffitem")).booleanValue()) {
                        fieldValue = "0";
                    }
                    newEntryObj.set(field, fieldValue);
                    continue;
                }
                if (!field.equals("detailscope")) continue;
                Object detailscopeObj = rowJSONObject.get((Object)"detailscope");
                Object elimdetailscopeObj = rowJSONObject.get((Object)"elimdetailscope");
                if (detailscopeObj == null) {
                    msg4 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u5bf9\u8d26\u591a\u9009\u8303\u56f4", (String)"CheckTmplBatchImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg4);
                }
                if (elimdetailscopeObj == null) {
                    String msg22 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u62b5\u9500\u591a\u9009\u8303\u56f4", (String)"CheckTmplBatchImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg22);
                }
                Map dimCache = (Map)this.getCache(CACHE_DIM_MAP);
                DynamicObjectCollection dims = (DynamicObjectCollection)dimCache.get(modelId.toString());
                Map<String, DynamicObject> dimMap = dims.stream().collect(Collectors.toMap(e -> e.getString("number"), v -> v, (o1, o2) -> o1));
                DynamicObjectCollection details = newEntryObj.getDynamicObjectCollection("detailscope");
                DynamicObjectCollection elimdetails = newEntryObj.getDynamicObjectCollection("elimdetailscope");
                Pair<Boolean, String> r = this.validateDetailscope(modelId, rowJSONObject, dimMap);
                if (((Boolean)r.p1).booleanValue()) {
                    for (Object item : (JSONArray)detailscopeObj) {
                        this.createDetailScopeEntry(details, item, modelId, "", "", dimMap);
                    }
                    for (Object item : (JSONArray)elimdetailscopeObj) {
                        this.createDetailScopeEntry(elimdetails, item, modelId, "elim", "elim", dimMap);
                    }
                    continue;
                }
                return r;
            }
        }
        List diffitems = entryentity.stream().filter(e -> e.getBoolean("diffitem")).collect(Collectors.toList());
        if (diffitems.isEmpty()) {
            msg2 = ResManager.loadKDString((String)"\u6a21\u677f\u7f3a\u5c11\u201c\u5dee\u989d\u9879\u201d\u3002", (String)"CheckTmplBatchImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg2);
        }
        if (entryentity.stream().allMatch(e -> e.getBoolean("diffitem"))) {
            msg2 = ResManager.loadKDString((String)"\u6a21\u677f\u7f3a\u5c11\u975e\u201c\u5dee\u989d\u9879\u201d\u3002", (String)"CheckTmplBatchImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg2);
        }
        HashSet<String> entryGroup = new HashSet<String>(16);
        HashMultimap diffEntryGroup = HashMultimap.create();
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
            List<Long> elimAccountList = this.getAccount(dynamicObject, false);
            if (dynamicObject.getBoolean("diffitem")) {
                diffEntryGroup.put((Object)(dynamicObject.getString("entrygroup") == null ? "1" : dynamicObject.getString("entrygroup")), (Object)elimAccountList.get(0));
                continue;
            }
            entryGroup.add(dynamicObject.getString("entrygroup") == null ? "1" : dynamicObject.getString("entrygroup"));
        }
        for (String group : entryGroup) {
            Collection accounts = diffEntryGroup.get((Object)group);
            if (accounts != null && accounts.size() > 0) {
                String groupName;
                String string = groupName = "0".equals(group) ? ResManager.loadKDString((String)"\u4e0d\u533a\u5206", (String)"CheckTmplEditPlugin_85", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : group;
                if (accounts.size() > 2) {
                    msg = String.format(ResManager.loadKDString((String)"\u5206\u7ec4%s\u7684\u201c\u5dee\u989d\u9879\u201d\u6700\u591a\u8bbe\u7f6e2\u9879\u3002", (String)"CheckTmplEditPlugin_65", (String)"fi-bcm-formplugin", (Object[])new Object[0]), groupName);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
                }
                if (accounts.size() != 2 || dyn.getInt("diffmode") == 4 || accounts.stream().anyMatch(p -> CheckTmplBatchImportPlugin.isDc(modelId, p)) == accounts.stream().anyMatch(p -> !CheckTmplBatchImportPlugin.isDc(modelId, p))) continue;
                msg = String.format(ResManager.loadKDString((String)"\u5206\u7ec4%s\u7684\u201c\u5dee\u989d\u9879\u201d\u52fe\u90092\u9879\u65f6\uff0c\u5fc5\u987b\u662f\u4e00\u501f\u4e00\u8d37\u3002", (String)"CheckTmplEditPlugin_63", (String)"fi-bcm-formplugin", (Object[])new Object[0]), groupName);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            if (diffEntryGroup.containsKey((Object)"0")) continue;
            String msg10 = String.format(ResManager.loadKDString((String)"\u5206\u7ec4%s\u672a\u914d\u7f6e\u5dee\u989d\u9879\u3002", (String)"CheckTmplEditPlugin_86", (String)"fi-bcm-formplugin", (Object[])new Object[0]), group);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg10);
        }
        HashSet diffGroupKeys = new HashSet(diffEntryGroup.keySet());
        boolean containAllEntryGroup = diffGroupKeys.containsAll(entryGroup);
        diffGroupKeys.removeAll(entryGroup);
        if (diffGroupKeys.size() > 0) {
            if (containAllEntryGroup) {
                if (diffGroupKeys.contains("0")) {
                    String msg11 = ResManager.loadKDString((String)"\u6240\u6709\u5206\u7ec4\u90fd\u5df2\u914d\u7f6e\u5dee\u989d\u9879\uff0c\u65e0\u9700\u914d\u7f6e\u4e0d\u533a\u5206\u5206\u7ec4\u5dee\u989d\u9879\u3002", (String)"CheckTmplEditPlugin_87", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg11);
                }
                String msg12 = String.format(ResManager.loadKDString((String)"\u5dee\u989d\u9879\u914d\u7f6e\u7684\u5206\u7ec4%s\u4e0d\u5b58\u5728\u5bf9\u5e94\u5206\u7ec4\u7684\u975e\u5dee\u989d\u9879\u884c\u3002", (String)"CheckTmplEditPlugin_89", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", diffGroupKeys));
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg12);
            }
            diffGroupKeys.remove("0");
            if (diffGroupKeys.size() > 0) {
                String msg13 = String.format(ResManager.loadKDString((String)"\u5dee\u989d\u9879\u914d\u7f6e\u7684\u5206\u7ec4%s\u4e0d\u5b58\u5728\u5bf9\u5e94\u5206\u7ec4\u7684\u975e\u5dee\u989d\u9879\u884c\u3002", (String)"CheckTmplEditPlugin_89", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", diffGroupKeys));
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg13);
            }
        }
        if (diffEntryGroup.get((Object)"0") != null) {
            Collection accounts = diffEntryGroup.get((Object)"0");
            if (accounts.size() > 2) {
                String msg14 = String.format(ResManager.loadKDString((String)"\u5206\u7ec4%s\u7684\u201c\u5dee\u989d\u9879\u201d\u6700\u591a\u8bbe\u7f6e2\u9879\u3002", (String)"CheckTmplEditPlugin_65", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0d\u533a\u5206", (String)"CheckTmplEditPlugin_85", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg14);
            }
            if (accounts.size() == 2 && dyn.getInt("diffmode") != 4 && accounts.stream().anyMatch(p -> CheckTmplBatchImportPlugin.isDc(modelId, p)) != accounts.stream().anyMatch(p -> !CheckTmplBatchImportPlugin.isDc(modelId, p))) {
                String msg15 = String.format(ResManager.loadKDString((String)"\u5206\u7ec4%s\u7684\u201c\u5dee\u989d\u9879\u201d\u52fe\u90092\u9879\u65f6\uff0c\u5fc5\u987b\u662f\u4e00\u501f\u4e00\u8d37\u3002", (String)"CheckTmplEditPlugin_63", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0d\u533a\u5206", (String)"CheckTmplEditPlugin_85", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg15);
            }
        }
        List list1 = entryentity.stream().filter(e -> !e.getBoolean("diffitem")).filter(e -> "0".equals(e.getString("entrymyop"))).collect(Collectors.toList());
        List list2 = entryentity.stream().filter(e -> !e.getBoolean("diffitem")).filter(e -> !"0".equals(e.getString("entrymyop"))).collect(Collectors.toList());
        if (list1.size() > 0 && list2.size() > 0) {
            msg = ResManager.loadKDString((String)"\u6a21\u677f\u8bbe\u7f6e\u4e86\u201c\u672c\u65b9\u201d\u6216\u201c\u5bf9\u65b9\u201d\u65f6\uff0c\u4e0d\u8bb8\u975e\u5dee\u989d\u9879\u884c\u91cc\u518d\u8bbe\u7f6e\u201c\u672c\u65b9&\u5bf9\u65b9\u201d\u3002", (String)"CheckTmplBatchImportPlugin_53", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        return Pair.onePair((Object)Boolean.TRUE, (Object)"");
    }

    private List<Long> getAccount(DynamicObject obj, boolean accountBolean) {
        String account = accountBolean ? "" : "elim";
        ArrayList<Long> dpropertyid = new ArrayList<Long>(10);
        DynamicObjectCollection dn = obj.getDynamicObjectCollection(account + "detailscope");
        dn.stream().filter(p -> (account + "accounttree").equals(p.getString(account + "sign"))).forEach(p -> dpropertyid.add(p.getLong(account + "memberid")));
        return dpropertyid;
    }

    private static boolean isDc(Long modelId, Long accountId) {
        return DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.getOIndex().equals(MemberReader.findMemberById((long)modelId, (String)"bcm_accountmembertree", (Long)accountId).getProperty("drcrdirect"));
    }

    private Pair<Boolean, String> validateDetailscope(Long modelId, JSONObject rowJSONObject, Map<String, DynamicObject> dimMap) {
        String msg;
        Boolean isDiffitem = rowJSONObject.getBoolean("diffitem");
        JSONArray detailscope = rowJSONObject.getJSONArray("detailscope");
        JSONArray elimdetailscope = rowJSONObject.getJSONArray("elimdetailscope");
        List<Object> accountDetailscope = detailscope.stream().filter(o -> DimTypesEnum.ACCOUNT.getNumber().equals(((Map)((Map)o).get("dimension")).get("number"))).collect(Collectors.toList());
        List<Object> accountElimDetailscope = elimdetailscope.stream().filter(o -> DimTypesEnum.ACCOUNT.getNumber().equals(((Map)((Map)o).get("elimdimension")).get("number"))).collect(Collectors.toList());
        if (accountDetailscope.size() == 0) {
            String msg2 = String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u591a\u9009\u8303\u56f4\u7f3a\u5c11%s\u7ef4\u5ea6\u3002", (String)"CheckTmplBatchImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.ACCOUNT.getNumber());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg2);
        }
        if (accountElimDetailscope.size() == 0) {
            String msg3 = String.format(ResManager.loadKDString((String)"\u62b5\u9500\u591a\u9009\u8303\u56f4\u7f3a\u5c11%s\u7ef4\u5ea6\u3002", (String)"CheckTmplBatchImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.ACCOUNT.getNumber());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg3);
        }
        List<IDNumberTreeNode> accountMembers = this.convertToMember(modelId, dimMap.get(DimTypesEnum.ACCOUNT.getNumber()), accountDetailscope, "");
        List<IDNumberTreeNode> accountElimMembers = this.convertToMember(modelId, dimMap.get(DimTypesEnum.ACCOUNT.getNumber()), accountElimDetailscope, "elim");
        Set filteredAccountMem = accountMembers.stream().filter(e -> (Boolean)e.getProperty("accountpart.isaccountoffset")).collect(Collectors.toSet());
        Set filteredAccountElimMem = accountElimMembers.stream().filter(e -> StorageTypeEnum.getRealStorageEnumIndexs().contains(e.getStorageType().index)).filter(e -> e.isLeaf()).filter(e -> (Boolean)e.getProperty("accountpart.isaccountoffset")).collect(Collectors.toSet());
        if (filteredAccountMem.size() == 0) {
            String msg4 = String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u591a\u9009\u8303\u56f4\u79d1\u76ee\u7ef4\u5ea6\u89e3\u6790\u6210\u5458\u540e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u586b\u5199\u7684\u79d1\u76ee\u8303\u56f4\u6210\u5458\u662f\u5426\u662f\u6253\u5f00\u4e86\u62b5\u9500\u5c5e\u6027\u7684\u6210\u5458\u3002", (String)"CheckTmplBatchImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.ACCOUNT.getNumber());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg4);
        }
        if (filteredAccountElimMem.size() == 0) {
            String msg5 = String.format(ResManager.loadKDString((String)"\u62b5\u9500\u591a\u9009\u8303\u56f4\u79d1\u76ee\u7ef4\u5ea6\u89e3\u6790\u6210\u5458\u540e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u586b\u5199\u7684\u79d1\u76ee\u8303\u56f4\u6210\u5458\u662f\u5426\u662f\u6253\u5f00\u4e86\u62b5\u9500\u5c5e\u6027\u7684\u660e\u7ec6\u6210\u5458\u3002", (String)"CheckTmplBatchImportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.ACCOUNT.getNumber());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
        }
        if (filteredAccountElimMem.size() != 1 && filteredAccountMem.size() != filteredAccountElimMem.size()) {
            String msg6 = String.format(ResManager.loadKDString((String)"\u62b5\u9500%1$s\u8303\u56f4\u9700\u548c\u5bf9\u8d26%2$s\u8303\u56f4\u76f8\u540c\u6216\u8005\u53ea\u80fd\u4e3a\u4e00\u4e2a%3$s%4$s\u6210\u5458", (String)"CheckTmplBatchImportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.ACCOUNT.getName(), DimTypesEnum.ACCOUNT.getName(), ResManager.loadKDString((String)"\u660e\u7ec6", (String)"CheckTmplBatchImportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.ACCOUNT.getName());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg6);
        }
        if (isDiffitem.booleanValue() && (filteredAccountMem.size() > 1 || filteredAccountElimMem.size() > 1)) {
            String msg7 = String.format(ResManager.loadKDString((String)"\u5dee\u989d\u9879%s\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u660e\u7ec6\u6210\u5458\u3002", (String)"CheckTmplBatchImportPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.ACCOUNT.getName());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg7);
        }
        accountMembers.clear();
        accountElimMembers.clear();
        filteredAccountMem.clear();
        filteredAccountElimMem.clear();
        if (this.isExistDimension(modelId, DimTypesEnum.AUDITTRIAL.getNumber())) {
            List<Object> auditTrailDetailscope = detailscope.stream().filter(o -> DimTypesEnum.AUDITTRIAL.getNumber().equals(((Map)((Map)o).get("dimension")).get("number"))).collect(Collectors.toList());
            List<Object> auditTrailElimDetailscope = elimdetailscope.stream().filter(o -> DimTypesEnum.AUDITTRIAL.getNumber().equals(((Map)((Map)o).get("elimdimension")).get("number"))).collect(Collectors.toList());
            if (auditTrailDetailscope.size() == 0) {
                String msg8 = String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u591a\u9009\u8303\u56f4\u7f3a\u5c11%s\u7ef4\u5ea6\u3002", (String)"CheckTmplBatchImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.AUDITTRIAL.getNumber());
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg8);
            }
            if (auditTrailElimDetailscope.size() == 0) {
                String msg9 = String.format(ResManager.loadKDString((String)"\u62b5\u9500\u591a\u9009\u8303\u56f4\u7f3a\u5c11%s\u7ef4\u5ea6\u3002", (String)"CheckTmplBatchImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.AUDITTRIAL.getNumber());
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg9);
            }
            if (auditTrailElimDetailscope.size() > 1) {
                String msg10 = String.format(ResManager.loadKDString((String)"\u62b5\u9500\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\u53ea\u80fd\u4e3a\u4e00\u4e2a\u660e\u7ec6\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\u3002", (String)"CheckTmplBatchImportPlugin_59", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.AUDITTRIAL.getNumber());
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg10);
            }
            List<IDNumberTreeNode> auditTrailMembers = this.convertToMember(modelId, dimMap.get(DimTypesEnum.AUDITTRIAL.getNumber()), auditTrailDetailscope, "");
            List<IDNumberTreeNode> auditTrailElimMembers = this.convertToMember(modelId, dimMap.get(DimTypesEnum.AUDITTRIAL.getNumber()), auditTrailElimDetailscope, "elim");
            if (auditTrailElimMembers.stream().anyMatch(e -> !e.isLeaf())) {
                String msg11 = String.format(ResManager.loadKDString((String)"\u62b5\u9500\u591a\u9009\u8303\u56f4\u5ba1\u8ba1\u7ebf\u7d22\u7ef4\u5ea6\u53ea\u80fd\u586b\u5199\u660e\u7ec6\u6210\u5458\u3002", (String)"CheckTmplBatchImportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.AUDITTRIAL.getNumber());
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg11);
            }
            if (auditTrailMembers.size() != auditTrailElimMembers.size() && auditTrailElimMembers.size() != 1) {
                String msg12 = String.format(ResManager.loadKDString((String)"\u62b5\u9500%1$s\u8303\u56f4\u9700\u548c\u5bf9\u8d26%2$s\u8303\u56f4\u76f8\u540c\u6216\u8005\u53ea\u80fd\u4e3a\u4e00\u4e2a%3$s%4$s\u6210\u5458", (String)"CheckTmplBatchImportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.AUDITTRIAL.getName(), DimTypesEnum.AUDITTRIAL.getName(), ResManager.loadKDString((String)"\u660e\u7ec6", (String)"CheckTmplBatchImportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.AUDITTRIAL.getName());
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg12);
            }
            if (isDiffitem.booleanValue() && auditTrailElimMembers.size() > 1) {
                String msg13 = String.format(ResManager.loadKDString((String)"\u5dee\u989d\u9879%s\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u660e\u7ec6\u6210\u5458\u3002", (String)"CheckTmplBatchImportPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.AUDITTRIAL.getName());
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg13);
            }
            auditTrailMembers.clear();
            auditTrailElimDetailscope.clear();
        }
        List icDetailscope = detailscope.stream().filter(o -> DimTypesEnum.INTERCOMPANY.getNumber().equals(((Map)((Map)o).get("dimension")).get("number"))).collect(Collectors.toList());
        List icElimDetailscope = elimdetailscope.stream().filter(o -> DimTypesEnum.INTERCOMPANY.getNumber().equals(((Map)((Map)o).get("elimdimension")).get("number"))).collect(Collectors.toList());
        if (icDetailscope.size() == 0) {
            msg = String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u591a\u9009\u8303\u56f4\u7f3a\u5c11%s\u7ef4\u5ea6\u3002", (String)"CheckTmplBatchImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.INTERCOMPANY.getNumber());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (icElimDetailscope.size() == 0) {
            msg = String.format(ResManager.loadKDString((String)"\u62b5\u9500\u591a\u9009\u8303\u56f4\u7f3a\u5c11%s\u7ef4\u5ea6\u3002", (String)"CheckTmplBatchImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.INTERCOMPANY.getNumber());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        Set cusdimNumbers = dimMap.values().stream().filter(dim -> fieldmappeds.contains(dim.getString("fieldmapped"))).map(dim -> dim.getString("number")).collect(Collectors.toSet());
        for (String cusDimNum : cusdimNumbers) {
            List custDimDetailscope = detailscope.stream().filter(o -> cusDimNum.equals(((Map)((Map)o).get("dimension")).get("number"))).collect(Collectors.toList());
            List custDimElimDetailscope = elimdetailscope.stream().filter(o -> cusDimNum.equals(((Map)((Map)o).get("elimdimension")).get("number"))).collect(Collectors.toList());
            if (custDimDetailscope.size() == 0) {
                String msg14 = String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u591a\u9009\u8303\u56f4\u7f3a\u5c11%s\u7ef4\u5ea6\u3002", (String)"CheckTmplBatchImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), cusDimNum);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg14);
            }
            if (custDimElimDetailscope.size() != 0) continue;
            String msg15 = String.format(ResManager.loadKDString((String)"\u62b5\u9500\u591a\u9009\u8303\u56f4\u7f3a\u5c11%s\u7ef4\u5ea6\u3002", (String)"CheckTmplBatchImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), cusDimNum);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg15);
        }
        return Pair.onePair((Object)Boolean.TRUE, (Object)"");
    }

    private List<IDNumberTreeNode> convertToMember(Long modelId, DynamicObject dim, List<Object> detailItems, String elim) {
        ArrayList<IDNumberTreeNode> result = new ArrayList<IDNumberTreeNode>(16);
        HashSet memberNums = new HashSet(16);
        String dimNumber = dim.getString("number");
        for (Object item : detailItems) {
            String dimNum = (String)((Map)((Map)item).get(elim + "dimension")).get("number");
            boolean isCust = false;
            String scope = (String)((Map)item).get(elim + "scope");
            if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimNum) && !atScops.contains(scope)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22\u7684\u6210\u5458\u8303\u56f4\u53ea\u80fd\u900910\u621690\u3002", (String)"CheckTmplBatchImportPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String[] Signs = ((Map)item).get(elim + "sign").toString().split("@@");
            if (Signs.length < 2) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s \u586b\u5199\u9519\u8bef\uff1a%2$s", (String)"CheckTmplBatchImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), elim + "sign", ((Map)item).get(elim + "sign")));
            }
            String signum = Signs[1];
            if ("elim".equals(elim) && !Signs[0].startsWith(elim)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s \u586b\u5199\u9519\u8bef\uff1a%2$s", (String)"CheckTmplBatchImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), elim + "sign", ((Map)item).get(elim + "sign")));
            }
            IDNumberTreeNode member = this.getMemberByNumCache(modelId, dimNumber, signum, false);
            if (member == null) {
                signum = signum.contains(":") ? signum.split(":")[1] : signum;
                member = this.getMemberByNumCache(modelId, dimNumber, signum, true);
                isCust = true;
            }
            if (member == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s \u586b\u5199\u9519\u8bef\uff1a%2$s", (String)"CheckTmplBatchImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), elim + "sign", ((Map)item).get(elim + "sign")));
            }
            HashSet itemNumSet = new HashSet(16);
            MembRangeItem membRangeItem = new MembRangeItem(dim.getString("membermodel"), member.getId(), signum, Integer.parseInt(scope), isCust, (Object)modelId);
            if (this.memberItemCache.containsKey(membRangeItem.genKey((Object)""))) {
                itemNumSet.addAll(this.memberItemCache.get(membRangeItem.genKey((Object)"")));
            } else {
                membRangeItem.matchItems(e -> itemNumSet.add(e.getNumber()));
                this.memberItemCache.put(membRangeItem.genKey((Object)""), itemNumSet);
            }
            memberNums.addAll(itemNumSet);
        }
        for (String memNum : memberNums) {
            IDNumberTreeNode dy = this.getMemberByNumCache(modelId, dimNumber, memNum, false);
            if (dy == null) continue;
            result.add(dy);
        }
        return result;
    }

    private void createDetailScopeEntry(DynamicObjectCollection details, Object json, Long modelId, String elim, String tarSign, Map<String, DynamicObject> dimMap) {
        IDNumberTreeNode member;
        DynamicObject newEntryDetailObj;
        String dimNum = (String)((Map)((Map)json).get(elim + "dimension")).get("number");
        DynamicObject dimension = dimMap.get(dimNum);
        if (dimension != null) {
            newEntryDetailObj = details.addNew();
            newEntryDetailObj.set(tarSign + "scope", ((Map)json).get(elim + "scope"));
            String[] Signs = ((Map)json).get(elim + "sign").toString().split("@@");
            if (Signs.length < 2) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s \u586b\u5199\u9519\u8bef\uff1a%2$s", (String)"CheckTmplBatchImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), elim + "sign", ((Map)json).get(elim + "sign")));
            }
            String sign = Signs[0];
            String signum = Signs[1];
            newEntryDetailObj.set(tarSign + "sign", (Object)sign);
            member = this.getMemberByNumCache(modelId, dimNum, signum, false);
            if (member == null) {
                signum = signum.contains(":") ? signum.split(":")[1] : signum;
                member = this.getMemberByNumCache(modelId, dimNum, signum, true);
            }
            if (member == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s \u586b\u5199\u9519\u8bef\uff1a%2$s", (String)"CheckTmplBatchImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), elim + "sign", ((Map)json).get(elim + "sign")));
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s \u586b\u5199\u9519\u8bef\uff1a%2$s", (String)"CheckTmplBatchImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), elim + "sign", ((Map)json).get(elim + "sign")));
        }
        newEntryDetailObj.set(tarSign + "memberid", (Object)member.getId());
        DynamicObject dimdy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimension");
        dimdy.set("id", (Object)dimension.getLong("id"));
        newEntryDetailObj.set(tarSign + "dimension", (Object)dimdy);
    }

    private void setPeriod(DynamicObject dyn, JSONObject period, Long modelId) {
        String[] numbers;
        DynamicObjectCollection periodCol = dyn.getDynamicObjectCollection("period");
        periodCol.clear();
        for (String num : numbers = period.get((Object)"number").toString().split(",")) {
            IDNumberTreeNode periodObj = this.getMemberByNumCache(modelId, "Period", num, false);
            if (periodObj == null) continue;
            DynamicObject perioddyn = periodCol.addNew();
            perioddyn.set("fbasedataid_id", (Object)periodObj.getId());
        }
    }

    private Long getModeId(JSONObject modelJson) {
        if (modelJson.containsKey((Object)"shownumber") && modelJson.get((Object)"shownumber") != null) {
            String modelNumber = (String)modelJson.get((Object)"shownumber");
            Map modeCache = (Map)this.getCache(CACHE_MODEL_MAP);
            Long aLong = (Long)modeCache.get(modelNumber);
            if (aLong != null) {
                return aLong;
            }
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)modelNumber).toArray());
            if (model != null) {
                modeCache.put(modelNumber, model.getLong("id"));
                this.addCache(CACHE_MODEL_MAP, modeCache);
                this.cacheModeInfo(model.getLong("id"));
                return model.getLong("id");
            }
        }
        return null;
    }

    private IDNumberTreeNode getMemberByNumCache(Long modelId, String dimNum, String memberNum, boolean isCus) {
        if (isCus) {
            Map dynamicObjectMap;
            Map memberCache = (Map)this.getCache(CACHE_PROPERTYMEMBER_MAP);
            Map mapMap = (Map)memberCache.get(modelId.toString());
            if (mapMap != null && (dynamicObjectMap = (Map)mapMap.get(dimNum)) != null) {
                DynamicObject dy = (DynamicObject)dynamicObjectMap.get(memberNum);
                if (dy != null) {
                    return new IDNumberTreeNode(Long.valueOf(dy.getLong("id")), dy.getString("number"), "", -1, -1, null, null, false, null, Long.valueOf(-1L), "");
                }
                return null;
            }
            return null;
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String cacheKey = String.join((CharSequence)"#", modelNum, dimNum, memberNum);
        IDNumberTreeNode node = this.memberReaderCache.get(cacheKey);
        if (node == null) {
            node = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)memberNum);
            this.memberReaderCache.put(cacheKey, node);
        }
        if (node != IDNumberTreeNode.NotFoundTreeNode) {
            return node;
        }
        return null;
    }

    private void cacheModeInfo(long modelId) {
        Map dimCache = (Map)this.getCache(CACHE_DIM_MAP);
        DynamicObjectCollection dim = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,fieldmapped,membermodel", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        dimCache.put(modelId + "", dim);
        this.addCache(CACHE_DIM_MAP, dimCache);
        Map templateCatalogCache = (Map)this.getCache(CACHE_TEMPLATECATALOG_MAP);
        QFBuilder filters = new QFBuilder("model", "=", (Object)modelId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_checktmplcatalog", (String)"id,number", (QFilter[])filters.toArray());
        for (DynamicObject catalog : collection) {
            templateCatalogCache.put(modelId + catalog.getString("number"), catalog.getLong("id"));
        }
        this.addCache(CACHE_TEMPLATECATALOG_MAP, templateCatalogCache);
        Map propertyMemberCache = (Map)this.getCache(CACHE_PROPERTYMEMBER_MAP);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,dimension.number", (QFilter[])qFilter.toArray());
        Map<String, List<DynamicObject>> listMap = dynamicObjects.stream().filter(e -> e.getString("dimension.number") != null).collect(Collectors.groupingBy(e -> e.getString("dimension.number")));
        HashMap cachePropertyMem = new HashMap(16);
        listMap.forEach((key, list) -> cachePropertyMem.put(key, list.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e, (o1, o2) -> o1))));
        propertyMemberCache.put(modelId + "", cachePropertyMem);
        this.addCache(CACHE_PROPERTYMEMBER_MAP, propertyMemberCache);
        Map adjustCatalogMapCache = (Map)this.getCache(CACHE_ADJUSTCATALOG_MAP);
        DynamicObjectCollection adjustCatalogs = QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,number", (QFilter[])new QFilter[]{AdjustCatalogUtil.getAdjustCatalogFilterWithPerm(modelId)});
        adjustCatalogs.forEach(d -> adjustCatalogMapCache.put(modelId + d.getString("number"), d.getLong("id")));
        this.addCache(CACHE_ADJUSTCATALOG_MAP, adjustCatalogMapCache);
    }

    private void getCheckConfig(DynamicObject dyn, String[] checkconfig, Long modelId, Integer diffMode) {
        Map dimCache = (Map)this.getCache(CACHE_DIM_MAP);
        DynamicObjectCollection dim = (DynamicObjectCollection)dimCache.get(modelId.toString());
        if (dim != null) {
            ArrayList<String> list = new ArrayList<String>(16);
            for (String e : checkconfig) {
                if (!StringUtils.isNotEmpty((CharSequence)e)) continue;
                if (checkconfigs.containsKey(e)) {
                    list.add(checkconfigs.get(e));
                    continue;
                }
                List collect = dim.stream().filter(n -> StringUtils.isNotEmpty((CharSequence)n.getString("fieldmapped"))).filter(n -> n.getString("number").equals(e)).map(n -> n.getString("fieldmapped")).collect(Collectors.toList());
                list.addAll(collect.isEmpty() ? collect : Collections.singleton(checkconfigs.get(collect.get(0))));
            }
            dyn.set("checkconfig", (Object)Joiner.on((String)",").join(list));
        }
    }

    private Long getEntityIdByNum(JSONObject dataJson, Long modelId, String cacheKey) {
        if (dataJson.containsKey((Object)"number") && dataJson.get((Object)"number") != null) {
            String number = (String)dataJson.get((Object)"number");
            Map cacheMap = (Map)this.getCache(cacheKey);
            if (cacheMap.containsKey(modelId.toString() + number)) {
                return (Long)cacheMap.get(modelId.toString() + number);
            }
        }
        return null;
    }

    private QFilter[] getUniqueFilters(JSONObject data, Long modelId, String type) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter numQf = new QFilter("number", "=", data.get((Object)"number"));
        if ("number".equals(type)) {
            return new QFilter[]{modelFilter, numQf};
        }
        Object name = data.get((Object)"name");
        String nameStr = name instanceof Map ? LocaleString.fromMap((Map)((Map)name)).toString().trim() : name.toString().trim();
        QFilter nameQf = new QFilter("name", "=", (Object)nameStr);
        return new QFilter[]{modelFilter, nameQf};
    }

    private boolean isExistDimension(Long modelId, String dimNum) {
        return MemberReader.isExistDimension((String)MemberReader.findModelNumberById((Object)modelId), (String)dimNum);
    }
}

