/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Control;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.CheckBox;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.check.CheckHelper;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;

public class CheckTmplDiffSettingPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static final String CTL_FLEXPANELAP = "flexpanelap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long model = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", model.toString());
        this.initPageView();
    }

    public void initPageView() {
        String oldValue;
        Map diffItems = CheckUtil.getDiffItems((Long)this.getModelId());
        Page page = new Page();
        page.addArea(this.getArea(diffItems));
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        qf.and(new QFilter("user", "=", (Object)0L));
        DynamicObject diffSettingDyn = QueryServiceHelper.queryOne((String)"bcm_checktmpllayout", (String)"id,model,user,diffsetting", (QFilter[])qf.toArray());
        if (diffSettingDyn == null) {
            CheckHelper.insertionUsing(this.getModelId());
            diffSettingDyn = QueryServiceHelper.queryOne((String)"bcm_checktmpllayout", (String)"id,model,user,diffsetting", (QFilter[])qf.toArray());
        }
        String string = oldValue = diffSettingDyn.getString("diffsetting") == null ? "" : diffSettingDyn.getString("diffsetting");
        if (StringUtils.isEmpty((CharSequence)oldValue.trim())) {
            oldValue = CheckUtil.DEFEULTDIFFSETTING;
        }
        Arrays.stream(oldValue.split("#")).forEach(key -> {
            if (diffItems.containsKey(key)) {
                this.getModel().setValue(key, (Object)true);
            }
        });
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"8", "5"});
    }

    private Area getArea(Map<String, String> diffItems) {
        Area area = new Area(CTL_FLEXPANELAP);
        TreeMap<String, String> treeMap = new TreeMap<String, String>(Comparator.comparingInt(e -> CheckUtil.diffSettingOrderList.indexOf(e)));
        treeMap.putAll(diffItems);
        treeMap.forEach((sign, name) -> {
            CheckBox checkBox = new CheckBox(name, sign);
            checkBox.setLabelDirection("v");
            checkBox.setCustomStyle(e -> {
                e.setWidth(new LocaleString("22%"));
                e.setFontSize(12);
                Style style = new Style();
                Margin margin = new Margin();
                margin.setRight("10px");
                margin.setLeft("10px");
                margin.setTop("15px");
                margin.setBottom("15px");
                style.setMargin(margin);
                e.setStyle(style);
            });
            area.addElement((Element)checkBox);
        });
        return area;
    }

    @Override
    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.saveDiffSetting();
                this.getView().returnDataToParent((Object)"bcm_checkdiffsetting");
                this.getView().close();
                break;
            }
        }
    }

    private void saveDiffSetting() {
        Area area = this.getPage(this.getView()).findAreaBySign(CTL_FLEXPANELAP);
        ArrayList<String> list = new ArrayList<String>(area.getElementListList().size());
        for (Element element : area.getElementListList()) {
            if (!((Boolean)this.getModel().getValue(element.getSign())).booleanValue()) continue;
            list.add(element.getSign());
        }
        String sql = " update t_bcm_checkrptlot set fdiffsetting = ? where fmodelid = ? and fuserid = ? ";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql, (Object[])new Object[]{String.join((CharSequence)"#", list), this.getModelId(), 0L});
        SaveServiceHelper.clearDataEntityCache((String)"bcm_checktmpllayout");
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bf9\u8d26\u5dee\u5f02\u5904\u7406\u914d\u7f6e", "CheckTmplDiffSettingPlugin_1", "fi-bcm-formplugin", "checkTmplDiffSetting"), OPDescMultiLangEnumBridge.genOpDescBridge((MultiLangEnumBridge)OpItemEnum.SETSUCCESS.getMultiLangEnumBridge(), null));
    }
}

