/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CheckTmplExportPlugin
extends AbstractBaseFormPlugin {
    private static final Map<String, String> checkconfigs = new ImmutableMap.Builder().put((Object)"1", (Object)"dim1").put((Object)"2", (Object)"dim2").put((Object)"3", (Object)"dim3").put((Object)"4", (Object)"dim4").put((Object)"5", (Object)"dim5").put((Object)"6", (Object)"dim6").put((Object)"7", (Object)"AuditTrail").build();

    public String export(String routeAppId, String formId, Long modelId, QFilter[] filterParams, Long template, String entityName) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        int rowIndex = 3;
        DynamicObject[] arrDimMapping = BusinessDataServiceHelper.load((String)entityName, (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_checktmpl").getAllFields().keySet()), (QFilter[])filterParams);
        String modelCude = MemberReader.findModelNumberById((Object)modelId);
        Map<String, String> realdimNumbers = this.getDimensions(modelId);
        DynamicObjectCollection dim = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,fieldmapped", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        for (DynamicObject dyn : arrDimMapping) {
            DynamicObject permClass = PermClassEntityHelper.getPermissionClassEntity((DynamicObject)dyn);
            if (permClass != null) {
                dyn.set("permclass", (Object)permClass.getDynamicObject("permclass"));
            }
            if ("0".equals(dyn.getString("diffmethod"))) {
                dyn.set("diffmethod", (Object)" ");
            }
            this.getCheckConfig(dyn, dim);
            for (DynamicObject entry : dyn.getDynamicObjectCollection("entryentity")) {
                Object detail2;
                entry.set("elim_mycompany", entry.get("mycompany"));
                List detailscope = DynamicObjectCollectionUtil.getDynamicObjects((DynamicObjectCollection)entry.getDynamicObjectCollection("detailscope"));
                detailscope.removeIf(e -> "mycompany".equals(e.getString("sign")));
                detailscope.sort(Comparator.comparing(d -> d.getString("sign")));
                entry.set("detailscope", (Object)detailscope);
                for (Object detail2 : detailscope) {
                    DynamicObject query;
                    String number = this.getMemberNumber(modelCude, realdimNumbers, (DynamicObject)detail2, Boolean.FALSE);
                    if (StringUtils.isEmpty((CharSequence)number) && (query = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.number,number", (QFilter[])new QFilter("id", "=", (Object)detail2.getLong("memberid")).toArray())) != null) {
                        number = query.getString("propertyid.number") + ":" + query.getString("number");
                    }
                    number = number == null ? "" : number;
                    detail2.set("sign", (Object)(detail2.getString("sign") + "@@" + number));
                }
                List elimdetailscope = DynamicObjectCollectionUtil.getDynamicObjects((DynamicObjectCollection)entry.getDynamicObjectCollection("elimdetailscope"));
                elimdetailscope.sort(Comparator.comparing(d -> d.getString("elimsign")));
                entry.set("elimdetailscope", (Object)elimdetailscope);
                detail2 = elimdetailscope.iterator();
                while (detail2.hasNext()) {
                    DynamicObject query;
                    DynamicObject elimdetail = (DynamicObject)detail2.next();
                    String number = this.getMemberNumber(modelCude, realdimNumbers, elimdetail, Boolean.TRUE);
                    if (StringUtils.isEmpty((CharSequence)number) && (query = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.number,number", (QFilter[])new QFilter("id", "=", (Object)elimdetail.getLong("elimmemberid")).toArray())) != null) {
                        number = query.getString("propertyid.number") + ":" + query.getString("number");
                    }
                    number = number == null ? "" : number;
                    elimdetail.set("elimsign", (Object)(elimdetail.getString("elimsign") + "@@" + number));
                }
            }
        }
        String json = SerializationUtils.toJsonString((Object)arrDimMapping);
        JSONArray billArr = JSONArray.parseArray((String)json);
        String fileName = this.genFileName(template, entityName, "");
        boolean isCheckMaxLineReplace = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isCheckMaxLineReplace");
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHeadAndClearCTAndAT((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (String)routeAppId, (Object)formId, (Object)template, (Object)entityName, (DynamicObject[])arrDimMapping, e -> {
            if (e != null && e.properties.containsKey("diffmode")) {
                ((Map)e.properties.get("diffmode")).compute("InputType", (k, v) -> {
                    if (v instanceof JSONArray) {
                        ((JSONArray)v).clear();
                        for (DiffModeEnum diffModeEnum : DiffModeEnum.values()) {
                            if (!diffModeEnum.isVisible()) continue;
                            ((JSONArray)v).add((Object)(diffModeEnum.getName() + " # " + diffModeEnum.getValue()));
                        }
                    }
                    return v;
                });
            } else if (e != null && e.properties.containsKey("diffmethod")) {
                ((Map)e.properties.get("diffmethod")).compute("InputType", (k, v) -> {
                    if (v instanceof JSONArray) {
                        ((JSONArray)v).clear();
                        for (DiffMethodEnum diffMethodEnum : DiffMethodEnum.values()) {
                            if (diffMethodEnum == DiffMethodEnum.MAXMAPPING) {
                                if (!isCheckMaxLineReplace) continue;
                                ((JSONArray)v).add((Object)(diffMethodEnum.getName() + " # " + diffMethodEnum.getValue()));
                                continue;
                            }
                            ((JSONArray)v).add((Object)(diffMethodEnum.getName() + " # " + diffMethodEnum.getValue()));
                        }
                    }
                    return v;
                });
            }
        });
        if (format == null) {
            return null;
        }
        try (TraceSpan span = Tracer.create((String)"bcmexport", (String)"export");){
            for (int i = 0; i < billArr.size(); ++i) {
                JSONObject bill = billArr.getJSONObject(i);
                int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)(rowIndex + 1), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
                rowIndex += offset;
            }
        }
        return this.writeFile(wb, fileName);
    }

    private String getMemberNumber(String modelCude, Map<String, String> realdimNumbers, DynamicObject detail, boolean isElim) {
        DynamicObject dimension = null;
        Long memberid = null;
        if (isElim) {
            dimension = detail.getDynamicObject("elimdimension");
            memberid = detail.getLong("elimmemberid");
        } else {
            dimension = detail.getDynamicObject("dimension");
            memberid = detail.getLong("memberid");
        }
        IDNumberTreeNode node = MemberReader.findMemberById((String)modelCude, (String)realdimNumbers.get(dimension.getString("number")), (Long)memberid);
        if (IDNumberTreeNode.NotFoundTreeNode.equals(node)) {
            return "";
        }
        return node.getNumber();
    }

    private Map<String, String> getDimensions(long modelid) {
        QFilter qf = new QFilter("model", "=", (Object)modelid);
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)"number, memberform", (QFilter[])qfs);
        HashMap<String, String> map = new HashMap<String, String>(16);
        dcs.forEach(p -> map.put(p.getString("number"), p.getString("memberform")));
        return map;
    }

    private String genFileName(Long template, String billFormId, String fileNamePrefix) {
        String fileName = fileNamePrefix;
        DynamicObject templateData = null;
        if (template > 0L) {
            templateData = QueryServiceHelper.queryOne((String)"bos_importtemplate", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)template)});
        }
        if (templateData != null) {
            fileName = fileName + templateData.get("name");
        } else {
            BillEntityType listEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
            fileName = fileName + listEntityType.getDisplayName();
        }
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("_%02d%02d", now.getMonthValue(), now.getDayOfMonth()) + ".xlsx";
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private void getCheckConfig(DynamicObject dyn, DynamicObjectCollection dim) {
        String[] checkconfig = dyn.getString("checkconfig").split(",");
        List<String> collect1 = Arrays.stream(checkconfig).sorted(Comparator.comparing(e -> e)).collect(Collectors.toList());
        ArrayList list = new ArrayList(16);
        collect1.forEach(e -> {
            if (StringUtils.isNotEmpty((CharSequence)e) && checkconfigs.containsKey(e)) {
                if (0 == Integer.parseInt(e) || 7 == Integer.parseInt(e) || 8 == Integer.parseInt(e) || 9 == Integer.parseInt(e)) {
                    list.add(checkconfigs.get(e));
                } else {
                    List collect = dim.stream().filter(n -> StringUtils.isNotEmpty((CharSequence)n.getString("fieldmapped"))).filter(n -> n.getString("fieldmapped").equals(checkconfigs.get(e))).map(n -> n.getString("number")).collect(Collectors.toList());
                    list.addAll(collect);
                }
            }
        });
        if (list.size() > 0) {
            dyn.set("checkconfignumber", (Object)Joiner.on((String)",").join(list));
        } else {
            dyn.set("checkconfignumber", (Object)"");
            dyn.set("checkconfig", (Object)"");
        }
    }
}

