/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.util.DragUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.CheckCreateTypeEnum;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.check.CheckHelper;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.spread.domain.view.Sheet;

public class CheckTmplLayoutPlugin
extends AbstractTemplateBasePlugin
implements DynamicPage {
    private static final List<String> mustShowList = Collections.unmodifiableList(Arrays.asList("checktmpl", "entity", "myentity", "oppositeentity", "entryaccount", "cvtdifmoney", "entryocmoney"));
    private static final List<String> unchangeOrderList = Collections.unmodifiableList(Arrays.asList("checktmpl", "entity", "myentity"));
    private static final List<String> group0 = Collections.unmodifiableList(Arrays.asList("entryaudittrail", "entrychangetype", "entrydim1", "entrydim2", "entrydim3", "entrydim4", "entrydim5", "entrydim6"));
    private static final List<String> group1 = Collections.unmodifiableList(Arrays.asList("entryocmoney", "entryecmoney", "entrycvtpath", "entrycvtmoney", "entrydccvtmoney"));
    private static final List<String> group2 = Collections.unmodifiableList(Arrays.asList("entryelimmoney", "entryelimdcmoney"));
    private static final List<String> group3 = Collections.unmodifiableList(Arrays.asList("adjustnumber", "isautoelim", "diffmode", "difftype", "status", "modifier", "modifytime", "mark"));
    private static final String HIDE = "hide";
    private static final String SHOW = "show";
    private static final String spreadKey = "layout_view";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long model = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", model.toString());
        this.getView().setVisible(Boolean.valueOf(this.isFromCheckDetaillReport()), new String[]{"btn_reset"});
        this.initializeData();
        Long userId = this.isFromCheckDetaillReport() ? LongUtil.toLong((Object)RequestContext.get().getUserId()) : 0L;
        DynamicObject dimen = this.getDimensionDyn(userId);
        if (dimen == null && this.isFromCheckDetaillReport()) {
            dimen = this.getDimensionDyn(0L);
        }
        if (dimen != null) {
            this.initPageArea(dimen);
        }
        this.refreshSpread();
    }

    private void initPageArea(DynamicObject dimen) {
        QFilter query = new QFilter("model", "=", (Object)this.getModelId());
        QFilter query2 = new QFilter("issysdimension", "=", (Object)"0");
        DynamicObjectCollection dimensionCollection = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,number,fieldmapped", (QFilter[])new QFilter[]{query, query2}, (String)"fieldmapped");
        Map<String, String> dimMap = dimensionCollection.stream().collect(Collectors.toMap(e1 -> "entry" + e1.getString("fieldmapped"), e2 -> e2.getString("name")));
        DynamicObjectCollection dy = dimen.getDynamicObjectCollection("entryentity");
        if (BlackListUtils.hasFeatureInCm((String)"CMTra")) {
            dy.remove(9);
        }
        Map<String, String> collect = dy.stream().collect(Collectors.toMap(p1 -> p1.getString("columnnumber"), p2 -> CheckHelper.getColumnNameByColumnSign(p2.getString("columnnumber"), dimMap)));
        List<String> show = dy.stream().filter(p1 -> p1.getBoolean("isshow")).sorted(Comparator.comparing(p -> p.getInt("sortorder"))).map(p1 -> p1.getString("columnnumber")).collect(Collectors.toList());
        List<String> hide = dy.stream().filter(p1 -> !p1.getBoolean("isshow")).sorted(Comparator.comparing(p -> p.getInt("sortorder"))).map(p1 -> p1.getString("columnnumber")).collect(Collectors.toList());
        this.getModel().setValue("radiogroup", (Object)dimen.getString("iscompany"));
        this.addItems(hide, show, SHOW, HIDE);
        this.getItems(collect);
        this.getControl(SHOW).setDroppable(true);
        this.getControl(HIDE).setDroppable(true);
        this.getPageCache().put("columMap", ObjectSerialUtil.toByteSerialized(collect));
    }

    private void getItems(Map<String, String> collect) {
        for (Map.Entry<String, String> entry : collect.entrySet()) {
            this.getModel().setValue(entry.getKey(), (Object)entry.getValue());
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        this.getBcmControl(e);
    }

    private void addItems(List<String> hides, List<String> shows, String isShow, String isHide) {
        Page page = new Page();
        page.addArea(this.getArea(shows, isShow));
        page.addArea(this.getArea(hides, isHide));
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        DragUtil.allDrag((IFormView)this.getView(), (Page)page);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btn_reset");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            DynamicObject adminDyn;
            Long userId = this.isFromCheckDetaillReport() ? LongUtil.toLong((Object)RequestContext.get().getUserId()) : 0L;
            DynamicObject dimensionDyn = this.getDimensionDyn(userId);
            if (dimensionDyn == null && (adminDyn = this.getDimensionDyn(0L)) != null && this.isFromCheckDetaillReport()) {
                CloneUtils cloneUtil = new CloneUtils(true, true);
                dimensionDyn = (DynamicObject)cloneUtil.clone((IDataEntityBase)adminDyn);
                dimensionDyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                DynamicObject bosUser = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                bosUser.set("id", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
                dimensionDyn.set("user", (Object)bosUser);
            }
            if (dimensionDyn != null) {
                DynamicObjectCollection dy = dimensionDyn.getDynamicObjectCollection("entryentity");
                List<String> hide = this.getCommonElementEntity(HIDE);
                List<String> show = this.getCommonElementEntity(SHOW);
                dimensionDyn.set("iscompany", this.getModel().getValue("radiogroup"));
                dy.forEach(e -> {
                    if (hide.contains(e.getString("columnnumber"))) {
                        e.set("isshow", (Object)false);
                        e.set("sortorder", (Object)hide.indexOf(e.getString("columnnumber")));
                    } else if (show.contains(e.getString("columnnumber"))) {
                        e.set("isshow", (Object)true);
                        e.set("sortorder", (Object)show.indexOf(e.getString("columnnumber")));
                    }
                });
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dimensionDyn});
            }
            this.getView().returnDataToParent((Object)Boolean.TRUE);
            this.getView().close();
        } else if ("btn_reset".equals(key)) {
            DynamicObject dimen = this.getDimensionDyn(0L);
            if (dimen != null) {
                this.initPageArea(dimen);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u544a\u5e03\u5c40\u8bbe\u7f6e\u5df2\u6309\u6700\u65b0\u6a21\u677f\u8bbe\u7f6e\u66f4\u65b0\uff0c\u786e\u8ba4\u4fdd\u5b58\u540e\u751f\u6548\u3002", (String)"CheckTmplLayoutPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("radiogroup".equalsIgnoreCase(e.getProperty().getName())) {
            this.refreshSpread();
        }
    }

    private Area getArea(List<String> collect, String key) {
        Area area = new Area(key);
        collect.forEach(e -> {
            TextEditElement text = new TextEditElement("", e, "entity");
            text.setShowLabel(false);
            text.setEditStyle(0);
            text.setFieldStyle(2);
            text.setFieldTextAlign("center");
            text.setTextAlign("left");
            text.setWidth(new LocaleString("130px"));
            text.setFontSize(13);
            Style style = new Style();
            Margin margin = new Margin();
            margin.setRight("5px");
            margin.setLeft("5px");
            margin.setTop("20px");
            margin.setBottom("10px");
            style.setMargin(margin);
            text.setStyle(style);
            area.addElement((Element)text);
        });
        return area;
    }

    private void initializeData() {
        DynamicObject dy = this.getDimensionDyn(0L);
        Long modle = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (null != dy) {
            boolean isNeedAddOcDiffMoney;
            List don = CheckHelper.getSysDimension(modle).stream().map(e -> "entry" + e.getString("fieldmapped")).collect(Collectors.toList());
            List collect = dy.getDynamicObjectCollection("entryentity").stream().map(e -> e.getString("columnnumber")).collect(Collectors.toList());
            boolean bl = isNeedAddOcDiffMoney = CheckHelper.isOpenOC(modle) && !collect.contains("ocdiffmoney");
            if (!collect.containsAll(don) || CheckHelper.isNeedUpdateOCColum(modle) || isNeedAddOcDiffMoney) {
                QFilter qf = new QFilter("model", "=", (Object)modle);
                DeleteServiceHelper.delete((String)"bcm_checktmpllayout", (QFilter[])qf.toArray());
                CheckHelper.insertionUsing(modle);
            }
            return;
        }
        CheckHelper.insertionUsing(modle);
    }

    private DynamicObject getDimensionDyn(Long UserId) {
        Long modle = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        QFilter qf = new QFilter("model", "=", (Object)modle);
        qf.and(new QFilter("user", "=", (Object)UserId));
        DynamicObject[] dy = BusinessDataServiceHelper.load((String)"bcm_checktmpllayout", (String)"id,model,user,iscompany,entryentity,entryentity.columnnumber,entryentity.isshow,entryentity.sortorder", (QFilter[])qf.toArray());
        return dy.length == 0 ? null : dy[0];
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String source;
            String eventArgs = e.getEventArgs();
            String[] msg = this.translateMessage(eventArgs);
            String target = msg[0];
            if (!this.checkParameter(target, source = msg[1]).booleanValue()) {
                return;
            }
            List<String> hideList = this.getCommonElementEntity(HIDE);
            List<String> showList = this.getCommonElementEntity(SHOW);
            if (SHOW.equals(target)) {
                if (showList.contains(source)) {
                    return;
                }
                this.setTheDisplay(hideList, showList, source, SHOW, HIDE, null);
            } else if (HIDE.equals(target)) {
                if (hideList.contains(source)) {
                    return;
                }
                this.setTheDisplay(showList, hideList, source, HIDE, SHOW, null);
            } else if (hideList.contains(target)) {
                this.setTheDisplay(showList, hideList, source, HIDE, SHOW, target);
            } else if (hideList.contains(source)) {
                this.setTheDisplay(hideList, showList, source, SHOW, HIDE, null);
            } else {
                this.setTheDisplay(hideList, showList, source, SHOW, HIDE, target);
            }
            this.refreshSpread();
        }
    }

    private void setTheDisplay(List<String> hide, List<String> show, String source, String isShow, String isHide, String target) {
        Map collect = (Map)this.deSerializedBytes(this.getPageCache().get("columMap"));
        if (StringUtils.isNotEmpty((CharSequence)target)) {
            int index;
            int indexsource = show.indexOf(source);
            show.removeIf(e -> source.equals(e));
            int indextar = show.indexOf(target);
            if ("oppositeentity".equals(source)) {
                if (indexsource > indextar) {
                    index = 3;
                } else {
                    ArrayList<Integer> g1 = new ArrayList<Integer>(16);
                    for (String sign : group1) {
                        if (show.indexOf(sign) == -1) continue;
                        g1.add(show.indexOf(sign));
                    }
                    for (String sign : group2) {
                        if (show.indexOf(sign) == -1) continue;
                        g1.add(show.indexOf(sign));
                    }
                    if (g1.size() == 0) {
                        index = 4;
                    } else {
                        Integer integer = (Integer)g1.stream().max(Integer::compareTo).get();
                        index = integer + 1;
                    }
                }
            } else {
                index = indexsource > indextar ? indextar : indextar + 1;
            }
            show.add(index, source);
        } else {
            int index = this.getDefaultIndexInArea(source, show);
            show.add(index, source);
        }
        hide.removeIf(p -> p.equals(source));
        this.addItems(hide, show, isShow, isHide);
        this.getItems(collect);
    }

    private int getDefaultIndexInArea(String sign, List<String> list) {
        int index = list.size();
        if (group0.contains(sign)) {
            for (String num : group0) {
                if (!list.contains(num)) continue;
                index = list.indexOf(num) + 1;
                return index;
            }
            return list.indexOf("entryaccount") + 1;
        }
        if (group1.contains(sign)) {
            for (String num : group1) {
                if (!list.contains(num)) continue;
                index = list.indexOf(num) + 1;
                return index;
            }
        }
        if (group2.contains(sign)) {
            for (String num : group2) {
                if (!list.contains(num)) continue;
                index = list.indexOf(num) + 1;
                return index;
            }
        }
        if (group3.contains(sign)) {
            for (String num : group3) {
                if (!list.contains(num)) continue;
                index = list.indexOf(num) + 1;
                return index;
            }
        }
        if ("oppositeentity".equals(sign)) {
            index = 3;
        }
        return index;
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private List<String> getCommonElementEntity(String common) {
        Area area = this.getPage(this.getView()).findAreaBySign(common);
        ArrayList<String> list = new ArrayList<String>(area.getElementListList().size());
        for (Element element : area.getElementListList()) {
            list.add(element.getSign());
        }
        return list;
    }

    private Boolean checkParameter(String target, String source) {
        Map collect = (Map)this.deSerializedBytes(this.getPageCache().get("columMap"));
        if (HIDE.equals(target) || SHOW.equals(target)) {
            if (mustShowList.contains(source) && HIDE.equals(target)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u53ef\u9690\u85cf\u3002", (String)"CheckTmplLayoutPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), collect.get(source)));
                return false;
            }
            if (mustShowList.contains(source) && this.getCommonElementEntity(SHOW).contains(source)) {
                return false;
            }
        } else {
            if (unchangeOrderList.contains(source) || unchangeOrderList.contains(target) || target.equals("oppositeentity")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s \u548c %2$s \u4e0d\u5141\u8bb8\u6539\u53d8\u987a\u5e8f\u3002", (String)"CheckTmplLayoutPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), collect.get(source), collect.get(target)));
                return false;
            }
            if ("oppositeentity".equals(source)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s \u53ea\u80fd\u653e\u5728 %2$s \u6216 \u5bf9\u8d26\u91d1\u989d \u540e\u3002", (String)"CheckTmplLayoutPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), collect.get("oppositeentity"), collect.get("myentity")));
                return true;
            }
        }
        return true;
    }

    private void refreshSpread() {
        Sheet sheet = this.getEffectiveSheet();
        SearchHelper.clearSheet(sheet, spreadKey, this.getClientViewProxy());
        SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), spreadKey);
        spreadEasyInvoker.setBatch(true);
        String json = AdjustModelUtil.getEmptyJson(8, 40);
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), spreadKey, json);
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), spreadKey);
        Map<Integer, Pair<String, String>> indexSignConfig = CheckHelper.getColumnConfigBySortedSign(this.getCommonElementEntity(SHOW), this.getModelId(), CheckCreateTypeEnum.CHECKADJUST_CREATE.value, this.getModel().getValue("radiogroup").toString());
        Map<String, Integer> signIndexConfig = CheckHelper.buildTableHead(this.getModelId(), sheet, indexSignConfig, spreadEasyInvoker);
        this.setColumnWidth(signIndexConfig, 60, spreadEasyInvoker);
        spreadEasyInvoker.setFrozenSheet(2, 0, 0, 0, "gray", 0);
        spreadEasyInvoker.startToInvoke();
        SearchHelper.lockOrUnlockCell(this.getClientViewProxy(), spreadKey, true, 0, 0, 8, 40);
        this.cacheSpreadModel();
    }

    @Override
    public String getSpreadKey() {
        return spreadKey;
    }

    private void setColumnWidth(Map<String, Integer> signIndexConfig, int width, SpreadEasyInvoker spreadEasyInvoker) {
        for (Integer col : signIndexConfig.values()) {
            spreadEasyInvoker.setColumnsWidth(col, width);
        }
    }

    private boolean isFromCheckDetaillReport() {
        return "bcm_checkdetail".equals(this.getFormCustomParam("PAGE_FROM"));
    }
}

