/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.Copy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.helper.CheckTmplCatalogServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.ElimTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.papertemplate.PaperTemplateSceneSettingHelper;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.check.CheckTmplExportPlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class CheckTmplListPlugin
extends AbstractBaseListPlugin {
    private static final String ctl_templatecatalog = "templatecatalog";
    private static final String ctl_billlistap = "billlistap";
    private static final String callbackid_del_confirm = "callbackid_del_confirm";
    private static final String deletecatalog_comfirm = "deletecatalog_comfirm";
    private static final String btn_addgroup = "btn_addgroup";
    private static final String btn_editgroup = "btn_editgroup";
    private static final String btn_delgroup = "btn_delgroup";
    private static final String btn_export = "btn_export";
    private static final String btn_import = "btn_import";
    private static final String btn_move = "btn_move";
    private static final String ctl_checkbox_tree = "treecheckbox";
    private static final String ctl_model = "model";
    private static final String ctl_scenario = "scenario";
    private static final String KEY_ADMINUSERBOL = "adminUserBol";
    private static final String KEY_ALLCHECKTMPLPERMMAP = "allCheckTmplPermMap";
    private static final String KEY_NOPERMCHECKTMPL = "nopermchecktmpl";
    private static final String KEY_READONLYCHECKTMPL = "readonlychecktmpl";
    private static final String KEY_READWRITEHECKTMPL = "readwritechecktmpl";

    private static OpNameMultiLangEnumBridge getOperationCopy() {
        return new OpNameMultiLangEnumBridge("\u590d\u5236", "CheckTmplListPlugin_2", "fi-bcm-formplugin", "copy");
    }

    private static OpNameMultiLangEnumBridge getOperationExport() {
        return new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "CheckTmplListPlugin_3", "fi-bcm-formplugin", "export");
    }

    private static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"CheckTmplListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"CheckTmplListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.setBillFormId("bcm_checktmpl");
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>(16);
        map.put(ctl_scenario, SingleF7TypeEnum.LEAF);
        super.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_addgroup, btn_editgroup, btn_delgroup);
        TreeView treeView = (TreeView)this.getControl(ctl_templatecatalog);
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                CheckTmplListPlugin.this.getPageCache().put("focusnodeid", evt.getNodeId().toString());
                CheckTmplListPlugin.this.refreshBillList(true);
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String key = ((ColumnDesc)e.getSource()).getKey();
            if ("checkconfig".equals(key)) {
                String checkconfig = e.getRowData().getString("checkconfig");
                if (!StringUtils.isEmpty((CharSequence)checkconfig)) {
                    e.setFormatValue((Object)this.getCheckConfigName(checkconfig));
                }
            } else if ("mulscenariotext".equals(key)) {
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id,scenarios.scenariomeb.id as scenariomeb.id,scenarios.scenariomeb.number as scenariomeb.number,scenarios.scenariomeb.name as scenariomeb.name,scenarios.scenarioscope as scenarioscope,scenarios.isexcept as isexcept", (QFilter[])new QFilter[]{new QFilter("id", "=", e.getRowData().getPkValue())});
                dynamicObjects.removeIf(o -> o.getLong("scenariomeb.id") == 0L);
                Pair p = PaperTemplateSceneSettingHelper.getItemAndNameByDyn((DynamicObjectCollection)dynamicObjects);
                e.setFormatValue(p.p1);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        IFormView parentView = this.getView().getParentView();
        String pageId = this.getView().getPageId() + e.getParameter().getPkId();
        IDataModel model = this.getModel();
        DynamicObject modelDyn = (DynamicObject)model.getValue(ctl_model);
        DynamicObject sceneDyn = (DynamicObject)model.getValue(ctl_scenario);
        if (modelDyn == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f53\u7cfb\u540e\u518d\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", (String)"CheckTmplListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        BillShowParameter parameter = e.getParameter();
        if (parameter.getStatus() == OperationStatus.ADDNEW) {
            parameter.setCustomParam("KEY_MODEL_ID", modelDyn.getPkValue());
            parameter.setCustomParam("KEY_SCENARIO_ID", sceneDyn == null ? Integer.valueOf(0) : sceneDyn.getPkValue());
            parameter.setCustomParam("pageId", e.getParameter().getPkId());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCaption(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f", (String)"CheckTmplListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        parameter.setPageId(pageId);
        if (parentView == null) {
            this.getView().showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(this.getView());
        } else {
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        }
        e.setCancel(true);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.actionEdit();
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperateKey().equals("copy")) {
            ListSelectedRow listSelectedRow = ((Copy)afterDoOperationEventArgs.getSource()).getListSelectedData().get(0);
            Object id = listSelectedRow.getPrimaryKeyValue();
            QFilter qcf = new QFilter("id", "=", id);
            DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_checktmpl", (String)"name,number", (QFilter[])new QFilter[]{qcf});
            this.writeMultiLangLog(CheckTmplListPlugin.getOperationCopy(), new OPDescMultiLangEnumBridge("\u8bb0\u5f55%1$s %2$s\uff0c%3$s %4$s", "CheckTmplListPlugin_44", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{data.getString("number"), data.getString("name"), CheckTmplListPlugin.getOperationCopy().loadKDString(), CheckTmplListPlugin.getOperationStstusSuccess()})));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Copy && !args.getListSelectedData().isEmpty() && !QueryServiceHelper.exists((String)"bcm_checktmpl", (Object)args.getListSelectedData().get(0).getPrimaryKeyValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"CheckTmplListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validate()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btn_addnew": {
                this.actionAddNew();
                break;
            }
            case "btn_assign": {
                this.actionAssign();
                break;
            }
            case "btn_delete": {
                this.actionDelete();
                break;
            }
            case "btn_refresh": {
                this.actionRefresh();
                break;
            }
            case "btn_export": {
                this.exportCheckTmpl();
                break;
            }
            case "btn_import": {
                this.importCheckTmpl();
                break;
            }
            case "btn_move": {
                this.movetemplate();
                break;
            }
            case "btn_order": {
                this.showTemplateOrderView();
                break;
            }
            case "btn_layout": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_checktmpllayoutfrom");
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_checktmpllayoutfrom");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
                break;
            }
            case "btn_enable": {
                this.updateCheckTmplEnable(true);
                break;
            }
            case "btn_disable": {
                this.updateCheckTmplEnable(false);
                break;
            }
            case "btn_diffsetting": {
                FormShowParameter sp = new FormShowParameter();
                sp.setFormId("bcm_checkdiffsetting");
                sp.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                sp.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack pcloseCallBack = new CloseCallBack((IFormPlugin)this, "bcm_checkdiffsetting");
                sp.setCloseCallBack(pcloseCallBack);
                this.getView().showForm(sp);
                break;
            }
        }
    }

    private void showTemplateOrderView() {
        if (!this.checkParams(true)) {
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_checktmpl_order");
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (this.getView().getParentView() != null) {
            param.setRootPageId(this.getView().getParentView().getPageId());
        }
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getValueId(ctl_model));
        param.setCustomParam("KEY_SCENARIO_ID", (Object)this.getValueId(ctl_scenario));
        param.setCaption(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f\u6392\u5e8f\uff08\u652f\u6301\u62d6\u62fd\u79fb\u52a8\u6392\u5e8f\uff09", (String)"CheckTmplListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tmpl_order");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void importCheckTmpl() {
        this.invokeOperation("bcm_checktmpl", "kd.fi.bcm.formplugin.check.CheckTmplBatchImportPlugin", ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f", (String)"CheckTmplListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "CheckTmplImportPlugin");
        SaveServiceHelper.clearDataEntityCache((String)"bcm_checktmpl");
    }

    private void exportCheckTmpl() {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        ListSelectedRowCollection ls = billList.getSelectedRows();
        try {
            if (ls.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bb0\u5f55\u3002", (String)"CheckTmplListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Object> set = new HashSet<Object>(16);
            for (ListSelectedRow row : ls) {
                set.add(row.getPrimaryKeyValue());
                this.writeMultiLangLog(CheckTmplListPlugin.getOperationExport(), new OPDescMultiLangEnumBridge("\u8bb0\u5f55%1$s %2$s\uff0c%3$s %4$s", "CheckTmplListPlugin_44", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{row.getNumber(), row.getName(), CheckTmplListPlugin.getOperationExport().loadKDString(), CheckTmplListPlugin.getOperationStstusSuccess()})));
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", set)});
            if (dynamicObjects.size() != set.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"CheckTmplListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.exportData("bcm_checktmpl", new QFilter("id", "in", set).toArray());
        }
        catch (Exception e) {
            for (ListSelectedRow row : ls) {
                this.writeMultiLangLog(CheckTmplListPlugin.getOperationExport(), new OPDescMultiLangEnumBridge("\u8bb0\u5f55%1$s %2$s\uff0c%3$s %4$s", "CheckTmplListPlugin_44", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{row.getNumber(), row.getName(), CheckTmplListPlugin.getOperationExport().loadKDString(), CheckTmplListPlugin.getOperationStstusFail()})));
            }
            throw new KDBizException(e.getMessage());
        }
    }

    protected void exportData(String entityName, QFilter[] qFilters) {
        if (qFilters.length == 0) {
            return;
        }
        String entityNameImp = entityName;
        long modelId = this.getModelId();
        QFilter[] filters = new QFilter[]{new QFilter("bizobject.number", "=", (Object)entityNameImp), new QFilter("templatetype", "=", (Object)"IMPT").or(new QFilter("templatetype", "is null", null))};
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters, (String)"", (int)2);
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            CheckTmplExportPlugin exportor = new CheckTmplExportPlugin();
            String url = exportor.export(routeAppId, entityNameImp, modelId, qFilters, (Long)pkIds.get(0), entityNameImp);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.downloadFile(url, "bcm_checktmpllist", "1G2FW/G3YIL8");
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\uff01", (String)"CheckTmplListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    private IClientViewProxy getClientViewProxyService() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (!this.validate()) {
            return;
        }
        String nodeId = this.getPageCache().get("focusnodeid");
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            nodeId = "0";
        }
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addgroup": {
                super.doCheckPermission("bcm_checktmpllist", "47156aff000000ac");
                this.newTemplateCatalog(nodeId, true);
                break;
            }
            case "btn_delgroup": {
                super.doCheckPermission("bcm_checktmpllist", "4715e1f1000000ac");
                String modelid = this.getPageCache().get("KEY_MODEL_ID");
                QFilter modelFilter = new QFilter(ctl_model, "=", (Object)LongUtil.toLong((Object)modelid));
                ElimTypeEnum[] checkTypes = ElimTypeEnum.values();
                ArrayList<String> checkTypeNumbers = new ArrayList<String>(10);
                for (ElimTypeEnum checkType : checkTypes) {
                    if ("root".equals(checkType.getNumber())) continue;
                    checkTypeNumbers.add(checkType.getNumber());
                }
                QFilter numberFilter = new QFilter("number", "in", checkTypeNumbers);
                DynamicObjectCollection defaultCatalogObjs = QueryServiceHelper.query((String)"bcm_checktmplcatalog", (String)"id", (QFilter[])new QFilter[]{modelFilter, numberFilter});
                HashSet<String> defaultCatalogIds = new HashSet<String>(16);
                for (DynamicObject id : defaultCatalogObjs) {
                    defaultCatalogIds.add(String.valueOf(id.getLong("id")));
                }
                if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"CheckTmplListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (defaultCatalogIds.contains(nodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7c7b\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"CheckTmplListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u6a21\u677f\u5206\u7c7b\u5c06\u4f1a\u5220\u9664\u8be5\u5206\u7c7b\u4e0b\u6240\u6709\u6a21\u677f\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"CheckTmplListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(deletecatalog_comfirm, (IFormPlugin)this));
                break;
            }
            case "btn_editgroup": {
                super.doCheckPermission("bcm_checktmpllist", "4715a0df000000ac");
                this.newTemplateCatalog(nodeId, false);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!this.validate()) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "treecheckbox": {
                this.refreshBillList(true);
                break;
            }
            case "model": {
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), ctl_model);
                if (modelId == null) {
                    this.getModel().setValue(ctl_model, (Object)this.getPageCache().get("KEY_MODEL_ID"));
                } else {
                    if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                        return;
                    }
                    UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                    this.getPageCache().put("KEY_MODEL_ID", modelId);
                }
                this.getModel().setValue(ctl_scenario, (Object)this.getUserScene(modelId));
                this.refreshTree();
                this.refreshBillList(false);
                break;
            }
            case "scenario": {
                String modelID = this.getPageCache().get("KEY_MODEL_ID");
                String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), ctl_scenario);
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelID, scenarioId);
                this.refreshBillList(false);
                break;
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), ctl_model);
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
        }
        this.getModel().setValue(ctl_model, (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        BasedataEdit scenarioF7 = (BasedataEdit)this.getControl(ctl_scenario);
        scenarioF7.setQFilter(new QFilter(ctl_model, "=", (Object)modelId));
        this.getModel().setValue(ctl_scenario, (Object)this.getUserScene(modelId));
        this.initCheckTmplPerm();
        this.refreshTree();
        this.refreshBillList(false);
    }

    private Long getUserScene(String modelId) {
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        DynamicObject dyn = UserSelectUtil.getUserSelectById(modelId, ctl_scenario, application);
        if (dyn != null && dyn.getLong(ctl_scenario) != 0L) {
            return dyn.getLong(ctl_scenario);
        }
        return null;
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        this.actionEdit();
        evt.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "callbackid_del_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                BillList billList = (BillList)this.getControl(ctl_billlistap);
                HashSet<Object> ids = new HashSet<Object>(10);
                billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
                Map<Object, String> collect = billList.getSelectedRows().stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, ListSelectedRow::getName));
                this.checkTmpl(collect, ids);
                if (ids.isEmpty()) break;
                this.deleteTmpl(ids, null);
                for (int i = 0; i < billList.getSelectedRows().size(); ++i) {
                    ListSelectedRow listSelectedRow = billList.getSelectedRows().get(i);
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "CheckTmplListPlugin_0", "fi-bcm-formplugin", "delete"), new OPDescMultiLangEnumBridge("%1$s %2$s\uff0c\u5220\u9664\u6210\u529f", "CheckTmplListPlugin_43", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{listSelectedRow.getNumber(), listSelectedRow.getName()})));
                }
                this.refreshBillList(true);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CheckTmplListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "deletecatalog_comfirm": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                BillList billList = (BillList)this.getControl(ctl_billlistap);
                HashSet<Object> ids = new HashSet<Object>(16);
                billList.getCurrentListAllRowCollection().forEach(e -> ids.add(e.getPrimaryKeyValue()));
                Map<Object, String> collect = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id,name", (QFilter[])new QFilter("id", "in", ids).toArray()).stream().collect(Collectors.toMap(k -> k.get("id"), v -> v.getString("name")));
                this.checkTmpl(collect, ids);
                if (ids.size() != collect.size()) {
                    return;
                }
                TreeView tree = (TreeView)this.getControl(ctl_templatecatalog);
                Map map = tree.getTreeState().getFocusNode();
                String nodeId = (String)map.get("id");
                DynamicObject catalog = QueryServiceHelper.queryOne((String)"bcm_checktmplcatalog", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)nodeId))});
                this.deleteTmpl(ids, nodeId);
                this.refreshTree();
                this.refreshBillList(true);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CheckTmplListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "CheckTmplListPlugin_0", "fi-bcm-formplugin", "delete"), new OPDescMultiLangEnumBridge("%1$s %2$s\uff0c\u5220\u9664\u6210\u529f", "CheckTmplListPlugin_43", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{catalog.getString("number"), catalog.getString("name")})));
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "bcm_checktmpl": {
                this.refreshBillList(true);
                break;
            }
            case "bcm_checktmplcatalog": {
                JSONArray ids;
                JSONArray jSONArray = ids = evt.getReturnData() == null ? null : new JSONArray((List)evt.getReturnData());
                if (ids == null || ids.size() <= 0) break;
                this.refreshTree();
                String nodeid = ids.get(0).toString();
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
                for (Map m : treeList) {
                    if (!nodeid.equals(m.get("id"))) continue;
                    TreeNode node = new TreeNode((String)m.get("parentid"), (String)m.get("id"), (String)m.get("name"));
                    ((TreeView)this.getControl(ctl_templatecatalog)).focusNode(node);
                    this.getPageCache().put("focusnodeid", nodeid);
                }
                this.refreshBillList(true);
                break;
            }
            case "processClosedCallBack": {
                this.refreshBillList(true);
                break;
            }
            case "CheckTmplImportPlugin": {
                this.refreshBillList(true);
                break;
            }
            case "tmpl_order": {
                boolean isRefresh;
                if (returnData == null || !(isRefresh = ((Boolean)returnData).booleanValue())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"CheckTmplListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.actionRefresh();
                break;
            }
            case "bcm_checktmplmove": {
                if (null != evt.getReturnData()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u6210\u529f\u3002", (String)"CheckTmplListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.refreshBillList(true);
                break;
            }
            case "bcm_checkdiffsetting": {
                if (null != evt.getReturnData()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CheckTmplEditPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.refreshBillList(true);
                break;
            }
        }
    }

    private void actionRefresh() {
        this.refreshBillList(true);
    }

    private void actionEdit() {
        BillList list = (BillList)this.getControl(ctl_billlistap);
        if (!list.getSelectedRows().isEmpty()) {
            DynamicObject dynamicObject = list.getModel().loadReferenceData((DynamicObjectType)list.getEntityType(), list.getFocusRowPkId());
            if (dynamicObject == null || !QueryServiceHelper.exists((String)"bcm_checktmpl", (Object)dynamicObject.getLong("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"CheckTmplListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String id = dynamicObject.get("id").toString();
            String name = dynamicObject.get("name").toString();
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "bcm_checktmpl");
            openParameter.put("pkId", id);
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            String pageId = this.getView().getPageId() + id;
            if (mainPageView == null || mainPageView.getView(pageId) == null) {
                mainPageView = mainPageView == null ? this.getView() : mainPageView;
                FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
                formShowParameter.setPageId(pageId);
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                formShowParameter.setCustomParam("KEY_SCENARIO_ID", (Object)this.getValueId(ctl_scenario));
                formShowParameter.setCustomParam("checkTmplPerm", (Object)this.getAllCheckTmplPermMap().get(dynamicObject.getString("id")));
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f-%s", (String)"CheckTmplListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_checktmpl"));
                if (parentView == null) {
                    this.getView().showForm(formShowParameter);
                    this.getView().sendFormAction(mainPageView);
                } else {
                    parentView.showForm(formShowParameter);
                    this.getView().sendFormAction(parentView);
                }
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    private void actionAddNew() {
        String catelogId = this.getPageCache().get("focusnodeid");
        if (StringUtils.isEmpty((CharSequence)catelogId)) {
            catelogId = "0";
        }
        if (catelogId.equals(this.getPageCache().get("headnodeid")) || catelogId.equals("0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0b\u4e0d\u80fd\u65b0\u589e\u6a21\u677f\u3002", (String)"CheckTmplListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject catalog = new JSONObject();
        catalog.put("id", (Object)catelogId);
        catalog.put("name", (Object)"");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_checktmpl");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        formShowParameter.setCustomParam("KEY_SCENARIO_ID", (Object)this.getValueId(ctl_scenario));
        formShowParameter.setCustomParam("catalog", (Object)catalog.toJSONString());
        formShowParameter.setCustomParam("isNew", (Object)Boolean.TRUE);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f-\u65b0\u589e", (String)"CheckTmplListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_checktmpl"));
        this.getView().showForm(formShowParameter);
    }

    private void actionDelete() {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5bf9\u8d26\u6a21\u677f\u3002", (String)"CheckTmplListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList ids = new ArrayList(10);
        billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (dynamicObjects.size() != ids.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"CheckTmplListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> readOnlyIds = this.getCheckTmplPermByType(KEY_READONLYCHECKTMPL);
        AtomicBoolean containReadOnly = new AtomicBoolean(false);
        if (!this.getAdminUserBol().booleanValue() && !CollectionUtils.isEmpty(readOnlyIds)) {
            ids.forEach(id -> {
                if (readOnlyIds.contains(id)) {
                    containReadOnly.set(true);
                    return;
                }
            });
        }
        if (containReadOnly.get()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6a21\u677f\u5305\u542b\u53ea\u8bfb\u6a21\u677f\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CheckTmplListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long modelId = this.getModelId();
        DynamicObjectCollection assignsTmplColl = QueryServiceHelper.query((String)"bcm_checktmplassignentry", (String)"template", (QFilter[])new QFBuilder().add(ctl_model, "=", (Object)modelId).add("template", "in", ids).toArray());
        ArrayList assignsTmpls = new ArrayList(10);
        if (assignsTmplColl.size() != 0) {
            assignsTmplColl.forEach(e -> assignsTmpls.add(e.getLong("template")));
            DynamicObjectCollection tmplNamesColl = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"name", (QFilter[])new QFBuilder().add(ctl_model, "=", (Object)modelId).add("id", "in", assignsTmpls).toArray());
            StringBuilder tmplnames = new StringBuilder();
            for (DynamicObject name : tmplNamesColl) {
                tmplnames.append(name.get("name")).append(' ');
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5176\u4e2d\u6a21\u677f%s\u5df2\u5206\u914d\uff0c\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"CheckTmplListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tmplnames.toString()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callbackid_del_confirm, (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"CheckTmplListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callbackid_del_confirm, (IFormPlugin)this));
        }
    }

    private void updateCheckTmplEnable(boolean isEnable) {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5bf9\u8d26\u6a21\u677f\u3002", (String)"CheckTmplListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (billList.getSelectedRows().size() >= 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e91000\u4e2a\u4ee5\u5185\u7684\u5bf9\u8d26\u6a21\u677f\u518d\u64cd\u4f5c\u3002", (String)"CheckTmplListPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList ids = new ArrayList(10);
        HashMap datas = new HashMap(16);
        billList.getSelectedRows().forEach(e -> {
            ids.add(e.getPrimaryKeyValue());
            datas.put(e.getPrimaryKeyValue(), e);
        });
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (dynamicObjects.size() != ids.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"CheckTmplListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> readOnlyIds = this.getCheckTmplPermByType(KEY_READONLYCHECKTMPL);
        List<Object> selectReadOnlyIds = new ArrayList(10);
        if (!this.getAdminUserBol().booleanValue() && !CollectionUtils.isEmpty(readOnlyIds)) {
            selectReadOnlyIds = ids.stream().filter(readOnlyIds::contains).collect(Collectors.toList());
        }
        if (selectReadOnlyIds.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6a21\u677f\u5305\u542b\u53ea\u8bfb\u6a21\u677f\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CheckTmplListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder sqlBuilder = new StringBuilder("update t_bcm_checktmpl set fisenable = ? ,fmodifierid = ? ,fmodifytime = ? where fid in (");
        for (Object id : ids) {
            sqlBuilder.append(id).append(',');
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(')');
        DB.update((DBRoute)DBRoute.of((String)"bcm"), (String)sqlBuilder.toString(), (Object[])new Object[]{isEnable, Long.valueOf(RequestContext.get().getUserId()), TimeServiceHelper.now()});
        SaveServiceHelper.clearDataEntityCache((String)"bcm_checktmpl");
        if (isEnable) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CheckTmplListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CheckTmplListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < billList.getSelectedRows().size(); ++i) {
            ListSelectedRow listSelectedRow = billList.getSelectedRows().get(i);
            OpNameMultiLangEnumBridge opName = isEnable ? new OpNameMultiLangEnumBridge("\u542f\u7528", "CheckTmplListPlugin_39", "fi-bcm-formplugin", "enable") : new OpNameMultiLangEnumBridge("\u7981\u7528", "CheckTmplListPlugin_40", "fi-bcm-formplugin", "disable");
            this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("\u8bb0\u5f55%1$s %2$s\uff0c%3$s %4$s", "CheckTmplListPlugin_44", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{listSelectedRow.getNumber(), listSelectedRow.getName(), opName.loadKDString(), CheckTmplListPlugin.getOperationStstusSuccess()})));
        }
        this.refreshBillList(false);
    }

    private void refreshBillList(boolean showMsg) {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        FilterParameter fp = new FilterParameter();
        fp.setOrderBy("sequence asc,id asc");
        if (this.checkParams(showMsg)) {
            QFilter filter = new QFilter(ctl_model, "=", (Object)this.getValueId(ctl_model));
            filter.and("id", "in", (Object)CheckUtil.getApplySceneTmpls((Long)this.getValueId(ctl_model), (Long)this.getValueId(ctl_scenario)));
            fp.setFilter(filter);
        } else {
            fp.setFilter(new QFilter("1", "=", (Object)0));
            billList.clearData();
        }
        billList.setFilterParameter(fp);
        billList.setOrderBy("sequence asc,id asc");
        billList.clearSelection();
        billList.refresh();
    }

    private Long getValueId(String keyName) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(keyName);
        Long res = 0L;
        if (obj != null) {
            res = obj.getLong("id");
        }
        return res;
    }

    private boolean checkParams(boolean showMsg) {
        Object model = this.getModel().getValue(ctl_model);
        if (model == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u4f53\u7cfb\u201d\u3002", (String)"CheckMainPagePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getFilter());
    }

    private QFilter getFilter() {
        String nodeid = this.getPageCache().get("focusnodeid");
        if (nodeid == null) {
            return new QFilter("1", "=", (Object)0);
        }
        boolean isallchild = Boolean.parseBoolean(this.getModel().getValue(ctl_checkbox_tree).toString());
        QFilter qFilter1 = new QFilter(ctl_templatecatalog, "=", (Object)ConvertUtil.convertObjToLong((Object)nodeid));
        QFilter qFilter_scene = new QFilter("id", "in", (Object)CheckUtil.getApplySceneTmpls((Long)this.getValueId(ctl_model), (Long)this.getValueId(ctl_scenario)));
        QFilter qFilter2 = null;
        if (isallchild) {
            List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
            ArrayList<Long> list = new ArrayList<Long>(10);
            this.queryAllChildNodeList(nodeid, treeList, list);
            if (list.size() > 0) {
                qFilter2 = new QFilter(ctl_templatecatalog, "in", list);
            }
        }
        qFilter1 = qFilter2 == null ? qFilter1 : qFilter1.or(qFilter2);
        qFilter1 = qFilter1.and(qFilter_scene);
        List<Long> noPermCheckTmpIds = this.getCheckTmplPermByType(KEY_NOPERMCHECKTMPL);
        if (!this.getAdminUserBol().booleanValue() && !CollectionUtils.isEmpty(noPermCheckTmpIds)) {
            qFilter1 = qFilter1.and("id", "not in", noPermCheckTmpIds);
        }
        return qFilter1;
    }

    private void actionAssign() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_checktmplassign");
        String pageId = null == this.getView().getParentView() ? this.getView().getPageId() : this.getView().getParentView().getPageId();
        param.setRootPageId(pageId);
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getValueId(ctl_model));
        param.setCustomParam("scene", (Object)this.getValueId(ctl_scenario));
        param.setCustomParam("noPermIds", this.getCheckTmplPermByType(KEY_NOPERMCHECKTMPL));
        Object[] rows = this.getSelectTemplate();
        if (rows == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bb0\u5f55\u3002", (String)"CheckTmplListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rows != null && rows.length > 0) {
            param.setCustomParam("rows", (Object)rows);
        }
        param.setCaption(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f-\u5206\u914d", (String)"CheckTmplListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(param);
    }

    private Object[] getSelectTemplate() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() > 0) {
            return rows.getPrimaryKeyValues();
        }
        return null;
    }

    private void refreshTree() {
        TreeView tree = (TreeView)this.getControl(ctl_templatecatalog);
        tree.deleteAllNodes();
        this.initTree();
    }

    private void initTree() {
        TreeNode templatecatalog = new TreeNode();
        String algoKey = this.getClass().getName();
        String modelID = this.getPageCache().get("KEY_MODEL_ID");
        String entityName = "bcm_checktmplcatalog";
        String selectFields = "id,name,number,parent";
        QFilter fmodelid = new QFilter(ctl_model, "=", (Object)ConvertUtil.convertObjToLong((Object)modelID));
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "id";
        String headid = "";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        if (dcs == null || dcs.size() <= 0) {
            CheckTmplCatalogServiceHelper.setDefaultRootNode((long)LongUtil.toLong((Object)modelID), (long)-1L);
            dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        }
        ArrayList treeList = new ArrayList(10);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", (String)task.get("number"));
                memberMap.put("name", (String)task.get("name"));
                memberMap.put("parentid", task.get("parent").toString());
                treeList.add(memberMap);
                if (!"0".equals(task.get("parent").toString())) continue;
                headid = task.get("id").toString();
                templatecatalog.setId(headid);
                this.getPageCache().put("focusnodeid", headid);
                this.getPageCache().put("headnodeid", headid);
            }
        }
        templatecatalog.setParentid("");
        templatecatalog.setText(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f", (String)"CheckTmplListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNode((TreeNode)templatecatalog, treeList, (String)headid);
        BCMTreeUtils.spreadAllNode((TreeNode)templatecatalog);
        TreeView tree = (TreeView)this.getControl(ctl_templatecatalog);
        tree.addNode(templatecatalog);
        tree.focusNode(templatecatalog);
    }

    private void newTemplateCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(ctl_model, this.getPageCache().get("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_checktmplcatalog");
        if (nodeId == null || "".equals(nodeId)) {
            nodeId = "0";
        }
        if (isAddNew) {
            if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u65b0\u589e\u6a21\u677f\u7c7b\u578b\u3002", (String)"CheckTmplListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            long id = Long.parseLong(nodeId);
            params.put("parent", id);
            params.put("type", "add");
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_checktmplcatalog", (String)"process", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            params.put("process", dyn.getLong("process"));
            this.showForm("bcm_checktmplcatalog", params, closeCallBack, ShowType.Modal, 0L);
        } else if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u4fee\u6539\u3002", (String)"CheckTmplListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            long id = Long.parseLong(nodeId);
            this.showForm("bcm_checktmplcatalog", params, closeCallBack, ShowType.Modal, id);
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private List<Long> queryAllChildNodeList(String nodeid, List<Map<String, String>> treeList, List<Long> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (!m.get("parentid").equals(nodeid)) continue;
            allnodelist.add(Long.valueOf(m.get("id")));
            this.queryAllChildNodeList(m.get("id"), treeList, allnodelist);
        }
        return allnodelist;
    }

    @Override
    public long getModelId() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            String string = modelId = this.getFormCustomParam("KEY_MODEL_ID") == null ? "" : this.getFormCustomParam("KEY_MODEL_ID").toString();
        }
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return 0L;
        }
        return Long.parseLong(modelId);
    }

    private boolean validate() {
        String modulid = this.getPageCache().get("KEY_MODEL_ID");
        return !StringUtils.isEmpty((CharSequence)modulid);
    }

    private String getCheckConfigName(String checkconfig) {
        String[] config = checkconfig.split(",");
        DynamicObjectCollection userDefines = this.getUserDefineDims();
        HashMap<String, String> userdefined = new HashMap<String, String>(16);
        for (DynamicObject dim : userDefines) {
            if (dim.getBoolean("issysdimension")) continue;
            userdefined.put(dim.getString("fieldmapped"), dim.getString("name"));
        }
        StringBuffer sb = new StringBuffer();
        for (String c : config) {
            int cc;
            if ("".equals(c) || (cc = Integer.parseInt(String.valueOf(c))) == 0 || cc == 8 || cc == 9) continue;
            if (cc > 0 && cc < 7) {
                sb.append((String)userdefined.get("dim" + c)).append('\uff0c');
                continue;
            }
            if (cc != 7) continue;
            sb.append(ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22", (String)"CheckTmplListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append('\uff0c');
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb.toString();
    }

    private DynamicObjectCollection getUserDefineDims() {
        String uddStr = this.getPageCache().get("UserDefineDims_" + this.getModelId());
        if (StringUtils.isNotBlank((CharSequence)uddStr)) {
            return (DynamicObjectCollection)ObjectSerialUtil.deSerializedBytes((String)uddStr);
        }
        String selectFields = "id,name,number,issysdimension,fieldmapped";
        QFilter[] qfilter = new QFilter[]{new QFilter(ctl_model, "=", (Object)this.getModelId())};
        DynamicObjectCollection userDefines = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])qfilter, (String)"dseq");
        this.getPageCache().put("UserDefineDims_" + this.getModelId(), ObjectSerialUtil.toByteSerialized((Object)userDefines));
        return userDefines;
    }

    private void checkTmpl(Map collect, Set<Object> ids) {
        QFilter qFilter = new QFilter("checktmpl", "in", ids.stream().map(p -> Long.valueOf(p.toString())).collect(Collectors.toSet()));
        DynamicObjectCollection checktmpl = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"checktmpl", (QFilter[])qFilter.toArray());
        Set<Object> checktmpl1 = checktmpl.stream().collect(Collectors.groupingBy(dy -> dy.get("checktmpl"))).keySet();
        ArrayList list = new ArrayList(10);
        checktmpl1.stream().filter(p -> ids.contains(p)).forEach(p -> list.add((String)collect.get(p)));
        ids.removeIf(e -> checktmpl1.contains(e));
        if (null != list && list.size() != 0) {
            String notification = list.size() <= 5 ? Joiner.on((String)",").join(list) : Joiner.on((String)",").join(list.subList(0, 5)) + "......";
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s \u6a21\u677f\u5df2\u7ecf\u751f\u6210\u5bf9\u8d26\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CheckTmplListPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), notification));
        }
    }

    private void deleteTmpl(Set<Object> ids, String nodeId) {
        try (TXHandle tx = TX.required();){
            try {
                Set collect = ids.stream().map(p -> Long.valueOf(p.toString())).collect(Collectors.toSet());
                QFilter tmplate = new QFilter(ctl_model, "in", (Object)this.getModelId());
                tmplate.and("template", "in", collect);
                BusinessDataWriter.delete((String)"bcm_checktmplassignentry", (QFilter[])new QFilter[]{tmplate});
                QFilter filter = new QFilter("id", "in", collect);
                BusinessDataWriter.delete((String)"bcm_checktmpl", (QFilter[])new QFilter[]{filter});
                if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
                    QFilter nodeFilter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)nodeId));
                    BusinessDataWriter.delete((String)"bcm_checktmplcatalog", (QFilter[])new QFilter[]{nodeFilter});
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new RuntimeException(e);
            }
        }
        SaveServiceHelper.clearDataEntityCache((String)"bcm_checktmpl");
    }

    private void initCheckTmplPerm() {
        Boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        this.getPageCache().put(KEY_ADMINUSERBOL, adminUserBol.toString());
        if (!adminUserBol.booleanValue()) {
            ArrayListMultimap checkTmplPermMap = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_checktmpl", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId());
            HashMap allCheckTmplPermMap = new HashMap();
            for (String key : checkTmplPermMap.keySet()) {
                List ids = checkTmplPermMap.get((Object)key);
                ids.forEach(id -> allCheckTmplPermMap.put(id.toString(), key));
            }
            this.getPageCache().put(KEY_ALLCHECKTMPLPERMMAP, SerializationUtils.toJsonString(allCheckTmplPermMap));
            this.getPageCache().put(KEY_NOPERMCHECKTMPL, SerializationUtils.toJsonString(checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()) == null ? new ArrayList() : checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue())));
            this.getPageCache().put(KEY_READONLYCHECKTMPL, SerializationUtils.toJsonString(checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue()) == null ? new ArrayList() : checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue())));
            this.getPageCache().put(KEY_READWRITEHECKTMPL, SerializationUtils.toJsonString(checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READWRITE.getValue()) == null ? new ArrayList() : checkTmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READWRITE.getValue())));
        }
    }

    private Boolean getAdminUserBol() {
        return Boolean.parseBoolean(this.getPageCache().get(KEY_ADMINUSERBOL));
    }

    private List<Long> getCheckTmplPermByType(String key) {
        ArrayList<Long> result = new ArrayList<Long>();
        String s = this.getPageCache().get(key);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            List o = (List)SerializationUtils.fromJsonString((String)s, List.class);
            o.forEach(e -> result.add(LongUtil.toLong((Object)e)));
        }
        return result;
    }

    private Map<String, String> getAllCheckTmplPermMap() {
        String s = this.getPageCache().get(KEY_ALLCHECKTMPLPERMMAP);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return (Map)SerializationUtils.fromJsonString((String)s, Map.class);
        }
        return new HashMap<String, String>();
    }

    protected void movetemplate() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bf9\u8d26\u6a21\u677f\u3002", (String)"CheckTmplListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List collect = selectedRows.stream().map(p -> LongUtil.toLong((Object)p.getPrimaryKeyValue())).collect(Collectors.toList());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
        if (dynamicObjects.size() != collect.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"CheckTmplListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_checktmplmove");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        showParameter.setCustomParam("tmplIds", collect);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_checktmplmove");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }
}

