/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class CheckTmplMove
extends AbstractBaseListPlugin {
    private static final String ctl_templatecatalog = "templatecatalog";
    private static final String btn_add = "bar_add";
    private static final String NUMBER = "number";
    private static final String NAME = "name";

    @Override
    public void initialize() {
        super.initialize();
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>(16);
        map.put("scenario", SingleF7TypeEnum.LEAF);
        super.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_add);
        TreeView treeView = (TreeView)this.getControl(ctl_templatecatalog);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                CheckTmplMove.this.getPageCache().put("focusnodeid", evt.getNodeId().toString());
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.refreshTree();
    }

    private void refreshTree() {
        TreeView tree = (TreeView)this.getControl(ctl_templatecatalog);
        tree.deleteAllNodes();
        this.initTree();
    }

    private void initTree() {
        TreeNode templatecatalog = new TreeNode();
        String algoKey = this.getClass().getName();
        Long modelID = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String entityName = "bcm_checktmplcatalog";
        String selectFields = "id,name,number,parent";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelID);
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "id";
        String headid = "";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        ArrayList treeList = new ArrayList(10);
        for (DynamicObject task : dcs) {
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            memberMap.put("id", task.get("id").toString());
            memberMap.put(NUMBER, (String)task.get(NUMBER));
            memberMap.put(NAME, (String)task.get(NAME));
            memberMap.put("parentid", task.get("parent").toString());
            treeList.add(memberMap);
            if (!"0".equals(task.get("parent").toString())) continue;
            headid = task.get("id").toString();
            templatecatalog.setId(headid);
        }
        templatecatalog.setParentid("");
        templatecatalog.setText(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f", (String)"CheckTmplMove_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        BCMTreeUtils.setEntryNode((TreeNode)templatecatalog, treeList, (String)headid);
        BCMTreeUtils.spreadAllNode((TreeNode)templatecatalog);
        TreeView tree = (TreeView)this.getControl(ctl_templatecatalog);
        tree.addNode(templatecatalog);
        tree.focusNode(templatecatalog);
    }

    @Override
    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "bar_add": {
                this.moveTemplate();
                break;
            }
        }
    }

    private void moveTemplate() {
        String nodeId = this.getPageCache().get("focusnodeid");
        DynamicObject dcs = QueryServiceHelper.queryOne((String)"bcm_checktmplcatalog", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)nodeId)).toArray());
        if (dcs == null || "root".equals(dcs.getString(NUMBER))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"CheckTmplMove_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List tmplIds = (List)this.getView().getFormShowParameter().getCustomParam("tmplIds");
        DynamicObject[] billList = BusinessDataServiceHelper.load((Object[])tmplIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_checktmpl"));
        String fromTemplateName = "";
        if (billList.length > 0) {
            fromTemplateName = billList[0].getLocaleString("templatecatalog.name").getLocaleValue();
        }
        Arrays.stream(billList).forEach(dn -> dn.set(ctl_templatecatalog, (Object)LongUtil.toLong((Object)nodeId)));
        Object[] save = SaveServiceHelper.save((DynamicObject[])billList);
        int length = 0;
        if (save != null && save.length > 0) {
            length = save.length;
            String toTemplateName = dcs.getString(NAME);
            String fromTemplateNameCopy = fromTemplateName;
            Arrays.stream(billList).forEach(dn -> {
                String name = dn.getString(NAME);
                String number = dn.getString(NUMBER);
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.MOVE.getMultiLangEnumBridge(), (String)"move"), new OPDescMultiLangEnumBridge("%1$s %2$s \u4ece%3$s\u79fb\u52a8\u5230%4$s,%5$s", "CheckTmplMove_2", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number, name, fromTemplateNameCopy, toTemplateName, ResultStatusEnum.SUCCESS.getName()})));
            });
        }
        this.getView().returnDataToParent((Object)length);
        this.getView().close();
    }
}

