/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.check.sum;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.CheckResult;
import kd.fi.bcm.business.check.helper.CheckServiceHelper;
import kd.fi.bcm.business.check.sum.CheckSumHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CheckLayoutEnum;
import kd.fi.bcm.common.enums.CheckStatusEnum;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.check.CheckSumStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.check.CheckHelper;
import kd.fi.bcm.formplugin.check.sum.CheckReportColumn;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import org.apache.commons.collections.CollectionUtils;

public class CheckSumReportPlugin
extends SpreadBasePlugin
implements ISpreadModelSupplier {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(CheckSumReportPlugin.class);
    protected static final String SPREAD_KEY = "report";
    public static final String CHECK_SM_CACHE_KEY = "check_spreadManager";
    public static final int INIT_ROW_COUNT = 50;
    private static final Map<String, Object> CENTER_STYLE_MAP = ImmutableMap.of((Object)SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), (Object)1, (Object)SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), (Object)1);
    public static final String SELECT_FIELDS = "id,model,createtime,modifytime,modifier.name,status,scene,creator,checktmpl,checktmpl.number,year,period,process,cvtdifmoney,currency,oppositeentity,oppositeentity.number,myentity,myentity.number,mycvtmoney,opcvtmoney,myelimmoney,opelimmoney,isautoelim,createtype,mark,entity,entity.longnumber,number, entryentity.ismydata, entryentity.checktmplentry, entryentity.entrycvtmoney, entryentity.entryelimmoney, entryentity.isdiffitem,entryentity.seq";
    public static final int INIT_COL_COUNT = 20;
    private static final String KEY_YEAR_ID = "KEY_YEAR_ID";
    private static final String KEY_PERIOD_ID = "KEY_PERIOD_ID";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SpreadManager currentManager = null;

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", modelId + "");
        this.getPageCache().put("checkScale", ConfigServiceHelper.getStringParam((Long)this.getModelId(), (String)"checkScale"));
        this.setBtnVisible(modelId);
        this.refreshSumData();
    }

    private void setBtnVisible(Long modelId) {
        BarItemAp barItemAp = new BarItemAp();
        barItemAp.setKey("btn_aobo8");
        barItemAp.setId("btn_aobo8");
        barItemAp.setName(new LocaleString(DiffModeEnum.DIRECT.getName()));
        barItemAp.setOperationStyle(Integer.valueOf(1));
        CheckHelper.initDiffButton(modelId, this.getView(), barItemAp, false, 1);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.startsWith("btn_aobo")) {
            Pair<DiffModeEnum, DiffMethodEnum> diffPair = CheckHelper.getDiffPairByBinSign(key);
            this.doAudit(diffPair);
            return;
        }
        switch (key) {
            case "btn_refreshsum": {
                this.refreshSumData();
                break;
            }
            case "btn_refresh": {
                this.refreshSpread(true);
                break;
            }
            case "btn_checkdetail": {
                this.openCheckDetail();
                break;
            }
            case "btn_unaudit": {
                this.doAudit(null);
                break;
            }
        }
    }

    private void doAudit(Pair<DiffModeEnum, DiffMethodEnum> diffPair) {
        String action;
        CheckParam checkParam = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
        CheckHelper.isExistArchiving(this.getModelId(), (String)checkParam.getScene().p2, (String)checkParam.getYear().p2, (String)checkParam.getPeriod().p2);
        Map<Long, String> idAutoelimMap = this.getSelectedRows();
        if (idAutoelimMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u884c\u7684\u5355\u5143\u683c\u3002", (String)"CheckSumReportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        CheckResult checkResult = diffPair == null ? CheckSumHelper.unAudit(idAutoelimMap.keySet(), (CheckParam)checkParam) : CheckSumHelper.doAudit(idAutoelimMap.keySet(), (CheckParam)checkParam, diffPair);
        String string = action = diffPair == null ? ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"CheckSumReportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u786e\u8ba4", (String)"CheckSumReportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (!checkResult.getSuccess()) {
            this.getView().showErrorNotification(checkResult.getMessage());
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6c47\u603b\u62a5\u544a", "CheckSumReportPlugin_29", "fi-bcm-formplugin", "sumCheckReport"), new OPDescMultiLangEnumBridge("%1$s\u5931\u8d25", "CheckSumReportPlugin_33", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{action})));
            return;
        }
        if (checkResult.getData() != null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210", (String)"CheckSumReportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), checkResult.getData().toString(), MessageTypes.Default);
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6c47\u603b\u62a5\u544a", "CheckSumReportPlugin_29", "fi-bcm-formplugin", "sumCheckReport"), new OPDescMultiLangEnumBridge("%1$s\u6210\u529f", "CheckSumReportPlugin_34", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{action})));
        this.refreshSpread(true);
    }

    private void refreshSumData() {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (String)"CheckSumReportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        CheckParam checkParam = (CheckParam)this.deSerializedBytes((String)this.getFormCustomParam("checkParam"));
        try {
            CheckServiceHelper.sumCheckRecord((CheckParam)checkParam);
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6c47\u603b\u6570\u636e", "CheckSumReportPlugin_25", "fi-bcm-formplugin", "sumData"), new OPDescMultiLangEnumBridge("%1$s\u4e2a\u5408\u5e76\u8282\u70b9\u6c47\u603b\u6570\u636e\u6210\u529f", "CheckSumReportPlugin_26", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{checkParam.getMergeEntityIds().size() + ""})));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6c47\u603b\u6570\u636e\u6267\u884c\u6210\u529f\u3002", (String)"CheckSumReportPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            this.getView().hideLoading();
            logger.error(ThrowableHelper.toString((Exception)e));
        }
        this.refreshSpread(false);
    }

    private void refreshSpread(boolean isShowLoading) {
        String checkParamStr;
        if (isShowLoading) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (String)"CheckSumReportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        }
        if (StringUtil.isEmptyString((String)(checkParamStr = (String)this.getView().getFormShowParameter().getCustomParam("checkParam")))) {
            return;
        }
        CheckParam param = (CheckParam)ObjectSerialUtil.deSerializedBytes((String)checkParamStr);
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), this.getSpreadKey(), AdjustModelUtil.getEmptyJson(50, 20));
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), this.getSpreadKey());
        this.currentManager = new SpreadManager("check_report_sum", null);
        Sheet sheet = this.getEffectiveSheet();
        sheet.clear();
        this.buildSpreadAndData(param);
        this.cacheSpreadModel(this.getSpreadModel());
        this.getView().hideLoading();
    }

    private void buildSpreadAndData(CheckParam param) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        Sheet sheet = this.getEffectiveSheet();
        CheckLayoutEnum checkLayout = CheckHelper.getCheckLayout(this.getModelId());
        List<CheckReportColumn> headerColumns = this.getHeaderColumn(checkLayout);
        this.buildHeader(headerColumns, sheet, invoker);
        this.bulidData(headerColumns, param, checkLayout, sheet, invoker);
        SearchHelper.lockOrUnlockCell(this.getClientViewProxy(), this.getSpreadKey(), true, 0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount());
        invoker.setStyle(0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount(), CENTER_STYLE_MAP);
        CheckHelper.setSpreadBorder(0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount(), invoker);
        this.formatValue(headerColumns.stream().filter(CheckReportColumn::isDigital).map(CheckReportColumn::getIndex).collect(Collectors.toList()), sheet, invoker);
        invoker.startToInvoke();
    }

    private void bulidData(List<CheckReportColumn> headerColumns, CheckParam param, CheckLayoutEnum checkLayout, Sheet sheet, SpreadEasyInvoker invoker) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", param.getModel().p1);
        builder.add("scene", "=", param.getScene().p1);
        builder.add("year", "=", param.getYear().p1);
        builder.add("period", "=", param.getPeriod().p1);
        builder.add("entity.number", "in", (Object)MemberReader.change2MemberNumsById((long)((Long)param.getModel().p1), (String)"bcm_entitymembertree", (List)param.getMergeEntityIds()));
        builder.add("entity.cslscheme", "=", (Object)param.getCslschemeId());
        builder.add("checktmpl", "in", param.getCheckTmpl().p1);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_checkrecordsum", (String)SELECT_FIELDS, (QFilter[])builder.toArray(), (String)"checktmpl.number asc,entity.longnumber asc, myentity.number asc, oppositeentity.number asc, status asc, isautoelim asc");
        if (doc == null || doc.size() <= 0) {
            return;
        }
        Map<String, CheckReportColumn> colMap = headerColumns.stream().collect(Collectors.toMap(CheckReportColumn::getNumber, e -> e, (e1, e2) -> e1));
        String showStyle = this.getShowStyle();
        Set checktmplIds = doc.stream().map(e -> e.getLong("checktmpl")).collect(Collectors.toSet());
        QFBuilder tmpBuilder = new QFBuilder();
        tmpBuilder.add("model", "=", param.getModel().p1);
        tmpBuilder.add("id", "in", checktmplIds);
        tmpBuilder.add("entryentity.detailscope.sign", "in", (Object)"accounttree");
        DynamicObjectCollection tmpDocs = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id,number,name,entryentity.id,entryentity.detailscope.memberid,entryentity.detailscope.scope", (QFilter[])tmpBuilder.toArray(), (String)"entryentity.seq asc,entryentity.detailscope.seq asc");
        HashMap<Long, Pair<String, String>> tmplMap = new HashMap<Long, Pair<String, String>>(16);
        HashMap<Long, List<Pair<Long, Integer>>> entryAccountMap = new HashMap<Long, List<Pair<Long, Integer>>>(16);
        HashMap<Long, Integer> tmplEntryIndexMap = new HashMap<Long, Integer>(16);
        for (int i = 0; i < tmpDocs.size(); ++i) {
            DynamicObject tmp = (DynamicObject)tmpDocs.get(i);
            tmplMap.put(tmp.getLong("id"), Pair.onePair((Object)tmp.getString("number"), (Object)tmp.getString("name")));
            Long entryId = tmp.getLong("entryentity.id");
            tmplEntryIndexMap.put(entryId, i);
            List accounts = entryAccountMap.computeIfAbsent(entryId, k -> new ArrayList(16));
            accounts.add(Pair.onePair((Object)tmp.getLong("entryentity.detailscope.memberid"), (Object)tmp.getInt("entryentity.detailscope.scope")));
        }
        int rowCount = 1;
        Set bigSpans = headerColumns.stream().filter(e -> e.getMergeType() == 2).map(CheckReportColumn::getIndex).collect(Collectors.toSet());
        Set smallSpans = headerColumns.stream().filter(e -> e.getMergeType() == 1).map(CheckReportColumn::getIndex).collect(Collectors.toSet());
        Map groupMap = doc.stream().collect(Collectors.groupingBy(e -> e.getLong("id"), LinkedHashMap::new, Collectors.toList()));
        int allCount = this.getAllRowCount(groupMap, checkLayout);
        if (allCount > 50) {
            SpreadClientInvoker.appendRows(this.getClientViewProxy(), this.getSpreadKey(), 50, allCount - 50);
        }
        ArrayList<Map<String, Object>> hyperLinkRangeList = new ArrayList<Map<String, Object>>(16);
        for (Map.Entry kv : groupMap.entrySet()) {
            int gourpStartIndex = rowCount;
            List allDoc = (List)kv.getValue();
            if (CollectionUtils.isEmpty((Collection)allDoc)) continue;
            int mergeRowSize = allDoc.size();
            DynamicObject header = (DynamicObject)allDoc.get(0);
            Map<Boolean, List<DynamicObject>> myoppoMap = allDoc.stream().collect(Collectors.groupingBy(e -> e.getBoolean("entryentity.ismydata")));
            List<DynamicObject> myDocs = this.sortByTmplEntry(myoppoMap.getOrDefault(true, new ArrayList(16)), tmplEntryIndexMap);
            List<DynamicObject> oppoDocs = this.sortByTmplEntry(myoppoMap.getOrDefault(false, new ArrayList(16)), tmplEntryIndexMap);
            if (CheckLayoutEnum.USING == checkLayout) {
                int groupMaxSize;
                mergeRowSize = groupMaxSize = Math.max(myDocs.size(), oppoDocs.size());
                for (int i = 0; i < groupMaxSize; ++i) {
                    this.setRowData(header, this.getDoc(myDocs, i), this.getDoc(oppoDocs, i), headerColumns, tmplMap, entryAccountMap, sheet, invoker, rowCount, showStyle, i == 0);
                    ++rowCount;
                }
            } else {
                Iterator colIndex2;
                boolean isGroupFirstRow = true;
                int mystart = rowCount;
                for (DynamicObject myDoc : myDocs) {
                    this.setRowData(header, myDoc, null, headerColumns, tmplMap, entryAccountMap, sheet, invoker, rowCount, showStyle, isGroupFirstRow);
                    isGroupFirstRow = false;
                    ++rowCount;
                }
                for (Iterator colIndex2 : smallSpans) {
                    invoker.setSpan(mystart, (Integer)((Object)colIndex2), myDocs.size(), 1);
                }
                int oppostart = rowCount;
                for (DynamicObject oppoDoc : oppoDocs) {
                    this.setRowData(header, null, oppoDoc, headerColumns, tmplMap, entryAccountMap, sheet, invoker, rowCount, showStyle, isGroupFirstRow);
                    isGroupFirstRow = false;
                    ++rowCount;
                }
                colIndex2 = smallSpans.iterator();
                while (colIndex2.hasNext()) {
                    Integer colIndex3 = (Integer)colIndex2.next();
                    invoker.setSpan(oppostart, colIndex3, oppoDocs.size(), 1);
                }
            }
            this.addToRangMap(hyperLinkRangeList, gourpStartIndex, 0, mergeRowSize, 1);
            for (Integer colIndex : bigSpans) {
                invoker.setSpan(gourpStartIndex, colIndex, mergeRowSize, 1);
            }
            BigDecimal mycvtmoney = header.getBigDecimal("mycvtmoney");
            BigDecimal myelimmoney = header.getBigDecimal("myelimmoney");
            BigDecimal opcvtmoney = header.getBigDecimal("opcvtmoney");
            BigDecimal oppoelimmoney = header.getBigDecimal("opelimmoney");
            BigDecimal cvtdifmoney = header.getBigDecimal("cvtdifmoney");
            Integer cvtdifmoneyIndex = colMap.get("cvtdifmoney").getIndex();
            if (CheckLayoutEnum.USING == checkLayout) {
                Integer mycvtmoneyIndex = colMap.get("mycvtmoney").getIndex();
                Integer myelimmoneyIndex = colMap.get("myelimmoney").getIndex();
                Integer opcvtmoneyIndex = colMap.get("oppocvtmoney").getIndex();
                Integer oppoelimmoneyIndex = colMap.get("oppoelimmoney").getIndex();
                invoker.updataValue(rowCount, mycvtmoneyIndex, mycvtmoney);
                sheet.getCell(rowCount, mycvtmoneyIndex.intValue()).setValue((Object)mycvtmoney);
                invoker.updataValue(rowCount, myelimmoneyIndex, myelimmoney);
                sheet.getCell(rowCount, myelimmoneyIndex.intValue()).setValue((Object)myelimmoney);
                invoker.updataValue(rowCount, opcvtmoneyIndex, opcvtmoney);
                sheet.getCell(rowCount, opcvtmoneyIndex.intValue()).setValue((Object)opcvtmoney);
                invoker.updataValue(rowCount, oppoelimmoneyIndex, oppoelimmoney);
                sheet.getCell(rowCount, oppoelimmoneyIndex.intValue()).setValue((Object)oppoelimmoney);
                invoker.updataValue(rowCount, cvtdifmoneyIndex, cvtdifmoney);
                sheet.getCell(rowCount, cvtdifmoneyIndex.intValue()).setValue((Object)cvtdifmoney);
            } else {
                Integer entrycvtmoneyIndex = colMap.get("entrycvtmoney").getIndex();
                Integer entryelimmoneyIndex = colMap.get("entryelimmoney").getIndex();
                BigDecimal cvtsum = this.addBigDecimal(mycvtmoney, opcvtmoney);
                BigDecimal elimsum = this.addBigDecimal(myelimmoney, oppoelimmoney);
                invoker.updataValue(rowCount, entrycvtmoneyIndex, cvtsum);
                sheet.getCell(rowCount, entrycvtmoneyIndex.intValue()).setValue((Object)cvtsum);
                invoker.updataValue(rowCount, entryelimmoneyIndex, elimsum);
                sheet.getCell(rowCount, entryelimmoneyIndex.intValue()).setValue((Object)elimsum);
                invoker.updataValue(rowCount, cvtdifmoneyIndex, cvtdifmoney);
                sheet.getCell(rowCount, cvtdifmoneyIndex.intValue()).setValue((Object)cvtdifmoney);
            }
            String sumStr = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CheckSumReportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            invoker.updataValue(rowCount, 0, sumStr);
            sheet.getCell(rowCount, 0).setValue((Object)sumStr);
            invoker.setStyle(rowCount, 0, 1, headerColumns.size(), CheckHelper.getColorStyleMap("3"));
            invoker.setSpan(rowCount, 0, 1, 3);
            ++rowCount;
        }
        invoker.setHyperLinkCellSimple(hyperLinkRangeList, "openCheckDetail");
        this.setSpreadFilter(1, 0, rowCount - 1, headerColumns.size());
    }

    private int getAllRowCount(Map<Long, List<DynamicObject>> groupMap, CheckLayoutEnum checkLayout) {
        int allCount = 1;
        int groupCount = 0;
        for (Map.Entry<Long, List<DynamicObject>> kv : groupMap.entrySet()) {
            List<DynamicObject> allDocs = kv.getValue();
            if (CheckLayoutEnum.USING == checkLayout) {
                Map<Boolean, List<DynamicObject>> myoppoMap = allDocs.stream().collect(Collectors.groupingBy(e -> e.getBoolean("entryentity.ismydata")));
                List myDocs = myoppoMap.getOrDefault(true, new ArrayList(16));
                List oppoDocs = myoppoMap.getOrDefault(false, new ArrayList(16));
                groupCount = Math.max(myDocs.size(), oppoDocs.size());
            } else {
                groupCount = allDocs.size();
            }
            allCount += groupCount;
        }
        allCount = allCount + groupMap.size() + 5;
        return allCount;
    }

    private Map<Long, String> getSelectedRows() {
        HashMap<Long, String> idAutoelimMap;
        block5: {
            SpreadSelector selector;
            Sheet sheet;
            block4: {
                idAutoelimMap = new HashMap<Long, String>(16);
                sheet = this.getEffectiveSheet();
                selector = this.getSpreadSelector();
                if (selector.getSelections() == null) break block4;
                for (Map selection : selector.getSelections()) {
                    Integer row = (Integer)selection.get("row");
                    Integer rowCount = (Integer)selection.get("rowCount");
                    Integer i = 0;
                    while (i < rowCount) {
                        Object autoElim = sheet.getCell(row + i, 0).getUserObject("isautoelim");
                        Object id = sheet.getCell(row + i, 0).getUserObject("id");
                        if (autoElim != null && id != null) {
                            idAutoelimMap.put(LongUtil.toLong((Object)id), autoElim.toString());
                        }
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                }
                break block5;
            }
            String rangePosition = selector.getRangePosition();
            if (!StringUtils.isNotEmpty((String)rangePosition)) break block5;
            RangeModel range = SpreadAreaUtil.getRangModel((String)rangePosition);
            for (int i = range.getY_start(); i <= range.getY_end(); ++i) {
                Object autoElim = sheet.getCell(i, 0).getUserObject("isautoelim");
                Object id = sheet.getCell(i, 0).getUserObject("id");
                if (autoElim == null || id == null) continue;
                idAutoelimMap.put(LongUtil.toLong((Object)id), autoElim.toString());
            }
        }
        return idAutoelimMap;
    }

    public void openCheckDetail() {
        DynamicObjectCollection checkRecords;
        Map<Long, String> idAutoelimMap = this.getSelectedRows();
        if (idAutoelimMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u884c\u7684\u5355\u5143\u683c\u3002", (String)"CheckSumReportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_checkrecord_link", (String)"id,checkrecordsum,checkrecord", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("checkrecordsum", "in", idAutoelimMap.keySet())});
        if (docs.size() <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5bf9\u8d26\u8bb0\u5f55\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u67e5\u770b\u660e\u7ec6\u5bf9\u8d26\u62a5\u544a\u3002", (String)"CheckSumReportPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> autoManualTypes = new HashSet<Long>(16);
        HashSet<Long> sumTypes = new HashSet<Long>(16);
        for (DynamicObject doc : docs) {
            long sumId = doc.getLong("checkrecordsum");
            long recordId = doc.getLong("checkrecord");
            String autoelimeType = idAutoelimMap.get(sumId);
            if (CheckSumStatusEnum.AUTO.getValue().equals(autoelimeType) || CheckSumStatusEnum.MANUAL.getValue().equals(autoelimeType)) {
                autoManualTypes.add(recordId);
            }
            if (!CheckSumStatusEnum.SUM.getValue().equals(autoelimeType)) continue;
            sumTypes.add(recordId);
        }
        if (CollectionUtils.isNotEmpty(autoManualTypes)) {
            checkRecords = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("id", "in", autoManualTypes)});
            if (autoManualTypes.size() != checkRecords.size()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5bf9\u8d26\u8bb0\u5f55\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u6c47\u603b\u6570\u636e\u3002", (String)"CheckSumReportPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (CollectionUtils.isNotEmpty(sumTypes) && ((checkRecords = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("id", "in", sumTypes)})) == null || checkRecords.size() <= 0)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5bf9\u8d26\u8bb0\u5f55\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u6c47\u603b\u6570\u636e\u3002", (String)"CheckSumReportPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set checkRecordIds = docs.stream().map(e -> e.getLong("checkrecord")).collect(Collectors.toSet());
        String obId = checkRecordIds.stream().map(Object::toString).collect(Collectors.joining("_"));
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = this.getView().getPageId() + "_" + this.getBizAppId() + "_" + this.getUserId() + "_" + obId.hashCode();
        if (mainPageView == null || mainPageView.getView(pageId) == null || parentView == null) {
            mainPageView = mainPageView == null ? this.getView() : mainPageView;
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bcm_checkdetail");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCustomParam("id", checkRecordIds);
            param.setPageId(pageId);
            param.getOpenStyle().setTargetKey("_submaintab_");
            param.setCustomParam("model", (Object)this.getModelId());
            param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            param.setCustomParam("createtype", this.getView().getFormShowParameter().getCustomParam("createtype"));
            param.setCustomParam("KEY_ISROOT", this.getView().getFormShowParameter().getCustomParam("KEY_ISROOT"));
            param.setCustomParam("cslschemeId", this.getView().getFormShowParameter().getCustomParam("cslschemeId"));
            param.setCustomParam("KEY_SCENARIO_ID", this.getView().getFormShowParameter().getCustomParam("KEY_SCENARIO_ID"));
            param.setCustomParam(KEY_YEAR_ID, this.getView().getFormShowParameter().getCustomParam(KEY_YEAR_ID));
            param.setCustomParam(KEY_PERIOD_ID, this.getView().getFormShowParameter().getCustomParam(KEY_PERIOD_ID));
            param.setCustomParam("checkParam", this.getView().getFormShowParameter().getCustomParam("checkParam"));
            param.setCustomParam("showstyle", this.getView().getFormShowParameter().getCustomParam("showstyle"));
            param.setCustomParam("fromPage", (Object)"sum_page");
            if (parentView == null) {
                this.getView().showForm(param);
                this.getView().sendFormAction(mainPageView);
            } else {
                parentView.showForm(param);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private BigDecimal addBigDecimal(BigDecimal a, BigDecimal b) {
        if (a == null) {
            a = BigDecimal.ZERO;
        }
        if (b == null) {
            b = BigDecimal.ZERO;
        }
        return a.add(b);
    }

    private List<DynamicObject> sortByTmplEntry(List<DynamicObject> docs, Map<Long, Integer> tmplEntryIndexMap) {
        for (DynamicObject doc : docs) {
            doc.set("entryentity.seq", (Object)tmplEntryIndexMap.getOrDefault(doc.getLong("entryentity.checktmplentry"), Integer.MAX_VALUE));
        }
        docs.sort(Comparator.comparing(e -> e.getInt("entryentity.seq")));
        return docs;
    }

    private String getShowStyle() {
        String parentShowstyle = this.getView().getParentView().getPageCache().get("showstyle");
        if (StringUtils.isNotEmpty((String)parentShowstyle)) {
            return parentShowstyle;
        }
        return (String)this.getView().getFormShowParameter().getCustomParam("showstyle");
    }

    private void formatValue(List<Integer> digitalColumns, Sheet sheet, SpreadEasyInvoker invoker) {
        if (digitalColumns.size() > 0) {
            Integer scale = this.getUserDefineScale();
            if (scale == null) {
                scale = 2;
            }
            HashMap<String, Object> styleMap = new HashMap<String, Object>(16);
            StringBuilder sb = new StringBuilder("#,##0");
            if (scale > 0) {
                sb.append(".");
            }
            for (int i2 = 0; i2 < scale; ++i2) {
                sb.append("0");
            }
            styleMap.put(SpreadProperties.SetCellStyleMethod.FORMAT.k(), sb.toString());
            styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 2);
            styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
            ArrayList<Map<String, Object>> rangeList = new ArrayList<Map<String, Object>>(16);
            digitalColumns.forEach(i -> this.addToRangMap((List<Map<String, Object>>)rangeList, 1, (int)i, sheet.getMaxRowCount() - 1, 1));
            invoker.setStyle(rangeList, styleMap);
        }
    }

    private Integer getUserDefineScale() {
        String scaleStr = this.getPageCache().get("checkScale");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scaleStr)) {
            try {
                int scale = Integer.parseInt(StringUtils.trim((String)scaleStr));
                if (scale >= 0 & scale <= 10) {
                    return scale;
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u7528\u6237\u81ea\u5b9a\u4e49\u7684\u7cbe\u5ea6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
        return null;
    }

    public void addToRangMap(List<Map<String, Object>> rangeList, int r, int c, int rc, int cc) {
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.R.k(), r);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.C.k(), c);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.CC.k(), cc);
        rangeList.add(rangeMap);
    }

    private void buildHeader(List<CheckReportColumn> headerColumns, Sheet sheet, SpreadEasyInvoker invoker) {
        int size = headerColumns.size();
        for (CheckReportColumn header : headerColumns) {
            invoker.updataValue(0, header.getIndex(), header.getName());
            sheet.getCell(0, header.getIndex().intValue()).setValue((Object)header.getName());
        }
        invoker.setStyle(0, 0, 1, size, CheckHelper.getColorStyleMap("1"));
        for (CheckReportColumn header : headerColumns) {
            invoker.setColumnsWidth(header.getIndex(), header.getColWidth());
        }
        invoker.setFrozenSheet(1, 0, 0, 0, "gray", 0);
    }

    private void setRowData(DynamicObject header, DynamicObject myDoc, DynamicObject oppoDoc, List<CheckReportColumn> headerColumns, Map<Long, Pair<String, String>> tmplMap, Map<Long, List<Pair<Long, Integer>>> entryAccountMap, Sheet sheet, SpreadEasyInvoker invoker, int rowIndex, String showStyle, boolean isGroupFirstRow) {
        DynamicObject doc = myDoc != null ? myDoc : oppoDoc;
        for (CheckReportColumn column : headerColumns) {
            Integer columnIndex = column.getIndex();
            switch (column.getNumber()) {
                case "number": {
                    this.updateValue(header, invoker, sheet, rowIndex, columnIndex, "number");
                    sheet.getCell(rowIndex, columnIndex.intValue()).setUserObject("id", (Object)header.getLong("id"));
                    sheet.getCell(rowIndex, columnIndex.intValue()).setUserObject("isautoelim", (Object)header.getString("isautoelim"));
                    break;
                }
                case "checktmpl": {
                    Long tmplId = header.getLong("checktmpl");
                    String tmplName = this.getDisplayName(tmplMap.getOrDefault(tmplId, (Pair<String, String>)Pair.onePair((Object)"", (Object)"")), showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)tmplName);
                    invoker.updataValue(rowIndex, columnIndex, tmplName);
                    break;
                }
                case "entity": {
                    String entity = this.getMemberStr(header.getLong("entity"), "bcm_entitymembertree", showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)entity);
                    invoker.updataValue(rowIndex, columnIndex, entity);
                    break;
                }
                case "currency": {
                    String currency = this.getMemberStr(header.getLong("currency"), "bcm_currencymembertree", showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)currency);
                    invoker.updataValue(rowIndex, columnIndex, currency);
                    break;
                }
                case "myentity": {
                    String myentity = this.getMemberStr(header.getLong("myentity"), "bcm_entitymembertree", showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)myentity);
                    invoker.updataValue(rowIndex, columnIndex, myentity);
                    break;
                }
                case "multimyentity": {
                    long myentityId = 0L;
                    if (myDoc != null) {
                        myentityId = header.getLong("myentity");
                    }
                    if (oppoDoc != null) {
                        myentityId = header.getLong("oppositeentity");
                    }
                    String multimyentity = this.getMemberStr(myentityId, "bcm_entitymembertree", showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)multimyentity);
                    invoker.updataValue(rowIndex, columnIndex, multimyentity);
                    break;
                }
                case "myaccount": {
                    if (myDoc == null) break;
                    String accountStr = this.getAccountString(entryAccountMap.get(myDoc.getLong("entryentity.checktmplentry")), showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)accountStr);
                    invoker.updataValue(rowIndex, columnIndex, accountStr);
                    break;
                }
                case "mycvtmoney": {
                    if (myDoc == null) break;
                    BigDecimal mycvtmoney = myDoc.getBigDecimal("entryentity.entrycvtmoney");
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)mycvtmoney);
                    invoker.updataValue(rowIndex, columnIndex, mycvtmoney);
                    break;
                }
                case "myelimmoney": {
                    if (myDoc == null) break;
                    BigDecimal myelimmoney = myDoc.getBigDecimal("entryentity.entryelimmoney");
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)myelimmoney);
                    invoker.updataValue(rowIndex, columnIndex, myelimmoney);
                    break;
                }
                case "oppositeentity": {
                    String oppositeentity = this.getMemberStr(header.getLong("oppositeentity"), "bcm_entitymembertree", showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)oppositeentity);
                    invoker.updataValue(rowIndex, columnIndex, oppositeentity);
                    break;
                }
                case "multioppositeentity": {
                    long oppoentityId = 0L;
                    if (myDoc != null) {
                        oppoentityId = header.getLong("oppositeentity");
                    }
                    if (oppoDoc != null) {
                        oppoentityId = header.getLong("myentity");
                    }
                    String multioppoentity = this.getMemberStr(oppoentityId, "bcm_entitymembertree", showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)multioppoentity);
                    invoker.updataValue(rowIndex, columnIndex, multioppoentity);
                    break;
                }
                case "oppoaccount": {
                    if (oppoDoc == null) break;
                    String accountStr = this.getAccountString(entryAccountMap.get(oppoDoc.getLong("entryentity.checktmplentry")), showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)accountStr);
                    invoker.updataValue(rowIndex, columnIndex, accountStr);
                    break;
                }
                case "oppocvtmoney": {
                    if (oppoDoc == null) break;
                    BigDecimal oppocvtmoney = oppoDoc.getBigDecimal("entryentity.entrycvtmoney");
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)oppocvtmoney);
                    invoker.updataValue(rowIndex, columnIndex, oppocvtmoney);
                    break;
                }
                case "oppoelimmoney": {
                    if (oppoDoc == null) break;
                    BigDecimal oppoelimmoney = oppoDoc.getBigDecimal("entryentity.entryelimmoney");
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)oppoelimmoney);
                    invoker.updataValue(rowIndex, columnIndex, oppoelimmoney);
                    break;
                }
                case "cvtdifmoney": {
                    if (!isGroupFirstRow) break;
                    BigDecimal cvtdifmoney = header.getBigDecimal("cvtdifmoney");
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)cvtdifmoney);
                    invoker.updataValue(rowIndex, columnIndex, cvtdifmoney);
                    break;
                }
                case "status": {
                    CheckStatusEnum status = CheckStatusEnum.getEnumNotThrow((int)header.getInt("status"));
                    if (status == null) break;
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)status.getName());
                    invoker.updataValue(rowIndex, columnIndex, status.getName());
                    break;
                }
                case "isautoelim": {
                    CheckSumStatusEnum autoelim = CheckSumStatusEnum.getEnumByValue((String)header.getString("isautoelim"));
                    if (autoelim == null) break;
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)autoelim.getName());
                    invoker.updataValue(rowIndex, columnIndex, autoelim.getName());
                    break;
                }
                case "modifier": {
                    String modifier = "";
                    CheckSumStatusEnum autoelimStatus = CheckSumStatusEnum.getEnumByValue((String)header.getString("isautoelim"));
                    if (autoelimStatus != null && CheckSumStatusEnum.SUM == autoelimStatus) {
                        modifier = header.getString("modifier.name");
                    }
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)modifier);
                    invoker.updataValue(rowIndex, columnIndex, modifier);
                    break;
                }
                case "modifytime": {
                    Date modifyDate;
                    String modifytime = "";
                    CheckSumStatusEnum autoStatus = CheckSumStatusEnum.getEnumByValue((String)header.getString("isautoelim"));
                    if (autoStatus != null && CheckSumStatusEnum.SUM == autoStatus && (modifyDate = header.getDate("modifytime")) != null) {
                        modifytime = this.dateFormat.format(modifyDate);
                    }
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)modifytime);
                    invoker.updataValue(rowIndex, columnIndex, modifytime);
                    break;
                }
                case "account": {
                    if (doc == null) break;
                    String accountStr = this.getAccountString(entryAccountMap.get(doc.getLong("entryentity.checktmplentry")), showStyle);
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)accountStr);
                    invoker.updataValue(rowIndex, columnIndex, accountStr);
                    break;
                }
                case "entrycvtmoney": {
                    if (doc == null) break;
                    BigDecimal oppocvtmoney = doc.getBigDecimal("entryentity.entrycvtmoney");
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)oppocvtmoney);
                    invoker.updataValue(rowIndex, columnIndex, oppocvtmoney);
                    break;
                }
                case "entryelimmoney": {
                    if (doc == null) break;
                    BigDecimal oppoelimmoney = doc.getBigDecimal("entryentity.entryelimmoney");
                    sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)oppoelimmoney);
                    invoker.updataValue(rowIndex, columnIndex, oppoelimmoney);
                    break;
                }
            }
        }
    }

    private String getMemberStr(long memberId, String entityNum, String showStyle) {
        IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)entityNum, (Long)memberId);
        if (IDNumberTreeNode.NotFoundTreeNode != node) {
            return this.getDisplayName((Pair<String, String>)Pair.onePair((Object)node.getNumber(), (Object)node.getName()), showStyle);
        }
        return "";
    }

    private void updateValue(DynamicObject header, SpreadEasyInvoker invoker, Sheet sheet, int rowIndex, Integer columnIndex, String field) {
        String value = header.getString(field);
        sheet.getCell(rowIndex, columnIndex.intValue()).setValue((Object)value);
        invoker.updataValue(rowIndex, columnIndex, value);
    }

    public List<CheckReportColumn> getHeaderColumn(CheckLayoutEnum checkLayout) {
        ArrayList result = new ArrayList(16);
        result = CheckLayoutEnum.USING == checkLayout ? Lists.newArrayList((Object[])new CheckReportColumn[]{new CheckReportColumn("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"CheckSumReportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("checktmpl", ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f", (String)"CheckSumReportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("entity", ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"CheckSumReportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CheckSumReportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("myentity", ResManager.loadKDString((String)"\u672c\u65b9\u5355\u4f4d", (String)"CheckSumReportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("myaccount", ResManager.loadKDString((String)"\u672c\u65b9\u79d1\u76ee", (String)"CheckSumReportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("mycvtmoney", ResManager.loadKDString((String)"\u672c\u65b9\u5bf9\u8d26\u91d1\u989d", (String)"CheckSumReportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), true, 0), new CheckReportColumn("myelimmoney", ResManager.loadKDString((String)"\u672c\u65b9\u62b5\u9500\u91d1\u989d", (String)"CheckSumReportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), true, 0), new CheckReportColumn("oppositeentity", ResManager.loadKDString((String)"\u5bf9\u65b9\u5355\u4f4d", (String)"CheckSumReportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("oppoaccount", ResManager.loadKDString((String)"\u5bf9\u65b9\u79d1\u76ee", (String)"CheckSumReportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("oppocvtmoney", ResManager.loadKDString((String)"\u5bf9\u65b9\u5bf9\u8d26\u91d1\u989d", (String)"CheckSumReportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), true, 0), new CheckReportColumn("oppoelimmoney", ResManager.loadKDString((String)"\u5bf9\u65b9\u62b5\u9500\u91d1\u989d", (String)"CheckSumReportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), true, 0), new CheckReportColumn("cvtdifmoney", ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02", (String)"CheckSumReportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), true, 2), new CheckReportColumn("status", ResManager.loadKDString((String)"\u72b6\u6001", (String)"CheckSumReportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 2), new CheckReportColumn("isautoelim", ResManager.loadKDString((String)"\u662f\u5426\u81ea\u52a8", (String)"CheckSumReportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 2), new CheckReportColumn("modifier", ResManager.loadKDString((String)"\u6700\u540e\u4fee\u6539\u4eba", (String)"CheckSumReportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 2), new CheckReportColumn("modifytime", ResManager.loadKDString((String)"\u6700\u540e\u4fee\u6539\u65f6\u95f4", (String)"CheckSumReportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 2)}) : Lists.newArrayList((Object[])new CheckReportColumn[]{new CheckReportColumn("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"CheckSumReportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("checktmpl", ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f", (String)"CheckSumReportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("entity", ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"CheckSumReportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CheckSumReportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("multimyentity", ResManager.loadKDString((String)"\u672c\u65b9\u5355\u4f4d", (String)"CheckSumReportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("multioppositeentity", ResManager.loadKDString((String)"\u5bf9\u65b9\u5355\u4f4d", (String)"CheckSumReportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("account", ResManager.loadKDString((String)"\u79d1\u76ee", (String)"CheckSumReportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 0), new CheckReportColumn("entrycvtmoney", ResManager.loadKDString((String)"\u5bf9\u8d26\u91d1\u989d", (String)"CheckSumReportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), true, 0), new CheckReportColumn("entryelimmoney", ResManager.loadKDString((String)"\u62b5\u9500\u91d1\u989d", (String)"CheckSumReportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), true, 0), new CheckReportColumn("cvtdifmoney", ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02", (String)"CheckSumReportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), true, 2), new CheckReportColumn("status", ResManager.loadKDString((String)"\u72b6\u6001", (String)"CheckSumReportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 2), new CheckReportColumn("isautoelim", ResManager.loadKDString((String)"\u662f\u5426\u81ea\u52a8", (String)"CheckSumReportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 2), new CheckReportColumn("modifier", ResManager.loadKDString((String)"\u6700\u540e\u4fee\u6539\u4eba", (String)"CheckSumReportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 2), new CheckReportColumn("modifytime", ResManager.loadKDString((String)"\u6700\u540e\u4fee\u6539\u65f6\u95f4", (String)"CheckSumReportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, 2)});
        for (int i = 0; i < result.size(); ++i) {
            ((CheckReportColumn)result.get(i)).setIndex(i);
        }
        return result;
    }

    private String getAccountString(List<Pair<Long, Integer>> pairs, String showStyle) {
        if (CollectionUtils.isEmpty(pairs)) {
            return "";
        }
        ArrayList<String> strList = new ArrayList<String>(16);
        for (Pair<Long, Integer> pair : pairs) {
            IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_accountmembertree", (Long)((Long)pair.p1));
            if (IDNumberTreeNode.NotFoundTreeNode != node) {
                strList.add(this.getDisplayName((Pair<String, String>)Pair.onePair((Object)node.getNumber(), (Object)node.getName()), showStyle));
                continue;
            }
            IDNumberTreeNode propertyNode = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_definedpropertyvalue", (Long)((Long)pair.p1));
            if (IDNumberTreeNode.NotFoundTreeNode == propertyNode) continue;
            IDNumberTreeNode topParentNode = propertyNode;
            while (topParentNode.getParent() != null) {
                topParentNode = topParentNode.getParent();
            }
            String str = topParentNode.getName() + ":" + propertyNode.getName();
            if (RangeEnum.getRangeByVal((int)((Integer)pair.p2)) != RangeEnum.VALUE_10) {
                str = str + "," + RangeEnum.getRangeByVal((int)((Integer)pair.p2)).getName();
            }
            strList.add(str);
        }
        return String.join((CharSequence)",", strList);
    }

    private String getDisplayName(Pair<String, String> pair, String showStyle) {
        if (StringUtils.isBlank((String)((String)pair.p1)) && StringUtils.isBlank((String)((String)pair.p2))) {
            return "";
        }
        if ("number".equals(showStyle)) {
            return (String)pair.p1;
        }
        if ("name".equals(showStyle)) {
            return (String)pair.p2;
        }
        return (String)pair.p1 + "|" + (String)pair.p2;
    }

    private DynamicObject getDoc(List<DynamicObject> docs, Integer index) {
        if (index < docs.size()) {
            return docs.get(index);
        }
        return null;
    }

    void setSpreadFilter(int r, int c, int rc, int cc) {
        HashMap<String, Integer> range = new HashMap<String, Integer>(16);
        range.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        range.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        range.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        range.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        SpreadClientInvoker.invokeSetRowFilterMethod(this.getClientViewProxy(), this.getSpreadKey(), Lists.newArrayList((Object[])new Map[]{range}));
    }

    protected Sheet getEffectiveSheet() {
        return this.getSpreadModel().getBook().getSheet(0);
    }

    @Override
    public String getSpreadKey() {
        return SPREAD_KEY;
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.currentManager != null) {
            return this.currentManager;
        }
        String data = this.getPageCache().get(CHECK_SM_CACHE_KEY);
        if (StringUtils.isEmpty((String)data)) {
            return null;
        }
        this.currentManager = JsonSerializerUtil.toSpreadManager((String)data);
        return this.currentManager;
    }

    @Override
    public void cacheSpreadModel(SpreadManager sm) {
        this.currentManager = sm;
        this.getPageCache().put(CHECK_SM_CACHE_KEY, JsonSerializerUtil.toJson((SpreadManager)sm));
    }
}

