/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.ObjectUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.tree.chk.ChkTreeBuilder;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractChkListPlugin
extends AbstractBaseListPlugin
implements TabSelectListener,
TreeNodeClickListener {
    protected static final String TAB_ORG = "tabpageap_entity";
    protected static final String TAB_TEMP = "tabpageap_template";
    private static final String SHOWTYPE_ORG = "orgshowtype";
    private static final String SHOWTYPE_TEMP = "tempshowtype";
    protected static final String NODE_SELECT_ORGID = "entityselectedNodeId";
    protected static final String NODE_SELECT_TEMPID = "templateselectedNodeId";
    protected static final String NODE_SELECT_TEMPNUMBER = "templateselectedNodeNumber";
    protected static final String NODE_TEMP_NONE = "TemplateNone";
    protected static final String treeview_id_cache = "treeview_id_cache";
    protected static final String treeview_entity = "treeview_entity";
    protected static final String treeview_template = "treeview_template";
    private static final String tabap = "tabap";
    protected static final String billlistap = "billlistap";
    protected static final String TABSELECT = "tabselect";
    private static final String SEARCH_LIST_ORG = "orglist";
    private static final String SEARCH_LIST_TEMP = "templist";
    protected static final String TREEFOCUS_ORG = "orgfocus";
    private static final String TREEFOCUS_TEMP = "tempfocus";
    protected static final String TABINFO_ORG = "orgTabInfo";
    protected static final String TABINFO_TEMP = "tempTabInfo";
    protected static final String GETHASPERMORGIDS = "getHasPermOrgIds";
    protected static final String allsubordinate = "alllevel";
    protected static final String directLevel = "directlevel";
    protected static final String currentLevel = "me";
    protected static final String ID = "id";
    protected static final String NUMBER = "number";
    protected TabInfo orgTabInfo = new TabInfo();
    protected TabInfo tempTabInfo = new TabInfo();
    private PermPackageList permMap;

    protected String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"CheckUpChkListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"CheckUpChkListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        Tab tab = (Tab)this.getControl(tabap);
        tab.addItemClickListener((ItemClickListener)this);
        tab.addTabSelectListener((TabSelectListener)this);
        TreeView orgTreeView = (TreeView)this.getControl(treeview_entity);
        orgTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView tempTreeView = (TreeView)this.getControl(treeview_template);
        tempTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        HashMap map = new HashMap();
        this.asMapF7toType(this.getUserSelectDimKeys(), SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
        this.addSerchCtrlListener();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("searchbefore", "searchnext", "searchbefore1", "searchnext1");
    }

    private void addSerchCtrlListener() {
        Search entitysearchap = (Search)this.getControl("entitysearchap");
        Search templatesearchap = (Search)this.getControl("templatesearchap");
        Search searchap = (Search)this.getControl("searchap");
        entitysearchap.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    AbstractChkListPlugin.this.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), true);
                } else {
                    AbstractChkListPlugin.this.getPageCache().put(AbstractChkListPlugin.SEARCH_LIST_ORG, null);
                    AbstractChkListPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
        templatesearchap.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    AbstractChkListPlugin.this.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), false);
                } else {
                    AbstractChkListPlugin.this.getPageCache().put(AbstractChkListPlugin.SEARCH_LIST_TEMP, null);
                    AbstractChkListPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
        searchap.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    AbstractChkListPlugin.this.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), false);
                } else {
                    AbstractChkListPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put(SHOWTYPE_ORG, (String)this.getModel().getValue("showorgtype"));
        this.getPageCache().put(SHOWTYPE_TEMP, (String)this.getModel().getValue("showtmptype"));
        if (!this.changeOpenPageParam()) {
            this.refreshBillByUserSelect(this.getUserSelectDimKeys(), false);
            if (this.getModel().getValue(this.getModelSign()) != null) {
                CslSchemeUtils.setDefaultCslSchemeValue(this.getModelId() + "", false, this.getView());
            }
        }
        if (this.getModelId() != 0L) {
            this.initLeftTree();
            String treeviewId = this.getPageCache().get(treeview_id_cache);
            this.treeNodeClickCache(this.getPageCache().get(NODE_SELECT_ORGID), treeviewId);
            this.setDefaultProcess();
        }
        this.getPageCache().put(TABSELECT, TAB_ORG);
        TreeView tree = (TreeView)this.getControl(treeview_entity);
        if (!this.isOrgMemberHavePerm(tree.getTreeState().getFocusNodeId())) {
            this.refreshBillList(new QFilter("1", "=", (Object)0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u6210\u5458\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractChkListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
        }
        this.checkGradeOrgScheme();
    }

    private boolean changeOpenPageParam() {
        FormShowParameter params = this.getView().getFormShowParameter();
        String page = (String)params.getCustomParam("page");
        if (StringUtils.isNotEmpty((String)page) && ("reportlist".equals(page) || "MergeControl".equals(page))) {
            String model = (String)params.getCustomParam("model");
            String scenario = (String)params.getCustomParam("scenario");
            String year = (String)params.getCustomParam("year");
            String period = (String)params.getCustomParam("period");
            String cslscheme = params.getCustomParam("cslscheme").toString();
            this.getModel().beginInit();
            this.getModel().setValue("model", (Object)model);
            this.getModel().setValue("scenario", (Object)scenario);
            this.getModel().setValue("year", (Object)year);
            this.getModel().setValue("period", (Object)period);
            if (StringUtils.isNotEmpty((String)cslscheme)) {
                this.getModel().setValue("cslscheme", (Object)cslscheme);
            }
            this.getModel().endInit();
            return true;
        }
        return false;
    }

    public void initLeftTree() {
        String currentTab;
        TemplateTreeNode root = null;
        Long modelId = this.getModelId();
        String string = currentTab = StringUtils.isNotEmpty((String)this.getPageCache().get(TABSELECT)) ? this.getPageCache().get(TABSELECT) : TAB_ORG;
        if (TAB_TEMP.equals(currentTab)) {
            String showType = this.getPageCache().get(SHOWTYPE_TEMP);
            root = ChkTreeBuilder.getTempTree(modelId, showType, true);
        } else {
            String showType = StringUtils.isNotEmpty((String)this.getPageCache().get(SHOWTYPE_ORG)) ? this.getPageCache().get(SHOWTYPE_ORG) : "4";
            root = this.initOrgTree(modelId, showType, false, false);
            this.getPageCache().put("orgrealnames", ObjectSerialUtil.toByteSerialized((Object)ThreadCache.get((Object)"orgrealnames")));
            if (root == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6210\u5458\u6743\u9650\u3002", (String)"AbstractChkListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                TreeView tree = (TreeView)this.getControl(treeview_entity);
                tree.deleteAllNodes();
                BillList billList = (BillList)this.getControl(billlistap);
                billList.clearData();
                billList.clearEntryState();
                return;
            }
            HashSet<Object> orgIds = new HashSet<Object>();
            this.getHasPermOrgIds(orgIds, (AbstractTreeNode<Object>)root);
            this.getPageCache().put(GETHASPERMORGIDS, this.toByteSerialized(orgIds));
            if (this.getPageCache().get(TABINFO_ORG) != null) {
                this.orgTabInfo = (TabInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get(TABINFO_ORG), TabInfo.class);
            } else {
                this.orgTabInfo.updateTabInfo(Long.parseLong(root.getId()), ((OrgTreeNode)root).getFinalname(), true);
            }
            this.getPageCache().put(TABINFO_ORG, SerializationUtils.toJsonString((Object)this.orgTabInfo));
        }
        this.buildLeftTree((AbstractTreeNode<Object>)root, currentTab);
    }

    @Override
    public CslSchemeServiceHelper.QueryOrgParam buildQueryOrgParam(long modelId, QFBuilder builder) {
        DynamicObject cslSchemeDyn = (DynamicObject)this.getModel().getValue("cslscheme");
        Pair schemePair = cslSchemeDyn == null ? null : Pair.of((Object)cslSchemeDyn.getLong(ID), (Object)cslSchemeDyn.getString(NUMBER));
        CslSchemeServiceHelper.QueryOrgParam param = CslSchemeServiceHelper.QueryOrgParam.of((String)"model", (Object)(modelId == 0L ? "" : "" + modelId));
        param.set("period", (Object)(this.getPeriodId() == 0L ? "" : "" + this.getPeriodId()));
        param.set("year", (Object)this.getFyNum());
        param.setCslScheme(schemePair);
        DynamicObject dataEntity = this.getPlugin().getView().getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        this.buildQueryParam(param, properties, "scenario", ID);
        return super.buildQueryOrgParam(modelId, builder);
    }

    public void getHasPermOrgIds(Set<Object> orgIds, AbstractTreeNode<Object> root) {
        orgIds.add(root.getId());
        if (root.getChildren() != null && !root.getChildren().isEmpty()) {
            for (Object o : root.getChildren()) {
                this.getHasPermOrgIds(orgIds, (AbstractTreeNode<Object>)((AbstractTreeNode)o));
            }
        }
    }

    private void buildLeftTree(AbstractTreeNode<Object> root, String currentTab) {
        String treeId = this.getPageCache().get(treeview_id_cache);
        TreeView tree = (TreeView)this.getControl(StringUtils.isNotEmpty((String)treeId) ? treeId : treeview_entity);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            TreeNode nodeRoot = treemodel.buildEntryTree(tree);
            nodeRoot.iterate(999, v -> v.setIsOpened(false));
            nodeRoot.iterate(0, v -> v.setIsOpened(true));
            if (root.getChildren() == null) {
                return;
            }
            TreeNode selectnode = this.findCacheNode(nodeRoot, currentTab, (TreeModel<AbstractTreeNode<Object>>)treemodel);
            tree.focusNode(selectnode);
            this.orgTabInfo.updateTabInfo(Long.parseLong(selectnode.getId()), selectnode.getText(), ObjectUtils.equals((Object)selectnode.getId(), (Object)nodeRoot.getId()));
            if (TAB_TEMP.equals(currentTab)) {
                TreeModel tempTreeModel;
                AbstractTreeNode selectTempNode;
                this.getPageCache().put(NODE_SELECT_TEMPID, selectnode.getId());
                if (this.getPageCache().get(treeview_template) != null && (selectTempNode = (AbstractTreeNode)(tempTreeModel = (TreeModel)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(treeview_template))).searchByNodeId(selectnode.getId())) != null) {
                    this.getPageCache().put(NODE_SELECT_TEMPNUMBER, ((TemplateTreeNode)selectTempNode).getNumber());
                }
                treemodel.ache2page(this.getPageCache(), treeview_template);
            } else {
                this.getPageCache().put(TABINFO_ORG, SerializationUtils.toJsonString((Object)this.orgTabInfo));
                this.getPageCache().put(NODE_SELECT_ORGID, selectnode.getId());
                treemodel.ache2page(this.getPageCache(), treeview_entity);
                OrgTreeNode orgNode = (OrgTreeNode)treemodel.searchByNodeId(selectnode.getId());
                this.getView().setVisible(orgNode.getParent() == null ? Boolean.FALSE : Boolean.TRUE, new String[]{"combofield"});
            }
        }
    }

    abstract boolean isRefreshBilllist();

    private TreeNode findCacheNode(TreeNode root, String currentTab, TreeModel<AbstractTreeNode<Object>> treemodel) {
        String selectnode = null;
        if (TAB_ORG.equals(currentTab)) {
            selectnode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), false, false);
            FormShowParameter params = this.getView().getFormShowParameter();
            if (!GuidePageUtils.isFromGuide(this.getView()) && params.getCustomParam("entity") != null) {
                selectnode = (String)params.getCustomParam("entity");
            }
            if (!StringUtil.isEmptyString((String)this.getPageCache().get(NODE_SELECT_ORGID))) {
                selectnode = this.getPageCache().get(NODE_SELECT_ORGID);
            }
            this.getPageCache().put(NODE_SELECT_ORGID, selectnode);
            if (selectnode == null || selectnode.equals(root.getId())) {
                if (root.getChildren() != null) {
                    TreeNode temp = (TreeNode)root.getChildren().get(0);
                    this.getPageCache().put(NODE_SELECT_ORGID, temp.getId());
                    return new TreeNode("0", temp.getId(), temp.getText());
                }
                return new TreeNode("0", root.getId(), root.getText());
            }
        } else if (TAB_TEMP.equals(currentTab)) {
            selectnode = this.getPageCache().get(NODE_SELECT_TEMPID);
        }
        if (selectnode == null || selectnode.equals(root.getId())) {
            return new TreeNode("0", root.getId(), root.getText());
        }
        List childPathNodes = root.getChildPathNodes(selectnode);
        childPathNodes.forEach(v -> v.setIsOpened(true));
        if (!childPathNodes.isEmpty()) {
            return (TreeNode)childPathNodes.get(childPathNodes.size() - 1);
        }
        return new TreeNode("0", root.getId(), root.getText());
    }

    private void searchMember(String text, boolean isentity) {
        TreeModel treeModel;
        TreeView treeView;
        if (isentity) {
            treeView = (TreeView)this.getControl(treeview_entity);
            treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)treeview_entity);
        } else {
            treeView = (TreeView)this.getControl(treeview_template);
            treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)treeview_template);
        }
        if (treeModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"AbstractChkListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ITreeNode root = treeModel.getRoot();
        List lists = treeModel.seekAllChildrenIf(root.getId(), p -> p.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH)));
        ArrayList<String> list = new ArrayList<String>(lists.size());
        for (AbstractTreeNode node : lists) {
            list.add(node.getId());
        }
        if (!list.isEmpty()) {
            if (isentity) {
                this.getPageCache().put(SEARCH_LIST_ORG, SerializationUtils.toJsonString(list));
                this.getPageCache().put(TREEFOCUS_ORG, "0");
            } else {
                this.getPageCache().put(SEARCH_LIST_TEMP, SerializationUtils.toJsonString(list));
                this.getPageCache().put(TREEFOCUS_TEMP, "0");
            }
            String focusnode = (String)list.get(0);
            ITreeNode parent = ((AbstractTreeNode)treeModel.searchByNodeId(focusnode)).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent() != null) {
                    parentId = ((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent().getId();
                    continue;
                }
                break;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"AbstractChkListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key) || "searchbefore1".equals(key) || "searchnext1".equals(key)) {
            String count;
            String rowcache;
            TreeModel treeModel;
            TreeView treeView;
            int rowCount = 0;
            if ("searchbefore".equals(key) || "searchnext".equals(key)) {
                treeView = (TreeView)this.getControl(treeview_entity);
                treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)treeview_entity);
                rowcache = this.getPageCache().get(SEARCH_LIST_ORG);
                count = this.getPageCache().get(TREEFOCUS_ORG);
                if (count != null) {
                    rowCount = Integer.parseInt(count);
                }
            } else {
                treeView = (TreeView)this.getControl(treeview_template);
                treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)treeview_template);
                rowcache = this.getPageCache().get(SEARCH_LIST_TEMP);
                count = this.getPageCache().get(TREEFOCUS_TEMP);
                if (count != null) {
                    rowCount = Integer.parseInt(count);
                }
            }
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"AbstractChkListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
            if ("searchbefore".equals(key) || "searchbefore1".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"AbstractChkListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else if ("searchnext".equals(key) || "searchnext1".equals(key)) {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"AbstractChkListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            String focusnode = String.valueOf(rowList.get(rowCount));
            if ("searchbefore".equals(key) || "searchnext".equals(key)) {
                this.getPageCache().put(TREEFOCUS_ORG, String.valueOf(rowCount));
            } else {
                this.getPageCache().put(TREEFOCUS_TEMP, String.valueOf(rowCount));
            }
            ITreeNode parent = treeModel.searchByNodeId(focusnode).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (treeModel.searchByNodeId(temp).getParent() == null) break;
                parentId = treeModel.searchByNodeId(temp).getParent().getId();
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String currentTab = tabSelectEvent.getTabKey();
        this.getPageCache().put(TABSELECT, currentTab);
        if (TAB_ORG.equals(currentTab)) {
            if (this.getPageCache().get(TABINFO_TEMP) != null) {
                this.tempTabInfo = (TabInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get(TABINFO_TEMP), TabInfo.class);
            } else {
                this.tempTabInfo.name = ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"AbstractChkListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            Label orgLabel = (Label)this.getView().getControl("templatelabel");
            orgLabel.setText(String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff1a%s", (String)"AbstractChkListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.tempTabInfo.name));
            this.getPageCache().put(treeview_id_cache, treeview_entity);
        } else if (TAB_TEMP.equals(currentTab)) {
            if (this.getPageCache().get(TABINFO_ORG) != null) {
                this.orgTabInfo = (TabInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get(TABINFO_ORG), TabInfo.class);
            } else {
                this.orgTabInfo.name = ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AbstractChkListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            Label orgLabel = (Label)this.getView().getControl("orglabel");
            orgLabel.setText(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s", (String)"AbstractChkListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.orgTabInfo.name));
            this.getPageCache().put(treeview_id_cache, treeview_template);
        }
        try {
            this.getModel().getValue(this.getModelSign());
        }
        catch (KDException e) {
            throw new KDBizException(MessageConstant.getMODEL_NOTEXISTS());
        }
        if (this.getModel().getValue(this.getModelSign()) != null) {
            this.initLeftTree();
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String selectedNodeId = (String)arg0.getNodeId();
        if (selectedNodeId.isEmpty()) {
            return;
        }
        String treeviewId = this.getPageCache().get(treeview_id_cache);
        if ((treeview_entity.equals(treeviewId) || treeviewId == null) && !this.isOrgMemberHavePerm(selectedNodeId)) {
            this.refreshBillList(new QFilter("1", "=", (Object)0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u6210\u5458\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractChkListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.treeNodeClickCache(selectedNodeId, treeviewId);
        this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
    }

    protected boolean isOrgMemberHavePerm(String memId) {
        if (StringUtils.isEmpty((String)memId)) {
            return false;
        }
        if (Boolean.parseBoolean(this.getPageCache().get("isroot"))) {
            return true;
        }
        this.permMap = this.getCachePermMap();
        if (this.permMap == null) {
            return true;
        }
        log.info(this.permMap.toString() + "memId:" + memId);
        PermEnum permEnum = this.permMap.getPermEnum(memId);
        return permEnum == null || permEnum != PermEnum.NOPERM;
    }

    private PermPackageList getCachePermMap() {
        if (this.permMap != null) {
            return this.permMap;
        }
        String permCacheStr = this.getPageCache().get(PermCacheKey.ORG_PERM_CACHE_KEY);
        if (permCacheStr == null) {
            return null;
        }
        this.permMap = (PermPackageList)SerializationUtils.fromJsonString((String)permCacheStr, PermPackageList.class);
        return this.permMap;
    }

    protected Integer getOrgMemberPerm(String orgId) {
        if (Boolean.parseBoolean(this.getPageCache().get("isroot"))) {
            return PermEnum.READWRITE.getValue();
        }
        PermPackageList permMap = this.getCachePermMap();
        PermEnum permNum = null;
        if (permMap != null) {
            permNum = permMap.getPermEnum(orgId);
        }
        if (permNum != null) {
            return permNum.getValue();
        }
        return PermEnum.NOPERM.getValue();
    }

    private void treeNodeClickCache(String selectedNodeId, String treeviewId) {
        if (treeview_template.equals(treeviewId)) {
            TreeModel tempTreeModel = (TreeModel)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(treeview_template));
            AbstractTreeNode tempNode = (AbstractTreeNode)tempTreeModel.searchByNodeId(selectedNodeId);
            boolean isSelectRoot = ((TemplateTreeNode)tempNode).isIstemplate();
            this.tempTabInfo.updateTabInfo(Long.parseLong(selectedNodeId), tempNode.getName(), !isSelectRoot);
            this.getPageCache().put(TABINFO_TEMP, SerializationUtils.toJsonString((Object)this.tempTabInfo));
            this.getPageCache().put(NODE_SELECT_TEMPID, selectedNodeId);
            this.getPageCache().put(NODE_SELECT_TEMPNUMBER, ((TemplateTreeNode)tempNode).getNumber());
        } else if (this.getPageCache().get(treeview_entity) != null) {
            boolean isSelectRoot;
            TreeModel orgTreeModel = (TreeModel)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(treeview_entity));
            OrgTreeNode orgNode = (OrgTreeNode)orgTreeModel.searchByNodeId(selectedNodeId);
            if (orgNode == null) {
                return;
            }
            boolean bl = isSelectRoot = orgNode.getParent() == null;
            if (isSelectRoot) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"combofield"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"combofield"});
            }
            this.orgTabInfo.updateTabInfo(Long.parseLong(selectedNodeId), orgNode.getFinalname(), isSelectRoot);
            this.getPageCache().put(TABINFO_ORG, SerializationUtils.toJsonString((Object)this.orgTabInfo));
            this.getPageCache().put(NODE_SELECT_ORGID, selectedNodeId);
        }
    }

    public void refreshBillList(QFilter filter) {
        this.refreshBillList(filter, true);
    }

    public void refreshBillList(QFilter filter, boolean needRefresh) {
        BillList billList = (BillList)this.getView().getControl(billlistap);
        billList.clearSelection();
        if (this.isRefreshBilllist()) {
            if (filter == null) {
                billList.getFilterParameter().setFilter(this.getQFilter());
            } else {
                filter.and(this.getQFilter());
                billList.getFilterParameter().setFilter(filter);
            }
            this.billistOrderBy(billList);
        } else {
            billList.getFilterParameter().setFilter(new QFilter("1", "=", (Object)0));
        }
        if (needRefresh) {
            billList.refresh();
        }
    }

    abstract void billistOrderBy(BillList var1);

    public QFilter getQFilter() {
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (this.getPageCache().get(TABINFO_ORG) != null) {
            this.orgTabInfo = (TabInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get(TABINFO_ORG), TabInfo.class);
            if (!this.orgTabInfo.isIfSelectRoot()) {
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"id, number, parent.id, longnumber, copyfrom.id, isleaf", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)this.orgTabInfo.getId())});
                if (org == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"AbstractChkListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                ArrayList<Long> orgparents = new ArrayList<Long>(2);
                orgparents.add(org.getLong("parent.id"));
                orgparents.add(0L);
                QFilter qf = new QFilter("orgparent", "in", orgparents).and("org", "=", (Object)(org.getLong("copyfrom.id") != 0L ? org.getLong("copyfrom.id") : org.getLong(ID)));
                if (!this.isOrgMemberHavePerm(org.getString(ID))) {
                    qf.and("1", "=", (Object)0);
                }
                if (!org.getBoolean("isleaf")) {
                    String orgSelectedLevel = (String)this.getModel().getValue("combofield");
                    if (allsubordinate.equals(orgSelectedLevel)) {
                        Map<Long, List<DynamicObject>> collect = this.getAllsubordinateOrgs(modelId, org.getString("longnumber"));
                        collect.forEach((k, v) -> {
                            Set ids = v.stream().filter(dy -> this.isOrgMemberHavePerm(dy.getString(ID))).map(o -> o.getLong("copyfrom.id") != 0L ? o.getLong("copyfrom.id") : o.getLong(ID)).collect(Collectors.toSet());
                            if (!ids.isEmpty()) {
                                qf.or(new QFilter("orgparent", "=", k).or("orgparent", "=", (Object)0L).and("org", "in", ids));
                            }
                        });
                    } else if (directLevel.equals(orgSelectedLevel)) {
                        DynamicObjectCollection orgs = this.getDirectLevelOrgs(org.getLong(ID));
                        if (this.getScenarioId() == 0L) {
                            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioEmpty"), new Object[0]);
                        }
                        FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), this.getScenarioId(), this.getFyNum(), this.getPeriodId());
                        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)orgs);
                        Set ids = orgs.stream().filter(dy -> this.isOrgMemberHavePerm(dy.getString(ID))).map(o -> o.getLong("copyfrom.id") != 0L ? o.getLong("copyfrom.id") : o.getLong(ID)).collect(Collectors.toSet());
                        if (!ids.isEmpty()) {
                            qf.or(new QFilter("orgparent", "in", Arrays.asList(org.getLong("parent.id"), org.getLong(ID), 0L)).and("org", "in", ids));
                        }
                    }
                }
                qFilter.and(qf);
            }
        }
        qFilter.and(this.getTmpSpecialHandleQfilter());
        QFilter f7Filter = this.getUserSelectF7Filter();
        if (f7Filter != null) {
            qFilter.and(f7Filter);
        }
        return qFilter;
    }

    protected DynamicObjectCollection getDirectLevelOrgs(long id) {
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, copyfrom.id", (QFilter[])new QFBuilder("parent", "=", (Object)id).toArray());
    }

    protected Map<Long, List<DynamicObject>> getAllsubordinateOrgs(long modelId, String longnumber) {
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, parent.id, copyfrom.id", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("longnumber", "like", (Object)(longnumber + "!%")).toArray());
        if (this.getScenarioId() == 0L) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioEmpty"), new Object[0]);
        }
        FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), this.getScenarioId(), this.getFyNum(), this.getPeriodId());
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)orgs);
        return orgs.stream().collect(Collectors.groupingBy(o -> o.getLong("parent.id")));
    }

    protected Map<Long, List<DynamicObject>> getEntityAllsubordinateOrgs(long modelId, String longnumber, long cslschemeId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("longnumber", "like", (Object)(longnumber + "!%"));
        if (cslschemeId != 0L) {
            qfBuilder.add("cslscheme.id", "=", (Object)cslschemeId);
        }
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, parent.id, copyfrom.id", (QFilter[])qfBuilder.toArray());
        if (this.getScenarioId() == 0L) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioEmpty"), new Object[0]);
        }
        FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), this.getScenarioId(), this.getFyNum(), this.getPeriodId());
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)orgs);
        return orgs.stream().collect(Collectors.groupingBy(o -> o.getLong("parent.id")));
    }

    public QFilter getTmpSpecialHandleQfilter() {
        if (this.getPageCache().get(TABINFO_TEMP) != null) {
            this.tempTabInfo = (TabInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get(TABINFO_TEMP), TabInfo.class);
            if (!this.tempTabInfo.isIfSelectRoot()) {
                List ls = TemplateUtil.getTemplateIds((Long)this.tempTabInfo.getId());
                return new QFilter("template", "in", (Object)ls);
            }
            if (this.tempTabInfo.isIfSelectRoot() && this.tempTabInfo.getId() != 1L && !this.tempTabInfo.name.equals(TabInfo.getRootName())) {
                List ls = TemplateUtil.getTemplateIds((Long)this.getModelId(), (Long)this.tempTabInfo.getId());
                return new QFilter("template", "in", (Object)ls);
            }
        }
        return new QFilter("1", "=", (Object)1);
    }

    public abstract QFilter getUserSelectF7Filter();

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "showorgtype": {
                String showOrgType = (String)this.getModel().getValue("showorgtype");
                this.getPageCache().put(SHOWTYPE_ORG, showOrgType);
                this.initLeftTree();
                break;
            }
            case "showtmptype": {
                String showTmpType = (String)this.getModel().getValue("showtmptype");
                this.getPageCache().put(SHOWTYPE_TEMP, showTmpType);
                this.initLeftTree();
                break;
            }
            case "model": {
                this.propertyChangedModelUse(this.getUserSelectDimKeys());
                this.setDefaultProcess();
                ThreadCache.remove((Object)(this.getClass().getName() + "listfilter"));
                if (this.getModel().getValue(this.getModelSign()) == null) break;
                this.getPageCache().remove(NODE_SELECT_ORGID);
                this.getPageCache().remove(TABINFO_ORG);
                this.getPageCache().remove(NODE_SELECT_TEMPID);
                this.getPageCache().remove(TABINFO_TEMP);
                this.initCslschemeValue(String.valueOf(this.getModelId()), true);
                this.initComboField();
                this.getPageCache().put(TABSELECT, TAB_ORG);
                this.getPageCache().put(treeview_id_cache, treeview_entity);
                Tab tab = (Tab)this.getControl(tabap);
                tab.selectTab(TAB_ORG);
                tab.activeTab(TAB_ORG);
                this.refreshBillList(null);
                break;
            }
            case "cslscheme": {
                this.saveUserChangedCslscheme((DynamicObject)e.getChangeSet()[0].getNewValue());
                this.initLeftTree();
                this.refreshBillList(null);
                break;
            }
        }
        if (this.getUserSelectDimKeys().contains(key)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (("year".equals(key) || "period".equals(key)) && this.getModel().getValue("model") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null) {
                this.initLeftTree();
            }
            Boolean isSureReturn = this.propertyChangedDimUse(key, newValue, false, true);
            this.refreshBillList(null);
            if (!isSureReturn.booleanValue()) {
                return;
            }
        }
        if ("process".equals(key)) {
            this.refreshBillList(null);
        }
    }

    protected void initComboField() {
        IDataModel iDataModel = this.getView().getModel();
        iDataModel.beginInit();
        this.getModel().setValue("combofield", (Object)currentLevel);
        iDataModel.endInit();
    }

    public abstract String getFyNum();

    public abstract long getPeriodId();

    public abstract long getScenarioId();

    public abstract List<String> getDimKeys();

    public abstract List<String> getUserSelectDimKeys();

    public abstract void setDefaultProcess();

    public void setNoneTempalteFilter(QFilter filter) {
        String nodeId = this.getPageCache().get(NODE_SELECT_TEMPID);
        if (StringUtils.isNotEmpty((String)nodeId) && "1".equals(nodeId)) {
            filter.and(new QFilter("template", "=", (Object)0L));
        }
    }

    static class TabInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected String rootName = ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"AbstractChkListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        private long id;
        protected String name;
        private boolean ifSelectRoot = true;

        TabInfo() {
        }

        public static String getRootName() {
            return ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"AbstractChkListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }

        void updateTabInfo(long id, String name, boolean ifSelectRoot) {
            this.id = id;
            this.name = name;
            this.ifSelectRoot = ifSelectRoot;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isIfSelectRoot() {
            return this.ifSelectRoot;
        }

        public void setIfSelectRoot(boolean ifSelectRoot) {
            this.ifSelectRoot = ifSelectRoot;
        }
    }
}

