/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.MultiTemplateModel;
import kd.fi.bcm.business.chkcheck.util.CheckedFormulaUtil;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.YearScopeEnum;
import kd.fi.bcm.common.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.EffectiveYearPeriodUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class ChechedBasicSinglePlugin
extends AbstractBaseFormPlugin {
    private static final String year = "yearcol";
    private static final String period = "periodcol";
    private static final String yearscope = "yearscopecol";
    private static final String entryentity = "entryentity";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(Lists.newArrayList((Object[])new String[]{"org"}), SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_cancel", "btn_confirm");
        this.addItemClickListeners("advcontoolbarap");
        BasedataEdit yearcol = (BasedataEdit)this.getControl(year);
        yearcol.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodCol = (BasedataEdit)this.getControl(period);
        periodCol.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit multitemplate = (BasedataEdit)this.getControl("multitemplate");
        multitemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefautValue();
        this.checkAndBuildEditPage();
        HashMap<String, String> f7Key2Dim = new HashMap<String, String>(16);
        f7Key2Dim.put("org", DimTypesEnum.ENTITY.getNumber());
        this.getPageCache().put("f7Key2Dim", this.toByteSerialized(f7Key2Dim));
        this.getPageCache().put("model", String.valueOf(this.getModelId()));
        if (this.isRPT()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdistcslscheme", "mulcslscheme"});
        }
    }

    private void checkAndBuildEditPage() {
        ChkFormulaModel model = (ChkFormulaModel)this.deSerializedBytes((String)this.getFormCustomParam("checkmodel"));
        if (model != null && StringUtils.isNotEmpty((String)model.getNumber())) {
            this.getModel().setValue("number", (Object)model.getNumber());
        }
        if (model != null && StringUtils.isNotEmpty((String)model.getName())) {
            this.getModel().setValue("number", (Object)model.getNumber());
            this.getModel().setValue("name", model.getMultiLangName());
            this.getModel().setValue("allowamount", (Object)model.getAllowamount());
            this.getModel().setValue("chkeffecttype", (Object)model.getChkeffecttype());
            this.getModel().setValue("org", (Object)model.getOrg());
            this.getModel().setValue("description", (Object)model.getDescription());
            if (this.getModel().getValue("multitemplate") != null && !((DynamicObjectCollection)this.getModel().getValue("multitemplate")).isEmpty()) {
                this.getModel().setValue("untemp", (Object)true);
            } else {
                this.getModel().setValue("untemp", (Object)false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"multitemplate"});
            }
            if (!model.getUmtemp()) {
                this.getModel().setValue("untemp", (Object)false);
                this.getModel().setValue("multitemplate", null);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"multitemplate"});
            }
        }
    }

    private void setDefautValue() {
        Object orgid = this.getFormCustomParam("org");
        Object temid = this.getFormCustomParam("temp");
        ChkFormulaModel cmodel = (ChkFormulaModel)this.deSerializedBytes((String)this.getFormCustomParam("checkmodel"));
        if (CollectionUtils.isEmpty((Collection)cmodel.getMulCslscheme())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"mulcslscheme"});
        } else {
            this.getModel().setValue("isdistcslscheme", (Object)true);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"mulcslscheme"});
            this.getModel().setValue("mulcslscheme", (Object)cmodel.getMulCslscheme());
        }
        List multiTemplate = cmodel.getMultiTemplate();
        if (CollectionUtils.isEmpty((Collection)multiTemplate)) {
            this.getModel().setValue("untemp", (Object)true);
            this.getModel().setValue("org", orgid);
            return;
        }
        if (temid != null) {
            DynamicObjectCollection doc = new DynamicObjectCollection();
            for (MultiTemplateModel model : multiTemplate) {
                DynamicObject chkSetting = BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkformulasetting");
                DynamicObject dynamicObject = new DynamicObject(chkSetting.getDynamicObjectCollection("multitemplate").getDynamicObjectType(), (Object)DB.genGlobalLongId());
                DynamicObject dybase = new DynamicObject(model.getBasetype(), (Object)model.getLastTempId());
                dynamicObject.set("fbasedataid", (Object)dybase);
                doc.add((Object)dynamicObject);
            }
            this.getModel().setValue("multitemplate", (Object)doc);
            this.getModel().setValue("untemp", (Object)true);
        }
        this.getModel().setValue("org", orgid);
        if (cmodel.get("effectivedata") != null) {
            Map effectiveMap = (Map)cmodel.get("effectivedata");
            EffectiveYearPeriodUtil.loadEntitymember(this.getModel(), this.getPageCache(), effectiveMap);
        } else if ((Long)cmodel.get("id") != 0L) {
            EffectiveYearPeriodUtil.loadEntitymember(this.getModel(), this.getPageCache(), cmodel.getId(), "bcm_chkformulasetting");
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("addrow".equals(key)) {
            this.getModel().createNewEntryRow(entryentity);
        } else if ("deleterow".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryentity);
            if (entryGrid.getSelectRows().length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"ChechedBasicSinglePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryRows(entryentity, entryGrid.getSelectRows());
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            ChkFormulaModel model = (ChkFormulaModel)this.deSerializedBytes((String)this.getFormCustomParam("checkmodel"));
            try {
                this.saveBasic(model);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
                return;
            }
            this.returnDataToParent(model);
            this.getPageCache().put("needRecycleNumber", "false");
            this.getView().close();
        }
    }

    private void saveBasic(ChkFormulaModel model) {
        String number = this.checkAndGetValue("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"ChechedBasicSinglePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])).toString();
        String name = this.checkAndGetValue("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"ChechedBasicSinglePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])).toString();
        CheckedFormulaUtil.existsFormula((String)"number", (String)number, (String)ResManager.loadKDString((String)"\u7f16\u7801", (String)"ChechedBasicSinglePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (long)model.getId(), (long)this.getModelId());
        String allowamount = this.checkAndGetValue("allowamount", ResManager.loadKDString((String)"\u5bb9\u5dee", (String)"ChechedBasicSinglePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])).toString();
        String chkeffecttype = this.checkAndGetValue("chkeffecttype", ResManager.loadKDString((String)"\u6821\u9a8c\u5f71\u54cd", (String)"ChechedBasicSinglePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])).toString();
        model.setNumber(number);
        model.setName(name);
        model.setAllowamount(Double.parseDouble(allowamount));
        model.setChkeffecttype(chkeffecttype);
        model.setModelId(this.getModelId());
        DynamicObject org = (DynamicObject)this.checkAndGetValue("org", ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"ChechedBasicSinglePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        model.setOrg(org.getLong("id"));
        boolean untemp = (Boolean)this.getModel().getValue("untemp");
        ArrayList<MultiTemplateModel> multitemplate = new ArrayList<MultiTemplateModel>(10);
        if (untemp) {
            DynamicObjectCollection template = (DynamicObjectCollection)this.checkAndGetValue("multitemplate", ResManager.loadKDString((String)"\u6a21\u677f", (String)"ChechedBasicSinglePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            Map groupId2LastTempIdMap = TemplateServiceHelper.getGroupId2LastTempIdMap((long)this.getModelId());
            for (DynamicObject dy : template) {
                MultiTemplateModel multiTemplateModel = new MultiTemplateModel(Long.valueOf(dy.getLong("fbasedataid.id")), (Long)groupId2LastTempIdMap.get(dy.getLong("fbasedataid.group")), dy.getString("fbasedataid.number"));
                multiTemplateModel.setType(dy.getDynamicObjectType());
                multiTemplateModel.setBasetype(dy.getDynamicObject("fbasedataid").getDynamicObjectType());
                multitemplate.add(multiTemplateModel);
            }
            this.getView().getParentView().getFormShowParameter().setCustomParam("aa", (Object)11);
            this.getView().getFormShowParameter().getCustomParams().put("temp", 0L);
            model.setUmtemp(true);
        } else {
            model.setUmtemp(false);
        }
        multitemplate.sort((t1, t2) -> t1.getNumber().compareToIgnoreCase(t2.getNumber()));
        model.setMultiTemplate(multitemplate);
        boolean isdistcslscheme = (Boolean)this.getModel().getValue("isdistcslscheme");
        if (isdistcslscheme) {
            model.setIsdistcslscheme(true);
            DynamicObjectCollection mulcslscheme = (DynamicObjectCollection)this.checkAndGetValue("mulcslscheme", ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u89c6\u56fe", (String)"ChechedBasicSinglePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            model.setMulCslscheme(mulcslscheme);
        } else {
            model.setMulCslscheme(new DynamicObjectCollection());
        }
        model.setDescription(this.getModel().getValue("description").toString());
        model.put("effectivedata", EffectiveYearPeriodUtil.saveEffectiveInfo(this.getModel()));
        if (model.get("effectivedata") != null && model.get("effectivedata").toString().length() > 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u603b\u7ed3\u7cbe\u7b80\u6240\u9009\u8303\u56f4\u3002", (String)"ChechedBasicSinglePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        model.setPeriodTxt(EffectiveYearPeriodUtil.buildPeriodTxt(this.getModel(), model.getModelId()));
        OrmLocaleValue ormLocaleValue = (OrmLocaleValue)this.getModel().getValue("name");
        ormLocaleValue.setLocaleValue(ormLocaleValue.getLocaleValue().trim());
        model.setMultiLangName((Object)ormLocaleValue);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        ChkFormulaModel cmodel = (ChkFormulaModel)this.deSerializedBytes((String)this.getFormCustomParam("checkmodel"));
        if (this.isNeedRecycleNumber() && !cmodel.isEdit()) {
            CodeRuleUtil.recycleCodeRuleNumber((String)"bcm_chkformulasetting", (String)"number", (String)this.getModel().getValue("number").toString(), (String)this.getModel().getValue("number").toString());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("untemp".equals(key)) {
            boolean untemp = (Boolean)e.getChangeSet()[0].getNewValue();
            if (!untemp) {
                this.getModel().setValue("multitemplate", null);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"multitemplate"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"multitemplate"});
            }
        } else if (period.equals(key)) {
            String periodIdsStr = this.getPageCache().get("periodIds");
            if (periodIdsStr != null) {
                Map map = (Map)this.deSerializedBytes(periodIdsStr);
                map.remove(this.getModel().getEntryCurrentRowIndex(entryentity));
                this.getPageCache().put("periodIds", this.toByteSerialized(map));
            }
        } else if ("isdistcslscheme".equals(key)) {
            boolean isdistcslscheme = (Boolean)e.getChangeSet()[0].getNewValue();
            if (isdistcslscheme) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"mulcslscheme"});
            } else {
                this.getModel().setValue("mulcslscheme", null);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"mulcslscheme"});
            }
        }
        int index = this.getModel().getEntryCurrentRowIndex(entryentity);
        if (year.equals(key)) {
            if (e.getChangeSet()[0].getOldValue() == null) {
                this.getModel().setValue(yearscope, (Object)YearScopeEnum.THISYEAR.getValue(), index);
                this.getView().updateView(yearscope, index);
            }
            if (e.getChangeSet()[0].getNewValue() == null) {
                this.getModel().setValue(yearscope, (Object)YearScopeEnum.ALLYEAR.getValue(), index);
                this.getView().updateView(yearscope, index);
            }
        }
        if (yearscope.equals(key)) {
            if (this.getModel().getEntryRowEntity(entryentity, index).get(year) == null) {
                this.getModel().setValue(yearscope, (Object)YearScopeEnum.ALLYEAR.getValue(), index);
                this.getView().updateView(yearscope, index);
            } else if (YearScopeEnum.ALLYEAR.getValue().equals(e.getChangeSet()[0].getNewValue())) {
                this.getModel().setValue(year, null, index);
                this.getView().updateView(year, index);
            }
        }
    }

    private Object checkAndGetValue(String sign, String name) {
        if ("name".equals(sign)) {
            OrmLocaleValue nameValue = (OrmLocaleValue)this.getModel().getValue(sign);
            if (MapUtils.isNotEmpty((Map)nameValue) && StringUtils.isNotEmpty((String)nameValue.getLocaleValue())) {
                return nameValue.getLocaleValue().trim();
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u3002", (String)"ChechedBasicSinglePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
        }
        if (this.getModel().getValue(sign) != null && StringUtils.isNotEmpty((String)this.getModel().getValue(sign).toString())) {
            if (this.getModel().getValue(sign) instanceof DynamicObjectCollection && ((DynamicObjectCollection)this.getModel().getValue(sign)).isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u3002", (String)"ChechedBasicSinglePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
            }
            return this.getModel().getValue(sign);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u3002", (String)"ChechedBasicSinglePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
    }

    private boolean isNeedRecycleNumber() {
        if ("bcm_checkedmainpage".equals(this.getView().getParentView().getEntityId())) {
            return false;
        }
        return this.getPageCache().get("needRecycleNumber") == null || Boolean.parseBoolean(this.getPageCache().get("needRecycleNumber"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        String name = arg0.getProperty().getName();
        if (year.equals(name) || period.equals(name)) {
            EffectiveYearPeriodUtil.beforeF7Select(arg0, this.getModelId(), name, this.getModel(), this.getPageCache());
        }
        if ("multitemplate".equals(name)) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter.and("templatetype", "in", Arrays.asList(String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType())));
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(filter.toArray()), "number"));
        }
    }

    @Override
    protected void initBasedataEditSingleMemberF7(String f7Key, BasedataEditSingleMemberF7 f7) {
        if ("Entity".equals(f7Key)) {
            Map<String, Object> customData = f7.getCustomData();
            if (customData == null) {
                customData = new HashMap<String, Object>(16);
                f7.setCustomData(customData);
            }
            customData.put("isShowCslScheme", "false");
        }
    }
}

