/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.CheckBox;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;

public class CheckUpChkDisplayPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final List<String> sysDims = Arrays.asList(SysDimensionEnum.Account.getNumber().toLowerCase(Locale.ENGLISH), SysDimensionEnum.Process.getNumber().toLowerCase(Locale.ENGLISH), SysDimensionEnum.AuditTrail.getNumber().toLowerCase(Locale.ENGLISH), SysDimensionEnum.ChangeType.getNumber().toLowerCase(Locale.ENGLISH));

    @Override
    public void initialize() {
        super.initialize();
        if (this.getPage(this.getView()) != null) {
            this.getPage(this.getView()).bindCtrlMapping(this.getView());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("save");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getModelId() == 0L) {
            return;
        }
        this.buildPage();
        this.setDefValue(this.getModelId());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("save".equals(key)) {
            this.save(this.getModelId());
            this.getView().close();
        }
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException((Throwable)ex, FiBcmErrorCode.create((String)""), new Object[0]);
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        Element c;
        super.onGetControl(e);
        if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(e.getKey())) != null && Element.class.isAssignableFrom(c.getClass())) {
            e.setControl(c.getControl(this.getView()));
        }
    }

    private void buildPage() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,name,issysdimension", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> sys = new HashMap<String, String>();
        HashMap<String, String> defined = new HashMap<String, String>();
        for (DynamicObject dot : col) {
            if (dot.getBoolean("issysdimension")) {
                sys.put(dot.getString("number").toLowerCase(Locale.ENGLISH), dot.getString("name"));
                continue;
            }
            defined.put(dot.getString("number").toLowerCase(Locale.ENGLISH), dot.getString("name"));
        }
        Page page = this.getPage(this.getView());
        if (page == null) {
            page = new Page();
        }
        page.addArea(this.setHalfDim(LEFT, sys, defined));
        page.addArea(this.setHalfDim(RIGHT, sys, defined));
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void setDefValue(long modelid) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_chkdisplaysetting", (String)"*", (QFilter[])new QFilter[]{qFilter}, (String)"type");
        if (col.isEmpty()) {
            this.getModel().setValue("accountleft", (Object)true);
            this.getModel().setValue("accountright", (Object)true);
            if (this.isExistChangeTypeDimension()) {
                this.getModel().setValue("changetyperight", (Object)true);
            }
        } else {
            if (col.size() == 1) {
                if (((DynamicObject)col.get(0)).getInt("type") == 1) {
                    this.getModel().setValue("accountright", (Object)true);
                    if (this.isExistChangeTypeDimension()) {
                        this.getModel().setValue("changetyperight", (Object)true);
                    }
                } else {
                    this.getModel().setValue("accountleft", (Object)true);
                }
            }
            for (DynamicObject dot : col) {
                String[] dims;
                if (StringUtils.isEmpty((CharSequence)dot.getString("selectdims"))) continue;
                for (String dim : dims = dot.getString("selectdims").split(";")) {
                    if ("audittrail".equals(dim) && !this.isExistAuditTrailDimension() || "changetype".equals(dim) && !this.isExistChangeTypeDimension()) continue;
                    this.getModel().setValue(dim + (dot.getInt("type") == 1 ? LEFT : RIGHT), (Object)true);
                }
            }
        }
    }

    private Area setHalfDim(String suffix, Map<String, String> sys, Map<String, String> defined) {
        CheckBox checkBox;
        Area area = new Area("flex" + suffix);
        for (String string : sysDims) {
            if (SysDimensionEnum.AuditTrail.getNumber().equalsIgnoreCase(string) ? !this.isExistAuditTrailDimension() : SysDimensionEnum.ChangeType.getNumber().equalsIgnoreCase(string) && !this.isExistChangeTypeDimension()) continue;
            CheckBox checkBox2 = new CheckBox(sys.get(string), string + suffix);
            area.addElement((Element)checkBox2);
        }
        if (this.checkIC(this.getModelId())) {
            checkBox = new CheckBox(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7", (String)"CheckUpChkDisplayPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "internalcompany" + suffix);
            area.addElement((Element)checkBox);
        }
        if (sys.containsKey("multigaap")) {
            checkBox = new CheckBox(ResManager.loadKDString((String)"\u51c6\u5219", (String)"CheckUpChkDisplayPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "multigaap" + suffix);
            area.addElement((Element)checkBox);
        }
        for (Map.Entry entry : defined.entrySet()) {
            CheckBox checkBox2 = new CheckBox((String)entry.getValue(), (String)entry.getKey() + suffix);
            area.addElement((Element)checkBox2);
        }
        return area;
    }

    private boolean checkIC(long modelid) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid).and(new QFilter("issysmember", "!=", (Object)1));
        return QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])new QFilter[]{qFilter});
    }

    private void save(long modelid) {
        StringBuilder lresult = new StringBuilder();
        StringBuilder rresult = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>();
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        DynamicObjectCollection dimensionCol = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())});
        HashMap<String, String> dimensionNameMap = new HashMap<String, String>();
        for (DynamicObject dot : dimensionCol) {
            dimensionNameMap.put(dot.getString("number").toLowerCase(Locale.ENGLISH), dot.getString("name"));
        }
        for (IDataEntityProperty pro : props) {
            if (!(pro instanceof BooleanProp)) continue;
            keys.add(pro.getName());
        }
        ArrayList leftNames = new ArrayList(dimensionCol.size());
        ArrayList rightNames = new ArrayList(dimensionCol.size());
        for (String key : keys) {
            String dimensionNumber;
            if (!this.getModel().getValue(key).equals(true)) continue;
            if (key.endsWith(LEFT)) {
                dimensionNumber = key.replace(LEFT, "");
                lresult.append(dimensionNumber).append(';');
                if (dimensionNameMap.get(dimensionNumber) == null) continue;
                leftNames.add(dimensionNameMap.get(dimensionNumber));
                continue;
            }
            dimensionNumber = key.replace(RIGHT, "");
            rresult.append(dimensionNumber).append(';');
            if (dimensionNameMap.get(dimensionNumber) == null) continue;
            rightNames.add(dimensionNameMap.get(dimensionNumber));
        }
        String leftLog = Joiner.on((String)",").join(leftNames);
        String rightLog = Joiner.on((String)",").join(rightNames);
        String lresultStr = lresult.length() == 0 ? "" : lresult.substring(0, lresult.length() - 1);
        String rresultStr = rresult.length() == 0 ? "" : rresult.substring(0, rresult.length() - 1);
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_chkdisplaysetting", (String)"*", (QFilter[])new QFilter[]{qFilter}, (String)"type");
        DynamicObject ldot = BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkdisplaysetting");
        DynamicObject rdot = BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkdisplaysetting");
        if (!col.isEmpty()) {
            if (col.size() == 1) {
                if (((DynamicObject)col.get(0)).getInt("type") == 1) {
                    ldot = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)col.get(0)).get("id"), (String)"bcm_chkdisplaysetting");
                } else {
                    rdot = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)col.get(0)).get("id"), (String)"bcm_chkdisplaysetting");
                }
            } else {
                ldot = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)col.get(0)).get("id"), (String)"bcm_chkdisplaysetting");
                rdot = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)col.get(1)).get("id"), (String)"bcm_chkdisplaysetting");
            }
        }
        ldot.set("type", (Object)1);
        ldot.set("selectdims", (Object)lresultStr);
        ldot.set("model", (Object)modelid);
        rdot.set("type", (Object)2);
        rdot.set("selectdims", (Object)rresultStr);
        rdot.set("model", (Object)modelid);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ldot, rdot});
        this.changeFormulas(modelid);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CheckUpChkDisplayPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            StringBuilder logBuilder = new StringBuilder();
            logBuilder.append(OpItemEnum.RPTDIMSEL.getName());
            logBuilder.append(leftLog);
            logBuilder.append(";");
            logBuilder.append(OpItemEnum.FORMULADIMSEL.getName());
            logBuilder.append(rightLog);
            logBuilder.append(";");
            logBuilder.append(OpItemEnum.SETSUCCESS.getName());
            OperationLogUtil.writeOperationLog((IFormView)parentView, (String)OpItemEnum.DIMSELECT.getName(), (String)logBuilder.toString(), (Long)this.getModelId());
        }
    }

    private void changeFormulas(long modelid) {
        DynamicObject[] cols;
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection settings = QueryServiceHelper.query((String)"bcm_chkdisplaysetting", (String)"type,selectdims", (QFilter[])new QFilter[]{qFilter});
        DynamicObject vSetting = null;
        DynamicObject chineseSettring = null;
        for (DynamicObject dot : settings) {
            if (dot.getInt("type") == 1) {
                chineseSettring = dot;
            }
            if (dot.getInt("type") != 2) continue;
            vSetting = dot;
        }
        ArrayList<String> dimList = new ArrayList<String>();
        if (chineseSettring != null) {
            dimList.addAll(Arrays.asList(chineseSettring.getString("selectdims").split(";")));
        }
        if (vSetting != null) {
            dimList.addAll(Arrays.asList(vSetting.getString("selectdims").split(";")));
        }
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dot : cols = BusinessDataServiceHelper.load((String)"bcm_chkformulasetting", (String)"id,lformulatemp,comparetype,rformulatemp,vformula,chineseformula", (QFilter[])new QFilter[]{qFilter})) {
            String vFormula = ChkFormulaServiceHelper.tranFormulasQuick((String)dot.getString("lformulatemp"), (long)modelid, (int)2, (DynamicObject)vSetting, (DynamicObjectCollection)templates) + ChkFormulaServiceHelper.changeNum2Symbol((String)dot.getString("comparetype")) + ChkFormulaServiceHelper.tranFormulasQuick((String)dot.getString("rformulatemp"), (long)modelid, (int)2, (DynamicObject)vSetting, (DynamicObjectCollection)templates);
            String chineseFormula = ChkFormulaServiceHelper.tranFormulasQuick((String)dot.getString("lformulatemp"), (long)modelid, (int)1, (DynamicObject)chineseSettring, (DynamicObjectCollection)templates) + ChkFormulaServiceHelper.changeNum2Symbol((String)dot.getString("comparetype")) + ChkFormulaServiceHelper.tranFormulasQuick((String)dot.getString("rformulatemp"), (long)modelid, (int)1, (DynamicObject)chineseSettring, (DynamicObjectCollection)templates);
            dot.set("vformula", (Object)vFormula);
            dot.set("chineseformula", (Object)chineseFormula);
        }
        SaveServiceHelper.save((DynamicObject[])cols);
    }
}

