/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.util.CheckedSettingUtil;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkMemberRangeLimitTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkMemberTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MemberRangeUtil;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import org.apache.commons.collections.CollectionUtils;

public class CheckUpChkImportPlugin
extends AbsCommonImport {
    private Long modelId;
    private HashMap<String, List<Long>> chkNum2MulTemplates = new HashMap(16);
    private HashMap<String, List<Long>> chkNum2MulCslScheme = new HashMap(16);

    private String getFieldNumberNull() {
        return ResManager.loadKDString((String)"\u5b57\u6bb5\u6240\u5f55\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"CheckUpChkImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.entityName = "bcm_chkformulasetting";
        return this;
    }

    protected boolean isForceBatch() {
        return true;
    }

    @Override
    public String getDefaultKeyFields() {
        return "number";
    }

    @Override
    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"CheckUpChkImportPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "number"));
        return items;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.modelId = LongUtil.toLong(this.ctx.getOption().get("BcmModelId"));
    }

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        JSONObject data = bill.getData();
        try {
            this.checkNotNullAndLength(data);
            Optional<DynamicObject> dbOld = this.getDbOld(bill);
            if (ImportOperateType.NEW == ImportHelper.getImportType(this.ctx)) {
                if (dbOld.isPresent()) {
                    return Optional.of(ResManager.loadKDString((String)"\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"CheckUpChkImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else if (ImportOperateType.OVERRIDE == ImportHelper.getImportType(this.ctx) && !dbOld.isPresent()) {
                return Optional.of(ResManager.loadKDString((String)"\u76f8\u540c\u540d\u79f0\u6216\u8005\u7f16\u7801\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8986\u76d6\u5931\u8d25\u3002", (String)"CheckUpChkImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.checkOrgExist(data);
            this.checkMulTemplate(data);
            this.checkRangeAndFixDim(data.getString("vrangetxt"));
            this.parseVRangeStr2MemList(data.getString("vrangetxt"), this.modelId, data);
            this.parseVDimStr2MemMap(data.getString("vfixdimtxt"), this.modelId, data);
            this.checkformulatempRight(data);
            this.checkCslScheme(data);
            this.checkeffectivedate(data);
        }
        catch (KDBizException kde) {
            return Optional.of(kde.getMessage());
        }
        return Optional.empty();
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        QFilter[] uniqueFilters = this.getUniqueFilters(rowData);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)this.entityName, (String)"id", (QFilter[])uniqueFilters);
        if (Objects.isNull(dyn)) {
            return Optional.empty();
        }
        dyn = BusinessDataServiceHelper.loadSingle((Object)dyn.get("id"), (String)this.entityName);
        return Optional.of(dyn);
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            DynamicObject dyn = this.buildDyn(billDataList.get(i));
            dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            dyn.set("createtime", (Object)TimeServiceHelper.now());
            dys[i] = dyn;
        }
        return dys;
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            DynamicObject dyn;
            dys[i] = dyn = this.buildDyn(billDataList.get(i));
        }
        return dys;
    }

    @Override
    protected void afterImport() {
        super.afterImport();
    }

    @Override
    protected Map<Object, String> buildErrorMap(List<ImportBillData> billDataList, Exception e, Map<Object, String> errorMap) {
        if (e instanceof KDBizException) {
            for (ImportBillData t : billDataList) {
                errorMap.put(t.getData().get((Object)"id"), e.getMessage());
            }
        } else {
            super.buildErrorMap(billDataList, e, errorMap);
        }
        return errorMap;
    }

    private void checkNotNullAndLength(JSONObject data) {
        String fieldNameTran = "";
        if (data.getString("number").length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u957f\u5ea6\u4e3a50\u3002", (String)"CheckUpChkImportPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (data.get((Object)"name") instanceof String && data.getString("name").length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u957f\u5ea6\u4e3a50\u3002", (String)"CheckUpChkImportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (data.get((Object)"name") instanceof Map) {
            ((HashMap)data.get((Object)"name")).forEach((k, v) -> {
                if (v.length() > 50) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u957f\u5ea6\u4e3a50\u3002", (String)"CheckUpChkImportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            });
        }
        if (ObjectUtils.isEmpty((Object)data.get((Object)"chkeffecttype"))) {
            fieldNameTran = ResManager.loadKDString((String)"\u6821\u9a8c\u5f71\u54cd", (String)"CheckUpChkImportPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckUpChkImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldNameTran));
        }
        if (ObjectUtils.isEmpty((Object)data.get((Object)"org"))) {
            fieldNameTran = ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"CheckUpChkImportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckUpChkImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldNameTran));
        }
    }

    private void checkOrgExist(JSONObject data) {
        String cslscheme;
        String orgNumber = data.getJSONObject("org").getString("number");
        IDNumberTreeNode entityNode = this.getOrgByNumberAndCslscheme(orgNumber, cslscheme = data.getJSONObject("org").getString("cslscheme"), this.modelId);
        if (entityNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u521b\u5efa\u7ec4\u7ec7\u7684\u7f16\u7801\u53ca\u521b\u5efa\u7ec4\u7ec7\u7684\u7ec4\u7ec7\u89c6\u56fe\u662f\u5426\u586b\u5199\u6b63\u786e\u3002", (String)"CheckUpChkImportPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkMulTemplate(JSONObject data) {
        JSONObject templateJson;
        String number;
        if (!ObjectUtils.isEmpty((Object)data.get((Object)"multitemplate")) && (number = (String)(templateJson = data.getJSONObject("multitemplate")).get((Object)"number")) != null) {
            HashSet<String> templateNumbers = new HashSet<String>(Arrays.asList(number.split(",")));
            List<DynamicObject> dys = this.getTemplates(templateNumbers, this.modelId);
            dys.forEach(dy -> templateNumbers.remove(dy.getString("number")));
            if (!templateNumbers.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6a21\u677f%1$s\uff0c\u4e0d\u5408\u683c\u7f16\u7801\u4e3a%2$s", (String)"CheckUpChkImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getFieldNumberNull(), templateNumbers));
            }
            Map<String, Long> templateNumber2FirstVersionId = this.templateNumber2FirstVersionId(dys);
            this.chkNum2MulTemplates.put(data.getString("number"), new ArrayList<Long>(templateNumber2FirstVersionId.values()));
        }
    }

    private void checkRangeAndFixDim(String vrangetxt) {
        if (StringUtils.isEmpty((CharSequence)vrangetxt)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u52fe\u7a3d\u6821\u9a8c\u8303\u56f4\u5fc5\u987b\u5305\u542b\u201c\u60c5\u666f-S\u201d\u3001\u201c\u7ec4\u7ec7\u9002\u7528\u8303\u56f4-ValidEntities\u201d\u6216\u201c\u4f8b\u5916\u7ec4\u7ec7\u8303\u56f4-InvalidEntities\u201d\u3002", (String)"CheckUpChkImportPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String[] split = vrangetxt.split(";");
        ArrayList<String> dims = new ArrayList<String>(split.length);
        for (String s : split) {
            if (!s.contains(":")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u52fe\u7a3d\u6821\u9a8c\u8303\u56f4\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CheckUpChkImportPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            dims.add(s.substring(0, s.indexOf(":")));
        }
        if (!dims.contains(DimTypesEnum.SCENARIO.getShortNumber()) || !dims.contains("InvalidEntities") && !dims.contains("ValidEntities")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u52fe\u7a3d\u6821\u9a8c\u8303\u56f4\u5fc5\u987b\u5305\u542b\u201c\u60c5\u666f-S\u201d\u3001\u201c\u7ec4\u7ec7\u9002\u7528\u8303\u56f4-ValidEntities\u201d\u6216\u201c\u4f8b\u5916\u7ec4\u7ec7\u8303\u56f4-InvalidEntities\u201d\u3002", (String)"CheckUpChkImportPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkformulatempRight(JSONObject data) {
        ArrayList selectdims = new ArrayList(MemberReader.getDimNumberMapNameById((long)this.modelId).keySet());
        DynamicObject chineseSettring = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_chkdisplaysetting"));
        chineseSettring.set("selectdims", (Object)String.join((CharSequence)";", selectdims));
        DynamicObjectCollection templates = this.getTemplates();
        if (ObjectUtils.isEmpty((Object)data.get((Object)"lformulatemp"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"CheckUpChkImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String msg = this.checkformulatemp(data.get((Object)"lformulatemp").toString(), this.modelId);
        String formula = data.get((Object)"lformulatemp").toString();
        if ("1".equalsIgnoreCase(msg)) {
            if (ObjectUtils.isEmpty((Object)data.get((Object)"rformulatemp"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"CheckUpChkImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            msg = this.checkformulatemp(data.get((Object)"rformulatemp").toString(), this.modelId);
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)msg) && !StringUtils.equals((CharSequence)"2", (CharSequence)msg)) {
                throw new KDBizException(msg);
            }
            if (ObjectUtils.isEmpty((Object)data.get((Object)"comparetype"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b49\u5f0f\u6821\u9a8c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckUpChkImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            formula = formula + ChkFormulaServiceHelper.changeNum2Symbol((String)data.get((Object)"comparetype").toString()) + data.get((Object)"rformulatemp").toString();
        } else if ("2".equalsIgnoreCase(msg)) {
            data.put("rformulatemp", (Object)"");
            data.put("comparetype", (Object)"");
        } else {
            throw new KDBizException(msg);
        }
        String chineseFormula = ChkFormulaServiceHelper.tranFormulasQuick((String)formula, (long)this.modelId, (int)1, null, (DynamicObjectCollection)templates);
        if (StringUtils.equals((CharSequence)chineseFormula, (CharSequence)formula)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u539f\u56e0\u3002", (String)"CheckUpChkImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        data.put("chineseFormula", (Object)chineseFormula);
    }

    private void checkCslScheme(JSONObject data) {
        JSONObject mulcslschemeJson = data.getJSONObject("mulcslscheme");
        if (mulcslschemeJson != null) {
            String number = (String)mulcslschemeJson.get((Object)"number");
            HashSet<String> cslSchemeNumbers = new HashSet<String>(Arrays.asList(number.split(",")));
            List<DynamicObject> dys = this.getCslSchemes(cslSchemeNumbers, this.modelId);
            dys.forEach(dy -> cslSchemeNumbers.remove(dy.getString("number")));
            if (!cslSchemeNumbers.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801%s\u4e0d\u5408\u683c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CheckUpChkImportPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]), cslSchemeNumbers));
            }
            List mulCslSchemes = dys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            this.chkNum2MulCslScheme.put(data.getString("number"), mulCslSchemes);
        }
    }

    private String checkformulatemp(String formula, long modelId) {
        try {
            if (!NumberUtils.isNumber((String)formula)) {
                FormulaPoolManager poolMng = ChkCheckServiceHelper.getPoolMng((String)formula);
                if (poolMng.pull("IF") != null || poolMng.pull("AND") != null || poolMng.pull("OR") != null) {
                    return "2";
                }
                if (poolMng.pull("ROUND") != null || poolMng.pull("ABS") != null) {
                    return "1";
                }
                List vformulas = poolMng.pull("V");
                List xformulas = poolMng.pull("X");
                ArrayList specificFormulas = new ArrayList();
                if (vformulas != null) {
                    specificFormulas.addAll(vformulas);
                }
                if (xformulas != null) {
                    specificFormulas.addAll(xformulas);
                }
                Map dimShortNumber2NameMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelId));
                specificFormulas.forEach(f -> ChkFormulaServiceHelper.translateChkformla((String)f.toString(), (long)modelId, (int)1, dimShortNumber -> {
                    if (!dimShortNumber2NameMap.containsKey(dimShortNumber)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ef4\u5ea6%1$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", (String)"CheckUpChkImportPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimShortNumber));
                    }
                }, (boolean)true));
            }
            return "1";
        }
        catch (KDBizException e1) {
            return e1.getMessage();
        }
        catch (Exception e) {
            return ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u7ef4\u5ea6,\u516c\u5f0f\u586b\u5199\u9519\u8bef\u3002", (String)"CheckUpChkImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
    }

    private DynamicObject buildDyn(ImportBillData billData) {
        JSONObject data = billData.getData();
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        DynamicObject dyn = importType != ImportOperateType.NEW && data.get((Object)"existingRecordDy") != null ? (DynamicObject)data.get((Object)"existingRecordDy") : BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
        Object name = data.get((Object)"name");
        if (name instanceof Map) {
            dyn.set("name", (Object)LocaleString.fromMap((Map)((Map)name)).toString().trim());
        } else {
            dyn.set("name", (Object)name.toString().trim());
        }
        dyn.set("number", data.get((Object)"number"));
        dyn.set("model", (Object)this.modelId);
        dyn.set("status", data.get((Object)"status") == null ? Integer.valueOf(1) : data.get((Object)"status"));
        dyn.set("description", data.get((Object)"description"));
        JSONObject orgJson = (JSONObject)data.get((Object)"org");
        IDNumberTreeNode org = this.getOrgByNumberAndCslscheme((String)orgJson.get((Object)"number"), (String)orgJson.get((Object)"cslscheme"), this.modelId);
        dyn.set("org", (Object)org.getId());
        dyn.set("comparetype", data.get((Object)"comparetype"));
        dyn.set("allowamount", data.get((Object)"allowamount"));
        dyn.set("chkeffecttype", data.get((Object)"chkeffecttype"));
        if (!ObjectUtils.isEmpty((Object)data.get((Object)"multitemplate"))) {
            this.setMultitemplateData(dyn, this.chkNum2MulTemplates.get(data.getString("number")));
        }
        if (!ObjectUtils.isEmpty((Object)data.get((Object)"mulcslscheme"))) {
            this.setMulCslSchemeData(dyn, this.chkNum2MulCslScheme.get(data.getString("number")));
        }
        this.setRangeDimData((Map<String, Object>)data, dyn, org, this.modelId);
        dyn.set("rangetxt", data.get((Object)"rangetxt"));
        dyn.set("fixdimtxt", data.get((Object)"fixdimtxt"));
        dyn.set("vrangetxt", data.get((Object)"vrangetxt"));
        dyn.set("vfixdimtxt", data.get((Object)"vfixdimtxt"));
        this.buildEntryentityData(dyn, (List)data.get((Object)"effectivedate"));
        String leftformula = this.cutTmp((String)data.get((Object)"lformulatemp"));
        String rightformula = this.cutTmp((String)data.get((Object)"rformulatemp"));
        DynamicObjectCollection templates = this.getTemplates();
        List<String> dimNumberList = this.getDimNumberList();
        DynamicObject dimSetting = this.getDimSetting();
        String vformula = ChkFormulaServiceHelper.tranFormulasQuick((String)((String)data.get((Object)"lformulatemp")), (long)this.modelId, (int)2, (DynamicObject)dimSetting, (DynamicObjectCollection)templates) + ChkFormulaServiceHelper.changeNum2Symbol((String)data.get((Object)"comparetype").toString()) + ChkFormulaServiceHelper.tranFormulasQuick((String)((String)data.get((Object)"rformulatemp")), (long)this.modelId, (int)2, (DynamicObject)dimSetting, (DynamicObjectCollection)templates);
        String mformula = ChkFormulaServiceHelper.tranFormulasQuick((String)((String)data.get((Object)"lformulatemp")), (long)this.modelId, (int)1, (DynamicObject)dimSetting, (DynamicObjectCollection)templates, (String)"mix") + ChkFormulaServiceHelper.changeNum2Symbol((String)data.get((Object)"comparetype").toString()) + ChkFormulaServiceHelper.tranFormulasQuick((String)((String)data.get((Object)"rformulatemp")), (long)this.modelId, (int)1, (DynamicObject)dimSetting, (DynamicObjectCollection)templates, (String)"mix");
        dyn.set("vformula", (Object)vformula);
        dyn.set("mformula", (Object)mformula);
        dyn.set("chineseformula", data.get((Object)"chineseformula"));
        dyn.set("leftformula", (Object)leftformula);
        dyn.set("lformulatemp", data.get((Object)"lformulatemp"));
        dyn.set("rightformula", (Object)rightformula);
        dyn.set("rformulatemp", data.get((Object)"rformulatemp"));
        dyn.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dyn.set("modifytime", (Object)TimeServiceHelper.now());
        return dyn;
    }

    private void setRangeDimData(Map<String, Object> data, DynamicObject dyn, IDNumberTreeNode org, long modelId) {
        DynamicObject mementry;
        DynamicObjectCollection mem = dyn.getDynamicObjectCollection("memberrange");
        if (!mem.isEmpty()) {
            mem.clear();
        }
        String vrangetxt = (String)data.get("vrangetxt");
        List vrangeDimList = (List)data.get("vrangeDimList");
        Map vfixDimMap = (Map)data.get("vfixDimMap");
        AtomicBoolean hasOrg = new AtomicBoolean(false);
        AtomicBoolean hasBp = new AtomicBoolean(false);
        long orgDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        long scenDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Scenario");
        long bpDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Process");
        vrangeDimList.forEach(memEntry -> {
            DynamicObject mementry = mem.addNew();
            mementry.set("memberid", memEntry.get("memberid"));
            mementry.set("membbound", memEntry.get("membbound"));
            mementry.set("dimension", memEntry.get("dimension"));
            mementry.set("membboundtype", memEntry.get("membboundtype"));
            mementry.set("limittype", memEntry.get("limittype"));
            mementry.set("propertyid", memEntry.get("propertyid"));
            if (LongUtil.toLong(memEntry.get("dimension")) == bpDimId) {
                hasBp.set(true);
            }
            if (LongUtil.toLong(memEntry.get("dimension")) == orgDimId && ChkMemberRangeLimitTypeEnum.INBOUND.getLimitType().equals(memEntry.get("limittype"))) {
                hasOrg.set(true);
            }
        });
        if (!hasOrg.get()) {
            mementry = mem.addNew();
            mementry.set("memberid", (Object)org.getId());
            mementry.set("membbound", (Object)40);
            mementry.set("dimension", (Object)orgDimId);
            mementry.set("membboundtype", (Object)ChkMemberTypeEnum.DIMENSION.getMemberType());
            mementry.set("limittype", (Object)ChkMemberRangeLimitTypeEnum.INBOUND.getLimitType());
            vrangetxt = String.format("ValidEntities:idescendants[%s];", org.getNumber()) + vrangetxt;
            data.put("vrangetxt", vrangetxt);
        }
        if (vfixDimMap != null) {
            vfixDimMap.forEach((key, value) -> {
                if (key == scenDimId || key == bpDimId) {
                    mem.removeIf(e -> e.getLong("dimension") == key.longValue());
                    this.changeTxt(data, key == scenDimId ? 0 : 1);
                    if (key == bpDimId) {
                        hasBp.set(true);
                    }
                }
                value.forEach((id, propertyMap) -> {
                    DynamicObject mementry = mem.addNew();
                    if (key == scenDimId || key == bpDimId) {
                        mementry.set("limittype", (Object)ChkMemberRangeLimitTypeEnum.INBOUND.getLimitType());
                    } else {
                        mementry.set("limittype", (Object)ChkMemberRangeLimitTypeEnum.COMMON.getLimitType());
                    }
                    mementry.set("memberid", id);
                    mementry.set("membbound", propertyMap.get("membbound"));
                    mementry.set("dimension", key);
                    mementry.set("membboundtype", propertyMap.get("membboundtype"));
                    mementry.set("propertyid", propertyMap.get("propertyid"));
                });
            });
        }
        if (!hasBp.get()) {
            mementry = mem.addNew();
            mementry.set("memberid", (Object)MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"ERpt").getId());
            mementry.set("membbound", (Object)10);
            mementry.set("dimension", (Object)bpDimId);
            mementry.set("membboundtype", (Object)ChkMemberTypeEnum.DIMENSION.getMemberType());
            mementry.set("limittype", (Object)ChkMemberRangeLimitTypeEnum.INBOUND.getLimitType());
            vrangetxt = String.format("%sBP:[ERpt];", vrangetxt);
            data.put("vrangetxt", vrangetxt);
        }
        data.put("rangetxt", this.buildRangeTxt(vrangeDimList));
        data.put("fixdimtxt", this.bulidFixDimTxt(vfixDimMap));
        dyn.set("mfixdimtxt", (Object)this.buildMtxt(vfixDimMap));
    }

    private void buildEntryentityData(DynamicObject dyn, List<Map<String, Object>> effectivedate) {
        DynamicObjectCollection entry = dyn.getDynamicObjectCollection("effective");
        if (!entry.isEmpty()) {
            entry.clear();
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        String seqKey = "";
        String newSeqKey = "";
        for (Map<String, Object> p : effectivedate) {
            DynamicObject newEntryObj = entry.addNew();
            newEntryObj.set("applytype", p.get("applytype"));
            sb.append("1".equals(p.get("applytype").toString()) ? ResManager.loadKDString((String)"\u9002\u7528", (String)"CheckUpChkImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f8b\u5916", (String)"CheckUpChkImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            IDNumberTreeNode year = (IDNumberTreeNode)p.get("effectiveyear");
            if (!ObjectUtils.isEmpty((Object)year) && year != IDNumberTreeNode.NotFoundTreeNode) {
                newEntryObj.set("effectiveyear", (Object)year.getId());
                sb.append(year.getName());
            }
            newEntryObj.set("yearscope", ObjectUtils.isEmpty((Object)p.get("yearscope")) ? Integer.valueOf(2) : p.get("yearscope"));
            switch (p.get("yearscope") + "") {
                case "3": {
                    sb.append(ResManager.loadKDString((String)"\u5df2\u9009\u53ca\u4e4b\u524d\u8d22\u5e74", (String)"CheckUpChkImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "4": {
                    sb.append(ResManager.loadKDString((String)"\u5df2\u9009\u53ca\u4e4b\u540e\u8d22\u5e74", (String)"CheckUpChkImportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    sb.append(ResManager.loadKDString((String)"\u4ec5\u5df2\u9009\u8d22\u5e74", (String)"CheckUpChkImportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            IDNumberTreeNode period = (IDNumberTreeNode)p.get("effectiveperiod");
            if (!ObjectUtils.isEmpty((Object)period) && period != IDNumberTreeNode.NotFoundTreeNode) {
                newEntryObj.set("effectiveperiod", (Object)period.getId());
                sb.append(period.getName());
            }
            sb.append(';');
            newSeqKey = "" + p.get("applytype") + "@" + (!ObjectUtils.isEmpty((Object)year) ? year.getId() : "") + "@" + p.get("yearscope");
            if (!seqKey.equals(newSeqKey)) {
                ++i;
                seqKey = newSeqKey;
            }
            newEntryObj.set("seq", (Object)i);
        }
        dyn.set("periodtxt", (Object)sb.toString());
    }

    private void checkeffectivedate(JSONObject data) {
        JSONArray effectiveJson = data.getJSONArray("effective");
        ArrayList effectivedate = new ArrayList(effectiveJson.size());
        if (effectiveJson != null) {
            String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
            for (Object entryJson : effectiveJson) {
                HashMap<String, Object> effectivedateMap = new HashMap<String, Object>();
                Object applytype = ((JSONObject)entryJson).get((Object)"applytype");
                Object yearscope = ((JSONObject)entryJson).get((Object)"yearscope");
                if (ObjectUtils.isEmpty((Object)applytype) && ObjectUtils.isEmpty((Object)yearscope)) continue;
                if (ObjectUtils.isEmpty((Object)applytype) || ObjectUtils.isEmpty((Object)yearscope)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5206\u7ec4\u540d\u79f0\uff0c\u8d22\u5e74\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckUpChkImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                effectivedateMap.put("applytype", applytype);
                effectivedateMap.put("yearscope", yearscope);
                JSONObject yearJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveyear");
                JSONObject periodJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveperiod");
                IDNumberTreeNode year = null;
                IDNumberTreeNode period = null;
                if (yearJson != null) {
                    year = MemberReader.findFyMemberByNum((String)modelNum, (String)yearJson.getString("number"));
                    if (year == IDNumberTreeNode.NotFoundTreeNode) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u7f16\u7801\u4e0d\u5b58\u5728", (String)"CheckUpChkImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    effectivedateMap.put("effectiveyear", year);
                }
                if (periodJson != null) {
                    period = MemberReader.findPeriodMemberByNum((String)modelNum, (String)periodJson.getString("number"));
                    if (period == IDNumberTreeNode.NotFoundTreeNode) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"CheckUpChkImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    effectivedateMap.put("effectiveperiod", period);
                }
                if (ObjectUtils.isEmpty(year) && ObjectUtils.isEmpty(period)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"CheckUpChkImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                effectivedate.add(effectivedateMap);
            }
            data.put("effectivedate", effectivedate);
        }
    }

    private void parseVRangeStr2MemList(String vrangetxt, long modelId, JSONObject data) {
        String[] dimArray;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vrangetxt)) {
            return;
        }
        int index = (vrangetxt = vrangetxt.replace(" ", "")).indexOf(58);
        if (index == -1) {
            return;
        }
        ArrayList rangeDimList = new ArrayList(10);
        Map dimNum2DimMap = MemberReader.getDimDyoByModelId((long)modelId);
        String modelnum = MemberReader.findModelNumberById((Object)modelId);
        Map dimShortNum2NumMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelnum);
        for (String dimstr : dimArray = vrangetxt.split(";")) {
            String[] memberArray;
            String limitType;
            int indexOf = dimstr.indexOf(":");
            if (indexOf == -1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u52fe\u7a3d\u6821\u9a8c\u8303\u56f4\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CheckUpChkImportPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String dimShortnumber = dimstr.substring(0, indexOf);
            String string = limitType = "InvalidEntities".equals(dimShortnumber) ? "2" : "1";
            if ("ValidEntities".equals(dimShortnumber) || "InvalidEntities".equals(dimShortnumber)) {
                dimShortnumber = DimTypesEnum.ENTITY.getShortNumber();
            }
            if (!dimShortNum2NumMap.containsKey(dimShortnumber)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u7ef4\u5ea6\u7b80\u7801\u4e3a%s\u7684\u7ef4\u5ea6\u3002", (String)"CheckUpChkImportPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimShortnumber));
            }
            String dimMemberStr = dimstr.substring(dimstr.indexOf(":") + 1);
            for (String memberStr : memberArray = dimMemberStr.split(",")) {
                String membBoundType;
                IDNumberTreeNode member;
                HashMap<String, Object> chkMemEntry = new HashMap<String, Object>(16);
                DynamicObject dimension = (DynamicObject)dimNum2DimMap.get(dimShortNum2NumMap.get(dimShortnumber));
                String memberNumber = memberStr.substring(memberStr.indexOf("[") + 1, memberStr.indexOf("]"));
                chkMemEntry.put("dimension", dimension.get("id"));
                if (!memberNumber.contains(":")) {
                    member = MemberReader.findMemberByNumber((String)modelnum, (String)dimension.getString("number"), (String)memberNumber);
                    if (member.getId() == -1L) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"CheckUpChkImportPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimension.get("number"), memberNumber));
                    }
                    membBoundType = ChkMemberTypeEnum.DIMENSION.getMemberType();
                    chkMemEntry.put("memberid", member.getId());
                    chkMemEntry.put("membname", member.getName());
                    chkMemEntry.put("membnumber", member.getNumber());
                } else {
                    membBoundType = ChkMemberTypeEnum.PROPERTY.getMemberType();
                    memberNumber = memberNumber.substring(memberNumber.indexOf(":") + 1);
                    member = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"id,propertyid,name,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)memberNumber)});
                    if (member == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u4e2d\u6ca1\u6709\u7f16\u7801\u4e3a%3$s\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u6210\u5458\u3002", (String)"CheckUpChkImportPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimension.get("number"), memberNumber));
                    }
                    DynamicObject custProp = QueryServiceHelper.queryOne((String)"bcm_definedproperty", (String)"id,name,number", (QFilter[])new QFilter("id", "=", (Object)member.getLong("propertyid")).toArray());
                    chkMemEntry.put("memberid", member.getLong("id"));
                    chkMemEntry.put("propertyid", member.getLong("propertyid"));
                    chkMemEntry.put("membname", custProp.getString("name") + ":" + member.getString("name"));
                    chkMemEntry.put("membnumber", custProp.getString("number") + ":" + member.getString("number"));
                }
                chkMemEntry.put("membbound", MemberRangeUtil.covertRangeNumber((String)memberStr.substring(0, memberStr.indexOf("["))));
                chkMemEntry.put("limittype", limitType);
                chkMemEntry.put("membboundtype", membBoundType);
                rangeDimList.add(chkMemEntry);
            }
        }
        data.put("vrangeDimList", rangeDimList);
    }

    private void parseVDimStr2MemMap(String vfixdimtxt, long modelId, JSONObject data) {
        String[] dimArray;
        if (vfixdimtxt == null) {
            return;
        }
        int indexOf = vfixdimtxt.indexOf(58);
        if (indexOf == -1) {
            return;
        }
        HashMap vfixDimMap = new HashMap(16);
        Map dimNum2DimMap = MemberReader.getDimDyoByModelId((long)modelId);
        String modelnum = MemberReader.findModelNumberById((Object)modelId);
        Map dimShortNum2NumMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelnum);
        for (String dimstr : dimArray = vfixdimtxt.split(";")) {
            int index = dimstr.indexOf(":");
            if (index == -1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u516c\u5f0f\u9002\u7528\u7ef4\u5ea6\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CheckUpChkImportPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String dimShortnumber = dimstr.substring(0, index);
            if (!dimShortNum2NumMap.containsKey(dimShortnumber)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u7ef4\u5ea6\u7b80\u7801\u4e3a%s\u7684\u7ef4\u5ea6\u3002", (String)"CheckUpChkImportPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimShortnumber));
            }
            String dimMemberStr = dimstr.substring(dimstr.indexOf(":") + 1);
            DynamicObject dimension = (DynamicObject)dimNum2DimMap.get(dimShortNum2NumMap.get(dimShortnumber));
            String[] memberArray = dimMemberStr.split(",");
            HashMap map = new HashMap();
            for (String memberStr : memberArray) {
                IDNumberTreeNode member;
                HashMap<String, Object> chkMemEntry = new HashMap<String, Object>(16);
                String memberNumber = memberStr.substring(memberStr.indexOf("[") + 1, memberStr.indexOf("]"));
                if (!memberNumber.contains(":")) {
                    member = MemberReader.findMemberByNumber((String)modelnum, (String)dimension.getString("number"), (String)memberNumber);
                    if (member.getId() == -1L) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"CheckUpChkImportPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimension.get("number"), memberNumber));
                    }
                    chkMemEntry.put("number", member.getNumber());
                    chkMemEntry.put("name", member.getName());
                    chkMemEntry.put("membbound", MemberRangeUtil.covertRangeNumber((String)memberStr.substring(0, memberStr.indexOf("["))));
                    chkMemEntry.put("membboundtype", ChkMemberTypeEnum.DIMENSION.getMemberType());
                    map.put(member.getId(), chkMemEntry);
                    continue;
                }
                memberNumber = memberNumber.substring(memberNumber.indexOf(":") + 1);
                member = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"id,propertyid,name,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)memberNumber)});
                if (member == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u4e2d\u6ca1\u6709\u7f16\u7801\u4e3a%3$s\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u6210\u5458\u3002", (String)"CheckUpChkImportPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimension.get("number"), memberNumber));
                }
                DynamicObject custProp = QueryServiceHelper.queryOne((String)"bcm_definedproperty", (String)"id,name,number", (QFilter[])new QFilter("id", "=", (Object)member.getLong("propertyid")).toArray());
                chkMemEntry.put("number", custProp.getString("number") + ":" + member.getString("number"));
                chkMemEntry.put("name", custProp.getString("name") + ":" + member.getString("name"));
                chkMemEntry.put("membbound", MemberRangeUtil.covertRangeNumber((String)memberStr.substring(0, memberStr.indexOf("["))));
                chkMemEntry.put("membboundtype", ChkMemberTypeEnum.PROPERTY.getMemberType());
                chkMemEntry.put("propertyid", member.getLong("propertyid"));
                map.put(member.getLong("id"), chkMemEntry);
            }
            vfixDimMap.put(dimension.getLong("id"), map);
        }
        data.put("vfixDimMap", vfixDimMap);
    }

    private void changeTxt(Map<String, Object> data, int type) {
        int fdEnd;
        int rgEnd;
        int offset;
        String subTxt;
        String rangetxt = (String)data.get("rangetxt");
        String fixdimtxt = (String)data.get("fixdimtxt");
        String dimName = type == 0 ? ResManager.loadKDString((String)"\u60c5\u666f", (String)"CheckUpChkImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8fc7\u7a0b", (String)"CheckUpChkImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        int rgBegin = rangetxt.indexOf(dimName);
        int nextDimIndex = rangetxt.indexOf(":", rgBegin + dimName.length() + 1) + 1;
        if (rgBegin > 0 && nextDimIndex > 0) {
            subTxt = rangetxt.substring(rgBegin, nextDimIndex);
            offset = subTxt.lastIndexOf(":") - subTxt.lastIndexOf(";");
            rgEnd = nextDimIndex - offset;
        } else {
            rgEnd = rangetxt.length();
        }
        int fdBegin = fixdimtxt.indexOf(dimName);
        nextDimIndex = fixdimtxt.indexOf(":", fdBegin + dimName.length() + 1) + 1;
        if (nextDimIndex > 0) {
            subTxt = fixdimtxt.substring(fdBegin, nextDimIndex);
            offset = subTxt.lastIndexOf(":") - subTxt.lastIndexOf(";");
            fdEnd = nextDimIndex - offset;
        } else {
            fdEnd = fixdimtxt.length();
        }
        rangetxt = rgBegin > 0 ? rangetxt.replace(rangetxt.substring(rgBegin, rgEnd), fixdimtxt.substring(fdBegin, fdEnd)) : rangetxt + fixdimtxt.substring(fdBegin, fdEnd);
        fixdimtxt = fixdimtxt.replace(fixdimtxt.substring(fdBegin, fdEnd), "");
        data.put("rangetxt", rangetxt);
        data.put("fixdimtxt", fixdimtxt);
    }

    private String cutTmp(String rightFormular) {
        while (rightFormular.contains("\"@TMP.")) {
            rightFormular = this.cutStr(rightFormular, "\"@TMP.");
        }
        return rightFormular;
    }

    private String cutStr(String r, String string) {
        if (r.contains(string)) {
            int j;
            int i = r.indexOf(string);
            for (j = i + 1; j < r.length() && r.charAt(j) != '\"'; ++j) {
            }
            if (r.charAt(++j) != ',') {
                --i;
            } else {
                ++j;
            }
            String tmpNum = r.substring(i + string.length(), j - 2);
            String tmp = r.substring(0, i) + r.substring(j, r.length());
            if (tmp.contains(string)) {
                return this.cutStr(tmp, string);
            }
            return tmp;
        }
        return r;
    }

    private void setMultitemplateData(DynamicObject dyn, List<Long> multitemplates) {
        if (CollectionUtils.isEmpty(multitemplates)) {
            return;
        }
        DynamicObjectCollection entry = dyn.getDynamicObjectCollection("multitemplate");
        if (!entry.isEmpty()) {
            entry.clear();
        }
        multitemplates.forEach(multitemplate -> {
            DynamicObject newEntryObj = entry.addNew();
            newEntryObj.set("fbasedataid_id", multitemplate);
        });
    }

    private void setMulCslSchemeData(DynamicObject dyn, List<Long> mulCslSchemes) {
        if (CollectionUtils.isEmpty(mulCslSchemes)) {
            return;
        }
        DynamicObjectCollection entry = dyn.getDynamicObjectCollection("mulcslscheme");
        if (!entry.isEmpty()) {
            entry.clear();
        }
        mulCslSchemes.forEach(mulCslScheme -> {
            DynamicObject newEntryObj = entry.addNew();
            newEntryObj.set("fbasedataid_id", mulCslScheme);
        });
    }

    private String buildMtxt(Map<Long, Map<Long, Map<String, Object>>> dimMap) {
        if (dimMap == null) {
            return "";
        }
        StringBuilder rangeTxt = new StringBuilder();
        dimMap.forEach((dimensionId, dimPropertyMap) -> {
            String dimNum = MemberReader.getDimensionNumById((long)dimensionId);
            String dimName = MemberReader.getDimensionNameById((long)dimensionId);
            if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
                rangeTxt.append(DimTypesEnum.ENTITY.getShortNumber()).append("-").append(DimTypesEnum.ENTITY.getName()).append("@{");
            } else {
                rangeTxt.append(dimNum).append("-").append(dimName).append("@{");
            }
            dimPropertyMap.forEach((k, v) -> {
                String number = v.get("number").toString();
                String name = v.get("name").toString();
                int scope = Integer.parseInt(v.get("membbound").toString());
                RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)scope);
                if (scope == RangeEnum.VALUE_10.getValue() || "".equals(rangeEnum.getNumber())) {
                    rangeTxt.append(number).append("-").append(name);
                } else {
                    rangeTxt.append(number).append("-").append(name).append("@").append(rangeEnum.getNumber()).append("-").append(rangeEnum.getName());
                }
                rangeTxt.append(";");
            });
            if (rangeTxt.length() > 0) {
                rangeTxt.deleteCharAt(rangeTxt.length() - 1).append("};").append(' ');
            }
        });
        return rangeTxt.toString();
    }

    private String buildRangeTxt(List<Map<String, Object>> rangMemList) {
        StringBuilder rangetxt = new StringBuilder();
        StringBuilder entityRangetxt = new StringBuilder();
        StringBuilder excludeEntityRangetxt = new StringBuilder();
        StringBuilder processRangetxt = new StringBuilder();
        Map<String, List<Map>> dim2RangListMap = rangMemList.stream().collect(Collectors.groupingBy(m -> m.get("dimension") + (String)m.get("limittype")));
        dim2RangListMap.forEach((k, rangeMap) -> {
            long dimensionId = Long.parseLong(k.substring(0, k.length() - 1));
            int limitType = Integer.parseInt(k.substring(k.length() - 1));
            String dimNum = MemberReader.getDimensionNumById((long)dimensionId);
            if (DimTypesEnum.ENTITY.getNumber().equals(dimNum) && limitType != 1) {
                this.appendByDim(excludeEntityRangetxt, (List<Map<String, Object>>)rangeMap, limitType, dimNum);
            } else if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
                this.appendByDim(entityRangetxt, (List<Map<String, Object>>)rangeMap, limitType, dimNum);
            } else if (DimTypesEnum.SCENARIO.getNumber().equals(dimNum)) {
                this.appendByDim(rangetxt, (List<Map<String, Object>>)rangeMap, limitType, dimNum);
            } else if (DimTypesEnum.PROCESS.getNumber().equals(dimNum)) {
                this.appendByDim(processRangetxt, (List<Map<String, Object>>)rangeMap, limitType, dimNum);
            }
        });
        return rangetxt.append((CharSequence)entityRangetxt).append((CharSequence)excludeEntityRangetxt).append((CharSequence)processRangetxt).toString();
    }

    private void appendByDim(StringBuilder singleRangetxt, List<Map<String, Object>> rangeMap, int limitType, String dimNum) {
        singleRangetxt.append(CheckedSettingUtil.convertDim2ChkRange((String)dimNum, (int)limitType)).append(":");
        ArrayList membList = new ArrayList(rangeMap.size());
        rangeMap.forEach(r -> {
            String membstr = MemberRangeUtil.getMemberRangeStr((String)r.get("membname").toString(), (int)((Integer)r.get("membbound")));
            membList.add(membstr);
        });
        singleRangetxt.append(String.join((CharSequence)",", membList)).append(";").append(" ");
    }

    private String bulidFixDimTxt(Map<Long, Map<Long, Map<String, Object>>> dimMap) {
        StringBuilder fixdimTxt = new StringBuilder();
        if (dimMap == null) {
            return "";
        }
        dimMap.forEach((dimensionId, membMap) -> {
            String dimName = MemberReader.getDimensionNameById((long)dimensionId);
            fixdimTxt.append(dimName).append(":");
            ArrayList membList = new ArrayList(membMap.size());
            membMap.forEach((k, v) -> {
                String membstr = MemberRangeUtil.getMemberRangeStr((String)v.get("name").toString(), (int)((Integer)v.get("membbound")));
                membList.add(membstr);
            });
            fixdimTxt.append(String.join((CharSequence)",", membList)).append(";");
        });
        return fixdimTxt.toString();
    }

    private IDNumberTreeNode getOrgByNumberAndCslscheme(String number, String cslschemeNumber, long modelId) {
        if (StringUtils.isEmpty((CharSequence)cslschemeNumber) && !"Entity".equals(number)) {
            return IDNumberTreeNode.NotFoundTreeNode;
        }
        IDNumberTreeNode org = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)number);
        if (IDNumberTreeNode.NotFoundTreeNode == org || "Entity".equals(number) || cslschemeNumber.equals(org.getProperty("cslscheme").toString())) {
            return org;
        }
        return org.getShareNodes().stream().filter(o -> cslschemeNumber.equals(o.getProperty("cslscheme").toString())).findAny().orElse(IDNumberTreeNode.NotFoundTreeNode);
    }

    private Map<String, Long> templateNumber2FirstVersionId(List<DynamicObject> dys) {
        HashMap<String, Long> templateNumber2FirstVersionId = new HashMap<String, Long>();
        Map<String, List<DynamicObject>> map = dys.stream().collect(Collectors.groupingBy(dy -> dy.getString("number")));
        map.forEach((number, list) -> list.sort(Comparator.comparingInt(dy -> dy.getInt("versionnumber"))));
        map.forEach((number, list) -> {
            if (1 == ((DynamicObject)list.get(0)).getInt("versionnumber")) {
                templateNumber2FirstVersionId.put((String)number, ((DynamicObject)list.get(0)).getLong("id"));
            } else {
                templateNumber2FirstVersionId.put((String)number, ((DynamicObject)list.get(list.size() - 1)).getLong("id"));
            }
        });
        return templateNumber2FirstVersionId;
    }

    private QFilter[] getUniqueFilters(ImportBillData rowdata) {
        JSONObject data = rowdata.getData();
        QFilter modelFilter = new QFilter("model", "=", (Object)this.modelId);
        QFilter qf = new QFilter("number", "=", (Object)data.getString("number"));
        return new QFilter[]{modelFilter, qf};
    }

    private DynamicObjectCollection getDimensions(Long modelId) {
        return (DynamicObjectCollection)ThreadCache.get((Object)("chk_importbcm_dimension" + modelId), () -> QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}));
    }

    private List<DynamicObject> getTemplates(Set<String> templateNumbers, Long modelId) {
        DynamicObjectCollection templates = this.getTemplates();
        return templates.stream().filter(dy -> {
            boolean isAllowedType = !String.valueOf(TemplateTypeEnum.MSN.getType()).equals(dy.getString("templatetype")) && !String.valueOf(TemplateTypeEnum.OTHERWP.getType()).equals(dy.getString("templatetype"));
            return templateNumbers.contains(dy.getString("number")) && isAllowedType;
        }).collect(Collectors.toList());
    }

    private DynamicObjectCollection getTemplates() {
        return (DynamicObjectCollection)ThreadCache.get((Object)("chk_importbcm_templateentity" + this.modelId), () -> QueryServiceHelper.query((String)"bcm_templateentity", (String)"templatetype,number,name,id,versionnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.modelId)}));
    }

    private DynamicObjectCollection getCslSchemes() {
        return (DynamicObjectCollection)ThreadCache.get((Object)("chk_importbcm_cslscheme" + this.modelId), () -> QueryServiceHelper.query((String)"bcm_cslscheme", (String)"number,name,id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.modelId)}));
    }

    private List<DynamicObject> getCslSchemes(Set<String> cslSchemeNumbers, Long modelId) {
        DynamicObjectCollection cslSchemes = this.getCslSchemes();
        return cslSchemes.stream().filter(dy -> cslSchemeNumbers.contains(dy.getString("number"))).collect(Collectors.toList());
    }

    private DynamicObject getDimSetting() {
        return (DynamicObject)ThreadCache.get((Object)("chk_importbcm_chkdisplaysetting" + this.modelId + "getDimSetting"), () -> ChkCheckServiceHelper.getDimSetting((QFilter)new QFilter("model", "=", (Object)this.modelId)));
    }

    private List<String> getDimNumberList() {
        return (List)ThreadCache.get((Object)("chk_importbcm_chkdisplaysetting" + this.modelId + "getDimNumberList"), () -> {
            ArrayList dimNumberList = new ArrayList();
            ChkCheckServiceHelper.getDimSetting((QFilter)new QFilter("model", "=", (Object)this.modelId), dimNumberList);
            return dimNumberList;
        });
    }
}

