/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.chkcheck.model.ChkStatusBuilder;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckReportListHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckStatusHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckTaskHelper;
import kd.fi.bcm.business.chkcheck.util.DimMemberQueryUtil;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.export.strategy.ChkCheckReportExportStrategy;
import kd.fi.bcm.business.export.strategy.ExportExecuteStrategyContext;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKCheckEffectEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkSourceEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.checkupchk.AbstractChkListPlugin;
import kd.fi.bcm.formplugin.checkupchk.util.ChkReportJump2CellUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CheckUpChkReportPlugin
extends AbstractChkListPlugin
implements CreateListColumnsListener {
    private static final String process = "process";
    protected static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");
    private static final String IS_CONTAIN_READONLY_ORG = "isContainReadOnlyOrg";
    private static final String FORCE_PASS_IDS = "forcePassIds";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(CheckUpChkReportPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener(this::setFilter);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addPackageDataListener(this::packageData);
        billList.addListHyperLinkClickListener(this::hyperLinkClick);
        billList.addHyperClickListener(this::hyperLink);
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.getContext();
        fc.setBillFormId("bcm_chkreport");
    }

    private DynamicObject queryChkSetting(long chkid) {
        if (ThreadCache.exists((Object)(chkid + "bcm_chkformulasetting"))) {
            return (DynamicObject)ThreadCache.get((Object)(chkid + "bcm_chkformulasetting"));
        }
        String selectFields = "vformula,chineseformula,mformula,fixdimtxt,vfixdimtxt,mfixdimtxt";
        QFilter qFilters = new QFilter("id", "=", (Object)chkid);
        DynamicObject chksetting = QueryServiceHelper.queryOne((String)"bcm_chkformulasetting", (String)selectFields, (QFilter[])qFilters.toArray());
        ThreadCache.put((Object)(chkid + "bcm_chkformulasetting"), (Object)chksetting);
        return chksetting;
    }

    @Override
    public boolean isSingleF7() {
        return true;
    }

    @SDKMark
    public void hyperLink(HyperLinkClickEvent arg0) {
        FormShowParameter formShowParameter;
        OPDescMultiLangEnumBridge opDescription = null;
        if (this.getModel().getValue("cslscheme") == null && this.isCM()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CheckUpChkReportPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if ("note".equals(arg0.getFieldName())) {
            formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("bcm_chknoteedit");
            formShowParameter.setCustomParam("id", ((BillList)arg0.getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue());
            formShowParameter.setCustomParam("cslschemeId", (Object)this.getCslschemeId());
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_chkreport", (String)"id,chkformula.number,chkresulttype", (QFilter[])new QFilter[]{this.getQFilter(), new QFilter("chkformula.status", "=", (Object)CHKFormulaStatusEnum.enable.getIndex())}, (String)"chkresulttype desc, chkformula.number");
            List ids = doc.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
            formShowParameter.setCustomParam("ids", (Object)SerializationUtils.toJsonString(ids));
            formShowParameter.setCustomParam(IS_CONTAIN_READONLY_ORG, (Object)this.getView().getPageCache().get(IS_CONTAIN_READONLY_ORG));
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            CloseCallBack cb = new CloseCallBack((IFormPlugin)this, "bcm_chknoteedit");
            formShowParameter.setCloseCallBack(cb);
            this.getView().showForm(formShowParameter);
            opDescription = new OPDescMultiLangEnumBridge("\u67e5\u770b\u6279\u6ce8\u6210\u529f", "CheckUpChkReportPlugin_1", "fi-bcm-formplugin", null);
        } else if ("chkformula_number".equals(arg0.getFieldName())) {
            formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("bcm_chknoteedit_inh");
            formShowParameter.setCustomParam("id", ((BillList)arg0.getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue());
            QFilter filter = this.getQFilter();
            formShowParameter.setCustomParam("filter", (Object)ObjectSerialUtil.toByteSerialized((Object)new QFilter[]{filter}));
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            this.getView().showForm(formShowParameter);
            opDescription = new OPDescMultiLangEnumBridge("\u67e5\u770b\u6210\u529f", "CheckUpChkReportPlugin_2", "fi-bcm-formplugin", null);
        } else if ("rightresult".equals(arg0.getFieldName())) {
            opDescription = new OPDescMultiLangEnumBridge("\u67e5\u770b\u5de6\u7b49\u5f0f\u7ed3\u679c\u6210\u529f\u3002", "CheckUpChkReportPlugin_3", "fi-bcm-formplugin", null);
        } else if ("leftresult".equals(arg0.getFieldName())) {
            opDescription = new OPDescMultiLangEnumBridge("\u67e5\u770b\u53f3\u7b49\u5f0f\u7ed3\u679c\u6210\u529f\u3002", "CheckUpChkReportPlugin_4", "fi-bcm-formplugin", null);
        }
        if (opDescription != null) {
            Map<String, List<String>> map = this.getlogMessageMap();
            OPDescMultiLangEnumBridge finalOpDescriotion = opDescription;
            map.forEach((key, value) -> {
                String number = (String)value.get(0);
                String name = (String)value.get(1);
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u67e5\u770b", "CheckUpChkReportPlugin_5", "fi-bcm-formplugin", "Query"), OPDescMultiLangEnumBridge.genUnTransBridge((String)String.format("%s %s,%s", number, name, finalOpDescriotion.getLocaleString())));
            });
        }
    }

    private long getCslschemeId() {
        return this.getModel().getValue("cslscheme") == null ? 0L : ((DynamicObject)this.getModel().getValue("cslscheme")).getLong("id");
    }

    public void createListColumns(BeforeCreateListColumnsArgs e) {
        ChkCheckReportListHelper.createListColumns((BeforeCreateListColumnsArgs)e);
    }

    public void packageData(PackageDataEvent e) {
        ChkCheckReportListHelper.packageData((PackageDataEvent)e);
        Map number2realName = (Map)ThreadCache.get((Object)"bcm_chkreportorgrealnames", () -> (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("orgrealnames")));
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            IDNumberTreeNode node;
            long processId;
            String showType;
            DynamicObject chksetting;
            String key = ((ColumnDesc)e.getSource()).getKey();
            long chkid = e.getRowData().getLong("chkformula.id");
            if ("mapdim".equals(key)) {
                chksetting = this.queryChkSetting(chkid);
                showType = this.getPageCache().get("showType");
                if ("name".equals(showType)) {
                    e.setFormatValue((Object)chksetting.getString("fixdimtxt"));
                } else if ("number".equals(showType)) {
                    e.setFormatValue((Object)chksetting.getString("vfixdimtxt"));
                } else if ("mix".equals(showType)) {
                    e.setFormatValue((Object)chksetting.getString("mfixdimtxt"));
                }
            }
            if ("chkformula.chineseformula".equals(key) || "chineseformula".equals(key)) {
                chksetting = this.queryChkSetting(chkid);
                showType = this.getPageCache().get("showType");
                if ("name".equals(showType)) {
                    e.setFormatValue((Object)chksetting.getString("chineseformula"));
                } else if ("number".equals(showType)) {
                    e.setFormatValue((Object)chksetting.getString("vformula"));
                } else if ("mix".equals(showType)) {
                    e.setFormatValue((Object)chksetting.getString("mformula"));
                }
            }
            if ("process.name".equals(key) && (processId = e.getRowData().getLong("process.id")) != 0L && (node = MemberReader.findProcessMemberById((String)this.getCurModelNumber(), (Long)processId)) != IDNumberTreeNode.NotFoundTreeNode) {
                String showType2 = this.getPageCache().get("showType");
                if ("name".equals(showType2)) {
                    e.setFormatValue((Object)node.getName());
                } else if ("number".equals(showType2)) {
                    e.setFormatValue((Object)node.getNumber());
                } else if ("mix".equals(showType2)) {
                    e.setFormatValue((Object)(node.getName() + "-" + node.getNumber()));
                }
            }
            if ("org.name".equals(key) || "orgparent.name".equals(key)) {
                IDNumberTreeNode node2;
                String property = key.replace("name", "id");
                long orgId = e.getRowData().getLong(property);
                if (orgId != 0L && (node2 = MemberReader.findEntityMemberById((String)this.getCurModelNumber(), (Long)orgId)) != IDNumberTreeNode.NotFoundTreeNode) {
                    String showType3 = this.getPageCache().get("showType");
                    if ("name".equals(showType3)) {
                        e.setFormatValue(number2realName.get(node2.getNumber()));
                    } else if ("number".equals(showType3)) {
                        e.setFormatValue((Object)node2.getNumber());
                    } else if ("mix".equals(showType3)) {
                        e.setFormatValue((Object)((String)number2realName.get(node2.getNumber()) + "-" + node2.getNumber()));
                    }
                }
            }
            if ("chkformula.multitemplate.name".equals(key)) {
                List<DynamicObject> lastTemplates = this.formatTemplateValue(e.getRowData().getLong("org.id"), (DynamicObject)e.getRowData().get("chkformula"));
                List<String> template = this.getTemplateByShowType(lastTemplates, this.getPageCache().get("showType"));
                e.setFormatValue((Object)String.join((CharSequence)",", template));
            }
        }
    }

    private List<String> getTemplateByShowType(List<DynamicObject> lastTemplates, String showType) {
        List<String> template = new ArrayList<String>();
        if (kd.bos.util.StringUtils.isEmpty((String)showType)) {
            return template;
        }
        switch (showType) {
            case "name": {
                template = lastTemplates.stream().map(dy -> dy.getString("name")).distinct().collect(Collectors.toList());
                break;
            }
            case "number": {
                template = lastTemplates.stream().map(dy -> dy.getString("number")).distinct().collect(Collectors.toList());
                break;
            }
            case "mix": {
                template = lastTemplates.stream().map(dy -> dy.getString("name") + "-" + dy.getString("number")).distinct().collect(Collectors.toList());
                break;
            }
        }
        return template;
    }

    private List<DynamicObject> formatTemplateValue(long orgId, DynamicObject chkDy) {
        String originalOrgId = this.getPageCache().get("entityselectedNodeId");
        if (kd.bos.util.StringUtils.isEmpty((String)originalOrgId)) {
            return new ArrayList<DynamicObject>();
        }
        List templateNumbers = chkDy.getDynamicObjectCollection("multitemplate").stream().map(dy -> dy.getString("fbasedataid.number")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(templateNumbers)) {
            return new ArrayList<DynamicObject>();
        }
        Map<String, DynamicObject> tempsMap = this.getCacheTemplateMap(orgId);
        return templateNumbers.stream().filter(t -> tempsMap.get(t) != null).map(tempsMap::get).collect(Collectors.toList());
    }

    private Map<String, DynamicObject> getCacheTemplateMap(long orgId) {
        String originalOrgId = this.getPageCache().get("entityselectedNodeId");
        if (kd.bos.util.StringUtils.isEmpty((String)originalOrgId)) {
            return new HashMap<String, DynamicObject>(16);
        }
        if (!ThreadCache.exists((Object)"bcm_chkreportbcm_templateentity")) {
            Map<Long, List<DynamicObject>> allsubordinateOrgs;
            long selectOrgId = LongUtil.toLong((Object)originalOrgId);
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)selectOrgId);
            String orgSelectedLevel = (String)this.getModel().getValue("combofield");
            HashSet<Long> orgIds = new HashSet<Long>();
            orgIds.add(entityNode.getBaseTreeNode().getId());
            if ("Entity".equals(entityNode.getNumber())) {
                allsubordinateOrgs = this.getEntityAllsubordinateOrgs(this.getModelId(), entityNode.getLongNumber(), this.getModel().getValue("cslscheme") == null ? 0L : ((DynamicObject)this.getModel().getValue("cslscheme")).getLong("id"));
                allsubordinateOrgs.forEach((k, v) -> v.forEach(dy -> orgIds.add(dy.getLong("copyfrom.id") != 0L ? dy.getLong("copyfrom.id") : dy.getLong("id"))));
            } else if ("alllevel".equals(orgSelectedLevel)) {
                allsubordinateOrgs = this.getAllsubordinateOrgs(this.getModelId(), entityNode.getLongNumber());
                allsubordinateOrgs.forEach((k, v) -> v.forEach(dy -> orgIds.add(dy.getLong("copyfrom.id") != 0L ? dy.getLong("copyfrom.id") : dy.getLong("id"))));
            } else if ("directlevel".equals(orgSelectedLevel)) {
                DynamicObjectCollection directLevelOrgs = this.getDirectLevelOrgs(selectOrgId);
                directLevelOrgs.forEach(dy -> orgIds.add(dy.getLong("copyfrom.id") != 0L ? dy.getLong("copyfrom.id") : dy.getLong("id")));
            }
            QFilter qFilter = this.getBcmStatusFilter(orgIds);
            DynamicObjectCollection orgStatus = QueryServiceHelper.query((String)"bcm_status", (String)"org.id,tmp.name,tmp.number", (QFilter[])qFilter.toArray());
            if (orgStatus.isEmpty()) {
                return new HashMap<String, DynamicObject>(16);
            }
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId()).and("templatetype", "in", Arrays.asList(String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType())));
            QFilter statusFilter = new QFilter("status", "=", (Object)"1");
            QFilter firstVersionFilter = new QFilter("versionnumber", "=", (Object)1);
            DynamicObjectCollection enableVersionTmps = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name,group,versionnumber", (QFilter[])new QFilter[]{filter, statusFilter}, (String)"versionnumber desc");
            DynamicObjectCollection firstVersionTmps = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name,group,versionnumber", (QFilter[])new QFilter[]{filter, firstVersionFilter});
            HashMap<String, DynamicObject> group2TempMap = new HashMap<String, DynamicObject>(enableVersionTmps.size());
            HashMap number2TempMap = new HashMap(enableVersionTmps.size());
            for (DynamicObject temp : enableVersionTmps) {
                group2TempMap.putIfAbsent(temp.getString("group"), temp);
            }
            for (DynamicObject temp : firstVersionTmps) {
                group2TempMap.putIfAbsent(temp.getString("group"), temp);
            }
            group2TempMap.forEach((k, v) -> number2TempMap.putIfAbsent(v.getString("number"), v));
            ThreadCache.put((Object)"bcm_chkreportbcm_templateentity", number2TempMap);
        }
        return (Map)ThreadCache.get((Object)"bcm_chkreportbcm_templateentity");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addSearchClickListener(this::doRefreshBillList);
        MulBasedataEdit mulf7Process = (MulBasedataEdit)this.getControl(process);
        mulf7Process.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cslschemeF7 = (BasedataEdit)this.getControl("cslscheme");
        cslschemeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                CheckUpChkReportPlugin.this.setBtnEnableStatus();
            }
        });
        billList.addListRowSelectAllListeners(event -> this.setBtnEnableStatus());
        billList.addClearSelectionListener(event -> this.setBtnEnableStatus());
    }

    private void setBtnEnableStatus() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Set ids = ConvertUtil.convertArrayToLong((Object[])billList.getSelectedRows().getPrimaryKeyValues());
        boolean isContainReadOnlyOrg = false;
        boolean hasCommit = false;
        if (!ids.isEmpty()) {
            QFilter filter = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection checkReports = QueryServiceHelper.query((String)billList.getEntityType().getName(), (String)"org.id", (QFilter[])new QFilter[]{filter});
            if (!checkReports.isEmpty()) {
                for (DynamicObject checkReport : checkReports) {
                    if (PermEnum.READONLY.getValue() != this.getOrgMemberPerm(checkReport.getString("org.id")).intValue()) continue;
                    isContainReadOnlyOrg = true;
                    break;
                }
                Set orgIds = checkReports.stream().map(chk -> chk.getLong("org.id")).collect(Collectors.toSet());
                DynamicObject modelDynamicObject = (DynamicObject)this.getModel().getValue("model");
                DynamicObject scenarioDynamicObject = (DynamicObject)this.getModel().getValue("scenario");
                DynamicObject fyearDynamicObject = (DynamicObject)this.getModel().getValue("year");
                DynamicObject periodDynamicObject = (DynamicObject)this.getModel().getValue("period");
                if (modelDynamicObject == null || scenarioDynamicObject == null || fyearDynamicObject == null || periodDynamicObject == null) {
                    return;
                }
                Map mcStatus = McStatus.batchGetMcStatus((Object)modelDynamicObject.getLong("id"), orgIds, (Object)scenarioDynamicObject.getLong("id"), (Object)fyearDynamicObject.getLong("id"), (Object)periodDynamicObject.getLong("id"));
                hasCommit = mcStatus.entrySet().stream().anyMatch(statusEntry -> ((McStatus)statusEntry.getValue()).getFlow().isSubmit());
            }
        }
        this.getView().getPageCache().remove(IS_CONTAIN_READONLY_ORG);
        if (!hasCommit) {
            this.getView().getPageCache().put(IS_CONTAIN_READONLY_ORG, Boolean.toString(isContainReadOnlyOrg));
            this.getView().setEnable(Boolean.valueOf(!isContainReadOnlyOrg), new String[]{"bar_check", "bar_recheck", "bar_pass", "bar_recover"});
        }
    }

    public void hyperLinkClick(ListHyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        if (this.getModel().getValue("cslscheme") == null && this.isCM()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CheckUpChkReportPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object selectPK = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject report = null;
        try {
            report = BusinessDataServiceHelper.loadSingle((Object)selectPK, (String)"bcm_chkreport");
        }
        catch (Exception exp) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u52fe\u7a3d\u6821\u9a8c\u7ed3\u679c\u5df2\u88ab\u5237\u65b0,\u8bf7\u5237\u65b0\u52fe\u7a3d\u6821\u9a8c\u62a5\u544a\u540e\u518d\u8054\u67e5\u6570\u636e\u3002", (String)"CheckUpChkReportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        billList.selectRows(e.getIndex());
        String yearNum = ((DynamicObject)this.getModel().getValue("year")).getString("number");
        String periodNum = ((DynamicObject)this.getModel().getValue("period")).getString("number");
        int is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), this.getBizAppId(), "bcm_report_list", "47150e89000000ac");
        if (is == 0 && !MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBaseListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ChkReportJump2CellUtil.showReport(this.getView(), e.getKey(), e.getColId(), report.getLong("id"), this.getModelId(), yearNum, periodNum);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "bcm_chknoteedit": {
                this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
                break;
            }
            case "bcm_chkforcepassnote": {
                if (evt.getReturnData() == null) break;
                String note = (String)this.deSerializedBytes(evt.getReturnData().toString());
                List ids = (List)this.deSerializedBytes(this.getPageCache().get(FORCE_PASS_IDS));
                this.pass(ids, note);
                try {
                    Map<String, List<String>> map = this.getlogMessageMap();
                    map.forEach((key, value) -> {
                        String number = (String)value.get(0);
                        String name = (String)value.get(1);
                        String scenario = (String)value.get(2);
                        String year = (String)value.get(3);
                        String period = (String)value.get(4);
                        String org = (String)value.get(5);
                        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5f3a\u5236\u901a\u8fc7", "CheckUpChkReportPlugin_17", "fi-bcm-formplugin", "Forced Pass"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s %4$s %5$s\uff0c\u5f3a\u5236\u901a\u8fc7\u6210\u529f\u3002", "CheckUpChkReportPlugin_18", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{scenario, year, period, org, number, name})));
                    });
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
                this.getPageCache().remove(FORCE_PASS_IDS);
                break;
            }
            case "btn_batchnote": {
                if (evt.getReturnData() == null) break;
                String note = (String)this.deSerializedBytes(evt.getReturnData().toString());
                Object[] ids = (Object[])this.deSerializedBytes(this.getPageCache().get("batchNoteIds"));
                ChkCheckReportListHelper.batchNoteReports((IFormView)this.getView(), (Object[])ids, (String)note, (long)this.getModelId(), (long)this.getCslschemeId());
                this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
                break;
            }
            case "chkTask": {
                Object data = evt.getReturnData();
                if (data == null) break;
                String taskInfoJson = (String)((Map)data).get("taskinfo");
                JSONObject taskInfo = JSONObjectUtil.parseObjectOrder((String)taskInfoJson);
                JSONObject custData = taskInfo.getJSONObject("data");
                Object errorMsgStr = custData.get((Object)"errorMsg");
                if (errorMsgStr != null) {
                    this.getView().showErrorNotification(String.join((CharSequence)System.lineSeparator(), (List)ObjectSerialUtil.deSerializedBytes((String)errorMsgStr.toString())));
                    this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
                    break;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u5b8c\u6210\u3002", (String)"CheckUpChkReportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                Map map = (Map)this.deSerializedBytes(this.getPageCache().get("logMap"));
                this.getView().getPageCache().remove("logMap");
                try {
                    OpNameMultiLangEnumBridge optionName;
                    Iterator iterator = map.entrySet().iterator();
                    OpNameMultiLangEnumBridge opNameMultiLangEnumBridge = optionName = custData.getInteger("type") == 4 ? new OpNameMultiLangEnumBridge("\u91cd\u65b0\u52fe\u7a3d", "CheckUpChkReportPlugin_35", "fi-bcm-formplugin", "Re-check") : new OpNameMultiLangEnumBridge("\u52fe\u7a3d\u68c0\u67e5", "CheckUpChkReportPlugin_15", "fi-bcm-formplugin", "Check");
                    while (iterator.hasNext()) {
                        List value2 = (List)iterator.next().getValue();
                        String number = (String)value2.get(0);
                        String name = (String)value2.get(1);
                        String scenario = (String)value2.get(2);
                        String year = (String)value2.get(3);
                        String period = (String)value2.get(4);
                        String org = (String)value2.get(5);
                        this.writeMultiLangLog(optionName, new OPDescMultiLangEnumBridge("%1$s %2$s %3$s %4$s %5$s\uff0c\u52fe\u7a3d\u68c0\u67e5\u6210\u529f\u3002", "CheckUpChkReportPlugin_16", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{scenario, year, period, org, number, name})));
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        Map<String, List<String>> map = this.getlogMessageMap();
        switch (key) {
            case "bar_refresh": {
                this.initLeftTree();
                this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
                break;
            }
            case "bar_check": 
            case "bar_recheck": {
                this.getView().getPageCache().put("logMap", this.toByteSerialized(map));
                this.checkUpCheck(evt);
                break;
            }
            case "bar_pass": {
                BillList list = this.beforeOperate();
                if (list == null) {
                    return;
                }
                ArrayList ids = new ArrayList();
                list.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
                Map chkReportMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"bcm_chkreport");
                chkReportMap.forEach((id, report) -> {
                    if (!String.valueOf(ChkResultTypeEnum.UNPASS.getIndex()).equals(report.getString("chkresulttype"))) {
                        ids.remove(id);
                    }
                });
                if (ids.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62a5\u544a\u672a\u5305\u542b\u201c\u4e0d\u901a\u8fc7\u201d\u72b6\u6001\u7684\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u5f3a\u5236\u901a\u8fc7\u64cd\u4f5c\u3002", (String)"CheckUpChkReportPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map<String, String> f7IdMap = this.getCurrentFilterParam(Arrays.asList("model", "scenario", "year", "period"), "id");
                boolean isQuoteScene = MergeControlHelper.isQuoteScene((Long)this.getModelId(), (Long)LongUtil.toLong((Object)f7IdMap.get("scenario")));
                Set allVersionedOrgs = MergeControlHelper.getAllVersionedOrgs((Long)this.getModelId(), (Long)LongUtil.toLong((Object)f7IdMap.get("scenario")), (Long)LongUtil.toLong((Object)f7IdMap.get("year")), (Long)LongUtil.toLong((Object)f7IdMap.get("period")));
                if (isQuoteScene) {
                    chkReportMap.forEach((id, report) -> {
                        if (!allVersionedOrgs.contains(report.getString("org.number"))) {
                            ids.remove(id);
                        }
                    });
                }
                if (ids.isEmpty()) {
                    throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioVersionError"), new Object[0]);
                }
                List<DynamicObject> reports = ids.stream().map(chkReportMap::get).collect(Collectors.toList());
                if (!this.checkPeriodFlowStatusAndPerm(reports.toArray(new DynamicObject[0]))) {
                    return;
                }
                this.getPageCache().put(FORCE_PASS_IDS, this.toByteSerialized(ids));
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_chkforcepassnote");
                showParameter.setCaption(ResManager.loadKDString((String)"\u5f3a\u5236\u901a\u8fc7", (String)"CheckUpChkReportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_chkforcepassnote"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                if (reports.size() == 1) {
                    showParameter.setCustomParam("note", ((DynamicObject)reports.get(0)).get("note"));
                }
                this.getView().showForm(showParameter);
                break;
            }
            case "bar_recover": {
                BillList list1 = this.beforeOperate();
                if (list1 == null) {
                    return;
                }
                this.recover(list1);
                try {
                    map = this.getlogMessageMap();
                    map.forEach((key1, value) -> {
                        String number = (String)value.get(0);
                        String name = (String)value.get(1);
                        String scenario = (String)value.get(2);
                        String year = (String)value.get(3);
                        String period = (String)value.get(4);
                        String org = (String)value.get(5);
                        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6062\u590d\u9a8c\u8bc1", "CheckUpChkReportPlugin_19", "fi-bcm-formplugin", "Recovery Verification"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s %4$s %5$s\uff0c\u6062\u590d\u9a8c\u8bc1\u6210\u529f\u3002", "CheckUpChkReportPlugin_20", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{scenario, year, period, org, number, name})));
                    });
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                }
                this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
                break;
            }
            case "bar_export": {
                this.exportChkReport(billList);
                try {
                    map = this.getlogMessageMap();
                    map.forEach((key1, value) -> {
                        String number = (String)value.get(0);
                        String name = (String)value.get(1);
                        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "CheckUpChkReportPlugin_21", "fi-bcm-formplugin", "Export"), new OPDescMultiLangEnumBridge("%1$s %2$s\uff0c\u5bfc\u51fa\u6210\u529f\u3002", "CheckUpChkReportPlugin_22", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number, name})));
                    });
                }
                catch (Exception e3) {
                    logger.error((Throwable)e3);
                }
                break;
            }
            case "btn_showname": 
            case "btn_shownumber": 
            case "btn_showmix": {
                this.show(key);
                break;
            }
            case "btn_batchnote": {
                if (CollectionUtils.isEmpty((Collection)billList.getSelectedRows())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"CheckUpChkReportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ChkCheckReportListHelper.openBatchNoteView((IFormPlugin)this, (IFormView)this.getView(), (Object[])billList.getSelectedRows().getPrimaryKeyValues());
                break;
            }
        }
    }

    private boolean checkPeriodFlowStatusAndPerm(DynamicObject[] reports) {
        ArrayList pageDims = Lists.newArrayList((Object[])new String[]{"model", "scenario", "year", "period"});
        Map<String, String> idMap = this.getCurrentFilterParam(pageDims, "id");
        Map<String, String> numberMap = this.getCurrentFilterParam(pageDims, "number");
        if (idMap == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"CheckUpChkReportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String orgId = this.getPageCache().get("entityselectedNodeId");
        HashMap<String, Boolean> checkedOrg = new HashMap<String, Boolean>();
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (DynamicObject report : reports) {
            IDNumberTreeNode node;
            if (report == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u62a5\u544a\u5df2\u7ecf\u5237\u65b0\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"CheckUpChkReportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String currency = report.getString("currency.number");
            String checkedKey = String.format("%d|%d|%s", report.getLong("org.id"), report.getLong("orgparent.id"), report.getString("currency.number"));
            if (checkedOrg.containsKey(checkedKey) || (node = this.findNode(orgId, MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)report.getLong("org.id")))) == null) continue;
            Boolean hasPerm = checkedOrg.putIfAbsent(String.valueOf(node.getId()), this.checkForcePerm(node.getId()));
            if (hasPerm == null) {
                if (!((Boolean)checkedOrg.get(String.valueOf(node.getId()))).booleanValue()) {
                    errorMsg.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u65e0\u6cd5\u6267\u884c\u5bf9\u5e94\u64cd\u4f5c\uff0c\u9700\u8981\u6709\u4e0a\u7ea7\u7ec4\u7ec7\u6210\u5458\u6743\u9650\u3002", (String)"CheckUpChkReportPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]), node.getNumber()));
                    continue;
                }
            } else if (!hasPerm.booleanValue()) continue;
            CalContext context = new CalContext();
            context.setProperty("year", (Object)numberMap.get("year"));
            context.setProperty("period", (Object)numberMap.get("period"));
            context.setProperty("modelId", (Object)this.getModelId());
            context.setProperty("scenarioId", (Object)LongUtil.toLong((Object)idMap.get("scenario")));
            context.setProperty("yearId", (Object)LongUtil.toLong((Object)idMap.get("year")));
            context.setProperty("periodId", (Object)LongUtil.toLong((Object)idMap.get("period")));
            context.setProperty("orgId", (Object)report.getLong("org.id"));
            context.setProperty("org", (Object)report.getString("org.number"));
            String ecCurrency = ChkCheckServiceHelper.getEcCurrency((ICalContext)context, (long)this.getModelId());
            try {
                ChkCheckServiceHelper.checkPeriodStatus((ICalContext)context);
                if (StringUtils.equals((String)ecCurrency, (String)currency)) {
                    ChkCheckServiceHelper.checkEcFlowStatus((ICalContext)context);
                }
                if (!StringUtils.equals((String)ecCurrency, (String)currency)) {
                    if (report.getLong("orgparent.id") != 0L) {
                        context.setProperty("orgparent", (Object)report.getLong("orgparent.id"));
                        ChkCheckServiceHelper.checkParentEcFlowStatus((ICalContext)context);
                    } else {
                        ChkCheckServiceHelper.checkPcFlowStatus((ICalContext)context);
                    }
                }
                checkedOrg.put(checkedKey, true);
            }
            catch (Exception e) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u65e0\u6cd5\u6267\u884c\u5bf9\u5e94\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002\u5177\u4f53\u539f\u56e0\uff1a%2$s\u3002", (String)"CheckUpChkReportPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]), node.getNumber(), e.getMessage()));
                checkedOrg.put(checkedKey, false);
            }
        }
        if (CollectionUtils.isNotEmpty(errorMsg)) {
            this.getView().showErrorNotification(String.join((CharSequence)System.lineSeparator(), errorMsg));
            return false;
        }
        return true;
    }

    private boolean isAllRecheck(ItemClickEvent evt) {
        return "bar_recheck".equals(evt.getItemKey());
    }

    private void show(String key) {
        if ("btn_showname".equals(key)) {
            this.getPageCache().put("showType", "name");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_show"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_show1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_show2"});
            this.writeOperationLog(ResManager.loadKDString((String)"\u6309\u540d\u79f0\u663e\u793a", (String)"CheckUpChkReportPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getOperationStstusSuccess());
        } else if ("btn_shownumber".equals(key)) {
            this.getPageCache().put("showType", "number");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_show1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_show"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_show2"});
            this.writeOperationLog(ResManager.loadKDString((String)"\u6309\u7f16\u7801\u663e\u793a", (String)"CheckUpChkReportPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getOperationStstusSuccess());
        } else if ("btn_showmix".equals(key)) {
            this.getPageCache().put("showType", "mix");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_show2"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_show"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_show1"});
            this.writeOperationLog(ResManager.loadKDString((String)"\u6309\u7f16\u7801-\u540d\u79f0\u663e\u793a", (String)"CheckUpChkReportPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getOperationStstusSuccess());
        }
        this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
    }

    private void exportChkReport(BillList billList) {
        try {
            ListSelectedRowCollection ls = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)ls)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"CheckUpChkReportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Object> set = new HashSet<Object>();
            for (ListSelectedRow row : ls) {
                set.add(row.getPrimaryKeyValue());
            }
            QFilter[] filters = new QFilter[]{new QFilter("bizobject.number", "=", (Object)"bcm_chkreport"), new QFilter("templatetype", "=", (Object)"IMPT").or(new QFilter("templatetype", "is null", null))};
            DynamicObject pkObj = QueryServiceHelper.queryOne((String)"bos_importtemplate", (String)"id", (QFilter[])filters);
            if (pkObj == null) {
                throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u5e94\u7528>\u914d\u7f6e\u5de5\u5177>\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f\u201d\u9884\u5236\u5bfc\u51fa\u6a21\u677f\u3002", (String)"CheckUpChkReportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
            }
            IFormView formView = this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            DynamicObject[] dys = BusinessDataServiceHelper.loadFromCache((String)"bcm_chkreport", (QFilter[])new QFilter("id", "in", set).toArray()).values().toArray(new DynamicObject[0]);
            DynamicObject[] showType = this.getPageCache().get("showType");
            String chineseFormulaProperty = "chineseformula";
            String mapdimProperty = "fixdimtxt";
            if (kd.bos.util.StringUtils.isNotEmpty((String)showType)) {
                switch (showType) {
                    case "number": {
                        chineseFormulaProperty = "vformula";
                        mapdimProperty = "vfixdimtxt";
                        break;
                    }
                    case "mix": {
                        chineseFormulaProperty = "mformula";
                        mapdimProperty = "mfixdimtxt";
                        break;
                    }
                }
            }
            for (DynamicObject dy : dys) {
                DynamicObject chkformula = dy.getDynamicObject("chkformula");
                List<DynamicObject> lastTemplates = this.formatTemplateValue(dy.getLong("org.id"), chkformula);
                DynamicObject templateDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity");
                templateDy.set("name", (Object)String.join((CharSequence)",", lastTemplates.stream().map(template -> template.getString("name")).collect(Collectors.toList())));
                templateDy.set("number", (Object)String.join((CharSequence)",", lastTemplates.stream().map(template -> template.getString("number")).collect(Collectors.toList())));
                dy.set("template", (Object)templateDy);
                dy.set("chineseformula", chkformula.get(chineseFormulaProperty));
                dy.set("mapdim", chkformula.get(mapdimProperty));
            }
            HashMap<String, Object> outputParams = new HashMap<String, Object>();
            outputParams.put("exportDyns", dys);
            outputParams.put("fileName", ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u62a5\u544a\u5bfc\u51fa.xlsx", (String)"CheckUpChkReportPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            ExportExecuteStrategyContext context = new ExportExecuteStrategyContext((IExport)new ChkCheckReportExportStrategy());
            String url = context.export(routeAppId, pkObj.getLong("id"), this.getView().getEntityId(), "bcm_chkreport", outputParams);
            if (kd.bos.util.StringUtils.isNotEmpty((String)url)) {
                this.downloadFile(url, "bcm_chkspeechlist", "1G2FW/G3YIL8");
            }
        }
        catch (Exception e) {
            try {
                Map<String, List<String>> map = this.getlogMessageMap();
                map.forEach((key, value) -> {
                    String number = (String)value.get(0);
                    String name = (String)value.get(1);
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "CheckUpChkReportPlugin_21", "fi-bcm-formplugin", "Export"), new OPDescMultiLangEnumBridge("%1$s %2$s\uff0c\u5bfc\u51fa\u5931\u8d25\u3002", "CheckUpChkReportPlugin_26", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number, name})));
                });
            }
            catch (Exception e1) {
                logger.error((Throwable)e1);
            }
            throw new KDBizException(e.getMessage());
        }
    }

    private Map<String, List<String>> getlogMessageMap() {
        ArrayList<Object> selectIdList = new ArrayList<Object>();
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection cos = billlistap.getSelectedRows();
        for (ListSelectedRow listSelectedRow : cos) {
            selectIdList.add(listSelectedRow.getPrimaryKeyValue());
        }
        DynamicObjectCollection load = QueryServiceHelper.query((String)billlistap.getEntityType().getName(), (String)"id,chkformula.number,chkformula.name, org.number", (QFilter[])new QFilter("id", "in", selectIdList).toArray());
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DynamicObject dynamicObject : load) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(dynamicObject.getString("chkformula.number"));
            list.add(dynamicObject.getString("chkformula.name"));
            list.add(((DynamicObject)this.getModel().getValue("scenario")).getString("number"));
            list.add(((DynamicObject)this.getModel().getValue("year")).getString("number"));
            list.add(((DynamicObject)this.getModel().getValue("period")).getString("number"));
            list.add(dynamicObject.getString("org.number"));
            map.put(dynamicObject.getString("id"), list);
        }
        return map;
    }

    private void pass(List<Object> ids, String note) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"bcm_chkreport", (String)"id,org,process,chkformula,chkresulttype,forcedpasser,forcedpasstime,note,orgparent", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("chkresulttype", "=", (Object)String.valueOf(ChkResultTypeEnum.UNPASS.getIndex()))})) {
            obj.set("chkresulttype", (Object)ChkResultTypeEnum.FORCEPASS.getIndex());
            obj.set("forcedpasser", (Object)RequestContext.get().getUserId());
            obj.set("forcedpasstime", (Object)TimeServiceHelper.now());
            obj.set("note", (Object)ChkCheckReportListHelper.appendNote((String)obj.getString("note"), (String)note, (boolean)false));
        }
        try (TXHandle tx = TX.required((String)"bcm_chkreport_forcepass");){
            try {
                SaveServiceHelper.save((DynamicObject[])objs);
                ChkCheckStatusHelper.dealChkStsAfterChangeReport((long)this.getModelId(), (long)((DynamicObject)this.getModel().getValue("scenario")).getLong("id"), (long)((DynamicObject)this.getModel().getValue("year")).getLong("id"), (long)((DynamicObject)this.getModel().getValue("period")).getLong("id"), (long)((DynamicObject)this.getModel().getValue("cslscheme")).getLong("id"), (DynamicObject[])objs);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f3a\u5236\u901a\u8fc7\u6210\u529f,\u6b64\u64cd\u4f5c\u4ec5\u5bf9\u72b6\u6001\u4e3a\u201c\u4e0d\u901a\u8fc7\u201d\u7684\u62a5\u544a\u751f\u6548\u3002", (String)"CheckUpChkReportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error("\u52fe\u7a3d\u5f3a\u5236\u901a\u8fc7\u5931\u8d25\uff1a", (Throwable)e);
                tx.markRollback();
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkForcePassError"), new Object[]{e.getMessage()});
            }
        }
    }

    private void recover(BillList list) {
        ArrayList ids = new ArrayList();
        list.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bcm_chkreport", (String)"id,org,process,chkformula,chkresulttype,note,chkformula.chkeffecttype,currency,orgparent", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("chkresulttype", "=", (Object)String.valueOf(ChkResultTypeEnum.FORCEPASS.getIndex()))});
        if (objs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62a5\u544a\u672a\u5305\u542b\u201c\u5f3a\u5236\u901a\u8fc7\u201d\u72b6\u6001\u7684\u6570\u636e\uff0c\u65e0\u9700\u8fdb\u884c\u6062\u590d\u9a8c\u8bc1\u64cd\u4f5c\u3002", (String)"CheckUpChkReportPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, String> f7IdMap = this.getCurrentFilterParam(Arrays.asList("scenario", "year", "period"), "id");
        boolean isQuoteScene = MergeControlHelper.isQuoteScene((Long)this.getModelId(), (Long)LongUtil.toLong((Object)f7IdMap.get("scenario")));
        if (isQuoteScene) {
            Set set = MergeControlHelper.getAllVersionedOrgs((Long)this.getModelId(), (Long)LongUtil.toLong((Object)f7IdMap.get("scenario")), (Long)LongUtil.toLong((Object)f7IdMap.get("year")), (Long)LongUtil.toLong((Object)f7IdMap.get("period")));
            objs = (DynamicObject[])Arrays.stream(objs).filter(o -> set.contains(o.getString("org.number"))).toArray(DynamicObject[]::new);
        }
        if (objs.length == 0) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioVersionError"), new Object[0]);
        }
        if (!this.checkPeriodFlowStatusAndPerm(objs)) {
            return;
        }
        for (DynamicObject obj : objs) {
            if (CHKCheckEffectEnum.NoteAndReport.getIndex().equals(obj.get("chkformula.chkeffecttype")) && kd.bos.util.StringUtils.isNotEmpty((String)obj.getString("note"))) {
                obj.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
                continue;
            }
            obj.set("chkresulttype", (Object)ChkResultTypeEnum.UNPASS.getIndex());
        }
        try (TXHandle tXHandle = TX.required((String)"bcm_chkreport_recover");){
            try {
                SaveServiceHelper.save((DynamicObject[])objs);
                ChkCheckStatusHelper.dealChkStsAfterChangeReport((long)this.getModelId(), (long)((DynamicObject)this.getModel().getValue("scenario")).getLong("id"), (long)((DynamicObject)this.getModel().getValue("year")).getLong("id"), (long)((DynamicObject)this.getModel().getValue("period")).getLong("id"), (long)((DynamicObject)this.getModel().getValue("cslscheme")).getLong("id"), (DynamicObject[])objs);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6062\u590d\u6210\u529f\u3002", (String)"CheckUpChkReportPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e2) {
                logger.error("\u52fe\u7a3d\u62a5\u544a\u6062\u590d\u9a8c\u8bc1\u5931\u8d25\uff1a", (Throwable)e2);
                tXHandle.markRollback();
            }
        }
    }

    private void syncStatus(DynamicObject[] objs) {
        HashSet orgs = new HashSet();
        String modelNumber = this.getCurModelNumber();
        Arrays.stream(objs).forEach(obj -> {
            if (obj.getLong("orgparent.id") != 0L) {
                IDNumberTreeNode parent = MemberReader.findEntityMemberById((String)modelNumber, (Long)obj.getLong("orgparent.id"));
                IDNumberTreeNode node = MemberReader.findEntityMemberById((String)modelNumber, (Long)obj.getLong("org.id"));
                Optional<IDNumberTreeNode> first = parent.getChildren().stream().filter(child -> child.getNumber().equals(node.getNumber())).findFirst();
                if (first.isPresent()) {
                    orgs.add(first.get().getId());
                }
            } else {
                orgs.add(obj.getLong("org.id"));
            }
        });
        orgs.forEach(orgId -> {
            String scenario = ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
            String year = ((DynamicObject)this.getModel().getValue("year")).getString("number");
            String period = ((DynamicObject)this.getModel().getValue("period")).getString("number");
            IDNumberTreeNode node = MemberReader.findEntityMemberById((String)modelNumber, (Long)orgId);
            String org = node.getNumber();
            Long scenarioId = ((DynamicObject)this.getModel().getValue("scenario")).getLong("id");
            Long yearId = ((DynamicObject)this.getModel().getValue("year")).getLong("id");
            Long periodId = ((DynamicObject)this.getModel().getValue("period")).getLong("id");
            CalContext ctx = new CalContext(modelNumber, org, year, period, scenario, "");
            ctx.setProperty("modelId", (Object)this.getModelId());
            ctx.setProperty("scenarioId", (Object)scenarioId);
            ctx.setProperty("yearId", (Object)yearId);
            ctx.setProperty("periodId", (Object)periodId);
            ctx.setProperty("orgId", (Object)node.getBaseTreeNode().getId());
            ctx.setProperty("originalOrgId", (Object)node.getId());
            ctx.setProperty("ecCurrency", (Object)node.getCurrency());
            ctx.setProperty("pcCurrency", (Object)("Entity".equals(node.getParent().getNumber()) ? node.getCurrency() : node.getParent().getCurrency()));
            ChkStatusBuilder chkStatusBuilder = new ChkStatusBuilder((ICalContext)ctx, true);
            chkStatusBuilder.syncStatus(false);
        });
    }

    private BillList beforeOperate() {
        DynamicObjectCollection chkReport;
        IDNumberTreeNode node;
        BillList list = (BillList)this.getControl("billlistap");
        if (list.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"CheckUpChkReportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        String selectNode = this.getPageCache().get("entityselectedNodeId");
        if (selectNode != null && (node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)LongUtil.toLong((Object)selectNode))).getParent() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u7ec4\u7ec7\u7684\u6839\u8282\u70b9\u4e0a\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"CheckUpChkReportPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        Map<String, String> f7IdMap = this.getCurrentFilterParam(Arrays.asList("scenario", "year", "period"), "id");
        if (list.getSelectedRows().size() == 1 && !(chkReport = QueryServiceHelper.query((String)"bcm_chkreport", (String)"id,org.id,org.number", (QFilter[])new QFilter("id", "=", list.getCurrentSelectedRowInfo().getPrimaryKeyValue()).toArray())).isEmpty() && MergeControlHelper.isQuoteLocked((Long)this.getModelId(), (Long)LongUtil.toLong((Object)f7IdMap.get("scenario")), (Long)LongUtil.toLong((Object)f7IdMap.get("year")), (Long)LongUtil.toLong((Object)f7IdMap.get("period")), (Long)((DynamicObject)chkReport.get(0)).getLong("org.id"))) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioVersionError"), new Object[0]);
        }
        return list;
    }

    private boolean checkForcePerm(Long orgId) {
        if (orgId != null) {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgId);
            if (node.getParent() == null || "Entity".equals(node.getParent().getNumber())) {
                return true;
            }
            IDNumberTreeNode parentNode = node.getParent();
            do {
                if (!this.isOrgMemberHavePerm(parentNode.getId().toString())) continue;
                return true;
            } while ((parentNode = parentNode.getParent()) != null);
        }
        return false;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("showType", "name");
        String mergedim = (String)this.getFormCustomParam("mergedim");
        String sourceFrom = (String)this.getFormCustomParam("sourceFrom");
        if (mergedim != null) {
            this.initFromMergeControl(mergedim);
        } else if ("excel".equals(sourceFrom)) {
            this.initFromExcel();
        } else {
            super.afterCreateNewData(e);
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_show"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_show1"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_show2"});
        if (this.getFormCustomParam("KEY_MODEL_ID") != null) {
            this.getPageCache().put("KEY_MODEL_ID", this.getFormCustomParam("KEY_MODEL_ID").toString());
        }
    }

    private void initFromExcel() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().beginInit();
        this.getModel().setValue("model", customParams.get("model"));
        this.getModel().setValue("cslscheme", customParams.get("cslscheme"));
        this.getModel().setValue("scenario", customParams.get("scenario"));
        this.getModel().setValue("year", customParams.get("year"));
        this.getModel().setValue("period", customParams.get("period"));
        this.getModel().endInit();
        this.getPageCache().put("entityselectedNodeId", String.valueOf(customParams.get("org")));
        this.setDefaultProcess();
        this.initLeftTree();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        if (evt.getSource() instanceof MulBasedataEdit && process.equals(((MulBasedataEdit)evt.getSource()).getKey())) {
            evt.setCustomQFilters(Collections.singletonList(new QFilter("id", "in", (Object)DimMemberQueryUtil.findDimAllSonMembs((Long)this.getModelId(), (String)"bcm_processmembertree", Arrays.asList("CCTotal", "CT")))));
        }
    }

    private void initFromMergeControl(String mergedim) {
        FormShowParameter params = this.getView().getFormShowParameter();
        Map dim = (Map)this.deSerializedBytes(mergedim);
        Pair org = (Pair)dim.get("org");
        this.getModel().beginInit();
        this.getModel().setValue("model", ((Pair)dim.get((Object)"model")).p1);
        this.getModel().setValue("cslscheme", MemberReader.findEntityMemberById((String)this.getCurModelNumber(), (Long)((Long)org.p1)).getProperty("cslscheme.id"));
        this.getModel().setValue("scenario", ((Pair)dim.get((Object)"scenario")).p1);
        this.getModel().setValue("year", ((Pair)dim.get((Object)"year")).p1);
        this.getModel().setValue("period", ((Pair)dim.get((Object)"period")).p1);
        this.getModel().setValue(process, (Object)new Object[]{params.getCustomParam("processId")});
        this.getModel().endInit();
        this.getPageCache().put("entityselectedNodeId", ((Long)org.p1).toString());
        this.initLeftTree();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("combofield".equals(key)) {
            this.getView().showLoading(new LocaleString());
            try {
                this.refreshBillList(new QFilter("model", "=", (Object)this.getModelId()));
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    @Override
    public String getFyNum() {
        DynamicObject yearDyn = (DynamicObject)this.getModel().getValue("year");
        String fyNum = "";
        if (yearDyn != null) {
            fyNum = yearDyn.getString("number");
        }
        return fyNum;
    }

    @Override
    public long getPeriodId() {
        DynamicObject periodDyn = (DynamicObject)this.getModel().getValue("period");
        long id = 0L;
        if (periodDyn != null) {
            id = periodDyn.getLong("id");
        }
        return id;
    }

    @Override
    public long getScenarioId() {
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("scenario");
        long id = 0L;
        if (sceneDyn != null) {
            id = sceneDyn.getLong("id");
        }
        return id;
    }

    @Override
    boolean isRefreshBilllist() {
        boolean flag = true;
        for (String dim : this.getDimKeys()) {
            flag = this.getModel().getValue(dim) != null;
        }
        return flag;
    }

    @Override
    void billistOrderBy(BillList billList) {
        FilterParameter filterParameter = billList.getFilterParameter();
        filterParameter.setOrderBy("org.name asc,chkresulttype desc,chkformula.number");
    }

    @Override
    public QFilter getUserSelectF7Filter() {
        if (!this.isFilterNull()) {
            long senceId = ((DynamicObject)this.getModel().getValue("scenario")).getLong("id");
            long yearId = ((DynamicObject)this.getModel().getValue("year")).getLong("id");
            long periodId = ((DynamicObject)this.getModel().getValue("period")).getLong("id");
            DynamicObjectCollection proDOC = (DynamicObjectCollection)this.getModel().getValue(process);
            QFilter filter = new QFilter("scenario", "=", (Object)senceId);
            filter.and(new QFilter("year", "=", (Object)yearId));
            filter.and(new QFilter("period", "=", (Object)periodId));
            if (!proDOC.isEmpty()) {
                filter.and(new QFilter(process, "in", proDOC.stream().map(dyn -> dyn.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList())));
            }
            if (this.orgTabInfo.isIfSelectRoot() && this.getModel().getValue("cslscheme") != null) {
                long cslschemeId = ((DynamicObject)this.getModel().getValue("cslscheme")).getLong("id");
                QFilter qf = new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("cslscheme", "=", (Object)cslschemeId));
                List orgIds = QueryServiceHelper.queryPrimaryKeys((String)"bcm_entitymembertree", (QFilter[])new QFilter[]{qf, new QFilter("storagetype", "=", (Object)StorageTypeEnum.STORAGE.index)}, (String)"", (int)-1);
                DynamicObjectCollection copyfromOrg = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,copyfrom", (QFilter[])new QFilter[]{qf, new QFilter("storagetype", "=", (Object)StorageTypeEnum.SHARE.index)});
                copyfromOrg.forEach(o -> orgIds.add(o.get("copyfrom")));
                filter.and(new QFilter("org", "in", (Object)orgIds));
            }
            return filter;
        }
        return new QFilter("1", "=", (Object)0);
    }

    private QFilter getBcmStatusFilter(Set<Long> originalOrgId) {
        long senceId = ((DynamicObject)this.getModel().getValue("scenario")).getLong("id");
        long yearId = ((DynamicObject)this.getModel().getValue("year")).getLong("id");
        long periodId = ((DynamicObject)this.getModel().getValue("period")).getLong("id");
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and(new QFilter("year", "=", (Object)yearId));
        filter.and(new QFilter("period", "=", (Object)periodId));
        filter.and(new QFilter("scenario", "=", (Object)senceId));
        filter.and(new QFilter("org", "in", originalOrgId));
        return filter;
    }

    private boolean isFilterNull() {
        return this.getModel().getValue("scenario") == null || this.getModel().getValue("year") == null || this.getModel().getValue("period") == null || this.getModel().getValue(process) == null;
    }

    public QFilter getChkReportFilter() {
        String chkresult = (String)this.getModel().getValue("chkresult");
        String chkeffect = (String)this.getModel().getValue("chkeffect");
        QFilter filter = new QFilter("chkresulttype", "=", (Object)chkresult);
        filter.and(new QFilter("chkformula.chkeffecttype", "=", (Object)chkeffect));
        return filter;
    }

    @Override
    public List<String> getDimKeys() {
        return Lists.newArrayList((Object[])new String[]{"scenario", "year", "period", process});
    }

    @Override
    public List<String> getUserSelectDimKeys() {
        return Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    }

    @Override
    public void setDefaultProcess() {
        Object currency;
        if ("reportlist".equals(this.getFormCustomParam("page")) && (currency = this.getFormCustomParam("currency")) != null) {
            IDNumberTreeNode ccyNode = MemberReader.findCurrencyMemberById((String)this.getCurModelNumber(), (Long)LongUtil.toLong((Object)currency));
            DynamicObject defaultCurrency = OrgCurrencyServiceHelper.getOrgDefaultCurrency((long)this.getModelId(), (long)LongUtil.toLong((Object)this.getPageCache().get("entityselectedNodeId")), (String)"DC");
            if ("EC".equals(ccyNode.getNumber()) || "DC".equals(ccyNode.getNumber()) || defaultCurrency.getString("number").equals(ccyNode.getNumber())) {
                this.setProcess(true);
            } else {
                this.setProcess(false);
            }
            return;
        }
        this.setProcess(true);
    }

    private void setProcess(boolean isEC) {
        if (isEC) {
            Long eirptId = MemberReader.findProcessMemberByNum((String)this.getCurModelNumber(), (String)"EIRpt").getId();
            Long eradjId = MemberReader.findProcessMemberByNum((String)this.getCurModelNumber(), (String)"ERAdj").getId();
            Long erptId = MemberReader.findProcessMemberByNum((String)this.getCurModelNumber(), (String)"ERpt").getId();
            this.getModel().beginInit();
            this.getModel().setValue(process, (Object)new Long[]{eirptId, eradjId, erptId});
            this.getModel().endInit();
        } else {
            Long irptId = MemberReader.findProcessMemberByNum((String)this.getCurModelNumber(), (String)"IRpt").getId();
            Long radjId = MemberReader.findProcessMemberByNum((String)this.getCurModelNumber(), (String)"RAdj").getId();
            Long rptId = MemberReader.findProcessMemberByNum((String)this.getCurModelNumber(), (String)"Rpt").getId();
            this.getModel().beginInit();
            this.getModel().setValue(process, (Object)new Long[]{irptId, radjId, rptId});
            this.getModel().endInit();
        }
    }

    @Override
    public QFilter getTmpSpecialHandleQfilter() {
        return new QFilter("1", "=", (Object)1);
    }

    @Override
    public QFilter getQFilter() {
        QFilter filter = super.getQFilter();
        long currUserId = Long.parseLong(RequestContext.get().getUserId());
        boolean checkMGStatus = (Boolean)ThreadCache.get((Object)("checkMGStatus_" + currUserId + this.getModelId()), () -> BcmFunPermissionHelper.needCheckMGStatus((long)currUserId, (long)this.getModelId()));
        if (checkMGStatus) {
            QFilter auditPermFilter = (QFilter)ThreadCache.get((Object)("checkMGStatus_noperm_" + currUserId + this.getModelId()), this::checkAuditPerm);
            filter.and(auditPermFilter);
        }
        this.setNoneTempalteFilter(filter);
        String templateNumber = this.getPageCache().get("templateselectedNodeNumber");
        if (kd.bos.util.StringUtils.isNotEmpty((String)templateNumber) && "TemplateNone".equals(templateNumber)) {
            filter.and(new QFilter("chkformula.multitemplate.fbasedataid", "=", null));
        } else if (kd.bos.util.StringUtils.isNotEmpty((String)templateNumber) && !"root".equals(templateNumber)) {
            filter.and(new QFilter("chkformula.multitemplate.fbasedataid.number", "=", (Object)templateNumber));
        }
        if (this.getFormCustomParam("mergedim") != null && this.getPageCache().get("fromMergeControlExecuted") == null) {
            Long processId;
            Long chkSettingId = (Long)this.getFormCustomParam("chksettingid");
            if (chkSettingId != null) {
                filter.and(new QFilter("chkformula", "=", (Object)chkSettingId));
            }
            if ((processId = (Long)this.getFormCustomParam("processId")) != null) {
                filter.and(new QFilter(process, "=", (Object)processId));
            }
            this.getPageCache().put("fromMergeControlExecuted", "true");
        }
        DynamicObject cslScheme = (DynamicObject)this.getModel().getValue("cslscheme");
        QFilter cslFilter = new QFilter("chkformula.mulcslscheme.fbasedataid", "=", null);
        if (cslScheme != null) {
            cslFilter.or("chkformula.mulcslscheme.fbasedataid", "=", (Object)cslScheme.getLong("id"));
            filter.and(new QFilter("cslscheme", "=", (Object)0).and(cslFilter).or("cslscheme", "=", (Object)cslScheme.getLong("id")));
        }
        return filter;
    }

    private QFilter checkAuditPerm() {
        long orgId = this.orgTabInfo.getId();
        McStatus mcStatus = McStatus.getMcStatus((Object)this.getModelId(), (Object)orgId, (Object)this.getId("scenario"), (Object)this.getId("year"), (Object)this.getId("period"));
        if (mcStatus.getFlow().isSubmit()) {
            return new QFilter("1", "=", (Object)1);
        }
        return new QFilter("1", "=", (Object)0);
    }

    protected Map<String, String> getCurrentFilterParam(List<String> dims, String property) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : dims) {
            if (process.equals(key)) {
                DynamicObjectCollection doc = (DynamicObjectCollection)this.getModel().getValue(key);
                if (!doc.isEmpty()) continue;
                return null;
            }
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(key);
            if (dynamicObject == null) {
                return null;
            }
            map.put(key, dynamicObject.getString(property));
        }
        return map;
    }

    private void checkUpCheck(ItemClickEvent evt) {
        ArrayList pageDims = Lists.newArrayList((Object[])new String[]{"model", "scenario", "year", "period"});
        Map<String, String> map = this.getCurrentFilterParam(pageDims, "number");
        Map<String, String> f7IdMap = this.getCurrentFilterParam(pageDims, "id");
        if (map == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"CheckUpChkReportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList list = (BillList)this.getControl("billlistap");
        if (CollectionUtils.isEmpty((Collection)list.getSelectedRows())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"CheckUpChkReportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] ids = list.getSelectedRows().getPrimaryKeyValues();
        DynamicObjectCollection chkReports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"id,org.id,org.number", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        if (chkReports.size() < ids.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u62a5\u544a\u5df2\u7ecf\u5237\u65b0\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"CheckUpChkReportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String orgId = this.getPageCache().get("entityselectedNodeId");
        IDNumberTreeNode entityMemberById = MemberReader.findEntityMemberById((String)this.getCurModelNumber(), (Long)Long.parseLong(orgId));
        if (entityMemberById.getParent() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u7ec4\u7ec7\u7684\u6839\u8282\u70b9\u4e0a\u6267\u884c\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"CheckUpChkReportPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Long, List> orgId2ReportIds = new HashMap<Long, List>();
        chkReports.forEach(v -> orgId2ReportIds.computeIfAbsent(v.getLong("org.id"), p -> new ArrayList()).add(v.getLong("id")));
        if (chkReports.size() == 1 && MergeControlHelper.isQuoteLocked((Long)this.getModelId(), (Long)LongUtil.toLong((Object)f7IdMap.get("scenario")), (Long)LongUtil.toLong((Object)f7IdMap.get("year")), (Long)LongUtil.toLong((Object)f7IdMap.get("period")), (Long)((DynamicObject)chkReports.get(0)).getLong("org.id"))) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioVersionError"), new Object[0]);
        }
        if (MergeControlHelper.isQuoteScene((Long)this.getModelId(), (Long)LongUtil.toLong((Object)f7IdMap.get("scenario")))) {
            Set allVersionedOrgs = MergeControlHelper.getAllVersionedOrgs((Long)this.getModelId(), (Long)LongUtil.toLong((Object)f7IdMap.get("scenario")), (Long)LongUtil.toLong((Object)f7IdMap.get("year")), (Long)LongUtil.toLong((Object)f7IdMap.get("period")));
            chkReports.forEach(o -> {
                if (!allVersionedOrgs.contains(o.getString("org.number"))) {
                    orgId2ReportIds.remove(o.getLong("org.id"));
                }
            });
            if (orgId2ReportIds.isEmpty()) {
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioVersionError"), new Object[0]);
            }
        }
        ArrayList ctxList = new ArrayList();
        orgId2ReportIds.forEach((k, v) -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)k);
            this.addCtxList(evt, map, orgId, ctxList, (List<Long>)v, node);
        });
        if (this.isAllRecheck(evt)) {
            ChkCheckTaskHelper.createTask((AbstractFormPlugin)this.getPlugin(), ctxList, (int)4);
        } else {
            ChkCheckTaskHelper.createTask((AbstractFormPlugin)this.getPlugin(), ctxList, (int)3);
        }
    }

    private IDNumberTreeNode findNode(String orgId, IDNumberTreeNode node) {
        IDNumberTreeNode copyNode = node;
        List shareNodes = null;
        if (!copyNode.isShare()) {
            shareNodes = copyNode.getShareNodes();
        }
        do {
            if (!String.valueOf(copyNode.getId()).equals(orgId)) continue;
            return node;
        } while ((copyNode = copyNode.getParent()) != null);
        if (shareNodes != null) {
            for (IDNumberTreeNode shareNode : shareNodes) {
                IDNumberTreeNode node1 = this.findNode(orgId, shareNode);
                if (node1 == null) continue;
                return node1;
            }
        }
        return null;
    }

    private void addCtxList(ItemClickEvent evt, Map<String, String> map, String orgId, List<CalContext> ctxList, List<Long> v, IDNumberTreeNode node) {
        IDNumberTreeNode findNode = this.findNode(orgId, node);
        if (findNode != null) {
            CalContext ctx = new CalContext(map.get("model"), node.getNumber(), map.get("year"), map.get("period"), map.get("scenario"), null);
            ctx.setProperty("reportIds", v);
            ctx.setProperty("originalOrgId", (Object)findNode.getId());
            ctx.setProperty("chksourcetype", (Object)ChkSourceEnum.CHECK_REPORT);
            if (this.isAllRecheck(evt)) {
                ctx.setProperty("chksourcetype", (Object)ChkSourceEnum.RECHECK_REPORT);
            }
            ctxList.add(ctx);
        }
    }

    private void doRefreshBillList(SearchClickEvent evt) {
        FilterParameter filterParameter = evt.getFilterParameter();
        List fastQFilters = evt.getFastQFilters();
        List commonFilters = filterParameter.getQFilters();
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue("model");
        if (modelDy != null) {
            QFilter qFilter = new QFilter("model", "=", (Object)modelDy.getLong("id"));
            if (CollectionUtils.isNotEmpty((Collection)fastQFilters)) {
                for (QFilter fastFilter : fastQFilters) {
                    if ("processfilter".equals(fastFilter.getProperty())) {
                        qFilter.and("process.number", fastFilter.getCP(), (Object)fastFilter.getValue().toString());
                        continue;
                    }
                    qFilter.and(fastFilter);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)commonFilters)) {
                for (QFilter commonFilter : commonFilters) {
                    if ("processfilter".equals(commonFilter.getProperty())) {
                        qFilter.and("process.number", commonFilter.getCP(), (Object)commonFilter.getValue().toString());
                        continue;
                    }
                    qFilter.and(commonFilter);
                }
            }
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.clearSelection();
            billList.setFilter(qFilter);
            billList.refresh();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        if (qFilters.stream().noneMatch(q -> "model".equals(q.getProperty()))) {
            qFilters.add(this.getQFilter().and(new QFilter("chkformula.status", "=", (Object)CHKFormulaStatusEnum.enable.getIndex())));
        } else {
            qFilters.add(new QFilter("chkformula.status", "=", (Object)CHKFormulaStatusEnum.enable.getIndex()));
        }
    }

    public Long getId(String f7Name) {
        Object value = this.getModel().getValue(f7Name);
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        return (Long)value;
    }
}

