/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.chkcheck.util.CheckedSettingUtil;
import kd.fi.bcm.business.chkcheck.util.DimMemberQueryUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.LogConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkMemberRangeLimitTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkMemberTypeEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MemberRangeUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.IOperationLog;
import org.apache.commons.lang3.StringUtils;

public class CheckedBatchEditPlugin
extends AbstractBaseFormPlugin
implements IOperationLog {
    private static final String BTN_OK = "btn_ok";
    private static final String FIELD_CONTENT = "fieldcontent";
    private static final String FIELD_BATCHEDIT = "batcheditfield";
    private static final String RADIO_GROUP = "radiogroup";
    private static final String RADIO_ADDNEW = "radio_addnew";
    private static final String RADIO_OVERWRITE = "radio_overwrite";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(FIELD_CONTENT, BTN_OK, RADIO_ADDNEW, RADIO_OVERWRITE);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (FIELD_BATCHEDIT.equals(name)) {
            this.getPageCache().remove(FIELD_CONTENT);
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newValue)) {
                this.getModel().setValue(FIELD_CONTENT, null);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_CONTENT, RADIO_ADDNEW, RADIO_OVERWRITE});
            } else {
                ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_BATCHEDIT);
                ComboProp comboProp = (ComboProp)comboEdit.getProperty();
                LocaleString itemName = new LocaleString();
                for (ValueMapItem item : comboProp.getComboItems()) {
                    if (!newValue.equals(item.getValue())) continue;
                    itemName = item.getName();
                    break;
                }
                TextEdit fieldContent = (TextEdit)this.getControl(FIELD_CONTENT);
                fieldContent.setCaption(itemName);
                this.getModel().setValue(FIELD_CONTENT, null);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_CONTENT, RADIO_ADDNEW, RADIO_OVERWRITE});
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_CONTENT, RADIO_ADDNEW, RADIO_OVERWRITE});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (FIELD_CONTENT.equals(source.getKey())) {
            this.showMulTiF7(FIELD_CONTENT, this.getDimNumber());
        }
        if (BTN_OK.equals(source.getKey())) {
            String fieldContent = this.getPageCache().get(FIELD_CONTENT);
            String radioGroupValue = this.getRadioGroupValue();
            if (StringUtils.isBlank((CharSequence)fieldContent) && RadioEnum.addNew.getRadioValue().equals(radioGroupValue)) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u7f16\u8f91\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u516c\u5f0f\u65e0\u53d8\u5316\u3002", (String)"CheckedBatchEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            if (StringUtils.isBlank((CharSequence)fieldContent) && RadioEnum.overWrite.getRadioValue().equals(radioGroupValue) && !"3".equals(this.getFieldBatcheditValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6279\u91cf\u7f16\u8f91\u7684\u5185\u5bb9\u3002", (String)"CheckedBatchEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            List<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
            if (StringUtils.isNotBlank((CharSequence)fieldContent)) {
                list = (List)SerializationUtils.fromJsonString((String)fieldContent, List.class);
            }
            this.updateMemberRange(list, radioGroupValue);
        }
    }

    private void updateMemberRange(List<Map<String, String>> list, String updateType) {
        List selectRows = (List)this.getFormCustomParam("selectrow");
        String dimNumber = this.getDimNumber();
        int limitType = this.getLimitType();
        Long dimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dimNumber);
        QFilter filter = new QFilter("id", "in", (Object)selectRows);
        DynamicObject[] memberRanges = BusinessDataServiceHelper.load((String)"bcm_chkformulasetting", (String)"id,number,rangetxt,vrangetxt,modifier,modifytime,memberrange,memberrange.memberid,memberrange.membbound,memberrange.dimension,memberrange.membboundtype,memberrange.limittype,memberrange.propertyid,memberrange.seq", (QFilter[])filter.toArray());
        StringBuilder rangetxtSb = new StringBuilder();
        StringBuilder vrangetxtSb = new StringBuilder();
        this.buildRangeTxt(list, dimNumber, rangetxtSb, vrangetxtSb, limitType);
        boolean isAddCustProp = list.stream().anyMatch(e -> StringUtils.isNotEmpty((CharSequence)((CharSequence)e.get("pid"))));
        for (DynamicObject dy : memberRanges) {
            String realUpdateType = this.isMembrTypeClash(dy, isAddCustProp, dimensionId, limitType) ? RadioEnum.overWrite.getRadioValue() : updateType;
            dy.set("modifier", (Object)RequestContext.get().getUserId());
            dy.set("modifytime", (Object)TimeServiceHelper.now());
            DynamicObjectCollection memberRange = dy.getDynamicObjectCollection("memberrange");
            memberRange.removeIf(m -> RadioEnum.overWrite.getRadioValue().equals(realUpdateType) && dimensionId.equals(m.getLong("dimension.id")) && limitType == m.getInt("limittype"));
            for (int i = 0; i < list.size(); ++i) {
                Map<String, String> stringStringMap = list.get(i);
                String memberId = stringStringMap.get("id");
                if (RadioEnum.addNew.getRadioValue().equals(realUpdateType) && memberRange.stream().anyMatch(m -> m.getString("memberid").equals(memberId) && limitType == m.getInt("limittype"))) {
                    String memName = MemberReader.findMemberById((long)this.getModelId(), (String)DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimNumber), (Long)LongUtil.toLong((Object)memberId)).getName();
                    throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.batchEditMemberDuplicate"), new Object[]{memName});
                }
                DynamicObject dynamicObject = memberRange.addNew();
                dynamicObject.set("memberid", (Object)memberId);
                dynamicObject.set("membbound", (Object)stringStringMap.get("scope"));
                dynamicObject.set("dimension", (Object)dimensionId);
                dynamicObject.set("membboundtype", (Object)(StringUtils.isEmpty((CharSequence)stringStringMap.get("pid")) ? ChkMemberTypeEnum.DIMENSION.getMemberType() : ChkMemberTypeEnum.PROPERTY.getMemberType()));
                dynamicObject.set("propertyid", (Object)(StringUtils.isEmpty((CharSequence)stringStringMap.get("pid")) ? Long.valueOf(0L) : LongUtil.toLong((Object)stringStringMap.get("pid"))));
                dynamicObject.set("limittype", (Object)limitType);
                dynamicObject.set("seq", (Object)(i + 1));
            }
            this.updateRangeTxt(dimNumber, dy, rangetxtSb, limitType, 1, realUpdateType);
            this.updateRangeTxt(dimNumber, dy, vrangetxtSb, limitType, 2, realUpdateType);
        }
        LogConstant logConstant = new LogConstant();
        try (TXHandle txHandle = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])memberRanges);
                this.writeOperationLog(this.getOperationBatchEdit(), logConstant.getOperationStatusSuccess());
                this.returnDataToParent(true);
                this.getView().close();
            }
            catch (Exception e2) {
                txHandle.markRollback();
                this.getView().showErrorNotification(this.getOperationBatchEditFail());
                this.writeOperationLog(this.getOperationBatchEdit(), logConstant.getOperationStatusFail());
            }
        }
    }

    private boolean isMembrTypeClash(DynamicObject memberRanges, boolean isAddCustProp, long dimensionId, int limitType) {
        boolean allNotSetting;
        if (limitType == Integer.parseInt(ChkMemberRangeLimitTypeEnum.OUTBOUND.getLimitType()) && (allNotSetting = memberRanges.getDynamicObjectCollection("memberrange").stream().noneMatch(m -> m.getLong("dimension.id") == dimensionId && m.getInt("limittype") == limitType))) {
            return false;
        }
        boolean selRowHasCustProp = memberRanges.getDynamicObjectCollection("memberrange").stream().anyMatch(m -> m.getLong("dimension.id") == dimensionId && m.getInt("limittype") == limitType && m.get("propertyid") != null);
        return isAddCustProp != selRowHasCustProp;
    }

    private void updateRangeTxt(String dimNumber, DynamicObject dy, StringBuilder rangetxtSb, int limitType, int type, String updateType) {
        String rangetxt = this.getRangeTxt(dy, type);
        String[] split = rangetxt.split(";");
        List newMembrs = Arrays.stream(rangetxtSb.toString().substring(rangetxtSb.indexOf(":") + 1).split(",")).collect(Collectors.toList());
        boolean start = false;
        boolean findDim = false;
        for (int i = 0; i < split.length; ++i) {
            String s = split[i].trim();
            if (this.isStartOfDimInRangeTxt(dimNumber, limitType, s, type)) {
                start = true;
                findDim = true;
                if (RadioEnum.overWrite.getRadioValue().equals(updateType)) {
                    split[i] = rangetxtSb.toString();
                    continue;
                }
                List<String> origMembrs = Arrays.asList(split[i].substring(split[i].indexOf(":") + 1).split(","));
                newMembrs.removeIf(origMembrs::contains);
                if (newMembrs.isEmpty()) continue;
                split[i] = split[i] + "," + String.join((CharSequence)",", newMembrs);
                continue;
            }
            if (!start) continue;
            if (s.contains(":")) {
                start = false;
                continue;
            }
            split[i] = "";
        }
        this.setRangeTxt(dy, rangetxtSb, type, split, findDim);
    }

    private void setRangeTxt(DynamicObject dy, StringBuilder rangetxtSb, int type, String[] split, boolean findDim) {
        if (type == 1) {
            dy.set("rangetxt", (Object)this.processTxt(split, findDim, rangetxtSb, true));
        }
        if (type == 2) {
            dy.set("vrangetxt", (Object)this.processTxt(split, findDim, rangetxtSb, false));
        }
    }

    private String getRangeTxt(DynamicObject dy, int type) {
        if (type == 1) {
            return dy.getString("rangetxt");
        }
        if (type == 2) {
            return dy.getString("vrangetxt");
        }
        return "";
    }

    private boolean isStartOfDimInRangeTxt(String dimNumber, int limitType, String s, int type) {
        if (type == 1) {
            return s.startsWith(CheckedSettingUtil.convertDim2ChkRange((String)dimNumber, (int)limitType) + ":");
        }
        if (type == 2) {
            return this.isInboundEntity(dimNumber, limitType) && s.startsWith("ValidEntities") || this.isOutboundEntity(dimNumber, limitType) && s.startsWith("InvalidEntities") || !DimTypesEnum.ENTITY.getNumber().equals(dimNumber) && s.startsWith(DimTypesEnum.getShortNumberByNumber((String)dimNumber) + ":");
        }
        return s.startsWith(CheckedSettingUtil.convertDim2ChkRange((String)dimNumber, (int)limitType) + ":");
    }

    private boolean isOutboundEntity(String dimNumber, int limitType) {
        return DimTypesEnum.ENTITY.getNumber().equals(dimNumber) && ChkMemberRangeLimitTypeEnum.OUTBOUND.getLimitType().equals("" + limitType);
    }

    private boolean isInboundEntity(String dimNumber, int limitType) {
        return DimTypesEnum.ENTITY.getNumber().equals(dimNumber) && ChkMemberRangeLimitTypeEnum.INBOUND.getLimitType().equals("" + limitType);
    }

    private String processTxt(String[] split, boolean findDim, StringBuilder rangetxtSb, boolean needSpace) {
        String newRangeTxt;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (StringUtils.isBlank((CharSequence)s)) continue;
            if (s.contains(":") && i > 0) {
                builder.append(";");
                if (needSpace) {
                    builder.append(" ");
                }
                builder.append(s.trim());
                continue;
            }
            if (s.contains(":")) {
                builder.append(s.trim());
                continue;
            }
            builder.append(",").append(s.trim());
        }
        builder.append(";");
        if (!findDim) {
            int index = builder.indexOf(";", builder.indexOf(";") + 1) + 1;
            builder.insert(index, ";");
            if (needSpace) {
                builder.insert(index++, " ");
            }
            newRangeTxt = builder.insert(index, rangetxtSb).toString();
        } else {
            newRangeTxt = builder.toString();
        }
        return needSpace ? newRangeTxt + " " : newRangeTxt;
    }

    private void buildRangeTxt(List<Map<String, String>> list, String dimNumber, StringBuilder rgtxtSb, StringBuilder vrgtxtSb, int limitType) {
        if (list.isEmpty()) {
            return;
        }
        StringJoiner rangeTxtBuilder = new StringJoiner(",");
        rgtxtSb.append(CheckedSettingUtil.convertDim2ChkRange((String)dimNumber, (int)limitType)).append(":");
        StringJoiner vrangeTxtBuilder = new StringJoiner(",");
        if (this.isInboundEntity(dimNumber, limitType)) {
            vrgtxtSb.append("ValidEntities");
        } else if (this.isOutboundEntity(dimNumber, limitType)) {
            vrgtxtSb.append("InvalidEntities");
        } else {
            vrgtxtSb.append(DimTypesEnum.getShortNumberByNumber((String)dimNumber));
        }
        vrgtxtSb.append(":");
        list.forEach(map -> {
            rangeTxtBuilder.add(MemberRangeUtil.getMemberRangeStr((String)((String)map.get("name")), (int)Integer.parseInt((String)map.get("scope"))));
            vrangeTxtBuilder.add(String.format("%s[%s]", MemberRangeUtil.getMemberRangeNumber((int)Integer.parseInt((String)map.get("scope"))), map.get("number")));
        });
        rgtxtSb.append(rangeTxtBuilder);
        vrgtxtSb.append(vrangeTxtBuilder);
    }

    private OpNameMultiLangEnumBridge getOperationBatchEdit() {
        return new OpNameMultiLangEnumBridge("\u6279\u91cf\u7f16\u8f91", "CheckedBatchEditPlugin_0", "fi-bcm-formplugin", "batchEdit");
    }

    private String getOperationBatchEditFail() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"CheckedBatchEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getRadioGroupValue() {
        return (String)this.getModel().getValue(RADIO_GROUP);
    }

    private String getFieldBatcheditValue() {
        return (String)this.getModel().getValue(FIELD_BATCHEDIT);
    }

    private String getDimNumber() {
        String field = this.getFieldBatcheditValue();
        if ("1".equals(field)) {
            return DimTypesEnum.SCENARIO.getNumber();
        }
        if ("4".equals(field)) {
            return DimTypesEnum.PROCESS.getNumber();
        }
        return DimTypesEnum.ENTITY.getNumber();
    }

    private int getLimitType() {
        String field = this.getFieldBatcheditValue();
        if ("3".equals(field)) {
            return Integer.parseInt(ChkMemberRangeLimitTypeEnum.OUTBOUND.getLimitType());
        }
        return Integer.parseInt(ChkMemberRangeLimitTypeEnum.INBOUND.getLimitType());
    }

    private void showMulTiF7(String key, String number) {
        DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumber((long)this.getModelId(), (String)number);
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_mulmemberf7base_tem");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("dimension", (Object)dim.getString("dseq"));
        para.setCustomParam("sign", (Object)key);
        if (DimTypesEnum.PROCESS.getNumber().equals(number)) {
            para.setCustomParam("customFilter", (Object)new QFilter("id", "in", (Object)DimMemberQueryUtil.findDimAllSonMembs((Long)this.getModelId(), (String)"bcm_processmembertree", Arrays.asList("CCTotal", "CT"))).toSerializedString());
        }
        if (DimTypesEnum.ENTITY.getNumber().equals(number)) {
            para.setCustomParam("rootid", this.getFormCustomParam("org"));
            para.setCustomParam("cslscheme", this.getFormCustomParam("cslscheme"));
        }
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"ChechedBasicInfoPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString("name")));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if (key.equals(FIELD_CONTENT)) {
            String field = this.getFieldBatcheditValue();
            boolean isEntity = "2".equals(field) || "3".equals(field);
            DynamicObjectCollection doc = (DynamicObjectCollection)cb.getReturnData();
            if (doc != null) {
                String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
                StringBuilder sb = new StringBuilder();
                ArrayList list = new ArrayList(doc.size());
                for (DynamicObject dynamicObject : doc) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    String id = dynamicObject.get(4).toString();
                    String name = dynamicObject.get(3).toString();
                    if (isEntity) {
                        IDNumberTreeNode entity = MemberReader.findEntityMemberById((String)modelNum, (Long)Long.parseLong(id));
                        id = entity.getStorageType() == StorageTypeEnum.SHARE ? entity.getCopyfromId().toString() : id;
                        name = entity.getStorageType() == StorageTypeEnum.SHARE ? MemberReader.findEntityMemberById((String)modelNum, (Long)Long.parseLong(id)).getName() : name;
                    }
                    map.put("id", id);
                    map.put("scope", dynamicObject.get(5).toString());
                    map.put("number", dynamicObject.get(2).toString());
                    map.put("name", name);
                    map.put("pid", dynamicObject.get(6).toString());
                    if (RangeEnum.getRangeByVal((int)dynamicObject.getInt(5)) == RangeEnum.VALUE_10) {
                        sb.append(dynamicObject.get(3).toString()).append(',');
                    } else {
                        sb.append(dynamicObject.get(3).toString()).append(ResManager.loadKDString((String)"\u7684", (String)"ChechedBasicInfoPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)dynamicObject.getInt(5)).getName()).append(',');
                    }
                    list.add(map);
                }
                if (StringUtils.isEmpty((CharSequence)sb.toString())) {
                    this.getModel().setValue(key, (Object)"");
                    this.getPageCache().put(key, null);
                } else {
                    this.getModel().setValue(key, (Object)sb.substring(0, sb.length() - 1));
                    this.getPageCache().put(key, SerializationUtils.toJsonString(list));
                }
            }
        }
    }

    static enum RadioEnum {
        addNew("1"),
        overWrite("2");

        private String radioValue;

        private RadioEnum(String radioValue) {
            this.radioValue = radioValue;
        }

        public String getRadioValue() {
            return this.radioValue;
        }
    }
}

