/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.util.CheckedFormulaUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.script.CommonFormulaModel;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.formula.validate.IValidate;
import kd.fi.bcm.formplugin.intergration.formula.validate.NotNullValidate;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import org.apache.commons.collections.CollectionUtils;

public class CheckedFormulaPlugin
extends AbstractBaseFormPlugin
implements SubPage,
DynamicPage {
    private String MAPCACHE = "mapcache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("leftpanel", "rightpanel");
        this.addClickListeners("btn_del", "btn_+", "btn_-", "btn_*", "btn_/", "btn_(", "btn_)", "btn_v");
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getPage(this.getView()) != null) {
            this.getPage(this.getView()).bindCtrlMapping(this.getView());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.checkAndBuildEditPage();
    }

    private void checkAndBuildEditPage() {
        ChkFormulaModel model = (ChkFormulaModel)this.deSerializedBytes((String)this.getFormCustomParam("checkmodel"));
        if (model != null && model.isEdit()) {
            CustomControl custom = (CustomControl)this.getView().getControl("formulasettingtext");
            if (ChkFormulaServiceHelper.isJudgeFormula((String)model.getLformulatemp())) {
                custom.setData(CheckedFormulaUtil.buildJudgeFormula((ChkFormulaModel)model, (IPageCache)this.getPageCache()));
            } else {
                custom.setData(CheckedFormulaUtil.packFormula((ChkFormulaModel)model, (IPageCache)this.getPageCache()));
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("formula_fx_")) {
            this.showVPanel("formula_fx_", key, this.getPageCache().get(key));
        } else if (key.startsWith("formula_temp_")) {
            this.showVPanel("formula_temp_", key, this.getPageCache().get(key));
        }
    }

    private void showVPanel(String type, String key, Object param) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_vformula");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        FormulaTicketer ticketer = this.buildTicketer(type, key);
        formShowParameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
        formShowParameter.setCustomParam("formula", param);
        CloseCallBack closeCallBack = key != null ? new CloseCallBack((IFormPlugin)this, key) : new CloseCallBack((IFormPlugin)this, "formulacb");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private FormulaTicketer buildTicketer(String type, String key) {
        FormulaTicketer ticketer = new FormulaTicketer();
        IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
        DynamicObjectCollection alldims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        for (DynamicObject obj : alldims) {
            String entity = obj.getString("membermodel");
            String number = obj.getString("number");
            String name = obj.getString("name");
            if ("bcm_entitymembertree".equals(entity) || "bcm_currencymembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, false, false));
                continue;
            }
            if ("bcm_periodmembertree".equals(entity) || "bcm_fymembertree".equals(entity) || "bcm_scenemembertree".equals(entity) || "bcm_processmembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, true, true));
                continue;
            }
            String sign = this.sugarF7Key(entity, number);
            ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true));
        }
        String csche = this.getPageCache().get(this.MAPCACHE);
        if (csche != null) {
            List doc = (List)this.deSerializedBytes(csche);
            for (Map obj : doc) {
                String number = (String)obj.get("number");
                String name = (String)obj.get("name");
                String sign = DimEntityNumEnum.getEntieyNumByNumber((String)number);
                if ("bcm_userdefinedmembertree".equals(sign)) {
                    sign = this.sugarF7Key(sign, number);
                }
                ticketer.addTicket(sign, new FTicket(DimEntityNumEnum.getEntieyNumByNumber((String)number), name, null, true));
            }
        }
        return ticketer;
    }

    private FormulaTicketer<String> buildTicketer() {
        FormulaTicketer<String> ticketer = new FormulaTicketer<String>();
        IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
        DynamicObjectCollection alldims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        for (DynamicObject obj : alldims) {
            String entity = obj.getString("membermodel");
            String number = obj.getString("number");
            String name = obj.getString("name");
            if ("bcm_entitymembertree".equals(entity) || "bcm_currencymembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, false, false));
                continue;
            }
            if ("bcm_periodmembertree".equals(entity) || "bcm_fymembertree".equals(entity) || "bcm_scenemembertree".equals(entity) || "bcm_processmembertree".equals(entity) || "bcm_audittrialmembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, true, true));
                continue;
            }
            String sign = this.sugarF7Key(entity, number);
            ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true));
        }
        String csche = this.getPageCache().get(this.MAPCACHE);
        if (csche != null) {
            List doc = (List)this.deSerializedBytes(csche);
            for (Map obj : doc) {
                String number = (String)obj.get("number");
                String name = (String)obj.get("name");
                String sign = DimEntityNumEnum.getEntieyNumByNumber((String)number);
                if ("bcm_userdefinedmembertree".equals(sign)) {
                    sign = this.sugarF7Key(sign, number);
                }
                ticketer.addTicket(sign, new FTicket(DimEntityNumEnum.getEntieyNumByNumber((String)number), name, null, true));
            }
        }
        return ticketer;
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if ("formulacb".equals(key)) {
            if (cb.getReturnData() != null) {
                String formula = cb.getReturnData().toString();
                String sign = CheckedFormulaUtil.getComboSign((String)"formula_fx_");
                this.getPageCache().put(sign, formula);
                this.getPageCache(this.getView().getParentView()).put("ismodifer", "true");
                CustomControl custom = (CustomControl)this.getView().getControl("formulasettingtext");
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)ChkFormulaServiceHelper.translateChkformla((String)formula, (long)this.getModelId(), (int)1)));
            }
        } else if (key.startsWith("formula_extends_")) {
            this.putXdmFormula2Cache(cb, key, key);
        } else if (key.startsWith("formula")) {
            if (cb.getReturnData() != null) {
                String formula = cb.getReturnData().toString();
                this.getPageCache().put(key, formula);
                String tmpnumber = this.getPageCache().get(key + "formula_temp");
                if (StringUtils.isNotEmpty((String)tmpnumber)) {
                    String formulatmp = formula.replaceAll("V\\(", "V\\(\"@TMP." + tmpnumber + "\",");
                    this.getPageCache().put(key + "formula_withtemp", formulatmp);
                }
                CustomControl custom = (CustomControl)this.getView().getControl("formulasettingtext");
                custom.setData(CheckedFormulaUtil.packGetText());
                this.getPageCache(this.getView().getParentView()).put("ismodifer", "true");
            }
        } else if ("addExtendFormula".equals(key)) {
            String sign = CheckedFormulaUtil.getComboSign((String)"formula_extends_");
            this.putXdmFormula2Cache(cb, sign, key);
        }
    }

    private void putXdmFormula2Cache(ClosedCallBackEvent cb, String sign, String key) {
        if (cb.getReturnData() != null) {
            Map extendsFormula = (Map)cb.getReturnData();
            String fullFormula = (String)extendsFormula.get("xdmscriptbuilder");
            CommonFormulaModel xdmFormulaBuilder = (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)ChkFormulaServiceHelper.parseXdmFormula((String)fullFormula));
            this.getPageCache().put(sign, fullFormula);
            this.getPageCache(this.getView().getParentView()).put("ismodifer", "true");
            CustomControl custom = (CustomControl)this.getView().getControl("formulasettingtext");
            if ("addExtendFormula".equals(key)) {
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)((String)xdmFormulaBuilder.getCondition("chinesename"))));
            } else {
                custom.setData(CheckedFormulaUtil.packGetText());
            }
        }
    }

    @Override
    public void dealMsg(CommandParam com) {
        List<Object> param;
        ChkFormulaModel model;
        CustomControl custom;
        if ("addFormula".equals(com.getOperation())) {
            this.addFormulaCache("formula_temp_", com.getParam().get(0).toString(), com.getParam().get(1).toString(), com.getParam().get(2).toString());
            this.getPageCache(this.getView().getParentView()).put("ismodifer", "true");
            custom = (CustomControl)this.getView().getControl("formulasettingtext");
            String key = CheckedFormulaUtil.getComboSign((String)"formula_temp_");
            this.getPageCache().put(key, com.getParam().get(0).toString());
            this.getPageCache().put(key + "formula_withtemp", com.getParam().get(1).toString());
            this.getPageCache().put(key + "formula_temp", com.getParam().get(2).toString());
            custom.setData(CheckedFormulaUtil.packAddText((String)key, (String)ChkFormulaServiceHelper.translateChkformla((String)com.getParam().get(1).toString(), (long)this.getModelId(), (int)1)));
        }
        if ("saveModel".equals(com.getOperation())) {
            custom = (CustomControl)this.getView().getControl("formulasettingtext");
            custom.setData(CheckedFormulaUtil.packGetText());
            model = (ChkFormulaModel)com.getParam().get(0);
            this.getPageCache().put("checkmodel", this.toByteSerialized(model));
        }
        if ("cacheMap".equals(com.getOperation())) {
            List doc = (List)com.getParam().get(0);
            this.getPageCache().put(this.MAPCACHE, this.toByteSerialized(doc));
        }
        if ("addLevel".equals(com.getOperation())) {
            custom = (CustomControl)this.getView().getControl("formulasettingtext");
            custom.setData(CheckedFormulaUtil.packGetText());
            model = (ChkFormulaModel)com.getParam().get(0);
            this.getPageCache().put("checkmodel", this.toByteSerialized(model));
            this.getPageCache().put("addlevelFlag", "1");
        }
        if ("sureAddLevel".equals(com.getOperation())) {
            this.addLevel();
        }
        if ("closed".equals(com.getOperation())) {
            custom = (CustomControl)this.getView().getControl("formulasettingtext");
            custom.setData(CheckedFormulaUtil.packGetText());
            model = (ChkFormulaModel)com.getParam().get(0);
            this.getPageCache().put("checkmodel", this.toByteSerialized(model));
            this.getPageCache().put("closedFlag", "1");
        }
        if ("addExtendFormula".equals(com.getOperation()) && CollectionUtils.isNotEmpty(param = com.getParam()) && param.get(0) instanceof Map) {
            this.showExtendsFormula((Map)com.getParam().get(0), null);
        }
    }

    private void showExtendsFormula(Map<String, Object> paramMap, String key) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_extendsformula");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = formShowParameter.getCustomParams();
        customParams.putAll(paramMap);
        customParams.put("KEY_MODEL_ID", this.getModelId());
        this.setExtendsModelAndField(customParams, paramMap);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, StringUtils.isEmpty((String)key) ? "addExtendFormula" : key));
        this.getView().showForm(formShowParameter);
    }

    private void setExtendsModelAndField(Map<String, Object> customParams, Map<String, Object> paramMap) {
        Object extField;
        Object extModel = paramMap.get("extendsmodel");
        if (!(extModel instanceof Long)) {
            String extendsModel = String.valueOf(extModel);
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("number", "=", (Object)extendsModel));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                customParams.put("extendsmodel", null);
                customParams.put("extendsfield", null);
                return;
            }
            long extendsModelId = dynamicObject.getLong("id");
            customParams.put("extendsmodel", extendsModelId);
        }
        if (!((extField = paramMap.get("extendsfield")) instanceof Long)) {
            String extendsField = String.valueOf(extField);
            QFilter qFilter1 = new QFilter("extmodelid", "=", customParams.get("extendsmodel")).and(new QFilter("extfield.number", "=", (Object)extendsField));
            DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"extfield", (QFilter[])qFilter1.toArray());
            if (dynamicObject1 == null) {
                customParams.put("extendsfield", null);
                return;
            }
            customParams.put("extendsfield", dynamicObject1.getLong("extfield"));
        }
    }

    public void customEvent(CustomEventArgs e) {
        switch (e.getEventName()) {
            case "f(x)": {
                String key = e.getEventArgs();
                if (StringUtils.isEmpty((String)key)) {
                    VFormula v = this.buildDefaultFormula();
                    this.showVPanel("formula_fx_", null, v.toString());
                    break;
                }
                if (key.startsWith("formula_fx_")) {
                    this.showVPanel("formula_fx_", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("formula_temp_")) {
                    this.showVPanel("formula_temp_", key, this.getPageCache().get(key));
                    break;
                }
                if (!key.startsWith("formula_extends_")) break;
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                String extendsFormula = ChkFormulaServiceHelper.parseXdmFormula((String)this.getPageCache().get(key));
                CommonFormulaModel xdmFormulaBuilder = (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)extendsFormula);
                paramMap.put("extendsmodel", xdmFormulaBuilder.getCondition("extendsmodel"));
                paramMap.put("extendsfield", xdmFormulaBuilder.getCondition("extendsfield"));
                paramMap.put("extendsmdfield", xdmFormulaBuilder.getCondition("extendsmdfield"));
                paramMap.put("scenario", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.SCENARIO.getNumber()));
                paramMap.put("extendsmdfieldvalue", xdmFormulaBuilder.getCondition("extendsmdfieldvalue"));
                paramMap.put("templatename", xdmFormulaBuilder.getCondition("templatename"));
                paramMap.put("template", xdmFormulaBuilder.getCondition("template"));
                paramMap.put("entryentity", xdmFormulaBuilder.getCondition("entryconditions"));
                paramMap.put("year", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.YEAR.getNumber()));
                paramMap.put("period", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.PERIOD.getNumber()));
                paramMap.put("entity", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.ENTITY.getNumber()));
                paramMap.put("currency", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.CURRENCY.getNumber()));
                paramMap.put("process", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.PROCESS.getNumber()));
                paramMap.put("audittrail", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.AUDITTRIAL.getNumber()));
                this.showExtendsFormula(paramMap, key);
                break;
            }
            case "getText": {
                this.getText(e);
                break;
            }
        }
    }

    private void getText(CustomEventArgs e) {
        String text = e.getEventArgs();
        text = text.replaceAll("\n", "");
        text = text.replaceAll("\\p{C}", "");
        String serial = this.getPageCache().get("checkmodel");
        if (this.isClosedOperate()) {
            this.closeOperate(text, serial);
            return;
        }
        if (this.isAddLevelOperate()) {
            this.addLevelOperate(text, serial);
            return;
        }
        if (StringUtils.isEmpty((String)serial)) {
            CustomControl custom = (CustomControl)this.getView().getControl("formulasettingtext");
            String newtext = CheckedFormulaUtil.rebuildDatabyFormula((String)text, (IPageCache)this.getPageCache(), (long)this.getModelId());
            JSONObject data = new JSONObject();
            data.put("operate", (Object)"updateText");
            data.put("data", (Object)newtext);
            custom.setData((Object)data);
            return;
        }
        if (StringUtils.isEmpty((String)text)) {
            String errorText = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u516c\u5f0f\u3002", (String)"CheckedFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            CommandParam com = new CommandParam("bcm_checkedformula", "bcm_checkedmainpage", "saveModel", errorText);
            this.sendMsg(this.getView(), com);
            return;
        }
        this.getPageCache().remove("checkmodel");
        ChkFormulaModel checkmodel = (ChkFormulaModel)this.deSerializedBytes(serial);
        Object[] resultList = CheckedFormulaUtil.changeVFuntionToNumber((String)text, (IPageCache)this.getPageCache());
        String formula = CheckedFormulaUtil.removeTextFormulaItem((String)String.valueOf(resultList[1]));
        Matcher matcher = ParamConstant.INVALID_FORMULA_PATTERN.matcher(String.valueOf(formula));
        if (matcher.find()) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaTextFormatError"), new Object[0]);
        }
        String exepr = CheckedFormulaUtil.getFormulaFromObjectResult((Object[])resultList);
        FormulaPoolManager poolMng = ChkCheckServiceHelper.getPoolMng((String)exepr);
        if (!poolMng.iterator().hasNext()) {
            long quoteCount = String.valueOf(resultList[1]).chars().filter(c -> c == 34).count();
            long leftBracketCount = String.valueOf(resultList[1]).chars().filter(c -> c == 40).count();
            long rightBracketCount = String.valueOf(resultList[1]).chars().filter(c -> c == 41).count();
            if (quoteCount % 2L != 0L || leftBracketCount != rightBracketCount) {
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaMissingSymbol"), new Object[0]);
            }
            if (formula.contains("\uff08") || formula.contains("\uff09")) {
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaBracketError"), new Object[0]);
            }
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaMissingEquation"), new Object[0]);
        }
        if (!CheckedFormulaUtil.validFormulaTextItem((String)String.valueOf(resultList[1]))) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaTextFormatError"), new Object[0]);
        }
        ChkFormulaServiceHelper.checkSpecialFunctionIsNumber((FormulaPoolManager)poolMng, (long)this.getModelId());
        if (ChkFormulaServiceHelper.includeExcelFormula((FormulaPoolManager)poolMng)) {
            CheckedFormulaUtil.checkCanExcecute((Object[])resultList);
            CheckedFormulaUtil.checkFormulaJudge((Object[])resultList, (ChkFormulaModel)checkmodel);
            checkmodel.remove("comparetype");
        } else {
            CheckedFormulaUtil.checkFormula((String)text, (IPageCache)this.getPageCache(), (ChkFormulaModel)checkmodel, (String)((String)resultList[1]));
            this.checkModelFormula(checkmodel);
        }
        CommandParam com = new CommandParam("bcm_checkedformula", "bcm_checkedmainpage", "saveModel", checkmodel);
        this.sendMsg(this.getView(), com);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "addLevel": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    CommandParam com = new CommandParam("bcm_checkedformula", "bcm_checkedmainpage", "addLevel", 1);
                    this.sendMsg(this.getView(), com);
                    break;
                }
                if (!MessageBoxResult.No.equals((Object)evt.getResult())) break;
                CommandParam com = new CommandParam("bcm_checkedformula", "bcm_checkedmainpage", "addLevel", 0);
                this.sendMsg(this.getView(), com);
                break;
            }
        }
    }

    private void addLevel() {
        CustomControl custom = (CustomControl)this.getView().getControl("formulasettingtext");
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"updateText");
        data.put("data", (Object)"");
        custom.setData((Object)data);
    }

    private void addFormulaCache(String type, String formula, String formulawithtmp, String tempnumber) {
        String sign = CheckedFormulaUtil.getComboSign((String)type);
        this.getPageCache().put(sign, formula);
        this.getPageCache().put(sign + "formula_withtemp", formulawithtmp);
        this.getPageCache().put(sign + "formula_temp", tempnumber);
    }

    private VFormula buildDefaultFormula() {
        VFormula v = new VFormula();
        v.initParam(new ParamList());
        QFilter qf = new QFilter("model.id", "=", (Object)this.getModelId());
        QFilter[] qfs = new QFilter[]{qf};
        String selectFields = "id,name,number,shortnumber,issysdimension";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])qfs);
        for (DynamicObject dim : dcs) {
            ParamItem pi;
            String shortnumber = dim.getString("shortnumber");
            boolean issysdimension = dim.getBoolean("issysdimension");
            if (DimTypesEnum.CHANGETYPE.getShortNumber().equals(shortnumber) && this.isExistChangeTypeDimension()) {
                pi = new ParamItem((Object)(DimTypesEnum.CHANGETYPE.getShortNumber() + "." + "EndingBalance"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.INTERCOMPANY.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.INTERCOMPANY.getShortNumber() + "." + "ICNone"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.MULTIGAAP.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.MULTIGAAP.getShortNumber() + "." + "PRCGAAP"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.DATASORT.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.DATASORT.getShortNumber() + "." + "Actual"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.AUDITTRIAL.getShortNumber().equals(shortnumber) && this.isExistAuditTrailDimension()) {
                pi = new ParamItem((Object)(DimTypesEnum.AUDITTRIAL.getShortNumber() + "." + "ATTotal"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (issysdimension) continue;
            pi = new ParamItem((Object)(shortnumber + "." + shortnumber + "None"));
            v.getParamList().add((Object)pi);
        }
        return v;
    }

    protected ChkFormulaModel getChkFormulaModel() {
        String serial = this.getPageCache(this.getView().getParentView()).get("checkmodel");
        ChkFormulaModel checkmodel = (ChkFormulaModel)this.deSerializedBytes(serial);
        return checkmodel;
    }

    private boolean checkModelFormula(ChkFormulaModel model) {
        FormulaTicketer<String> formulaTicketer = this.buildTicketer();
        Map dimensionShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.getCurModelNumber());
        Map dimNumber2Name = MemberReader.getDimNumberMapNameById((long)this.getModelId());
        HashMap dimensionNumber2ShortNumberMap = new HashMap();
        dimensionShortNumber2NumberMap.forEach((k, v) -> dimensionNumber2ShortNumberMap.put(v.toLowerCase(Locale.ENGLISH), k));
        ArrayList needDims = new ArrayList();
        formulaTicketer.forEach(ticketEntry -> {
            if (ticketEntry.getValue() == null || ((FTicket)ticketEntry.getValue()).getValidate() == null) {
                return;
            }
            String dimensionNumber = null;
            dimensionNumber = ((String)ticketEntry.getKey()).contains("bcm_userdefinedmembertree") ? ((String)ticketEntry.getKey()).replace("bcm_userdefinedmembertree_", "").toLowerCase(Locale.ENGLISH) : DimEntityNumEnum.getNumberByEntieyNum((String)((String)ticketEntry.getKey())).toLowerCase(Locale.ENGLISH);
            if (dimensionNumber2ShortNumberMap.containsKey(dimensionNumber)) {
                needDims.add(dimensionNumber2ShortNumberMap.get(dimensionNumber));
            }
        });
        for (Object mre : model.getMapdim()) {
            needDims.remove(mre.getDimension().getShortNumber());
        }
        List leftVList = ChkFormulaServiceHelper.getVList((String)model.getLeftformula());
        for (String v2 : leftVList) {
            String missedDim = ChkCheckServiceHelper.checkFormula((String)v2, needDims);
            if (!StringUtils.isNotEmpty((String)missedDim)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\uff0c\u7ef4\u5ea6\u3010%s\u3011\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CheckedFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimNumber2Name.get(dimensionShortNumber2NumberMap.get(missedDim))));
        }
        List rightVList = ChkFormulaServiceHelper.getVList((String)model.getRightformula());
        for (String v3 : rightVList) {
            String missedDim = ChkCheckServiceHelper.checkFormula((String)v3, needDims);
            if (!StringUtils.isNotEmpty((String)missedDim)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\uff0c\u7ef4\u5ea6\u3010%s\u3011\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CheckedFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimNumber2Name.get(dimensionShortNumber2NumberMap.get(missedDim))));
        }
        return true;
    }

    private boolean isClosedOperate() {
        return this.getPageCache().get("closedFlag") != null && "1".equals(this.getPageCache().get("closedFlag"));
    }

    private void closeOperate(String text, String serial) {
        CommandParam com = null;
        this.getPageCache().remove("closedFlag");
        if (StringUtils.isNotEmpty((String)serial)) {
            if (StringUtils.isEmpty((String)text)) {
                com = new CommandParam("bcm_checkedformula", "bcm_checkedmainpage", "closedConfirm", "");
                this.sendMsg(this.getView(), com);
            } else {
                this.refreshAndCheckFormula(text, serial, "closedConfirm");
            }
        } else {
            CustomControl custom = (CustomControl)this.getView().getControl("formulasettingtext");
            String newtext = CheckedFormulaUtil.rebuildDatabyFormula((String)text, (IPageCache)this.getPageCache(), (long)this.getModelId());
            JSONObject data = new JSONObject();
            data.put("operate", (Object)"updateText");
            data.put("data", (Object)newtext);
            custom.setData((Object)data);
        }
    }

    private boolean isAddLevelOperate() {
        return this.getPageCache().get("addlevelFlag") != null && "1".equals(this.getPageCache().get("addlevelFlag"));
    }

    private void addLevelOperate(String text, String serial) {
        CommandParam com = null;
        this.getPageCache().remove("addlevelFlag");
        if (StringUtils.isNotEmpty((String)serial)) {
            if (StringUtils.isEmpty((String)text)) {
                com = new CommandParam("bcm_checkedformula", "bcm_checkedmainpage", "addlevelConfirm", "");
                this.sendMsg(this.getView(), com);
            } else {
                this.refreshAndCheckFormula(text, serial, "addlevelConfirm");
            }
        }
    }

    private void refreshAndCheckFormula(String text, String serial, String operation) {
        try {
            this.getPageCache().remove("checkmodel");
            ChkFormulaModel checkmodel = (ChkFormulaModel)this.deSerializedBytes(serial);
            Object[] resultList = CheckedFormulaUtil.changeVFuntionToNumber((String)text, (IPageCache)this.getPageCache());
            String exepr = CheckedFormulaUtil.getFormulaFromObjectResult((Object[])resultList);
            FormulaPoolManager poolMng = ChkCheckServiceHelper.getPoolMng((String)exepr);
            if (!poolMng.iterator().hasNext()) {
                CommandParam com = new CommandParam("bcm_checkedformula", "bcm_checkedmainpage", operation, "");
                this.sendMsg(this.getView(), com);
                return;
            }
            if (ChkFormulaServiceHelper.includeExcelFormula((FormulaPoolManager)poolMng)) {
                CheckedFormulaUtil.checkCanExcecute((Object[])resultList);
                CheckedFormulaUtil.checkFormulaJudge((Object[])resultList, (ChkFormulaModel)checkmodel);
            } else {
                CheckedFormulaUtil.checkFormula((String)text, (IPageCache)this.getPageCache(), (ChkFormulaModel)checkmodel, (String)((String)resultList[1]));
                this.checkModelFormula(checkmodel);
            }
            CommandParam com = new CommandParam("bcm_checkedformula", "bcm_checkedmainpage", operation, checkmodel);
            this.sendMsg(this.getView(), com);
        }
        catch (KDBizException kde) {
            CommandParam com = new CommandParam("bcm_checkedformula", "bcm_checkedmainpage", operation, kde.getMessage());
            this.sendMsg(this.getView(), com);
        }
    }
}

