/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.ChkResultMapFormulaModel;
import kd.fi.bcm.business.chkcheck.model.DimensionCombination;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckReportListHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckStatusHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.util.FormulaAnalyseUtil;
import kd.fi.bcm.business.chkcheck.util.NumberQuantileValueUtil;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.chkcheck.CHKCheckEffectEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.spread.formula.EncoderService;

public class CheckedNoteEditPlugin
extends AbstractBaseFormPlugin {
    private static final String IDS = "ids";
    private static final String CURIDS = "curids";
    public static final String bar_per = "bar_per";
    public static final String bar_next = "bar_next";
    public static final String bar_save = "bar_save";
    public static final String bar_saveAndClear = "bar_saveandclear";
    public static final String bar_quit = "bar_quit";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put(IDS, (String)this.getFormCustomParam(IDS));
        if (this.getFormCustomParam("id") != null) {
            long reportid = (Long)this.getFormCustomParam("id");
            try {
                this.loadPage(reportid);
            }
            catch (KDBizException ex) {
                this.getView().showMessage(ex.getMessage());
                this.getView().close();
            }
        }
        if ("true".equals(this.getFormCustomParam("isContainReadOnlyOrg"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{bar_save});
        }
    }

    protected void loadPage(long reportid) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)reportid, (String)"bcm_chkreport");
        if (obj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"CheckedNoteEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("chkresulttype", (Object)obj.getString("chkresulttype"));
        this.getModel().setValue("number", (Object)obj.getString("chkformula.number"));
        this.getModel().setValue("name", (Object)obj.getString("chkformula.name"));
        DynamicObject setobj = BusinessDataServiceHelper.loadSingle((Object)obj.getString("chkformula.id"), (String)"bcm_chkformulasetting");
        String left = "";
        String right = "";
        if (StringUtils.isNotEmpty((String)setobj.getString("lformulatemp"))) {
            left = ChkFormulaServiceHelper.tranFormulas((String)setobj.getString("lformulatemp"), (long)obj.getLong("model.id"), (int)1);
        }
        if (StringUtils.isNotEmpty((String)setobj.getString("rformulatemp"))) {
            right = ChkFormulaServiceHelper.tranFormulas((String)setobj.getString("rformulatemp"), (long)obj.getLong("model.id"), (int)1);
        }
        if (CHKTypeEnum.getCHKTypeEnumByIndex((int)setobj.getInt("comparetype")) != null) {
            this.getModel().setValue("formula", (Object)(left + CHKTypeEnum.getCHKTypeEnumByIndex((int)setobj.getInt("comparetype")).getName() + right));
        } else {
            this.getModel().setValue("formula", (Object)(left + right));
        }
        Map resultmap = FormulaAnalyseUtil.packFormulaResult((String)obj.getString("resultmap"));
        if (resultmap.get("left") == null) {
            String leftF = obj.getString("fulllformula");
            this.getModel().setValue("leftresult", (Object)this.addBracket(obj.getString("leftresult"), leftF));
        } else {
            this.getModel().setValue("leftresult", resultmap.get("left"));
        }
        if (resultmap.get("right") == null) {
            String rightF = obj.getString("fullrformula");
            this.getModel().setValue("rightresult", (Object)this.addBracket(obj.getString("rightresult"), rightF));
        } else {
            this.getModel().setValue("rightresult", resultmap.get("right"));
        }
        this.getModel().setValue("result", (Object)NumberQuantileValueUtil.change2QuantileValueDefault2Zero((String)obj.getString("calcresultexpr")));
        this.getModel().setValue("allowamount", (Object)NumberQuantileValueUtil.change2QuantileValueNoEndZero((String)obj.getString("chkformula.allowamount")));
        this.getModel().setValue("note", (Object)obj.getString("note"));
        this.getControl("note").getModel().setDataChanged(false);
        this.getPageCache().put(CURIDS, String.valueOf(reportid));
        ThreadCache.put((Object)"chkreport", (Object)obj);
        ThreadCache.put((Object)"chkset", (Object)setobj);
    }

    private String addBracket(String result, String formula) {
        if (StringUtils.isEmpty((String)formula) || ChkCheckServiceHelper.isText((String)formula)) {
            return result;
        }
        ChkResultMapFormulaModel mapFormulaModel = new ChkResultMapFormulaModel(formula, result);
        mapFormulaModel.init();
        String abstractF = mapFormulaModel.getAbstractFormula();
        for (Map.Entry entry : mapFormulaModel.entrySet()) {
            String key = (String)entry.getKey();
            StringBuilder formulaExpressinSb = new StringBuilder();
            String value = (String)mapFormulaModel.get((Object)key);
            if (NumberUtils.isNegativeNumber((String)value)) {
                formulaExpressinSb.append("(");
                formulaExpressinSb.append(NumberQuantileValueUtil.change2QuantileValue((String)value));
                formulaExpressinSb.append(")");
            } else {
                formulaExpressinSb.append(NumberQuantileValueUtil.change2QuantileValue((String)value));
            }
            abstractF = abstractF.replace(key, formulaExpressinSb);
        }
        return abstractF;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (this.getPageCache().get(IDS) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"CheckedNoteEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List ids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(IDS), List.class);
        long id = (Long)SerializationUtils.fromJsonString((String)this.getPageCache().get(CURIDS), Long.class);
        int index = ids.indexOf(id);
        switch (itemKey) {
            case "bar_per": {
                if (index > 0) {
                    if (this.getControl("note").getModel().getDataChanged()) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6ce8\u5df2\u6539\u53d8\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"CheckedNoteEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("perOrSave"));
                        return;
                    }
                    id = (Long)ids.get(index - 1);
                    this.loadPage(id);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5230\u8fbe\u7b2c\u4e00\u6761\u3002", (String)"CheckedNoteEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_next": {
                if (index < ids.size() - 1) {
                    if (this.getControl("note").getModel().getDataChanged()) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6ce8\u5df2\u6539\u53d8\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"CheckedNoteEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("nextOrSave"));
                        return;
                    }
                    id = (Long)ids.get(index + 1);
                    this.loadPage(id);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5230\u8fbe\u6700\u540e\u4e00\u6761\u3002", (String)"CheckedNoteEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_save": {
                this.saveNote(id, false);
                break;
            }
            case "bar_saveandclear": {
                this.saveNote(id, true);
                break;
            }
            case "bar_quit": {
                if (this.getControl("note").getModel().getDataChanged()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6ce8\u5df2\u6539\u53d8\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"CheckedNoteEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("quitOrSave"));
                    return;
                }
                this.getView().close();
                break;
            }
        }
    }

    private void saveNote(long id, boolean isOverwrite) {
        String note = this.getModel().getValue("note").toString();
        String newNote = this.getModel().getValue("newnote").toString();
        String number = this.getModel().getValue("number").toString();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_chkreport");
        if (ChkResultTypeEnum.FORCEPASS.getIndex() == obj.getInt("chkresulttype") && StringUtils.isEmpty((String)note) && isOverwrite) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f3a\u5236\u901a\u8fc7\u7684\u62a5\u544a\uff0c\u6279\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckedNoteEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        note = ChkCheckReportListHelper.appendNote((String)note, (String)newNote, (boolean)isOverwrite);
        obj.set("note", (Object)note);
        String left = obj.getString("fulllformula");
        String right = obj.getString("fullrformula");
        this.setChkResultType(note, obj);
        List<String> list = this.getDimCom(left);
        list.addAll(this.getDimCom(right));
        try (TXHandle tx = TX.required();){
            try {
                this.saveLinkReport(obj);
                this.dealChkStatus(obj);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error("save chkformulasetting note error :", e);
                throw new KDBizException(e.getMessage());
            }
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fee\u6539\u6279\u6ce8", "CheckedNoteEditPlugin_8", "fi-bcm-formplugin", "Modify comments"), new OPDescMultiLangEnumBridge("%1$s %2$s \u4fee\u6539\u6279\u6ce8\u6210\u529f", "CheckedNoteEditPlugin_7", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{obj.getString("chkformula.number"), obj.getString("chkformula.name")})));
        this.loadPage(id);
        this.getModel().setValue("newnote", (Object)"");
        this.getControl("note").getModel().setDataChanged(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CheckedNoteEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void dealChkStatus(DynamicObject obj) {
        CHKCheckEffectEnum ce = CHKCheckEffectEnum.getCHKCheckEffectByIndex((String)obj.getString("chkformula.chkeffecttype"));
        if (CHKCheckEffectEnum.NoteAndReport == ce) {
            long senceId = obj.getLong("scenario.id");
            long yearId = obj.getLong("year.id");
            long periodId = obj.getLong("period.id");
            long cslschemeId = this.getCslschemeId();
            ChkCheckStatusHelper.dealChkStsAfterChangeReport((long)this.getModelId(), (long)senceId, (long)yearId, (long)periodId, (long)cslschemeId, (DynamicObject[])new DynamicObject[]{obj});
        }
    }

    private Long getCslschemeId() {
        return this.getFormCustomParam("cslschemeId") == null ? Long.valueOf(0L) : LongUtil.toLong((Object)this.getFormCustomParam("cslschemeId"));
    }

    private void setChkResultType(String note, DynamicObject obj) {
        CHKCheckEffectEnum ce = CHKCheckEffectEnum.getCHKCheckEffectByIndex((String)obj.getString("chkformula.chkeffecttype"));
        if (CHKCheckEffectEnum.NoteAndReport == ce) {
            if (StringUtils.isEmpty((String)note)) {
                BigDecimal allowAmount = obj.getBigDecimal("chkformula.allowamount");
                if (StringUtils.isEmpty((String)obj.getString("calcresultexpr"))) {
                    if ("true".equals(obj.getString("leftresult"))) {
                        obj.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
                    } else {
                        obj.set("chkresulttype", (Object)ChkResultTypeEnum.UNPASS.getIndex());
                    }
                } else {
                    CHKTypeEnum compareType = CHKTypeEnum.getCHKTypeEnumByIndex((int)obj.getInt("chkformula.comparetype"));
                    String calcresultexpr = obj.getString("calcresultexpr");
                    if (!NumberUtils.isNumber((String)calcresultexpr)) {
                        obj.set("chkresulttype", (Object)ChkResultTypeEnum.UNPASS.getIndex());
                        return;
                    }
                    BigDecimal calcresult = new BigDecimal(calcresultexpr);
                    switch (Objects.requireNonNull(compareType)) {
                        case EQUAL: {
                            if (calcresult.abs().compareTo(allowAmount.abs()) > 0) {
                                obj.set("chkresulttype", (Object)ChkResultTypeEnum.UNPASS.getIndex());
                                break;
                            }
                            obj.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
                            break;
                        }
                        case LARGE_THAN: {
                            if (calcresult.compareTo(BigDecimal.ZERO) > 0) {
                                obj.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
                                break;
                            }
                            obj.set("chkresulttype", (Object)ChkResultTypeEnum.UNPASS.getIndex());
                            break;
                        }
                        case LARGE_EQUALS: {
                            if (calcresult.compareTo(BigDecimal.ZERO) >= 0) {
                                obj.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
                                break;
                            }
                            obj.set("chkresulttype", (Object)ChkResultTypeEnum.UNPASS.getIndex());
                            break;
                        }
                        case LESS_THAN: {
                            if (calcresult.compareTo(BigDecimal.ZERO) < 0) {
                                obj.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
                                break;
                            }
                            obj.set("chkresulttype", (Object)ChkResultTypeEnum.UNPASS.getIndex());
                            break;
                        }
                        case LESS_EQUALS: {
                            if (calcresult.compareTo(BigDecimal.ZERO) <= 0) {
                                obj.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
                                break;
                            }
                            obj.set("chkresulttype", (Object)ChkResultTypeEnum.UNPASS.getIndex());
                            break;
                        }
                        case NOT_EQUALS: {
                            if (calcresult.compareTo(BigDecimal.ZERO) != 0) {
                                obj.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
                                break;
                            }
                            obj.set("chkresulttype", (Object)ChkResultTypeEnum.UNPASS.getIndex());
                            break;
                        }
                    }
                }
            } else {
                obj.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
            }
        }
    }

    private void saveLinkReport(DynamicObject obj) {
        QFilter qm = QFilter.of((String)"model = ? and chkformula = ? and org =? and year =? and scenario =? and period=? and currency=?", (Object[])new Object[]{obj.getLong("model.id"), obj.getLong("chkformula.id"), obj.getLong("org.id"), obj.getLong("year.id"), obj.getLong("scenario.id"), obj.getLong("period.id"), obj.getLong("currency.id")});
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bcm_chkreport", (String)"id,note,chkresulttype,fulllformula,fullrformula,chkformula.chkeffecttype,calcresultexpr,leftresult,chkformula.allowamount", (QFilter[])new QFilter[]{qm});
        ArrayList<DynamicObject> edit = new ArrayList<DynamicObject>();
        if (objs != null) {
            String comleft = obj.getString("fulllformula");
            String comright = obj.getString("fullrformula");
            for (DynamicObject chk : objs) {
                String left = chk.getString("fulllformula");
                String right = chk.getString("fullrformula");
                if (!comleft.equals(left) || !comright.equals(right)) continue;
                edit.add(chk);
            }
        }
        if (!edit.isEmpty()) {
            String note = obj.getString("note");
            edit.forEach(e -> {
                e.set("note", (Object)note);
                this.setChkResultType(note, (DynamicObject)e);
            });
            SaveServiceHelper.save((DynamicObject[])edit.toArray(new DynamicObject[0]));
        }
    }

    private List<String> getDimCom(String formula) {
        if (StringUtils.isEmpty((String)formula)) {
            return new ArrayList<String>(1);
        }
        ArrayList<String> list = new ArrayList<String>(10);
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        Pair pair = Pair.onePair(null, null);
        try {
            pair = parser.parse(formula, coder);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (pair.p2 == null) {
            return list;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (IFormula f : (List)pair.p2) {
            if (!"V".equalsIgnoreCase(f.getName())) continue;
            for (int i = 0; i < f.getParamList().size(); ++i) {
                ParamItem pi = (ParamItem)f.getParamList().get(i);
                String shortnumber = pi.toString().split("\\.")[0];
                if (shortnumber.equals("@TMP")) continue;
                String member = pi.toString().split("\\.")[1];
                DynamicObject dim = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("shortnumber", "=", (Object)shortnumber)});
                map.put(dim.getString("number"), member);
            }
            DimensionCombination dimCombination = new DimensionCombination(this.getModelId());
            dimCombination.putAll(map);
            list.add(dimCombination.getDimensionCombineStr());
        }
        return list;
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        long id = (Long)SerializationUtils.fromJsonString((String)this.getPageCache().get(CURIDS), Long.class);
        List ids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(IDS), List.class);
        int index = ids.indexOf(id);
        if ("perOrSave".equals(callBackId) || "nextOrSave".equals(callBackId) || "quitOrSave".equals(callBackId)) {
            if (MessageBoxResult.Yes == mbce.getResult()) {
                this.saveNote(id, false);
            } else if ("perOrSave".equals(callBackId)) {
                id = (Long)ids.get(index - 1);
                this.loadPage(id);
            } else if ("nextOrSave".equals(callBackId)) {
                id = (Long)ids.get(index + 1);
                this.loadPage(id);
            } else {
                this.getView().close();
            }
        }
    }
}

