/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.MultiTemplateModel;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.util.CheckedFormulaUtil;
import kd.fi.bcm.business.chkcheck.util.CheckedSettingUtil;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKCheckEffectEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.EffectiveYearPeriodUtil;
import org.apache.commons.collections.CollectionUtils;

public class CheckedSetMainPlugin
extends AbstractBaseFormPlugin
implements MainPage {
    protected ChkFormulaModel checkmodel;

    private OpNameMultiLangEnumBridge getOperationSave() {
        return new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "CheckedSetMainPlugin_0", "fi-bcm-formplugin", "Add Save");
    }

    private OpNameMultiLangEnumBridge getOperationModifySave() {
        return new OpNameMultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "CheckedSetMainPlugin_5", "fi-bcm-formplugin", "Update Save");
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"CheckedSetMainPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showFromView("base", "bcm_checkedbasicinfo");
        this.showFromView("spreadpanel", "bcm_chksettingrpt");
        this.showFromView("formula", "bcm_checkedformula");
        this.getPageCache().put("oldCheckModel", this.toByteSerialized(this.getChkFormulaModel()));
        String operaType = (String)this.getView().getFormShowParameter().getCustomParams().get("operation");
        if ("add".equals(operaType)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_itemaddlevel"});
        }
        String orgId = this.getFormCustomParam("org").toString();
        if (!CheckedSettingUtil.checkOrg((long)this.getModelId(), (long)this.getChkFormulaModel().getOrg(), (long)Long.parseLong(orgId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u7ec4\u7ec7\u521b\u5efa\u7684\u52fe\u7a3d\u5173\u7cfb\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CheckedSetMainPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_itemaddlevel"});
            this.getPageCache().put("isNotCreateOrg", "true");
        }
    }

    private void showFromView(String tab, String form) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(tab);
        formShowParameter.setFormId(form);
        formShowParameter.setPageId(this.getPageIdAndCache(this.getPageCache(), form));
        formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        formShowParameter.setCustomParam("checkmodel", (Object)this.toByteSerialized(this.getChkFormulaModel()));
        this.getView().showForm(formShowParameter);
    }

    private void showBaseInfo(ChkFormulaModel model) {
        String pageId = "chkBaseInfo-" + this.getView().getPageId();
        IFormView baseInfoView = this.getView().getView(pageId);
        if (baseInfoView == null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setPageId(pageId);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("bcm_chkinfosubpage");
            formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            formShowParameter.setCustomParam("checkmodel", (Object)this.toByteSerialized(model));
            CloseCallBack cb = new CloseCallBack((IFormPlugin)this, "bcm_chkinfosubpage");
            formShowParameter.setCloseCallBack(cb);
            this.getView().showForm(formShowParameter);
        } else {
            baseInfoView.activate();
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getFormCustomParam("pageId") != null) {
            this.getView().getFormShowParameter().setParentPageId((String)this.getFormCustomParam("pageId"));
        }
        if (this.isNeedRecycleNumber() && !this.getChkFormulaModel().isEdit()) {
            CodeRuleUtil.recycleCodeRuleNumber("bcm_chkformulasetting", this.getChkFormulaModel().getNumber());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("bcm_chkinfosubpage".equals(key) && closedCallBackEvent.getReturnData() != null) {
            CommandParam com;
            ChkFormulaModel model = (ChkFormulaModel)this.getReturnData(closedCallBackEvent);
            if ("1".equals(this.getPageCache().get("addlevelFlag"))) {
                ChkFormulaModel newCkm = this.initAddLevelChkFormulaModel(model, 2);
                this.openNewTabForAddLevel(newCkm);
                this.getView().close();
                return;
            }
            if (QueryServiceHelper.exists((String)"bcm_chkformulasetting", (Object)model.getId())) {
                model.setEdit(true);
            }
            if (model.getOrg() != this.getChkFormulaModel().getOrg()) {
                com = new CommandParam("bcm_checkedmainpage", "bcm_checkedbasicinfo", "changeOrg", model);
                this.sendMsg(this.getView(), com);
            }
            this.cacheChkFormulaModel(model);
            if (!model.getMultiTemplate().isEmpty()) {
                com = new CommandParam("bcm_checkedmainpage", "bcm_chksettingrpt", "changeTmp", model);
                this.sendMsg(this.getView(), com);
            }
        }
    }

    private ChkFormulaModel initAddLevelChkFormulaModel(ChkFormulaModel model, int opttype) {
        ChkFormulaModel newCkm = new ChkFormulaModel();
        newCkm.setId(0L);
        newCkm.setModelId(model.getModelId());
        newCkm.setNumber(model.getNumber());
        newCkm.setOrg(model.getOrg());
        newCkm.setStatus(CHKFormulaStatusEnum.enable.getIndex());
        if (opttype == 2) {
            newCkm.setName(model.getName());
            newCkm.setAllowamount(model.getAllowamount());
            newCkm.setChkeffecttype(model.getChkeffecttype());
            newCkm.setUmtemp(model.getUmtemp());
            newCkm.setMultiTemplate(model.getMultiTemplate());
            newCkm.setMulCslscheme(model.getMulCslscheme());
        }
        return newCkm;
    }

    private void openNewTabForAddLevel(ChkFormulaModel newCkm) {
        IFormView parentView = this.getView().getParentView();
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.putAll(this.getView().getFormShowParameter().getCustomParams());
        params.put("checkmodel", this.toByteSerialized(newCkm));
        if (newCkm.getMultiTemplate() != null) {
            params.put("temp", this.toByteSerialized(newCkm.getMultiTemplate()));
        }
        showParameter.setFormId("bcm_checkedmainpage");
        String pageId = "bcm_checkedmainpage" + UUID.randomUUID().toString().replace("-", "");
        showParameter.setPageId(pageId);
        showParameter.setCustomParams(params);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parentView.showForm(showParameter);
        this.getView().sendFormAction(parentView);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        CommandParam com;
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_save".equals(key)) {
            ChkFormulaModel chkFormulaModel = this.getChkFormulaModel();
            chkFormulaModel.setCreateTime(TimeServiceHelper.now());
            CommandParam com2 = new CommandParam("bcm_checkedmainpage", "bcm_checkedbasicinfo", "saveModel", this.getChkFormulaModel());
            this.sendMsg(this.getView(), com2);
        }
        if ("bar_base".equals(key)) {
            this.showBaseInfo(this.getChkFormulaModel());
        }
        if ("bar_itemaddlevel".equals(key)) {
            com = new CommandParam("bcm_checkedmainpage", "bcm_checkedformula", "addLevel", this.getChkFormulaModel());
            this.sendMsg(this.getView(), com);
        }
        if ("bar_close".equals(key)) {
            if (Boolean.parseBoolean(this.getPageCache().get("isNotCreateOrg"))) {
                this.getView().close();
                return;
            }
            if (!this.toByteSerialized(this.getChkFormulaModel()).equals(this.getPageCache().get("oldCheckModel"))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u52fe\u7a3d\u516c\u5f0f\u5df2\u53d8\u5316\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"CheckedSetMainPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("closedConfirm", (IFormPlugin)this));
            } else {
                com = new CommandParam("bcm_checkedmainpage", "bcm_checkedbasicinfo", "closed", this.getChkFormulaModel());
                this.sendMsg(this.getView(), com);
            }
        }
    }

    private void addLevel(int opt) {
        if (opt == 0) {
            ChkFormulaModel ckm = this.getChkFormulaModel();
            ckm.setNumber(CodeRuleUtil.getCodeRuleNumber("bcm_chkformulasetting", "createtime"));
            ChkFormulaModel newCkm = this.initAddLevelChkFormulaModel(ckm, 0);
            this.openNewTabForAddLevel(newCkm);
        } else if (opt == 1 || opt == 2) {
            if (opt == 1) {
                CommandParam com = new CommandParam("bcm_checkedmainpage", "bcm_checkedbasicinfo", "saveModel", this.getChkFormulaModel());
                this.sendMsg(this.getView(), com);
            }
            ChkFormulaModel model = this.getChkFormulaModel();
            this.getPageCache().put("addlevelFlag", "1");
            model.setName("");
            model.setNumber(CodeRuleUtil.getCodeRuleNumber("bcm_chkformulasetting", "createtime"));
            model.setId(0L);
            model.setChkeffecttype(CHKCheckEffectEnum.TipAndNotReport.getIndex());
            model.setAllowamount(0.0);
            model.setMultiTemplate(new ArrayList(0));
            model.setMulCslscheme(null);
            this.showBaseInfo(model);
        }
    }

    @Override
    public void dealMsg(CommandParam com) {
        if ("saveModel".equals(com.getOperation())) {
            this.saveModel(com);
        } else if ("addLevel".equals(com.getOperation())) {
            int opt = (Integer)com.getParam().get(0);
            this.addLevel(opt);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_itemaddlevel"});
        } else if ("closedConfirm".equals(com.getOperation())) {
            if (com.getParam().get(0) instanceof String) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u52fe\u7a3d\u516c\u5f0f\u5df2\u53d8\u5316\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"CheckedSetMainPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("closedConfirm", (IFormPlugin)this));
                return;
            }
            String newFormula = com.getParam().get(0).toString();
            String oldFormula = this.deSerializedBytes(this.getPageCache().get("oldCheckModel")).toString();
            if (newFormula != null && !newFormula.equals(oldFormula)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u52fe\u7a3d\u516c\u5f0f\u5df2\u53d8\u5316\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"CheckedSetMainPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("closedConfirm", (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        } else if ("addlevelConfirm".equals(com.getOperation())) {
            if (com.getParam().get(0) instanceof String) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u52fe\u7a3d\u516c\u5f0f\u5df2\u53d8\u5316\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"CheckedSetMainPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("addlevelConfirm", (IFormPlugin)this));
                return;
            }
            String newFormula = com.getParam().get(0).toString();
            String oldFormula = this.deSerializedBytes(this.getPageCache().get("oldCheckModel")).toString();
            if (newFormula != null && !newFormula.equals(oldFormula)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u52fe\u7a3d\u516c\u5f0f\u5df2\u53d8\u5316\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"CheckedSetMainPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("addlevelConfirm", (IFormPlugin)this));
            } else {
                this.addLevel(2);
            }
        }
    }

    private void saveModel(CommandParam com) {
        int permission = PermissionServiceHelper.checkPermission((long)this.getUserId(), (String)"bcm_model", (long)this.getModelId(), (String)AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.getAppnum()).getId(), (String)"bcm_checkuplist", (String)"4715a0df000000ac");
        if (permission == 0 && !MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"CheckedSetMainPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (com.getParam().get(0) instanceof String) {
            this.getView().showErrorNotification(com.getParam().get(0).toString());
            return;
        }
        ChkFormulaModel model = (ChkFormulaModel)com.getParam().get(0);
        if (ChkCheckServiceHelper.isCheckDimCombOver((ChkFormulaModel)model)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u52fe\u7a3d\u8bbe\u7f6e\u53ef\u80fd\u4ea7\u751f\u8f83\u591a\u6570\u636e\uff0c\u5728\u6821\u9a8c\u65f6\u4f1a\u82b1\u8d39\u8f83\u957f\u65f6\u95f4\uff0c\u5efa\u8bae\u7f29\u5c0f\u6216\u8005\u51cf\u5c11\u9002\u7528\u7ef4\u5ea6\u8303\u56f4\u3002", (String)"CheckedSetMainPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection doc = new DynamicObjectCollection();
        List multiTemplateModels = model.getMultiTemplate();
        if (CollectionUtils.isNotEmpty((Collection)multiTemplateModels)) {
            Map<String, Long> numberToid = this.getTempIdMap(multiTemplateModels);
            for (MultiTemplateModel multiTemplateModel : multiTemplateModels) {
                DynamicObject chkSetting = BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkformulasetting");
                DynamicObject dynamicObject = new DynamicObject(chkSetting.getDynamicObjectCollection("multitemplate").getDynamicObjectType(), (Object)DB.genGlobalLongId());
                long tid = numberToid.containsKey(multiTemplateModel.getNumber()) ? numberToid.get(multiTemplateModel.getNumber()).longValue() : multiTemplateModel.getTempId().longValue();
                DynamicObject dybase = new DynamicObject(multiTemplateModel.getBasetype(), (Object)tid);
                dynamicObject.set("fbasedataid", (Object)dybase);
                doc.add((Object)dynamicObject);
            }
        }
        DynamicObject oo = model.genDynamicObject();
        oo.set("name", model.getMultiLangName());
        if (model.getUmtemp()) {
            oo.set("multitemplate", (Object)doc);
        } else {
            oo.set("multitemplate", (Object)new DynamicObjectCollection());
        }
        if (model.isDistcslscheme()) {
            DynamicObjectCollection mulCslscheme = new DynamicObjectCollection();
            model.getMulCslscheme().forEach(c -> {
                DynamicObject dynamicObject = new DynamicObject(c.getDynamicObjectType(), (Object)DB.genGlobalLongId());
                dynamicObject.set("fbasedataid", c.get("fbasedataid"));
                mulCslscheme.add((Object)dynamicObject);
            });
            oo.set("mulcslscheme", (Object)mulCslscheme);
        } else {
            oo.set("mulcslscheme", (Object)new DynamicObjectCollection());
        }
        this.changeFormula(this.getModelId(), oo);
        this.saveEffectiveInfo(oo, model);
        this.saveStageallocate(oo);
        oo.set("vrangetxt", (Object)ChkCheckServiceHelper.buildChkScope((ChkFormulaModel)model));
        oo.set("vfixdimtxt", (Object)ChkCheckServiceHelper.buildChkSuitDim((ChkFormulaModel)model));
        oo.set("modifier", (Object)RequestContext.getOrCreate().getUserId());
        oo.set("modifytime", (Object)TimeServiceHelper.now());
        CheckedFormulaUtil.existsFormula((String)"number", (String)model.getNumber(), (String)ResManager.loadKDString((String)"\u7f16\u7801", (String)"CheckedSetMainPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (long)model.getId(), (long)this.getModelId());
        try (TXHandle tx = TX.required((String)"bcm_chkformulasetting_save");){
            try {
                BusinessDataWriter.delete((IDataEntityType)oo.getDataEntityType(), (Object[])new Object[]{oo.getPkValue()});
                SaveServiceHelper.save((IDataEntityType)oo.getDataEntityType(), (Object[])new Object[]{oo});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        this.getPageCache().put("needRecycleNumber", "false");
        this.cacheChkFormulaModel(model);
        this.getPageCache().put("oldCheckModel", this.toByteSerialized(this.getChkFormulaModel()));
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_itemaddlevel"});
        this.getPageCache().remove("ismodifer");
        if (model.isEdit()) {
            this.writeOperationLog(this.getOperationModifySave(), oo.getString("number"), oo.getString("name"), this.getOperationStstusSuccess());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u516c\u5f0f\u8bbe\u7f6e\u5df2\u66f4\u65b0\u3002\u8bf7\u91cd\u65b0\u6267\u884c\u52fe\u7a3d\u68c0\u67e5\uff0c\u4ee5\u66f4\u65b0\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CheckedSetMainPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.writeOperationLog(this.getOperationSave(), oo.getString("number"), oo.getString("name"), this.getOperationStstusSuccess());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CheckedSetMainPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if ("closedConfirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            ChkFormulaModel chkFormulaModel = this.getChkFormulaModel();
            chkFormulaModel.setCreateTime(TimeServiceHelper.now());
            CommandParam com = new CommandParam("bcm_checkedmainpage", "bcm_checkedbasicinfo", "saveModel", this.getChkFormulaModel());
            this.sendMsg(this.getView(), com);
        } else if ("addlevelConfirm".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
                this.addLevel(1);
            } else {
                this.addLevel(0);
            }
        } else {
            this.getView().close();
        }
    }

    private Map<String, Long> getTempIdMap(List<MultiTemplateModel> tmps) {
        ArrayList<String> numbers = new ArrayList<String>(tmps.size());
        for (MultiTemplateModel multiTemplateModel : tmps) {
            numbers.add(multiTemplateModel.getNumber());
        }
        QFilter ft = new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("number", "in", numbers)).and(new QFilter("templatetype", "in", (Object)new String[]{"0", "1"}).and("versionnumber", "=", (Object)new BigDecimal("1.0")));
        Map doc = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)"id,number", (QFilter[])new QFilter[]{ft});
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (doc != null) {
            for (DynamicObject obj : doc.values()) {
                result.put(obj.getString("number"), obj.getLong("id"));
            }
        }
        return result;
    }

    private void saveEffectiveInfo(DynamicObject oo, ChkFormulaModel model) {
        Map effectiveMap = (Map)model.get("effectivedata");
        if (effectiveMap != null) {
            EffectiveYearPeriodUtil.saveEffectiveInfo(oo, effectiveMap);
        } else {
            DynamicObjectCollection effectiveDys;
            DynamicObject chkdy;
            Object pkValue = oo.getPkValue();
            if (pkValue != null && (chkdy = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"bcm_chkformulasetting", (String)"effective.seq, effective.applytype, effective.yearscope, effective.effectiveyear, effective.effectiveperiod")) != null && !(effectiveDys = chkdy.getDynamicObjectCollection("effective")).isEmpty()) {
                DynamicObjectCollection effectives = oo.getDynamicObjectCollection("effective");
                DynamicObjectType effectiveType = effectives.getDynamicObjectType();
                for (DynamicObject dy : effectiveDys) {
                    DynamicObject effective = new DynamicObject(effectiveType);
                    effective.set("seq", (Object)dy.getInt("seq"));
                    effective.set("applytype", (Object)dy.getString("applytype"));
                    effective.set("yearscope", (Object)dy.getString("yearscope"));
                    effective.set("effectiveyear", (Object)dy.getLong("effectiveyear.id"));
                    effective.set("effectiveperiod", (Object)dy.getLong("effectiveperiod.id"));
                    effectives.add((Object)effective);
                }
            }
        }
    }

    private void saveStageallocate(DynamicObject oo) {
        String filed;
        Object pkValue = oo.getPkValue();
        DynamicObject chkdy = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"bcm_chkformulasetting", (String)(filed = "stageallocate"));
        if (chkdy != null) {
            oo.set(filed, chkdy.get(filed));
        }
    }

    private boolean isNeedRecycleNumber() {
        return this.getPageCache().get("needRecycleNumber") == null || Boolean.parseBoolean(this.getPageCache().get("needRecycleNumber"));
    }

    private void changeFormula(long modelid, DynamicObject oo) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection settings = QueryServiceHelper.query((String)"bcm_chkdisplaysetting", (String)"type,selectdims", (QFilter[])new QFilter[]{qFilter});
        DynamicObject vSetting = null;
        DynamicObject chineseSettring = null;
        for (DynamicObject dot : settings) {
            if (dot.getInt("type") == 1) {
                chineseSettring = dot;
            }
            if (dot.getInt("type") != 2) continue;
            vSetting = dot;
        }
        ArrayList<String> dimList = new ArrayList<String>();
        if (chineseSettring != null) {
            dimList.addAll(Arrays.asList(chineseSettring.getString("selectdims").split(";")));
        }
        if (vSetting != null) {
            dimList.addAll(Arrays.asList(vSetting.getString("selectdims").split(";")));
        }
        if (dimList.isEmpty()) {
            dimList.add(DimTypesEnum.ACCOUNT.getNumber());
        }
        QFilter typeFilter = new QFilter("templatetype", "in", Arrays.asList(String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType())));
        QFilter stsFilter = new QFilter("status", "=", (Object)"1");
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,name", (QFilter[])new QFilter[]{qFilter, typeFilter, stsFilter}, (String)"versionnumber desc");
        String right = ChkFormulaServiceHelper.tranFormulasQuick((String)oo.getString("rformulatemp"), (long)modelid, (int)2, (DynamicObject)vSetting, (DynamicObjectCollection)templates);
        String vFormula = ChkFormulaServiceHelper.tranFormulasQuick((String)oo.getString("lformulatemp"), (long)modelid, (int)2, (DynamicObject)vSetting, (DynamicObjectCollection)templates) + ChkFormulaServiceHelper.changeNum2Symbol((String)oo.getString("comparetype")) + right;
        String chineseFormula = ChkFormulaServiceHelper.tranFormulasQuick((String)oo.getString("lformulatemp"), (long)modelid, (int)1, (DynamicObject)chineseSettring, (DynamicObjectCollection)templates) + ChkFormulaServiceHelper.changeNum2Symbol((String)oo.getString("comparetype")) + ChkFormulaServiceHelper.tranFormulasQuick((String)oo.getString("rformulatemp"), (long)modelid, (int)1, (DynamicObject)chineseSettring, (DynamicObjectCollection)templates);
        String mixFormula = ChkFormulaServiceHelper.tranFormulasQuick((String)oo.getString("lformulatemp"), (long)modelid, (int)1, (DynamicObject)chineseSettring, (DynamicObjectCollection)templates, (String)"mix") + ChkFormulaServiceHelper.changeNum2Symbol((String)oo.getString("comparetype")) + ChkFormulaServiceHelper.tranFormulasQuick((String)oo.getString("rformulatemp"), (long)modelid, (int)1, (DynamicObject)chineseSettring, (DynamicObjectCollection)templates, (String)"mix");
        oo.set("vformula", (Object)vFormula);
        oo.set("chineseformula", (Object)chineseFormula);
        oo.set("mformula", (Object)mixFormula);
    }

    protected ChkFormulaModel getChkFormulaModel() {
        if (this.checkmodel != null) {
            return this.checkmodel;
        }
        Predicate<String> p = StringUtils::isEmpty;
        String serial = this.getPageCache().get("checkmodel");
        if (p.test(serial)) {
            serial = (String)this.getFormCustomParam("checkmodel");
            this.checkmodel = !p.test(serial) ? (ChkFormulaModel)this.deSerializedBytes(serial) : new ChkFormulaModel();
            this.getPageCache().put("checkmodel", this.toByteSerialized(this.checkmodel));
        } else {
            this.checkmodel = (ChkFormulaModel)this.deSerializedBytes(serial);
        }
        return this.checkmodel;
    }

    protected void cacheChkFormulaModel(ChkFormulaModel model) {
        this.getPageCache().put("checkmodel", this.toByteSerialized(model));
    }
}

