/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.checkupchk.util;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.VTFormula;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckReportListHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.script.CommonFormulaModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.report.IIncreaseReportTab;
import kd.fi.bcm.formplugin.report.csl.CslReportProcessPlugin;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanByEntity;
import kd.fi.bcm.formplugin.util.FormUtils;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.formula.ParseException;

public class ChkReportJump2CellUtil {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(ChkReportJump2CellUtil.class);

    @SDKMark
    public static void showReport(IFormView view, String fkey, String colKey, long reportId, long modelId, String yearNum, String periodNum) {
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"bcm_chkreport");
        if (report == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u52fe\u7a3d\u6821\u9a8c\u7ed3\u679c\u5df2\u88ab\u5237\u65b0,\u8bf7\u5237\u65b0\u52fe\u7a3d\u6821\u9a8c\u62a5\u544a\u540e\u518d\u8054\u67e5\u6570\u636e\u3002", (String)"CheckUpChkReportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        long entityId = report.getLong("org.id");
        long cslschemeId = report.getLong("cslscheme.id");
        DynamicObject orgdy = BusinessDataServiceHelper.loadSingleFromCache((Object)entityId, (String)"bcm_entitymembertree", (String)"number");
        if (orgdy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"AbstractChkListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        QFilter qfilter = new QFilter("model", "=", (Object)modelId);
        qfilter.and("number", "=", (Object)orgdy.getString("number"));
        orgdy = MemberServiceHelper.getBaseMember((String)"bcm_entitymembertree", (String)"id", (QFilter)qfilter);
        entityId = orgdy.getLong("id");
        String vformula = "";
        vformula = colKey.startsWith("l") ? report.getString("fulllformula") : report.getString("fullrformula");
        try {
            if (ChkFormulaServiceHelper.isJudgeFormula((String)vformula)) {
                return;
            }
            VTFormula vtFormula = new VTFormula(vformula);
            String formula = "";
            for (IFormula iFormula : (List)vtFormula.getPair().p2) {
                if (!iFormula.getUUID().equals(fkey)) continue;
                formula = iFormula.toString();
                break;
            }
            if (ChkFormulaServiceHelper.isXdmFormula((String)formula)) {
                ChkReportJump2CellUtil.xdmFormulaJump2TemplateReport(view, modelId, formula, report);
                return;
            }
            if (!formula.contains("V(\"@TMP.")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u52fe\u7a3d\u516c\u5f0f\u672a\u5173\u8054\u4efb\u4f55\u62a5\u8868\u6a21\u677f\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u3002", (String)"CheckUpChkReportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            VTFormula.FormulaWithTempMemStr fs = vtFormula.getFormulaToMemStr(formula);
            Map sNumToMems = fs.getDimToMem_Num();
            long scenarioId = DimensionServiceHelper.getMemberDy((String)DimTypesEnum.SCENARIO.getShortNumber(), (long)modelId, (String)((String)sNumToMems.get(DimTypesEnum.SCENARIO.getShortNumber()))).getLong("id");
            long yearId = DimensionServiceHelper.getMemberDy((String)DimTypesEnum.YEAR.getShortNumber(), (long)modelId, (String)((String)sNumToMems.get(DimTypesEnum.YEAR.getShortNumber()))).getLong("id");
            long periodId = DimensionServiceHelper.getMemberDy((String)DimTypesEnum.PERIOD.getShortNumber(), (long)modelId, (String)((String)sNumToMems.get(DimTypesEnum.PERIOD.getShortNumber()))).getLong("id");
            long currencyId = DimensionServiceHelper.getMemberDy((String)DimTypesEnum.CURRENCY.getShortNumber(), (long)modelId, (String)((String)sNumToMems.get(DimTypesEnum.CURRENCY.getShortNumber()))).getLong("id");
            LinkedHashMap<String, String> linkMap = new LinkedHashMap<String, String>(16);
            for (Map.Entry entry : sNumToMems.entrySet()) {
                linkMap.put(DimTypesEnum.getDimNumber((String)((String)entry.getKey()), (long)modelId), (String)entry.getValue());
            }
            long tempId = ChkReportJump2CellUtil.getShowTemplateId(report, yearId, periodId, modelId, fs.getTempNum());
            if (tempId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u52fe\u7a3d\u516c\u5f0f\u672a\u5173\u8054\u4efb\u4f55\u62a5\u8868\u6a21\u677f\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u3002", (String)"CheckUpChkReportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            ChkCheckReportListHelper.checkTemplateDistributionOrg((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, (long)orgdy.getLong("id"), (long)currencyId, (long)tempId);
            ChkReportJump2CellUtil.jump2TemplateReport(view, modelId, entityId, scenarioId, yearId, periodId, currencyId, linkMap, tempId, report.getLong("orgparent.id"), cslschemeId);
        }
        catch (ParseException p) {
            log.error((Throwable)p);
        }
        catch (Exception ext) {
            log.error((Throwable)ext);
            throw new KDBizException(StringUtils.isEmpty((String)ext.getMessage()) ? ResManager.loadKDString((String)"\u516c\u5f0f\u5f02\u5e38\u3002", (String)"CheckUpChkReportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ext.getMessage());
        }
    }

    private static void xdmFormulaJump2TemplateReport(IFormView view, long modelId, String vformula, DynamicObject dy) {
        try {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            CommonFormulaModel xdmFormulaBuilder = (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)ChkFormulaServiceHelper.parseXdmFormula((String)vformula));
            long entityId = xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.ENTITY.getNumber()) == null ? dy.getLong("org.id") : xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.ENTITY.getNumber()).longValue();
            long cslschemeId = xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.ENTITY.getNumber()) == null ? dy.getLong("cslscheme.id") : 0L;
            long scenarioId = xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.SCENARIO.getNumber()) == null ? dy.getLong("scenario.id") : xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.SCENARIO.getNumber()).longValue();
            long yearId = xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.YEAR.getNumber()) == null ? dy.getLong("year.id") : xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.YEAR.getNumber()).longValue();
            long periodId = xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.PERIOD.getNumber()) == null ? dy.getLong("period.id") : xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.PERIOD.getNumber()).longValue();
            long currencyId = xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.CURRENCY.getNumber()) == null ? dy.getLong("currency.id") : xdmFormulaBuilder.getDimId(modelNum, DimTypesEnum.CURRENCY.getNumber()).longValue();
            long tempId = ChkReportJump2CellUtil.getShowTemplateId(dy, yearId, periodId, modelId, (String)xdmFormulaBuilder.getCondition("template"));
            if (tempId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u52fe\u7a3d\u516c\u5f0f\u672a\u5173\u8054\u4efb\u4f55\u62a5\u8868\u6a21\u677f\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u3002", (String)"CheckReportListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            LinkedHashMap<String, String> linkMap = new LinkedHashMap<String, String>();
            linkMap.put("extendsmodel", (String)xdmFormulaBuilder.getCondition("extendsmodel"));
            linkMap.put("extendsfield", (String)xdmFormulaBuilder.getCondition("extendsfield"));
            linkMap.put(DimTypesEnum.SCENARIO.getNumber(), MemberReader.findMemberById((String)modelNum, (String)"bcm_scenemembertree", (Long)scenarioId).getNumber());
            linkMap.put(DimTypesEnum.YEAR.getNumber(), MemberReader.findMemberById((String)modelNum, (String)"bcm_fymembertree", (Long)yearId).getNumber());
            linkMap.put(DimTypesEnum.PERIOD.getNumber(), MemberReader.findMemberById((String)modelNum, (String)"bcm_periodmembertree", (Long)periodId).getNumber());
            linkMap.put(DimTypesEnum.CURRENCY.getNumber(), MemberReader.findMemberById((String)modelNum, (String)"bcm_currencymembertree", (Long)currencyId).getNumber());
            if (xdmFormulaBuilder.getDim(DimTypesEnum.PROCESS.getNumber()) == null) {
                linkMap.put(DimTypesEnum.PROCESS.getNumber(), dy.getString("process.number"));
            } else {
                linkMap.put(DimTypesEnum.PROCESS.getNumber(), xdmFormulaBuilder.getDim(DimTypesEnum.PROCESS.getNumber()));
            }
            ChkReportJump2CellUtil.jump2TemplateReport(view, modelId, entityId, scenarioId, yearId, periodId, currencyId, linkMap, tempId, dy.getLong("orgparent.id"), cslschemeId);
        }
        catch (Exception e) {
            log.error("deSerializedBytes error!" + e);
        }
    }

    private static void jump2TemplateReport(IFormView view, long modelId, long entityId, long scenarioId, long yearId, long periodId, long currencyId, Map<String, String> linkMap, long tempId, long orgParentId, long cslschemeId) {
        long effectiveOrg = ChkCheckReportListHelper.convert2EffectiveOrg((long)entityId, (long)modelId, (long)scenarioId, (long)yearId, (long)periodId, (long)cslschemeId);
        ReportPostmanByEntity postman = new ReportPostmanByEntity(effectiveOrg, scenarioId, yearId, periodId, currencyId, modelId);
        postman.setBaseEntityPK(entityId);
        postman.addPair(tempId, ChkReportJump2CellUtil.getReportId(postman, entityId, tempId));
        ChkReportJump2CellUtil.handleFinTemplate(view, linkMap, postman, entityId, cslschemeId);
    }

    public static void handleFinTemplate(IFormView view, Map<String, String> linkMap, AbstractReportPostman postman, Long orgId, Long cslschemeId) {
        String openPageId = "bcm_cslreportprocess";
        if (ConfigServiceHelper.getBoolParam((Long)LongUtil.toLong((Object)postman.getModelPK()), (String)"CM055")) {
            openPageId = "bcm_unrefreshreport";
        }
        IFormView mainPageView = view.getMainView();
        IFormView parentView = FormUtils.findHomePage(view.getParentView());
        String menuPageId = ChkReportJump2CellUtil.getMenuPageId(postman, view);
        if (mainPageView == null || mainPageView.getView(menuPageId) == null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setPageId(menuPageId);
            formShowParameter.setFormId(openPageId);
            formShowParameter.setCaption(ChkReportJump2CellUtil.getOpenFormCaption(postman));
            formShowParameter.setCustomParam("reportpostman", (Object)ObjectSerialUtil.toByteSerialized((Object)postman));
            formShowParameter.setCustomParam("listPageID", (Object)view.getPageId());
            formShowParameter.setCustomParam("numtomems", linkMap);
            formShowParameter.setCustomParam("KEY_MODEL_ID", postman.getModelPK());
            formShowParameter.setCustomParam("cslscheme", (Object)String.valueOf(cslschemeId));
            formShowParameter.setCustomParam("orgpermvalue", (Object)ChkReportJump2CellUtil.getOrgMemberPerm(view, orgId).toString());
            formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            if (parentView == null) {
                view.showForm(formShowParameter);
            } else {
                formShowParameter.setParentPageId(parentView.getPageId());
                formShowParameter.setParentFormId(parentView.getEntityId());
                parentView.showForm(formShowParameter);
                view.sendFormAction(parentView);
            }
        } else {
            ThreadCache.put((Object)"isFromChkReport", (Object)true);
            IFormView childFormView = mainPageView.getView(menuPageId);
            childFormView.getFormShowParameter().setCustomParam("numtomems", linkMap);
            childFormView.cacheFormShowParameter();
            childFormView.activate();
            if ("bcm_unrefreshreport".equalsIgnoreCase(childFormView.getFormShowParameter().getFormId())) {
                ThreadCache.put((Object)"numtomems", linkMap);
            }
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childFormView.getService(FormViewPluginProxy.class);
            AbstractReportPostman pm = postman;
            pluginProxy.getPlugIns().forEach(e -> {
                if (!(e instanceof CslReportProcessPlugin)) {
                    return;
                }
                if (IIncreaseReportTab.class.isAssignableFrom(e.getClass())) {
                    ((IIncreaseReportTab)IIncreaseReportTab.class.cast(e)).increaseReportTab(pm);
                }
            });
            view.sendFormAction(childFormView);
        }
    }

    private static long getShowTemplateId(DynamicObject dy, long fyid, long periodid, long modelid, String tempNum) {
        QFBuilder qfBuilder = new QFBuilder();
        long tempId = dy.getLong("template.id");
        if (!StringUtil.isEmptyString((String)tempNum)) {
            qfBuilder.add("number", "=", (Object)tempNum);
            qfBuilder.add("model", "=", (Object)modelid);
            qfBuilder.add("templatetype", "not in", (Object)Lists.newArrayList((Object[])new String[]{TemplateTypeEnum.MSN.getType() + "", TemplateTypeEnum.OTHERWP.getType() + ""}));
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])qfBuilder.toArray());
            Set ids = doc.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
            Map id2Right = TemplateUtil.getRightTplIdByVersioned((Long)modelid, (Long)fyid, (Long)periodid, ids);
            for (Map.Entry entry : id2Right.entrySet()) {
                tempId = (Long)entry.getValue();
            }
        }
        return tempId;
    }

    private static long getReportId(AbstractReportPostman postman, long orgid, long temId) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", postman.getModelPK());
        qf.add("fyear", "=", postman.getYearPK());
        qf.add("period", "=", postman.getPeriodPK());
        qf.add("scene", "=", postman.getScenarioPK());
        qf.add("currency", "=", postman.getCurrencyPK());
        qf.add("entity", "=", (Object)orgid);
        qf.add("template", "=", (Object)temId);
        DynamicObject report = BusinessDataServiceHelper.loadSingle((String)"bcm_reportentity", (String)"id", (QFilter[])qf.toArray());
        return report == null ? 0L : report.getLong("id");
    }

    private static String getMenuPageId(AbstractReportPostman pm, IFormView view) {
        return pm.getEntityPK(null) + view.getPageId();
    }

    private static String getOpenFormCaption(AbstractReportPostman pm) {
        DynamicObject entity = QueryServiceHelper.queryOne((String)pm.getTabSort().getEntityNumber(), (String)"name,id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", pm.getSortViewPK())});
        return String.format(ResManager.loadKDString((String)"\u52fe\u7a3d\u6821\u9a8c\uff1a%s", (String)"CheckUpChkReportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entity.getString("name"));
    }

    public static Integer getOrgMemberPerm(IFormView view, Long orgId) {
        if (Boolean.parseBoolean(view.getPageCache().get("isroot"))) {
            return PermEnum.READWRITE.getValue();
        }
        String permCacheStr = view.getPageCache().get(PermCacheKey.ORG_PERM_CACHE_KEY);
        if (permCacheStr != null) {
            PermPackageList permMap = (PermPackageList)SerializationUtils.fromJsonString((String)permCacheStr, PermPackageList.class);
            PermEnum permNum = null;
            if (permMap != null) {
                permNum = permMap.getPermEnum(orgId.toString());
            }
            if (permNum != null) {
                return permNum.getValue();
            }
            return PermEnum.NOPERM.getValue();
        }
        return PermEnum.READWRITE.getValue();
    }
}

