/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.rule.BizRuleLogicStatusEnum;
import kd.fi.bcm.common.util.CodeRuleUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.computing.BizRuleCheckConditionPlugin;
import kd.fi.bcm.formplugin.computing.BizRuleConfigImportAndExport;
import kd.fi.bcm.formplugin.computing.BizRuleEditPlugin;
import kd.fi.bcm.formplugin.computing.BizRuleExportHelper;
import kd.fi.bcm.formplugin.computing.BizRuleHelper;
import kd.fi.bcm.formplugin.util.FormUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BizRuleConfigEditPlugin
extends BizRuleEditPlugin {
    private static final String subViewNums = "subViewNums";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Boolean isOnlyRead = (Boolean)this.getView().getFormShowParameter().getCustomParam("isOnlyRead");
        EntryGrid ruleConfigEntry = (EntryGrid)this.getControl("entryentity");
        ruleConfigEntry.addHyperClickListener(evt -> {
            if (isOnlyRead != null && isOnlyRead.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u53ea\u8bfb\u6a21\u5f0f\uff0c\u65e0\u6cd5\u7f16\u8f91\u89c4\u5219\u903b\u8f91\u3002", (String)"BizRuleConfigEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            EntryGrid source = (EntryGrid)evt.getSource();
            DynamicObject[] dataEntitys = source.getEntryData().getDataEntitys();
            int rowIndex = evt.getRowIndex();
            DynamicObject bizruleConfig = dataEntitys[rowIndex];
            this.openNewTab(new FormShowParameter(), bizruleConfig);
        });
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        entryentity.removeIf(BizRuleHelper::isDelete);
        int rows = entryentity.size();
        for (int i = 0; i < rows; ++i) {
            String condition = this.getModel().getValue("logic_condition", i).toString();
            String scope = this.getModel().getValue("logic_scope", i).toString();
            String expression = this.getModel().getValue("logic_expression", i).toString();
            this.getModel().setValue("logic_condition_appear", (Object)this.getAppearCondition(condition), i);
            this.getModel().setValue("logic_scope_appear", (Object)this.getAppearScope(scope), i);
            this.getModel().setValue("logic_expression_appear", (Object)this.getAppearExpression(expression), i);
        }
    }

    private String getAppearExpression(String expression) {
        List xList = ChkFormulaServiceHelper.getXList((String)expression);
        if (CollectionUtils.isNotEmpty((Collection)xList)) {
            for (String xFormula : xList) {
                expression = expression.replace(xFormula, ChkFormulaServiceHelper.formatXdmExpression((String)xFormula));
            }
        }
        return expression;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        this.checkPerm(key);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        FormShowParameter showParameter = new FormShowParameter();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getEntryState().getSelectedRows();
        long bizRuleId = (Long)this.getModel().getValue("id");
        String number = this.getModel().getValue("number").toString();
        switch (key) {
            case "btn_add": 
            case "btn_copy": 
            case "btn_clear": {
                OperationResult result;
                if (StringUtils.isEmpty((String)this.getModel().getValue("number").toString()) || StringUtils.isEmpty((String)this.getModel().getValue("name").toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u5fc5\u5f55\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizRuleConfigFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String name = this.getModel().getValue("name").toString();
                if (status == OperationStatus.ADDNEW && bizRuleId == 0L && !(result = this.getView().invokeOperation("save")).isSuccess()) {
                    return;
                }
                this.openNewTab(showParameter, key);
                this.writeOperationLog(BizRuleConstant.getOperationAdd(), number, name, BizRuleConstant.getOperationStatusSuccess());
                break;
            }
            case "btn_preview": {
                showParameter.setCustomParam("KEY_MODEL_ID", this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
                showParameter.setCustomParam("bizRuleId", (Object)bizRuleId);
                showParameter.setFormId("bcm_configruleview");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btn_preview"));
                this.writeOperationLog(BizRuleConstant.getOperationPreView(), ResManager.loadKDString((String)"\u811a\u672c", (String)"BizRuleConfigEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number, BizRuleConstant.getOperationStatusSuccess());
                this.getView().showForm(showParameter);
                break;
            }
            case "btn_delete": {
                if (selectRows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u53ef\u5220\u9664\u7684\u884c\u8bb0\u5f55\u3002", (String)"BizRuleConfigFormPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6240\u9009\u903b\u8f91\uff0c\u5220\u9664\u540e\u65e0\u6cd5\u6062\u590d\u3002", (String)"BizRuleConfigFormPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delLogicCofirm"));
                break;
            }
            case "btn_copylogic": {
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u903b\u8f91\u3002", (String)"BizRuleConfigEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    break;
                }
                DynamicObjectCollection all = this.getView().getModel().getEntryEntity("entryentity");
                DynamicObjectCollection collections = new DynamicObjectCollection();
                for (int selectRow : selectRows) {
                    CloneUtils cloneUtils = new CloneUtils(false, true);
                    DynamicObject src = this.getModel().getEntryRowEntity("entryentity", selectRow);
                    DynamicObject tar = (DynamicObject)cloneUtils.clone(src.getDataEntityType(), (Object)src);
                    tar.set("logic_name", (Object)(src.getString("logic_name") + "copy"));
                    tar.set("logic_js", (Object)src.getString("logic_js").replaceFirst(src.getString("logic_number"), tar.getString("logic_number")).replaceFirst(src.getString("logic_name"), tar.getString("logic_name")));
                    collections.add((Object)tar);
                }
                DynamicObject old = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (DynamicObjectType)this.getModel().getDataEntityType());
                DynamicObjectCollection entryentity = old.getDynamicObjectCollection("entryentity");
                List oldCodeNums = entryentity.stream().map(entry -> entry.getString("logic_number")).sorted().collect(Collectors.toList());
                String firstCode = CodeRuleUtil.getCodeRuleNumber((String)"bcm_bizruleentityconfig", (String)"number", (String)this.getModel().getValue("number").toString());
                CodeRuleUtil.recycleCodeRuleNumber((String)"bcm_bizruleentityconfig", (String)"number", (String)this.getModel().getValue("number").toString(), (String)firstCode);
                if (oldCodeNums.stream().anyMatch(oldOne -> oldOne.compareTo(firstCode) >= 0)) {
                    CodeRuleUtil.syncCodeRuleNumbers((String)"bcm_bizruleentityconfig", (String)"number", (String)this.getModel().getValue("number").toString(), (String)((String)oldCodeNums.get(oldCodeNums.size() - 1)));
                }
                entryentity.addAll((Collection)collections);
                int seq = 0;
                for (DynamicObject newDyn : entryentity) {
                    if (newDyn.getLong("id") == 0L) {
                        String num = CodeRuleUtil.getCodeRuleNumber((String)"bcm_bizruleentityconfig", (String)"number", (String)this.getModel().getValue("number").toString());
                        newDyn.set("logic_number", (Object)num);
                        this.writeOperationLog(BizRuleConstant.getOperationCopy(), num, newDyn.getString("logic_name"), BizRuleConstant.getOperationStatusSuccess());
                    }
                    newDyn.set("seq", (Object)seq);
                    ++seq;
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{old});
                this.getView().invokeOperation("refresh");
                this.getView().invokeOperation("save");
                break;
            }
            case "bar_save": {
                this.doSave();
                break;
            }
            case "bar_commit": {
                this.doCommit();
                break;
            }
            case "bar_exit": {
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("add_logic".equals(actionId)) {
            this.refresh();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("delLogicCofirm".equals(callBackId) && com.google.common.base.Objects.equal((Object)event.getResult(), (Object)MessageBoxResult.Yes)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getEntryState().getSelectedRows();
            HashSet<Long> entryIds = new HashSet<Long>(selectRows.length);
            for (int i = 0; i < selectRows.length; ++i) {
                if (this.getModel().getEntryRowEntity("entryentity", selectRows[i]) == null) continue;
                entryIds.add(this.getModel().getEntryRowEntity("entryentity", selectRows[i]).getLong("id"));
            }
            DynamicObject bizRule = this.getView().getModel().getDataEntity(true);
            DynamicObjectCollection logics = bizRule.getDynamicObjectCollection("entryentity");
            HashSet<String> deleteLogicNumbers = new HashSet<String>();
            for (DynamicObject dyo : logics) {
                if (!entryIds.contains(dyo.getLong("id"))) continue;
                String logicNumber = dyo.getString("logic_number");
                String logic_name = dyo.getString("logic_name");
                deleteLogicNumbers.add(logicNumber);
                this.writeOperationLog(BizRuleConstant.getOperationDel(), logicNumber, logic_name, BizRuleConstant.getOperationStatusSuccess());
                dyo.set("isdelete", (Object)BizRuleLogicStatusEnum.DELETE.getStatus());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRule});
            this.getView().invokeOperation("save");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BizRuleConfigFormPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.refresh();
            for (String logicNumber : deleteLogicNumbers) {
                CodeRuleUtil.recycleCodeRuleNumber((String)"bcm_bizruleentityconfig", (String)"number", (String)String.valueOf(this.getModel().getValue("number")), (String)logicNumber);
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getSubViewNums() > 0) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5173\u95ed\u6240\u6709\u903b\u8f91\u914d\u7f6e\u5b50\u9875\u9762\u540e\uff0c\u518d\u5173\u95ed\u6b64\u89c4\u5219\u9875\u9762\u3002", (String)"BizRuleConfigEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
        }
    }

    private int getSubViewNums() {
        String cacheStr = this.getPageCache().get(subViewNums);
        if (StringUtils.isNotEmpty((String)cacheStr)) {
            List pages = (List)SerializationUtils.deSerializeFromBase64((String)cacheStr);
            for (String page : pages) {
                IFormView view = this.getView().getMainView();
                if (view == null || view.getView(page) == null) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5173\u95ed\u6240\u6709\u903b\u8f91\u914d\u7f6e\u5b50\u9875\u9762\u540e\uff0c\u518d\u5173\u95ed\u6b64\u89c4\u5219\u9875\u9762\u3002", (String)"BizRuleConfigEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                return 1;
            }
        }
        return 0;
    }

    private void addSubViewNums(String pageId) {
        String cacheStr = this.getPageCache().get(subViewNums);
        List<String> pages = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)cacheStr)) {
            pages = (List)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        }
        pages.add(pageId);
        this.getPageCache().put(subViewNums, SerializationUtils.serializeToBase64(pages));
    }

    private void refresh() {
        this.getView().invokeOperation("refresh");
    }

    private void openNewTab(FormShowParameter showParameter, String key) {
        Optional<DynamicObject> logicNumber;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        IFormView parentView = this.getView().getParentView();
        parentView = FormUtils.findHomePage(parentView);
        showParameter.setFormId(BizRuleUtil.getLogicForm((String)key));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add_logic"));
        params.put("KEY_MODEL_ID", ((DynamicObject)this.getModel().getValue("model")).getString("id"));
        params.put("number", this.getModel().getValue("number").toString());
        params.put("name", this.getModel().getValue("name").toString());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity) && (logicNumber = entryEntity.stream().max(Comparator.comparing(dy -> dy.getString("logic_number"), String::compareTo))).isPresent()) {
            params.put("max_number", logicNumber.get().getString("logic_number"));
        }
        params.put("bizRuleId", this.getModel().getValue("id"));
        params.put("pageId", this.getView().getPageId());
        showParameter.setCustomParams(params);
        showParameter.setStatus(OperationStatus.ADDNEW);
        if (parentView != null) {
            showParameter.setParentPageId(parentView.getPageId());
        }
        String pageId = UUID.randomUUID().toString().replace("-", "");
        showParameter.setPageId(pageId);
        this.addSubViewNums(pageId);
        this.getView().showForm(showParameter);
    }

    private void openNewTab(FormShowParameter showParameter, DynamicObject bizruleConfig) {
        IFormView mainView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String id = bizruleConfig.getString("id");
        String pageId = this.getView().getPageId() + id;
        if (mainView == null || mainView.getView(pageId) == null) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            showParameter.setFormId(BizRuleUtil.getLogicForm((String)bizruleConfig.getString("logic_type")));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add_logic"));
            showParameter.setPageId(pageId);
            parentView = FormUtils.findHomePage(parentView);
            if (parentView != null) {
                showParameter.setParentPageId(parentView.getPageId());
            }
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"BizRuleListPlugin_65", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MetadataServiceHelper.getDataEntityType((String)showParameter.getFormId()).getDisplayName().getLocaleValue(), this.getModel().getValue("logic_name")));
            params.put("KEY_MODEL_ID", ((DynamicObject)this.getModel().getValue("model")).getString("id"));
            params.put("bizruleconfig", bizruleConfig);
            params.put("bizRuleId", this.getModel().getValue("id"));
            params.put("id", id);
            params.put("pageId", this.getView().getPageId());
            showParameter.setCustomParams(params);
            showParameter.setStatus(OperationStatus.EDIT);
            if (parentView != null) {
                parentView.showForm(showParameter);
                this.addSubViewNums(pageId);
                this.getView().sendFormAction(parentView);
            } else {
                this.getView().showForm(showParameter);
                this.addSubViewNums(pageId);
            }
        } else {
            IFormView childFormView = mainView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private String getAppearCondition(String condition) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)condition) && condition.contains(";")) {
            String[] rows;
            for (String row : rows = condition.split(";")) {
                if (row.contains("|")) {
                    String[] cells = row.split("\\|");
                    String link = "";
                    String dimension = "";
                    String checkCondition = "";
                    String checkMethod = "";
                    String value = "";
                    if (cells.length == 5) {
                        dimension = cells[0];
                        checkCondition = cells[1];
                        checkMethod = cells[2];
                        value = cells[3];
                    } else {
                        link = cells[0];
                        dimension = cells[1];
                        checkCondition = cells[2];
                        checkMethod = cells[3];
                        value = cells[4];
                    }
                    if (StringUtils.isNotEmpty((String)link)) {
                        sb.append(this.convertCombo(link, "link"));
                        sb.append("|");
                    }
                    String entityNumber = dimension;
                    sb.append(this.convertCombo(dimension, "main_dimension"));
                    sb.append("|");
                    sb.append(this.convertCheckCondition(checkCondition));
                    sb.append("|");
                    sb.append(this.convertCombo(checkMethod, "check_method"));
                    sb.append("|");
                    String checkValue = "";
                    switch (checkCondition) {
                        case "storageType": {
                            checkValue = BizRuleConfigEditPlugin.getCheckValue(value, BizRuleConstant.STORAGE_NUMBER_NAME);
                            break;
                        }
                        case "aggOprt": {
                            checkValue = BizRuleConfigEditPlugin.getCheckValue(value, BizRuleConstant.AGG_NUMBER_NAME);
                            break;
                        }
                        case "properties": {
                            checkValue = this.convertProperty(entityNumber, null, value);
                            break;
                        }
                        case "number": 
                        case "controlOrg": {
                            checkValue = this.convertMember(entityNumber, value);
                            break;
                        }
                        case "EC": 
                        case "PC": {
                            long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
                            IDNumberTreeNode node = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)value);
                            checkValue = node.getNumber() + "-" + node.getName();
                            break;
                        }
                        case "isDependent": 
                        case "isIC": {
                            checkValue = "2".equals(value) ? ResManager.loadKDString((String)"\u662f", (String)"BizRuleConfigPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BizRuleConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                            break;
                        }
                        default: {
                            checkValue = this.convertProperty(entityNumber, checkCondition, value);
                        }
                    }
                    sb.append(checkValue);
                    sb.append("|");
                    sb.append(cells[cells.length - 1]);
                }
                sb.append(";");
            }
        }
        return sb.toString();
    }

    private static String getCheckValue(String value, Map<String, String> numberName) {
        StringJoiner joiner = new StringJoiner(",");
        for (String number : value.split(",")) {
            joiner.add(numberName.get(number));
        }
        return joiner.toString();
    }

    private Map<String, String> getPropertyMap(String entityNumber, String checkCondition) {
        HashMap<String, String> map = new HashMap(16);
        String propertyMap = this.getPageCache().get("properties-" + entityNumber + "-" + checkCondition);
        if (propertyMap == null) {
            String selectMemberFields;
            DynamicObjectCollection members;
            ArrayList propertyIds = new ArrayList();
            String selectFields = "id";
            long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            QFilter dimensionFilter = new QFilter("dimension", "=", (Object)MemberReader.getDimensionIdByNum((long)modelId, (String)SysDimensionEnum.getDimNumberByMemberTreefrom((String)entityNumber)));
            QFilter[] filters = checkCondition != null ? new QFilter[]{dimensionFilter, new QFilter("number", "=", (Object)checkCondition)} : new QFilter[]{dimensionFilter};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_definedproperty", (String)selectFields, (QFilter[])filters, null);
            dcs.forEach(dc -> propertyIds.add(dc.getLong("id")));
            if (CollectionUtils.isNotEmpty(propertyIds) && CollectionUtils.isNotEmpty((Collection)(members = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)(selectMemberFields = "number,name"), (QFilter[])new QFilter("propertyid", "in", propertyIds).toArray())))) {
                for (DynamicObject member : members) {
                    map.put(member.getString("number"), member.getString("name"));
                }
            }
            this.getPageCache().put("properties-" + entityNumber + "-" + checkCondition, SerializationUtils.toJsonString(map));
        } else {
            map = (Map)SerializationUtils.fromJsonString((String)propertyMap, Map.class);
        }
        return map;
    }

    private String convertMember(String entityNumber, String value) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByMemberTreemodel((String)entityNumber);
        if (dimensionEnum == null) {
            return sb.toString();
        }
        if (value.contains(",")) {
            String[] splits;
            for (String split : splits = value.split(",")) {
                if (split.contains(":")) {
                    BizRuleConfigEditPlugin.getPropertyAppearName(sb, modelId, dimensionEnum, split);
                } else {
                    sb.append(split).append("-").append(MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)SysDimensionEnum.getDimNumberByMemberTreefrom((String)entityNumber), (String)split.trim()).getName());
                }
                sb.append(",");
            }
            result = sb.substring(0, sb.length() - 1);
        } else if (value.contains(":")) {
            BizRuleConfigEditPlugin.getPropertyAppearName(sb, modelId, dimensionEnum, value);
        } else {
            result = sb.append(value).append("-").append(MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)LongUtil.toLong((Object)modelId)), (String)SysDimensionEnum.getDimNumberByMemberTreefrom((String)entityNumber), (String)value).getName()).toString();
        }
        return result;
    }

    private static void getPropertyAppearName(StringBuilder sb, long modelId, SysDimensionEnum dimensionEnum, String split) {
        String[] property = split.split(":");
        String propertyKey = property[0];
        String propertyVal = property[1];
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimensionEnum.getNumber());
        String keyName = DimPropList.getDimPropList((long)dimensionId).getFieldName(propertyKey);
        Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)modelId);
        String valName = "";
        for (IDNumberTreeNode node : allNodeFromCache.values()) {
            if (!Objects.equals(node.getDimId(), dimensionId) || !node.getNumber().equals(propertyVal)) continue;
            valName = node.getName();
        }
        sb.append(split).append("-").append(propertyVal).append(":").append(valName);
    }

    private String convertProperty(String entityNumber, String checkCondition, String value) {
        StringBuilder sb = new StringBuilder();
        Map<String, String> propertyMap = this.getPropertyMap(entityNumber, checkCondition);
        if (value.contains(",")) {
            String[] splits;
            for (String split : splits = value.split(",")) {
                sb.append(split).append("-").append(propertyMap.get(split));
                sb.append(",");
            }
            return sb.substring(0, sb.length() - 1);
        }
        return sb.append(value).append("-").append(propertyMap.get(value)).toString();
    }

    private String convertCombo(String condition, String key) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"bcm_bizrulelogicalcal");
        IDataEntityProperty dimensionProp = (IDataEntityProperty)entityType.getAllFields().get(key);
        if (dimensionProp instanceof ComboProp) {
            List comboItems = ((ComboProp)dimensionProp).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(condition)) continue;
                condition = comboItem.getName().getLocaleValue();
                break;
            }
        }
        return condition;
    }

    private String convertCheckCondition(String condition) {
        List<Map<String, String>> list = BizRuleCheckConditionPlugin.ENTITYLIST;
        for (Map<String, String> map : list) {
            if (!map.get("number").equals(condition)) continue;
            condition = map.get("name");
            break;
        }
        return condition;
    }

    private String getAppearScope(String scope) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)scope)) {
            String[] rows = scope.split(";");
            Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            for (String str : rows) {
                String sc;
                Map allNodeFromCache;
                Long dimensionId;
                String[] splits;
                String memName;
                String memNumber;
                IDNumberTreeNode memberByNumber;
                int index;
                String[] strs = str.split("\\|");
                if (SysDimensionEnum.getEnumByNumber((String)strs[0]) != null) {
                    DimTypesEnum dimTypesEnum = DimTypesEnum.getDimTypesEnumByNumber((String)strs[0]);
                    sb.append(dimTypesEnum.getName()).append("|");
                } else {
                    sb.append(strs[0]).append("|");
                }
                if (!" ".equals(strs[1])) {
                    String[] includeNumbers = strs[1].split(",");
                    int i = 0;
                    for (String number : includeNumbers) {
                        index = number.indexOf("@");
                        memberByNumber = index < 0 ? MemberReader.findMemberByNumber((String)modelNumber, (String)strs[0], (String)number) : MemberReader.findMemberByNumber((String)modelNumber, (String)strs[0], (String)number.substring(0, index));
                        memNumber = memberByNumber.getNumber();
                        memName = memberByNumber.getName();
                        if (memberByNumber == IDNumberTreeNode.NotFoundTreeNode && number.contains(":")) {
                            splits = number.split(":");
                            dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)strs[0]);
                            memNumber = splits[0] + ":" + DimPropList.getDimPropList((long)dimensionId).getFieldName(splits[0]);
                            allNodeFromCache = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)modelId);
                            for (IDNumberTreeNode node : allNodeFromCache.values()) {
                                if (!Objects.equals(node.getDimId(), dimensionId) || !node.getNumber().equals(splits[1])) continue;
                                memName = splits[1] + ":" + node.getName();
                            }
                        }
                        if (i != includeNumbers.length - 1) {
                            sb.append(memberByNumber.getNumber()).append("-").append(memNumber).append(":").append(memName);
                            if (index > 0) {
                                sc = number.substring(index + 1);
                                sb.append(ResManager.loadKDString((String)"\u7684", (String)"BizRuleConfigEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)Integer.parseInt(sc)).getName());
                            }
                            sb.append(",");
                        } else {
                            sb.append(memNumber).append("-").append(memName);
                            if (index > 0) {
                                sc = number.substring(index + 1);
                                sb.append(ResManager.loadKDString((String)"\u7684", (String)"BizRuleConfigEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)Integer.parseInt(sc)).getName());
                            }
                        }
                        ++i;
                    }
                    sb.append("|");
                } else {
                    sb.append(" ").append("|");
                }
                if (!" ".equals(strs[2])) {
                    String[] excludeNumbers = strs[2].split(",");
                    int j = 0;
                    for (String number : excludeNumbers) {
                        index = number.indexOf("@");
                        memberByNumber = index < 0 ? MemberReader.findMemberByNumber((String)modelNumber, (String)strs[0], (String)number) : MemberReader.findMemberByNumber((String)modelNumber, (String)strs[0], (String)number.substring(0, index));
                        memNumber = memberByNumber.getNumber();
                        memName = memberByNumber.getName();
                        if (memberByNumber == IDNumberTreeNode.NotFoundTreeNode && number.contains(":")) {
                            splits = number.split(":");
                            dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)strs[0]);
                            memNumber = splits[0] + ":" + DimPropList.getDimPropList((long)dimensionId).getFieldName(splits[0]);
                            allNodeFromCache = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)modelId);
                            for (IDNumberTreeNode node : allNodeFromCache.values()) {
                                if (!Objects.equals(node.getDimId(), dimensionId) || !node.getNumber().equals(splits[1])) continue;
                                memName = splits[1] + ":" + node.getName();
                            }
                        }
                        if (j != excludeNumbers.length - 1) {
                            sb.append(memNumber).append("-").append(memName);
                            if (index > 0) {
                                sc = number.substring(index + 1);
                                sb.append(ResManager.loadKDString((String)"\u7684", (String)"BizRuleConfigEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)Integer.parseInt(sc)).getName());
                            }
                            sb.append(",");
                        } else {
                            sb.append(memNumber).append("-").append(memName);
                            if (index > 0) {
                                sc = number.substring(index + 1);
                                sb.append(ResManager.loadKDString((String)"\u7684", (String)"BizRuleConfigEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)Integer.parseInt(sc)).getName());
                            }
                        }
                        ++j;
                    }
                    sb.append(";");
                    continue;
                }
                sb.append(" ;");
            }
        }
        return sb.toString();
    }

    @Override
    protected void saveCommitLogicRule() {
        super.saveCommitLogicRule();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        entryentity.removeIf(BizRuleHelper::isDelete);
        entryentity.forEach(ruleLogic -> {
            if (BizRuleLogicStatusEnum.NEW.getStatus().equals(ruleLogic.getString("isdelete"))) {
                ruleLogic.set("isdelete", (Object)BizRuleLogicStatusEnum.VALID.getStatus());
            }
        });
        for (DynamicObject logicRule : entryentity) {
            BizRuleConfigImportAndExport ruleInfoBean = BizRuleExportHelper.getRuleInfoBean(logicRule);
            logicRule.set("logic_commitexpr", (Object)ruleInfoBean.toString());
        }
    }
}

