/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.model.chk.XFormula;
import kd.fi.bcm.business.formula.model.excelformula.GETRATEFormula;
import kd.fi.bcm.business.formula.model.excelformula.IFFormula;
import kd.fi.bcm.business.formula.model.inv.EspFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.formplugin.computing.BizRuleHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class BizRuleConfigFormulaHelper {
    public static final String FORMULASIGN_FX = "formula_fx_";
    public static final String GETRATEACB = "getratelacb";
    public static final String ESPFORMULACB = "espformulacb";
    public static final String TEMPFORMULACB = "formula_temp_";
    public static final String SOURCE = "1";
    public static final String TARGET = "2";

    public static Object packAddText(String key, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"");
        sb.append(key);
        sb.append("\",\"");
        sb.append(text);
        sb.append("\"}");
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"addText");
        data.put("data", (Object)sb.toString());
        return data;
    }

    public static Object packGetText() {
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"getText");
        data.put("data", (Object)TimeServiceHelper.getTimeStamp());
        return data;
    }

    public static Object packUpdateText(String text) {
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"updateText");
        data.put("data", (Object)text);
        data.put("time", (Object)new Date().getTime());
        return data;
    }

    public static String getComboSign(String type, String chooseType) {
        String testSign = "";
        testSign = StringUtils.isNotEmpty((String)chooseType) ? type + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH) + "_" + chooseType : type + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
        return testSign;
    }

    public static String transFormula(String formula, IPageCache pageCache) {
        String[] leftStrs;
        ArrayList strLs = Lists.newArrayList();
        for (String leftStr : leftStrs = formula.split("\\{")) {
            String[] rightStrs = leftStr.split("}");
            Collections.addAll(strLs, rightStrs);
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sbName = new StringBuilder();
        for (String str : strLs) {
            if (str.contains(FORMULASIGN_FX) || str.contains(GETRATEACB) || str.contains(ESPFORMULACB) || str.contains(TEMPFORMULACB)) {
                sb.append(pageCache.get(str.subSequence(1, str.length() - 1).toString()));
                sbName.append(pageCache.get(str.subSequence(1, str.length() - 1) + "name"));
                continue;
            }
            if (str.contains("formula_extends_")) {
                sb.append(pageCache.get("bizruleformula_" + str.subSequence(1, str.length() - 1)));
                sbName.append(pageCache.get(str.subSequence(1, str.length() - 1) + "name"));
                continue;
            }
            sb.append(str);
            sbName.append(str);
        }
        return sb.append("@@@").append((CharSequence)sbName).toString();
    }

    public static Object packHyperClickText(String text, IPageCache pageCache) {
        StringBuilder sb = new StringBuilder();
        JSONObject data = new JSONObject();
        String[] strs = text.split(";");
        for (int i = 0; i < strs.length; ++i) {
            sb.append(BizRuleConfigFormulaHelper.getHyperformulData(strs[i], pageCache));
            if (i == strs.length - 1 && text.lastIndexOf(";") != text.length() - 1) continue;
            sb.append(";");
        }
        data.put("operate", (Object)"updateText");
        data.put("data", (Object)sb.toString());
        return data;
    }

    private static String getHyperformulData(String text, IPageCache pageCache) {
        String[] split = text.split("=", 2);
        if (split.length < 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u683c\u5f0f\u9519\u8bef\u3002", (String)"BizRuleConfigFormulaHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Pair parseFormula = ChkFormulaServiceHelper.parseFormula((String)text);
        if (parseFormula.p2 == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u683c\u5f0f\u9519\u8bef\u3002", (String)"BizRuleConfigFormulaHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String customControlData = text;
        HashMap<String, String> sign2Formula = new HashMap<String, String>();
        ((List)parseFormula.p2).sort(Comparator.comparing(IFormula::getUUID, String::compareTo));
        for (IFormula iFormula : (List)parseFormula.p2) {
            if (iFormula instanceof VFormula) {
                String chooseType = "A".equals(iFormula.getUUID()) ? TARGET : SOURCE;
                customControlData = BizRuleConfigFormulaHelper.cacheFormula((Formula)iFormula, pageCache, FORMULASIGN_FX, chooseType, customControlData, sign2Formula);
            }
            if (iFormula instanceof EspFormula) {
                customControlData = BizRuleConfigFormulaHelper.cacheFormula((Formula)iFormula, pageCache, ESPFORMULACB, "", customControlData, sign2Formula);
            }
            if (iFormula instanceof GETRATEFormula) {
                customControlData = BizRuleConfigFormulaHelper.cacheFormula((Formula)iFormula, pageCache, GETRATEACB, "", customControlData, sign2Formula);
            }
            if (!(iFormula instanceof XFormula)) continue;
            customControlData = BizRuleConfigFormulaHelper.cacheFormula((Formula)iFormula, pageCache, "formula_extends_", "", customControlData, sign2Formula);
        }
        for (Map.Entry entry : sign2Formula.entrySet()) {
            String sign = (String)entry.getKey();
            String formula = (String)entry.getValue();
            customControlData = StringUtils.replace((String)customControlData, (String)sign, (String)String.format("{\"%s\",\"%s\"}", sign, formula));
        }
        return customControlData;
    }

    private static String cacheFormula(Formula iFormula, IPageCache pageCache, String formulasignFx, String chooseType, String text, Map<String, String> sign2Formula) {
        String formulaName = iFormula.getName().toLowerCase(Locale.ENGLISH);
        if (iFormula instanceof GETRATEFormula) {
            formulaName = "getRate";
        }
        if (iFormula instanceof XFormula) {
            formulaName = iFormula.getName();
        }
        String formula = iFormula.toBizRuleFormulaString(formulaName);
        String jsStr = BizRuleConfigFormulaHelper.replace2JsFormula(formula);
        pageCache.put(formula, jsStr);
        String sign = BizRuleConfigFormulaHelper.getComboSign(formulasignFx, chooseType);
        if (iFormula instanceof XFormula) {
            pageCache.put("bizruleformula_" + sign, formula);
            pageCache.put(sign, ChkFormulaServiceHelper.formatXdmExpression((String)formula));
        } else {
            pageCache.put(sign, formula);
        }
        sign2Formula.put(sign, pageCache.get(sign));
        return StringUtils.replaceOnce((String)text, (String)formula, (String)sign);
    }

    private static String replace2JsFormula(String str) {
        List vformula = ChkFormulaServiceHelper.getIFormulaList((String)str, (String)VFormula.getVName());
        for (IFormula iFormula : vformula) {
            if (!(iFormula instanceof VFormula)) continue;
            VFormula v = (VFormula)iFormula;
            str = str.replace(v.toBizRuleFormulaString("v"), BizRuleUtil.convert2Js((VFormula)v));
        }
        if (CollectionUtils.isEmpty((Collection)vformula)) {
            return BizRuleUtil.getTemporaryStr((String)str);
        }
        return str;
    }

    public static String rebuildFormula(String formula, IPageCache pageCache) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < formula.length(); ++i) {
            char c = formula.charAt(i);
            if (c == '{') {
                sb.append(c);
                sb.append(formula.charAt(++i));
                ++i;
                StringBuilder keysb = new StringBuilder();
                while (i < formula.length()) {
                    c = formula.charAt(i);
                    sb.append(c);
                    if (c == '\"') break;
                    keysb.append(c);
                    ++i;
                }
                String key = keysb.toString();
                String text = "";
                if (pageCache.get(key) != null) {
                    text = pageCache.get(key);
                    String jsText = BizRuleConfigFormulaHelper.replace2JsFormula(text);
                    pageCache.put(text, jsText);
                }
                sb.append(",\"");
                sb.append(text);
                sb.append('\"');
                sb.append(formula.charAt(++i));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String buildScript(DynamicObject bizRule) {
        DynamicObjectCollection logics = bizRule.getDynamicObjectCollection("entryentity");
        String lineSp = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        boolean firstValidRuleLogic = true;
        for (int i = 0; i < logics.size(); ++i) {
            DynamicObject lg = (DynamicObject)logics.get(i);
            if (BizRuleHelper.isDelete(lg)) continue;
            if (firstValidRuleLogic) {
                sb.append("/**").append(lineSp).append(" * ").append(ResManager.loadKDString((String)"\u914d\u7f6e\u89c4\u5219\u7f16\u7801\uff0c\u7528\u4e8e\u5b9a\u4e49\u4ea7\u54c1\u7684\u914d\u7f6e\u89c4\u5219\u3002", (String)"BizRuleConfigSaveOp_0", (String)"fi-bcm-opplugin", (Object[])new Object[0])).append(bizRule.getString("number"));
                sb.append(lineSp).append(" * ").append(ResManager.loadKDString((String)"\u914d\u7f6e\u89c4\u5219\u540d\u79f0\uff1a", (String)"BizRuleConfigSaveOp_1", (String)"fi-bcm-opplugin", (Object[])new Object[0])).append(bizRule.getString("name"));
                sb.append(lineSp).append(" * ").append(ResManager.loadKDString((String)"\u5206\u914d\u8fc7\u7a0b ", (String)"BizRuleConfigSaveOp_2", (String)"fi-bcm-opplugin", (Object[])new Object[0])).append(bizRule.getString("alloprocessname"));
                sb.append(lineSp).append(" * ").append(ResManager.loadKDString((String)"\u8bf4\u660e ", (String)"BizRuleConfigSaveOp_3", (String)"fi-bcm-opplugin", (Object[])new Object[0])).append(bizRule.getString("description")).append(lineSp).append(" */").append(lineSp).append(lineSp);
            }
            sb.append(lg.get("logic_js")).append(lineSp).append(lineSp);
            firstValidRuleLogic = false;
        }
        return sb.toString();
    }

    public static String getMaxJsFormula(String formula) {
        String[] formulaStr = formula.split(";");
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String exp : formulaStr) {
            sb.append(BizRuleConfigFormulaHelper.getJsFormula(exp));
            if (count != formulaStr.length - 1) {
                sb.append(";");
            }
            ++count;
        }
        return sb.toString();
    }

    public static String getJsFormula(String formula) {
        String newStr = formula;
        Pair parseFormula = ChkFormulaServiceHelper.parseFormula((String)newStr);
        if (CollectionUtils.isEmpty((Collection)((Collection)parseFormula.p2)) || !((String)parseFormula.p1).startsWith("A=")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u683c\u5f0f\u9519\u8bef\u3002", (String)"BizRuleConfigFormulaHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        for (IFormula iFormula : (List)parseFormula.p2) {
            if (!(iFormula instanceof IFFormula)) continue;
            IFFormula ifFormula = (IFFormula)iFormula;
            if (ifFormula.getParamList().size() != 3) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5if\u51fd\u6570\u3002", (String)"BizRuleFunctionV_5", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            ParamItem paramItem = (ParamItem)ifFormula.getParamList().get(0);
            if (!(paramItem.getParam() instanceof BinaryOperationExpr)) {
                throw new KDBizException(ResManager.loadKDString((String)"if\u51fd\u6570\u5fc5\u987b\u662f\u903b\u8f91\u8868\u8fbe\u5f0f\u3002", (String)"BizRuleFunctionV_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            String sb = String.format("%s?%s:%s", BizRuleUtil.getExpr((ParamItem)paramItem), BizRuleUtil.getExpr((ParamItem)((ParamItem)ifFormula.getParamList().get(1))), BizRuleUtil.getExpr((ParamItem)((ParamItem)ifFormula.getParamList().get(2))));
            newStr = newStr.replace(ifFormula.toBizRuleFormulaString("if"), sb);
        }
        for (IFormula iFormula : (List)parseFormula.p2) {
            String formulaString;
            if (iFormula instanceof VFormula) {
                newStr = newStr.replace(((VFormula)iFormula).toBizRuleFormulaString("v"), BizRuleUtil.convert2Js((VFormula)((VFormula)iFormula)));
            }
            if (iFormula instanceof GETRATEFormula) {
                formulaString = ((Formula)iFormula).toBizRuleFormulaString("getRate");
                newStr = newStr.replace(formulaString, BizRuleUtil.appendQuote((String)BizRuleUtil.getTemporaryStr((String)formulaString)));
            }
            if (iFormula instanceof EspFormula) {
                formulaString = ((Formula)iFormula).toBizRuleFormulaString("esp");
                newStr = newStr.replace(formulaString, BizRuleUtil.appendQuote((String)formulaString));
            }
            if (!(iFormula instanceof XFormula)) continue;
            newStr = newStr.replace(iFormula.toString(), BizRuleUtil.appendQuote((String)ChkFormulaServiceHelper.formatXdmExpression((String)iFormula.toString())));
        }
        if ((newStr = BizRuleUtil.replaceSpecialJs((String)newStr)).endsWith("+\"")) {
            return "\"" + newStr.substring(0, newStr.length() - "+\"".length());
        }
        return BizRuleUtil.wrapQuote((String)newStr);
    }
}

