/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class BizRuleDeleteRecordPlugin
extends AbstractBaseListPlugin {
    private static final String billlistap = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("bar_exit", "bar_restore", "bar_delete");
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        BillList billList = (BillList)this.getControl(billlistap);
        switch (key) {
            case "bar_restore": {
                this.restoreBizRule();
                break;
            }
            case "bar_delete": {
                ListSelectedRowCollection collection = billList.getSelectedRows();
                if (collection.isEmpty()) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f7b\u5e95\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u5f7b\u5e95\u5220\u9664\uff1f", (String)"BizRuleDeleteRecordPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("DELETE_BIZRULE_COMFIRM", (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("DELETE_BIZRULE_COMFIRM".equals(callBackId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.deleteBizRule();
        }
    }

    @Override
    public String getBizEntityNumber() {
        return "bcm_bizruleentity";
    }

    private void deleteBizRule() {
        BillList billList = (BillList)this.getControl(billlistap);
        ListSelectedRowCollection collection = billList.getSelectedRows();
        if (!collection.isEmpty()) {
            Object[] ids = collection.getPrimaryKeyValues();
            QFilter filter = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"number", (QFilter[])new QFilter[]{filter});
            for (DynamicObject object : ruleCollection) {
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5f7b\u5e95\u5220\u9664", "BizRuleDeleteRecordPlugin_1", "fi-bcm-formplugin", "delete");
                super.writeSuccessLog(opName, object.getString("number"));
            }
            DeleteServiceHelper.delete((IDataEntityType)billList.getEntityType(), (Object[])ids);
            billList.refresh();
            billList.clearSelection();
        }
    }

    private void restoreBizRule() {
        BillList billList = (BillList)this.getControl(billlistap);
        ListSelectedRowCollection collection = billList.getSelectedRows();
        Object[] ids = collection.getPrimaryKeyValues();
        this.updateBizRule(ids, "deletestatus", false);
        this.updateBizRule(ids, "modifier", RequestContext.get().getUserId());
        this.updateBizRule(ids, "modifytime", TimeServiceHelper.getTimeStamp());
        for (Object id : ids) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_bizruleentity", (String)"catalog");
            QFilter filter3 = new QFilter("id", "!=", id);
            QFilter filter4 = new QFilter("catalog", "=", (Object)obj.getDynamicObject("catalog").getLong("id"));
            QFilter filter5 = new QFilter("deletestatus", "=", (Object)false);
            DynamicObjectCollection otherBizRuleCollection = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"catalog, executeseq", (QFilter[])new QFilter[]{filter3, filter4, filter5}, (String)"executeseq");
            if (otherBizRuleCollection == null) continue;
            this.updateBizRule(new Object[]{id}, "executeseq", obj.getDynamicObject("catalog").getString("name") + (otherBizRuleCollection.size() + 1));
        }
        billList.refresh();
        billList.clearSelection();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String modelId = (String)this.getFormCustomParam("KEY_MODEL_ID");
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter statusFilter = new QFilter("deletestatus", "=", (Object)true);
        e.getQFilters().add(modelFilter);
        e.getQFilters().add(statusFilter);
    }

    private void updateBizRule(Object[] ids, String propertyName, Object value) {
        Object[] entitys;
        for (DynamicObject dynamicObject : entitys = BusinessDataServiceHelper.load((String)"bcm_bizruleentity", (String)propertyName, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)})) {
            dynamicObject.set(propertyName, value);
        }
        if (entitys.length > 0) {
            BusinessDataServiceHelper.save((IDataEntityType)entitys[0].getDynamicObjectType(), (Object[])entitys);
        }
    }
}

