/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MoveEntryDown;
import kd.bos.form.operate.MoveEntryUp;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.integrationnew.util.RuleBase64;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.MutexServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.bizrule.QuickConstructConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.BizRuleRunStatusEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.common.IRefreshList;
import kd.fi.bcm.formplugin.computing.BizRuleHelper;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.FormUtils;
import org.apache.commons.collections.CollectionUtils;

public class BizRuleEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
IOperationLog {
    private static final Log LOG = LogFactory.getLog(BizRuleEditPlugin.class);
    public static final List<String> ADJEJE_ONLY_LIST = Arrays.asList("ADJ", "EJE", "CADJ", "CCADJ", "DADJ", "DEJE");

    private static String getBizruleSubmitMsg() {
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u63d0\u4ea4\u5b8c\u6210\uff0c\u70b9\u51fb\u4e1a\u52a1\u89c4\u5219-\u5217\u8868\u7684\u5de5\u5177\u680f\u6267\u884c\u60c5\u51b5\u6309\u94ae\u67e5\u770b\u6267\u884c\u60c5\u51b5\u3002", (String)"BizRuleEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        super.beforeItemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_save": {
                this.getView().invokeOperation("get_script_data_save");
                break;
            }
            case "bar_commit": {
                this.getModel().setValue("runstatus", (Object)BizRuleRunStatusEnum.COMMITED.getIndex());
                this.getView().invokeOperation("get_script_data_commit");
                break;
            }
            case "bar_exit": {
                this.getView().invokeOperation("get_script_data");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        this.checkPerm(key);
        boolean isCommon = this.isCommon();
        String alloprocess = (String)this.getModel().getValue("alloprocessid");
        String alloprocessname = (String)this.getModel().getValue("alloprocessname");
        switch (key) {
            case "bar_excute": {
                long bizRuleId = (Long)this.getModel().getValue("id");
                if (!this.checkIsSave() || bizRuleId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                String msg = BizRuleUtil.checkScriptGrammar((String)this.getModel().getValue("debug").toString());
                if (StringUtils.isNotEmpty((String)msg)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002", (String)"BizRuleEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), msg, MessageTypes.Default);
                    return;
                }
                if (BizRuleUtil.checkAllProcessBeforeSave((boolean)isCommon, (String)alloprocess, (String)alloprocessname)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u914d\u8fc7\u7a0b\u3002", (String)"BizRuleEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.executeBizRule();
                break;
            }
            case "bar_executeinfo": {
                this.showBizRuleExecuteInfoListForm();
                break;
            }
        }
    }

    protected void doSave() {
        boolean isCommon = this.isCommon();
        String allocateProcessId = (String)this.getModel().getValue("alloprocessid");
        String allocateProcessName = (String)this.getModel().getValue("alloprocessname");
        String debugEditContent = this.getPageCache().get("debugEditContent");
        if (String.valueOf(BizRuleRunStatusEnum.COMMITED.getIndex()).equals(this.getModel().getValue("runstatus")) && !Objects.equals(this.getModel().getValue("debug"), debugEditContent)) {
            this.getModel().setValue("runstatus", (Object)BizRuleRunStatusEnum.MODIFIED.getIndex());
        }
        String errorMSG = BizRuleUtil.checkScriptGrammar((String)this.getModel().getValue("debug").toString());
        Object number = this.getModel().getValue("number");
        Object name = this.getModel().getValue("name");
        if (StringUtils.isNotEmpty((String)errorMSG)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002", (String)"BizRuleEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), errorMSG, MessageTypes.Default);
            this.writeOperationLog(BizRuleConstant.getOperationSave(), number.toString(), name.toString(), BizRuleConstant.getOperationStatusFail());
            return;
        }
        if (BizRuleUtil.checkAllProcessBeforeSave((boolean)isCommon, (String)allocateProcessId, (String)allocateProcessName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u914d\u8fc7\u7a0b\u3002", (String)"BizRuleEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BizRuleExecuteTypeEnum.INVEST_ONLY.getCode().equals(this.getModel().getValue("executetype")) && this.checkNeedProcess("EIRpt")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ec5\u80a1\u6743\u91cd\u7b97\u201d\u6267\u884c\u7c7b\u578b\u7684\u89c4\u5219\u53ea\u80fd\u5b9a\u4e49\u5728EIRpt\u8fc7\u7a0b\u4e0a\u3002", (String)"BizRuleEditPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BizRuleExecuteTypeEnum.INTR_ONLY.getCode().equals(this.getModel().getValue("executetype")) && !this.checkIntrProcess()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ec5\u4ea4\u6613\u5e95\u7a3f\u201d\u6267\u884c\u7c7b\u578b\u7684\u89c4\u5219\u53ea\u5141\u8bb8\u5b9a\u4e49\u5728ADJ\u8fc7\u7a0b\u4e0a\u3002", (String)"BizRuleEditPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BizRuleExecuteTypeEnum.EQUITY_ONLY.getCode().equals(this.getModel().getValue("executetype")) && this.checkNeedProcess("ERAdj", "ADJ", "EJE", "CADJ", "CCADJ")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ec5\u6743\u76ca\u5e95\u7a3f\u201d\u6267\u884c\u7c7b\u578b\u7684\u89c4\u5219\u53ea\u5141\u8bb8\u5b9a\u4e49\u5728ERAdj\u3001ADJ\u3001EJE\u3001CADJ\u3001CCADJ\u8fc7\u7a0b\u4e0a\u3002", (String)"BizRuleEditPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BizRuleExecuteTypeEnum.EXTCONV_ONLY.getCode().equals(this.getModel().getValue("executetype")) && this.checkNeedProcess("IRpt", "RAdj")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ec5\u62d3\u5c55\u6570\u636e\u6298\u7b97\u201d\u6267\u884c\u7c7b\u578b\u7684\u89c4\u5219\u53ea\u5141\u8bb8\u5b9a\u4e49\u5728IRpt\u3001RAdj\u8fc7\u7a0b\u4e0a\u3002", (String)"BizRuleEditPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.getPageCache().get("isSpecialProcess") != null && this.noneSpecialProcess()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8fc7\u7a0b\u4e0d\u5141\u8bb8\u5206\u914d\u6a21\u677f\uff0c\u786e\u5b9a\u4fdd\u5b58\u7684\u8bdd\u4f1a\u5220\u9664\u539f\u89c4\u5219\u4e0e\u6a21\u677f\u7684\u5206\u914d\u5173\u7cfb\uff0c\u786e\u5b9a\u4fdd\u5b58\uff1f", (String)"BizRuleEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("saveCallBack", (IFormPlugin)this));
        } else {
            OperationResult operationResult = this.invokeSaveAction();
            if (operationResult.isSuccess()) {
                this.writeOperationLog(BizRuleConstant.getOperationSave(), number.toString(), name.toString(), BizRuleConstant.getOperationStatusSuccess());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BizRuleEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.changeTabNameAndCachePageId(operationResult);
        }
    }

    protected void doCommit() {
        boolean isCommon = this.isCommon();
        String allocateProcessId = (String)this.getModel().getValue("alloprocessid");
        String allocateProcessName = (String)this.getModel().getValue("alloprocessname");
        IDataModel model = this.getModel();
        String checkResult = BizRuleUtil.validate((String)model.getValue("name").toString(), (String)model.getValue("number").toString(), (String)this.getModel().getValue("debug").toString(), (String)model.getValue("id").toString(), (Long)((DynamicObject)model.getValue("model")).getLong("id"));
        if (BizRuleUtil.checkAllProcessBeforeSave((boolean)isCommon, (String)allocateProcessId, (String)allocateProcessName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u914d\u8fc7\u7a0b\u3002", (String)"BizRuleEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((String)checkResult)) {
            if (this.getPageCache().get("isSpecialProcess") != null && this.noneSpecialProcess()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8fc7\u7a0b\u4e0d\u5141\u8bb8\u5206\u914d\u6a21\u677f\uff0c\u786e\u5b9a\u4fdd\u5b58\u7684\u8bdd\u4f1a\u5220\u9664\u539f\u89c4\u5219\u4e0e\u6a21\u677f\u7684\u5206\u914d\u5173\u7cfb\uff0c\u786e\u5b9a\u4fdd\u5b58\uff1f", (String)"BizRuleEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("commitInfoCallBack", (IFormPlugin)this));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\u8c03\u8bd5\u7248\u5185\u5bb9\u5c06\u4f1a\u8986\u76d6\u5230\u8fd0\u884c\u7248\uff0c\u786e\u5b9a\u63d0\u4ea4\uff1f", (String)"BizRuleEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("commitCallBack", (IFormPlugin)this));
            }
        } else {
            this.getView().showTipNotification(checkResult);
        }
    }

    private boolean checkNeedProcess(String ... process) {
        if (this.getPageCache().get("alloprocessname") == null) {
            return false;
        }
        List alloprocess = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("alloprocessname"), JSONObject.class);
        List<String> need = Arrays.asList(process);
        return alloprocess.stream().anyMatch(pro -> !need.contains(((JSONObject)pro).getString("number")));
    }

    private boolean checkIntrProcess() {
        if (this.getPageCache().get("alloprocessname") == null) {
            return false;
        }
        List alloprocess = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("alloprocessname"), JSONObject.class);
        return alloprocess.size() == 1 && "ADJ".equals(((JSONObject)alloprocess.get(0)).getString("number"));
    }

    protected OperationResult invokeSaveAction() {
        OperationResult operationResult = this.getView().invokeOperation("save");
        if (operationResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)operationResult.getSuccessPkIds())) {
            String bizRuleId = operationResult.getSuccessPkIds().get(0).toString();
            try {
                MutexServiceHelper.request((String)bizRuleId, (String)"bcm_bizruleentity", (String)BizRuleConstant.getOperationEdit());
            }
            catch (Exception e) {
                LOG.error("request lock error!", (Throwable)e);
            }
            this.getView().getPageCache().put("MUTEX_OBJ_ID", bizRuleId);
        }
        return operationResult;
    }

    private void changeTabNameAndCachePageId(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            IFormView parentView;
            this.getView().setFormTitle(new LocaleString(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219-%s", (String)"BizRuleListPlugin_51", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getModel().getValue("name"))));
            if (CollectionUtils.isNotEmpty((Collection)operationResult.getSuccessPkIds()) && (parentView = this.getView().getParentView()) != null) {
                parentView.getPageCache().put(operationResult.getSuccessPkIds().get(0).toString(), this.getView().getPageId());
            }
        }
    }

    private boolean isCommon() {
        return (Boolean)Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("iscommon")).orElseGet(() -> this.getModel().getValue("iscommon"));
    }

    public void checkPerm(String opkey) {
        Map map;
        Map permitem = BcmPermSingleModel.getInstance().getPermitem();
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            map = (Map)permitem.get(parameter.getBillFormId());
            if (map == null) {
                map = (Map)permitem.get(this.getView().getEntityId());
            }
        } else {
            map = (Map)permitem.get(this.getView().getEntityId());
        }
        if (map == null || map.get(opkey) == null) {
            return;
        }
        String[] perm = ((String)map.get(opkey)).split("@");
        if (perm.length < 2) {
            return;
        }
        this.doCheckPermission(perm[0], perm[1]);
    }

    protected void doCheckPermission(String entityNum, String permItemId) {
        String modelId = ((DynamicObject)this.getModel().getValue("model")).getString("id");
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        int is = BcmBasePluginUtil.checkPermission(userId, Long.parseLong(modelId), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), entityNum, permItemId);
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((long)userId, (String)modelId)) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBaseListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean noneSpecialProcess() {
        boolean hasSpecialProcess = false;
        if (this.getPageCache().get("alloprocessname") != null) {
            for (Object obj : SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("alloprocessname"), JSONObject.class)) {
                JSONObject pro = (JSONObject)obj;
                if (!"EIRpt".equalsIgnoreCase(pro.getString("number")) && !"ERAdj".equalsIgnoreCase(pro.getString("number")) && !"IRpt".equalsIgnoreCase(pro.getString("number")) && !"RAdj".equalsIgnoreCase(pro.getString("number"))) continue;
                hasSpecialProcess = true;
                break;
            }
        }
        return !hasSpecialProcess;
    }

    private void showBizRuleExecuteInfoListForm() {
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getView().getPageId() + "executeinfo";
        IFormView parentView = this.getView().getParentView();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            ListShowParameter param = new ListShowParameter();
            param.setFormId("bcm_brexecuteinfo");
            param.setBillFormId("bcm_brexecuteinfoentity");
            Map map = this.getView().getFormShowParameter().getCustomParams();
            param.setCustomParam("modelid", map.get("KEY_MODEL_ID") != null ? map.get("KEY_MODEL_ID") : ((DynamicObject)this.getModel().getValue("model")).getString("id"));
            param.setCustomParam("bizruleid", (Object)this.getModel().getValue("id").toString());
            param.setPageId(pageId);
            parentView = FormUtils.findHomePage(parentView);
            if (parentView != null) {
                param.setParentPageId(parentView.getPageId());
            }
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u60c5\u51b5", (String)"BizRuleEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)param);
        } else {
            IFormView pageView = mainPageView.getView(pageId);
            pageView.activate();
            this.getView().sendFormAction(pageView);
        }
    }

    private boolean checkIsSave() {
        QFilter filter = new QFilter("number", "=", this.getModel().getValue("number"));
        return QueryServiceHelper.exists((String)"bcm_bizruleentity", (QFilter[])filter.toArray());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "execute_closecallback": {
                String errorinfo;
                if (!"OK".equals(closedCallBackEvent.getReturnData())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5df2\u5b8c\u6210\u3002", (String)"BizRuleEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                CodeEdit debugoutput = (CodeEdit)this.getControl("debugoutput");
                String debugOutputText = "";
                String loginfo = (String)ThreadCache.get((Object)(this.getModel().getValue("id") + "loginfo"));
                if (StringUtils.isNotEmpty((String)loginfo)) {
                    debugOutputText = debugOutputText + "\n" + loginfo;
                }
                if (StringUtils.isNotEmpty((String)(errorinfo = (String)ThreadCache.get((Object)(this.getModel().getValue("id") + "errorinfo"))))) {
                    debugOutputText = debugOutputText + "\n" + errorinfo;
                }
                debugoutput.setText(debugOutputText.replaceFirst("\n", ""));
                DynamicObject model = this.getModel().getDataEntity();
                AppLogInfo appLogInfo = OperationLogUtil.buildLogInfo((String)ResManager.loadKDString((String)"\u6267\u884c\u4e1a\u52a1\u89c4\u5219", (String)"BizRuleEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)(model.getString("number") + "-" + model.getString("name")), (Long)((DynamicObject)this.getModel().getValue("model")).getLong("id"), (String)this.getView().getEntityId());
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
                break;
            }
            case "selectprocess": {
                DynamicObjectCollection doc;
                if (closedCallBackEvent.getReturnData() == null || (doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData()).isEmpty()) break;
                this.getModel().setValue("alloprocessname", (Object)String.join((CharSequence)",", doc.stream().map(o -> o.getString("mname1")).collect(Collectors.toList())));
                this.getModel().setValue("alloprocessid", (Object)String.join((CharSequence)",", doc.stream().map(o -> o.getString("mid1")).collect(Collectors.toList())));
                ArrayList list = new ArrayList(doc.size());
                for (DynamicObject dynamicObject : doc) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", dynamicObject.get(4).toString());
                    map.put("scope", dynamicObject.get(5).toString());
                    map.put("number", dynamicObject.get(2).toString());
                    map.put("name", dynamicObject.get(3).toString());
                    list.add(map);
                }
                String s = SerializationUtils.toJsonString(list);
                this.getPageCache().put("alloprocessname", s);
                break;
            }
        }
    }

    private void executeBizRule() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_bizruleexecuteform");
        param.setCustomParam("KEY_MODEL_ID", (Object)((DynamicObject)this.getModel().getValue("model")).getString("id"));
        ArrayList<Long> ids = new ArrayList<Long>(10);
        ids.add((Long)this.getModel().getValue("id"));
        param.setCustomParam("select_ids", ids);
        String alloprocess = (String)this.getModel().getValue("alloprocessid");
        param.setCustomParam("alloprocessid", (Object)alloprocess);
        param.setCustomParam("executeType", this.getModel().getValue("executetype"));
        param.setParentPageId(this.getView().getPageId());
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"BizRuleEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "execute_closecallback"));
        this.getView().showForm(param);
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("alloprocessname".equals(key)) {
            this.showProcessMultilF7(key);
        } else if ("btn_runs".equals(key)) {
            this.appendScript(System.lineSeparator() + QuickConstructConstant.RUNS);
        } else if ("btn_var".equals(key)) {
            this.appendScript(System.lineSeparator() + QuickConstructConstant.USER_DEFINE_PARAM);
        } else if ("btn_v".equals(key)) {
            this.appendScript(System.lineSeparator() + QuickConstructConstant.V_FUNCTION);
        } else if ("btn_save".equals(key)) {
            this.appendScript(System.lineSeparator() + QuickConstructConstant.SAVE_FUNCTION);
        } else if ("btn_fix".equals(key)) {
            this.appendScript(System.lineSeparator() + QuickConstructConstant.FIX_FUNCTION);
        } else if ("btn_round".equals(key)) {
            this.appendScript(System.lineSeparator() + QuickConstructConstant.ROUND_FUNCTION);
        } else if ("btn_if".equals(key)) {
            this.appendScript(System.lineSeparator() + QuickConstructConstant.IF_EXPRE);
        } else if ("btn_rate".equals(key)) {
            this.appendScript(System.lineSeparator() + QuickConstructConstant.GET_RATE_FUNCTION);
        }
    }

    private void showProcessMultilF7(String key) {
        DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumber((long)((DynamicObject)this.getModel().getValue("model")).getLong("id"), (String)"Process");
        if (dim == null) {
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_mulmemberf7base_tem");
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("dimension", dim.getString("dseq"));
        params.put("KEY_MODEL_ID", ((DynamicObject)this.getModel().getValue("model")).getString("id"));
        params.put("resourceKey", key);
        params.put("sign", "alloprocessname");
        params.put("showScopes", ObjectSerialUtil.toByteSerialized((Object)new int[]{10}));
        QFilter customFilter = this.getProcessFilter();
        params.put("customFilter", customFilter.toSerializedString());
        params.put("onlyleaf", true);
        params.put("rule", true);
        para.setCustomParams(params);
        para.setCaption(dim.getString("name"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectprocess");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private QFilter getProcessFilter() {
        if (ModelUtil.queryApp(this.getView()) == ApplicationTypeEnum.RPT) {
            return new QFilter("number", "in", (Object)BizRuleConstant.RPT_PROCESS);
        }
        QFilter customFilter = new QFilter("isleaf", "!=", (Object)"1").or(new QFilter("isbizrule", "=", (Object)"1"));
        if (!BizRuleExecuteTypeEnum.ADJEJE_ONLY.getCode().equals(this.getModel().getValue("executetype"))) {
            customFilter.and(new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"BPNone", "TCF", "DIF", "TARPT"})));
        } else {
            customFilter.and(new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"BPNone", "TCF", "DIF", "TARPT", "Rpt", "ERpt", "CSTE"})));
        }
        customFilter.and("longnumber", "not like", (Object)"%!TCF!%");
        customFilter.and("longnumber", "not like", (Object)"%!DIF!%");
        customFilter.and("longnumber", "not like", (Object)"%!TARPT!%");
        return customFilter;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String event = e.getEventName();
        String content = RuleBase64.decode((String)e.getEventArgs());
        this.getModel().setValue("debug", (Object)content);
        if ("return_script_data_save".equals(event)) {
            this.checkPerm("bar_save");
            this.doSave();
            this.getPageCache().put("debugEditContent", content);
        } else if ("return_script_data_commit".equals(event)) {
            this.checkPerm("bar_commit");
            this.doCommit();
        } else {
            this.getView().invokeOperation("close");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"alloprocessname", "btn_var", "btn_runs", "btn_v", "btn_save", "btn_fix", "btn_round", "btn_if", "btn_rate"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Map map = this.getView().getFormShowParameter().getCustomParams();
            this.getModel().setValue("model", map.get("KEY_MODEL_ID"));
            JSONObject obj = JSONObject.parseObject((String)map.get("catalog").toString());
            String processCatalogId = obj.getString("processcatalog");
            String scenarioCatalogId = obj.getString("scatalog");
            this.getModel().setValue("scatalog", (Object)new Object[]{Long.valueOf(scenarioCatalogId)});
            this.getModel().setValue("processcatalog", (Object)processCatalogId);
        }
        this.getModel().setDataChanged(false);
        this.getModel().updateCache();
        this.hideButton();
    }

    private void hideButton() {
        Boolean isOnlyRead = (Boolean)this.getView().getFormShowParameter().getCustomParam("isOnlyRead");
        if (isOnlyRead != null && isOnlyRead.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_commit", "btn_add", "btn_delete", "btn_level, btn_copylogic"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isSuccess;
        super.afterDoOperation(e);
        if (e.getSource() instanceof DeleteEntry || e.getSource() instanceof Refresh || e.getSource() instanceof MoveEntryDown || e.getSource() instanceof MoveEntryUp) {
            return;
        }
        boolean bl = isSuccess = e.getOperationResult().getValidateResult().isSuccess() && e.getOperationResult().isSuccess();
        if (e.getSource() instanceof Save) {
            if (isSuccess) {
                boolean isCommon;
                if ("bcm_bizruleentityconfig".equals(this.getView().getEntityId())) {
                    this.updateDataToView();
                }
                OperationResult operationResult = e.getOperationResult();
                operationResult.setShowMessage(false);
                DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("periods");
                QFilter filter = new QFilter("bizrule", "=", this.getModel().getValue("id"));
                DeleteServiceHelper.delete((String)"bcm_bizrulescope", (QFilter[])new QFilter[]{filter});
                if (periods != null && !periods.isEmpty()) {
                    DynamicObject[] periodDynaObjs = new DynamicObject[periods.size()];
                    for (int i = 0; i < periods.size(); ++i) {
                        periodDynaObjs[i] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulescope");
                        periodDynaObjs[i].set("bizrule", this.getModel().getValue("id"));
                        periodDynaObjs[i].set("dimension", (Object)BizRuleUtil.getPeriodDimensionId((Object)((DynamicObject)this.getModel().getValue("model")).getLong("id")));
                        periodDynaObjs[i].set("member", ((DynamicObject)periods.get(i)).getDynamicObject("fbasedataid").get("id"));
                        periodDynaObjs[i].set("scope", (Object)RangeEnum.VALUE_10.getValue());
                    }
                    SaveServiceHelper.save((DynamicObject[])periodDynaObjs);
                }
                if (isCommon = ((Boolean)Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("iscommon")).orElseGet(() -> this.getModel().getValue("iscommon"))).booleanValue()) {
                    String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
                    long dimensionid = BizRuleUtil.getProcessDimensionId((Object)((DynamicObject)this.getModel().getValue("model")).getLong("id"));
                    Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
                    Long id = (Long)this.getModel().getValue("id");
                    QFilter commonFilter = new QFilter("member", "=", (Object)Long.parseLong(nodeId));
                    commonFilter.and("model", "=", (Object)modelId);
                    commonFilter.and("bizrule", "=", (Object)id);
                    if (!QueryServiceHelper.exists((String)"bcm_bizrulealloprocess", (QFilter[])commonFilter.toArray())) {
                        DynamicObject commonAllo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulealloprocess");
                        commonAllo.set("bizrule", (Object)id);
                        commonAllo.set("dimension", (Object)dimensionid);
                        commonAllo.set("member", (Object)Long.valueOf(nodeId));
                        commonAllo.set("model", (Object)modelId);
                        commonAllo.set("execsort", (Object)this.getMaxSort(modelId, Long.valueOf(nodeId)));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{commonAllo});
                    }
                } else {
                    String alloprocessids = (String)this.getModel().getValue("alloprocessid");
                    QFilter apfilter = new QFilter("bizrule", "=", this.getModel().getValue("id"));
                    apfilter.and(new QFilter("dimension", "=", (Object)BizRuleUtil.getProcessDimensionId((Object)((DynamicObject)this.getModel().getValue("model")).getLong("id"))));
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"member", (QFilter[])new QFilter[]{apfilter});
                    Set<Object> deleteAllo = collection == null || collection.isEmpty() ? new HashSet(16) : collection.stream().map(dy -> dy.getLong("member")).collect(Collectors.toSet());
                    Set newAllo = Stream.of(alloprocessids.split(",")).map(Long::parseLong).collect(Collectors.toSet());
                    Set intersectionAllo = CollectionUtil.intersectionLong(deleteAllo, newAllo);
                    for (Long alloid : intersectionAllo) {
                        deleteAllo.remove(alloid);
                        newAllo.remove(alloid);
                    }
                    QFilter pfilter = new QFilter("bizrule", "=", this.getModel().getValue("id"));
                    pfilter.and("member", "in", deleteAllo);
                    DeleteServiceHelper.delete((String)"bcm_bizrulealloprocess", (QFilter[])new QFilter[]{pfilter});
                    if (!newAllo.isEmpty()) {
                        DynamicObject[] periodDynaObjs = new DynamicObject[newAllo.size()];
                        long dimensionid = BizRuleUtil.getProcessDimensionId((Object)((DynamicObject)this.getModel().getValue("model")).getLong("id"));
                        long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
                        long id = (Long)this.getModel().getValue("id");
                        int i = 0;
                        for (Long processid : newAllo) {
                            periodDynaObjs[i] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulealloprocess");
                            periodDynaObjs[i].set("bizrule", (Object)id);
                            periodDynaObjs[i].set("dimension", (Object)dimensionid);
                            periodDynaObjs[i].set("member", (Object)processid);
                            periodDynaObjs[i].set("model", (Object)modelId);
                            periodDynaObjs[i].set("execsort", (Object)this.getMaxSort(modelId, processid));
                            ++i;
                        }
                        SaveServiceHelper.save((DynamicObject[])periodDynaObjs);
                    }
                }
            }
        } else if (e.getOperateKey().startsWith("get_script_data")) {
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("cmd", e.getOperateKey());
            data.put("id", UUID.randomUUID().toString());
            data.put("operate", UUID.randomUUID().toString());
            ((CustomControl)this.getControl("debugcontent")).setData(data);
        } else if (e.getSource() instanceof Donothing && isSuccess && "excutescript".equals(((Donothing)e.getSource()).getOperateKey())) {
            this.getView().showSuccessNotification(BizRuleEditPlugin.getBizruleSubmitMsg());
        }
    }

    private int getMaxSort(long modelid, Long processid) {
        QFilter filter = new QFilter("member", "=", (Object)processid);
        filter.and("model", "=", (Object)modelid);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"execsort", (QFilter[])filter.toArray(), (String)"execsort desc", (int)1);
        if (result.isEmpty()) {
            return 1;
        }
        return ((DynamicObject)result.get(0)).getInt("execsort") + 1;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String processname;
        if ("alloprocessname".equals(e.getProperty().getName()) && StringUtils.isEmpty((String)(processname = (String)this.getModel().getValue("alloprocessname")))) {
            this.getModel().setValue("alloprocessid", null);
            this.removeCacheByKey("alloprocessname");
        }
        if ("executetype".equals(e.getProperty().getName())) {
            String oldValue;
            ChangeData[] changeSet = e.getChangeSet();
            String newValue = changeSet[0].getNewValue().toString();
            if (this.isChangeBetweenInvAndNormal(newValue, oldValue = (String)ThreadCache.get((Object)"executetype_oldvalue", () -> changeSet[0].getOldValue().toString())) && this.allocateTemplate()) {
                this.removeCacheByKey("isSpecialProcess");
                this.getModel().setValue("executetype", (Object)oldValue);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u5df2\u5206\u914d\u6a21\u677f\uff0c\u8bf7\u5148\u53cd\u5206\u914d\u540e\u518d\u5207\u6362\u6267\u884c\u7c7b\u578b\u3002", (String)"BizRuleEditPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else if (BizRuleExecuteTypeEnum.ADJEJE_ONLY.getCode().equals(newValue) && !this.getAdjEjeOnlyList().contains(this.getModel().getValue("alloprocessid").toString())) {
                this.getModel().setValue("alloprocessid", null);
                this.getModel().setValue("alloprocessname", null);
                this.removeCacheByKey("alloprocessname");
            }
        }
    }

    private boolean allocateTemplate() {
        if (0L == LongUtil.toLong((Object)this.getModel().getValue("id"))) {
            return false;
        }
        QFilter filter = new QFilter("bizrule", "=", this.getModel().getValue("id"));
        return QueryServiceHelper.exists((String)"bcm_brallocateentity", (QFilter[])filter.toArray());
    }

    private boolean isChangeBetweenInvAndNormal(String newValue, String oldValue) {
        return BizRuleExecuteTypeEnum.EQUITY_ONLY.getCode().equals(newValue) && !BizRuleExecuteTypeEnum.EQUITY_ONLY.getCode().equals(oldValue) || !BizRuleExecuteTypeEnum.EQUITY_ONLY.getCode().equals(newValue) && BizRuleExecuteTypeEnum.EQUITY_ONLY.getCode().equals(oldValue);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateDataToView();
        if (this.isCommon()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"executetype"});
        } else if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            String nodeId;
            List mountedNode = BizRuleConstant.EXECUTE_TYPES.stream().map(BizRuleExecuteTypeEnum::getCode).collect(Collectors.toList());
            if (mountedNode.contains(nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId"))) {
                BizRuleExecuteTypeEnum executeTypeEnum = BizRuleExecuteTypeEnum.getEnumByCode((String)nodeId);
                this.getModel().setValue("executetype", (Object)executeTypeEnum.getCode());
            } else {
                this.getModel().setValue("executetype", (Object)BizRuleExecuteTypeEnum.ALL.getCode());
            }
        } else {
            this.getModel().setValue("executetype", this.getModel().getValue("executetype"));
        }
        this.getModel().setDataChanged(false);
        this.getModel().updateCache();
        this.hideButton();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean isCommon = (Boolean)Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("iscommon")).orElseGet(() -> this.getModel().getValue("iscommon"));
        List mountedNode = BizRuleConstant.EXECUTE_TYPES.stream().map(BizRuleExecuteTypeEnum::getCode).collect(Collectors.toList());
        String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
        if (!isCommon && OperationStatus.ADDNEW == status && !mountedNode.contains(nodeId)) {
            DynamicObject processes = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)"bcm_processmembertree", (String)"number,name");
            this.getModel().setValue("alloprocessid", (Object)nodeId);
            this.getModel().setValue("alloprocessname", (Object)processes.getString("name"));
            ArrayList list = new ArrayList(1);
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("id", processes.getString("id"));
            map.put("scope", "10");
            map.put("number", processes.getString("number"));
            map.put("name", processes.getString("name"));
            list.add(map);
            String string = SerializationUtils.toJsonString(list);
            this.getPageCache().put("alloprocessname", string);
        }
        if (!isCommon && OperationStatus.EDIT == status) {
            QFilter filter = new QFilter("bizrule", "=", this.getModel().getValue("id"));
            filter.and(new QFilter("dimension", "=", (Object)BizRuleUtil.getProcessDimensionId((Object)((DynamicObject)this.getModel().getValue("model")).getLong("id"))));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"member", (QFilter[])new QFilter[]{filter});
            if (collection != null && !collection.isEmpty()) {
                List processIds = collection.stream().map(dy -> String.valueOf(dy.getLong("member"))).collect(Collectors.toList());
                List list = processIds.stream().map(Long::parseLong).collect(Collectors.toList());
                QFilter pfilter = new QFilter("id", "in", list);
                DynamicObjectCollection processes = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,number,name", (QFilter[])pfilter.toArray());
                List processnames = processes.stream().map(dy -> dy.getString("name")).collect(Collectors.toList());
                List processNumberList = processes.stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
                if (!this.isInvExecuteType() && (processNumberList.contains("EIRpt") || processNumberList.contains("ERAdj") || processNumberList.contains("RAdj") || processNumberList.contains("IRpt"))) {
                    this.getPageCache().put("isSpecialProcess", "1");
                }
                String ids = String.join((CharSequence)",", processIds);
                String names = String.join((CharSequence)",", processnames);
                this.getModel().setValue("alloprocessid", (Object)ids);
                this.getModel().setValue("alloprocessname", (Object)names);
                ArrayList list2 = new ArrayList(processes.size());
                for (DynamicObject dynamicObject : processes) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", dynamicObject.getString("id"));
                    map.put("scope", "10");
                    map.put("number", dynamicObject.getString("number"));
                    map.put("name", dynamicObject.getString("name"));
                    list2.add(map);
                }
                String s = SerializationUtils.toJsonString(list2);
                this.getPageCache().put("alloprocessname", s);
                this.getModel().setDataChanged(false);
            }
        }
        if (isCommon) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultimport"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"alloprocessname", "btn_runs"});
            if (OperationStatus.ADDNEW == status) {
                this.getModel().setValue("defaultimport", (Object)true);
                this.getModel().setValue("iscommon", (Object)true);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"alloprocessname"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultimport"});
        }
        LinkedList<ComboItem> comboItemList = new LinkedList<ComboItem>();
        BizRuleExecuteTypeEnum[] values = BizRuleExecuteTypeEnum.values();
        ComboEdit types = (ComboEdit)this.getControl("executetype");
        if (ApplicationTypeEnum.RPT.getAppnum().equals(this.getBizAppId()) || BizRuleTypeEnum.CONFIG.getType().equals(this.getModel().getValue("type"))) {
            for (BizRuleExecuteTypeEnum value : values) {
                if (value != BizRuleExecuteTypeEnum.ALL && value != BizRuleExecuteTypeEnum.RPT_ONLY) continue;
                comboItemList.add(new ComboItem(new LocaleString(value.getDescription()), value.getCode()));
            }
        } else {
            if (nodeId == null || "-2".equals(nodeId)) {
                nodeId = this.getModel().getValue("executetype").toString();
            }
            if (!mountedNode.contains(nodeId)) {
                comboItemList.add(new ComboItem(new LocaleString(BizRuleExecuteTypeEnum.ALL.getDescription()), BizRuleExecuteTypeEnum.ALL.getCode()));
                comboItemList.add(new ComboItem(new LocaleString(BizRuleExecuteTypeEnum.RPT_ONLY.getDescription()), BizRuleExecuteTypeEnum.RPT_ONLY.getCode()));
                comboItemList.add(new ComboItem(new LocaleString(BizRuleExecuteTypeEnum.ADJEJE_ONLY.getDescription()), BizRuleExecuteTypeEnum.ADJEJE_ONLY.getCode()));
                comboItemList.add(new ComboItem(new LocaleString(BizRuleExecuteTypeEnum.EXTCONV_ONLY.getDescription()), BizRuleExecuteTypeEnum.EXTCONV_ONLY.getCode()));
            } else {
                BizRuleExecuteTypeEnum bizRuleExecuteTypeEnum = BizRuleExecuteTypeEnum.getEnumByCode((String)nodeId);
                comboItemList.add(new ComboItem(new LocaleString(bizRuleExecuteTypeEnum.getDescription()), bizRuleExecuteTypeEnum.getCode()));
            }
        }
        types.setComboItems(comboItemList);
    }

    private boolean isInvExecuteType() {
        return BizRuleExecuteTypeEnum.EQUITY_ONLY.getCode().equals(this.getModel().getValue("executetype"));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        switch (event.getCallBackId()) {
            case "commitCallBack": {
                String modelId;
                if (!com.google.common.base.Objects.equal((Object)event.getResult(), (Object)MessageBoxResult.Yes)) break;
                CodeEdit edit = (CodeEdit)this.getControl("codeedit_content");
                Object debug = this.getModel().getValue("debug");
                if (debug == null) {
                    return;
                }
                edit.setText(debug.toString());
                this.getModel().setValue("content", (Object)edit.getText());
                this.getModel().setValue("runstatus", (Object)BizRuleRunStatusEnum.COMMITED.getIndex());
                ThreadCache.put((Object)"isCommitOp", (Object)true);
                this.saveCommitLogicRule();
                OperationResult operationResult = this.invokeSaveAction();
                if (!operationResult.isSuccess()) {
                    if (CollectionUtils.isNotEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
                        this.getView().showErrorNotification(((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage());
                    } else {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"BizRuleEditPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"BizRuleEditPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.changeTabNameAndCachePageId(operationResult);
                String number = (String)this.getModel().getValue("number");
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)this.getModel().getValue("name");
                String name = ormLocaleValue.getLocaleValue();
                this.writeOperationLog(BizRuleConstant.getOperationCommit(), number, name, BizRuleConstant.getOperationStatusSuccess());
                if (this.getPageCache().get("isSpecialProcess") != null && this.noneSpecialProcess()) {
                    DeleteServiceHelper.delete((String)"bcm_brallocateentity", (QFilter[])new QFilter[]{new QFilter("bizrule.id", "=", this.getModel().getValue("id"))});
                    this.removeCacheByKey("isSpecialProcess");
                }
                BizRuleHelper.updateCalculateStatus((modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")) != null ? modelId : ((DynamicObject)this.getModel().getValue("model")).getString("id"));
                break;
            }
            case "saveCallBack": {
                if (!com.google.common.base.Objects.equal((Object)event.getResult(), (Object)MessageBoxResult.Yes)) break;
                OperationResult operationResult = this.invokeSaveAction();
                this.changeTabNameAndCachePageId(operationResult);
                if (!operationResult.isSuccess()) break;
                DeleteServiceHelper.delete((String)"bcm_brallocateentity", (QFilter[])new QFilter[]{new QFilter("bizrule.id", "=", this.getModel().getValue("id"))});
                this.removeCacheByKey("isSpecialProcess");
                this.writeOperationLog(BizRuleConstant.getOperationSave(), "number.toString()", "name.toString()", BizRuleConstant.getOperationStatusSuccess());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BizRuleEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "commitInfoCallBack": {
                if (!com.google.common.base.Objects.equal((Object)event.getResult(), (Object)MessageBoxResult.Yes)) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\u8c03\u8bd5\u7248\u5185\u5bb9\u5c06\u4f1a\u8986\u76d6\u5230\u8fd0\u884c\u7248\uff0c\u786e\u5b9a\u63d0\u4ea4\uff1f", (String)"BizRuleEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("commitCallBack", (IFormPlugin)this));
                break;
            }
        }
    }

    private void removeCacheByKey(String key) {
        this.getPageCache().remove(key);
    }

    protected void saveCommitLogicRule() {
    }

    private void updateDataToView() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        IDataModel model = this.getModel();
        String content = model.getValue("content").toString();
        CodeEdit edit = (CodeEdit)this.getControl("codeedit_content");
        edit.setText(content);
        String debug = model.getValue("debug").toString();
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("cmd", "set_script_data");
        data.put("script", OperationStatus.ADDNEW.equals((Object)status) ? ResManager.loadKDString((String)"//\u5982\u9700\u5199\u6ce8\u91ca\uff0c\u8bf7\u5728\u6bcf\u884c\u4ee5\u201c//\u201d\u5f00\u5934\u3002", (String)"BizRuleEditPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : debug);
        data.put("keys", (String)BizRuleUtil.getRuleKeys());
        JSONObject ecmaScript = BizRuleUtil.getECMAScript();
        BizRuleUtil.addOtherDimension((JSONObject)ecmaScript, (long)((DynamicObject)this.getModel().getValue("model")).getLong("id"));
        data.put("bcm_ecmascript", (String)ecmaScript);
        ((CustomControl)this.getControl("debugcontent")).setData(data);
        this.getPageCache().put("debugEditContent", debug);
    }

    private void appendScript(String appendContent) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("cmd", "append_script_data");
        data.put("script", appendContent);
        data.put("id", UUID.randomUUID());
        ((CustomControl)this.getControl("debugcontent")).setData(data);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if ("scenarios".equals(name)) {
            filter.and("isleaf", "=", (Object)true);
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(filter);
        } else if ("periods".equals(name)) {
            filter.and("isleaf", "=", (Object)true);
            filter.and("number", "not in", (Object)new String[]{"CurrentPeriod", "LastPeriod"});
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(filter);
        } else if ("scatalog".equals(name)) {
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(filter.and("number", "!=", (Object)"root"));
            param.setMultiSelect(false);
        } else if ("catalog".equals(name)) {
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(filter);
            param.setMultiSelect(false);
        } else if ("alloprocess".equals(name)) {
            filter.and("isleaf", "=", (Object)true);
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(filter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView listView;
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String listPageId = map.getOrDefault("listPageID", "").toString();
        if (StringUtils.isNotEmpty((String)listPageId) && (listView = this.getView().getMainView().getView(listPageId)) != null) {
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)listView.getService(FormViewPluginProxy.class);
            pluginProxy.getPlugIns().forEach(p -> {
                if (IRefreshList.class.isAssignableFrom(p.getClass())) {
                    ((IRefreshList)IRefreshList.class.cast(p)).refreshList();
                }
            });
            this.getView().sendFormAction(listView);
        }
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
    }

    @Override
    public void writeMultiLangLog(OpNameMultiLangEnumBridge opName, OPDescMultiLangEnumBridge opDescriotion) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opName, (OPDescMultiLangEnumBridge)opDescriotion, (Long)((DynamicObject)this.getModel().getValue("model")).getLong("id"), (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    public void writeOperationLog(OpNameMultiLangEnumBridge opName, String objNumber, String objName, String result) {
        this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("%1$s %2$s\uff0c%3$s%4$s", "AbstractBaseFormPlugin_7", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{objNumber, objName, opName.loadKDString(), result})));
    }

    public void pageRelease(EventObject e) {
        Map lockInfo;
        super.pageRelease(e);
        String pkId = ((IFormView)e.getSource()).getPageCache().get("MUTEX_OBJ_ID");
        if (StringUtils.isNotEmpty((String)pkId) && (lockInfo = MutexServiceHelper.getLockInfo((String)pkId, (String)"bcm_bizruleentity", (String)BizRuleConstant.getOperationEdit())) != null && lockInfo.get("userid") != null && ((String)lockInfo.get("userid")).equals(RequestContext.getOrCreate().getUserId())) {
            MutexServiceHelper.forceRelease((String)pkId, (String)"bcm_bizruleentity", (String)BizRuleConstant.getOperationEdit());
        }
    }

    private List<String> getAdjEjeOnlyList() {
        long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        return ADJEJE_ONLY_LIST.stream().map(pro -> MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)pro).getId().toString()).collect(Collectors.toList());
    }
}

