/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.inv.EspFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.invest.HolderTypeEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.spread.formula.EncoderService;

public class BizRuleEspFormulaPlugin
extends AbstractBaseFormPlugin {
    private static final List<String> DIMKEYS = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static String PARENTORG = "ctx.E.parent().controlOrg";
    private static String ORGNOW = "ctx.E.number";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(DIMKEYS, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initComboItems(this.getModelId());
        if (this.getFormCustomParam("formula") != null) {
            String formula = (String)this.getFormCustomParam("formula");
            ExpressParser parser = new ExpressParser();
            EncoderService encoder = new EncoderService();
            try {
                Pair pair = parser.parse(formula, encoder);
                String sharescaletype = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(0)).toString();
                this.rebuildNumberType(sharescaletype);
                String numberType = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(1)).toString();
                String invholderorg = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(2)).toString();
                String investorg = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(3)).toString();
                String sNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(4)).toString();
                String yearNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(5)).toString();
                String periodNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(6)).toString();
                DynamicObject scenario = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_scenemembertree", (Object)this.getModelId(), (String)sNumber);
                DynamicObject year = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_fymembertree", (Object)this.getModelId(), (String)yearNumber);
                DynamicObject period = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_periodmembertree", (Object)this.getModelId(), (String)periodNumber);
                if (scenario != null) {
                    this.getModel().setValue("scenario", (Object)scenario.getLong("id"));
                }
                if (year != null) {
                    this.getModel().setValue("year", (Object)year.getLong("id"));
                }
                if (period != null) {
                    this.getModel().setValue("period", (Object)period.getLong("id"));
                }
                this.getModel().setValue("sharescaletype", (Object)sharescaletype);
                this.getModel().setValue("numbertype", (Object)numberType);
                this.getModel().setValue("invholderorg", (Object)invholderorg);
                this.getModel().setValue("investorg", (Object)investorg);
            }
            catch (Exception e1) {
                log.error("error", (Throwable)e1);
            }
        } else {
            this.rebuildNumberType(InvRelaTypeEnum.DirectRelaType.getType());
            this.getModel().setValue("invholderorg", (Object)PARENTORG);
            this.getModel().setValue("investorg", (Object)ORGNOW);
            this.getModel().setValue("sharescaletype", (Object)InvRelaTypeEnum.DirectRelaType.getType());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
        BasedataEdit sceneEdit = (BasedataEdit)this.getView().getControl("scenario");
        sceneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit yearEdit = (BasedataEdit)this.getView().getControl("year");
        yearEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodEdit = (BasedataEdit)this.getView().getControl("period");
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        this.validateData();
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            String sNumber = this.getModel().getValue("scenario") == null ? "" : ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
            String yNumber = this.getModel().getValue("year") == null ? "" : ((DynamicObject)this.getModel().getValue("year")).getString("number");
            String pNumber = this.getModel().getValue("period") == null ? "" : ((DynamicObject)this.getModel().getValue("period")).getString("number");
            String invholderorg = (String)this.getModel().getValue("invholderorg");
            String investorg = (String)this.getModel().getValue("investorg");
            String sharescaletype = (String)this.getModel().getValue("sharescaletype");
            String numberType = (String)this.getModel().getValue("numbertype");
            EspFormula espFormula = new EspFormula();
            ParamList paramList = new ParamList();
            paramList.add((Object)new ParamItem((Object)sharescaletype));
            paramList.add((Object)new ParamItem((Object)numberType));
            paramList.add((Object)new ParamItem((Object)invholderorg));
            paramList.add((Object)new ParamItem((Object)investorg));
            paramList.add((Object)new ParamItem((Object)sNumber));
            paramList.add((Object)new ParamItem((Object)yNumber));
            paramList.add((Object)new ParamItem((Object)pNumber));
            espFormula.initParam(paramList);
            String invFormula = espFormula.toBizRuleFormulaString("esp");
            HashMap map = Maps.newHashMap();
            map.put("formula", invFormula);
            String name = HolderTypeEnum.getNameByNumber((String)numberType);
            if ("4".equals(sharescaletype) || "5".equals(sharescaletype)) {
                name = HolderTypeEnum.UniteScale.getName();
            }
            map.put("name", name);
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }

    private void initComboItems(Long modelId) {
        ComboEdit ce = (ComboEdit)this.getControl("sharescaletype");
        List items = InvRelationTypeHelper.getComboItems((Long)modelId, qfBuilder -> {
            List oldRelationTypeNumber = Arrays.stream(InvRelaTypeEnum.values()).filter(invRelaTypeEnum -> Integer.parseInt(invRelaTypeEnum.getType()) < 9).map(invRelaTypeEnum -> invRelaTypeEnum.getType()).collect(Collectors.toList());
            qfBuilder.add("status", "=", (Object)InvRelationTypeConstant.StatusEnum.ENABLE.getCode()).add("number", "in", oldRelationTypeNumber);
        });
        ce.setComboItems(items);
        ComboEdit ce1 = (ComboEdit)this.getControl("invholderorg");
        ComboEdit ce2 = (ComboEdit)this.getControl("investorg");
        ArrayList<ComboItem> items1 = new ArrayList<ComboItem>();
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(new QFilter("isleaf", "=", (Object)"1"));
        qf.and(new QFilter("storagetype", "=", (Object)"2"));
        DynamicObjectCollection dcol = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number,name", (QFilter[])qf.toArray());
        if (dcol != null) {
            items1.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6bcd\u516c\u53f8", (String)"BizRuleEspFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])), PARENTORG));
            items1.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7", (String)"BizRuleEspFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])), ORGNOW));
            for (DynamicObject dy : dcol) {
                String number = dy.getString("number");
                String name = dy.getString("name");
                items1.add(new ComboItem(new LocaleString(name), number));
            }
        }
        ce1.setComboItems(items1);
        ce2.setComboItems(items1);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("sharescaletype".equals(key)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            newValue = e.getChangeSet() == null || StringUtils.isEmpty((String)newValue) ? oldValue : newValue;
            this.rebuildNumberType(newValue);
        }
    }

    private void rebuildNumberType(String newValue) {
        if ("1".equals(newValue)) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.equivalentAdd.getName()), HolderTypeEnum.equivalentAdd.getNumber());
            ComboItem item2 = new ComboItem(new LocaleString(HolderTypeEnum.littleAdd.getName()), HolderTypeEnum.littleAdd.getNumber());
            comboItems.add(item1);
            comboItems.add(item2);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.equivalentAdd.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        } else if ("2".equals(newValue)) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.direct.getName()), HolderTypeEnum.direct.getNumber());
            ComboItem item2 = new ComboItem(new LocaleString(HolderTypeEnum.little.getName()), HolderTypeEnum.little.getNumber());
            comboItems.add(item1);
            comboItems.add(item2);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.direct.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        } else if ("3".equals(newValue)) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.equivalentMulti.getName()), HolderTypeEnum.equivalentMulti.getNumber());
            ComboItem item2 = new ComboItem(new LocaleString(HolderTypeEnum.littleMulti.getName()), HolderTypeEnum.littleMulti.getNumber());
            comboItems.add(item1);
            comboItems.add(item2);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.equivalentMulti.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        } else if ("4".equals(newValue) || "5".equals(newValue)) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.UniteScale.getName()), HolderTypeEnum.little.getNumber());
            comboItems.add(item1);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.little.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        } else {
            ComboEdit comboEdit = (ComboEdit)this.getControl("numbertype");
            ArrayList comboItems = Lists.newArrayList();
            ComboItem item1 = new ComboItem(new LocaleString(HolderTypeEnum.little.getName()), HolderTypeEnum.little.getNumber());
            ComboItem item2 = new ComboItem(new LocaleString(HolderTypeEnum.DefindScale.getName()), HolderTypeEnum.DefindScale.getNumber());
            comboItems.add(item1);
            comboItems.add(item2);
            comboEdit.setComboItems((List)comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("numbertype", (Object)HolderTypeEnum.DefindScale.getNumber());
            this.getModel().endInit();
            comboEdit.getView().updateView("numbertype");
        }
    }

    private void validateData() {
        if (!"bcm_invchangeformula".equals(this.getView().getFormShowParameter().getParentFormId()) && this.getModel().getValue("invholderorg") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6295\u8d44\u5355\u4f4d\u3002", (String)"BizRuleEspFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

