/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.BRExecStatusEnum;
import kd.fi.bcm.formplugin.util.BillListHyperLinkClickUtil;
import org.apache.commons.lang3.StringUtils;

public class BizRuleExecInfoPlugin
extends AbstractListPlugin {
    private static final String filtercontainerap = "filtercontainerap";
    private static final String billlistap = "billlistap";
    private static final String bar_refresh = "bar_refresh";
    private static final String bar_delete = "bar_delete";
    private static final String modelid_cachekey = "MODELID";

    private String getOperationDelete() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"BizRuleExecInfoPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"BizRuleExecInfoPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"BizRuleExecInfoPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl(filtercontainerap);
        fc.setBillFormId("bcm_brexecuteinfoentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer fc = (FilterContainer)this.getControl(filtercontainerap);
        fc.addSearchClickListener(evt -> this.refreshBillList());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_refresh": {
                this.refreshBillList();
                break;
            }
            case "bar_delete": {
                this.deleteExecuteInfo();
                break;
            }
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(billlistap);
        billList.clearSelection();
        billList.refresh();
    }

    private void deleteExecuteInfo() {
        BillList billList = (BillList)this.getControl(billlistap);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8bb0\u5f55\u3002", (String)"BizRuleExecInfoPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u8bb0\u5f55\uff1f", (String)"BizRuleExecInfoPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("action_delete", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("action_delete".equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList billList = (BillList)this.getControl(billlistap);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ListSelectedRow row : selectedRows) {
                ids.add((Long)row.getPrimaryKeyValue());
            }
            QFilter filter = new QFilter("id", "in", ids);
            Map delDyMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_brexecuteinfoentity", (String)"id,bizrule.id,bizrule.number,bizrule.name", (QFilter[])new QFilter[]{filter});
            int deleteSize = BusinessDataWriter.delete((String)"bcm_brexecuteinfoentity", (QFilter[])new QFilter[]{filter});
            if (deleteSize > 0) {
                this.writeDelOpLog(delDyMap, this.getOperationStatusSuccess());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BizRuleExecInfoPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.writeDelOpLog(delDyMap, this.getOperationStatusFail());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"BizRuleExecInfoPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.refreshBillList();
        }
    }

    private void writeDelOpLog(Map<Object, DynamicObject> delDyMap, String status) {
        for (Map.Entry<Object, DynamicObject> delDy : delDyMap.entrySet()) {
            DynamicObject dy = delDy.getValue();
            String number = dy.getString("bizrule.number");
            ILocaleString name = dy.getLocaleString("bizrule.name");
            String localName = "";
            if (name != null) {
                localName = name.getLocaleValue();
            }
            String log = String.format("%s %s,%s%s", number, localName, this.getOperationDelete(), status);
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)this.getOperationDelete(), (String)log, (Long)this.getModelId());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        long modelId = this.getModelId();
        QFilter filterModel = new QFilter("model", "=", (Object)modelId);
        List filterList = e.getQFilters();
        filterList.add(filterModel);
        Iterator iterator = filterList.iterator();
        QFilter qFilter = null;
        while (iterator.hasNext()) {
            QFilter filter = (QFilter)iterator.next();
            String property = filter.getProperty();
            if (!"execstatus".equals(property)) continue;
            Object str = filter.getValue();
            if (BRExecStatusEnum.LASTEXECUTED.getIndex().equals(str)) {
                iterator.remove();
                qFilter = this.getLastExecutedIdFilter();
                continue;
            }
            if (!BRExecStatusEnum.LASTSUCCESS.getIndex().equals(str)) continue;
            iterator.remove();
            qFilter = this.getLastSuccessIdFilter();
        }
        filterList.add(qFilter);
        if (!MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId))) {
            filterList.add(new QFilter("executor", "=", (Object)Long.parseLong(RequestContext.get().getUserId())));
        }
        e.setOrderBy("starttime desc, bizrule.executeseq asc");
    }

    private QFilter getLastSuccessIdFilter() {
        QFilter filter1 = new QFilter("model", "=", (Object)this.getModelId());
        QFilter filter2 = new QFilter("execstatus", "=", (Object)BRExecStatusEnum.SUCCESS.getIndex());
        return this.getIdFilter(new QFilter[]{filter1, filter2});
    }

    private QFilter getIdFilter(QFilter[] filterArray) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_brexecuteinfoentity", (String)"id, bizrule", (QFilter[])filterArray, (String)"starttime desc");
        TreeSet<Long> bizruleSet = new TreeSet<Long>();
        ArrayList<Long> idList = new ArrayList<Long>();
        if (collection != null) {
            for (DynamicObject dynamicObject : collection) {
                if (!bizruleSet.add(dynamicObject.getLong("bizrule"))) continue;
                idList.add(dynamicObject.getLong("id"));
            }
        }
        return new QFilter("id", "in", idList);
    }

    private QFilter getLastExecutedIdFilter() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        return this.getIdFilter(new QFilter[]{qFilter});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object id = BillListHyperLinkClickUtil.getObjectPkIdFromEvt(args);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_bizruleerrorinfo");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", id);
        parameter.setCustomParam("field", (Object)args.getFieldName());
        this.getView().showForm(parameter);
    }

    private long getModelId() {
        String modelId = this.getPageCache().get(modelid_cachekey);
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelid");
            if (StringUtils.isNotEmpty((CharSequence)modelId)) {
                this.getPageCache().put(modelid_cachekey, modelId);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb\u53c2\u6570\uff0c\u9875\u9762\u8bbf\u95ee\u51fa\u9519\u3002", (String)"BizRuleExecInfoPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        return Long.parseLong(modelId);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        args.setCustomQFilters(this.getFilters());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        args.setCustomQFilters(this.getFilters());
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String ruleId = (String)this.getView().getFormShowParameter().getCustomParam("bizruleid");
        if (StringUtils.isNotEmpty((CharSequence)ruleId)) {
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                if (!"bizrule.number".equals(filterColumn.getFieldName())) continue;
                ((CommonFilterColumn)filterColumn).setConstantDefaultValue((Object)ruleId);
            }
        }
    }

    private List<QFilter> getFilters() {
        ArrayList<QFilter> result = new ArrayList<QFilter>();
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter filter1 = new QFilter("deletestatus", "=", (Object)false);
        result.add(filter);
        result.add(filter1);
        return result;
    }
}

