/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class BizRuleExecutePlugin
extends AbstractBaseFormPlugin
implements SingleMemberF7Util.ISingleMemberF7Handle {
    private static final List<String> keys = Lists.newArrayList((Object[])new String[]{"currency", "entity", "period", "scenario", "year"});

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("bar_ok");
        ArrayList dims = Lists.newArrayList((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.CURRENCY.getNumber()});
        String modelId = (String)this.getFormCustomParam("KEY_MODEL_ID");
        QFilter filter1 = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        QFilter filter2 = new QFilter("number", "in", (Object)dims.toArray());
        DynamicObjectCollection dimObjs = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number", (QFilter[])new QFilter[]{filter1, filter2}, (String)"number");
        ArrayList<Long> dimIds = new ArrayList<Long>();
        dimObjs.forEach(e -> dimIds.add(e.getLong("id")));
        SingleMemberF7Util.cacheSingleMemberF7ByModelId(this.getView(), this.getModel(), Long.parseLong(modelId), dimIds, keys, (SingleMemberF7Util.ISingleMemberF7Handle)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit process = (BasedataEdit)this.getControl("process");
        process.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("process".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String alloprocess = (String)this.getFormCustomParam("alloprocessid");
            if (StringUtils.isNotEmpty((String)alloprocess)) {
                String[] processsids = alloprocess.split(",");
                QFilter filter = new QFilter("id", "in", Arrays.stream(processsids).map(LongUtil::toLong).collect(Collectors.toList()));
                showParameter.getListFilterParameter().setFilter(filter);
            } else {
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                filter.and("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"BPNone", "TCF"}));
                filter.and("longnumber", "not like", (Object)"%TCF!%");
                filter.and("isleaf", "=", (Object)Boolean.TRUE);
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        if (source instanceof BasedataEditSingleMemberF7) {
            BasedataEditSingleMemberF7 f7 = (BasedataEditSingleMemberF7)((Object)source);
            String dimNum = f7.getEntity();
            if ("bcm_periodmembertree".equals(dimNum)) {
                FormShowParameter formShowParameter = arg0.getFormShowParameter();
                DynamicObject scenarioDy = (DynamicObject)this.getModel().getValue("scenario");
                if (scenarioDy == null) {
                    scenarioDy = (DynamicObject)this.getValue("scenario");
                }
                DimensionServiceHelper.checkSPConfig((boolean)true, (DynamicObject)scenarioDy, (long)this.getModelId(), (IDataModel)this.getPlugin().getView().getModel(), (String)this.getPeriodLogo());
                DimensionServiceHelper.buildPeriodFilter((long)this.getModelId(), (long)scenarioDy.getLong("id"), (FormShowParameter)formShowParameter);
                f7.getQFilter().and(DimensionServiceHelper.getFilter((long)this.getModelId(), (long)scenarioDy.getLong("id")));
            } else if ("bcm_fymembertree".equals(dimNum)) {
                QFilter filter = new QFilter("number", "not in", (Object)new String[]{"CurrentYear", "LastYear", "Year"});
                f7.getQFilter().and(filter);
            }
        }
    }

    @Override
    public String getBizEntityNumber() {
        return "bcm_bizruleentity";
    }

    private void checkParams(String content) {
        boolean isIncludeCurrentPeriod;
        boolean isIncludeCurrentYear;
        boolean bl = isIncludeCurrentYear = (content.contains("Year.CurrentYear") || content.contains("Year.LastYear")) && this.getModel().getValue("year") == null;
        if (isIncludeCurrentYear) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u4e2d\u5305\u542b\u672c\u5e74\u6216\u4e0a\u5e74\uff0c\u8bf7\u9009\u62e9\u8d22\u5e74\u7684\u6210\u5458\u3002", (String)"BizRuleExecutePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        boolean bl2 = isIncludeCurrentPeriod = (content.contains("Period.CurrentPeriod") || content.contains("Period.LastPeriod")) && this.getModel().getValue("period") == null;
        if (isIncludeCurrentPeriod) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u4e2d\u5305\u542b\u672c\u671f\u6216\u4e0a\u671f\uff0c\u8bf7\u9009\u62e9\u671f\u95f4\u7684\u6210\u5458\u3002", (String)"BizRuleExecutePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("bar_ok".equals(key)) {
            List bizRuleIds = (List)this.getFormCustomParam("select_ids");
            String executeType = (String)this.getFormCustomParam("executeType");
            Map<String, Pair<String, Long>> map = this.getParams();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"bcm_model", (String)"id,number");
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            if (entity != null && "Entity".equals(entity.getString("number"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5176\u4ed6\u7ec4\u7ec7\u3002", (String)"BizRuleExecutePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("entity", null);
                return;
            }
            HashMap csMap = Maps.newHashMap();
            if (this.getModel().getValue("entity") != null) {
                csMap.put(entity.getLong("id"), entity.getString("number"));
            }
            String ecCurrency = "";
            Long orgParent = 0L;
            String orgNumber = "";
            boolean isLeaf = false;
            for (Long bizRuleId : bizRuleIds) {
                DynamicObject bizRuleObj = BusinessDataServiceHelper.loadSingle((Object)bizRuleId, (String)"bcm_bizruleentity", (String)"number, catalog, debug");
                String content = bizRuleObj.getString("debug");
                this.checkParams(content);
                BizRuleExecParam param = new BizRuleExecParam(object.getString("number"));
                param.setExecuteType(BizRuleExecuteTypeEnum.getEnumByCode((String)executeType));
                if (map.get((Object)"entity").p1 != null) {
                    param.getCommonParam().addCommonParamPair(DimTypesEnum.ENTITY.getNumber(), (Long)map.get((Object)"entity").p2, (String)map.get((Object)"entity").p1);
                }
                if (map.get((Object)"year").p1 != null) {
                    param.getCommonParam().addCommonParamPair(DimTypesEnum.YEAR.getNumber(), (Long)map.get((Object)"year").p2, (String)map.get((Object)"year").p1);
                }
                if (map.get((Object)"period").p1 != null) {
                    param.getCommonParam().addCommonParamPair(DimTypesEnum.PERIOD.getNumber(), (Long)map.get((Object)"period").p2, (String)map.get((Object)"period").p1);
                }
                boolean isECOrDC = false;
                if (map.get((Object)"currency").p1 != null) {
                    String currencyNumber = (String)map.get((Object)"currency").p1;
                    IDNumberTreeNode org = MemberReader.findEntityMemberById((String)object.getString("number"), (Long)((Long)map.get((Object)"entity").p2));
                    Pair orgCurrencyPair = TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)org, (long)this.getModelId(), (String)((String)map.get((Object)"process").p1), (String)currencyNumber);
                    currencyNumber = (String)orgCurrencyPair.p2;
                    Long currencyId = MemberReader.findCurrencyMemberByNum((String)object.getString("number"), (String)currencyNumber).getId();
                    if (currencyNumber == null || currencyId == -1L) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u5e01\u79cd\u4e0d\u5b58\u5728\uff0c\u8bf7\u5230\u7ef4\u5ea6\u7ba1\u7406\u68c0\u67e5\u8be5\u7ec4\u7ec7\u7684\u5e01\u79cd\u53d8\u66f4\u8bb0\u5f55\u3002", (String)"BizRuleExecutePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    param.getCommonParam().addCommonParamPair(DimTypesEnum.CURRENCY.getNumber(), currencyId, currencyNumber);
                    if ("DC".equals(currencyNumber) || "EC".equals(currencyNumber)) {
                        ecCurrency = currencyNumber;
                        isECOrDC = true;
                    } else {
                        ecCurrency = (String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)org, (long)this.getModelId(), (String)((String)map.get((Object)"process").p1), (String)"EC").p2;
                    }
                    orgParent = org.getParent().getId();
                    isLeaf = org.isLeaf();
                    orgNumber = org.getNumber();
                }
                if (map.get((Object)"scenario").p1 != null) {
                    param.getCommonParam().addCommonParamPair(DimTypesEnum.SCENARIO.getNumber(), (Long)map.get((Object)"scenario").p2, (String)map.get((Object)"scenario").p1);
                }
                if (map.get((Object)"process").p1 != null) {
                    param.getCommonParam().addCommonParamPair(DimTypesEnum.PROCESS.getNumber(), (Long)map.get((Object)"process").p2, (String)map.get((Object)"process").p1);
                }
                ThreadCache.put((Object)"exclude_rule_id", (Object)bizRuleId);
                param.getCommonParam().addCommonParamPair(DimTypesEnum.PROCESS.getNumber(), (Long)map.get((Object)"process").p2, (String)map.get((Object)"process").p1);
                if (param.getExecuteType() == BizRuleExecuteTypeEnum.INVEST_ONLY && !this.checkInvestOnlyCanRun(param, isLeaf, isECOrDC)) {
                    return;
                }
                if (!this.checkProcessAndOrg(param, isLeaf)) {
                    return;
                }
                if (!this.checkPeriodStatus(param, orgNumber)) {
                    return;
                }
                if (!this.checkFlowStatus(param, orgParent)) {
                    return;
                }
                if (!this.checkProcessAndCurrency(param, ecCurrency)) {
                    return;
                }
                if (MergeControlHelper.isQuoteLocked((Long)this.getModelId(), (Long)((Long)map.get((Object)"scenario").p2), (Long)((Long)map.get((Object)"year").p2), (Long)((Long)map.get((Object)"period").p2), (Long)((Long)map.get((Object)"entity").p2))) {
                    throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioVersionError"), new Object[0]);
                }
                boolean isRelaProcess = OrgRelaProcessMembPool.isRelaProcess((String)((String)map.get((Object)"process").p1));
                if (isRelaProcess && !((String)map.get((Object)"entity").p1).contains("_")) {
                    String virtualEntity = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)((Long)map.get((Object)"entity").p2)).getVirtualEntity();
                    Pair pair = param.getCommonParam().getDimMemberPair(DimTypesEnum.ENTITY.getNumber());
                    param.getCommonParam().addCommonParamPair(DimTypesEnum.ENTITY.getNumber(), (Long)map.get((Object)"entity").p2, virtualEntity);
                }
                param.setPaperTemplateNumber("");
                param.setCalcTypeWay("2");
                BizRuleExecStarter.execBizRule((List)Lists.newArrayList((Object[])new Long[]{bizRuleId}), (BizRuleExecParam)param, (boolean)true, (boolean)true);
            }
            this.saveUserSelect();
            this.getView().returnDataToParent((Object)"OK");
            this.getView().close();
        }
    }

    private boolean checkInvestOnlyCanRun(BizRuleExecParam param, boolean isLeaf, boolean isECOrDC) {
        DynamicObject query = QueryServiceHelper.queryOne((String)"bcm_invrelationset", (String)"supportruleexc", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).toArray());
        if (Objects.isNull(query) || !query.getBoolean("supportruleexc")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7684\u80a1\u6743\u6570\u636e\u4e0d\u5141\u8bb8\u89c4\u5219\u5199\u5165\uff0c\u8bf7\u5230\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e\u9875\u9762\u4fee\u6539\u80a1\u6743\u67e5\u8be2\u53c2\u6570\u914d\u7f6e\u3002", (String)"BizRuleExecutePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Pair process = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.PROCESS.getNumber());
        if (!"EIRpt".equals(process.p2)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ec5\u80a1\u6743\u91cd\u7b97\u201d\u6267\u884c\u7c7b\u578b\u7684\u89c4\u5219\u53ea\u80fd\u5b9a\u4e49\u5728EIRpt\u8fc7\u7a0b\u4e0a\u3002", (String)"BizRuleExecutePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (isLeaf) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ec5\u80a1\u6743\u91cd\u7b97\u201d\u6267\u884c\u7c7b\u578b\u7684\u89c4\u5219\uff0c\u53ea\u5141\u8bb8\u9009\u62e9\u5408\u5e76\u7ec4\u7ec7\u8c03\u8bd5\u3002", (String)"BizRuleExecutePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)param.getModelNum(), (String)param.getEntityNumber());
        if (!isECOrDC && !param.getCurrencyNumber().equals(entityNode.getCurrency())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ec5\u80a1\u6743\u91cd\u7b97\u201d\u6267\u884c\u7c7b\u578b\u7684\u89c4\u5219\uff0c\u5e01\u79cd\u53ea\u53ef\u9009DC\u3001EC\u6216\u5408\u5e76\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u79cd\u3002", (String)"BizRuleExecutePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkProcessAndOrg(BizRuleExecParam param, boolean isLeaf) {
        Pair process = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.PROCESS.getNumber());
        if (BizRuleConstant.ONLY_EXECUTE_PROCESS_IN_MERGE_ORG.contains(process.p2) && isLeaf) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8fc7\u7a0b\u53ea\u5bf9\u5408\u5e76\u7ec4\u7ec7\u6709\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BizRuleExecutePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkPeriodStatus(BizRuleExecParam param, String orgNumber) {
        boolean checkPeriodStatus;
        Pair scene = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.SCENARIO.getNumber());
        Pair year = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.YEAR.getNumber());
        Pair period = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.PERIOD.getNumber());
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)ConfigEnum.CM012.getNumber()) && !(checkPeriodStatus = PeriodSettingHelper.checkPeriodStatus((long)this.getModelId(), (String)orgNumber, (long)((Long)scene.p1), (long)((Long)year.p1), (long)((Long)period.p1), (String)"datastatus"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7[%s]\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BizRuleExecutePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNumber));
            return false;
        }
        return true;
    }

    private boolean checkFlowStatus(BizRuleExecParam param, Long orgParent) {
        Map mcStatusMap;
        McStatus mcStatus;
        Pair entity = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.ENTITY.getNumber());
        Pair process = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.PROCESS.getNumber());
        Pair scene = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.SCENARIO.getNumber());
        Pair year = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.YEAR.getNumber());
        Pair period = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.PERIOD.getNumber());
        if (BizRuleConstant.ONLY_EXECUTE_PROCESS_IN_EC.contains(process.p2) && (mcStatus = (McStatus)(mcStatusMap = McStatus.batchGetMcStatus((Object)this.getModelId(), Collections.singletonList(entity.p1), (Object)scene.p1, (Object)year.p1, (Object)period.p1)).get(entity.p1)).getFlow().isSubmit()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"ERpt-\u9ed8\u8ba4\u5e01\u62a5\u8868\u5df2\u63d0\u4ea4\u6216\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u8c03\u8bd5\u3002", (String)"BizRuleExecutePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (BizRuleConstant.NO_EXECUTE_PROCESS_IN_EC.contains(process.p2) && (mcStatus = (McStatus)(mcStatusMap = McStatus.batchGetMcStatus((Object)this.getModelId(), Collections.singletonList(entity.p1), (Object)scene.p1, (Object)year.p1, (Object)period.p1)).get(entity.p1)).getPcFlow().isSubmit()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Rpt-\u6298\u7b97\u5e01\u62a5\u8868\u5df2\u63d0\u4ea4\u6216\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u8c03\u8bd5\u3002", (String)"BizRuleExecutePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (orgParent != 0L && (mcStatus = (McStatus)(mcStatusMap = McStatus.batchGetMcStatus((Object)this.getModelId(), Collections.singletonList(orgParent), (Object)scene.p1, (Object)year.p1, (Object)period.p1)).get(orgParent)).getFlow().isSubmit()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u201cERpt-\u9ed8\u8ba4\u5e01\u62a5\u8868\u201d\u5df2\u63d0\u4ea4\u6216\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u8c03\u8bd5\u3002", (String)"BizRuleExecutePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkProcessAndCurrency(BizRuleExecParam param, String ecCurrency) {
        Pair process = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.PROCESS.getNumber());
        Pair currency = (Pair)param.getCommonParam().getParams().get(DimTypesEnum.CURRENCY.getNumber());
        if (process != null && currency != null) {
            if (!(!BizRuleConstant.ONLY_EXECUTE_PROCESS_IN_EC.contains(process.p2) || StringUtils.isNotEmpty((String)ecCurrency) && ecCurrency.equals(currency.p2))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u8fc7\u7a0b\u4e0d\u5141\u8bb8\u5728\u975e\u672c\u4f4d\u5e01\u5e01\u79cd\u4e0a\u6267\u884c\u89c4\u5219\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BizRuleExecutePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (BizRuleConstant.NO_EXECUTE_PROCESS_IN_EC.contains(process.p2) && StringUtils.isNotEmpty((String)ecCurrency) && ecCurrency.equals(currency.p2)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u8fc7\u7a0b\u4e0d\u5141\u8bb8\u5728\u672c\u4f4d\u5e01\u5e01\u79cd\u4e0a\u6267\u884c\u89c4\u5219\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BizRuleExecutePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String alloprocess;
        super.afterCreateNewData(e);
        String modelId = (String)this.getFormCustomParam("KEY_MODEL_ID");
        QFilter filter1 = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        QFilter filter2 = new QFilter("modifier", "=", (Object)Long.parseLong(RequestContext.get().getUserId()));
        QFilter filter3 = new QFilter("formid", "=", (Object)"bcm_bizruleexecuteform");
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_userselect", (String)"entity, scenario, year, period, currency", (QFilter[])new QFilter[]{filter1, filter2, filter3});
        if (obj != null) {
            for (String key : keys) {
                if ("process".equals(key) || obj.getLong(key) == 0L) continue;
                this.getModel().setValue(key, obj.get(key));
            }
        }
        if (StringUtils.isNotEmpty((String)(alloprocess = (String)this.getFormCustomParam("alloprocessid")))) {
            String[] processsids = alloprocess.split(",");
            this.getModel().setValue("process", (Object)processsids[0]);
        }
    }

    private void saveUserSelect() {
        UserSelectModel userSelectModel = new UserSelectModel();
        userSelectModel.setOrg(UserSelectUtil.getF7SelectId(this.getView(), "entity"));
        userSelectModel.setScene(UserSelectUtil.getF7SelectId(this.getView(), "scenario"));
        userSelectModel.setYear(UserSelectUtil.getF7SelectId(this.getView(), "year"));
        userSelectModel.setPeriod(UserSelectUtil.getF7SelectId(this.getView(), "period"));
        userSelectModel.setCurrency(UserSelectUtil.getF7SelectId(this.getView(), "currency"));
        userSelectModel.setModel((String)this.getFormCustomParam("KEY_MODEL_ID"));
        userSelectModel.setApplication(ApplicationTypeEnum.CM);
        userSelectModel.setOnlyModel(false);
        userSelectModel.setModifier(RequestContext.get().getUserId());
        userSelectModel.setFormid("bcm_bizruleexecuteform");
        UserSelectUtil.savetUserSelect(userSelectModel);
    }

    private Map<String, Pair<String, Long>> getParams() {
        HashMap<String, Pair<String, Long>> map = new HashMap<String, Pair<String, Long>>();
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        map.put("entity", this.getNullOrNumber(entity));
        if (ApplicationTypeEnum.isEBOrBGMDOrBGBDOrBGM((ApplicationTypeEnum)ModelUtil.queryApp(this.getView()))) {
            map.put("scenario", Pair.onePair((Object)"NoScenario", (Object)0L));
        } else {
            DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
            map.put("scenario", this.getNullOrNumber(scenario));
        }
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        map.put("year", this.getNullOrNumber(year));
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        map.put("period", this.getNullOrNumber(period));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        map.put("currency", this.getNullOrNumber(currency));
        DynamicObject process = (DynamicObject)this.getModel().getValue("process");
        map.put("process", this.getNullOrNumber(process));
        return map;
    }

    private Pair<String, Long> getNullOrNumber(DynamicObject object) {
        return object == null ? Pair.onePair(null, (Object)0L) : Pair.onePair((Object)object.getString("number"), (Object)object.getLong("id"));
    }
}

